-----------------------------------
-- Regal Footprint
-----------------------------------
require("modules/module_utils")
local wew_unlocks = require("modules/catseyexi/lua/additive_overrides/utils/wew_unlocks")
-----------------------------------
local m = Module:new("wew_wardrobe_unlocks")

m:addOverride("xi.zones.Lower_Jeuno.npcs.Treasure_Coffer.onEventFinish", function(player, csid, option, npc)
    -- Gives one W5 slot to WEW players every X repeatable key item turn-in
    local repeatableReward = false
    local freeSlots = player:getFreeSlotsCount()
    if
        player:isClassicMode() and
        csid == 10099 and
        option >= 1 and
        option <= 20
    then
        repeatableReward = true
    end

    super(player, csid, option, npc)

    local bag = xi.inv.WARDROBE5
    if
        repeatableReward and
        freeSlots ~= player:getFreeSlotsCount()
    then
        -- reward was successfully rewarded
        local currSize = player:getContainerSize(bag)
        if currSize < 80 then
            local successfulRedemptions = player:getCharVar('[WEW]Wardrobe5') + 1
            player:setCharVar('[WEW]Wardrobe5', successfulRedemptions)
            if successfulRedemptions % 3 == 0 then
                local str = string.format(
                    "\129\154 Your %s capacity has been increased by %i from %i to %i! \129\154",
                    "Mog Wardrobe 5", 1, currSize, currSize + 1)

                player:printToPlayer(str, xi.msg.channel.SYSTEM_3)
                player:changeContainerSize(bag, 1)
            end
        end
    end

    local currSize = player:getContainerSize(bag)
    if
        player:isClassicMode() and
        currSize < 80
    then
            -- check for missing mission slots
        local total = math.floor(player:getCharVar('[WEW]Wardrobe5') / 3)
        for log_id = xi.mission.log_id.ACP, xi.mission.log_id.ASA do
            for mission, slots in pairs(wew_unlocks.wardrobeMissions[log_id]) do
                if player:hasCompletedMission(log_id, mission) then
                    -- slots[1] is the wardrobe, which we already know to be W5
                    total = total + slots[2]
                end
            end
        end

        if total > currSize then
            local newSize = utils.clamp(total, 0, 80)
            local str = string.format(
                "\129\154 Your %s capacity has been increased by %i from %i to %i! \129\154",
                "Mog Wardrobe 5", newSize - currSize, currSize, newSize)

            player:printToPlayer(str, xi.msg.channel.SYSTEM_3)
            player:changeContainerSize(bag, newSize - currSize)
        end
    end
end)

-- WEW-only wardrobe 6 per 10 skillups in any synth-based craft
-- full loop if wardrobe 6 is empty to catchup existing WEW players
-- otherwise do a full loop (check every skill) every 10 levels
m:addOverride("xi.player.onPlayerSkillUp", function(player, skillID, origLevel, skillUpAmount)
    super(player, skillID, origLevel, skillUpAmount)

    local bag = xi.inv.WARDROBE6
    local currSize = player:getContainerSize(bag)
    if
        not player:isClassicMode() or
        (currSize > 0 and
        math.floor(player:getCharSkillLevel(skillID)) / 100 == math.floor(origLevel / 100)) or
        skillID < xi.skill.WOODWORKING or
        skillID > xi.skill.COOKING
    then
        return
    end

    local total = 0
    for i = xi.skill.WOODWORKING, xi.skill.COOKING do
        total = total + 5 * math.floor(player:getCharSkillLevel(i) / 100)
    end

    if
        total > currSize and
        currSize < 80
    then
        local newSize = utils.clamp(total, 0, 80)
        local str = string.format(
            "\129\154 Your %s capacity has been increased by %i from %i to %i! \129\154",
            "Mog Wardrobe 6", newSize - currSize, currSize, newSize)

        player:printToPlayer(str, xi.msg.channel.SYSTEM_3)
        player:changeContainerSize(bag, newSize - currSize)
    end
end)

return m
