-----------------------------------
-- Regal Footprint
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("wew_perks")

-- TH+1 for each of the main items from AWR: Talaria and Tartarus Platemail
-- excludes thf as main or subjob
-- Deprecated to go a different route with giving TH to WEW players. Leaving here for posterity
local NEVERadjustTH = function(player)
    local thBonus = 0

    if
        player:getMainJob() == xi.job.THF or -- until we can sort out TH++ not scaling linearly
        player:getSubJob() == xi.job.THF or
        player:getMainJob() == xi.job.BLU or -- until we can sort out Trait recalc updating this
        player:getSubJob() == xi.job.BLU
    then
        thBonus = 0
    elseif player:hasItem(26944) then -- Tartarus Platemail
        thBonus = 2
    elseif player:hasItem(11403) then -- Talaria
        thBonus = 1
    end

    if thBonus > 0 then
        local traitID = 19
        local traitTier = 1
        print(string.format("Giving %s TH+%u", player:getName(), thBonus))
        player:addJobTrait(traitID, traitTier, xi.mod.TREASURE_HUNTER, thBonus, 0)
    end
end

m:addOverride("xi.player.onGameIn", function(player, firstLogin, zoning)
    super(player, firstLogin, zoning)

    if player:isClassicMode() then
        -- Give gil based on xp gained from monsters (similar to book xp)
        player:addListener("EXPERIENCE_POINTS", "WEW_EXP_GIL", function(player, mob, exp)
            local gilLimit = 500000 + player:getCharVar('[WEW]WEEKLY_GIL_MAX_INCREASE')
            local gilMultiplier = 1 + player:getCharVar('[WEW]WEEKLY_GIL_MULTIPLIER') / 100
            local currentGil = player:getCharVar('[WEW]WEEKLY_GIL_FROM_EXP')
            local gilFromEXP = math.floor(exp * gilMultiplier)

            -- Hasn't met the weekly cap, award gil and print report if first time gaining exp in zone
            if currentGil + gilFromEXP < gilLimit then
                local ID = zones[player:getZoneID()]
                player:setCharVar('[WEW]WEEKLY_GIL_FROM_EXP', currentGil + gilFromEXP, NextConquestTally())
                player:addGil(gilFromEXP)
                player:messageSpecial(ID.text.GIL_OBTAINED, gilFromEXP)

                if player:getLocalVar('[WEW]WEEKLY_GIL_REPORTED') ~= 1 then
                    player:setLocalVar('[WEW]WEEKLY_GIL_REPORTED', 1)
                    player:timer(500, function(playerArg)
                        playerArg:sys('Weekly exp-to-gil multiplier: ({}) and remaining gil: ({}K)',
                            gilMultiplier,
                            math.floor(math.max(0, gilLimit - currentGil - gilFromEXP) / 1000)
                        )
                    end)
                end
            end
        end)
    end
end)

-- Tartarus Platemail latent
m:addOverride('xi.effects.quickening.onEffectGain', function(target, effect)
    super(target, effect)

    if target:isClassicMode() then
        effect:setTick(3000)
    else
        effect:setTick(0) -- more efficient to not run the below code at all
    end
end)

local effectCounterVar = '[QUICKENING]effectCounter'
local effectCounterThresh = 5
local resetCounter = function(player)
    if player:getLocalVar(effectCounterVar) > effectCounterThresh then
        player:sys('The glow from your Tartarus Platemail fades')
    end

    player:setLocalVar(effectCounterVar, 0)
end

m:addOverride('xi.effects.quickening.onEffectLose', function(target, effect)
    super(target, effect)

    resetCounter(target)
end)

-- provides hp/mp recovery when wew is exploring (not involved in combat or taking any actions)
m:addOverride('xi.effects.quickening.onEffectTick', function(target, effect)
    super(target, effect)

    local bodyEquip = target:isPC() and target:getEquippedItem(xi.slot.BODY) or nil
    if bodyEquip == nil or bodyEquip:getID() ~= xi.item.TARTARUS_PLATEMAIL then
        resetCounter(target)

        return
    end

    local currAnimation = target:getAnimation()
    local currAction = target:getCurrentAction()
    if
        (currAnimation ~= xi.animation.HEALING and
        currAnimation ~= xi.animation.NONE) or
        currAction ~= xi.action.ROAMING
    then
        resetCounter(target)

        return
    end

    -- localvar can't store negative values
    local currentX = math.abs(target:getXPos()) * 1000
    local lastX    = target:getLocalVar('[QUICKENING]LastXPos')
    target:setLocalVar('[QUICKENING]LastXPos', currentX)

    local currentZ = math.abs(target:getZPos()) * 1000
    local lastZ    = target:getLocalVar('[QUICKENING]LastZPos')
    target:setLocalVar('[QUICKENING]LastZPos', currentZ)

    -- hp/mp recovery percent of max
    local percentRecovery = 0
    if
        math.abs(currentX - lastX) >= 2 or
        math.abs(currentZ - lastZ) >= 2
    then
        -- moving
        percentRecovery = 3
    elseif currAnimation == xi.animation.HEALING then
        percentRecovery = 2
    elseif currAnimation == xi.animation.NONE then
        percentRecovery = .1
    end

    -- if conditions not met to get recovery, reset counter
    if percentRecovery == 0 then
        resetCounter(target)

        return
    end

    local effectCounter = target:getLocalVar(effectCounterVar)

    if effectCounter < effectCounterThresh then
        target:setLocalVar(effectCounterVar, effectCounter + 1)

        return
    else
        -- all base conditions are met, reset counter if anyone in player's alliance is engaged in combat
        local party = target:getAlliance()
        if party == nil then
            party = target
        end


        for _, member in pairs(party) do
            if
                member:getZoneID() == target:getZoneID() and
                member:getAnimation() == xi.animation.ATTACK
            then
                resetCounter(target)

                return
            end
        end

        if effectCounter == effectCounterThresh then
            target:sys('Your Tartarus Platemail begins to glow')
            target:setLocalVar(effectCounterVar, effectCounter + 1)
        end
    end

    -- print(percentRecovery)
    target:addMP(math.ceil(target:getMaxMP() * percentRecovery / 100))
    target:addHP(math.ceil(target:getMaxHP() * percentRecovery / 100))
end)

return m
