-----------------------------------
-- Trust restrictions by char type
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("exp_buff_restrictions")

local vars =
{
    CW_TRUST = "[CW]TRUST",
}

-- Limit Crystal Warrior to 2 trusts (5 in DI)
-- Limited Classic Mode to 0 trusts (0 in DI)
m:addOverride("xi.trust.canCast", function(caster, spell, notAllowedTrustIds)
    if caster:isClassicMode() then
        caster:messageSystem(xi.msg.system.TRUST_MAXIMUM_NUMBER)
        return -1
    end

    -- Cannot summon trusts during campaign battles
    if caster:hasStatusEffect(xi.effect.ALLIED_TAGS) then
        caster:messageSystem(xi.msg.system.TRUST_MAXIMUM_NUMBER)
        return -1
    end

    if not caster:isCrystalWarrior() then
        return super(caster, spell, notAllowedTrustIds)
    end

    local numTrusts = 0
    local party     = caster:getPartyWithTrusts()

    for _, member in pairs(party) do
        if member:getObjType() == xi.objType.TRUST then
            numTrusts = numTrusts + 1
        end
    end

    if
        numTrusts >= caster:getCharVar(vars.CW_TRUST) or
        (numTrusts == 0 and caster:getMainLvl() < 10) or -- Only allow 1 trust if level 10+
        (numTrusts == 1 and caster:getMainLvl() < 40)    -- Only allow additional trust if level 40+
    then
        caster:messageSystem(xi.msg.system.TRUST_MAXIMUM_NUMBER)
        return -1
    else
        return super(caster, spell, notAllowedTrustIds)
    end
end)

return m
