-----------------------------------
-- Login Campaign by char type
-----------------------------------
require("modules/module_utils")
require("scripts/events/login_campaign")
require('scripts/globals/appraisal')
-----------------------------------
local m = Module:new("login_campaign")


-----------------------------------
-- Wings Era Login Campaign Items
-----------------------------------
local loginItems =
{
    { "Tidal Talisman",         11290, 4000 }, -- tidal_talisman
    { "Nomad Cap",              16119, 4000 }, -- Nomad cap
    { "Custom Gilet +1",        11273, 4000 }, -- hq swim top
    { "Custom Top +1",          11274, 4000 }, -- hq swim top
    { "Magna Gilet +1",         11275, 4000 }, -- hq swim top
    { "Magna Top +1",           11276, 4000 }, -- hq swim top
    { "Wonder Maillot +1",      11277, 4000 }, -- hq swim top
    { "Wonder Top +1",          11278, 4000 }, -- hq swim top
    { "Savage Top +1",          11279, 4000 }, -- hq swim top
    { "Elder Gilet +1",         11280, 4000 }, -- hq swim top
    { "Behe Statue",            266,   500, }, -- Behe Statue
    { "Dinner Jacket",          11355, 500, }, -- Dinner Jacket
--  { "Hoe",                    20909, 500, }, -- Hoe -- Special Ventures (Harvesting)
    { "Chocobo Shield",         10811, 500, }, -- Chocobo shield
    { "Dinner Hose",            16378, 500, }, -- Dinner Hose
--    { "Caver's Shovel",         18600, 500, }, -- Caver's Shovel -- DAT modded on CEXI
    { "Harpsichord",            320,   500, }, -- Harpsichord
    { "Aldebaran",              415,   500, }, -- Aldebaran
    { "Chocobo Knife II",       20577, 500, }, -- Chocobo Knife II
    { "Starlet Jabot",          26975, 500, }, -- starlet_jabot
    { "Himegami Yukata",        11862, 500, }, -- himegami_yukata
    { "Pupils Shirt",           26946, 500, }, -- pupils_shirt
    { "Novennial Thigh Boots",  11957, 500, }, -- novennial_thigh_boots
    { "Redeyes",                16120, 500, }, -- redeyes
    { "Goblin Suit",            27866, 500, }, -- goblin_suit
    { "Overalls",               27879, 500, }, -- overalls
    { "Excalipoor",             20713, 500, }, -- excalipoor
    { "Councilors Garb",        27923, 500, }, -- councilors_garb
    { "Wyrmking Suit",          25756, 500, }, -- wyrmking_suit
    { "Ark Sword",              18913, 500, }, -- ark_sword
    { "Onion Sword II",         21608, 500, }, -- onion_sword_ii
    { "Cait Sith Cap",          26717, 500, }, -- cait_sith_cap
    { "Blizzard Brand",         20666, 500, }, -- blizzard_brand
    { "Custom Shorts",          16322, 500, }, -- custom_shorts
--  { "Worm Feelers",           20532, 500, }, -- worm_feelers -- Special Ventures (Mining)
    { "Worm Masque",            27717, 500, }, -- worm_masque
    { "Snow Bunny Hat",         11490, 500, }, -- snow_bunny_hat
    { "Cait Sith Guard",        27631, 500, }, -- cait_sith_guard
--    { "Decazoom Mk-XI",         21280, 500, }, -- decazoom_mk-xi -- Refer-a-friend reward
    { "Slime Shield",           28655, 500, }, -- slime_shield
    { "Lamia Staff",            22072, 500, }, -- lamia_staff
    { "Ark Saber",              18912, 500, }, -- ark_saber
    { "Botulus Suit",           25711, 500, }, -- botulus_suit
    { "Aern Dagger",            20573, 500, }, -- aern_dagger
    { "Novennial Coat",         11853, 500, }, -- novennial_coat
    { "Novennial Dress",        11854, 500, }, -- novennial_dress
    { "Hapy Staff",             22069, 500, }, -- hapy_staff
    { "Chobobo Masque",        xi.item.CHOCOBO_MASQUE,    500 },
    { "Chocobo Suit",        xi.item.CHOCOBO_SUIT,      500 },
    { "Mandragora Masque",        xi.item.MANDRAGORA_MASQUE, 500 },
    { "Mandragora Suit",        xi.item.MANDRAGORA_SUIT,   500 },
}

-----------------------------------
-- Crystal Warrior Restrictions
-----------------------------------
local message =
{
    LOGIN_REWARD = "You cannot claim login rewards as a Crystal Warrior.",
}

-- Restrict Login Points (Accumulation)
m:addOverride("xi.events.loginCampaign.onGameIn", function(player)
    if not player:isCrystalWarrior() then
        super(player)
    end
end)

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local itemAppraisal =
{
    {   -- Floor 20
        { xi.item.UNAPPRAISED_AXE,      xi.appraisal.origin.NYZUL_BAT_EYE                },
        { xi.item.UNAPPRAISED_NECKLACE, xi.appraisal.origin.NYZUL_SHADOW_EYE             },
        { xi.item.UNAPPRAISED_RING,     xi.appraisal.origin.NYZUL_BOMB_KING              },
        { xi.item.UNAPPRAISED_POLEARM,  xi.appraisal.origin.NYZUL_JUGGLER_HECATOMB       },
        { xi.item.UNAPPRAISED_RING,     xi.appraisal.origin.NYZUL_SMOTHERING_SCHMIDT     },
        { xi.item.UNAPPRAISED_POLEARM,  xi.appraisal.origin.NYZUL_HELLION                },
        { xi.item.UNAPPRAISED_FOOTWEAR, xi.appraisal.origin.NYZUL_LEAPING_LIZZY          },
        { xi.item.UNAPPRAISED_DAGGER,   xi.appraisal.origin.NYZUL_TOM_TIT_TAT            },
        { xi.item.UNAPPRAISED_NECKLACE, xi.appraisal.origin.NYZUL_JAGGEDY_EARED_JACK     },
        { xi.item.UNAPPRAISED_FOOTWEAR, xi.appraisal.origin.NYZUL_CACTUAR_CANTAUTOR      },
        { xi.item.UNAPPRAISED_NECKLACE, xi.appraisal.origin.NYZUL_GARGANTUA              },
        { xi.item.UNAPPRAISED_BOW,      xi.appraisal.origin.NYZUL_GYRE_CARLIN            },
        { xi.item.UNAPPRAISED_RING,     xi.appraisal.origin.NYZUL_ASPHYXIATED_AMSEL      },
        { xi.item.UNAPPRAISED_SWORD,    xi.appraisal.origin.NYZUL_FROSTMANE              },
        { xi.item.UNAPPRAISED_GLOVES,   xi.appraisal.origin.NYZUL_PEALLAIDH              },
        { xi.item.UNAPPRAISED_SWORD,    xi.appraisal.origin.NYZUL_CARNERO                },
        { xi.item.UNAPPRAISED_POLEARM,  xi.appraisal.origin.NYZUL_FALCATUS_ARANEI        },
        { xi.item.UNAPPRAISED_SWORD,    xi.appraisal.origin.NYZUL_EMERGENT_ELM           },
    },
    {   -- Floor 40
        { xi.item.UNAPPRAISED_CAPE,      xi.appraisal.origin.NYZUL_OLD_TWO_WINGS         },
        { xi.item.UNAPPRAISED_BOX,       xi.appraisal.origin.NYZUL_AIATAR                },
        { xi.item.UNAPPRAISED_BOX,       xi.appraisal.origin.NYZUL_INTULO                },
        { xi.item.UNAPPRAISED_DAGGER,    xi.appraisal.origin.NYZUL_ORCTRAP               },
        { xi.item.UNAPPRAISED_HEADPIECE, xi.appraisal.origin.NYZUL_VALKURM_EMPEROR       },
        { xi.item.UNAPPRAISED_RING,      xi.appraisal.origin.NYZUL_CRUSHED_KRAUSE        },
        { xi.item.UNAPPRAISED_DAGGER,    xi.appraisal.origin.NYZUL_STINGING_SOPHIE       },
        { xi.item.UNAPPRAISED_NECKLACE,  xi.appraisal.origin.NYZUL_SERPOPARD_ISHTAR      },
        { xi.item.UNAPPRAISED_DAGGER,    xi.appraisal.origin.NYZUL_WESTERN_SHADOW        },
        { xi.item.UNAPPRAISED_SHIELD,    xi.appraisal.origin.NYZUL_BLOODTEAR_BALDURF     },
        { xi.item.UNAPPRAISED_SWORD,     xi.appraisal.origin.NYZUL_ZIZZY_ZILLAH          },
        { xi.item.UNAPPRAISED_HEADPIECE, xi.appraisal.origin.NYZUL_ELLYLLON              },
        { xi.item.UNAPPRAISED_DAGGER,    xi.appraisal.origin.NYZUL_MISCHIEVOUS_MICHOLAS  },
        { xi.item.UNAPPRAISED_EARRING,   xi.appraisal.origin.NYZUL_LEECH_KING            },
        { xi.item.UNAPPRAISED_BOW,       xi.appraisal.origin.NYZUL_EASTERN_SHADOW        },
        { xi.item.UNAPPRAISED_POLEARM,   xi.appraisal.origin.NYZUL_NUNYENUNC             },
        { xi.item.UNAPPRAISED_BOW,       xi.appraisal.origin.NYZUL_HELLDIVER             },
        { xi.item.UNAPPRAISED_HEADPIECE, xi.appraisal.origin.NYZUL_TAISAIJIN             },
    },
    {   -- Floor 60
        { xi.item.UNAPPRAISED_SHIELD,    xi.appraisal.origin.NYZUL_FUNGUS_BEETLE         },
        { xi.item.UNAPPRAISED_BOX,       xi.appraisal.origin.NYZUL_FRIAR_RUSH            },
        { xi.item.UNAPPRAISED_RING,      xi.appraisal.origin.NYZUL_PULVERIZED_PFEFFER    },
        { xi.item.UNAPPRAISED_NECKLACE,  xi.appraisal.origin.NYZUL_ARGUS                 },
        { xi.item.UNAPPRAISED_NECKLACE,  xi.appraisal.origin.NYZUL_BLOODPOOL_VORAX       },
        { xi.item.UNAPPRAISED_DAGGER,    xi.appraisal.origin.NYZUL_NIGHTMARE_VASE        },
        { xi.item.UNAPPRAISED_DAGGER,    xi.appraisal.origin.NYZUL_DAGGERCLAW_DRACOS     },
        { xi.item.UNAPPRAISED_AXE,       xi.appraisal.origin.NYZUL_NORTHERN_SHADOW       },
        { xi.item.UNAPPRAISED_CAPE,      xi.appraisal.origin.NYZUL_FRAELISSA             },
        { xi.item.UNAPPRAISED_POLEARM,   xi.appraisal.origin.NYZUL_ROC                   },
        { xi.item.UNAPPRAISED_BOX,       xi.appraisal.origin.NYZUL_SABOTENDER_BAILARIN   },
        { xi.item.UNAPPRAISED_AXE,       xi.appraisal.origin.NYZUL_AQUARIUS              },
        { xi.item.UNAPPRAISED_GLOVES,    xi.appraisal.origin.NYZUL_ENERGETIC_ERUCA       },
        { xi.item.UNAPPRAISED_CAPE,      xi.appraisal.origin.NYZUL_SPINY_SPIPI           },
        { xi.item.UNAPPRAISED_AXE,       xi.appraisal.origin.NYZUL_TRICKSTER_KINETIX     },
        { xi.item.UNAPPRAISED_HEADPIECE, xi.appraisal.origin.NYZUL_DROOLING_DAISY        },
        { xi.item.UNAPPRAISED_FOOTWEAR,  xi.appraisal.origin.NYZUL_BONNACON              },
        { xi.item.UNAPPRAISED_HEADPIECE, xi.appraisal.origin.NYZUL_TAISAIJIN             },
    },
    {   -- Floor 80
        { xi.item.UNAPPRAISED_CAPE,      xi.appraisal.origin.NYZUL_GOLDEN_BAT            },
        { xi.item.UNAPPRAISED_SHIELD,    xi.appraisal.origin.NYZUL_STEELFLEECE_BALDARICH },
        { xi.item.UNAPPRAISED_DAGGER,    xi.appraisal.origin.NYZUL_SABOTENDER_MARIACHI   },
        { xi.item.UNAPPRAISED_BOW,       xi.appraisal.origin.NYZUL_UNGUR                 },
        { xi.item.UNAPPRAISED_POLEARM,   xi.appraisal.origin.NYZUL_SWAMFISK              },
        { xi.item.UNAPPRAISED_NECKLACE,  xi.appraisal.origin.NYZUL_BUBURIMBOO            },
        { xi.item.UNAPPRAISED_SWORD,     xi.appraisal.origin.NYZUL_KEEPER_OF_HALIDOM     },
        { xi.item.UNAPPRAISED_RING,      xi.appraisal.origin.NYZUL_SERKET                },
        { xi.item.UNAPPRAISED_NECKLACE,  xi.appraisal.origin.NYZUL_DUNE_WIDOW            },
        { xi.item.UNAPPRAISED_BOX,       xi.appraisal.origin.NYZUL_ODQAN                 },
        { xi.item.UNAPPRAISED_RING,      xi.appraisal.origin.NYZUL_BURNED_BERGMANN       },
        { xi.item.UNAPPRAISED_DAGGER,    xi.appraisal.origin.NYZUL_TOM_TIT_TAT           },
        { xi.item.UNAPPRAISED_AXE,       xi.appraisal.origin.NYZUL_TYRANNIC_TUNNOK       },
        { xi.item.UNAPPRAISED_RING,      xi.appraisal.origin.NYZUL_BLOODSUCKER           },
        { xi.item.UNAPPRAISED_FOOTWEAR,  xi.appraisal.origin.NYZUL_TOTTERING_TOBY        },
        { xi.item.UNAPPRAISED_SHIELD,    xi.appraisal.origin.NYZUL_SOUTHERN_SHADOW       },
        { xi.item.UNAPPRAISED_HEADPIECE, xi.appraisal.origin.NYZUL_SHARP_EARED_ROPIPI    },
        { xi.item.UNAPPRAISED_HEADPIECE, xi.appraisal.origin.NYZUL_TAISAIJIN             },
    },
    {   -- Floor 100
        { xi.item.UNAPPRAISED_AXE,       xi.appraisal.origin.NYZUL_PANZER_PERCIVAL       },
        { xi.item.UNAPPRAISED_POLEARM,   xi.appraisal.origin.NYZUL_VOUIVRE               },
        { xi.item.UNAPPRAISED_SASH,      xi.appraisal.origin.NYZUL_JOLLY_GREEN           },
        { xi.item.UNAPPRAISED_HEADPIECE, xi.appraisal.origin.NYZUL_TUMBLING_TRUFFLE      },
        { xi.item.UNAPPRAISED_EARRING,   xi.appraisal.origin.NYZUL_CAPRICIOUS_CASSIE     },
        { xi.item.UNAPPRAISED_SWORD,     xi.appraisal.origin.NYZUL_AMIKIRI               },
        { xi.item.UNAPPRAISED_BOX,       xi.appraisal.origin.NYZUL_STRAY_MARY            },
        { xi.item.UNAPPRAISED_RING,      xi.appraisal.origin.NYZUL_SEWER_SYRUP           },
        { xi.item.UNAPPRAISED_BOX,       xi.appraisal.origin.NYZUL_UNUT                  },
        { xi.item.UNAPPRAISED_FOOTWEAR,  xi.appraisal.origin.NYZUL_SIMURGH               },
        { xi.item.UNAPPRAISED_SHIELD,    xi.appraisal.origin.NYZUL_PELICAN               },
        { xi.item.UNAPPRAISED_SWORD,     xi.appraisal.origin.NYZUL_CARGO_CRAB_COLIN      },
        { xi.item.UNAPPRAISED_RING,      xi.appraisal.origin.NYZUL_WOUNDED_WURFEL        },
        { xi.item.UNAPPRAISED_AXE,       xi.appraisal.origin.NYZUL_PEG_POWLER            },
        { xi.item.UNAPPRAISED_DAGGER,    xi.appraisal.origin.NYZUL_TOM_TIT_TAT           },
        { xi.item.UNAPPRAISED_BOX,       xi.appraisal.origin.NYZUL_JADED_JODY            },
        { xi.item.UNAPPRAISED_EARRING,   xi.appraisal.origin.NYZUL_MAIGHDEAN_UAINE       },
        { xi.item.UNAPPRAISED_HEADPIECE, xi.appraisal.origin.NYZUL_TAISAIJIN             },
    },
}

local keyItems =
{
    xi.ki.CRIMSON_KEY,
    xi.ki.VIRIDIAN_KEY,
    xi.ki.AMBER_KEY,
    xi.ki.AZURE_KEY,
    xi.ki.IVORY_KEY,
    xi.ki.EBON_KEY,
    xi.ki.WHITE_CORAL_KEY,
    xi.ki.BLUE_CORAL_KEY,
    xi.ki.PEACH_CORAL_KEY,
    xi.ki.BLACK_CORAL_KEY,
    xi.ki.RED_CORAL_KEY,
    xi.ki.ANGEL_SKIN_KEY,
    xi.ki.MOOGLE_KEY,
    xi.ki.BIRD_KEY,
    xi.ki.CACTUAR_KEY,
    xi.ki.BOMB_KEY,
    xi.ki.CHOCOBO_KEY,
    xi.ki.TONBERRY_KEY,
}

local scenarioCompleteKeyItems =
{
    xi.ki.PRISMATIC_KEY,
    xi.ki.OXBLOOD_KEY,
    xi.ki.BEHEMOTH_KEY,
}

local fireworks =
{
    { 4167, 99, }, -- cracker
    { 4168, 99, }, -- twinkle_shower
    { 4169, 99, }, -- little_comet
    { 4183, 99, }, -- konron_hassen
    { 4184, 99, }, -- kongou_inaho
    { 4185, 99, }, -- meifu_goma
    { 4186, 99, }, -- airborne
    { 4215, 99, }, -- popstar
    { 4216, 99, }, -- brilliant_snow
    { 4217, 99, }, -- sparkling_hand
    { 4218, 99, }, -- air_rider
    { 4250, 99, }, -- crackler
    { 4251, 99, }, -- festive_fan
    { 4252, 99, }, -- summer_fan
    { 4253, 99, }, -- spirit_masque
    { 4256, 99, }, -- ouka_ranman
    { 4257, 99, }, -- papillion
    { 5360, 99, }, -- muteppo
    { 5361, 99, }, -- datechochin
    { 5441, 99, }, -- angelwing
    { 5532, 99, }, -- ichinintousen_koma
    { 5725, 99, }, -- goshikitenge
    { 5769, 99, }, -- popper
    { 5881, 99, }, -- shisai_kaboku
    { 5882, 99, }, -- marine_bliss
    { 5883, 99, }, -- falling_star
    { 5884, 99, }, -- rengedama
    { 5936, 99, }, -- mog_missile
    { 5937, 99, }, -- bubble_breeze
    { 6268, 99, }, -- komanezumi
}

local rewardFunctions =
{
    ["RAND_FIREWORK"] = function(player)
        local firework = utils.shuffle(fireworks)[1]

        -- attempt to give stack of fireworks, only take login points if successful
        return npcUtil.giveItem(player, {{ firework[1], firework[2] }})
    end,
}

local function confirmPurchase(player, npc, item)
    local balance = player:getCurrency("login_points")

    if balance < item[3] then
        npc:facePlayer(player, true)
        player:printToPlayer(string.format("%s : You can't afford that.", npc:getPacketName()), xi.msg.channel.NS_SAY)
        return
    end

    delaySendMenu(player, {
        title   = string.format("Buy %s (%u)?", item[1], item[3]),
        options =
        {
            {
                "No",
                function()
                end,
            },
            {
                "Yes",
                function()
                    if type(item[2]) == "string" then
                        if rewardFunctions[item[2]](player) then
                            player:delCurrency("login_points", item[3])
                        end
                    else
                        if npcUtil.giveItem(player, item[2]) then
                            player:delCurrency("login_points", item[3])
                        end
                    end
                end,
            },
        },
    })
end

local function loginShop(player, npc)
    local balance = player:getCurrency("login_points")
    local title   = string.format("Login points (%u):", balance)
    -- randomize long list everytime, but these will always be first
    local shuffled =
    {
        { "Random Fireworks", "RAND_FIREWORK", 50, },
    }

    for _, item in pairs(utils.shuffle(loginItems)) do
        table.insert(shuffled, item)
    end

    npc:facePlayer(player, true)
    cexi.util.simpleShop(player, npc, shuffled, confirmPurchase, title)
end

local function buyAppraisalItem(player, npc, cost)
    local nyzulFloorProgress = player:getCharVar("NyzulFloorProgress")

    if nyzulFloorProgress < 20 then
        npc:facePlayer(player, true)
        player:printToPlayer("Greeter Moogle : I can't sell you this until you reach floor 20 in Nyzul Isle!", xi.msg.channel.NS_SAY)

        return
    end

    local floorRange      = math.random(1, math.floor(nyzulFloorProgress / 20))
    local unappraisedItem = itemAppraisal[floorRange][math.random(1, #itemAppraisal[floorRange])]

    if player:getFreeSlotsCount() == 0 then
        player:messageSpecial(zones[player:getZoneID()].text.ITEM_CANNOT_BE_OBTAINED, unappraisedItem[1])

        return
    else
        player:addItem({ id = unappraisedItem[1], appraisal = unappraisedItem[2] })
        player:delCurrency("login_points", cost)
        player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, unappraisedItem[1])

        return
    end

    npc:facePlayer(player, true)
    player:printToPlayer("Greeter Moogle : Kupo~o! You can't carry all of that!", xi.msg.channel.NS_SAY)
end

local function buyKeyItem(player, npc, cost)
    local shuffled = nil
    if cost < 500 then
        shuffled = utils.shuffle(keyItems)
    else
        shuffled = utils.shuffle(scenarioCompleteKeyItems)
    end

    for _, keyItem in pairs(shuffled) do
        if not player:hasKeyItem(keyItem) then
            npcUtil.giveKeyItem(player, keyItem)
            player:delCurrency("login_points", cost)

            return
        end
    end

    npc:facePlayer(player, true)
    player:printToPlayer("Greeter Moogle : K~upo~o! You already have every key I could possibly give you!", xi.msg.channel.NS_SAY)
end

local function confirmPurchase(player, npc, cost, func)
    local balance = player:getCurrency("login_points")

    if balance < cost then
        npc:facePlayer(player, true)
        player:printToPlayer("Greeter Moogle : Hmm... You don't have enough points.", xi.msg.channel.NS_SAY)

        return
    end

    delaySendMenu(player, {
        title   = string.format("Buy for %u points?", cost),
        options =
        {
            {
                "No",
                function()
                end,
            },
            {
                "Yes",
                function()
                    func(player, npc, cost)
                end,
            }
        },
    })
end

-- TODO: Need Yes/No confirmation and check balance
local function classicOnTrigger(player, npc)
    local balance = player:getCurrency("login_points")

    npc:facePlayer(player, true)

    delaySendMenu(player, {
        title   = string.format("Login points (%u):", balance),
        options =
        {
            {
                "Nothing",
                function()
                end,
            },
            {
                "Various Items",
                function()
                    loginShop(player, npc)
                end,
            },
            {
                "Nyzul ??? Item (200)",
                function()
                    confirmPurchase(player, npc, 200, buyAppraisalItem)
                end,
            },
            {
                "Add-on mission Key (300)",
                function()
                    confirmPurchase(player, npc, 300, buyKeyItem)
                end,
            },
            {
                "Add-on complete Key (1500)",
                function()
                    confirmPurchase(player, npc, 1500, buyKeyItem)
                end,
            },
        },
    })
end

local greeters =
{
    "Windurst_Walls",
    "Port_San_dOria",
    "Port_Bastok",
    -- "Chocobo_Circuit", -- Is this implemented?
}

for _, zoneName in pairs(greeters) do
    m:addOverride(string.format("xi.zones.%s.npcs.Greeter_Moogle.onTrigger", zoneName), function(player, npc)
        if player:isClassicMode() then
            classicOnTrigger(player, npc)
        else
            super(player, npc)
        end
    end)
end

-- Restrict Login Points (Rewards)
m:addOverride("xi.events.loginCampaign.onTrigger", function(player, csid)
    if player:isClassicMode() then
        return -- Should be caught above
    elseif player:isCrystalWarrior() then
        player:printToPlayer(message.LOGIN_REWARD, xi.msg.channel.SYSTEM_3)
    else
        super(player, csid)
    end
end)

-- Generic library moogle
-- Greeter Moogle
-- Ephemeral Moogle
cexi.util.liveReload(m, {
    ["Celennia_Memorial_Library"] =
    {
        {
            name      = "Moogle X",
            objtype   = xi.objType.NPC,
            look      = 2419,
            x         = -107.760,
            y         = -2.150,
            z         = -84.604,
            rotation  = 51,
            onTrigger = function(player, npc)
                            player:sys('Moogle X : Trade crystals to store at my cousin, the Ephemeral Moogle.')
                            classicOnTrigger(player, npc)
                        end,
            onTrade   = function(player, npc, trade)
                            -- if you don't trigger a valid tradeEvent, the function will fail and not consume the crystals
                            local tradeEvent   = 23
                            local failEvent    = 27
                            xi.ephemeral.onTrade(player, trade, tradeEvent, failEvent)
                            player:sys('Moogle X : Any crystals in the trade are sent off to my cousin, the Ephemeral Moogle!')

                            player:confirmTrade()
                        end,
            onEventUpdate = function(player)
                            xi.ephemeral.onEventUpdate(player)
                        end,
        }
    }
})

return m
