----------------------------------------------------
-- Handles Level Caps by char type
----------------------------------------------------
require("modules/module_utils")
require("scripts/globals/player")
-----------------------------------
local m = Module:new("level_capped_areas")

-- Level Cap "Chains of Promathia" Areas
local levelCaps =
{
    ["Promyvion-Dem"]      = 30,
    ["Promyvion-Mea"]      = 30,
    ["Promyvion-Holla"]    = 30,
    ["Phomiuna_Aqueducts"] = 40,
    ["Riverne-Site_A01"]   = 40,
    ["Riverne-Site_B01"]   = 50,
    ["Sacrarium"]          = 50,
    ["Promyvion-Vahzl"]    = 50,
}

local function applyLevelCap(player, levelCap)
    player:addStatusEffectEx(
        xi.effect.LEVEL_RESTRICTION,
        xi.effect.LEVEL_RESTRICTION,
        levelCap,
        0,
        0,
        0,
        0,
        0,
        xi.effectFlag.ON_ZONE
    )
end

local function checkLevelCap(player, levelCap)
    if
        player:isCrystalWarrior() or
        player:isClassicMode()
    then
        applyLevelCap(player, levelCap)

    -- If QoL has Classic Mode player, apply level cap
    else
        local party = player:getParty()

        for _, member in pairs(party) do
            if member:isClassicMode() then
                applyLevelCap(player, levelCap)
                return
            end
        end
    end
end

for zoneName, levelCap in pairs(levelCaps) do
    m:addOverride(string.format("xi.zones.%s.Zone.afterZoneIn", zoneName), function(player)
        super(player)
        checkLevelCap(player, levelCap)
    end)
end

-- Level Cap Pso'Xja (FULL OVERRIDE)
m:addOverride("xi.zones.Beaucedine_Glacier.npcs.Iron_Grate.onEventFinish", function(player, csid, option)
    local lvlCap = 0

    if option == 1 then
        if csid == 200 then     -- 50 Cap Area
            lvlCap = 50
            player:setPos(396, -8, -20, 125, 9)
        elseif csid == 201 then -- 60 Cap Area
            lvlCap = 60
            player:setPos(220, -8, -282, 66, 9)
        elseif csid == 202 then -- No Cap Area
            player:setPos(180, -8, 241, 190, 9)
        elseif csid == 203 then -- No Cap Area
            player:setPos(-242, 8, -259, 126, 9)
        elseif csid == 204 then -- Cap 40 Area
            lvlCap = 40
            player:setPos(-180, -8, -78, 194, 9)
        elseif csid == 205 then -- No Cap Area
            lvlCap = 75
            player:setPos(-300, -8, 203, 191, 9)
        end
    end

    if
        player:isCrystalWarrior() or
        player:isClassicMode()
    then
        -- This variable is set by the Iron Grates in Beaucedine Glacier
        player:setCharVar("PSOXJA_RESTRICTION_LVL", lvlCap)
    end
end)

m:addOverride("xi.zones.PsoXja.Zone.afterZoneIn", function(player)
    super(player)

    -- This variable is set by the Iron Grates in Beaucedine Glacier
    local levelCap = player:getCharVar("PSOXJA_RESTRICTION_LVL")

    checkLevelCap(player, levelCap)
end)

return m
