-----------------------------------
-- Mission Helper Rewards (CW/WEW)
-- Gives an EXP scroll to players who help others clearing mission battles
-----------------------------------
require("modules/module_utils")
require("scripts/globals/npc_util")
-----------------------------------
local m = Module:new("helper_rewards")

local missions2_3 =
{
    { xi.mission.log_id.SANDORIA, xi.mission.id.sandoria.JOURNEY_ABROAD     },
    { xi.mission.log_id.BASTOK,   xi.mission.id.bastok.THE_EMISSARY         },
    { xi.mission.log_id.WINDURST, xi.mission.id.windurst.THE_THREE_KINGDOMS },
}

local missions5_1 =
{
    { xi.mission.log_id.SANDORIA, xi.mission.id.sandoria.THE_RUINS_OF_FEI_YIN },
    { xi.mission.log_id.BASTOK,   xi.mission.id.bastok.DARKNESS_RISING        },
    { xi.mission.log_id.WINDURST, xi.mission.id.windurst.THE_FINAL_SEAL       },
}

local missions5_2 =
{
    { xi.mission.log_id.SANDORIA, xi.mission.id.sandoria.THE_SHADOW_LORD        },
    { xi.mission.log_id.BASTOK,   xi.mission.id.bastok.XARCABARD_LAND_OF_TRUTHS },
    { xi.mission.log_id.WINDURST, xi.mission.id.windurst.THE_SHADOW_AWAITS      },
}

local missionRewards =
{
    -- Nation Mission 2-3 (Dragon Fight)
    {
        area       = "Waughroon_Shrine",
        bcnm       = "rank_2_mission",
        nm         = "Dark_Dragon",
        anyMission = missions2_3,
    },
    {
        area       = "Balgas_Dais",
        bcnm       = "rank_2_mission",
        nm         = "Black_Dragon",
        anyMission = missions2_3,
    },
    {
        area       = "Horlais_Peak",
        bcnm       = "rank_2_mission",
        nm         = "Dread_Dragon",
        anyMission = missions2_3,
    },

    -- Nation Mission 5-1 (Archlich Taber'quoan)
    {
        area       = "QuBia_Arena",
        bcnm       = "rank_5_mission",
        nm         = "Archlich_Taberquoan",
        anyMission = missions5_1,
    },
    {
        area       = "QuBia_Arena",
        bcnm       = "rank_5_mission",
        nm         = "Archlich_Taberquoan",
        anyMission = missions5_1,
    },
    {
        area       = "QuBia_Arena",
        bcnm       = "rank_5_mission",
        nm         = "Archlich_Taberquoan",
        anyMission = missions5_1,
    },

    -- Nation Mission 5-2 (Shadow Lord)
    {
        area       = "Throne_Room",
        bcnm       = "shadow_lord_battle",
        nm         = "Shadow_Lord",
        anyMission = missions5_2,
        multiplier = 2,
    },
    {
        area       = "Throne_Room",
        bcnm       = "shadow_lord_battle",
        nm         = "Shadow_Lord",
        anyMission = missions5_2,
        multiplier = 2,
    },
    {
        area       = "Throne_Room",
        bcnm       = "shadow_lord_battle",
        nm         = "Shadow_Lord",
        anyMission = missions5_2,
        multiplier = 2,
    },

    -----------------------------------
    -- Rise of the Zilart
    -----------------------------------

    -- ZM 4
    {
        area    = "Sacrificial_Chamber",
        bcnm    = "temple_of_uggalepih",
        nm      = "Tungsiton",
        logID   = xi.mission.log_id.ZILART,
        mission = xi.mission.id.zilart.TEMPLE_OF_UGGALEPIH,
    },

    -- ZM 6
    {
        area    = "Chamber_of_Oracles",
        bcnm    = "through_the_quicksand_caves",
        nm      = "Centurio_V-III",
        logID   = xi.mission.log_id.ZILART,
        mission = xi.mission.id.zilart.THROUGH_THE_QUICKSAND_CAVES,
    },

    -- ZM 8
    {
        area    = "Stellar_Fulcrum",
        bcnm    = "return_to_delkfutts_tower",
        nm      = "Kamlanaut",
        logID   = xi.mission.log_id.ZILART,
        mission = xi.mission.id.zilart.RETURN_TO_DELKFUTTS_TOWER,
    },

    -----------------------------------
    -- Chains of Promathia
    -----------------------------------

    -- Lv30 Promys
    {
        area    = "Spire_of_Dem",
        bcnm    = "ancient_flames_beckon",
        nm      = "Progenerator",
        logID   = xi.mission.log_id.COP,
        mission = xi.mission.id.cop.THE_MOTHERCRYSTALS,
        multiplier = 3,
    },
    {
        area    = "Spire_of_Holla",
        bcnm    = "ancient_flames_beckon",
        nm      = "Wreaker",
        logID   = xi.mission.log_id.COP,
        mission = xi.mission.id.cop.THE_MOTHERCRYSTALS,
        multiplier = 3,
    },
    {
        area    = "Spire_of_Mea",
        bcnm    = "ancient_flames_beckon",
        nm      = "Delver",
        logID   = xi.mission.log_id.COP,
        mission = xi.mission.id.cop.THE_MOTHERCRYSTALS,
        multiplier = 3,
    },

    -- Minotaur
    {
        area    = "Phomiuna_Aqueducts",
        nm      = "Minotaur",
        logID   = xi.mission.log_id.COP,
        mission = xi.mission.id.cop.DISTANT_BELIEFS,
    },

    -- Mammets
    {
        area    = "Monarch_Linn",
        bcnm    = "ancient_vows",
        nm      = "Mammet-19_Epsilon",
        logID   = xi.mission.log_id.COP,
        mission = xi.mission.id.cop.ANCIENT_VOWS,
        multiplier = 3,
    },

    -- Ouryu
    {
        area    = "Monarch_Linn",
        bcnm    = "the_savage",
        nm      = "Ouryu",
        logID   = xi.mission.log_id.COP,
        mission = xi.mission.id.cop.THE_SAVAGE,
        multiplier = 3,
    },

    -- Sacrarium
    {
        area    = "Sacrarium",
        nm      = "Old_Professor_Mariselle",
        logID   = xi.mission.log_id.COP,
        mission = xi.mission.id.cop.THE_SECRETS_OF_WORSHIP,
        multiplier = 3,
    },

    -- Promyvion - Vahzl
    {
        area    = "Spire_of_Vahzl",
        bcnm    = "desires_of_emptiness",
        nm      = "Agonizer",
        logID   = xi.mission.log_id.COP,
        mission = xi.mission.id.cop.DESIRES_OF_EMPTINESS,
        multiplier = 3,
    },

    -- Diabolos
    {
        area    = "The_Shrouded_Maw",
        bcnm    = "darkness_named",
        nm      = "Diabolos",
        logID   = xi.mission.log_id.COP,
        mission = xi.mission.id.cop.DARKNESS_NAMED,
    },

    -- Three Paths
    {
        area    = "Boneyard_Gully",
        bcnm    = "head_wind",
        nm      = "Shikaree_Z",
        logID   = xi.mission.log_id.COP,
        mission = xi.mission.id.cop.THREE_PATHS,
    },
    {
        area    = "Bearclaw_Pinnacle",
        bcnm    = "head_wind",
        nm      = "Snoll_Tzar",
        logID   = xi.mission.log_id.COP,
        mission = xi.mission.id.cop.THREE_PATHS,
    },
    {
        area    = "Mine_Shaft_2716",
        bcnm    = "century_of_hardship",
        nm      = "Bugbby",
        logID   = xi.mission.log_id.COP,
        mission = xi.mission.id.cop.THREE_PATHS,
    },

    -- Omega/Ultima "Airship" battle
    {
        area    = "Sealions_Den",
        bcnm    = "one_to_be_feared",
        nm      = "Ultima",
        logID   = xi.mission.log_id.COP,
        mission = xi.mission.id.cop.ONE_TO_BE_FEARED,
        multiplier = 2,
    },

    -----------------------------------
    -- Bard Artifact
    -----------------------------------
    {
        area  = "Ranguemont_Pass",
        nm    = "Tros",
        logID = xi.questLog.JEUNO,
        quest = xi.quest.id.jeuno.PAINFUL_MEMORY,
    },
    {
        area  = "The_Eldieme_Necropolis",
        nm    = "Yum_Kimil",
        logID = xi.questLog.JEUNO,
        quest = xi.quest.id.jeuno.THE_REQUIEM,
    },
    {
        area  = "Monastic_Cavern",
        nm    = "Bugaboo",
        logID = xi.questLog.JEUNO,
        quest = xi.quest.id.jeuno.THE_CIRCLE_OF_TIME,
    },

    -----------------------------------
    -- Beastmaster Artifact
    -----------------------------------
    {
        area  = "FeiYin",
        nm    = "Dabotzs_Ghost",
        logID = xi.questLog.JEUNO,
        quest = xi.quest.id.jeuno.SCATTERED_INTO_SHADOW,
    },
    {
        area  = "The_Eldieme_Necropolis",
        nm    = "Sturm",
        logID = xi.questLog.JEUNO,
        quest = xi.quest.id.jeuno.A_NEW_DAWN,
    },

    -----------------------------------
    -- Black Mage Artifact
    -----------------------------------
    {
        area  = "Xarcabard",
        nm    = "Chaos_Elemental",
        logID = xi.questLog.WINDURST,
        quest = xi.quest.id.windurst.THE_THREE_MAGI,
        ensure = true,
    },
    {
        area  = "Toraimarai_Canal",
        nm    = "Magic_Sludge",
        logID = xi.questLog.WINDURST,
        quest = xi.quest.id.windurst.THE_ROOT_OF_THE_PROBLEM,
        multiplier = 2,
    },

    -----------------------------------
    -- Dark Knight Artifact
    -----------------------------------
    {
        area  = "Giddeus",
        nm    = "Vaa_Huja_the_Erudite",
        logID = xi.questLog.BASTOK,
        quest = xi.quest.id.bastok.DARK_LEGACY,
    },
    {
        area   = "Giddeus",
        nm     = "Gerwitzs_Soul",
        logID  = xi.questLog.BASTOK,
        quest  = xi.quest.id.bastok.DARK_PUPPET,
        ensure = true,
    },
    {
        area   = "Beadeaux",
        nm     = "Gerwitzs_Scythe",
        logID  = xi.questLog.BASTOK,
        quest  = xi.quest.id.bastok.BLADE_OF_EVIL,
        ensure = true,
    },

    -----------------------------------
    -- Dragoon Artifact
    -----------------------------------
    {
        area  = "Eastern_Altepa_Desert",
        nm    = "Decurio_I-III",
        logID = xi.questLog.SANDORIA,
        quest = xi.quest.id.sandoria.A_CRAFTSMAN_S_WORK,
    },
    {
        area  = "Batallia_Downs",
        nm    = "Sturmtiger",
        logID = xi.questLog.SANDORIA,
        quest = xi.quest.id.sandoria.CHASING_QUOTAS,
    },
    {
        area  = "Temple_of_Uggalepih",
        nm    = "Cleuvarion_M_Resoaix",
        logID = xi.questLog.SANDORIA,
        quest = xi.quest.id.sandoria.KNIGHT_STALKER,
    },

    -----------------------------------
    -- Monk Artifact
    -----------------------------------
    {
        area  = "Gusgen_Mines",
        nm    = "Wandering_Ghost",
        logID = xi.questLog.BASTOK,
        quest = xi.quest.id.bastok.GHOSTS_OF_THE_PAST,
    },
    {
        area  = "Davoi",
        nm    = "Bilopdop",
        logID = xi.questLog.BASTOK,
        quest = xi.quest.id.bastok.THE_FIRST_MEETING,
    },
    {
        area  = "Castle_Oztroja",
        nm    = "Huu_Xalmo_the_Savage",
        logID = xi.questLog.BASTOK,
        quest = xi.quest.id.bastok.TRUE_STRENGTH,
    },

    -----------------------------------
    -- Ninja Artifact
    -----------------------------------
    {
        area  = "Eastern_Altepa_Desert",
        nm    = "Tsuchigumo",
        logID = xi.questLog.OUTLANDS,
        quest = xi.quest.id.outlands.TWENTY_IN_PIRATE_YEARS,
    },
    {
        area  = "Ship_bound_for_Selbina",
        nm    = "Enagakure",
        logID = xi.questLog.OUTLANDS,
        quest = xi.quest.id.outlands.I_LL_TAKE_THE_BIG_BOX,
    },
    {
        area  = "Yhoator_Jungle",
        nm    = "Kappa_Akuso",
        logID = xi.questLog.OUTLANDS,
        quest = xi.quest.id.outlands.TRUE_WILL,
    },

    -----------------------------------
    -- Paladin Artifact
    -----------------------------------
    {
        area  = "Ordelles_Caves",
        nm    = "Polevik",
        logID = xi.questLog.SANDORIA,
        quest = xi.quest.id.sandoria.SHARPENING_THE_SWORD,
    },
    {
        area   = "Crawlers_Nest",
        nm     = "Odontotyrannus",
        logID  = xi.questLog.SANDORIA,
        quest  = xi.quest.id.sandoria.A_BOY_S_DREAM,
        ensure = true,
    },
    {
        area   = "Davoi",
        nm     = "One-eyed_Gwajboj",
        logID  = xi.questLog.SANDORIA,
        quest  = xi.quest.id.sandoria.UNDER_OATH,
        ensure = true,
    },

    -----------------------------------
    -- Ranger Artifact
    -----------------------------------
    {
        area  = "Xarcabard",
        nm    = "Koenigstiger",
        logID = xi.questLog.WINDURST,
        quest = xi.quest.id.windurst.UNBRIDLED_PASSION,
    },

    -----------------------------------
    -- Red Mage Artifact
    -----------------------------------
    {
        area   = "Davoi",
        nm     = "Purpleflash_Brukdok",
        logID  = xi.questLog.SANDORIA,
        quest  = xi.quest.id.sandoria.THE_CRIMSON_TRIAL,
        ensure = true,
    },
    {
        area   = "FeiYin",
        nm     = "Miser_Murphy",
        logID  = xi.questLog.SANDORIA,
        quest  = xi.quest.id.sandoria.PEACE_FOR_THE_SPIRIT,
        ensure = true,
    },
    {
        area   = "Garlaige_Citadel",
        nm     = "Guardian_Statue",
        logID  = xi.questLog.SANDORIA,
        quest  = xi.quest.id.sandoria.PEACE_FOR_THE_SPIRIT,
        ensure = true,
    },

    -----------------------------------
    -- Samurai Artifact
    -----------------------------------
    {
        area  = "The_Sanctuary_of_ZiTah",
        nm    = "Isonade",
        logID = xi.questLog.OUTLANDS,
        quest = xi.quest.id.outlands.THE_SACRED_KATANA,
    },
    {
        area  = "Labyrinth_of_Onzozo",
        nm    = "Ubume",
        logID = xi.questLog.OUTLANDS,
        quest = xi.quest.id.outlands.YOMI_OKURI,
    },
    {
        area   = "Labyrinth_of_Onzozo",
        nm     = "Doman",
        logID  = xi.questLog.OUTLANDS,
        quest  = xi.quest.id.outlands.YOMI_OKURI,
        ensure = true,
    },
    {
        area  = "Waughroon_Shrine",
        nm    = "Onki",
        logID = xi.questLog.OUTLANDS,
        quest = xi.quest.id.outlands.A_THIEF_IN_NORG,
    },

    -----------------------------------
    -- Summoner Artifact
    -----------------------------------
    {
        area  = "Cloister_of_Tremors",
        nm    = "Galgalim",
        logID = xi.questLog.WINDURST,
        quest = xi.quest.id.windurst.THE_PUPPET_MASTER,
    },
    {
        area   = "Cloister_of_Frost",
        nm     = "Dryad",
        logID  = xi.questLog.WINDURST,
        quest  = xi.quest.id.windurst.CLASS_REUNION,
        ensure = true,
    },
    {
        area   = "Cloister_of_Storms",
        nm     = "Lightning_Gremlin",
        logID  = xi.questLog.WINDURST,
        quest  = xi.quest.id.windurst.CARBUNCLE_DEBACLE,
        ensure = true,
    },
    {
        area   = "Cloister_of_Storms",
        nm     = "Ogmios",
        logID  = xi.questLog.WINDURST,
        quest  = xi.quest.id.windurst.CARBUNCLE_DEBACLE,
        ensure = true,
    },

    -----------------------------------
    -- Thief Artifact
    -----------------------------------
    {
        area  = "Sauromugue_Champaign",
        nm    = "Climbpix_Highrise",
        logID = xi.questLog.WINDURST,
        quest = xi.quest.id.windurst.AS_THICK_AS_THIEVES,
    },
    {
        area  = "North_Gustaberg",
        nm    = "Gambilox_Wanderling",
        logID = xi.questLog.WINDURST,
        quest = xi.quest.id.windurst.AS_THICK_AS_THIEVES,
        multiplier = 2,
    },
    {
        area  = "Garlaige_Citadel",
        nm    = "Chandelier",
        logID = xi.questLog.WINDURST,
        quest = xi.quest.id.windurst.HITTING_THE_MARQUISATE,
    },

    -----------------------------------
    -- Warrior Artifact
    -----------------------------------
    {
        area  = "Davoi",
        nm    = "Gavotvut",
        logID = xi.questLog.BASTOK,
        quest = xi.quest.id.bastok.THE_DOORMAN,
    },
    {
        area   = "Palborough_Mines",
        nm     = "NiGhu_Nestfender",
        logID  = xi.questLog.BASTOK,
        quest  = xi.quest.id.bastok.THE_TALEKEEPERS_TRUTH,
        ensure = true,
    },
    {
        area  = "Behemoths_Dominion",
        nm    = "Doglix_Muttsnout",
        logID = xi.questLog.BASTOK,
        quest = xi.quest.id.bastok.THE_TALEKEEPERS_GIFT,
    },

    -----------------------------------
    -- White Mage Artifact
    -----------------------------------
    {
        area  = "Valkurm_Dunes",
        nm    = "Marchelute",
        logID = xi.questLog.SANDORIA,
        quest = xi.quest.id.sandoria.MESSENGER_FROM_BEYOND,
    },
    {
        area   = "FeiYin",
        nm     = "Altedour_I_Tavnazia",
        logID  = xi.questLog.SANDORIA,
        quest  = xi.quest.id.sandoria.MESSENGER_FROM_BEYOND,
        ensure = true,
    },

    -----------------------------------
    -- Blue Mage Artifact
    -----------------------------------
    {
        area  = "Navukgo_Execution_Chamber",
        nm    = "Immortal_Flan",
        logID = xi.questLog.AHT_URHGAN,
        quest = xi.quest.id.ahtUrhgan.OMENS,
    },
    {
        area  = "Alzadaal_Undersea_Ruins",
        nm    = "Nepionic_Soulflayer",
        logID = xi.questLog.AHT_URHGAN,
        quest = xi.quest.id.ahtUrhgan.TRANSFORMATIONS,
    },

    -----------------------------------
    -- Puppetmaster Artifact
    -----------------------------------
    {
        area  = "Caedarva_Mire",
        nm    = "Caedarva_Toad",
        logID = xi.questLog.AHT_URHGAN,
        quest = xi.quest.id.ahtUrhgan.THE_WAYWARD_AUTOMATON,
    },
    {
        area   = "Talacca_Cove",
        nm     = "Valkeng",
        logID  = xi.questLog.AHT_URHGAN,
        quest  = xi.quest.id.ahtUrhgan.OPERATION_TEATIME,
        ensure = true,
    },

    -----------------------------------
    -- Dancer Artifact
    -----------------------------------
    {
        area  = "Grauberg_[S]",
        nm    = "Migratory_Hippogryph",
        logID = xi.questLog.JEUNO,
        quest = xi.quest.id.jeuno.THE_UNFINISHED_WALTZ,
    },

    -----------------------------------
    -- Scholar Artifact
    -----------------------------------
    {
        area   = "Ruhotz_Silvermines",
        nm     = "Ulbrecht",
        logID  = xi.questLog.CRYSTAL_WAR,
        quest  = xi.quest.id.crystalWar.SEEING_BLOOD_RED,
        ensure = true,
    },
}

local function checkAllMissions(player, anyMission)
    if anyMission ~= nil then
        for k, v in pairs(anyMission) do
            if player:hasCompletedMission(v[1], v[2]) then
                return true
            end
        end
    end

    return false
end

local function checkOneMission(player, logID, missionID)
    if
        logID     ~= nil and
        missionID ~= nil
    then
        return player:hasCompletedMission(logID, missionID)
    end

    return false
end

local function checkQuest(player, logID, questID)
    if
        logID   ~= nil and
        questID ~= nil
    then
        local helping = player:getQuestStatus(logID, questID) ~= xi.questStatus.QUEST_ACCEPTED

        if not helping then
            return false
        end

        local party = player:getParty()

        for _, member in pairs(party) do
            -- Only give reward if party member is on this quest
            if member:getQuestStatus(logID, questID) == xi.questStatus.QUEST_ACCEPTED then
                return true
            end
        end
    end

    return false
end

local function checkRewards(player, info)
    return
        checkAllMissions(player, info.anyMission) or
        checkOneMission(player, info.logID, info.mission) or
        checkQuest(player, info.logID, info.quest)
end

for k, v in pairs(missionRewards) do
    -- Only ensure if required (Or it will wipe functions)
    if v.ensure then
        xi.module.ensureTable(string.format("xi.zones.%s.mobs.%s", v.area, v.nm))
    end

    m:addOverride(string.format("xi.zones.%s.mobs.%s.onMobDeath", v.area, v.nm), function(mob, player, optParams)
        super(mob, player, optParams)

        if
            player and
            (player:isCrystalWarrior() or player:isClassicMode()) and
            checkRewards(player, v)
        then
            local var = string.format("[HELPER]%s", string.upper(v.nm))

            -- Make sure player can't claim reward more than once every 24 hours
            if player:getCharVar(var) == 0 then
                print(string.format("[HELPER] %s has claimed a reward for helping with %s.", player:getName(), v.bcnm or v.nm))
                player:setCharVar(var, 1, getMidnight())

                -- Set var on player for use in leaderboards
                player:incrementCharVar("[HELPER]POINTS", 1)

                if v.multiplier ~= nil then
                    if not npcUtil.giveItem(player, { { xi.item.DRAGON_CHRONICLES, v.multiplier } }) then
                        player:incrementCharVar("[HELPER]EXP_SCROLLS", v.multiplier)
                    end
                else
                    if not npcUtil.giveItem(player, xi.item.DRAGON_CHRONICLES) then
                        player:incrementCharVar("[HELPER]EXP_SCROLLS", 1)
                    end
                end
            end
        end
    end)
end

-- Now that EXP scrolls stack, we prevent players from using them inside Battlefields
local preventBattlefieldUse =
{
    'page_from_miratetes_memoirs',
    'copy_of_ginuvas_battle_theory',
    'copy_of_schultz_stratagems',
    'page_from_the_dragon_chronicles',
}

for _, itemName in pairs(preventBattlefieldUse) do
    m:addOverride(string.format("xi.items.%s.onItemCheck", itemName), function(target)
        if target:hasStatusEffect(xi.effect.BATTLEFIELD) then
            return xi.msg.basic.ITEM_UNABLE_TO_USE
        end

        return 0
    end)
end

-- Update Dragon Chronicles (4198) to give 2500-3000 EXP
-- This is only obtainable through Eco-Warrior, Garrison, etc.
m:addOverride("xi.items.page_from_the_dragon_chronicles.onItemUse", function(target)
    local expReward = math.random(2500, 3000)
    target:addExp(expReward)
end)

-- Update Miratete's Memoirs (4247) to give 1500-2000 EXP
m:addOverride("xi.items.page_from_miratetes_memoirs.onItemUse", function(target)
    local expReward = math.random(1500, 2000)
    target:addExp(expReward)
end)

return m
