-----------------------------------
-- EXP Buff restrictions by char type
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("exp_buff_restrictions")

-- Restrict EXP Buff items
local expItems = 
{
    "sprout_beret",
    "guide_beret",
    "echad_ring",
}

for _, item in pairs(expItems) do
    m:addOverride(string.format("xi.items.%s.onItemCheck", item), function(target)
        if
            target:isCrystalWarrior() or
            target:isClassicMode()
        then
            return xi.msg.basic.ITEM_UNABLE_TO_USE_2
        else
            return super(target)
        end
    end)
end

return m
