-----------------------------------
-- Create Char Overrides
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("char_create")

local startingRaceInfo =
{
    [xi.race.HUME_M]   = { body = 12631, hand = 12754, leg = 12883, feet = 13005, homeNation = xi.nation.BASTOK   },
    [xi.race.HUME_F]   = { body = 12632, hand = 12760, leg = 12884, feet = 13010, homeNation = xi.nation.BASTOK   },
    [xi.race.ELVAAN_M] = { body = 12633, hand = 12755, leg = 12885, feet = 13006, homeNation = xi.nation.SANDORIA },
    [xi.race.ELVAAN_F] = { body = 12634, hand = 12759, leg = 12889, feet = 13011, homeNation = xi.nation.SANDORIA },
    [xi.race.TARU_M]   = { body = 12635, hand = 12756, leg = 12886, feet = 13007, homeNation = xi.nation.WINDURST },
    [xi.race.TARU_F]   = { body = 12635, hand = 12756, leg = 12886, feet = 13007, homeNation = xi.nation.WINDURST },
    [xi.race.MITHRA]   = { body = 12636, hand = 12757, leg = 12887, feet = 13008, homeNation = xi.nation.WINDURST },
    [xi.race.GALKA]    = { body = 12637, hand = 12758, leg = 12888, feet = 13009, homeNation = xi.nation.BASTOK   },
}

local startingNationInfo =
{
    [xi.nation.SANDORIA] = { ring = 13495, map = xi.ki.MAP_OF_THE_SAN_DORIA_AREA, start = { 152.145, 0.000, 195.839, 100,  xi.zone.KING_RANPERRES_TOMB } },
    [xi.nation.BASTOK]   = { ring = 13497, map = xi.ki.MAP_OF_THE_BASTOK_AREA,    start = { -452.215, 3.987, 133.918, 150, xi.zone.DANGRUF_WADI        } },
    [xi.nation.WINDURST] = { ring = 13496, map = xi.ki.MAP_OF_THE_WINDURST_AREA,  start = { 180.019, 8.500, 22.654, 64,    xi.zone.TORAIMARAI_CANAL    } },
}

local defaultLocations =
{
    [xi.nation.SANDORIA] = { -110.465,  0.000,  -54.469, 223, xi.zone.SOUTHERN_SAN_DORIA },
    [xi.nation.BASTOK]   = {  -16.039, -1.500, -132.804, 193, xi.zone.BASTOK_MINES       },
    [xi.nation.WINDURST] = {  124.043, -5.000,  -39.992, 126, xi.zone.WINDURST_WOODS     },
}

local startingJobGear =
{
    [xi.job.WAR] = { 16534 },       -- onion sword
    [xi.job.MNK] = { 13184 },       -- white belt
    [xi.job.WHM] = { 17068, 4608 }, -- onion rod, scroll of cure
    [xi.job.BLM] = { 17104, 4607 }, -- onion staff, scroll of stone
    [xi.job.RDM] = { 16482, 4606 }, -- onion dagger, scroll of dia
    [xi.job.THF] = { 16483 },       -- onion knife
}

local function addAllMaps(player)
    if xi.settings.main.ALL_MAPS == 1 then
        for i = xi.ki.MAP_OF_THE_SAN_DORIA_AREA, xi.ki.MAP_OF_DIO_ABDHALJS_GHELSBA do
            player:addKeyItem(i)
        end

        for i = xi.ki.MAP_OF_AL_ZAHBI, xi.ki.MAP_OF_RAKAZNAR do
            player:addKeyItem(i)
        end

        for i = xi.ki.MAP_OF_RALA_WATERWAYS_U, xi.ki.MAP_OF_RAKAZNAR_U do
            player:addKeyItem(i)
        end

        for i = xi.ki.MAP_OF_ESCHA_ZITAH, xi.ki.MAP_OF_REISENJIMA do
            player:addKeyItem(i)
        end
    end
end

local function setInitialVars(player)
    player:setCharVar("HQuest[moghouseExpo]notSeen", 1) -- needs Moghouse intro
    player:setCharVar("spokeKindlix", 1)                -- Kindlix introduction
    player:setCharVar("spokePyropox", 1)                -- Pyropox introduction
    player:setCharVar("TutorialProgress", 1)            -- Has not started tutorial
    player:setCharVar("EinherjarIntro", 1)              -- Has not seen Einherjar intro
end

local function startCW(player)
    local race = player:getRace()
    local nation = player:getNation()
    local nationInfo = startingNationInfo[nation]

    -- Update inventory containers for Crystal Warriors
    local containerSize = 0

    for i = xi.inv.MOGSATCHEL, xi.inv.WARDROBE8 do
        containerSize = player:getContainerSize(i)
        player:changeContainerSize(i, - containerSize)
    end

    -- Add race-specific starting gear
    for _, v in pairs(startingRaceInfo[race]) do
        if not player:hasItem(v) then
            player:addItem(v)
            player:equipItem(v)
        end
    end

    -- add nation-specific map
    player:addKeyItem(nationInfo.map)

    -- add job-emote Key items
    player:addKeyItem(xi.ki.JOB_GESTURE_WARRIOR)
    player:addKeyItem(xi.ki.JOB_GESTURE_MONK)
    player:addKeyItem(xi.ki.JOB_GESTURE_WHITE_MAGE)
    player:addKeyItem(xi.ki.JOB_GESTURE_BLACK_MAGE)
    player:addKeyItem(xi.ki.JOB_GESTURE_RED_MAGE)
    player:addKeyItem(xi.ki.JOB_GESTURE_THIEF)

    -- give all maps
    addAllMaps(player)

    -- set initial level cap
    player:setLevelCap(50)

    player:setGil(10)
    player:addTitle(xi.title.NEW_ADVENTURER)

    setInitialVars(player)

    player:setNewPlayer(false)                          -- Do not apply new player flag
    player:addLinkpearl("CrystalWarriors", true)

    -- Set Home Point for safety
    -- This will be changed once leaving Provenance
    player:setHomePointAt(501.448, 27.500, -497.632, 252, 222)
    player:setPos(501.448, 27.500, -497.632, 252, 222)
end

local function startWings(player)
    local nation     = player:getNation()
    local nationInfo = startingNationInfo[nation]

    local race       = player:getRace()
    local raceInfo   = startingRaceInfo[race]

    local containerSize = 0

    for i = xi.inv.MOGSATCHEL, xi.inv.WARDROBE8 do
        containerSize = player:getContainerSize(i)
        player:changeContainerSize(i, - containerSize)
    end

    -- Add race-specific starting gear
    for _, v in pairs(raceInfo) do
        if not player:hasItem(v) then
            player:addItem(v)
            player:equipItem(v)
        end
    end

    -- add job-specific starting gear
    for _, v in pairs(startingJobGear[player:getMainJob()]) do
        if not player:hasItem(v) then
            player:addItem(v)
        end
    end

    -- Starting Ring
    if nation == raceInfo.homeNation then
        player:addItem(nationInfo.ring)
    end

    -- add nation-specific map
    player:addKeyItem(nationInfo.map)

    -- add job-emote Key items
    player:addKeyItem(xi.ki.JOB_GESTURE_WARRIOR)
    player:addKeyItem(xi.ki.JOB_GESTURE_MONK)
    player:addKeyItem(xi.ki.JOB_GESTURE_WHITE_MAGE)
    player:addKeyItem(xi.ki.JOB_GESTURE_BLACK_MAGE)
    player:addKeyItem(xi.ki.JOB_GESTURE_RED_MAGE)
    player:addKeyItem(xi.ki.JOB_GESTURE_THIEF)

    -- give all maps
    addAllMaps(player)

    -- set initial level cap
    player:setLevelCap(50)

    player:setGil(10)
    player:addTitle(xi.title.NEW_ADVENTURER)

    setInitialVars(player)
end

m:addOverride("xi.player.charCreate", function(player)
    local accType = player:getAccountType()

    -- UPDATE accounts SET type = 1 WHERE login = "accname";
    if
        accType == 1 and
        xi.settings.main.ENABLE_CW == 1
    then
        player:setCrystalWarrior(true)
        startCW(player)
    elseif accType == 2 then
        player:setClassicMode(true)
        startWings(player)

        local defaultLocation = defaultLocations[player:getNation()]
        player:setHomePointAt(unpack(defaultLocation))
    else
        super(player)
        player:addItem(15198) -- Sprout Beret
        player:addLinkpearl("CatsEyeXI", true)

        local defaultLocation = defaultLocations[player:getNation()]
        player:setHomePointAt(unpack(defaultLocation))
        return
    end
end)

return m
