-----------------------------------
-- Sigil Allied Notes
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("sigil_allied_notes")

local regions = set {
    xi.region.RONFAURE_FRONT,
    xi.region.NORVALLEN_FRONT,
    xi.region.GUSTABERG_FRONT,
    xi.region.DERFLAND_FRONT,
    xi.region.SARUTA_FRONT,
    xi.region.ARAGONEAU_FRONT,
    xi.region.FAUREGANDI_FRONT,
    xi.region.VALDEAUNIA_FRONT,
}

m:addOverride("xi.player.onGameIn", function(player, firstLogin, zoning)
    super(player, firstLogin, zoning)

    if regions[player:getCurrentRegion()] ~= nil then
        player:addListener("EXPERIENCE_POINTS", "SIGIL_ALLIED_NOTES", function(player, mob, exp)
            if player:hasStatusEffect(xi.effect.SIGIL) then
                player:addCurrency("allied_notes", math.floor(exp * 0.05))
            end
        end)
    end
end)

return m
