-----------------------------------
-- Campaign Augments
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("npc_campaign_augments")

-----------------------------------
-- NPC Tables
-----------------------------------
local areas =
{
    ["Southern_San_dOria_[S]"] =
    {
        name = "Allied Enhancer", -- (K-9)
        pos  = { 119.328, 1.000, -30.470, 140 }, -- !pos 119.328 1.000 -30.470 80
        look = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.B6,
            head = cexi.model.NOTHING,
            body = cexi.model.WHITE_CLOAK,
            hand = cexi.model.CENTURIONS_SCALE_MAIL,
            legs = cexi.model.CENTURIONS_SCALE_MAIL,
            feet = cexi.model.CENTURIONS_SCALE_MAIL,
            main = 250, -- Gold Sword
            offh = 28,  -- T.K. Army Shield
        }),
    },

    ["Bastok_Markets_[S]"] =
    {
        name = "Allied Enhancer", -- (F-8)
        pos  = { -301.663, -12.000, -41.441, 60 }, -- !pos -301.663 -12.000 -41.441 87
        look = cexi.util.look({
            race = xi.race.HUME_M,
            face = cexi.face.B6,
            head = cexi.model.CENTURIONS_SCALE_MAIL,
            body = cexi.model.MYTHRIL_BREASTPLATE,
            hand = cexi.model.MYTHRIL_BREASTPLATE,
            legs = cexi.model.MYTHRIL_BREASTPLATE,
            feet = cexi.model.MYTHRIL_BREASTPLATE,
            main = 84, -- Viking Axe
            offh = 43, -- Decurion's Shield
        }),
    },

    ["Windurst_Waters_[S]"] =
    {
        name = "Allied Enhancer", -- (G-10)
        pos  = { -13.673, -1.000, 19.207, 0 }, -- !pos -13.673 -1.000 19.207 94
        look = cexi.util.look({
            race = xi.race.MITHRA,
            face = cexi.face.B6,
            head = cexi.model.SHADE_HARNESS,
            body = cexi.model.BONE_HARNESS,
            hand = cexi.model.CORAL_HARNESS,
            legs = cexi.model.CORAL_HARNESS,
            feet = cexi.model.CORAL_HARNESS,
            main = 101, -- Bone Cudgel
            offh = 36,  -- Maple Shield
        }),
    },
}

-----------------------------------
-- Load Armor Lists
-----------------------------------
local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function onTrigger(player, npc)
    if xi.settings.main.ENABLE_CAMPAIGN then
        cexi.util.dialog(player, {
            "Greetings adventurer. I'm here to facilitate upgrades to your existing Campaign Armor.",
            " Trade me a piece and I will authorize it provided you have the sufficient rank and Allied Notes.",
        }, npc:getPacketName(), { npc = npc } )
    else
        cexi.util.dialog(player, {
            "Greetings adventurer. I've been assigned here on behalf of the Allied Campaign.",
            " My business is confidential as a matter of security but all will become clear in due time.",
        }, npc:getPacketName(), { npc = npc } )
    end
end

local function onTrade(player, npc, trade)
    if not xi.settings.main.ENABLE_CAMPAIGN then
        cexi.util.dialog(player, {
            "Halt! I've not yet been given the authorization to handle these items.",
        }, npc:getPacketName(), { npc = npc } )

        return
    end

    for itemID, itemInfo in pairs(cexi.augments.campaign_augments) do
        if cexi.util.tradeHasExactly(trade, itemID) then
            local item = cexi.util.augment.getTradedItem(trade, itemID)
            local augs = cexi.util.augment.getAugments(player, item)
            local tier = cexi.augments.campaignGetTier(itemID, augs)

            if tier >= 3 then
                cexi.util.dialog(player, { fmt("You've already upgraded this {} to the maximum level.", itemInfo.name) }, npc:getPacketName(), { npc = npc })
                return
            end

            local notes = player:getCurrency("allied_notes")
            local reqs  = cexi.augments.campaign_requirements[tier + 1]

            if notes < reqs[3] then
                cexi.util.dialog(player, { fmt("This upgrade requires {} Allied Notes but you only have {}.", reqs[3], notes) }, npc:getPacketName(), { npc = npc })
                return
            end

            if not player:hasKeyItem(reqs[1]) then
                cexi.util.dialog(player, { fmt("You do not possess the {} required for me to authorize this upgrade.", reqs[2]) }, npc:getPacketName(), { npc = npc })
                return
            end

            npc:facePlayer(player, true)

            delaySendMenu(player, {
                title   = fmt("Upgrade {} to Level {}?", itemInfo.name, tier + 1),
                options =
                {
                    {
                        "No",
                        function()
                            cexi.util.dialog(player, { "Very well." }, npc:getPacketName(), { npc = npc })
                            return
                        end,
                    },
                    {
                        fmt("Yes ({} Allied Notes)", reqs[3]),
                        function()
                            cexi.util.dialog(player, {
                                "It is done.",
                                { emote = xi.emote.SALUTE },
                            }, npc:getPacketName(), { npc = npc })

                            player:tradeComplete()
                            player:delCurrency("allied_notes", reqs[3])
                            cexi.augments.campaignGiveTier(player, itemID, tier + 1)
                        end,
                    },
                },
            })
        end
    end
end

-- Create reload list from NPC table
local npcs = {}

for zoneName, npcInfo in pairs(areas) do
    npcs[zoneName] =
    {
        {
            name      = npcInfo.name,
            objtype   = xi.objType.NPC,
            look      = npcInfo.look,
            x         = npcInfo.pos[1],
            y         = npcInfo.pos[2],
            z         = npcInfo.pos[3],
            rotation  = npcInfo.pos[4],
            onTrigger = onTrigger,
            onTrade   = onTrade,
        },
    }
end

cexi.util.liveReload(m, npcs)

return m
