-----------------------------------
-- Campaign Data
-----------------------------------
require("modules/module_utils")
require("scripts/globals/campaign")
-----------------------------------
local m = Module:new("campaign_data")

xi = xi or {}
xi.campaign = xi.campaign or {}

local control =
{
    Sandoria = 1,
    Bastok   = 2,
    Windurst = 3,
    Beastman = 4,
}

-- Promotion Credits required to receive each medal
xi.campaign.promotions =
{
    { xi.keyItem.BRONZE_RIBBON_OF_SERVICE, 10000, "Bronze Ribbon of Service" },
    { xi.keyItem.BRASS_RIBBON_OF_SERVICE,  11000, "Brass Ribbon of Service"  },
    { xi.keyItem.ALLIED_RIBBON_OF_BRAVERY, 12000, "Allied Ribbon of Bravery" },
    { xi.keyItem.ALLIED_RIBBON_OF_GLORY,   13000, "Allied Ribbon of Glory"   },
    { xi.keyItem.BRONZE_STAR,              14000, "Bronze Star"              },
    { xi.keyItem.STERLING_STAR,            15000, "Sterling Star"            },
    { xi.keyItem.MYTHRIL_STAR,             16000, "Mythril Star"             },
    { xi.keyItem.GOLDEN_STAR,              17000, "Golden Star"              },
    { xi.keyItem.COPPER_EMBLEM_OF_SERVICE, 18000, "Copper Emblem of Service" },
    { xi.keyItem.IRON_EMBLEM_OF_SERVICE,   19000, "Iron Emblem of Service"   },
    { xi.keyItem.STEELKNIGHT_EMBLEM,       20000, "Steelknight Emblem"       },
    { xi.keyItem.HOLYKNIGHT_EMBLEM,        21000, "Holyknight Emblem"        },
    { xi.keyItem.BRASS_WINGS_OF_SERVICE,   22000, "Brass Wings of Service"   },
    { xi.keyItem.MYTHRIL_WINGS_OF_SERVICE, 23000, "Mythril Wings of Service" },
    { xi.keyItem.WINGS_OF_INTEGRITY,       24000, "Wings of Integrity"       },
    { xi.keyItem.WINGS_OF_HONOR,           25000, "Wings of Honor"           },
    { xi.keyItem.STARLIGHT_MEDAL,          26000, "Starlight Medal"          },
    { xi.keyItem.MOONLIGHT_MEDAL,          27000, "Moonlight Medal"          },
    { xi.keyItem.DAWNLIGHT_MEDAL,          28000, "Dawnlight Medal"          },
    { xi.keyItem.MEDAL_OF_ALTANA,          30000, "Medal of Altana"          },
}

-- Promotion Credits received relative to the number of participants
xi.campaign.credits =
{
    win =
    {
        [1]  = 1000, -- N/A
        [2]  = 1100, -- N/A
        [3]  = 1200, -- Minumum number of participants
        [4]  = 1300,
        [6]  = 1400,
        [8]  = 1500,
        [10] = 1600,
        [12] = 1700,
        [14] = 1800,
        [16] = 1900,
        [18] = 2000, -- Maximum number of participants
    },

    loss =
    {
        [1]  =  500, -- N/A
        [2]  =  550, -- N/A
        [3]  =  600, -- Minumum number of participants
        [4]  =  650,
        [6]  =  700,
        [8]  =  750,
        [10] =  800,
        [12] =  850,
        [14] =  900,
        [16] =  950,
        [18] = 1000, -- Maximum number of participants
    },
}

xi.campaign.group =
{
    SANDORIA =
    {
        { 'Valaineral_R_Davilles',  'Royal_Guard'                                    },
        { 'Leonoyne',               'Savage_Hound_Condottiere'                       },
        { 'Ashmea_B_Greinner',      'Scarlet_Boar_Esquire'                           },
        { 'Feldrautte_I_Rouhent',   'Norvallen_Knight'                               },
        { 'Yrvaulair_S_Cousseraux', 'Royal_Knight'                                   },
    },
    ORCISH =
    {
        { 'Conqueror_Bakgodek',     'Steelhide_Protector'                            },
        { 'One-eyed_Gwajboj',       'Gutrender_Trooper'                              },
        { 'Deathlord_Rojgnoj',      'Spinebeak_Neckchopper'                          },
        { 'Jagidbods_Warmachine',   'Jagidbod_of_Clan_Reaper', 'Clan_Reaper_Grunt'   },
        { 'Alpha_Gnole_Anders',     'Anderss_Guard',           'Moonfang_Warrior'    },
    },
    BASTOK =
    {
        { 'Bartholomaus',           '1st_Iron_Musketeer'                             },
        { 'Maximilian',             '1st_Legionnaire'                                },
        { 'Ludwig',                 '2nd_Legionnaire'                                },
        { 'Elivira',                '1st_Gold_Musketeer'                             },
        { 'Kurt',                   '8th_Iron_Musketeer'                             },
    },
    QUADAV =
    {
        { 'DiDha_Adamantfist',      'DiDhas_Elite_Guard'                             },
        { 'BoDho_Hundredfist',      'Waughroon_Heavyshell'                           },
        { 'DeVyu_Headhunter',       'Beadeaux_Vanguard'                              },
        { 'BiGho_Headtaker',        'Qulun_Heavyshell'                               },
        { 'GoBhu_Herohunter',       'GoBhus_Elite_Raider'                            },
    },
    WINDURST =
    {
        { 'Kayeel-Payeel',  'Ice_Fiend',    'Thunder_Fiend',  'Aquarian_Caster'      },
        { 'Gariri',         'Flame_Giant',  'Scorpion_Caster'                        },
        { 'Zolku-Azolku',   'Libran_Caster'                                          },
        { 'Lhu_Mhakaracca', 'Pya',          'Kyo',            'Python_Mercenary'     },
        { 'Haja_Zhwan',     'Wildcat_Volunteer'                                      },
    },
    YAGUDO =
    {
        { 'Vee_Qiqa_the_Decreer',    'Vee_Qiqas_Elemental', 'Divine_Templar'         },
        { 'Moo_Ouzi_the_Swiftblade', 'Divine_Disseminator'                           },
        { 'Muu_Buxu_the_Elusive',    'Divine_Assassin'                               },
        { 'Dee_Xalmo_the_Grim',      'Divine_Ascetic'                                },
        { 'Kazan_the_Peerless',      'Plenilune_Ronin'                               },
    },
}

xi.campaign.npcs =
{
    SANDORIA_GUARD   = 0,
    BASTOK_GUARD     = 1,
    WINDURST_GUARD   = 2,
    SANDORIA_FLAG    = 3,
    BASTOK_FLAG      = 4,
    WINDURST_FLAG    = 5,
    BEASTMEN_FLAG    = 6,
    CAMPAIGN_ARBITER = 7,
}

xi.campaign.messages =
{
    CAMPAIGN_TALLIED = 0,
    CAMPAIGN_BEGIN   = 1,
    CAMPAIGN_FINISH  = 2,
    CAMPAIGN_WIN     = 3,
    CAMPAIGN_LOSE    = 4,
}

xi.campaign.activeZones =
{
    ["East_Ronfaure_[S]"]         = { "SANDORIA", "ORCISH" },
    ["Jugner_Forest_[S]"]         = { "SANDORIA", "ORCISH" },

    ["North_Gustaberg_[S]"]       = { "BASTOK",   "QUADAV" },
    ["Pashhow_Marshlands_[S]"]    = { "BASTOK",   "QUADAV" },

    ["West_Sarutabaruta_[S]"]     = { "WINDURST", "YAGUDO" },
    ["Meriphataud_Mountains_[S]"] = { "WINDURST", "YAGUDO" },
}

xi.campaign.npcOverride =
{
    ["East_Ronfaure_[S]"]         = { "Arlayse_RK",   "Aged_Stone_LC",     "Ihli_Llamhya_MC",  "Waldo_CA"   },
    ["Jugner_Forest_[S]"]         = { "Roiloux_RK",   "Blazing_Lizard_LC", "Emmah_Laali_MC",   "Larkin_CA"  },
    ["North_Gustaberg_[S]"]       = { "Estineau_RK",  "Jagged_Onyx_LC",    "Dhi_Emwaltih_MC",  "Uriah_CA"   },
    ["Pashhow_Marshlands_[S]"]    = { "Yuvalbaux_RK", "Stray_Boar_LC",     "Yhu_Lyehga_MC",    "Barnett_CA" },
    ["West_Sarutabaruta_[S]"]     = { "Madelleon_RK", "Tenacious_Fool_LC", "Mhik_Liusihlo_MC", "Addison_CA" },
    ["Meriphataud_Mountains_[S]"] = { "Raurart_RK",   "Pondering_Peak_LC", "Dhen_Kwherri_MC",  "Kearney_CA" },
}

xi.campaign.event =
{
    [control.Sandoria] = { 454, 450 },
    [control.Bastok]   = { 455, 451 },
    [control.Windurst] = { 456, 452 },
    [control.Beastman] = { 457, 453 },
}

xi.campaign.data =
{
    [xi.zone.EAST_RONFAURE_S] =
    {
        music    = { 251, 251, 101, 215 },
        chest    = { 314.202, -29.679, -115.127, 36 },
        items    =
        {
            { cexi.rate.VERY_COMMON, 1452 }, -- O.Bronzepiece         (24%)
            { cexi.rate.VERY_COMMON, 1455 }, -- One Byne Bill         (24%)
            { cexi.rate.VERY_COMMON, 1449 }, -- T.Whiteshell          (24%)
            { cexi.rate.VERY_COMMON,  689 }, -- Lauan Log             (24%)
        },
        defender =
        {
            { 310.774, -29.500, -118.595,  21 },
            { 304.452, -29.950, -120.200,  51 },
            { 299.733, -29.768, -120.616, 112 },
            { 294.327, -29.797, -116.571,  82 },
            { 290.349, -30.617, -110.233, 116 },
            { 313.229, -29.727, -124.992,  42 },
            { 318.168, -30.059, -123.869,  10 },
            { 321.768, -30.000, -119.308,  28 },
            { 319.802, -29.634, -113.018, 164 },
            { 326.825, -28.978, -112.980, 176 },
            { 324.137, -29.777, -105.830, 233 },
            { 320.466, -29.800,  -99.226, 212 },
            { 314.450, -29.692,  -98.557, 142 },
            { 316.999, -29.500,  -91.194, 202 },
            { 309.458, -28.353,  -90.475, 163 },
        },
        attacker =
        {
            { 332.498, -24.798, -134.066, 158 },
            { 330.995, -23.481, -139.870, 157 },
            { 341.911, -21.783, -132.185, 162 },
            { 337.680, -23.896, -130.580, 150 },
            { 336.571, -25.590, -125.221, 170 },
            { 332.217, -26.245, -127.840, 135 },
            { 339.243, -20.906, -144.667, 148 },
            { 336.799, -20.482, -149.124, 158 },
            { 344.841, -20.668, -139.391, 159 },
            { 348.415, -20.168, -138.435, 219 },
            { 350.646, -19.972, -143.918, 140 },
            { 346.412, -21.044, -127.716, 136 },
        },
    },
    [xi.zone.JUGNER_FOREST_S] =
    {
        music    = { 0, 0, 101, 215 },
        chest    = { 71.262, 0.400, -10.487, 228 },
        items    =
        {
            { cexi.rate.VERY_COMMON, 1452 }, -- O.Bronzepiece         (24%)
            { cexi.rate.VERY_COMMON, 1455 }, -- One Byne Bill         (24%)
            { cexi.rate.VERY_COMMON, 1449 }, -- T.Whiteshell          (24%)
            { cexi.rate.VERY_COMMON,  689 }, -- Lauan Log             (24%)
        },
        defender =
        {
            { 71.5540, 0.5723, -14.3294, 244 },
            { 64.2865, 0.5279,  -6.6730, 171 },
            { 47.7580, 0.2691,  -5.6650, 167 },
            { 39.2335, 0.1871,  -7.7645,   9 },
            { 44.2635, 0.8663, -22.0278, 103 },
            { 42.7592, 0.0216, -35.5473,  77 },
            { 51.1296, 0.3500, -36.0839, 244 },
            { 70.1544, 0.2912, -36.4474,   3 },
            { 73.1937, 0.5550, -29.0422, 240 },
            { 76.4017, 0.9691, -20.5950,   2 },
            { 85.8880, 0.4244, -14.2877, 246 },
            { 75.1536, 0.0899,   3.4548, 196 },
        },
        attacker =
        {
            { 124.8249,  0.2708, 29.7325, 108 },
            { 130.7036,  0.3508, 19.3699,  90 },
            { 125.2486,  0.2433, 11.4862, 100 },
            { 117.3974,  1.0149, 17.0991, 133 },
            { 109.7956,  1.5828, 25.4355, 100 },
            { 117.3410,  0.3225, 50.4709,  87 },
            { 105.5014, -1.2826, 51.7473,  87 },
            {  95.8312, -3.8503, 54.1748,  91 },
            { 115.3864,  0.6446, 61.6078,  94 },
            { 123.3199,  0.0991, 59.8282,  58 },
            { 135.3644,  0.8349, 52.4788,  92 },
            { 146.4848,  0.2396, 44.0130, 102 },
        },
    },
    [xi.zone.NORTH_GUSTABERG_S] =
    {
        music    = { 253, 253, 101, 215 },
        chest    = { -549.911, 39.477, 64.165, 0 },
        items    =
        {
            { cexi.rate.VERY_COMMON,  640 }, -- Copper Ore            (24%)
            { cexi.rate.UNCOMMON,    1452 }, -- O.Bronzepiece         (10%)
            { cexi.rate.UNCOMMON,    1455 }, -- One Byne Bill         (10%)
            { cexi.rate.UNCOMMON,    1449 }, -- T.Whiteshell          (10%)
        },
        defender =
        {
            { -551.4673, 40.2253, 71.0747, 238 },
            { -557.3380, 40.0000, 79.9618, 192 },
            { -567.2735, 39.0236, 87.2699, 181 },
            { -576.6789, 39.8738, 77.4991, 141 },
            { -581.7320, 39.4890, 69.7548,  60 },
            { -583.4304, 39.3992, 64.7534, 107 },
            { -583.5961, 39.9547, 56.1699, 153 },
            { -573.9128, 41.1483, 52.7933,  17 },
            { -567.0217, 40.1333, 46.1489,  53 },
            { -554.4638, 40.6175, 48.0330,  25 },
            { -549.8489, 41.8077, 52.6959,   3 },
            { -543.1235, 42.3172, 58.6495,   3 },
        },
        attacker =
        {
            { -504.7327, 41.3595,  95.3642, 114 },
            { -509.7391, 42.8050, 101.8010, 140 },
            { -515.3355, 41.2152, 109.7049, 116 },
            { -515.8635, 39.9027, 124.4447, 128 },
            { -522.2148, 39.7769, 130.2679,  60 },
            { -487.7961, 39.9512, 110.4291,  95 },
            { -478.8181, 42.4062,  98.5990,  85 },
            { -472.0407, 40.7249,  91.9673, 115 },
            { -466.0094, 40.0126,  79.7285, 101 },
            { -452.2469, 38.6356,  73.8246, 175 },
            { -449.4079, 40.5312,  95.1134, 119 },
            { -455.6943, 41.6037, 105.2032,  98 },
        },
    },
    [xi.zone.PASHHOW_MARSHLANDS_S] =
    {
        music    = { 0, 0, 101, 215 },
        chest    = { 447.549, 24.826, 404.032, 200 },
        items    =
        {
            { cexi.rate.VERY_COMMON,  640 }, -- Copper Ore            (24%)
            { cexi.rate.UNCOMMON,    1452 }, -- O.Bronzepiece         (10%)
            { cexi.rate.UNCOMMON,    1455 }, -- One Byne Bill         (10%)
            { cexi.rate.UNCOMMON,    1449 }, -- T.Whiteshell          (10%)
        },
        defender =
        {
            { 429.6588, 24.6076, 406.5809, 162 },
            { 428.0288, 24.4563, 392.9685, 117 },
            { 422.8304, 24.3863, 385.8771, 104 },
            { 434.8317, 24.6195, 377.4032,  78 },
            { 445.0688, 24.7675, 370.3423,  51 },
            { 457.5004, 24.2289, 373.0513,  22 },
            { 462.9498, 23.9193, 383.6817, 230 },
            { 463.2133, 24.5330, 394.9377, 153 },
            { 461.4662, 24.6118, 402.9957, 195 },
            { 471.0639, 24.7397, 408.4225, 221 },
            { 446.3415, 24.8310, 407.3582, 164 },
            { 435.4137, 24.8196, 410.4033, 205 },
        },
        attacker =
        {
            { 476.1312, 25.0000, 452.3886,  83 },
            { 486.5958, 25.0000, 444.9643,  26 },
            { 490.2938, 25.0000, 437.8010,  51 },
            { 496.2873, 25.0000, 433.9920, 114 },
            { 508.7108, 25.0000, 437.5218,  63 },
            { 497.2941, 25.0000, 447.8336,  93 },
            { 487.7308, 25.0000, 451.8475, 110 },
            { 479.1258, 24.6381, 458.0162,  99 },
            { 472.4663, 25.0000, 451.2758,  96 },
            { 463.4759, 24.6445, 459.6415, 110 },
            { 467.8387, 25.0000, 465.7186,  66 },
            { 485.6271, 25.0000, 464.9509,  75 },
        },
    },
    [xi.zone.WEST_SARUTABARUTA_S] =
    {
        music    = { 141, 141, 101, 215 },
        chest    = { -14.889, -12.807, 309.589, 128 },
        items    =
        {
            { cexi.rate.VERY_COMMON,  833 }, -- Moko Grass            (24%)
            { cexi.rate.UNCOMMON,    1452 }, -- O.Bronzepiece         (10%)
            { cexi.rate.UNCOMMON,    1455 }, -- One Byne Bill         (10%)
            { cexi.rate.UNCOMMON,    1449 }, -- T.Whiteshell          (10%)
        },
        defender =
        {
            { -15.4956, -12.5000, 312.3914, 116 },
            { -19.9309, -12.8309, 320.4900, 147 },
            {  -7.1280, -12.8438, 328.1854, 230 },
            {  -3.1559, -13.1976, 339.1356, 192 },
            {  10.4951, -14.5355, 331.3063,  36 },
            {  20.1092, -16.2938, 323.8667,   4 },
            {  15.7149, -14.9880, 312.4055,  39 },
            {  24.3969, -16.2921, 312.9700, 243 },
            {  20.9056, -15.6002, 297.0389,  68 },
            {  11.3443, -13.0059, 289.0060,  83 },
            {   0.6071, -12.5619, 292.4500,  98 },
            {  -9.0618, -13.6474, 298.2640, 125 },
        },
        attacker =
        {
            {  -71.9394, -16.3076, 340.6168,  14 },
            {  -67.9809, -14.8550, 347.5158, 241 },
            {  -62.1576, -14.2750, 353.5009, 255 },
            {  -61.5638, -14.3757, 363.6572,  17 },
            {  -72.3011, -15.5697, 364.4319,  23 },
            {  -94.7886, -17.1183, 341.1643,   1 },
            {  -98.1117, -16.8699, 333.6005,  99 },
            {  -99.0855, -17.2211, 323.8398,  55 },
            { -109.0817, -16.8713, 328.6888,  23 },
            { -112.9454, -17.0235, 347.3599, 196 },
            { -104.8367, -15.5000, 356.7084,  21 },
            { -119.8363, -16.2205, 367.5001,  22 },
        },
    },
    [xi.zone.MERIPHATAUD_MOUNTAINS_S] =
    {
        music    = { 0, 0, 101, 215 },
        chest    = { -302.131, 17.297, 430.404, 128 },
        items    =
        {
            { cexi.rate.VERY_COMMON,  833 }, -- Moko Grass            (24%)
            { cexi.rate.UNCOMMON,    1452 }, -- O.Bronzepiece         (10%)
            { cexi.rate.UNCOMMON,    1455 }, -- One Byne Bill         (10%)
            { cexi.rate.UNCOMMON,    1449 }, -- T.Whiteshell          (10%)
        },
        defender =
        {
            { -301.9181, 17.3413, 425.8704, 108 },
            { -297.4528, 16.9081, 421.3748,  49 },
            { -292.8454, 17.6861, 410.5381,  58 },
            { -284.0772, 16.3300, 409.2331,  23 },
            { -277.3953, 16.1554, 419.5312, 228 },
            { -276.3583, 16.1320, 426.9496, 198 },
            { -278.4431, 16.0000, 436.6650, 181 },
            { -286.0982, 16.0197, 444.2347, 137 },
            { -295.9341, 15.8874, 447.5950, 124 },
            { -305.7360, 16.0908, 446.1041, 110 },
            { -307.8033, 16.4088, 437.7720,  95 },
            { -298.0560, 16.9771, 425.2574,  70 },
        },
        attacker =
        {
            { -230.3021,  7.7416, 389.7814, 138 },
            { -236.6470,  4.4808, 382.3167, 145 },
            { -238.4758,  2.4020, 373.8025, 142 },
            { -238.9961,  0.0000, 362.3398, 164 },
            { -223.7010,  0.3043, 362.3847, 153 },
            { -222.9182, -0.1418, 369.8978, 172 },
            { -217.1437,  0.0307, 376.9588, 160 },
            { -218.8785,  6.3608, 387.5438, 143 },
            { -222.7171,  8.8631, 400.5580, 143 },
            { -224.8380,  7.0669, 408.0455, 122 },
            { -240.8026,  8.0000, 401.9750, 133 },
            { -249.0692,  8.0755, 408.1644, 145 },
        },
    },
}

xi.campaign.basicResist =
{
    mods =
    {
        [xi.mod.STUNRES]     = 100,
        [xi.mod.BLINDRES]    = 100,
        [xi.mod.BINDRES]     = 100,
        [xi.mod.GRAVITYRES]  = 100,
        [xi.mod.SLEEPRES]    = 100,
        [xi.mod.POISONRES]   = 100,
        [xi.mod.PARALYZERES] = 100,
        [xi.mod.LULLABYRES]  = 100,
    },

    effects =
    {
        [xi.effect.REGAIN] = { 5, 3, 0 },
    },
}

xi.campaign.mods =
{
    ['Ashmea_B_Greinner'] =
    {
        mods    =
        {
            [xi.mod.VIT] = 30,
        },
        effects =
        {
            [xi.effect.REFRESH] = { 5, 3, 0 },
        },
    },
}

return m
