-----------------------------------
-- Beast Raising - NM Unlocks
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("beast_raising_nm_unlocks")

local vars =
{
    unlocked = "[BEAST]UNLOCKED",
}

for index, pet in pairs(cexi.job.bst.beasts) do
    for _, sourceInfo in pairs(pet.from) do
        cexi.util.ensureMob(sourceInfo[1], sourceInfo[2])

        m:addOverride(fmt("xi.zones.{}.mobs.{}.onMobDeath", sourceInfo[1], sourceInfo[2]), function(mob, player, isKiller)
            super(mob, player, isKiller)

            if not player:isPC() then
                return
            end

            if mob:getLocalVar("ROLLED_BEAST") > 0 then
                return
            end

            mob:setLocalVar("ROLLED_BEAST", 1)

            if math.random(0, 1000) < sourceInfo[3] then
                local zoneID   = player:getZoneID()
                local alliance = player:getAlliance()

                for _, member in pairs(alliance) do
                    if
                        member:getZoneID() == zoneID and
                        member:getMainJob() == xi.job.BST
                    then
                        local unlocks = member:getCharVar(vars.unlocked)

                        if not utils.mask.getBit(unlocks, index) then
                            local updated = utils.mask.setBit(unlocks, index, true)
                            member:setCharVar(vars.unlocked, updated)
                            member:sys("You have unlocked the ability to raise {}!", pet.name)
                        end
                    end
                end
            end
        end)
    end
end

return m
