-----------------------------------
-- Beast Raising - Call Beast
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("beast_raising_call_beast")

m:addOverride("xi.actions.abilities.call_beast.onUseAbility", function(player, target, ability)
    super(player, target, ability)

    local pet = player:getPet()

    if pet == nil then
        return
    end

    local index = cexi.job.bst.beastLookup[pet:getName()]

    if index == nil then
        return
    end

    local petInfo = cexi.job.bst.beasts[index]

    if petInfo == nil then
        return
    end

    local tier = math.floor(player:getCharVar(fmt("[BEAST]{}", petInfo.name)) / 10)
    tier = utils.clamp(tier, 0, 5)

    if tier > 0 then
        player:sys("{} comes ready for battle! ({}: {})", petInfo.name, petInfo.desc, string.rep("\129\154", tier))

        for modID, modValue in pairs(petInfo.mods) do
            pet:addMod(modID, modValue[tier])
        end

        if tier >= 5 then
            player:sys("{} inspires allies! ({})", petInfo.name, petInfo.buff.name)
            pet:addMod(xi.mod.AURA_SIZE, 1500) -- Adds 15' to Auras
            pet:addStatusEffectEx(petInfo.buff.effect, petInfo.buff.effect, petInfo.buff.amount, 3, 0, petInfo.buff.effect, petInfo.buff.amount, xi.auraTarget.ALLIES, xi.effectFlag.AURA)
        end
    end
end)

return m
