-----------------------------------
-- Beast Raising - Buried Treasure
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("beast_raising_buried_treasure")

local function getName(str)
    return string.gsub(str, "_", " ")
end

for _, pet in pairs(cexi.job.bst.beasts) do
    for index, mobInfo in pairs(pet.mobs) do
        cexi.util.ensureMob(mobInfo[1], mobInfo[2])

        m:addOverride(fmt("xi.zones.{}.mobs.{}.onMobDeath", mobInfo[1], mobInfo[2]), function(mob, player, isKiller)
            super(mob, player, isKiller)

            if not player:isPC() then
                return
            end

            if player:getCharVar("[BEAST]ACTIVITY_ROLL") == index then
                local current = player:getCharVar("[BEAST]MOBS")
                local updated = current +1

                player:setCharVar("[BEAST]MOBS", updated)

                if updated < mobInfo[3] then
                    player:sys("Beast Raising Activity [{}] {}/{} ({} in {})", pet.name, updated, mobInfo[3], getName(mobInfo[2]), getName(mobInfo[1]))
                else
                    player:sys("Beast Raising Activity [{}] Complete! Return to the Bestiary Book", pet.name)
                end
            end
        end)
    end
end

return m
