-----------------------------------
-- Beast Raising - Buried Treasure
-----------------------------------
require("modules/module_utils")
require("scripts/globals/npc_util")
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("beast_raising_buried_treasure")

-- Locations of buried items
local locations =
{
    ["La_Theine_Plateau"] =
    {
        { -638.6077, 0.3097, 587.9549 },
        { -691.7823, 3.6321, 555.7835 },
        { -645.2256, 3.0952, 469.3940 },
        { -641.8928, 16.9018, 418.0569 },
        { -613.2701, 16.5228, 363.7530 },
        { -687.9911, 16.4269, 312.8977 },
        { -745.0386, 16.9380, 366.7822 },
        { -790.2850, 16.2791, 436.0782 },
        { -804.3282, 15.8395, 561.9351 },
        { -732.2684, 16.4222, 642.5706 },
        { -410.8013, -8.7081, 375.9962 },
        { -339.1855, 1.5512, 386.1894 },
        { -277.5185, 8.8237, 423.5049 },
        { -240.9078, 3.9247, 348.8324 },
        { -200.5264, 7.0817, 406.2898 },
        { -305.8228, 8.6135, 237.6171 },
        { -236.6946, 8.9126, 178.2730 },
        { -251.3020, 8.4812, 92.7427 },
        { -320.9118, 8.0449, 120.7447 },
        { -382.7454, 8.6662, 121.5114 },
        { -406.7767, 8.5894, 186.3516 },
        { -464.3515, -7.8278, 156.7742 },
        { -457.2738, -13.2837, 64.5541 },
        { -344.7265, -14.5018, 15.8502 },
        { -253.6696, -9.7618, -29.7538 },
        { -190.6260, -8.8661, -62.1752 },
        { -171.2086, -7.3248, -88.7090 },
        { -219.6181, -11.9188, -155.3091 },
        { -291.1199, -13.0520, -157.4199 },
        { -345.5279, -1.2182, -171.2538 },
        { -393.7574, 0.6250, -136.5571 },
        { -421.0011, 1.0389, -85.4663 },
        { -466.3048, 0.5653, -42.4712 },
        { -513.6858, 0.6508, -23.4444 },
        { -572.6494, 0.4419, -46.0534 },
        { -596.7145, 0.0000, -78.6180 },
        { -533.0277, 0.4986, -118.2852 },
        { -491.2155, -1.1714, -173.9268 },
        { -479.1846, 0.1481, -233.0153 },
        { -411.7269, 0.4357, -239.0690 },
        { -358.9825, 0.5967, -225.9903 },
        { -245.9929, -7.8351, -42.9964 },
        { -176.3767, -8.4387, -144.1841 },
        { -136.1462, -3.3625, -198.9039 },
        { -78.1078, -0.8015, -189.6401 },
        { -34.3635, 8.0899, -110.8992 },
        { -49.5912, -0.6383, -23.3108 },
        { -4.8895, 16.0323, 39.9047 },
        { 29.3758, 16.8194, 62.6918 },
        { 73.3399, 16.3159, 151.8266 },
        { -12.9027, 16.6684, 161.2735 },
        { -51.5792, 16.3778, 159.8429 },
        { -149.0065, 8.4575, 195.3584 },
        { -207.2118, 8.1595, 118.9032 },
    },
    ["Konschtat_Highlands"] =
    {
        { -259.6368, 70.5208, 825.8882 },
        { -261.9263, 67.9862, 783.7797 },
        { -211.5537, 72.1491, 758.1414 },
        { -186.6173, 71.9468, 724.2040 },
        { -138.3478, 71.8772, 704.4968 },
        { -79.4995, 67.1796, 658.5438 },
        { -99.7788, 63.4807, 585.2463 },
        { -148.3843, 61.0492, 574.4708 },
        { -220.2633, 61.4456, 572.2555 },
        { -297.9604, 58.2269, 583.9811 },
        { -219.6941, 60.5605, 511.6017 },
        { -285.4388, 50.2603, 460.5033 },
        { -261.6354, 35.0275, 359.4266 },
        { -339.8745, 33.9282, 344.3890 },
        { -401.8372, 23.9914, 323.8484 },
        { -473.3333, 15.5972, 310.9230 },
        { -476.3325, 15.9784, 243.8282 },
        { -516.0261, 14.2992, 229.0040 },
        { -476.6725, 8.0860, 164.7402 },
        { -446.7700, 13.0116, 104.3971 },
        { -509.0862, 1.4012, 72.5292 },
        { -536.4923, 5.5353, 10.6250 },
        { -439.5521, 9.3717, -15.5970 },
        { -339.3896, 12.4076, -21.2541 },
        { -209.4061, -8.7199, -110.0643 },
        { -104.5991, -28.7201, -191.3802 },
        { -184.7462, -38.2747, -268.1181 },
        { -290.1634, -39.7460, -283.7681 },
        { -388.6650, -37.2485, -306.1365 },
        { -233.8185, 7.7208, 0.1003 },
        { -284.1699, 15.7662, 87.7548 },
        { -237.4949, 16.1287, 126.5966 },
        { -233.9297, 17.1352, 174.3881 },
        { -149.4693, 17.9116, 173.1685 },
        { -85.7201, 11.2285, 102.7917 },
        { -49.9430, 22.0551, 117.4742 },
        { -8.0206, 24.4080, 206.8436 },
        { -12.8400, 26.7579, 277.6129 },
        { 32.6344, 32.3072, 334.0405 },
        { -74.4599, 32.1920, 388.9575 },
        { -65.6372, 46.6872, 492.8862 },
        { -32.1936, 68.2380, 568.8572 },
        { -116.2794, 75.2277, 621.4602 },
    },
    ["Tahrongi_Canyon"] =
    {
        { 357.0571, -7.5589, -72.4286 },
        { 293.0396, -15.5002, -79.9457 },
        { 241.3813, -15.9745, -75.4683 },
        { 221.0131, -16.1978, -124.8058 },
        { 197.6475, -24.0000, -159.4682 },
        { 156.5627, -8.8212, -129.3767 },
        { 126.2451, -8.2878, -161.7964 },
        { 111.2686, -8.0034, -224.8042 },
        { 79.5049, -15.7629, -205.9514 },
        { 47.5090, -15.2238, -153.1998 },
        { 17.2718, -5.1433, -116.3221 },
        { -8.2184, -14.1567, -152.5251 },
        { -31.7253, -15.7873, -198.6565 },
        { -74.5866, -9.2263, -234.4452 },
        { -86.2700, -15.9442, -168.5885 },
        { -126.9880, -15.9725, -114.8882 },
        { -147.8171, -15.5919, -123.1966 },
        { -182.5922, -15.3495, -107.7866 },
        { -198.6951, -15.4130, -146.0886 },
        { -238.7283, -24.0000, -157.1842 },
        { -233.8705, -23.9470, -108.7699 },
        { -259.9275, -24.0000, -75.5666 },
        { -257.4936, -11.3093, -31.2103 },
        { -218.8217, -4.2863, 2.0519 },
        { -212.7904, 5.9760, 40.9562 },
        { -229.8434, 2.0222, 76.6138 },
        { -269.0364, -6.8268, 75.7232 },
        { -312.9645, -0.4512, 108.4469 },
        { -251.2940, 8.1523, 126.7800 },
        { -196.0580, 8.7346, 151.6210 },
        { -144.3790, 12.5605, 119.7492 },
        { -110.8639, 15.6346, 171.5865 },
        { -117.2120, 16.1720, 224.4944 },
        { -79.9358, 27.8666, 261.6095 },
        { -99.6455, 28.3256, 310.7338 },
        { -175.9105, 16.6769, 320.4659 },
        { -232.3198, 8.6259, 323.2570 },
        { -227.7960, 20.3956, 383.2099 },
        { -297.6222, 15.9247, 368.6241 },
        { -356.9469, 16.0000, 365.3198 },
        { -399.3230, 16.1811, 409.0933 },
        { -436.8109, 15.9291, 436.3767 },
        { -300.8854, 25.6427, 471.6171 },
        { -267.5126, 32.2405, 508.6562 },
        { -205.8628, 40.1144, 506.5932 },
        { -158.2292, 32.0000, 478.4516 },
        { -140.0101, 24.7116, 410.9985 },
        { -89.2695, 24.1933, 439.5950 },
        { -38.0007, 26.7350, 382.9434 },
        { 18.8543, 24.7747, 398.7824 },
        { 68.2621, 36.8628, 433.3802 },
        { 53.9273, 39.8019, 509.2444 },
        { 130.8849, 48.2311, 500.9619 },
        { 73.1529, 39.9384, 348.4635 },
        { 45.5900, 24.7127, 244.8232 },
        { 122.9745, 28.3227, 213.0817 },
        { 185.3540, 30.2592, 187.1231 },
        { 238.7098, 16.0000, 160.9952 },
        { 288.7507, 24.6888, 208.1977 },
        { 327.8579, 28.0219, 295.3383 },
        { 297.1405, 40.1606, 330.8447 },
        { 317.2970, 33.4428, 411.6313 },
        { 277.4025, 40.0408, 472.5443 },
        { 384.9688, 44.5000, 493.6472 },
    },
}

m:addOverride("xi.player.onPlayerEmote", function(player, emoteId)
    super(player, emoteId)

    if emoteId ~= xi.emote.THINK then
        return
    end

    local zoneID = player:getZoneID()

    if player:getCharVar("[BEAST]TREASURE") == zoneID then
        local location = player:getCharVar("[BEAST]ACTIVITY_ROLL")

        if location == 0 then
            location = math.random(1, #locations[cexi.zoneName[zoneID]])
            player:setCharVar("[BEAST]ACTIVITY_ROLL", location)
        end

        if player:getCharVar("[BEAST]FOUND") == 1 then
            player:fmt("You've already found the buried item.")
            return
        end

        if cexi.skill.digTreasure(player, locations[cexi.zoneName[zoneID]][location]) then
            player:timer(2000, function()
                player:sys("You found the buried item! Return to the Beastiary Book")
                player:setCharVar("[BEAST]FOUND", 1, JstMidnight())
            end)
        end
    end
end)

return m
