-----------------------------------
-- Anti-cheat module for CXI

-- debug testing commands
-- !exec target:setCharVar('[LB3Davoi]Cheat', 0)
-- !exec target:setCharVar('[LB3Cavern]Cheat', 0)
-- !exec target:setCharVar('[LB3Altar]Cheat', 0)
-- !exec target:setCharVar('[LB3Dome]Cheat', 0)
-- !exec target:setCharVar('[LB3Davoi]Tractor', 0)
-- !exec target:setCharVar('[LB3Oztroja]Tractor', 0)
-- !exec target:setCharVar('[LB3Dome]Tractor', 0)
-- !exec target:setCharVar('[LB3Davoi]CheatAttempts', 0)
-- !exec target:setCharVar('[LB3Cavern]CheatAttempts', 0)
-- !exec target:setCharVar('[LB3Altar]CheatAttempts', 0)
-- !exec target:setCharVar('[LB3Dome]CheatAttempts', 0)

-- testing commands
-- !addkeyitem CREST_OF_DAVOI
-- !addkeyitem YAGUDO_TORCH
-- !addkeyitem SILVER_BELL
-- !addkeyitem BLACK_MATINEE_NECKLACE
-- !addkeyitem CORUSCANT_ROSARY
-- !delkeyitem CREST_OF_DAVOI
-- !delkeyitem YAGUDO_TORCH
-- !delkeyitem SILVER_BELL
-- !delkeyitem CORUSCANT_ROSARY
-- !delkeyitem BLACK_MATINEE_NECKLACE
-- !gotoid 17387983
-- !gotoid 17391830
-- !gotoid 17399839
-- !gotoid 17383458
-- !pos -99 24 -105 151
-- !pos 60 24 -2 148
-----------------------------------
require("modules/module_utils")
require("scripts/globals/npc_util")
-----------------------------------

local m = Module:new("anti-cheat")

local function davoiCheatAttempt(player)
    if
        player:hasKeyItem(xi.ki.CREST_OF_DAVOI) or
        player:getCharVar('[LB3Davoi]Tractor') == 1
    then
        return false
    else
        return true
    end
end

local function altarCheatAttempt(player)
    if
        player:hasKeyItem(xi.ki.YAGUDO_TORCH) or
        player:getCharVar('[LB3Oztroja]Tractor') == 1
    then
        return false
    else
        return true
    end
end

local function domeCheatAttempt(player)
    if
        player:hasKeyItem(xi.ki.SILVER_BELL) and
        player:hasKeyItem(xi.ki.CORUSCANT_ROSARY) and
        player:hasKeyItem(xi.ki.BLACK_MATINEE_NECKLACE) or
        player:getCharVar('[LB3Dome]Tractor') == 1
    then
        return false
    else
        return true
    end
end

-- Zone Logic

m:addOverride("xi.zones.Davoi.Zone.onInitialize", function(zone)
    super(zone)

    -- This radius was extensivly tested to ensure that it would not trigger on accident
    -- players within the defined radius will be warped to the entrance of the gate 1 time as a visual warning
    -- a variable is set to prevent the player from being warped again but will flag the attempt
    zone:registerTriggerArea(1, -22.094, 10.5, -81.118, 0, 0, 0) -- DOORID: 17387983
end)

m:addOverride("xi.zones.Davoi.Zone.onTriggerAreaEnter", function(player, triggerArea)
    super(player, triggerArea)

    local triggerAreaID = triggerArea:GetTriggerAreaID()

    -- If a player is tractored into the triggerArea, they will be dead
    if triggerAreaID == 1 then
        if player:isDead() then
            player:setCharVar('[LB3Davoi]Tractor', 1) -- Store a charVar on the player to keep a record of the tractor
        end

        if player:getCharVar('[LB3Davoi]Cheat') == 1 and davoiCheatAttempt(player) == true then
            player:setCharVar('[LB3Davoi]CheatAttempts', player:getCharVar('[LB3Davoi]CheatAttempts') + 1) -- increment the cheat attempts
            player:setPos(-23.067, 1.519, -68.381, 185) -- warp them to the entrance of the Wall of Dark Arts
        end

        if davoiCheatAttempt(player) == false then
            return
        elseif player:getCharVar('[LB3Davoi]Cheat') == 0 then -- Cheat Attempt
            player:setPos(-23.067, 1.519, -68.381, 185) -- warp them to the entrance of the Wall of Dark Arts
            player:setCharVar('[LB3Davoi]Cheat', 1)
            printf(string.format('[ANTI-CHEAT] %s has bypassed the Wall of Dark Arts in Davoi.', player:getName()))
        end
    end
end)

m:addOverride("xi.zones.Monastic_Cavern.Zone.onInitialize", function(zone)
    super(zone)

    -- You can not be within this radius without meeting the requirements to enter the area
    zone:registerTriggerArea(1, -160.899, 10, 7.8, 0, 0, 0) -- MAGICITE: 17391830
end)

m:addOverride("xi.zones.Monastic_Cavern.Zone.onTriggerAreaEnter", function(player, triggerArea)
    super(player, triggerArea)

    local triggerAreaID = triggerArea:GetTriggerAreaID()

    -- If a player is tractored into the triggerArea, they will be dead and get the Var from the prior zone
    if triggerAreaID == 1 then

        if player:getCharVar('[LB3Cavern]Cheat') == 1 and davoiCheatAttempt(player) == true then
            player:setCharVar('[LB3Cavern]CheatAttempts', player:getCharVar('[LB3Cavern]CheatAttempts') + 1) -- increment the cheat attempts
            player:setPos(-23.067, 1.519, -68.381, 185, 149) -- warp them to the entrance of the Wall of Dark Arts
        end

        if davoiCheatAttempt(player) == false then
            return
        elseif player:getCharVar('[LB3Cavern]Cheat') == 0 then -- Cheat Attempt
            player:setCharVar('[LB3Cavern]Cheat', 1)
            player:setPos(-23.067, 1.519, -68.381, 185, 149) -- warp them to the entrance of the Wall of Dark Arts
            printf(string.format('[ANTI-CHEAT] %s has triggered the check in Monastic Caverns.', player:getName()))
        end
    end
end)

m:addOverride("xi.zones.Castle_Oztroja.Zone.onInitialize", function(zone)
    super(zone)

    zone:registerTriggerArea(1, -99.250, 10, -119.700, 0, 0, 0)
end)

m:addOverride("xi.zones.Castle_Oztroja.Zone.onTriggerAreaEnter", function(player, triggerArea)
    super(player, triggerArea)

    local triggerAreaID = triggerArea:GetTriggerAreaID()

    if triggerAreaID == 1 then
        if player:isDead() then
            player:setCharVar('[LB3Oztroja]Tractor', 1)
        end
    end
end)

m:addOverride("xi.zones.Altar_Room.Zone.onInitialize", function(zone)
    super(zone)

    zone:registerTriggerArea(1, -346, 15, 42, 0, 0, 0) -- MAGICITE: 17399839
end)

m:addOverride("xi.zones.Altar_Room.Zone.onTriggerAreaEnter", function(player, triggerArea)
    super(player, triggerArea)

    local triggerAreaID = triggerArea:GetTriggerAreaID()

    if triggerAreaID == 1 then

        if player:getCharVar('[LB3Altar]Cheat') == 1 and altarCheatAttempt(player) == true then
            player:setCharVar('[LB3Altar]CheatAttempts', player:getCharVar('[LB3Altar]CheatAttempts') + 1)
            player:setPos(752.632, -32, -40.035, 129, 119) -- warp them to the entrance of Castle Oztroja
        end

        if altarCheatAttempt(player) == false then
            return
        elseif player:getCharVar('[LB3Altar]Cheat') == 0 then
            player:setCharVar('[LB3Altar]Cheat', 1)
            player:setPos(752.632, -32, -40.035, 129, 119)
            printf(string.format('[ANTI-CHEAT] %s has triggered the check in the Altar Room.', player:getName()))
        end
    end
end)

m:addOverride("xi.zones.Qulun_Dome.Zone.onInitialize", function(zone)
    super(zone)

    zone:registerTriggerArea(1, 59.581, 10, -16.159, 0, 0, 0) -- Tractor check
    zone:registerTriggerArea(2, 10.756, 10, -81.188, 0, 0, 0) -- MAGICITE: 17383458
end)

m:addOverride("xi.zones.Qulun_Dome.Zone.onTriggerAreaEnter", function(player, triggerArea)
    super(player, triggerArea)

    local triggerAreaID = triggerArea:GetTriggerAreaID()

    if triggerAreaID == 1 then
        if player:isDead() then
            player:setCharVar('[LB3Dome]Tractor', 1)
        end

    elseif triggerAreaID == 2 then
        if player:getCharVar('[LB3Dome]Cheat') == 1 and domeCheatAttempt(player) == true then
            player:setCharVar('[LB3Dome]CheatAttempts', player:getCharVar('[LB3Dome]CheatAttempts') + 1)
            player:setPos(-278, 1, 100, 246, 147) -- Beadeaux entrance
        end

        if domeCheatAttempt(player) == false then
            return
        elseif player:getCharVar('[LB3Dome]Cheat') == 0 then
            player:setPos(-278, 1, 100, 246, 147)
            player:setCharVar('[LB3Dome]Cheat', 1)
            printf(string.format('[ANTI-CHEAT] %s has triggered the check in the Qulun Dome.', player:getName()))
        end
    end
end)

-- Send players in unwanted zones to their Home Point
local blockedZones =
{
    "Western_Adoulin",
    "Eastern_Adoulin",
}

for _, zoneName in pairs(blockedZones) do
    m:addOverride(fmt("xi.zones.{}.Zone.onZoneIn", zoneName), function(player, prevZone)
        player:warp()
    end)
end

return m
