----------------------------------------------
-- NPC: Greyson
--  Lower Jeuno
-- Mars/Venus Orb & Silver Voucher Redemption
----------------------------------------------
require('modules/module_utils')
require('scripts/globals/roe_records')
require('scripts/globals/roe')

local m = Module:new('aman_trove_greyson')

local path = "xi.zones.Lower_Jeuno.npcs.Greyson"
xi.module.ensureTable(path)

m:addOverride(path .. ".onTrade", function(player, npc, trade)
    local amanIntro = player:getCharVar('[AMAN]intro')

    if player:isCrystalWarrior() then
        player:printToPlayer("Unfortunately, I cannot help you.", 0, npc:getPacketName())
        return
    end

    if amanIntro == 0 then
        player:printToPlayer("Unfortunately, I cannot help you.", 0, npc:getPacketName())
        return
    end

    if
        amanIntro == 1 and
        (player:getEminenceCompleted(1447) or player:isClassicMode())
    then
        local voucherItem = 9277

        if npcUtil.tradeHas(trade, voucherItem) then
            local tradeQty = trade:getItemQty(voucherItem)
            local storedVouchers = player:getCharVar('[AMAN]silver_vouchers')

            trade:confirmItem(voucherItem, storedVouchers)
            -- player:confirmTrade()
            player:tradeComplete()
            player:setCharVar('[AMAN]silver_vouchers', storedVouchers + tradeQty)
            player:startEvent(20085, storedVouchers + tradeQty)
        end
    end
end)

m:addOverride(path .. ".onTrigger", function(player, npc)
    local storedVouchers   = player:getCharVar('[AMAN]silver_vouchers')
    local buyableVouchers  = player:getCharVar('[AMAN]purchased_vouchers')
    local amanIntro        = player:getCharVar('[AMAN]intro')
    local minPlayerAge     = 30
    local playerAge        = (os.time() - player:getTimeCreated()) / 86400
    local day              = tonumber(os.date('%d'))

    if player:isCrystalWarrior() then
        player:printToPlayer("Unfortunately, I cannot help you.", 0, npc:getPacketName())

        return
    end

    -- Check for account age and lvl 75
    if amanIntro == 0 then
        if playerAge < minPlayerAge then
            local daysRemaining = math.min(math.ceil(minPlayerAge - playerAge), 30)
            player:printToPlayer("You must wait another " .. daysRemaining .. " days before you are eligible for Aman Trove.", 0, npc:getPacketName())
        end

        if player:getMainLvl() < 75 then
            player:printToPlayer("You must reach Level 75 to be eligible for Aman Trove.", 0, npc:getPacketName())
        end

        if 
            playerAge < minPlayerAge or
            player:getMainLvl() < 75
        then
            return
        else
            player:setCharVar('[AMAN]intro', 1)
        end
    end

    -- Check if RoE objective has been satisfied
    if
        player:getEminenceCompleted(1447) or
        player:isClassicMode()
    then
        -- Main Menu
        player:startEvent(20084, storedVouchers, buyableVouchers, player:getGil())
        return
    end

    if player:getEminenceProgress(1447) then
        -- Introduction dialog
        player:startEvent(20083)
    else
        -- Default dialog (RoE not flagged)
        player:startEvent(20082)
    end
end)

m:addOverride(path .. ".onEventFinish", function(player, csid, option, npc)
    -- Set how many vouchers players are allowed to purchase each month
    local voucherAllowance  = 5
    local storedVouchers    = player:getCharVar('[AMAN]silver_vouchers')
    local purchasedVouchers = player:getCharVar('[AMAN]purchased_vouchers')
    local buyableVouchers   = (voucherAllowance - purchasedVouchers)
    local voucherItem       = 9277 -- Silver voucher
    local voucherCost       = 100000

    if csid == 20083 then
        if player:getEminenceProgress(1447) then
            xi.roe.onRecordTrigger(player, 1447)
        end
    end

    if csid == 20084 then
        print('[AMAN] Event: Option: ' .. option .. ' buyableVouchers: ' .. buyableVouchers .. ' -- Gil: ' .. player:getGil())
        -- Exchange vouchers for Orbs
        if
            -- Mars Orb
            option == 1 and
            storedVouchers >= 6
        then
            if npcUtil.giveItem(player, xi.item.MARS_ORB) then
                player:setCharVar('[AMAN]silver_vouchers', storedVouchers - 6)
            end
        elseif
            -- Venus Orb
            option == 2 and
            storedVouchers >= 10
        then
            if npcUtil.giveItem(player, xi.item.VENUS_ORB) then
                player:setCharVar('[AMAN]silver_vouchers', storedVouchers - 10)
            end
        elseif
            -- Purchasing 1 voucher with gil
            option == 3 and
            purchasedVouchers < voucherAllowance and
            player:getGil() >= voucherCost
        then
            if npcUtil.giveItem(player, voucherItem) then

                if purchasedVouchers == 0 then
                    player:setCharVar('[AMAN]purchased_vouchers', purchasedVouchers + 1, cexi.time.nextMonth())
                else
                    player:incrementCharVar('[AMAN]purchased_vouchers', 1)
                end
                player:delGil(voucherCost)

                print('[AMAN] Removing ' .. voucherCost .. ' gil from ' .. player:getName() .. ' for a single voucher. They\'ve purchased a total of ' .. purchasedVouchers + 1 .. '.')

                if purchasedVouchers + 1 == voucherAllowance then
                    print('[AMAN] ' .. player:getName() .. ' has purchased all of their silver vouchers.')
                end

                return
            end
        elseif
            -- Purchase as many vouchers as you can
            option == 4 and
            purchasedVouchers < voucherAllowance and
            player:getGil() >= voucherCost * buyableVouchers
        then
            if npcUtil.giveItem(player, { { voucherItem, buyableVouchers } }) then
                -- This should max out the player's purchased vouchers no matter what.

                if purchasedVouchers == 0 then
                    player:setCharVar('[AMAN]purchased_vouchers', voucherAllowance, cexi.time.nextMonth())
                else
                    player:incrementCharVar('[AMAN]purchased_vouchers', buyableVouchers)
                end

                player:delGil(voucherCost * buyableVouchers)

                print('[AMAN] Removing ' .. voucherCost * buyableVouchers .. ' gil for ' .. buyableVouchers .. ' from ' .. player:getName() .. ' for max allowable vouchers.')
                print('[AMAN] ' .. player:getName() .. ' has purchased all of their silver vouchers.')

                return
            end
        end
    end
end)

return m
