-----------------------------------
-- Death Trap
--
-- Description: Attempts to stun or poison any players in a large trap. Resets hate.
-- Type: Enfeebling
-- Utsusemi/Blink absorb: Ignores shadows
-- Range: 30' radial
-- Notes: Mods for Aman Trove use
-----------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
-----------------------------------
local m = Module:new("mobskill_death_trap")

xi.module.ensureTable("xi.actions.mobskills.death_trap")

m:addOverride("xi.actions.mobskills.death_trap.onMobSkillCheck", function(target, mob, skill)
    return 0
end)

m:addOverride("xi.actions.mobskills.death_trap.onMobWeaponSkill", function(target, mob, skill)
    local typeEffect = xi.effect.POISON
    local duration   = 60
    local power      = mob:getMainLvl() / 3

    if math.random() <= 0.5 then
        -- stun
        typeEffect = xi.effect.STUN
        duration   = 10
        power      = 1
    end

    skill:setMsg(xi.mobskills.mobStatusEffectMove(mob, target, typeEffect, power, 0, duration))

    mob:resetEnmity(target)
    if mob:getZoneID() == xi.zone.HORLAIS_PEAK and (mob:getName() == "Chest_OPlenty" or mob:getName() == "Coffer_OPlenty") then
        target:dispelStatusEffect(xi.effect.RERAISE)
        target:setHP(0)
    end
    return typeEffect
end)

return m