---------------------------------------
-- CatsEyeXI
-- BCNM: Amans Trove Venus
-- Mob: Coffer OPlenty
---------------------------------------
require('scripts/globals/battlefield')
require("modules/module_utils")
local venus  = require("modules/catseyexi/lua/additive_overrides/systems/aman_trove/aman_trove_global")
-----------------------------------
local m = Module:new("coffer_oplenty")

local path = "xi.zones.Horlais_Peak.mobs.Coffer_OPlenty"
xi.module.ensureTable(path)

m:addOverride(path .. ".onMobSpawn", function(mob)
    mob:setModelId(966)
    mob:hideName(true)
    mob:setStatus(xi.status.NORMAL)
    mob:setMobMod(xi.mobMod.NO_AGGRO, 1)
    mob:setMobMod(xi.mobMod.NO_LINK, 1)
    mob:setAnimationSub(0)

    venus.debugPrint("Mob spawned: " .. mob:getName() .. " with ID: " .. mob:getID())

    mob:addListener('ON_TRIGGER', 'MIMIC_MAGIC', function(player, mobArgOne)
        local bf = mobArgOne:getBattlefield()
        local bfID = bf:getID()
        local mimicID = bf:getLocalVar("mimicID")

        venus.debugPrint("MIMIC_MAGIC triggered for mob ID: " .. mobArgOne:getID() .. " in battlefield ID: " .. bfID)

        -- Check if mob ID matches mimic ID
        if mobArgOne:getID() == mimicID then
            venus.debugPrint("Mimic ID matches with mob ID: " .. mobArgOne:getID() .. ". Initiating mimic transformation and cleanup.")
            -- Perform actions if mob is a mimic
            venus.mimicAction(mobArgOne, player)
            venus.venusTerminalDespawn()
            venus.venusRemoveALLChests(mobArgOne)
        else
            venus.debugPrint("Mimic ID does not match with mob ID: " .. mobArgOne:getID() .. ". Regular chest opened.")
            -- Perform actions if mob is not a mimic
            local battlefield = mobArgOne:getBattlefield()
            venus.venusRollChestOutcome(player, battlefield, mobArgOne)
            venus.debugPrint("Reward incremented, round incremented, mimic randomized.")
            mobArgOne:setAnimationSub(1)
            mobArgOne:removeListener("MIMIC_MAGIC")
        end
    end)
end)

return m
