---------------------------------------
-- CatsEyeXI
-- BCNM: Amans Trove Mars
-- Mob: Chest OPlenty
---------------------------------------
require('scripts/globals/battlefield')
require("modules/module_utils")
local mars  = require("modules/catseyexi/lua/additive_overrides/systems/aman_trove/aman_trove_global")
-----------------------------------
local m = Module:new("chest_oplenty")

local path = "xi.zones.Horlais_Peak.mobs.Chest_OPlenty"
xi.module.ensureTable(path)

m:addOverride(path .. ".onMobSpawn", function(mob)
    mob:setModelId(966)
    mob:hideName(true)
    mob:setStatus(xi.status.NORMAL)
    mob:setMobMod(xi.mobMod.NO_AGGRO, 1)
    mob:setMobMod(xi.mobMod.NO_LINK, 1)
    mob:setAnimationSub(0)

    mars.debugPrint("Mob spawned: " .. mob:getName() .. " with ID: " .. mob:getID())

    mob:addListener('ON_TRIGGER', 'MIMIC_MAGIC', function(player, mobArgOne)
        local bf = mobArgOne:getBattlefield()
        local bfID = bf:getID()
        local mimicID = bf:getLocalVar("mimicID")

        mars.debugPrint("MIMIC_MAGIC triggered for mob ID: " .. mobArgOne:getID() .. " in battlefield ID: " .. bfID)

        -- Check if mob ID matches mimic ID
        if mobArgOne:getID() == mimicID then
            mars.debugPrint("Mimic ID matches with mob ID: " .. mobArgOne:getID() .. ". Initiating mimic transformation and cleanup.")
            -- Perform actions if mob is a mimic
            mars.mimicAction(mobArgOne, player)
            mars.marsTerminalDespawn()
            mars.marsRemoveALLChests(mobArgOne)
        else
            mars.debugPrint("Mimic ID does not match with mob ID: " .. mobArgOne:getID() .. ". Regular chest opened.")
            -- Perform actions if mob is not a mimic
            local battlefield = mobArgOne:getBattlefield()
            mars.marsRollChestOutcome(player, battlefield, mobArgOne)
            mars.debugPrint("Reward incremented, round incremented, mimic randomized.")
            mobArgOne:setAnimationSub(1)
            mobArgOne:removeListener("MIMIC_MAGIC")
        end
    end)
end)

return m
