-----------------------------------
-- CatsEyeXI
-- BCNM: Amans Trove
-- Area: Horlais Peak
--  NPC: Terminal_Coffer
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
local global  = require("modules/catseyexi/lua/additive_overrides/systems/aman_trove/aman_trove_global")
local loot  = require("modules/catseyexi/lua/additive_overrides/systems/aman_trove/aman_trove_loot")
-----------------------------------
local m = Module:new("aman_trove_terminal_coffer")

local path = "xi.zones.Horlais_Peak.npcs.Terminal_Coffer"
xi.module.ensureTable(path)

local function calculateTotalDropRate(set)
    local totalDropRate = 0
    for _, item in pairs(set) do
        totalDropRate = totalDropRate + (item.droprate or 0)
    end
    return totalDropRate
end

local function addTreasure(player, npc, set)
    local totalDropRate = calculateTotalDropRate(set)
    local randomRoll = math.random(totalDropRate)
    local cumulativeRate = 0

    for _, item in pairs(set) do
        cumulativeRate = cumulativeRate + (item.droprate or 0)
        if randomRoll <= cumulativeRate and item.itemid ~= 0 then
            player:addTreasure(item.itemid, npc)
            break
        end
    end
end

local function handleLootDistribution(player, npc, bf)
    local reward = bf:getLocalVar('reward')
    local tier = math.floor(reward / 15) * 15  -- Calculate the tier based on reward

    local battlefieldId = bf:getID()
    local tierLoot

    if battlefieldId == 25 then  -- A.M.A.N. Trove (Venus)
        tierLoot = loot.venusLoot[tier]
    elseif battlefieldId == 24 then  -- A.M.A.N. Trove (Mars)
        tierLoot = loot.marsLoot[tier]
    end

    if tierLoot then
        for _, slot in pairs(tierLoot) do
            addTreasure(player, npc, slot)  -- Distribute loot for each slot
        end
    end
end

local function handleJackpot(player)
    if math.random(100) <= global.jackpotChance then
        player:addGil(global.jackpotReward)
        player:messageSpecial(7979, global.jackpotReward)
        return true
    end
    return false
end

m:addOverride(path .. ".onTrigger", function(player, npc)
    local bf = player:getBattlefield()
    if bf:getLocalVar('rewardReceived') == 2 then
        return
    end

    if bf:getLocalVar('reward') > 0 then
        npc:entityAnimationPacket('openH')
        local round = bf:getLocalVar("round")
        player:addExp(round * global.chestExpBonus)

        local battlefieldId = bf:getID()

        if battlefieldId == 25 then  -- A.M.A.N. Trove (Venus)
            global.venusDespawnCoffersWin()
        elseif battlefieldId == 24 then  -- A.M.A.N. Trove (Mars)
            global.marsDespawnCoffersWin()
        end

        bf:setStatus(xi.battlefield.status.WON)
        bf:setLocalVar('rewardReceived', 2)

        handleJackpot(player)  -- Check for jackpot

        -- Distribute the loot after a delay
        npc:timer(1000, function() handleLootDistribution(player, npc, bf) end)
    end
end)

return m
