-----------------------------------
-- CatsEyeXI
-- BCNM: Amans Trove
-- Horlais Peak
-- Loot Table for Aman Trove
-----------------------------------
require('scripts/globals/battlefield')
require("scripts/globals/utils")
require("modules/module_utils")
-----------------------------------
local m = Module:new("aman_trove_loot")

-- History
-- 24/1/1   First trove table made - Spicy
-- 24/2/29  First addendum. - Spicy
--          - Tatters added as an extra slot (Removed from Login Campaign). Not reodrdering slot notes so I will just call it slot 10 as 9 slots exist.
--          - Yinyang Robe added to the D ring pool.
-- xx/xx/xx

--
-- Venus Orb Loot
--

m.venusLoot =
{

    [15] =
    {   -- Slot 1, Currency --
        {
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  90 },
            { itemid = xi.item.ALEXANDRITE,                     droprate =  90 },
            { itemid = xi.item.ONE_BYNE_BILL,                   droprate =  90 },
            { itemid = xi.item.ORDELLE_BRONZEPIECE,             droprate =  90 },
            { itemid = xi.item.TUKUKU_WHITESHELL,               droprate =  90 },
            { itemid = xi.item.BEASTMENS_SEAL,                  droprate =  85 },
            { itemid = xi.item.KINDREDS_SEAL,                   droprate =  85 },
            { itemid = xi.item.FORGOTTEN_THOUGHT,               droprate =  50 },
            { itemid = xi.item.FORGOTTEN_HOPE,                  droprate =  50 },
            { itemid = xi.item.FORGOTTEN_TOUCH,                 droprate =  50 },
            { itemid = xi.item.FORGOTTEN_JOURNEY,               droprate =  50 },
            { itemid = xi.item.FORGOTTEN_STEP,                  droprate =  50 },
            { itemid =  8798,                                   droprate =  50 }, -- HP Bayld
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter
        },
        -- Slot 10, Tatters --
        {
            { itemid =  3283,                                   droprate =  31 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  31 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  31 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  31 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  31 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  31 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  31 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  31 }, -- Wyrmal Tatter
            { itemid =     0,                                   droprate = 750 }, -- Nothing
        },
        -- Slot 2, Pop Items --
        {
            { itemid = xi.item.CURTANA,                         droprate =  40 },
            { itemid = xi.item.CHUNK_OF_DIORITE,                droprate =  40 },
            { itemid = xi.item.FLASK_OF_ROMAEVE_SPRING_WATER,   droprate =  40 },
            { itemid = xi.item.RED_CRYPTEX,                     droprate =  20 },
            { itemid = xi.item.DARKSTEEL_ENGRAVING,             droprate =  20 },
            { itemid = xi.item.SEVEN_KNOT_QUIPU,                droprate =  20 },
            { itemid = xi.item.GALKA_FANG_SACK,                 droprate =  20 },
            { itemid = xi.item.JADE_CRYPTEX,                    droprate =  20 },
            { itemid = xi.item.SILVER_ENGRAVING,                droprate =  20 },
            { itemid = xi.item.MITHRA_FANG_SACK,                droprate =  20 },
            { itemid = xi.item.THIRTEEN_KNOT_QUIPU,             droprate =  20 },
            { itemid = xi.item.TIGER_LEATHER_MISSIVE,           droprate =  20 },
            { itemid = xi.item.BEHEMOTH_LEATHER_MISSIVE,        droprate =  20 },
            { itemid = xi.item.RAM_LEATHER_MISSIVE,             droprate =  20 },
            { itemid = xi.item.HOUND_FANG_SACK,                 droprate =  20 },
            { itemid = xi.item.DHALMEL_LEATHER_MISSIVE,         droprate =  20 },
            { itemid = xi.item.BUNNY_FANG_SACK,                 droprate =  20 },
            { itemid = xi.item.SHEEP_LEATHER_MISSIVE,           droprate =  20 },
            { itemid = xi.item.COEURL_LEATHER_MISSIVE,          droprate =  20 },
            { itemid = xi.item.DRAGON_CHRONICLES,               droprate =  20 },
            { itemid = xi.item.HIGH_QUALITY_PHUABO_ORGAN,       droprate =  15 },
            { itemid = xi.item.HIGH_QUALITY_HPEMDE_ORGAN,       droprate =  15 },
            { itemid = xi.item.HIGH_QUALITY_EUVHI_ORGAN,        droprate =  15 },
            { itemid = xi.item.HIGH_QUALITY_AERN_ORGAN,         droprate =  15 },
            { itemid =  1855,                                   droprate =  15 }, -- H.Q. Xzomit Organ
            { itemid =  1784,                                   droprate =  15 }, -- Phuabo Organ
            { itemid =  1785,                                   droprate =  15 }, -- Xzomit Organ
            { itemid =  1786,                                   droprate =  15 }, -- Aern Organ
            { itemid =  1787,                                   droprate =  15 }, -- Hpemde Organ
            { itemid =  1788,                                   droprate =  15 }, -- Yovra Organ
            { itemid =  1872,                                   droprate =  20 }, -- Ghrah M Chip
            { itemid =  1783,                                   droprate =  20 }, -- Luminian Tissue
            { itemid =  1288,                                   droprate =  10 }, -- Wooden Hakutatku Eye
            { itemid =  1289,                                   droprate =  10 }, -- Burning Hakutatku Eye
            { itemid =  1290,                                   droprate =  10 }, -- Earthen Hakutatku Eye
            { itemid =  1291,                                   droprate =  10 }, -- Golden Hakutatku Eye
            { itemid =  1292,                                   droprate =  10 }, -- Damp Hakutatku Eye
            { itemid = xi.item.JAR_OF_PEISTE_PELLETS,           droprate =  20 },
            { itemid = xi.item.JAR_OF_GNAT_PELLETS,             droprate =  20 },
            { itemid =  2565,                                   droprate =  20 }, -- Gnole Pellets
            { itemid = xi.item.FLICKERING_LANTERN,              droprate =   5 },
            { itemid = xi.item.TONBERRY_RATTLE,                 droprate =   5 },
            { itemid = xi.item.OFFERING_TO_UGGALEPIH,           droprate =   5 },
            { itemid = xi.item.UGGALEPIH_WHISTLE,               droprate =   5 },
            { itemid = xi.item.CARBUNCLES_RUBY,                 droprate =   5 },
            { itemid = xi.item.SAHAGIN_KEY,                     droprate =   5 },
            { itemid = xi.item.DEED_OF_PLACIDITY,               droprate =  20 },
            { itemid = xi.item.DEED_OF_SENSIBILITY,             droprate =  20 },
            { itemid =  1854,                                   droprate =  20 }, -- Deed of Moderation
            { itemid = xi.item.FOMOR_CODEX,                     droprate =  20 },
            { itemid = xi.item.POT_OF_CLUSTERED_TAR,            droprate =  20 },
            { itemid =  1782,                                   droprate =  20 }, -- Florid Stone
            { itemid = xi.item.AIR_TANK,                        droprate =  20 },
            { itemid = xi.item.PREMIUM_BAG,                     droprate =  15 },
            { itemid = xi.item.ARK_PENTASPHERE,                 droprate =   5 },
            { itemid = xi.item.PIRATES_CHART,                   droprate =   5 },
            { itemid = xi.item.BRIGANDS_CHART,                  droprate =   5 },
            { itemid =   724,                                   droprate =  20 }, -- Magnolia Lumber
            { itemid =   677,                                   droprate =  20 }, -- White Steel
        },
        -- Slot 3, Equipment --
        {
            { itemid = xi.item.MELEE_CAPE,                      droprate =   5 },
            { itemid = xi.item.ABYSS_CAPE,                      droprate =   5 },
            { itemid = xi.item.ASSASSINS_CAPE,                  droprate =   5 },
            { itemid = xi.item.VALOR_CAPE,                      droprate =   5 },
            { itemid = xi.item.BARDS_CAPE,                      droprate =   5 },
            { itemid = xi.item.SUMMONERS_CAPE,                  droprate =   5 },
            { itemid = xi.item.WARRIORS_STONE,                  droprate =   5 },
            { itemid = xi.item.CLERICS_BELT,                    droprate =   5 },
            { itemid = xi.item.DUELISTS_BELT,                   droprate =   5 },
            { itemid = xi.item.SORCERERS_BELT,                  droprate =   5 },
            { itemid = xi.item.MONSTER_BELT,                    droprate =   5 },
            { itemid = xi.item.SCOUTS_BELT,                     droprate =   5 },
            { itemid = xi.item.KOGA_SARASHI,                    droprate =   5 },
            { itemid = xi.item.WYRM_BELT,                       droprate =   5 },
            { itemid = xi.item.SAOTOME_KOSHI_ATE,               droprate =   5 },
            { itemid = xi.item.COMMODORE_BELT,                  droprate =   5 },
            { itemid = xi.item.ARGUTE_BELT,                     droprate =   5 },
            { itemid = xi.item.MIRAGE_MANTLE,                   droprate =   5 },
            { itemid = xi.item.PANTIN_CAPE,                     droprate =   5 },
            { itemid = xi.item.ETOILE_CAPE,                     droprate =   5 },
            { itemid = xi.item.KOBO_OBI,                        droprate =   5 },  -- GEO Dynamis Accessory
            { itemid = xi.item.TANTALIC_CAPE,                   droprate =   5 },  -- RUN Dynamis Accessory
            { itemid = xi.item.DUENDE_COTEHARDIE,               droprate =   4 },
            { itemid = xi.item.NOKIZARU_GI,                     droprate =   4 },
            { itemid = xi.item.RAPPAREE_HARNESS,                droprate =   4 },
            { itemid = xi.item.SHINIMUSHA_HARA_ATE,             droprate =   4 },
            { itemid = xi.item.WYVERN_MAIL,                     droprate =   4 },
            { itemid = xi.item.SHIKAREE_AKETON,                 droprate =   4 },
            { itemid = xi.item.CERISE_DOUBLET,                  droprate =   4 },
            { itemid = xi.item.GLAMOR_JUPON,                    droprate =   4 },
            { itemid = xi.item.GLOOM_BREASTPLATE,               droprate =   4 },
            { itemid = xi.item.NIMBUS_DOUBLET,                  droprate =   4 },
            { itemid = xi.item.AIKIDO_GI,                       droprate =   4 },
            { itemid = xi.item.PARADE_CUIRASS,                  droprate =   4 },
            { itemid = xi.item.GAUDY_HARNESS,                   droprate =   4 },
            { itemid = xi.item.CARPENTERS_BELT,                 droprate =   4 },
            { itemid = xi.item.BLACKSMITHS_BELT,                droprate =   4 },
            { itemid = xi.item.GOLDSMITHS_BELT,                 droprate =   4 },
            { itemid = xi.item.WEAVERS_BELT,                    droprate =   4 },
            { itemid = xi.item.TANNERS_BELT,                    droprate =   4 },
            { itemid = xi.item.BONEWORKERS_BELT,                droprate =   4 },
            { itemid = xi.item.ALCHEMISTS_BELT,                 droprate =   4 },
            { itemid = xi.item.CULINARIANS_BELT,                droprate =   4 },
            { itemid = xi.item.FISHERMANS_BELT,                 droprate =   4 },
            { itemid = xi.item.HAMAYUMI,                        droprate =   5 },
            { itemid = xi.item.DIA_WAND,                        droprate =   5 },
            { itemid = xi.item.STONE_GORGET,                    droprate =   5 },
            { itemid = xi.item.PILGRIMS_WAND,                   droprate =   5 },
            { itemid = xi.item.GELONG_STAFF,                    droprate =   5 },
            { itemid = xi.item.WEBCUTTER,                       droprate =   5 },
            { itemid =  18412,                                  droprate =   5 }, -- Gassan
            { itemid =  17708,                                  droprate =   5 }, -- Auriga Xiphos
            { itemid =  18359,                                  droprate =   5 }, -- Boreas Cesti
            { itemid =  15220,                                  droprate =   5 }, -- Rain Hat
            { itemid =  15468,                                  droprate =   5 }, -- Resentment Cape
            { itemid =  15505,                                  droprate =   5 }, -- Dhalmel Whistle
            { itemid =  14667,                                  droprate =   5 }, -- Carect Ring
            { itemid =  xi.item.GOTHIC_SABATONS,                droprate =   5 },
            { itemid =  xi.item.GOTHIC_GAUNTLETS,               droprate =   5 },
            { itemid =  11529,                                  droprate =   5 }, -- Frugal Cape
            { itemid =  16187,                                  droprate =   5 }, -- Adoubeurs Pavise
            { itemid =  16899,                                  droprate =   5 }, -- Hototogisu
            { itemid =  16374,                                  droprate =   5 }, -- Layqa Seraweels
            { itemid =  17199,                                  droprate =   5 }, -- Loxley Bow
            { itemid =  16882,                                  droprate =   5 }, -- Calamar
            { itemid =  17504,                                  droprate =   5 }, -- Pagures
            { itemid =  16884,                                  droprate =   5 }, -- Narval
            { itemid =  17503,                                  droprate =   5 }, -- Exocets
            { itemid =  19238,                                  droprate =   5 }, -- Jasper Tathlum
            { itemid =  11404,                                  droprate =   5 }, -- Promptitude Solea
            { itemid =  15897,                                  droprate =   5 }, -- Grace Corset
            { itemid =  13803,                                  droprate =   5 }, -- Shaman's Cloak
            { itemid =  19237,                                  droprate =   5 }, -- Slick Dart
            { itemid =  15942,                                  droprate =   5 }, -- Summoning Belt
            { itemid =  xi.item.MUSHROOM_HELM,                  droprate =   5 },
            { itemid =  xi.item.LUNA_SUBLIGAR,                  droprate =   5 },
            { itemid =  16980,                                  droprate =   5 }, -- Sukesada
            { itemid =  13912,                                  droprate =   5 }, -- Shadow Mask
            { itemid =  16943,                                  droprate =   5 }, -- Ascalon
            { itemid =  14063,                                  droprate =   5 }, -- Protecting Bangles
            { itemid =  14064,                                  droprate =   5 }, -- Sand Gloves
            { itemid =  17651,                                  droprate =   5 }, -- Dainslaif
            { itemid =  17924,                                  droprate =   5 }, -- Tungi
            { itemid =  16734,                                  droprate =   5 }, -- Pendragon Axe
            { itemid =  15995,                                  droprate =   5 }, -- Carline Earring
            { itemid =  16127,                                  droprate =   5 }, -- Carline Ribbon
            { itemid =  16125,                                  droprate =   5 }, -- Breeder Mask
            { itemid =  15001,                                  droprate =   5 }, -- Breeder Mufflers
            { itemid =  15946,                                  droprate =   5 }, -- Tempest Belt
            { itemid =  11405,                                  droprate =   5 }, -- Kyoshu Kyahan
            { itemid =  11533,                                  droprate =   5 }, -- Lyricist's Gonnelle
            { itemid =  16298,                                  droprate =   5 }, -- Knack Pendant
            { itemid =  17454,                                  droprate =   5 }, -- Asklepios
            { itemid =  17455,                                  droprate =   5 }, -- Skirnir's Wand
            { itemid =  16912,                                  droprate =   5 }, -- Kitsutsuki
            { itemid =  17926,                                  droprate =   5 }, -- Acha D'Armas
            { itemid =  17982,                                  droprate =   5 }, -- Kard
            { itemid =  17983,                                  droprate =   5 }, -- Valiant Knife
            { itemid =  18042,                                  droprate =   5 }, -- Ascention
            { itemid =  17563,                                  droprate =   5 }, -- Power Staff
            { itemid =  17969,                                  droprate =   5 }, -- Fendoir
            { itemid =  18608,                                  droprate =   5 }, -- Atesh Pole
            { itemid =  16727,                                  droprate =   5 }, -- Eisentaenzer
            { itemid =  17971,                                  droprate =   5 }, -- Tartaglia
            { itemid =  19235,                                  droprate =   5 }, -- Veuglaire
            { itemid =  16375,                                  droprate =   5 }, -- Surge Subligar
            { itemid =  xi.item.ASTRAL_ASPIS,                   droprate =   5 },
            { itemid =  xi.item.GAE_BOLG,                       droprate =   5 },
            { itemid =  xi.item.LOHAR,                          droprate =   5 },
            { itemid =   19122,                                 droprate =   5 }, -- Courser's Pugio
            { itemid =   16081,                                 droprate =   5 }, -- Curate's Hat
            { itemid =   15882,                                 droprate =   5 }, -- Othinus' Bow
            { itemid =   17244,                                 droprate =   5 }, -- Storm Belt
            { itemid =   14806,                                 droprate =   5 }, -- Intruder Earring
            { itemid =   14466,                                 droprate =   5 }, -- Fomor Tunic
            { itemid =   18007,                                 droprate =   5 }, -- Chiroptera Dagger
            { itemid =   17510,                                 droprate =   5 }, -- Vampiric Claws
            { itemid =   14763,                                 droprate =   5 }, -- Boroka Earring
            { itemid =   13178,                                 droprate =   5 }, -- Auditory Torque
            { itemid =   15943,                                 droprate =   5 }, -- Virtuoso Belt
            { itemid =   14884,                                 droprate =   5 }, -- Mycophile Cuffs
            { itemid =   17794,                                 droprate =   5 }, -- Niokiyotsuna
            { itemid =   15219,                                 droprate =   5 }, -- Sinister Mask
            { itemid =   16368,                                 droprate =   5 }, -- Herder's Subligar
            { itemid =   14724,                                 droprate =   5 }, -- Moldavite Earring
            { itemid =   16279,                                 droprate =   5 }, -- Pile Chain
            { itemid =   15546,                                 droprate =   5 }, -- Fasting Ring
            { itemid =   16299,                                 droprate =   5 }, -- Lleu's Charm
            { itemid =   11496,                                 droprate =   5 }, -- Fenrir's Crown
            { itemid =   14168,                                 droprate =   5 }, -- Dune Boots
            { itemid =   17854,                                 droprate =   5 }, -- Cradle Horn
            { itemid =   19239,                                 droprate =   5 }, -- Astrolable
            { itemid =   16169,                                 droprate =   5 }, -- Caballero Shield
            { itemid =   17653,                                 droprate =   5 }, -- Hrotti
            { itemid =   18027,                                 droprate =   5 }, -- Palladium Dagger
            { itemid =   17564,                                 droprate =   5 }, -- Cocytus Pole
            { itemid =   16426,                                 droprate =   5 }, -- Avengers
            { itemid =   19121,                                 droprate =   5 }, -- Sleight Kukri
            { itemid =   15944,                                 droprate =   5 }, -- Selemnus Belt
            { itemid =   16297,                                 droprate =   4 }, -- Shepherd's Chain
            { itemid =  xi.item.KAMEWARI,                       droprate =   5 },
            { itemid =  xi.item.NADRS,                          droprate =   5 },
            { itemid =  xi.item.ALTDORFS_EARRING,               droprate =   5 },
            { itemid =  xi.item.WILHELMS_EARRING,               droprate =   5 },
            { itemid =  xi.item.MINSTRELS_DAGGER,               droprate =   5 },
            { itemid =  xi.item.SAND_CHARM,                     droprate =   5 },
            { itemid =   15692,                                 droprate =   3 }, -- Storm Crackows
            { itemid =   14669,                                 droprate =   3 }, -- Jaeger Ring
            { itemid =   15351,                                 droprate =   2 }, -- Bounding Boots
            { itemid =   18018,                                 droprate =   2 }, -- Sirocco Kukri
            { itemid =   13567,                                 droprate =   2 }, -- Bomb Queen Ring
            { itemid =   15547,                                 droprate =   2 }, -- Vilma's Ring
            { itemid =   26164,                                 droprate =   2 }, -- Caliber Ring
            { itemid =   15183,                                 droprate =   5 }, -- Dobson Bandana
            { itemid =   15184,                                 droprate =   2 }, -- Voyager Sallet
            { itemid =   14986,                                 droprate =   2 }, -- Ochimusha Kote
            { itemid =   15737,                                 droprate =   2 }, -- Sarutobi Kyahan
            { itemid =   15551,                                 droprate =   2 }, -- Shikaree Ring
            { itemid =  xi.item.EMPRESS_HAIRPIN,                droprate =   2 },
            { itemid =  xi.item.JOYEUSE,                        droprate =   2 },
            { itemid =  xi.item.DRYAD_STAFF,                    droprate =   2 },
            { itemid =  xi.item.VALIS_BOW,                      droprate =   2 },
            { itemid =  xi.item.RETALIATORS,                    droprate =   2 },
            { itemid =  xi.item.UNGUR_BOOMERANG,                droprate =   2 },
            { itemid =   15515,                                 droprate =   1 }, -- Peacock Amulet
            { itemid =  xi.item.TROTTER_BOOTS,                  droprate =   1 },
            { itemid =    0,                                    droprate = 250 }, -- Nothing
        },
        -- Slot 4, Materials --
        {
            { itemid = xi.item.MOAT_CARP,                       droprate =   4 },
            { itemid = xi.item.IRON_INGOT,                      droprate =   5 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   5 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   5 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   5 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   5 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   5 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   5 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   5 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   5 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   5 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   5 },
            { itemid = xi.item.RAM_HORN,                        droprate =   5 },
            { itemid = xi.item.ELM_LOG,                         droprate =   5 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   5 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   5 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   5 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   5 },
            { itemid = xi.item.SACK_OF_SILICA,                  droprate =   5 },
            { itemid =  850,                                    droprate =   5 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   5 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   5 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   5 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   5 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   5 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   5 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   5 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   5 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   5 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   5 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   5 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   5 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   5 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   5 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   5 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   5 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   5 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   5 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   5 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   5 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   5 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   5 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   5 },
            { itemid = xi.item.IMP_HORN,                        droprate =   5 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   5 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   5 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   5 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   5 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   5 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   5 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   5 },
            { itemid = 1225,                                    droprate =   5 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   5 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   5 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   5 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   5 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   5 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   5 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   5 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   5 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   5 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   5 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   5 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   5 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   5 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   5 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   5 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   5 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   5 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   5 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   5 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   5 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   5 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   5 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   5 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   5 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   5 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   5 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   5 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   5 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   5 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   5 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   4 },
            { itemid = 2151,                                    droprate =   4 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   4 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   4 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   4 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   4 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   4 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   4 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   4 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   4 }, -- Water Anima
            { itemid = 1647,                                    droprate =   4 }, -- Light Anima
            { itemid = 1648,                                    droprate =   4 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   3 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   3 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   3 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   3 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   3 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   3 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   3 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   3 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   3 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   3 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   3 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   3 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   3 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   3 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   3 },
            { itemid =  734,                                    droprate =   3 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   3 }, -- Amphiptere Hide
            { itemid = 2164,                                    droprate =   4 }, -- Pephredo Hive Chip
            { itemid = 1279,                                    droprate =   4 }, -- Taffeta Cloth
            { itemid = 1280,                                    droprate =   4 }, -- Sarcenet Cloth
            { itemid = 1281,                                    droprate =   4 }, -- Cheviot Cloth
            { itemid = 1295,                                    droprate =   4 }, -- Twincoon
            { itemid = 1270,                                    droprate =   4 }, -- Arachne Web
            { itemid =  647,                                    droprate =   4 }, -- Molybdenum Ore
            { itemid = 1271,                                    droprate =   4 }, -- Pigeon's Blood Ruby
            { itemid = 1276,                                    droprate =   4 }, -- Tarasque Skin
            { itemid = 1296,                                    droprate =   4 }, -- Yowie Skin
            { itemid = 1277,                                    droprate =   4 }, -- Lindwurm Skin
            { itemid = 1765,                                    droprate =   4 }, -- Habu Skin
            { itemid = 2828,                                    droprate =   4 }, -- Herensugue Skin
            { itemid = 2837,                                    droprate =   4 }, -- Ratatoskr Pelt
            { itemid = 2839,                                    droprate =   4 }, -- Coquecigrue Skin
            { itemid = 2830,                                    droprate =   4 }, -- Bastet Fang
            { itemid = 2833,                                    droprate =   4 }, -- Thunder Coral
            { itemid = 1272,                                    droprate =   4 }, -- Arioch Fang
            { itemid = 1273,                                    droprate =   4 }, -- Namtar Bone
            { itemid = 2849,                                    droprate =   4 }, -- Likho Talon
            { itemid = 2846,                                    droprate =   4 }, -- Hefty Oak Lumber
            { itemid = 2855,                                    droprate =   4 }, -- Mahogany Heartwood
            { itemid = xi.item.CHUNK_OF_FIRE_ORE,               droprate =   2 },
            { itemid = xi.item.CHUNK_OF_ICE_ORE,                droprate =   2 },
            { itemid = xi.item.CHUNK_OF_WIND_ORE,               droprate =   2 },
            { itemid = xi.item.CHUNK_OF_EARTH_ORE,              droprate =   2 },
            { itemid = xi.item.CHUNK_OF_LIGHTNING_ORE,          droprate =   2 },
            { itemid = xi.item.CHUNK_OF_WATER_ORE,              droprate =   2 },
            { itemid = xi.item.CHUNK_OF_LIGHT_ORE,              droprate =   2 },
            { itemid = xi.item.CHUNK_OF_DARK_ORE,               droprate =   2 },
            { itemid = xi.item.CLUMP_OF_IMPERIAL_TEA_LEAVES,    droprate =   2 },
            { itemid = xi.item.DRAGON_FRUIT,                    droprate =   1 },
            { itemid = xi.item.WALNUT,                          droprate =   1 },
            { itemid = xi.item.BOWL_OF_AMBROSIA,                droprate =   1 },
            { itemid = xi.item.BOTTLE_OF_AMRITA,                droprate =   1 },
            { itemid = xi.item.DRAGON_HEART,                    droprate =   1 },
            { itemid = xi.item.HANDFUL_OF_DRAGON_SCALES,        droprate =   1 },
            { itemid = xi.item.SLICE_OF_DRAGON_MEAT,            droprate =   1 },
            { itemid = xi.item.CHUNK_OF_HYDRA_MEAT,             droprate =   1 },
            { itemid = xi.item.SLICE_OF_CERBERUS_MEAT,          droprate =   1 },
            { itemid = xi.item.BEHEMOTH_HIDE,                   droprate =   1 },
            { itemid = xi.item.BEHEMOTH_HORN,                   droprate =   1 },
            { itemid = 2158,                                    droprate =   1 }, -- Hydra Fang
            { itemid = 2172,                                    droprate =   1 }, -- Hydra Scale
            { itemid = 2168,                                    droprate =   1 }, -- Cerberus Claw
            { itemid = 2169,                                    droprate =   1 }, -- Cerberus Hide
            { itemid = 2371,                                    droprate =   1 }, -- Khimaira Horn
            { itemid = 2372,                                    droprate =   1 }, -- Khimaira Mane
            { itemid = 2373,                                    droprate =   1 }, -- Khimaira Tail
            { itemid = 4273,                                    droprate =   1 }, -- Kitron
            { itemid = 1718,                                    droprate =   1 }, -- M-bugard Tusk
            { itemid = 1719,                                    droprate =   1 }, -- Harajnite Shell
            { itemid =    0,                                    droprate = 250 }, -- nothing
        },
        -- Slot 5 Misc/Medicine --
        {
            { itemid = xi.item.TRAINING_MANUAL,                 droprate =  25 },
            { itemid = xi.item.FIRE_CLUSTER,                    droprate =  20 },
            { itemid = xi.item.ICE_CLUSTER,                     droprate =  20 },
            { itemid = xi.item.WIND_CLUSTER,                    droprate =  20 },
            { itemid = xi.item.EARTH_CLUSTER,                   droprate =  20 },
            { itemid = xi.item.LIGHTNING_CLUSTER,               droprate =  20 },
            { itemid = xi.item.WATER_CLUSTER,                   droprate =  20 },
            { itemid = xi.item.LIGHT_CLUSTER,                   droprate =  20 },
            { itemid = xi.item.DARK_CLUSTER,                    droprate =  20 },
            { itemid = xi.item.ANTIDOTE,                        droprate =  20 },
            { itemid = xi.item.FLASK_OF_ECHO_DROPS,             droprate =  20 },
            { itemid = xi.item.FLASK_OF_HOLY_WATER,             droprate =  20 },
            { itemid = xi.item.RERAISER,                        droprate =  20 },
            { itemid = xi.item.HI_RERAISER,                     droprate =  20 },
            { itemid = xi.item.VILE_ELIXIR,                     droprate =  20 },
            { itemid = xi.item.PINCH_OF_PUNGENT_POWDER_II,      droprate =  20 },
            { itemid = 4512,                                    droprate =  20 }, -- Vampire Juice
            { itemid = 5724,                                    droprate =  20 }, -- Pungent Powder I
            { itemid = 5350,                                    droprate =  20 }, -- Volant Serum
            { itemid = 4153,                                    droprate =  20 }, -- Antacid
            { itemid = 5356,                                    droprate =  20 }, -- Remedy Ointment
            { itemid = 5254,                                    droprate =  20 }, -- Hyper Potion
            { itemid = 5255,                                    droprate =  20 }, -- Hyper Ether
            { itemid = xi.item.REMEDY,                          droprate =  15 },
            { itemid = xi.item.MOAT_CARP,                       droprate =  15 },
            { itemid = 4149,                                    droprate =   5 }, -- Panacea
            { itemid =    0,                                    droprate = 500 }, -- nothing
        },
    },

    [30] =
    {   -- Slot 1, Currency --
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate =  50 },
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  90 },
            { itemid = xi.item.COTTON_COIN_PURSE,               droprate = 100 },
            { itemid = xi.item.ONE_BYNE_BILL,                   droprate =  90 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =  10 },
            { itemid = xi.item.ORDELLE_BRONZEPIECE,             droprate =  80 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =  10 },
            { itemid = xi.item.TUKUKU_WHITESHELL,               droprate =  80 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =  10 },
            { itemid = xi.item.BEASTMENS_SEAL,                  droprate =  50 },
            { itemid = xi.item.KINDREDS_SEAL,                   droprate =  50 },
            { itemid =  6541,                                   droprate =  60 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  60 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  60 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  60 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  60 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter
        },
        -- Slot 6, Currency --
        {
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  22 },
            { itemid = xi.item.ALEXANDRITE,                     droprate =  30 },
            { itemid = xi.item.ONE_BYNE_BILL,                   droprate =  30 },
            { itemid = xi.item.ORDELLE_BRONZEPIECE,             droprate =  30 },
            { itemid = xi.item.TUKUKU_WHITESHELL,               droprate =  30 },
            { itemid = xi.item.BEASTMENS_SEAL,                  droprate =  20 },
            { itemid = xi.item.KINDREDS_SEAL,                   droprate =  20 },
            { itemid = xi.item.FORGOTTEN_THOUGHT,               droprate =  10 },
            { itemid = xi.item.FORGOTTEN_HOPE,                  droprate =  10 },
            { itemid = xi.item.FORGOTTEN_TOUCH,                 droprate =  10 },
            { itemid = xi.item.FORGOTTEN_JOURNEY,               droprate =  10 },
            { itemid = xi.item.FORGOTTEN_STEP,                  droprate =  10 },
            { itemid =  8798,                                   droprate =  10 }, -- HP Bayld
            { itemid =  3283,                                   droprate =   1 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =   1 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =   1 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =   1 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =   1 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =   1 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =   1 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =   1 }, -- Wyrmal Tatter
            { itemid =     0,                                   droprate = 750 }, -- Nothing
        },
        -- Slot 10, Tatters --
        {
            { itemid =  3283,                                   droprate =  62 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  62 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  62 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  62 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  62 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  62 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  62 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  62 }, -- Wyrmal Tatter
            { itemid =     0,                                   droprate = 500 }, -- Nothing
        },
        -- Slot 2, Pop Items --
        {
            { itemid = xi.item.CURTANA,                         droprate =  20 },
            { itemid = xi.item.CHUNK_OF_DIORITE,                droprate =  20 },
            { itemid = xi.item.FLASK_OF_ROMAEVE_SPRING_WATER,   droprate =  20 },
            { itemid = xi.item.GEM_OF_THE_EAST,                 droprate =  20 },
            { itemid = xi.item.SPRINGSTONE,                     droprate =  20 },
            { itemid = xi.item.GEM_OF_THE_SOUTH,                droprate =  20 },
            { itemid = xi.item.SUMMERSTONE,                     droprate =  20 },
            { itemid = xi.item.GEM_OF_THE_WEST,                 droprate =  20 },
            { itemid = xi.item.AUTUMNSTONE,                     droprate =  20 },
            { itemid = xi.item.GEM_OF_THE_NORTH,                droprate =  20 },
            { itemid = xi.item.WINTERSTONE,                     droprate =  20 },
            { itemid = xi.item.IVORY_CHIP,                      droprate =  30 },
            { itemid = xi.item.SCARLET_CHIP,                    droprate =  30 },
            { itemid = xi.item.EMERALD_CHIP,                    droprate =  30 },
            { itemid = xi.item.SILVER_CHIP,                     droprate =  20 },
            { itemid = xi.item.CERULEAN_CHIP,                   droprate =  20 },
            { itemid = 1986,                                    droprate =  20 }, -- Orchid Chip
            { itemid = xi.item.SMALT_CHIP,                      droprate =  20 },
            { itemid = xi.item.SMOKY_CHIP,                      droprate =  20 },
            { itemid = 1987,                                    droprate =  20 }, -- Charcoal Chip
            { itemid = 1988,                                    droprate =  20 }, -- Magenta Chip
            { itemid = xi.item.HIGH_QUALITY_PHUABO_ORGAN,       droprate =  10 },
            { itemid = xi.item.HIGH_QUALITY_HPEMDE_ORGAN,       droprate =  10 },
            { itemid = xi.item.HIGH_QUALITY_EUVHI_ORGAN,        droprate =  10 },
            { itemid = xi.item.HIGH_QUALITY_AERN_ORGAN,         droprate =  10 },
            { itemid =  1855,                                   droprate =  10 }, -- H.Q. Xzomit Organ
            { itemid =  1784,                                   droprate =   5 }, -- Phuabo Organ
            { itemid =  1785,                                   droprate =   5 }, -- Xzomit Organ
            { itemid =  1786,                                   droprate =   5 }, -- Aern Organ
            { itemid =  1787,                                   droprate =   5 }, -- Hpemde Organ
            { itemid =  1788,                                   droprate =   5 }, -- Yovra Organ
            { itemid =  1872,                                   droprate =   5 }, -- Ghrah M Chip
            { itemid =  1783,                                   droprate =   5 }, -- Luminian Tissue
            { itemid =  1288,                                   droprate =  10 }, -- Wooden Hakutatku Eye
            { itemid =  1289,                                   droprate =  10 }, -- Burning Hakutatku Eye
            { itemid =  1290,                                   droprate =  10 }, -- Earthen Hakutatku Eye
            { itemid =  1291,                                   droprate =  10 }, -- Golden Hakutatku Eye
            { itemid =  1292,                                   droprate =  10 }, -- Damp Hakutatku Eye
            { itemid = xi.item.DEED_OF_PLACIDITY,               droprate =  40 },
            { itemid = xi.item.DEED_OF_SENSIBILITY,             droprate =  40 },
            { itemid =  1854,                                   droprate =  40 }, -- Deed of Moderation
            { itemid = xi.item.FIRST_VIRTUE,                    droprate =  20 },
            { itemid =  1853,                                   droprate =  20 }, -- Second Virtue
            { itemid = xi.item.THIRD_VIRTUE,                    droprate =  20 },
            { itemid = xi.item.ANTLION_TRAP,                    droprate =  20 },
            { itemid = xi.item.HAUNTED_MULETA,                  droprate =  15 },
            { itemid = xi.item.SHRIMP_LANTERN,                  droprate =  20 },
            { itemid = xi.item.HELLCAGE_BUTTERFLY,              droprate =  20 },
            { itemid = xi.item.JUG_OF_FLORAL_NECTAR,            droprate =  20 },
            { itemid = xi.item.WEDGE_OF_RODENT_CHEESE,          droprate =  20 },
            { itemid = xi.item.CLUMP_OF_SHADELEAVES,            droprate =  20 },
            { itemid = xi.item.BEAKER_OF_PECTIN,                droprate =  20 },
            { itemid = xi.item.FLASK_OF_COG_LUBRICANT,          droprate =  20 },
            { itemid = xi.item.GOLDEN_TEETH,                    droprate =  20 },
            { itemid = xi.item.GREENLING,                       droprate =  20 },
            { itemid = xi.item.BOTTLE_OF_SPOILT_BLOOD,          droprate =  20 },
        },
        -- Slot 3, Equipment --
        {
            { itemid = xi.item.MELEE_CAPE,                      droprate =   5 },
            { itemid = xi.item.ABYSS_CAPE,                      droprate =   5 },
            { itemid = xi.item.ASSASSINS_CAPE,                  droprate =   5 },
            { itemid = xi.item.VALOR_CAPE,                      droprate =   5 },
            { itemid = xi.item.BARDS_CAPE,                      droprate =   5 },
            { itemid = xi.item.SUMMONERS_CAPE,                  droprate =   5 },
            { itemid = xi.item.WARRIORS_STONE,                  droprate =   5 },
            { itemid = xi.item.CLERICS_BELT,                    droprate =   5 },
            { itemid = xi.item.DUELISTS_BELT,                   droprate =   5 },
            { itemid = xi.item.SORCERERS_BELT,                  droprate =   5 },
            { itemid = xi.item.MONSTER_BELT,                    droprate =   5 },
            { itemid = xi.item.SCOUTS_BELT,                     droprate =   5 },
            { itemid = xi.item.KOGA_SARASHI,                    droprate =   5 },
            { itemid = xi.item.WYRM_BELT,                       droprate =   5 },
            { itemid = xi.item.SAOTOME_KOSHI_ATE,               droprate =   5 },
            { itemid = xi.item.COMMODORE_BELT,                  droprate =   5 },
            { itemid = xi.item.ARGUTE_BELT,                     droprate =   5 },
            { itemid = xi.item.MIRAGE_MANTLE,                   droprate =   5 },
            { itemid = xi.item.PANTIN_CAPE,                     droprate =   5 },
            { itemid = xi.item.ETOILE_CAPE,                     droprate =   5 },
            { itemid = xi.item.KOBO_OBI,                        droprate =   5 },  -- GEO Dynamis Accessory
            { itemid = xi.item.TANTALIC_CAPE,                   droprate =   5 },  -- RUN Dynamis Accessory
            { itemid = xi.item.DUENDE_COTEHARDIE,               droprate =   4 },
            { itemid = xi.item.NOKIZARU_GI,                     droprate =   4 },
            { itemid = xi.item.RAPPAREE_HARNESS,                droprate =   4 },
            { itemid = xi.item.SHINIMUSHA_HARA_ATE,             droprate =   4 },
            { itemid = xi.item.WYVERN_MAIL,                     droprate =   4 },
            { itemid = xi.item.SHIKAREE_AKETON,                 droprate =   4 },
            { itemid = xi.item.CERISE_DOUBLET,                  droprate =   4 },
            { itemid = xi.item.GLAMOR_JUPON,                    droprate =   4 },
            { itemid = xi.item.GLOOM_BREASTPLATE,               droprate =   4 },
            { itemid = xi.item.NIMBUS_DOUBLET,                  droprate =   4 },
            { itemid = xi.item.AIKIDO_GI,                       droprate =   4 },
            { itemid = xi.item.PARADE_CUIRASS,                  droprate =   4 },
            { itemid = xi.item.GAUDY_HARNESS,                   droprate =   4 },
            { itemid = xi.item.CARPENTERS_BELT,                 droprate =   4 },
            { itemid = xi.item.BLACKSMITHS_BELT,                droprate =   4 },
            { itemid = xi.item.GOLDSMITHS_BELT,                 droprate =   4 },
            { itemid = xi.item.WEAVERS_BELT,                    droprate =   4 },
            { itemid = xi.item.TANNERS_BELT,                    droprate =   4 },
            { itemid = xi.item.BONEWORKERS_BELT,                droprate =   4 },
            { itemid = xi.item.ALCHEMISTS_BELT,                 droprate =   4 },
            { itemid = xi.item.CULINARIANS_BELT,                droprate =   4 },
            { itemid = xi.item.FISHERMANS_BELT,                 droprate =   4 },
            { itemid = xi.item.HAMAYUMI,                        droprate =   5 },
            { itemid = xi.item.DIA_WAND,                        droprate =   5 },
            { itemid = xi.item.STONE_GORGET,                    droprate =   5 },
            { itemid = xi.item.PILGRIMS_WAND,                   droprate =   5 },
            { itemid = xi.item.GELONG_STAFF,                    droprate =   5 },
            { itemid = xi.item.WEBCUTTER,                       droprate =   5 },
            { itemid =  18412,                                  droprate =   2 }, -- Gassan
            { itemid =  17708,                                  droprate =   5 }, -- Auriga Xiphos
            { itemid =  18359,                                  droprate =   5 }, -- Boreas Cesti
            { itemid =  15220,                                  droprate =   5 }, -- Rain Hat
            { itemid =  15468,                                  droprate =   5 }, -- Resentment Cape
            { itemid =  15505,                                  droprate =   5 }, -- Dhalmel Whistle
            { itemid =  14667,                                  droprate =   5 }, -- Carect Ring
            { itemid =  xi.item.GOTHIC_SABATONS,                droprate =   5 },
            { itemid =  xi.item.GOTHIC_GAUNTLETS,               droprate =   5 },
            { itemid =  11529,                                  droprate =   5 }, -- Frugal Cape
            { itemid =  16187,                                  droprate =   5 }, -- Adoubeurs Pavise
            { itemid =  16899,                                  droprate =   5 }, -- Hototogisu
            { itemid =  16374,                                  droprate =   5 }, -- Layqa Seraweels
            { itemid =  17199,                                  droprate =   5 }, -- Loxley Bow
            { itemid =  16882,                                  droprate =   5 }, -- Calamar
            { itemid =  17504,                                  droprate =   5 }, -- Pagures
            { itemid =  16884,                                  droprate =   5 }, -- Narval
            { itemid =  17503,                                  droprate =   5 }, -- Exocets
            { itemid =  19238,                                  droprate =   5 }, -- Jasper Tathlum
            { itemid =  11404,                                  droprate =   5 }, -- Promptitude Solea
            { itemid =  15897,                                  droprate =   5 }, -- Grace Corset
            { itemid =  13803,                                  droprate =   5 }, -- Shaman's Cloak
            { itemid =  19237,                                  droprate =   5 }, -- Slick Dart
            { itemid =  15942,                                  droprate =   5 }, -- Summoning Belt
            { itemid =  xi.item.MUSHROOM_HELM,                  droprate =   5 },
            { itemid =  xi.item.LUNA_SUBLIGAR,                  droprate =   5 },
            { itemid =  16980,                                  droprate =   5 }, -- Sukesada
            { itemid =  13912,                                  droprate =   5 }, -- Shadow Mask
            { itemid =  16943,                                  droprate =   5 }, -- Ascalon
            { itemid =  14063,                                  droprate =   5 }, -- Protecting Bangles
            { itemid =  14064,                                  droprate =   5 }, -- Sand Gloves
            { itemid =  17651,                                  droprate =   5 }, -- Dainslaif
            { itemid =  17924,                                  droprate =   5 }, -- Tungi
            { itemid =  16734,                                  droprate =   5 }, -- Pendragon Axe
            { itemid =  15995,                                  droprate =   5 }, -- Carline Earring
            { itemid =  16127,                                  droprate =   5 }, -- Carline Ribbon
            { itemid =  16125,                                  droprate =   5 }, -- Breeder Mask
            { itemid =  15001,                                  droprate =   5 }, -- Breeder Mufflers
            { itemid =  15946,                                  droprate =   5 }, -- Tempest Belt
            { itemid =  11405,                                  droprate =   5 }, -- Kyoshu Kyahan
            { itemid =  11533,                                  droprate =   5 }, -- Lyricist's Gonnelle
            { itemid =  16298,                                  droprate =   5 }, -- Knack Pendant
            { itemid =  17454,                                  droprate =   5 }, -- Asklepios
            { itemid =  17455,                                  droprate =   5 }, -- Skirnir's Wand
            { itemid =  16912,                                  droprate =   5 }, -- Kitsutsuki
            { itemid =  17926,                                  droprate =   5 }, -- Acha D'Armas
            { itemid =  17982,                                  droprate =   5 }, -- Kard
            { itemid =  17983,                                  droprate =   5 }, -- Valiant Knife
            { itemid =  18042,                                  droprate =   5 }, -- Ascention
            { itemid =  17563,                                  droprate =   5 }, -- Power Staff
            { itemid =  17969,                                  droprate =   5 }, -- Fendoir
            { itemid =  18608,                                  droprate =   5 }, -- Atesh Pole
            { itemid =  16727,                                  droprate =   5 }, -- Eisentaenzer
            { itemid =  17971,                                  droprate =   5 }, -- Tartaglia
            { itemid =  19235,                                  droprate =   5 }, -- Veuglaire
            { itemid =  16375,                                  droprate =   5 }, -- Surge Subligar
            { itemid =  xi.item.ASTRAL_ASPIS,                   droprate =   5 },
            { itemid =  xi.item.GAE_BOLG,                       droprate =   5 },
            { itemid =  xi.item.LOHAR,                          droprate =   5 },
            { itemid =   19122,                                 droprate =   5 }, -- Courser's Pugio
            { itemid =   16081,                                 droprate =   5 }, -- Curate's Hat
            { itemid =   15882,                                 droprate =   5 }, -- Othinus' Bow
            { itemid =   17244,                                 droprate =   5 }, -- Storm Belt
            { itemid =   14806,                                 droprate =   5 }, -- Intruder Earring
            { itemid =   14466,                                 droprate =   5 }, -- Fomor Tunic
            { itemid =   18007,                                 droprate =   5 }, -- Chiroptera Dagger
            { itemid =   17510,                                 droprate =   5 }, -- Vampiric Claws
            { itemid =   14763,                                 droprate =   5 }, -- Boroka Earring
            { itemid =   13178,                                 droprate =   5 }, -- Auditory Torque
            { itemid =   15943,                                 droprate =   5 }, -- Virtuoso Belt
            { itemid =   14884,                                 droprate =   5 }, -- Mycophile Cuffs
            { itemid =   17794,                                 droprate =   5 }, -- Niokiyotsuna
            { itemid =   15219,                                 droprate =   5 }, -- Sinister Mask
            { itemid =   16368,                                 droprate =   5 }, -- Herder's Subligar
            { itemid =   14724,                                 droprate =   5 }, -- Moldavite Earring
            { itemid =   16279,                                 droprate =   5 }, -- Pile Chain
            { itemid =   15546,                                 droprate =   5 }, -- Fasting Ring
            { itemid =   16299,                                 droprate =   5 }, -- Lleu's Charm
            { itemid =   11496,                                 droprate =   5 }, -- Fenrir's Crown
            { itemid =   14168,                                 droprate =   5 }, -- Dune Boots
            { itemid =   17854,                                 droprate =   5 }, -- Cradle Horn
            { itemid =   19239,                                 droprate =   5 }, -- Astrolable
            { itemid =   16169,                                 droprate =   5 }, -- Caballero Shield
            { itemid =   17653,                                 droprate =   5 }, -- Hrotti
            { itemid =   18027,                                 droprate =   5 }, -- Palladium Dagger
            { itemid =   17564,                                 droprate =   5 }, -- Cocytus Pole
            { itemid =   16426,                                 droprate =   5 }, -- Avengers
            { itemid =   19121,                                 droprate =   5 }, -- Sleight Kukri
            { itemid =   15944,                                 droprate =   5 }, -- Selemnus Belt
            { itemid =   16297,                                 droprate =   4 }, -- Shepherd's Chain
            { itemid =  xi.item.KAMEWARI,                       droprate =   5 },
            { itemid =  xi.item.NADRS,                          droprate =   5 },
            { itemid =  xi.item.ALTDORFS_EARRING,               droprate =   5 },
            { itemid =  xi.item.WILHELMS_EARRING,               droprate =   5 },
            { itemid =  xi.item.MINSTRELS_DAGGER,               droprate =   5 },
            { itemid =  xi.item.SAND_CHARM,                     droprate =   5 },
            { itemid =   15692,                                 droprate =   3 }, -- Storm Crackows
            { itemid =   14669,                                 droprate =   3 }, -- Jaeger Ring
            { itemid =   15351,                                 droprate =   2 }, -- Bounding Boots
            { itemid =   18018,                                 droprate =   2 }, -- Sirocco Kukri
            { itemid =   13567,                                 droprate =   2 }, -- Bomb Queen Ring
            { itemid =   15547,                                 droprate =   2 }, -- Vilma's Ring
            { itemid =   26164,                                 droprate =   2 }, -- Caliber Ring
            { itemid =   15183,                                 droprate =   5 }, -- Dobson Bandana
            { itemid =   15184,                                 droprate =   2 }, -- Voyager Sallet
            { itemid =   14986,                                 droprate =   2 }, -- Ochimusha Kote
            { itemid =   15737,                                 droprate =   2 }, -- Sarutobi Kyahan
            { itemid =   15551,                                 droprate =   2 }, -- Shikaree Ring
            { itemid =  xi.item.EMPRESS_HAIRPIN,                droprate =   2 },
            { itemid =  xi.item.JOYEUSE,                        droprate =   2 },
            { itemid =  xi.item.DRYAD_STAFF,                    droprate =   2 },
            { itemid =  xi.item.VALIS_BOW,                      droprate =   2 },
            { itemid =  xi.item.RETALIATORS,                    droprate =   2 },
            { itemid =  xi.item.UNGUR_BOOMERANG,                droprate =   2 },
            { itemid =   15515,                                 droprate =   2 }, -- Peacock Amulet
            { itemid =  xi.item.TROTTER_BOOTS,                  droprate =   2 },
            { itemid =   19236,                                 droprate =   3 }, -- Hightail Bullet
            { itemid =   17192,                                 droprate =   3 }, -- Ifrit's Bow
            { itemid =   17711,                                 droprate =   5 }, -- Shiva's Shotel
            { itemid =   18021,                                 droprate =   5 }, -- Titan's Baselarde
            { itemid =   18063,                                 droprate =   5 }, -- Garuda's Sickle
            { itemid =   18109,                                 droprate =   5 }, -- Leviathan's Couse
            { itemid =   18404,                                 droprate =   5 }, -- Ramuh's Mace
            { itemid =   18581,                                 droprate =   5 }, -- Carbuncle's Pole
            { itemid =   14931,                                 droprate =   5 }, -- Carbuncle's Cuffs
            { itemid =   18422,                                 droprate =   5 }, -- Ryumon
            { itemid =   14960,                                 droprate =   5 }, -- Evoker's Gages
            { itemid =   19277,                                 droprate =   5 }, -- Tsugumi
            { itemid =   11408,                                 droprate =   5 }, -- Morana Pigaches
            { itemid =   11409,                                 droprate =   5 }, -- Aoide's Pumps
            { itemid =   16238,                                 droprate =   5 }, -- Taster's Cape
            { itemid =   11497,                                 droprate =   5 }, -- Spurrer Beret
            { itemid =   11406,                                 droprate =   5 }, -- Stimulus Sabots
            { itemid =   18767,                                 droprate =   5 }, -- Birdbanes
            { itemid =   15854,                                 droprate =   5 }, -- Sortie Ring
            { itemid =   15915,                                 droprate =   5 }, -- Sothic Rope
            { itemid =   11342,                                 droprate =   5 }, -- Restorer Cloak
            { itemid =   18770,                                 droprate =   5 }, -- Pygme Sainti
            { itemid =   17737,                                 droprate =   5 }, -- Corsair's Scimitar
            { itemid =   19124,                                 droprate =   5 }, -- Creve-coeur
            { itemid =   19279,                                 droprate =   5 }, -- Musanto
            { itemid =   17766,                                 droprate =   5 }, -- Lyft Scimitar
            { itemid =   17970,                                 droprate =   5 }, -- Lyft Tabar
            { itemid =   18508,                                 droprate =   5 }, -- Lyft Voulge
            { itemid =   18609,                                 droprate =   5 }, -- Lyft Pole
            { itemid =   18771,                                 droprate =   5 }, -- Lyft Sainti
            { itemid =   18872,                                 droprate =   5 }, -- Lyft Ferule
            { itemid =   18958,                                 droprate =   5 }, -- Lyft Scythe
            { itemid =   19125,                                 droprate =   5 }, -- Lyft Jambiya
            { itemid =   19161,                                 droprate =   5 }, -- Lyft Claymore
            { itemid =   19233,                                 droprate =   5 }, -- Lyft Crossbow
            { itemid =   19306,                                 droprate =   5 }, -- Lyft Lance
            { itemid =  xi.item.LAVAS_RING,                     droprate =   5 },
            { itemid =  xi.item.KUSHAS_RING,                    droprate =   5 },
            { itemid =  xi.item.NASATYAS_RING,                  droprate =   5 },
            { itemid =  xi.item.DASRAS_RING,                    droprate =   5 },
            { itemid =  xi.item.HOPE_STAFF,                     droprate =   5 },
            { itemid =  xi.item.JUSTICE_SWORD,                  droprate =   5 },
            { itemid =  xi.item.TEMPERANCE_AXE,                 droprate =   5 },
            { itemid =  xi.item.LOVE_HALBERD,                   droprate =   5 },
            { itemid =  xi.item.FORTITUDE_AXE,                  droprate =   5 },
            { itemid =  xi.item.FAITH_BAGHNAKHS,                droprate =   5 },
            { itemid =  xi.item.PRUDENCE_ROD,                   droprate =   5 },
            { itemid =  xi.item.BYAKKOS_AXE,                    droprate =   5 },
            { itemid =  xi.item.SUZAKUS_SCYTHE,                 droprate =   5 },
            { itemid =  xi.item.SEIRYUS_SWORD,                  droprate =   5 },
            { itemid =  xi.item.SANGUINE_SWORD,                 droprate =   5 },
        },
        -- Slot 7, Equipment --
        {
            { itemid =  5681,                                   droprate =   5 }, -- Cupid Chocolate
            { itemid = xi.item.AERN_DAGGER,                     droprate =   7 },
            { itemid = xi.item.AERN_SWORD,                      droprate =   7 },
            { itemid = xi.item.AERN_AXE,                        droprate =   7 },
            { itemid = xi.item.AERN_SPEAR,                      droprate =   7 },
            { itemid = xi.item.AERN_STAFF,                      droprate =   7 },
            { itemid = xi.item.CHICKEN_KNIFE_II,                droprate =   7 },
            { itemid = xi.item.GENBUS_KABUTO,                   droprate =   5 },
            { itemid = xi.item.GENBUS_SHIELD,                   droprate =   5 },
            { itemid = xi.item.SEIRYUS_KOTE,                    droprate =   5 },
            { itemid = xi.item.SUZAKUS_SUNE_ATE,                droprate =   5 },
            { itemid = xi.item.BYAKKOS_HAIDATE,                 droprate =   5 },
            { itemid = xi.item.ANIMATOR_P1,                     droprate =   5 },
            { itemid = 17567,                                   droprate =   5 }, -- Kirin's Pole
            { itemid = 12562,                                   droprate =   5 }, -- Kirin's Osode
            { itemid = 19123,                                   droprate =   5 }, -- Cinquedea
            { itemid = 15221,                                   droprate =   5 }, -- Patroclus's Helm
            { itemid = 15182,                                   droprate =   5 }, -- Zoolater Hat
            { itemid = 11343,                                   droprate =   5 }, -- Thrakon Breastplate
            { itemid = 13804,                                   droprate =   5 }, -- Minstrel's Coat
            { itemid = 13805,                                   droprate =   5 }, -- Assault Jerkin
            { itemid = 14467,                                   droprate =   5 }, -- Archer's Jupon
            { itemid = 16126,                                   droprate =   5 }, -- Bowman's Mask
            { itemid = 15744,                                   droprate =   5 }, -- Bowman's Ledelsens
            { itemid = 16034,                                   droprate =   5 }, -- Sarabande Earring
            { itemid = 12361,                                   droprate =   5 }, -- Sipar
            { itemid = 13914,                                   droprate =   5 }, -- Aegishjalmr
            { itemid = 14075,                                   droprate =   5 }, -- Andvaranauts
            { itemid = 13415,                                   droprate =   5 }, -- Pixie Earring
            { itemid = 16300,                                   droprate =   5 }, -- Wit Pendant
            { itemid = 16303,                                   droprate =   5 }, -- Laran's Pendant
            { itemid = 15057,                                   droprate =   5 }, -- Bricta's Cuffs
            { itemid = 14943,                                   droprate =   5 }, -- Barbarossa's Moufles
            { itemid = 16376,                                   droprate =   5 }, -- Bahram Cuisses
            { itemid = 16302,                                   droprate =   3 }, -- Bloodbead Gorget
            { itemid = 11411,                                   droprate =   3 }, -- Shrewd Pumps
            { itemid = 15223,                                   droprate =   3 }, -- Ace's Helm
            { itemid = 18002,                                   droprate =   3 }, -- Perseu's Harp
            { itemid = 14873,                                   droprate =   3 }, -- Bandomusha Kote
            { itemid = 19280,                                   droprate =   3 }, -- Narigitsune
            { itemid = xi.item.WYRM_BEARD,                      droprate =   3 },
            { itemid = xi.item.BEHEMOTH_TONGUE,                 droprate =   3 },
            { itemid = xi.item.ADAMANTOISE_EGG,                 droprate =   3 },
            { itemid = xi.item.SEVENEYES,                       droprate =   3 },
            { itemid = xi.item.ALGOL,                           droprate =   3 },
            { itemid = 13658,                                   droprate =   2 }, -- Shadow Mantle
            { itemid = 14646,                                   droprate =   2 }, -- Shadow Ring
            { itemid = 11589,                                   droprate =   2 }, -- Aesir Torque
            { itemid = 16057,                                   droprate =   2 }, -- Aesir Ear Pendant
            { itemid = 11546,                                   droprate =   2 }, -- Aesir Mantle
            { itemid = 11547,                                   droprate =   2 }, -- Colossus's Mantle
            { itemid = 11590,                                   droprate =   2 }, -- Colossus's Torque
            { itemid = 16058,                                   droprate =   2 }, -- Colossus's Earring
            { itemid = 18019,                                   droprate =   2 }, -- X's Knife
            { itemid = 18057,                                   droprate =   2 }, -- Y's Scythe
            { itemid = 18101,                                   droprate =   2 }, -- Z's Trident
            { itemid = 15899,                                   droprate =   2 }, -- Velocious Belt
            { itemid = 15617,                                   droprate =   2 }, -- Barbarossa's Zerehs
            { itemid = 17586,                                   droprate =   2 }, -- Mercurial Pole
            { itemid = xi.item.JUSTICE_TORQUE,                  droprate =   1 },
            { itemid = xi.item.HOPE_TORQUE,                     droprate =   1 },
            { itemid = xi.item.PRUDENCE_TORQUE,                 droprate =   1 },
            { itemid = xi.item.FORTITUDE_TORQUE,                droprate =   1 },
            { itemid = xi.item.FAITH_TORQUE,                    droprate =   1 },
            { itemid = xi.item.TEMPERANCE_TORQUE,               droprate =   1 },
            { itemid = xi.item.LOVE_TORQUE,                     droprate =   1 },
            { itemid =    0,                                    droprate = 750 }, -- nothing
        },
        -- Slot 4, Materials --
        {
            { itemid = xi.item.MOAT_CARP,                       droprate =   4 },
            { itemid = xi.item.IRON_INGOT,                      droprate =   5 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   5 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   5 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   5 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   5 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   5 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   5 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   5 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   5 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   5 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   5 },
            { itemid = xi.item.RAM_HORN,                        droprate =   5 },
            { itemid = xi.item.ELM_LOG,                         droprate =   5 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   5 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   5 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   5 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   5 },
            { itemid = xi.item.SACK_OF_SILICA,                  droprate =   5 },
            { itemid =  850,                                    droprate =   5 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   5 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   5 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   5 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   5 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   5 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   5 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   5 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   5 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   5 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   5 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   5 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   5 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   5 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   5 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   5 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   5 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   5 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   5 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   5 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   5 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   5 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   5 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   5 },
            { itemid = xi.item.IMP_HORN,                        droprate =   5 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   5 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   5 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   5 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   5 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   5 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   5 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   5 },
            { itemid = 1225,                                    droprate =   5 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   5 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   5 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   5 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   5 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   5 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   5 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   5 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   5 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   5 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   5 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   5 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   5 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   5 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   5 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   5 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   5 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   5 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   5 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   5 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   5 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   5 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   5 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   5 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   5 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   5 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   5 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   5 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   5 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   5 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   5 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   4 },
            { itemid = 2151,                                    droprate =   4 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   4 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   4 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   4 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   4 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   4 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   4 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   4 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   4 }, -- Water Anima
            { itemid = 1647,                                    droprate =   4 }, -- Light Anima
            { itemid = 1648,                                    droprate =   4 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   3 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   3 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   3 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   3 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   3 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   3 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   3 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   3 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   3 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   3 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   3 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   3 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   3 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   3 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   3 },
            { itemid =  734,                                    droprate =   3 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   3 }, -- Amphiptere Hide
            { itemid = 2164,                                    droprate =   4 }, -- Pephredo Hive Chip
            { itemid = 1279,                                    droprate =   4 }, -- Taffeta Cloth
            { itemid = 1280,                                    droprate =   4 }, -- Sarcenet Cloth
            { itemid = 1281,                                    droprate =   4 }, -- Cheviot Cloth
            { itemid = 1295,                                    droprate =   4 }, -- Twincoon
            { itemid = 1270,                                    droprate =   4 }, -- Arachne Web
            { itemid =  647,                                    droprate =   4 }, -- Molybdenum Ore
            { itemid = 1271,                                    droprate =   4 }, -- Pigeon's Blood Ruby
            { itemid = 1276,                                    droprate =   4 }, -- Tarasque Skin
            { itemid = 1296,                                    droprate =   4 }, -- Yowie Skin
            { itemid = 1277,                                    droprate =   4 }, -- Lindwurm Skin
            { itemid = 1765,                                    droprate =   4 }, -- Habu Skin
            { itemid = 2828,                                    droprate =   4 }, -- Herensugue Skin
            { itemid = 2837,                                    droprate =   4 }, -- Ratatoskr Pelt
            { itemid = 2839,                                    droprate =   4 }, -- Coquecigrue Skin
            { itemid = 2830,                                    droprate =   4 }, -- Bastet Fang
            { itemid = 2833,                                    droprate =   4 }, -- Thunder Coral
            { itemid = 1272,                                    droprate =   4 }, -- Arioch Fang
            { itemid = 1273,                                    droprate =   4 }, -- Namtar Bone
            { itemid = 2849,                                    droprate =   4 }, -- Likho Talon
            { itemid = 2846,                                    droprate =   4 }, -- Hefty Oak Lumber
            { itemid = 2855,                                    droprate =   4 }, -- Mahogany Heartwood
            { itemid = xi.item.CHUNK_OF_FIRE_ORE,               droprate =   2 },
            { itemid = xi.item.CHUNK_OF_ICE_ORE,                droprate =   2 },
            { itemid = xi.item.CHUNK_OF_WIND_ORE,               droprate =   2 },
            { itemid = xi.item.CHUNK_OF_EARTH_ORE,              droprate =   2 },
            { itemid = xi.item.CHUNK_OF_LIGHTNING_ORE,          droprate =   2 },
            { itemid = xi.item.CHUNK_OF_WATER_ORE,              droprate =   2 },
            { itemid = xi.item.CHUNK_OF_LIGHT_ORE,              droprate =   2 },
            { itemid = xi.item.CHUNK_OF_DARK_ORE,               droprate =   2 },
            { itemid = xi.item.CLUMP_OF_IMPERIAL_TEA_LEAVES,    droprate =   2 },
            { itemid = xi.item.DRAGON_FRUIT,                    droprate =   1 },
            { itemid = xi.item.WALNUT,                          droprate =   1 },
            { itemid = xi.item.BOWL_OF_AMBROSIA,                droprate =   1 },
            { itemid = xi.item.BOTTLE_OF_AMRITA,                droprate =   1 },
            { itemid = xi.item.DRAGON_HEART,                    droprate =   1 },
            { itemid = xi.item.HANDFUL_OF_DRAGON_SCALES,        droprate =   1 },
            { itemid = xi.item.SLICE_OF_DRAGON_MEAT,            droprate =   1 },
            { itemid = xi.item.CHUNK_OF_HYDRA_MEAT,             droprate =   1 },
            { itemid = xi.item.SLICE_OF_CERBERUS_MEAT,          droprate =   1 },
            { itemid = xi.item.BEHEMOTH_HIDE,                   droprate =   1 },
            { itemid = xi.item.BEHEMOTH_HORN,                   droprate =   1 },
            { itemid = 2158,                                    droprate =   1 }, -- Hydra Fang
            { itemid = 2172,                                    droprate =   1 }, -- Hydra Scale
            { itemid = 2168,                                    droprate =   1 }, -- Cerberus Claw
            { itemid = 2169,                                    droprate =   1 }, -- Cerberus Hide
            { itemid = 2371,                                    droprate =   1 }, -- Khimaira Horn
            { itemid = 2372,                                    droprate =   1 }, -- Khimaira Mane
            { itemid = 2373,                                    droprate =   1 }, -- Khimaira Tail
            { itemid = 4273,                                    droprate =   1 }, -- Kitron
            { itemid = 1718,                                    droprate =   1 }, -- M-bugard Tusk
            { itemid = 1719,                                    droprate =   1 }, -- Harajnite Shell
            { itemid =    0,                                    droprate = 250 }, -- nothing
        },
        -- Slot 5, Misc/Medicine --
        {
            { itemid = xi.item.RERAISER,                        droprate = 100 },
            { itemid = xi.item.REMEDY,                          droprate =  80 },
            { itemid = xi.item.HI_RERAISER,                     droprate =  70 },
            { itemid = xi.item.FLASK_OF_ECHO_DROPS,             droprate =  50 },
            { itemid = xi.item.FLASK_OF_HOLY_WATER,             droprate =  50 },
            { itemid = xi.item.SUPER_RERAISER,                  droprate =  60 },
            { itemid = xi.item.ICARUS_WING,                     droprate =  60 },
            { itemid = xi.item.VILE_ELIXIR,                     droprate =  60 },
            { itemid = xi.item.VILE_ELIXIR_P1,                  droprate =  50 },
            { itemid = xi.item.FIRE_CLUSTER,                    droprate =  20 },
            { itemid = xi.item.ICE_CLUSTER,                     droprate =  20 },
            { itemid = xi.item.WIND_CLUSTER,                    droprate =  20 },
            { itemid = xi.item.EARTH_CLUSTER,                   droprate =  20 },
            { itemid = xi.item.LIGHTNING_CLUSTER,               droprate =  20 },
            { itemid = xi.item.WATER_CLUSTER,                   droprate =  20 },
            { itemid = xi.item.LIGHT_CLUSTER,                   droprate =  20 },
            { itemid = xi.item.DARK_CLUSTER,                    droprate =  20 },
            { itemid = 5356,                                    droprate =  60 }, -- Remedy Ointment
            { itemid = 4153,                                    droprate =  60 }, -- Antacid
            { itemid = 4512,                                    droprate =  50 }, -- Vampire Juice
            { itemid = 4149,                                    droprate =  30 }, -- Panacea
            { itemid = 5254,                                    droprate =  25 }, -- Hyper Potion
            { itemid = 5255,                                    droprate =  25 }, -- Hyper Ether
            { itemid = xi.item.MOAT_CARP,                       droprate =  10 },
        },
    },
    [45] =
    {   -- Slot 1, Currency --
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate =  70 },
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  50 },
            { itemid = xi.item.COTTON_COIN_PURSE,               droprate =  50 },
            { itemid = xi.item.LINEN_COIN_PURSE,                droprate =  50 },
            { itemid = xi.item.ONE_BYNE_BILL,                   droprate =  80 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =  30 },
            { itemid = xi.item.ORDELLE_BRONZEPIECE,             droprate =  80 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =  30 },
            { itemid = xi.item.TUKUKU_WHITESHELL,               droprate =  80 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =  30 },
            { itemid = xi.item.BEASTMENS_SEAL,                  droprate =  10 },
            { itemid = xi.item.KINDREDS_SEAL,                   droprate =  10 },
            { itemid =  6541,                                   droprate =  70 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  70 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  70 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  70 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  70 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter
        },
        -- Slot 6, Currency --
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate =  10 },
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  40 },
            { itemid = xi.item.COTTON_COIN_PURSE,               droprate =  40 },
            { itemid = xi.item.ONE_BYNE_BILL,                   droprate =  65 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =   5 },
            { itemid = xi.item.ORDELLE_BRONZEPIECE,             droprate =  65 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =   5 },
            { itemid = xi.item.TUKUKU_WHITESHELL,               droprate =  65 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =   5 },
            { itemid = xi.item.BEASTMENS_SEAL,                  droprate =  20 },
            { itemid = xi.item.KINDREDS_SEAL,                   droprate =  20 },
            { itemid =  6541,                                   droprate =  30 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  30 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  30 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  30 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  30 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =   1 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =   1 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =   1 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =   1 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =   1 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =   1 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =   1 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =   1 }, -- Wyrmal Tatter
            { itemid =     0,                                   droprate = 500 }, -- Nothing            
        },
        -- Slot 10, Tatters --
        {
            { itemid =  3283,                                   droprate =  93 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  93 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  93 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  93 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  93 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  93 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  93 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  93 }, -- Wyrmal Tatter
            { itemid =     0,                                   droprate = 250 }, -- Nothing
        },
        -- Slot 2, Pop Items --
        {
            { itemid = xi.item.CURTANA,                         droprate =  10 },
            { itemid = xi.item.CHUNK_OF_DIORITE,                droprate =  10 },
            { itemid = xi.item.FLASK_OF_ROMAEVE_SPRING_WATER,   droprate =  10 },
            { itemid = xi.item.GEM_OF_THE_EAST,                 droprate =  20 },
            { itemid = xi.item.SPRINGSTONE,                     droprate =  20 },
            { itemid = xi.item.GEM_OF_THE_SOUTH,                droprate =  20 },
            { itemid = xi.item.SUMMERSTONE,                     droprate =  20 },
            { itemid = xi.item.GEM_OF_THE_WEST,                 droprate =  20 },
            { itemid = xi.item.AUTUMNSTONE,                     droprate =  20 },
            { itemid = xi.item.GEM_OF_THE_NORTH,                droprate =  20 },
            { itemid = xi.item.WINTERSTONE,                     droprate =  20 },
            { itemid = xi.item.IVORY_CHIP,                      droprate =  30 },
            { itemid = xi.item.SCARLET_CHIP,                    droprate =  30 },
            { itemid = xi.item.EMERALD_CHIP,                    droprate =  30 },
            { itemid = xi.item.SILVER_CHIP,                     droprate =  20 },
            { itemid = xi.item.CERULEAN_CHIP,                   droprate =  20 },
            { itemid = 1986,                                    droprate =  20 }, -- Orchid Chip
            { itemid = xi.item.SMALT_CHIP,                      droprate =  20 },
            { itemid = xi.item.SMOKY_CHIP,                      droprate =  20 },
            { itemid = 1987,                                    droprate =  20 }, -- Charcoal Chip
            { itemid = 1988,                                    droprate =  20 }, -- Magenta Chip
            { itemid =  1288,                                   droprate =   5 }, -- Wooden Hakutatku Eye
            { itemid =  1289,                                   droprate =   5 }, -- Burning Hakutatku Eye
            { itemid =  1290,                                   droprate =   5 }, -- Earthen Hakutatku Eye
            { itemid =  1291,                                   droprate =   5 }, -- Golden Hakutatku Eye
            { itemid =  1292,                                   droprate =   5 }, -- Damp Hakutatku Eye
            { itemid = xi.item.DEED_OF_PLACIDITY,               droprate =  40 },
            { itemid = xi.item.DEED_OF_SENSIBILITY,             droprate =  40 },
            { itemid =  1854,                                   droprate =  40 }, -- Deed of Moderation
            { itemid = xi.item.FIRST_VIRTUE,                    droprate =  20 },
            { itemid =  1853,                                   droprate =  20 }, -- Second Virtue
            { itemid = xi.item.THIRD_VIRTUE,                    droprate =  20 },
            { itemid = xi.item.ANTLION_TRAP,                    droprate =   5 },
            { itemid = xi.item.HAUNTED_MULETA,                  droprate =   5 },
            { itemid = xi.item.SHRIMP_LANTERN,                  droprate =   5 },
            { itemid = xi.item.HELLCAGE_BUTTERFLY,              droprate =  20 },
            { itemid = xi.item.JUG_OF_FLORAL_NECTAR,            droprate =  20 },
            { itemid = xi.item.WEDGE_OF_RODENT_CHEESE,          droprate =  20 },
            { itemid = xi.item.CLUMP_OF_SHADELEAVES,            droprate =  20 },
            { itemid = xi.item.BEAKER_OF_PECTIN,                droprate =  20 },
            { itemid = xi.item.FLASK_OF_COG_LUBRICANT,          droprate =  20 },
            { itemid = xi.item.GOLDEN_TEETH,                    droprate =  20 },
            { itemid = xi.item.GREENLING,                       droprate =  20 },
            { itemid = xi.item.BOTTLE_OF_SPOILT_BLOOD,          droprate =  20 },
            { itemid = xi.item.BUNCH_OF_SENORITA_PAMAMAS,       droprate =  20 },
            { itemid = xi.item.JAR_OF_OILY_BLOOD,               droprate =  20 },
            { itemid = xi.item.STRAND_OF_SAMARIRI_CORPSEHAIR,   droprate =  20 },
            { itemid = xi.item.SLAB_OF_RAW_BUFFALO,             droprate =  20 },
            { itemid = xi.item.LUMP_OF_BONE_CHARCOAL,           droprate =  20 },
            { itemid = xi.item.PINCH_OF_GRANULATED_SUGAR,       droprate =  20 },
            { itemid = xi.item.MINT_DROP,                       droprate =  20 },
            { itemid = xi.item.OPALUS_GEM,                      droprate =  20 },
            { itemid = xi.MERROW_NO_11_MOLTING,                 droprate =  20 },
        },
        -- Slot 3, Equipment --
        {
            { itemid = xi.item.DUENDE_COTEHARDIE,               droprate =   4 },
            { itemid = xi.item.NOKIZARU_GI,                     droprate =   4 },
            { itemid = xi.item.RAPPAREE_HARNESS,                droprate =   4 },
            { itemid = xi.item.SHINIMUSHA_HARA_ATE,             droprate =   4 },
            { itemid = xi.item.WYVERN_MAIL,                     droprate =   4 },
            { itemid = xi.item.SHIKAREE_AKETON,                 droprate =   4 },
            { itemid = xi.item.CERISE_DOUBLET,                  droprate =   4 },
            { itemid = xi.item.GLAMOR_JUPON,                    droprate =   4 },
            { itemid = xi.item.GLOOM_BREASTPLATE,               droprate =   4 },
            { itemid = xi.item.NIMBUS_DOUBLET,                  droprate =   4 },
            { itemid = xi.item.AIKIDO_GI,                       droprate =   4 },
            { itemid = xi.item.PARADE_CUIRASS,                  droprate =   4 },
            { itemid = xi.item.GAUDY_HARNESS,                   droprate =   4 },
            { itemid = xi.item.HAMAYUMI,                        droprate =   5 },
            { itemid = xi.item.DIA_WAND,                        droprate =   4 },
            { itemid = xi.item.STONE_GORGET,                    droprate =   5 },
            { itemid =  18359,                                  droprate =   5 }, -- Boreas Cesti
            { itemid =  15468,                                  droprate =   5 }, -- Resentment Cape
            { itemid =  xi.item.GOTHIC_SABATONS,                droprate =   5 },
            { itemid =  xi.item.GOTHIC_GAUNTLETS,               droprate =   5 },
            { itemid =  16187,                                  droprate =   5 }, -- Adoubeurs Pavise
            { itemid =  16899,                                  droprate =   5 }, -- Hototogisu
            { itemid =  16374,                                  droprate =   5 }, -- Layqa Seraweels
            { itemid =  17199,                                  droprate =   5 }, -- Loxley Bow
            { itemid =  16882,                                  droprate =   5 }, -- Calamar
            { itemid =  17504,                                  droprate =   5 }, -- Pagures
            { itemid =  16884,                                  droprate =   5 }, -- Narval
            { itemid =  17503,                                  droprate =   5 }, -- Exocets
            { itemid =  19238,                                  droprate =   5 }, -- Jasper Tathlum
            { itemid =  11404,                                  droprate =   5 }, -- Promptitude Solea
            { itemid =  15897,                                  droprate =   5 }, -- Grace Corset
            { itemid =  13803,                                  droprate =   5 }, -- Shaman's Cloak
            { itemid =  19237,                                  droprate =   5 }, -- Slick Dart
            { itemid =  15942,                                  droprate =   5 }, -- Summoning Belt
            { itemid =  xi.item.MUSHROOM_HELM,                  droprate =   2 },
            { itemid =  xi.item.LUNA_SUBLIGAR,                  droprate =   2 },
            { itemid =  16980,                                  droprate =   5 }, -- Sukesada
            { itemid =  13912,                                  droprate =   5 }, -- Shadow Mask
            { itemid =  16943,                                  droprate =   5 }, -- Ascalon
            { itemid =  14063,                                  droprate =   5 }, -- Protecting Bangles
            { itemid =  14064,                                  droprate =   5 }, -- Sand Gloves
            { itemid =  17651,                                  droprate =   5 }, -- Dainslaif
            { itemid =  17924,                                  droprate =   5 }, -- Tungi
            { itemid =  16734,                                  droprate =   5 }, -- Pendragon Axe
            { itemid =  15995,                                  droprate =   5 }, -- Carline Earring
            { itemid =  16127,                                  droprate =   5 }, -- Carline Ribbon
            { itemid =  16125,                                  droprate =   5 }, -- Breeder Mask
            { itemid =  15001,                                  droprate =   5 }, -- Breeder Mufflers
            { itemid =  15946,                                  droprate =   5 }, -- Tempest Belt
            { itemid =  11405,                                  droprate =   5 }, -- Kyoshu Kyahan
            { itemid =  11533,                                  droprate =   5 }, -- Lyricist's Gonnelle
            { itemid =  16298,                                  droprate =   5 }, -- Knack Pendant
            { itemid =  17454,                                  droprate =   5 }, -- Asklepios
            { itemid =  17455,                                  droprate =   5 }, -- Skirnir's Wand
            { itemid =  16912,                                  droprate =   5 }, -- Kitsutsuki
            { itemid =  17926,                                  droprate =   5 }, -- Acha D'Armas
            { itemid =  17982,                                  droprate =   5 }, -- Kard
            { itemid =  17983,                                  droprate =   5 }, -- Valiant Knife
            { itemid =  18042,                                  droprate =   5 }, -- Ascention
            { itemid =  17563,                                  droprate =   5 }, -- Power Staff
            { itemid =  17969,                                  droprate =   5 }, -- Fendoir
            { itemid =  18608,                                  droprate =   5 }, -- Atesh Pole
            { itemid =  16727,                                  droprate =   5 }, -- Eisentaenzer
            { itemid =  17971,                                  droprate =   5 }, -- Tartaglia
            { itemid =  19235,                                  droprate =   5 }, -- Veuglaire
            { itemid =  16375,                                  droprate =   5 }, -- Surge Subligar
            { itemid =  xi.item.ASTRAL_ASPIS,                   droprate =   5 },
            { itemid =  xi.item.GAE_BOLG,                       droprate =   5 },
            { itemid =  xi.item.LOHAR,                          droprate =   5 },
            { itemid =   19122,                                 droprate =   5 }, -- Courser's Pugio
            { itemid =   16081,                                 droprate =   5 }, -- Curate's Hat
            { itemid =   15882,                                 droprate =   5 }, -- Othinus' Bow
            { itemid =   17244,                                 droprate =   5 }, -- Storm Belt
            { itemid =   14806,                                 droprate =   5 }, -- Intruder Earring
            { itemid =   14466,                                 droprate =   5 }, -- Fomor Tunic
            { itemid =   18007,                                 droprate =   5 }, -- Chiroptera Dagger
            { itemid =   17510,                                 droprate =   5 }, -- Vampiric Claws
            { itemid =   14763,                                 droprate =   5 }, -- Boroka Earring
            { itemid =   13178,                                 droprate =   5 }, -- Auditory Torque
            { itemid =   15943,                                 droprate =   5 }, -- Virtuoso Belt
            { itemid =   14884,                                 droprate =   5 }, -- Mycophile Cuffs
            { itemid =   17794,                                 droprate =   5 }, -- Niokiyotsuna
            { itemid =   15219,                                 droprate =   5 }, -- Sinister Mask
            { itemid =   16368,                                 droprate =   5 }, -- Herder's Subligar
            { itemid =   14724,                                 droprate =   5 }, -- Moldavite Earring
            { itemid =   16279,                                 droprate =   5 }, -- Pile Chain
            { itemid =   15546,                                 droprate =   5 }, -- Fasting Ring
            { itemid =   16299,                                 droprate =   5 }, -- Lleu's Charm
            { itemid =   11496,                                 droprate =   5 }, -- Fenrir's Crown
            { itemid =   14168,                                 droprate =   5 }, -- Dune Boots
            { itemid =   17854,                                 droprate =   5 }, -- Cradle Horn
            { itemid =   19239,                                 droprate =   5 }, -- Astrolable
            { itemid =   16169,                                 droprate =   5 }, -- Caballero Shield
            { itemid =   17653,                                 droprate =   5 }, -- Hrotti
            { itemid =   18027,                                 droprate =   5 }, -- Palladium Dagger
            { itemid =   17564,                                 droprate =   5 }, -- Cocytus Pole
            { itemid =   16426,                                 droprate =   5 }, -- Avengers
            { itemid =   19121,                                 droprate =   5 }, -- Sleight Kukri
            { itemid =   15944,                                 droprate =   7 }, -- Selemnus Belt
            { itemid =   16297,                                 droprate =   7 }, -- Shepherd's Chain
            { itemid =  xi.item.KAMEWARI,                       droprate =   5 },
            { itemid =  xi.item.NADRS,                          droprate =   5 },
            { itemid =  xi.item.ALTDORFS_EARRING,               droprate =   5 },
            { itemid =  xi.item.WILHELMS_EARRING,               droprate =   5 },
            { itemid =  xi.item.HELENUSS_EARRING,               droprate =   5 },
            { itemid =  xi.item.CASSANDRAS_EARRING,             droprate =   5 },
            { itemid =  xi.item.MINSTRELS_DAGGER,               droprate =   5 },
            { itemid =  xi.item.SAND_CHARM,                     droprate =   5 },
            { itemid =   15692,                                 droprate =   5 }, -- Storm Crackows
            { itemid =   14669,                                 droprate =   5 }, -- Jaeger Ring
            { itemid =   15351,                                 droprate =   5 }, -- Bounding Boots
            { itemid =   18018,                                 droprate =   5 }, -- Sirocco Kukri
            { itemid =   13567,                                 droprate =   5 }, -- Bomb Queen Ring
            { itemid =   15547,                                 droprate =   5 }, -- Vilma's Ring
            { itemid =   26164,                                 droprate =   5 }, -- Caliber Ring
            { itemid =   15183,                                 droprate =   7 }, -- Dobson Bandana
            { itemid =   15184,                                 droprate =   7 }, -- Voyager Sallet
            { itemid =   14986,                                 droprate =   7 }, -- Ochimusha Kote
            { itemid =   15737,                                 droprate =   7 }, -- Sarutobi Kyahan
            { itemid =   15551,                                 droprate =   7 }, -- Shikaree Ring
            { itemid =  xi.item.EMPRESS_HAIRPIN,                droprate =   7 },
            { itemid =  xi.item.JOYEUSE,                        droprate =   7 },
            { itemid =  xi.item.DRYAD_STAFF,                    droprate =   7 },
            { itemid =  xi.item.VALIS_BOW,                      droprate =   7 },
            { itemid =  xi.item.RETALIATORS,                    droprate =   7 },
            { itemid =  xi.item.UNGUR_BOOMERANG,                droprate =   7 },
            { itemid =   15515,                                 droprate =   7 }, -- Peacock Amulet
            { itemid =  xi.item.TROTTER_BOOTS,                  droprate =   7 },
            { itemid =   19236,                                 droprate =   7 }, -- Hightail Bullet
            { itemid =   17192,                                 droprate =   7 }, -- Ifrit's Bow
            { itemid =   17711,                                 droprate =   7 }, -- Shiva's Shotel
            { itemid =   18021,                                 droprate =   7 }, -- Titan's Baselarde
            { itemid =   18063,                                 droprate =   7 }, -- Garuda's Sickle
            { itemid =   18109,                                 droprate =   7 }, -- Leviathan's Couse
            { itemid =   18404,                                 droprate =   7 }, -- Ramuh's Mace
            { itemid =   18581,                                 droprate =   7 }, -- Carbuncle's Pole
            { itemid =   14931,                                 droprate =   7 }, -- Carbuncle's Cuffs
            { itemid =   18422,                                 droprate =   7 }, -- Ryumon
            { itemid =   14960,                                 droprate =   7 }, -- Evoker's Gages
            { itemid =   19277,                                 droprate =   7 }, -- Tsugumi
            { itemid =   11408,                                 droprate =   7 }, -- Morana Pigaches
            { itemid =   11409,                                 droprate =   7 }, -- Aoide's Pumps
            { itemid =   16238,                                 droprate =   7 }, -- Taster's Cape
            { itemid =   11497,                                 droprate =   7 }, -- Spurrer Beret
            { itemid =   11406,                                 droprate =   7 }, -- Stimulus Sabots
            { itemid =   18767,                                 droprate =   6 }, -- Birdbanes
            { itemid =   15854,                                 droprate =   7 }, -- Sortie Ring
            { itemid =   15915,                                 droprate =   7 }, -- Sothic Rope
            { itemid =   11342,                                 droprate =   6 }, -- Restorer Cloak
            { itemid =   18770,                                 droprate =   7 }, -- Pygme Sainti
            { itemid =   17737,                                 droprate =   6 }, -- Corsair's Scimitar
            { itemid =   19124,                                 droprate =   7 }, -- Creve-coeur
            { itemid =   19279,                                 droprate =   7 }, -- Musanto
            { itemid =   17766,                                 droprate =   7 }, -- Lyft Scimitar
            { itemid =   17970,                                 droprate =   7 }, -- Lyft Tabar
            { itemid =   18508,                                 droprate =   7 }, -- Lyft Voulge
            { itemid =   18609,                                 droprate =   7 }, -- Lyft Pole
            { itemid =   18771,                                 droprate =   7 }, -- Lyft Sainti
            { itemid =   18872,                                 droprate =   7 }, -- Lyft Ferule
            { itemid =   18958,                                 droprate =   7 }, -- Lyft Scythe
            { itemid =   19125,                                 droprate =   7 }, -- Lyft Jambiya
            { itemid =   19161,                                 droprate =   7 }, -- Lyft Claymore
            { itemid =   19233,                                 droprate =   7 }, -- Lyft Crossbow
            { itemid =   19306,                                 droprate =   7 }, -- Lyft Lance
            { itemid =  xi.item.LAVAS_RING,                     droprate =   7 },
            { itemid =  xi.item.KUSHAS_RING,                    droprate =   7 },
            { itemid =  xi.item.NASATYAS_RING,                  droprate =   7 },
            { itemid =  xi.item.DASRAS_RING,                    droprate =   7 },
            { itemid =  xi.item.HOPE_STAFF,                     droprate =   7 },
            { itemid =  xi.item.JUSTICE_SWORD,                  droprate =   7 },
            { itemid =  xi.item.TEMPERANCE_AXE,                 droprate =   7 },
            { itemid =  xi.item.LOVE_HALBERD,                   droprate =   7 },
            { itemid =  xi.item.FORTITUDE_AXE,                  droprate =   7 },
            { itemid =  xi.item.FAITH_BAGHNAKHS,                droprate =   7 },
            { itemid =  xi.item.PRUDENCE_ROD,                   droprate =   7 },
            { itemid =  xi.item.BYAKKOS_AXE,                    droprate =   8 },
            { itemid =  xi.item.SUZAKUS_SCYTHE,                 droprate =   8 },
            { itemid =  xi.item.SEIRYUS_SWORD,                  droprate =   8 },
        },
        -- Slot 7, Equipment --
        {
            { itemid =  5681,                                   droprate =   4 }, -- Cupid Chocolate
            { itemid = xi.item.AERN_DAGGER,                     droprate =   7 },
            { itemid = xi.item.AERN_SWORD,                      droprate =   7 },
            { itemid = xi.item.AERN_AXE,                        droprate =   7 },
            { itemid = xi.item.AERN_SPEAR,                      droprate =   7 },
            { itemid = xi.item.AERN_STAFF,                      droprate =   7 },
            { itemid = xi.item.CHICKEN_KNIFE_II,                droprate =   7 },
            { itemid = xi.item.GENBUS_KABUTO,                   droprate =   7 },
            { itemid = xi.item.GENBUS_SHIELD,                   droprate =   7 },
            { itemid = xi.item.SEIRYUS_KOTE,                    droprate =   7 },
            { itemid = xi.item.SUZAKUS_SUNE_ATE,                droprate =   7 },
            { itemid = xi.item.BYAKKOS_HAIDATE,                 droprate =   7 },
            { itemid = xi.item.ANIMATOR_P1,                     droprate =   5 },
            { itemid = 17567,                                   droprate =   5 }, -- Kirin's Pole
            { itemid = 12562,                                   droprate =   5 }, -- Kirin's Osode
            { itemid = 16034,                                   droprate =   5 }, -- Sarabande Earring
            { itemid = 13415,                                   droprate =   5 }, -- Pixie Earring
            { itemid = 16300,                                   droprate =   5 }, -- Wit Pendant
            { itemid = 16303,                                   droprate =   5 }, -- Laran's Pendant
            { itemid = 15057,                                   droprate =   5 }, -- Bricta's Cuffs
            { itemid = 14943,                                   droprate =   5 }, -- Barbarossa's Moufles
            { itemid = 16376,                                   droprate =   5 }, -- Bahram Cuisses
            { itemid = 16302,                                   droprate =   4 }, -- Bloodbead Gorget
            { itemid = 11411,                                   droprate =   4 }, -- Shrewd Pumps
            { itemid = 15223,                                   droprate =   4 }, -- Ace's Helm
            { itemid = 18002,                                   droprate =   4 }, -- Perseu's Harp
            { itemid = 14873,                                   droprate =   4 }, -- Bandomusha Kote
            { itemid = 19280,                                   droprate =   4 }, -- Narigitsune
            { itemid = xi.item.WYRM_BEARD,                      droprate =   4 },
            { itemid = xi.item.BEHEMOTH_TONGUE,                 droprate =   4 },
            { itemid = xi.item.ADAMANTOISE_EGG,                 droprate =   4 },
            { itemid = xi.item.SEVENEYES,                       droprate =   4 },
            { itemid = xi.item.ALGOL,                           droprate =   4 },
            { itemid = 13658,                                   droprate =   3 }, -- Shadow Mantle
            { itemid = 14646,                                   droprate =   3 }, -- Shadow Ring
            { itemid = 11589,                                   droprate =   3 }, -- Aesir Torque
            { itemid = 16057,                                   droprate =   3 }, -- Aesir Ear Pendant
            { itemid = 11546,                                   droprate =   3 }, -- Aesir Mantle
            { itemid = 11547,                                   droprate =   3 }, -- Colossus's Mantle
            { itemid = 11590,                                   droprate =   3 }, -- Colossus's Torque
            { itemid = 16058,                                   droprate =   3 }, -- Colossus's Earring
            { itemid = 18019,                                   droprate =   3 }, -- X's Knife
            { itemid = 18057,                                   droprate =   3 }, -- Y's Scythe
            { itemid = 18101,                                   droprate =   3 }, -- Z's Trident
            { itemid = 15899,                                   droprate =   3 }, -- Velocious Belt
            { itemid = 15617,                                   droprate =   3 }, -- Barbarossa's Zerehs
            { itemid = 17586,                                   droprate =   3 }, -- Mercurial Pole
            { itemid = xi.item.JUSTICE_TORQUE,                  droprate =   2 },
            { itemid = xi.item.HOPE_TORQUE,                     droprate =   2 },
            { itemid = xi.item.PRUDENCE_TORQUE,                 droprate =   2 },
            { itemid = xi.item.FORTITUDE_TORQUE,                droprate =   2 },
            { itemid = xi.item.FAITH_TORQUE,                    droprate =   2 },
            { itemid = xi.item.TEMPERANCE_TORQUE,               droprate =   2 },
            { itemid = xi.item.LOVE_TORQUE,                     droprate =   1 },
            { itemid = xi.item.RIDILL,                          droprate =   1 },
            { itemid = xi.item.OCTAVE_CLUB,                     droprate =   1 },
            { itemid = xi.item.HAUTECLAIRE,                     droprate =   1 },
            { itemid = 13566,                                   droprate =   1 }, -- Defending Ring
            { itemid = 27456,                                   droprate =   1 }, -- Crier's Gaiters
            { itemid = 14468,                                   droprate =   2 }, -- Yinyang Robe
            { itemid = 17754,                                   droprate =   3 }, -- Sylphid Epee
            { itemid = 16154,                                   droprate =   3 }, -- Karura Hachigane
            { itemid = 16000,                                   droprate =   3 }, -- Dragoon's Earring
            { itemid = 16240,                                   droprate =   3 }, -- Erato's Cape
            { itemid = 17755,                                   droprate =   3 }, -- Beast Slayer
            { itemid = 16340,                                   droprate =   3 }, -- Armadillo Cuisses
            { itemid = 17961,                                   droprate =   3 }, -- Lion Tamer
            { itemid = 15018,                                   droprate =   3 }, -- Ritterhentzes
            { itemid = 18859,                                   droprate =   3 }, -- Kerykeion
            { itemid = 16274,                                   droprate =   3 }, -- Almah Torque
            { itemid = 15999,                                   droprate =   3 }, -- Guignol Earring
            { itemid = 15916,                                   droprate =   3 }, -- Corsair's Belt
            { itemid = 18950,                                   droprate =   3 }, -- White Joker
            { itemid = 11369,                                   droprate =   3 }, -- Numerist Pumps
            { itemid = 11368,                                   droprate =   3 }, -- Hakke Habaki
            { itemid = 15827,                                   droprate =   3 }, -- Insect Ring
            { itemid = 15828,                                   droprate =   3 }, -- Blood Ring
            { itemid = 19154,                                   droprate =   3 }, -- Ferrara
            { itemid = 11366,                                   droprate =   3 }, -- Avocat Pigaches
            { itemid = 15017,                                   droprate =   3 }, -- Toad Mittens
            { itemid = 16339,                                   droprate =   3 }, -- Paddock Trousers
            { itemid = 16153,                                   droprate =   3 }, -- Reikyo Hairpin
            { itemid = 11367,                                   droprate =   3 }, -- Nobushi Kyahan
            { itemid = 19109,                                   droprate =   3 }, -- Trilling Dagger
            { itemid = 18448,                                   droprate =   3 }, -- Hacchonenbutsu
            { itemid = 19211,                                   droprate =   3 }, -- Reacton Arm
            { itemid = 19028,                                   droprate =   3 }, -- Magic Strap
            { itemid = 18127,                                   droprate =   3 }, -- Achilles' Spear
            { itemid = 16338,                                   droprate =   3 }, -- Ruby Seraweels
            { itemid = 18949,                                   droprate =   3 }, -- Zareehkl Scythe
            { itemid = 19108,                                   droprate =   3 }, -- Zareehkl Jambiya
            { itemid = 16239,                                   droprate =   3 }, -- Solitaire Cape
            { itemid = 16175,                                   droprate =   3 }, -- Muse Tariqah
            { itemid = 16152,                                   droprate =   3 }, -- Hissho Hachimaki
            { itemid = 16174,                                   droprate =   3 }, -- Riot Shield
            { itemid = 18126,                                   droprate =   2 }, -- Tomoe
            { itemid = xi.item.ORACLES_GLOVES,                  droprate =   2 },
            { itemid = xi.item.AURUM_SABATONS,                  droprate =   2 },
            { itemid = 19031,                                   droprate =   2 }, -- Fire Grip
            { itemid = 19032,                                   droprate =   2 }, -- Water Grip
            { itemid = 19033,                                   droprate =   2 }, -- Wind Grip
            { itemid = 19034,                                   droprate =   2 }, -- Ice Grip
            { itemid = 19035,                                   droprate =   2 }, -- Thunder Grip
            { itemid = 19036,                                   droprate =   2 }, -- Earth Grip
            { itemid = 19037,                                   droprate =   2 }, -- Light Grip
            { itemid = 19038,                                   droprate =   2 }, -- Dark Grip
            { itemid = xi.item.ENKIDUS_MITTENS,                 droprate =   2 },
            { itemid = xi.item.AURUM_CUISSES,                   droprate =   2 },
            { itemid = 19153,                                   droprate =   2 }, -- Naglering
            { itemid = 18125,                                   droprate =   2 }, -- Cletine
            { itemid = xi.item.ENKIDUS_SUBLIGAR,                droprate =   2 },
            { itemid = xi.item.ORACLES_PIGACHES,                droprate =   2 },
            { itemid = 17960,                                   droprate =   2 }, -- Labrys
            { itemid = xi.item.ENKIDUS_LEGGINGS,                droprate =   2 },
            { itemid = xi.item.AURUM_GAUNTLETS,                 droprate =   2 },
            { itemid = 16176,                                   droprate =   2 }, -- Simba Buckler
            { itemid = 17753,                                   droprate =   2 }, -- Organics
            { itemid = xi.item.ORACLES_BRACONI,                 droprate =   2 },
            { itemid = 16177,                                   droprate =   2 }, -- Legion Scutum
            { itemid = 18595,                                   droprate =   2 }, -- Mekki Shakki
            { itemid = 18430,                                   droprate =   2 }, -- Oninohocho        
            { itemid = 10754,                                   droprate =   2 }, -- Moepapa Ring
            { itemid = 10755,                                   droprate =   2 }, -- Moepapa Annulet
            { itemid = 10756,                                   droprate =   2 }, -- Tjukurrpa Ring
            { itemid = 10757,                                   droprate =   2 }, -- Tjukurrpa Annulet
            { itemid = 10759,                                   droprate =   2 }, -- Aife's Annulet
            { itemid = 10817,                                   droprate =   2 }, -- Moepapa Stone
            { itemid = 10818,                                   droprate =   2 }, -- Tjukurrpa Belt
            { itemid = 10932,                                   droprate =   2 }, -- Oneiros torque
            { itemid = 10933,                                   droprate =   2 }, -- Mujin necklace
            { itemid = 10940,                                   droprate =   2 }, -- Moepapa Pendant
            { itemid = 10941,                                   droprate =   2 }, -- Tjukurrpa Medal
            { itemid = 10942,                                   droprate =   2 }, -- Aife's Medal
            { itemid = 10943,                                   droprate =   2 }, -- Moepapa Medal
            { itemid = 10972,                                   droprate =   2 }, -- Oneiros cappa
            { itemid = 10973,                                   droprate =   2 }, -- Oneiros cape
            { itemid = 10974,                                   droprate =   2 }, -- Mujin mantle
            { itemid = 10983,                                   droprate =   2 }, -- Aife's Mantle
            { itemid = 10984,                                   droprate =   2 }, -- Tjukurrpa Mantle
            { itemid = 11030,                                   droprate =   2 }, -- Oneiros earring
            { itemid = 11032,                                   droprate =   2 }, -- Mujin Stud
            { itemid = 11031,                                   droprate =   2 }, -- Oneiros pearl
            { itemid = 11456,                                   droprate =   2 }, -- Ryuga Sune-Ate
            { itemid = 11461,                                   droprate =   2 }, -- Aife's Pumps
            { itemid = 11670,                                   droprate =   2 }, -- Oneiros annulet
            { itemid = 11671,                                   droprate =   2 }, -- Oneiros ring
            { itemid = 11672,                                   droprate =   2 }, -- Mujin band
            { itemid = 11772,                                   droprate =   2 }, -- Oneiros sash
            { itemid = 11773,                                   droprate =   2 }, -- Oneiros belt
            { itemid = 11774,                                   droprate =   2 }, -- Oneiros cest
            { itemid = 11775,                                   droprate =   2 }, -- Oneiros rope
            { itemid = 11776,                                   droprate =   2 }, -- Mujin obi
            { itemid = 11820,                                   droprate =   2 }, -- Khthonios Mask
            { itemid = 11821,                                   droprate =   2 }, -- Khthonios Helm
            { itemid = 11816,                                   droprate =   2 }, -- Oneiros helm
            { itemid = 11817,                                   droprate =   2 }, -- Oneiros barbut
            { itemid = 11818,                                   droprate =   2 }, -- Oneiros headgear
            { itemid = 11819,                                   droprate =   2 }, -- Oneiros coif 
            { itemid = 11923,                                   droprate =   2 }, -- Tjukurrpa Gauntlets
            { itemid = 11918,                                   droprate =   2 }, -- Khthonios Gloves
            { itemid = 11919,                                   droprate =   2 }, -- Avesta Bangles
            { itemid = 17069,                                   droprate =   2 }, -- Moepapa Mace
            { itemid = 17358,                                   droprate =   2 }, -- Oneiros Harp
            { itemid = 18519,                                   droprate =   2 }, -- Oneiros axe
            { itemid = 18541,                                   droprate =   2 }, -- Tjukurrpa Axe 
            { itemid = 18623,                                   droprate =   2 }, -- Chtonic Staff
            { itemid = 18811,                                   droprate =   2 }, -- Oneiros grip
            { itemid = 19141,                                   droprate =   2 }, -- Oneiros knife
            { itemid = 19295,                                   droprate =   2 }, -- Mujin tanto
            { itemid = 19738,                                   droprate =   2 }, -- Aife's Bow
            { itemid = 19762,                                   droprate =   2 }, -- Oneiros Tathlum  
            { itemid = 19763,                                   droprate =   2 }, -- Oneiros Cluster  
            { itemid = 19767,                                   droprate =   2 }, -- Oneiros pebble
            { itemid = 19790,                                   droprate =   2 }, -- Oneiros lance
            { itemid =    0,                                    droprate = 500 }, -- nothing
        },
        -- Slot 4, Materials --
        {
            { itemid = xi.item.MOAT_CARP,                       droprate =   5 },
            { itemid = xi.item.IRON_INGOT,                      droprate =   5 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   5 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   5 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   5 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   5 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   5 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   5 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   5 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   5 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   5 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   5 },
            { itemid = xi.item.RAM_HORN,                        droprate =   5 },
            { itemid = xi.item.ELM_LOG,                         droprate =   5 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   5 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   5 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   5 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   5 },
            { itemid = xi.item.SACK_OF_SILICA,                  droprate =   5 },
            { itemid =  850,                                    droprate =   5 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   5 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   5 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   5 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   5 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   5 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   5 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   5 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   5 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   5 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   5 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   5 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   5 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   5 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   5 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   5 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   5 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   5 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   5 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   5 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   5 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   5 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   5 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   5 },
            { itemid = xi.item.IMP_HORN,                        droprate =   5 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   5 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   5 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   5 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   5 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   5 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   5 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   5 },
            { itemid = 1225,                                    droprate =   5 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   5 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   5 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   5 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   5 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   5 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   5 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   5 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   5 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   5 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   5 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   5 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   5 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   5 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   5 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   5 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   5 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   5 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   5 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   5 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   5 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   5 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   5 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   5 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   5 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   5 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   5 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   5 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   5 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   5 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   5 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   5 },
            { itemid = 2151,                                    droprate =   5 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   5 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   5 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   5 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   5 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   5 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   5 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   5 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   5 }, -- Water Anima
            { itemid = 1647,                                    droprate =   5 }, -- Light Anima
            { itemid = 1648,                                    droprate =   5 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   5 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   5 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   5 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   5 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   5 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   5 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   5 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   5 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   5 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   5 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   5 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   5 },
            { itemid =  734,                                    droprate =   5 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   5 }, -- Amphiptere Hide
            { itemid = 2164,                                    droprate =   5 }, -- Pephredo Hive Chip
            { itemid = 1279,                                    droprate =   5 }, -- Taffeta Cloth
            { itemid = 1280,                                    droprate =   5 }, -- Sarcenet Cloth
            { itemid = 1281,                                    droprate =   5 }, -- Cheviot Cloth
            { itemid = 1295,                                    droprate =   5 }, -- Twincoon
            { itemid = 1270,                                    droprate =   5 }, -- Arachne Web
            { itemid =  647,                                    droprate =   5 }, -- Molybdenum Ore
            { itemid = 1271,                                    droprate =   5 }, -- Pigeon's Blood Ruby
            { itemid = 1276,                                    droprate =   5 }, -- Tarasque Skin
            { itemid = 1296,                                    droprate =   5 }, -- Yowie Skin
            { itemid = 1277,                                    droprate =   5 }, -- Lindwurm Skin
            { itemid = 1765,                                    droprate =   5 }, -- Habu Skin
            { itemid = 2828,                                    droprate =   5 }, -- Herensugue Skin
            { itemid = 2837,                                    droprate =   5 }, -- Ratatoskr Pelt
            { itemid = 2839,                                    droprate =   5 }, -- Coquecigrue Skin
            { itemid = 2830,                                    droprate =   5 }, -- Bastet Fang
            { itemid = 2833,                                    droprate =   5 }, -- Thunder Coral
            { itemid = 1272,                                    droprate =   5 }, -- Arioch Fang
            { itemid = 1273,                                    droprate =   5 }, -- Namtar Bone
            { itemid = 2849,                                    droprate =   5 }, -- Likho Talon
            { itemid = 2846,                                    droprate =   5 }, -- Hefty Oak Lumber
            { itemid = 2855,                                    droprate =   5 }, -- Mahogany Heartwood
            { itemid = xi.item.CHUNK_OF_FIRE_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_ICE_ORE,                droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WIND_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_EARTH_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHTNING_ORE,          droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WATER_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHT_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_DARK_ORE,               droprate =   3 },
            { itemid = xi.item.CLUMP_OF_IMPERIAL_TEA_LEAVES,    droprate =   3 },
            { itemid = xi.item.DRAGON_FRUIT,                    droprate =   3 },
            { itemid = xi.item.WALNUT,                          droprate =   3 },
            { itemid = xi.item.BOWL_OF_AMBROSIA,                droprate =   3 },
            { itemid = xi.item.BOTTLE_OF_AMRITA,                droprate =   3 },
            { itemid = xi.item.DRAGON_HEART,                    droprate =   3 },
            { itemid = xi.item.HANDFUL_OF_DRAGON_SCALES,        droprate =   3 },
            { itemid = xi.item.SLICE_OF_DRAGON_MEAT,            droprate =   3 },
            { itemid = xi.item.CHUNK_OF_HYDRA_MEAT,             droprate =   3 },
            { itemid = xi.item.SLICE_OF_CERBERUS_MEAT,          droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HIDE,                   droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HORN,                   droprate =   3 },
            { itemid = 2158,                                    droprate =   3 }, -- Hydra Fang
            { itemid = 2172,                                    droprate =   3 }, -- Hydra Scale
            { itemid = 2168,                                    droprate =   3 }, -- Cerberus Claw
            { itemid = 2169,                                    droprate =   3 }, -- Cerberus Hide
            { itemid = 2371,                                    droprate =   3 }, -- Khimaira Horn
            { itemid = 2372,                                    droprate =   3 }, -- Khimaira Mane
            { itemid = 2373,                                    droprate =   3 }, -- Khimaira Tail
            { itemid = 4273,                                    droprate =   3 }, -- Kitron
            { itemid = 1718,                                    droprate =   3 }, -- M-bugard Tusk
            { itemid = 1719,                                    droprate =   3 }, -- Harajnite Shell
            { itemid = xi.item.SQUARE_OF_ECARLATE_CLOTH,        droprate =   3 },
            { itemid = xi.item.ARGYRO_RIVET,                    droprate =   3 },
            { itemid = xi.item.UTOPIAN_GOLD_THREAD,             droprate =   3 },
            { itemid = xi.item.ANCIENT_BRASS_INGOT,             droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BENEDICT_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_BENEDICT_YARN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_DIABOLIC_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_DIABOLIC_YARN,          droprate =   3 },
            { itemid = xi.item.SPOOL_OF_RUBY_SILK_THREAD,       droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CARDINAL_CLOTH,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SUPPLE_SKIN,           droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LIGHT_FILAMENT,         droprate =   3 },
            { itemid = xi.item.CHUNK_OF_SNOWY_CERMET,           droprate =   3 },
            { itemid = xi.item.WHITE_RIVET,                     droprate =   3 },
            { itemid = xi.item.DARK_ORICHALCUM_INGOT,           droprate =   3 },
            { itemid = xi.item.BLACK_RIVET,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SMALT_LEATHER,         droprate =   3 },
            { itemid = xi.item.FETID_LANOLIN_CUBE,              droprate =   3 },
            { itemid = xi.item.SPOOL_OF_COILED_YARN,            droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BROWN_DOESKIN,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_CHAMELEON_YARN,         droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CHARCOAL_COTTON,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SCARLET_ODOSHI,         droprate =   3 },
            { itemid = xi.item.SHEET_OF_KUROGANE,               droprate =   3 },
            { itemid = xi.item.PLAITED_CORD,                    droprate =   3 },
            { itemid = xi.item.POT_OF_EBONY_LACQUER,            droprate =   3 },
            { itemid = xi.item.SHEET_OF_COBALT_MYTHRIL,         droprate =   3 },
            { itemid = xi.item.BLUE_RIVET,                      droprate =   3 },
            { itemid = xi.item.SPOOL_OF_GLITTERING_YARN,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ASTRAL_LEATHER,        droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LUMINIAN_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_FLAMESHUN_CLOTH,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SILKWORM_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CANVAS_TOILE,          droprate =   3 },
            { itemid = xi.item.PANTIN_WIRE,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CORDUROY_CLOTH,        droprate =   3 },
            { itemid = xi.item.PIECE_OF_ANGEL_SKIN,             droprate =   3 },
            { itemid = xi.item.LOCK_OF_SIRENS_HAIR,             droprate =   3 },
            { itemid = xi.item.DIVINE_LOG,                      droprate =   3 },
            { itemid = xi.item.POT_OF_VIRIDIAN_URUSHI,          droprate =   2 },
            { itemid = xi.item.SQUARE_OF_KEJUSU_SATIN,          droprate =   2 },
            { itemid = xi.item.SQUARE_OF_ELTORO_LEATHER,        droprate =   2 },
            { itemid = xi.item.SQUARE_OF_GALATEIA,              droprate =   2 },
            { itemid = xi.item.DRAGON_BONE,                     droprate =   2 },
            { itemid = 1703,                                    droprate =   3 }, -- Kunwu Ore
        },
        -- Slot 5, Misc/Medicine --
        {
            { itemid = xi.item.VILE_ELIXIR,                     droprate = 150 },
            { itemid = 4149,                                    droprate = 150 }, -- Panacea
            { itemid = xi.item.VILE_ELIXIR_P1,                  droprate = 140 },
            { itemid = xi.item.HI_RERAISER,                     droprate = 140 },
            { itemid = xi.item.REMEDY,                          droprate = 140 },
            { itemid = xi.item.ICARUS_WING,                     droprate = 140 },
            { itemid = xi.item.SUPER_RERAISER,                  droprate = 140 },
        },
        -- Slot 9, Misc/Medicine --
        {
            { itemid = xi.item.RERAISER,                        droprate = 100 },
            { itemid = xi.item.REMEDY,                          droprate =  80 },
            { itemid = xi.item.HI_RERAISER,                     droprate =  70 },
            { itemid = xi.item.FLASK_OF_ECHO_DROPS,             droprate =  50 },
            { itemid = xi.item.FLASK_OF_HOLY_WATER,             droprate =  50 },
            { itemid = xi.item.SUPER_RERAISER,                  droprate =  60 },
            { itemid = xi.item.ICARUS_WING,                     droprate =  60 },
            { itemid = xi.item.VILE_ELIXIR,                     droprate =  60 },
            { itemid = xi.item.VILE_ELIXIR_P1,                  droprate =  50 },
            { itemid = xi.item.FIRE_CLUSTER,                    droprate =  20 },
            { itemid = xi.item.ICE_CLUSTER,                     droprate =  20 },
            { itemid = xi.item.WIND_CLUSTER,                    droprate =  20 },
            { itemid = xi.item.EARTH_CLUSTER,                   droprate =  20 },
            { itemid = xi.item.LIGHTNING_CLUSTER,               droprate =  20 },
            { itemid = xi.item.WATER_CLUSTER,                   droprate =  20 },
            { itemid = xi.item.LIGHT_CLUSTER,                   droprate =  20 },
            { itemid = xi.item.DARK_CLUSTER,                    droprate =  20 },
            { itemid = 5356,                                    droprate =  60 }, -- Remedy Ointment
            { itemid = 4153,                                    droprate =  60 }, -- Antacid
            { itemid = 4512,                                    droprate =  50 }, -- Vampire Juice
            { itemid = 4149,                                    droprate =  30 }, -- Panacea
            { itemid = 5254,                                    droprate =  25 }, -- Hyper Potion
            { itemid = 5255,                                    droprate =  25 }, -- Hyper Ether
            { itemid = xi.item.MOAT_CARP,                       droprate =  10 },
        },
    },
    [60] =
    {   -- Slot 1, Currency --
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate =  90 },
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  60 },
            { itemid = xi.item.LINEN_COIN_PURSE,                droprate =  80 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =  80 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =  80 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =  80 },
            { itemid =  6541,                                   droprate =  90 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  90 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  90 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  90 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  90 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter
        },
        -- Slot 6, Currency --
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate =  50 },
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  60 },
            { itemid = xi.item.COTTON_COIN_PURSE,               droprate =  40 },
            { itemid = xi.item.LINEN_COIN_PURSE,                droprate =  30 },
            { itemid = xi.item.ONE_BYNE_BILL,                   droprate =  50 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =  10 },
            { itemid = xi.item.ORDELLE_BRONZEPIECE,             droprate =  50 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =  10 },
            { itemid = xi.item.TUKUKU_WHITESHELL,               droprate =  50 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =  10 },
            { itemid = xi.item.BEASTMENS_SEAL,                  droprate =   5 },
            { itemid = xi.item.KINDREDS_SEAL,                   droprate =   5 },
            { itemid =  6541,                                   droprate =  60 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  60 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  60 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  60 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  60 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter
            { itemid =     0,                                   droprate = 250 }, -- Nothing
        },
        -- Slot 10, Tatters --
        {
            { itemid =  3283,                                   droprate = 125 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate = 125 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate = 125 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate = 125 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate = 125 }, -- Martial Tatter
            { itemid =  3279,                                   droprate = 125 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate = 125 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate = 125 }, -- Wyrmal Tatter
        },
        -- Slot 2, Pop Items --
        {
            { itemid = xi.item.GEM_OF_THE_EAST,                 droprate =  16 },
            { itemid = xi.item.SPRINGSTONE,                     droprate =  16 },
            { itemid = xi.item.GEM_OF_THE_SOUTH,                droprate =  16 },
            { itemid = xi.item.SUMMERSTONE,                     droprate =  16 },
            { itemid = xi.item.GEM_OF_THE_WEST,                 droprate =  16 },
            { itemid = xi.item.AUTUMNSTONE,                     droprate =  16 },
            { itemid = xi.item.GEM_OF_THE_NORTH,                droprate =  16 },
            { itemid = xi.item.WINTERSTONE,                     droprate =  16 },
            { itemid = xi.item.IVORY_CHIP,                      droprate =  20 },
            { itemid = xi.item.SCARLET_CHIP,                    droprate =  20 },
            { itemid = xi.item.EMERALD_CHIP,                    droprate =  20 },
            { itemid = xi.item.SILVER_CHIP,                     droprate =  20 },
            { itemid = xi.item.CERULEAN_CHIP,                   droprate =  20 },
            { itemid = 1986,                                    droprate =  20 }, -- Orchid Chip
            { itemid = xi.item.SMALT_CHIP,                      droprate =  20 },
            { itemid = xi.item.SMOKY_CHIP,                      droprate =  20 },
            { itemid = 1987,                                    droprate =  20 }, -- Charcoal Chip
            { itemid = 1988,                                    droprate =  20 }, -- Magenta Chip
            { itemid = xi.item.HAKUTAKU_EYE_CLUSTER,            droprate =  12 },
            { itemid = xi.item.FIRST_VIRTUE,                    droprate =  20 },
            { itemid =  1853,                                   droprate =  20 }, -- Second Virtue
            { itemid = xi.item.THIRD_VIRTUE,                    droprate =  20 },
            { itemid =  1848,                                   droprate =  20 }, -- Fourth Virtue
            { itemid =  1847,                                   droprate =  20 }, -- Fifth Virtue
            { itemid =  1849,                                   droprate =  20 }, -- Sxith Virtue
            { itemid = xi.item.HELLCAGE_BUTTERFLY,              droprate =  20 },
            { itemid = xi.item.JUG_OF_FLORAL_NECTAR,            droprate =  20 },
            { itemid = xi.item.WEDGE_OF_RODENT_CHEESE,          droprate =  20 },
            { itemid = xi.item.CLUMP_OF_SHADELEAVES,            droprate =  20 },
            { itemid = xi.item.BEAKER_OF_PECTIN,                droprate =  20 },
            { itemid = xi.item.FLASK_OF_COG_LUBRICANT,          droprate =  20 },
            { itemid = xi.item.GOLDEN_TEETH,                    droprate =  20 },
            { itemid = xi.item.GREENLING,                       droprate =  20 },
            { itemid = xi.item.BOTTLE_OF_SPOILT_BLOOD,          droprate =  20 },
            { itemid = xi.item.BUNCH_OF_SENORITA_PAMAMAS,       droprate =  20 },
            { itemid = xi.item.JAR_OF_OILY_BLOOD,               droprate =  20 },
            { itemid = xi.item.STRAND_OF_SAMARIRI_CORPSEHAIR,   droprate =  20 },
            { itemid = xi.item.SLAB_OF_RAW_BUFFALO,             droprate =  20 },
            { itemid = xi.item.LUMP_OF_BONE_CHARCOAL,           droprate =  20 },
            { itemid = xi.item.PINCH_OF_GRANULATED_SUGAR,       droprate =  20 },
            { itemid = xi.item.MINT_DROP,                       droprate =  20 },
            { itemid = xi.item.OPALUS_GEM,                      droprate =  20 },
            { itemid = xi.MERROW_NO_11_MOLTING,                 droprate =  20 },
            { itemid = xi.BAR_OF_FERRITE,                       droprate =  20 },
            { itemid = xi.BAGGED_SHEEP_BOTFLY,                  droprate =  20 },
            { itemid = xi.OLZHIRYAN_CACTUS_PADDLE,              droprate =  20 },
            { itemid = xi.VIAL_OF_PURE_BLOOD,                   droprate =  20 },
            { itemid = xi.VINEGAR_PIE,                          droprate =  20 },
            { itemid = xi.JAR_OF_ROCK_JUICE,                    droprate =  20 },
            { itemid = xi.BOUND_EXORCISM_TREATISE,              droprate =  20 },
            { itemid = xi.CLUMP_OF_MYRRH,                       droprate =  20 },
            { itemid = xi.WHOLE_ROSE_SCAMPI,                    droprate =  20 },
        },
        -- Slot 3, Equipment --
        {
            { itemid = xi.item.DUENDE_COTEHARDIE,               droprate =   4 },
            { itemid = xi.item.NOKIZARU_GI,                     droprate =   4 },
            { itemid = xi.item.RAPPAREE_HARNESS,                droprate =   4 },
            { itemid = xi.item.SHINIMUSHA_HARA_ATE,             droprate =   4 },
            { itemid = xi.item.WYVERN_MAIL,                     droprate =   4 },
            { itemid = xi.item.SHIKAREE_AKETON,                 droprate =   4 },
            { itemid = xi.item.CERISE_DOUBLET,                  droprate =   4 },
            { itemid = xi.item.GLAMOR_JUPON,                    droprate =   4 },
            { itemid = xi.item.GLOOM_BREASTPLATE,               droprate =   4 },
            { itemid = xi.item.NIMBUS_DOUBLET,                  droprate =   4 },
            { itemid = xi.item.AIKIDO_GI,                       droprate =   4 },
            { itemid = xi.item.PARADE_CUIRASS,                  droprate =   4 },
            { itemid = xi.item.GAUDY_HARNESS,                   droprate =   4 },
            { itemid = xi.item.HAMAYUMI,                        droprate =   5 },
            { itemid = xi.item.DIA_WAND,                        droprate =   4 },
            { itemid = xi.item.STONE_GORGET,                    droprate =   5 },
            { itemid =  18359,                                  droprate =   5 }, -- Boreas Cesti
            { itemid =  15468,                                  droprate =   5 }, -- Resentment Cape
            { itemid =  xi.item.GOTHIC_SABATONS,                droprate =   5 },
            { itemid =  xi.item.GOTHIC_GAUNTLETS,               droprate =   5 },
            { itemid =  16187,                                  droprate =   5 }, -- Adoubeurs Pavise
            { itemid =  16899,                                  droprate =   5 }, -- Hototogisu
            { itemid =  16374,                                  droprate =   5 }, -- Layqa Seraweels
            { itemid =  17199,                                  droprate =   5 }, -- Loxley Bow
            { itemid =  16882,                                  droprate =   5 }, -- Calamar
            { itemid =  17504,                                  droprate =   5 }, -- Pagures
            { itemid =  16884,                                  droprate =   5 }, -- Narval
            { itemid =  17503,                                  droprate =   5 }, -- Exocets
            { itemid =  19238,                                  droprate =   5 }, -- Jasper Tathlum
            { itemid =  11404,                                  droprate =   5 }, -- Promptitude Solea
            { itemid =  15897,                                  droprate =   5 }, -- Grace Corset
            { itemid =  13803,                                  droprate =   5 }, -- Shaman's Cloak
            { itemid =  19237,                                  droprate =   5 }, -- Slick Dart
            { itemid =  15942,                                  droprate =   5 }, -- Summoning Belt
            { itemid =  xi.item.MUSHROOM_HELM,                  droprate =   2 },
            { itemid =  xi.item.LUNA_SUBLIGAR,                  droprate =   2 },
            { itemid =  16980,                                  droprate =   5 }, -- Sukesada
            { itemid =  13912,                                  droprate =   5 }, -- Shadow Mask
            { itemid =  16943,                                  droprate =   5 }, -- Ascalon
            { itemid =  14063,                                  droprate =   5 }, -- Protecting Bangles
            { itemid =  14064,                                  droprate =   5 }, -- Sand Gloves
            { itemid =  17651,                                  droprate =   5 }, -- Dainslaif
            { itemid =  17924,                                  droprate =   5 }, -- Tungi
            { itemid =  16734,                                  droprate =   5 }, -- Pendragon Axe
            { itemid =  15995,                                  droprate =   5 }, -- Carline Earring
            { itemid =  16127,                                  droprate =   5 }, -- Carline Ribbon
            { itemid =  16125,                                  droprate =   5 }, -- Breeder Mask
            { itemid =  15001,                                  droprate =   5 }, -- Breeder Mufflers
            { itemid =  15946,                                  droprate =   5 }, -- Tempest Belt
            { itemid =  11405,                                  droprate =   5 }, -- Kyoshu Kyahan
            { itemid =  11533,                                  droprate =   5 }, -- Lyricist's Gonnelle
            { itemid =  16298,                                  droprate =   5 }, -- Knack Pendant
            { itemid =  17454,                                  droprate =   5 }, -- Asklepios
            { itemid =  17455,                                  droprate =   5 }, -- Skirnir's Wand
            { itemid =  16912,                                  droprate =   5 }, -- Kitsutsuki
            { itemid =  17926,                                  droprate =   5 }, -- Acha D'Armas
            { itemid =  17982,                                  droprate =   5 }, -- Kard
            { itemid =  17983,                                  droprate =   5 }, -- Valiant Knife
            { itemid =  18042,                                  droprate =   5 }, -- Ascention
            { itemid =  17563,                                  droprate =   5 }, -- Power Staff
            { itemid =  17969,                                  droprate =   5 }, -- Fendoir
            { itemid =  18608,                                  droprate =   5 }, -- Atesh Pole
            { itemid =  16727,                                  droprate =   5 }, -- Eisentaenzer
            { itemid =  17971,                                  droprate =   5 }, -- Tartaglia
            { itemid =  19235,                                  droprate =   5 }, -- Veuglaire
            { itemid =  16375,                                  droprate =   5 }, -- Surge Subligar
            { itemid =  xi.item.ASTRAL_ASPIS,                   droprate =   5 },
            { itemid =  xi.item.GAE_BOLG,                       droprate =   5 },
            { itemid =  xi.item.LOHAR,                          droprate =   5 },
            { itemid =   19122,                                 droprate =   5 }, -- Courser's Pugio
            { itemid =   16081,                                 droprate =   5 }, -- Curate's Hat
            { itemid =   15882,                                 droprate =   5 }, -- Othinus' Bow
            { itemid =   17244,                                 droprate =   5 }, -- Storm Belt
            { itemid =   14806,                                 droprate =   5 }, -- Intruder Earring
            { itemid =   14466,                                 droprate =   5 }, -- Fomor Tunic
            { itemid =   18007,                                 droprate =   5 }, -- Chiroptera Dagger
            { itemid =   17510,                                 droprate =   5 }, -- Vampiric Claws
            { itemid =   14763,                                 droprate =   5 }, -- Boroka Earring
            { itemid =   13178,                                 droprate =   5 }, -- Auditory Torque
            { itemid =   15943,                                 droprate =   5 }, -- Virtuoso Belt
            { itemid =   14884,                                 droprate =   5 }, -- Mycophile Cuffs
            { itemid =   17794,                                 droprate =   5 }, -- Niokiyotsuna
            { itemid =   15219,                                 droprate =   5 }, -- Sinister Mask
            { itemid =   16368,                                 droprate =   5 }, -- Herder's Subligar
            { itemid =   14724,                                 droprate =   5 }, -- Moldavite Earring
            { itemid =   16279,                                 droprate =   5 }, -- Pile Chain
            { itemid =   15546,                                 droprate =   5 }, -- Fasting Ring
            { itemid =   16299,                                 droprate =   5 }, -- Lleu's Charm
            { itemid =   11496,                                 droprate =   5 }, -- Fenrir's Crown
            { itemid =   14168,                                 droprate =   5 }, -- Dune Boots
            { itemid =   17854,                                 droprate =   5 }, -- Cradle Horn
            { itemid =   19239,                                 droprate =   5 }, -- Astrolable
            { itemid =   16169,                                 droprate =   5 }, -- Caballero Shield
            { itemid =   17653,                                 droprate =   5 }, -- Hrotti
            { itemid =   18027,                                 droprate =   5 }, -- Palladium Dagger
            { itemid =   17564,                                 droprate =   5 }, -- Cocytus Pole
            { itemid =   16426,                                 droprate =   5 }, -- Avengers
            { itemid =   19121,                                 droprate =   5 }, -- Sleight Kukri
            { itemid =   15944,                                 droprate =   7 }, -- Selemnus Belt
            { itemid =   16297,                                 droprate =   7 }, -- Shepherd's Chain
            { itemid =  xi.item.KAMEWARI,                       droprate =   5 },
            { itemid =  xi.item.NADRS,                          droprate =   5 },
            { itemid =  xi.item.ALTDORFS_EARRING,               droprate =   5 },
            { itemid =  xi.item.WILHELMS_EARRING,               droprate =   5 },
            { itemid =  xi.item.HELENUSS_EARRING,               droprate =   5 },
            { itemid =  xi.item.CASSANDRAS_EARRING,             droprate =   5 },
            { itemid =  xi.item.MINSTRELS_DAGGER,               droprate =   5 },
            { itemid =  xi.item.SAND_CHARM,                     droprate =   5 },
            { itemid =   15692,                                 droprate =   5 }, -- Storm Crackows
            { itemid =   14669,                                 droprate =   5 }, -- Jaeger Ring
            { itemid =   15351,                                 droprate =   5 }, -- Bounding Boots
            { itemid =   18018,                                 droprate =   5 }, -- Sirocco Kukri
            { itemid =   13567,                                 droprate =   5 }, -- Bomb Queen Ring
            { itemid =   15547,                                 droprate =   5 }, -- Vilma's Ring
            { itemid =   26164,                                 droprate =   5 }, -- Caliber Ring
            { itemid =   15183,                                 droprate =   7 }, -- Dobson Bandana
            { itemid =   15184,                                 droprate =   7 }, -- Voyager Sallet
            { itemid =   14986,                                 droprate =   7 }, -- Ochimusha Kote
            { itemid =   15737,                                 droprate =   7 }, -- Sarutobi Kyahan
            { itemid =   15551,                                 droprate =   7 }, -- Shikaree Ring
            { itemid =  xi.item.EMPRESS_HAIRPIN,                droprate =   7 },
            { itemid =  xi.item.JOYEUSE,                        droprate =   7 },
            { itemid =  xi.item.DRYAD_STAFF,                    droprate =   7 },
            { itemid =  xi.item.VALIS_BOW,                      droprate =   7 },
            { itemid =  xi.item.RETALIATORS,                    droprate =   7 },
            { itemid =  xi.item.UNGUR_BOOMERANG,                droprate =   7 },
            { itemid =   15515,                                 droprate =   7 }, -- Peacock Amulet
            { itemid =  xi.item.TROTTER_BOOTS,                  droprate =   7 },
            { itemid =   19236,                                 droprate =   7 }, -- Hightail Bullet
            { itemid =   17192,                                 droprate =   7 }, -- Ifrit's Bow
            { itemid =   17711,                                 droprate =   7 }, -- Shiva's Shotel
            { itemid =   18021,                                 droprate =   7 }, -- Titan's Baselarde
            { itemid =   18063,                                 droprate =   7 }, -- Garuda's Sickle
            { itemid =   18109,                                 droprate =   7 }, -- Leviathan's Couse
            { itemid =   18404,                                 droprate =   7 }, -- Ramuh's Mace
            { itemid =   18581,                                 droprate =   7 }, -- Carbuncle's Pole
            { itemid =   14931,                                 droprate =   7 }, -- Carbuncle's Cuffs
            { itemid =   18422,                                 droprate =   7 }, -- Ryumon
            { itemid =   14960,                                 droprate =   7 }, -- Evoker's Gages
            { itemid =   19277,                                 droprate =   7 }, -- Tsugumi
            { itemid =   11408,                                 droprate =   7 }, -- Morana Pigaches
            { itemid =   11409,                                 droprate =   7 }, -- Aoide's Pumps
            { itemid =   16238,                                 droprate =   7 }, -- Taster's Cape
            { itemid =   11497,                                 droprate =   7 }, -- Spurrer Beret
            { itemid =   11406,                                 droprate =   7 }, -- Stimulus Sabots
            { itemid =   18767,                                 droprate =   6 }, -- Birdbanes
            { itemid =   15854,                                 droprate =   7 }, -- Sortie Ring
            { itemid =   15915,                                 droprate =   7 }, -- Sothic Rope
            { itemid =   11342,                                 droprate =   6 }, -- Restorer Cloak
            { itemid =   18770,                                 droprate =   7 }, -- Pygme Sainti
            { itemid =   17737,                                 droprate =   6 }, -- Corsair's Scimitar
            { itemid =   19124,                                 droprate =   7 }, -- Creve-coeur
            { itemid =   19279,                                 droprate =   7 }, -- Musanto
            { itemid =   17766,                                 droprate =   7 }, -- Lyft Scimitar
            { itemid =   17970,                                 droprate =   7 }, -- Lyft Tabar
            { itemid =   18508,                                 droprate =   7 }, -- Lyft Voulge
            { itemid =   18609,                                 droprate =   7 }, -- Lyft Pole
            { itemid =   18771,                                 droprate =   7 }, -- Lyft Sainti
            { itemid =   18872,                                 droprate =   7 }, -- Lyft Ferule
            { itemid =   18958,                                 droprate =   7 }, -- Lyft Scythe
            { itemid =   19125,                                 droprate =   7 }, -- Lyft Jambiya
            { itemid =   19161,                                 droprate =   7 }, -- Lyft Claymore
            { itemid =   19233,                                 droprate =   7 }, -- Lyft Crossbow
            { itemid =   19306,                                 droprate =   7 }, -- Lyft Lance
            { itemid =  xi.item.LAVAS_RING,                     droprate =   7 },
            { itemid =  xi.item.KUSHAS_RING,                    droprate =   7 },
            { itemid =  xi.item.NASATYAS_RING,                  droprate =   7 },
            { itemid =  xi.item.DASRAS_RING,                    droprate =   7 },
            { itemid =  xi.item.HOPE_STAFF,                     droprate =   7 },
            { itemid =  xi.item.JUSTICE_SWORD,                  droprate =   7 },
            { itemid =  xi.item.TEMPERANCE_AXE,                 droprate =   7 },
            { itemid =  xi.item.LOVE_HALBERD,                   droprate =   7 },
            { itemid =  xi.item.FORTITUDE_AXE,                  droprate =   7 },
            { itemid =  xi.item.FAITH_BAGHNAKHS,                droprate =   7 },
            { itemid =  xi.item.PRUDENCE_ROD,                   droprate =   7 },
            { itemid =  xi.item.BYAKKOS_AXE,                    droprate =   8 },
            { itemid =  xi.item.SUZAKUS_SCYTHE,                 droprate =   8 },
            { itemid =  xi.item.SEIRYUS_SWORD,                  droprate =   8 },
        },
        -- Slot 7, Equipment --
        {
            { itemid =  5681,                                   droprate =   4 }, -- Cupid Chocolate
            { itemid = xi.item.AERN_DAGGER,                     droprate =   5 },
            { itemid = xi.item.AERN_SWORD,                      droprate =   5 },
            { itemid = xi.item.AERN_AXE,                        droprate =   5 },
            { itemid = xi.item.AERN_SPEAR,                      droprate =   5 },
            { itemid = xi.item.AERN_STAFF,                      droprate =   5 },
            { itemid = xi.item.CHICKEN_KNIFE_II,                droprate =   5 },
            { itemid = xi.item.GENBUS_KABUTO,                   droprate =   6 },
            { itemid = xi.item.GENBUS_SHIELD,                   droprate =   6 },
            { itemid = xi.item.SEIRYUS_KOTE,                    droprate =   6 },
            { itemid = xi.item.SUZAKUS_SUNE_ATE,                droprate =   6 },
            { itemid = xi.item.BYAKKOS_HAIDATE,                 droprate =   6 },
            { itemid = xi.item.ANIMATOR_P1,                     droprate =   5 },
            { itemid = 17567,                                   droprate =   5 }, -- Kirin's Pole
            { itemid = 12562,                                   droprate =   5 }, -- Kirin's Osode
            { itemid = 16034,                                   droprate =   5 }, -- Sarabande Earring
            { itemid = 13415,                                   droprate =   5 }, -- Pixie Earring
            { itemid = 16300,                                   droprate =   5 }, -- Wit Pendant
            { itemid = 16303,                                   droprate =   5 }, -- Laran's Pendant
            { itemid = 15057,                                   droprate =   5 }, -- Bricta's Cuffs
            { itemid = 14943,                                   droprate =   5 }, -- Barbarossa's Moufles
            { itemid = 16376,                                   droprate =   5 }, -- Bahram Cuisses
            { itemid = 16302,                                   droprate =   5 }, -- Bloodbead Gorget
            { itemid = 11411,                                   droprate =   5 }, -- Shrewd Pumps
            { itemid = 15223,                                   droprate =   5 }, -- Ace's Helm
            { itemid = 18002,                                   droprate =   5 }, -- Perseu's Harp
            { itemid = 14873,                                   droprate =   5 }, -- Bandomusha Kote
            { itemid = 19280,                                   droprate =   5 }, -- Narigitsune
            { itemid = xi.item.WYRM_BEARD,                      droprate =   5 },
            { itemid = xi.item.BEHEMOTH_TONGUE,                 droprate =   5 },
            { itemid = xi.item.ADAMANTOISE_EGG,                 droprate =   5 },
            { itemid = xi.item.SEVENEYES,                       droprate =   5 },
            { itemid = xi.item.ALGOL,                           droprate =   5 },
            { itemid = 13658,                                   droprate =   5 }, -- Shadow Mantle
            { itemid = 14646,                                   droprate =   5 }, -- Shadow Ring
            { itemid = 11589,                                   droprate =   5 }, -- Aesir Torque
            { itemid = 16057,                                   droprate =   5 }, -- Aesir Ear Pendant
            { itemid = 11546,                                   droprate =   5 }, -- Aesir Mantle
            { itemid = 11547,                                   droprate =   5 }, -- Colossus's Mantle
            { itemid = 11590,                                   droprate =   5 }, -- Colossus's Torque
            { itemid = 16058,                                   droprate =   5 }, -- Colossus's Earring
            { itemid = 18019,                                   droprate =   5 }, -- X's Knife
            { itemid = 18057,                                   droprate =   5 }, -- Y's Scythe
            { itemid = 18101,                                   droprate =   5 }, -- Z's Trident
            { itemid = 15899,                                   droprate =   5 }, -- Velocious Belt
            { itemid = 15617,                                   droprate =   5 }, -- Barbarossa's Zerehs
            { itemid = 17586,                                   droprate =   5 }, -- Mercurial Pole
            { itemid = xi.item.JUSTICE_TORQUE,                  droprate =   5 },
            { itemid = xi.item.HOPE_TORQUE,                     droprate =   5 },
            { itemid = xi.item.PRUDENCE_TORQUE,                 droprate =   5 },
            { itemid = xi.item.FORTITUDE_TORQUE,                droprate =   5 },
            { itemid = xi.item.FAITH_TORQUE,                    droprate =   5 },
            { itemid = xi.item.TEMPERANCE_TORQUE,               droprate =   5 },
            { itemid = xi.item.LOVE_TORQUE,                     droprate =   2 },
            { itemid = xi.item.RIDILL,                          droprate =   2 },
            { itemid = xi.item.OCTAVE_CLUB,                     droprate =   2 },
            { itemid = xi.item.HAUTECLAIRE,                     droprate =   2 },
            { itemid = 13566,                                   droprate =   2 }, -- Defending Ring
            { itemid = 27456,                                   droprate =   2 }, -- Crier's Gaiters
            { itemid = 14468,                                   droprate =   3 }, -- Yinyang Robe
            { itemid = 17754,                                   droprate =   5 }, -- Sylphid Epee
            { itemid = 16154,                                   droprate =   5 }, -- Karura Hachigane
            { itemid = 16000,                                   droprate =   5 }, -- Dragoon's Earring
            { itemid = 16240,                                   droprate =   5 }, -- Erato's Cape
            { itemid = 17755,                                   droprate =   5 }, -- Beast Slayer
            { itemid = 16340,                                   droprate =   5 }, -- Armadillo Cuisses
            { itemid = 17961,                                   droprate =   5 }, -- Lion Tamer
            { itemid = 15018,                                   droprate =   5 }, -- Ritterhentzes
            { itemid = 18859,                                   droprate =   5 }, -- Kerykeion
            { itemid = 16274,                                   droprate =   5 }, -- Almah Torque
            { itemid = 15999,                                   droprate =   5 }, -- Guignol Earring
            { itemid = 15916,                                   droprate =   5 }, -- Corsair's Belt
            { itemid = 18950,                                   droprate =   5 }, -- White Joker
            { itemid = 11369,                                   droprate =   5 }, -- Numerist Pumps
            { itemid = 11368,                                   droprate =   5 }, -- Hakke Habaki
            { itemid = 15827,                                   droprate =   5 }, -- Insect Ring
            { itemid = 15828,                                   droprate =   5 }, -- Blood Ring
            { itemid = 19154,                                   droprate =   5 }, -- Ferrara
            { itemid = 11366,                                   droprate =   5 }, -- Avocat Pigaches
            { itemid = 15017,                                   droprate =   5 }, -- Toad Mittens
            { itemid = 16339,                                   droprate =   5 }, -- Paddock Trousers
            { itemid = 16153,                                   droprate =   5 }, -- Reikyo Hairpin
            { itemid = 11367,                                   droprate =   5 }, -- Nobushi Kyahan
            { itemid = 19109,                                   droprate =   5 }, -- Trilling Dagger
            { itemid = 18448,                                   droprate =   5 }, -- Hacchonenbutsu
            { itemid = 19211,                                   droprate =   5 }, -- Reacton Arm
            { itemid = 19028,                                   droprate =   5 }, -- Magic Strap
            { itemid = 18127,                                   droprate =   5 }, -- Achilles' Spear
            { itemid = 16338,                                   droprate =   5 }, -- Ruby Seraweels
            { itemid = 18949,                                   droprate =   5 }, -- Zareehkl Scythe
            { itemid = 19108,                                   droprate =   5 }, -- Zareehkl Jambiya
            { itemid = 16239,                                   droprate =   5 }, -- Solitaire Cape
            { itemid = 16175,                                   droprate =   5 }, -- Muse Tariqah
            { itemid = 16152,                                   droprate =   5 }, -- Hissho Hachimaki
            { itemid = 16174,                                   droprate =   5 }, -- Riot Shield
            { itemid = 18126,                                   droprate =   4 }, -- Tomoe
            { itemid = xi.item.ORACLES_GLOVES,                  droprate =   4 },
            { itemid = xi.item.AURUM_SABATONS,                  droprate =   4 },
            { itemid = 19031,                                   droprate =   4 }, -- Fire Grip
            { itemid = 19032,                                   droprate =   4 }, -- Water Grip
            { itemid = 19033,                                   droprate =   4 }, -- Wind Grip
            { itemid = 19034,                                   droprate =   4 }, -- Ice Grip
            { itemid = 19035,                                   droprate =   4 }, -- Thunder Grip
            { itemid = 19036,                                   droprate =   4 }, -- Earth Grip
            { itemid = 19037,                                   droprate =   4 }, -- Light Grip
            { itemid = 19038,                                   droprate =   4 }, -- Dark Grip
            { itemid = xi.item.ENKIDUS_MITTENS,                 droprate =   4 },
            { itemid = xi.item.AURUM_CUISSES,                   droprate =   4 },
            { itemid = 19153,                                   droprate =   4 }, -- Naglering
            { itemid = 18125,                                   droprate =   4 }, -- Cletine
            { itemid = xi.item.ENKIDUS_SUBLIGAR,                droprate =   4 },
            { itemid = xi.item.ORACLES_PIGACHES,                droprate =   4 },
            { itemid = 17960,                                   droprate =   4 }, -- Labrys
            { itemid = xi.item.ENKIDUS_LEGGINGS,                droprate =   4 },
            { itemid = xi.item.AURUM_GAUNTLETS,                 droprate =   4 },
            { itemid = 16176,                                   droprate =   4 }, -- Simba Buckler
            { itemid = 17753,                                   droprate =   4 }, -- Organics
            { itemid = xi.item.ORACLES_BRACONI,                 droprate =   4 },
            { itemid = 16177,                                   droprate =   4 }, -- Legion Scutum
            { itemid = 18595,                                   droprate =   4 }, -- Mekki Shakki
            { itemid = 18430,                                   droprate =   4 }, -- Oninohocho
            { itemid = 18593,                                   droprate =   2 }, -- Alkalurops
            { itemid = xi.item.ENKIDUS_CAP,                     droprate =   2 },
            { itemid = xi.item.ENKIDUS_HARNESS,                 droprate =   2 },
            { itemid = xi.item.HACHIRYU_SUNE_ATE,               droprate =   2 },
            { itemid = xi.item.ORACLES_CAP,                     droprate =   2 },
            { itemid = 18429,                                   droprate =   2 }, -- Shusui
            { itemid = xi.item.AURUM_ARMET,                     droprate =   2 },
            { itemid = 18497,                                   droprate =   2 }, -- Foolkiller
            { itemid = xi.item.HACHIRYU_HAIDATE,                droprate =   2 },
            { itemid = xi.item.ORACLES_ROBE,                    droprate =   2 },
            { itemid = 18446,                                   droprate =   2 }, -- Pachipachio
            { itemid = 18857,                                   droprate =   2 }, -- Antares
            { itemid = xi.item.AURUM_CUIRASS,                   droprate =   2 },
            { itemid = xi.item.HACHIRYU_KOTE,                   droprate =   2 },
            { itemid = xi.item.HACHIRYU_HARAMAKI,               droprate =   1 },
            { itemid = 10754,                                   droprate =   3 }, -- Moepapa Ring
            { itemid = 10755,                                   droprate =   3 }, -- Moepapa Annulet
            { itemid = 10756,                                   droprate =   3 }, -- Tjukurrpa Ring
            { itemid = 10757,                                   droprate =   3 }, -- Tjukurrpa Annulet
            { itemid = 10759,                                   droprate =   3 }, -- Aife's Annulet
            { itemid = 10817,                                   droprate =   3 }, -- Moepapa Stone
            { itemid = 10818,                                   droprate =   3 }, -- Tjukurrpa Belt
            { itemid = 10932,                                   droprate =   3 }, -- Oneiros torque
            { itemid = 10933,                                   droprate =   3 }, -- Mujin necklace
            { itemid = 10940,                                   droprate =   3 }, -- Moepapa Pendant
            { itemid = 10941,                                   droprate =   3 }, -- Tjukurrpa Medal
            { itemid = 10942,                                   droprate =   3 }, -- Aife's Medal
            { itemid = 10943,                                   droprate =   3 }, -- Moepapa Medal
            { itemid = 10972,                                   droprate =   3 }, -- Oneiros cappa
            { itemid = 10973,                                   droprate =   3 }, -- Oneiros cape
            { itemid = 10974,                                   droprate =   3 }, -- Mujin mantle
            { itemid = 10983,                                   droprate =   3 }, -- Aife's Mantle
            { itemid = 10984,                                   droprate =   3 }, -- Tjukurrpa Mantle
            { itemid = 11030,                                   droprate =   3 }, -- Oneiros earring
            { itemid = 11032,                                   droprate =   3 }, -- Mujin Stud
            { itemid = 11031,                                   droprate =   3 }, -- Oneiros pearl
            { itemid = 11456,                                   droprate =   3 }, -- Ryuga Sune-Ate
            { itemid = 11461,                                   droprate =   3 }, -- Aife's Pumps
            { itemid = 11670,                                   droprate =   3 }, -- Oneiros annulet
            { itemid = 11671,                                   droprate =   3 }, -- Oneiros ring
            { itemid = 11672,                                   droprate =   3 }, -- Mujin band
            { itemid = 11772,                                   droprate =   3 }, -- Oneiros sash
            { itemid = 11773,                                   droprate =   3 }, -- Oneiros belt
            { itemid = 11774,                                   droprate =   3 }, -- Oneiros cest
            { itemid = 11775,                                   droprate =   3 }, -- Oneiros rope
            { itemid = 11776,                                   droprate =   3 }, -- Mujin obi
            { itemid = 11820,                                   droprate =   3 }, -- Khthonios Mask
            { itemid = 11821,                                   droprate =   3 }, -- Khthonios Helm
            { itemid = 11816,                                   droprate =   3 }, -- Oneiros helm
            { itemid = 11817,                                   droprate =   3 }, -- Oneiros barbut
            { itemid = 11818,                                   droprate =   3 }, -- Oneiros headgear
            { itemid = 11819,                                   droprate =   3 }, -- Oneiros coif 
            { itemid = 11923,                                   droprate =   3 }, -- Tjukurrpa Gauntlets
            { itemid = 11918,                                   droprate =   3 }, -- Khthonios Gloves
            { itemid = 11919,                                   droprate =   3 }, -- Avesta Bangles
            { itemid = 17069,                                   droprate =   3 }, -- Moepapa Mace
            { itemid = 17358,                                   droprate =   3 }, -- Oneiros Harp
            { itemid = 18519,                                   droprate =   3 }, -- Oneiros axe
            { itemid = 18541,                                   droprate =   3 }, -- Tjukurrpa Axe 
            { itemid = 18623,                                   droprate =   3 }, -- Chtonic Staff
            { itemid = 18811,                                   droprate =   3 }, -- Oneiros grip
            { itemid = 19141,                                   droprate =   3 }, -- Oneiros knife
            { itemid = 19295,                                   droprate =   3 }, -- Mujin tanto
            { itemid = 19738,                                   droprate =   3 }, -- Aife's Bow
            { itemid = 19762,                                   droprate =   3 }, -- Oneiros Tathlum  
            { itemid = 19763,                                   droprate =   3 }, -- Oneiros Cluster  
            { itemid = 19767,                                   droprate =   3 }, -- Oneiros pebble
            { itemid = 19790,                                   droprate =   3 }, -- Oneiros lance
            { itemid =    0,                                    droprate = 250 }, -- nothing
        },
        -- Slot 4, Materials --
        {
            { itemid = xi.item.IRON_INGOT,                      droprate =   5 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   5 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   5 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   5 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   5 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   5 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   5 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   5 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   5 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   5 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   5 },
            { itemid = xi.item.RAM_HORN,                        droprate =   5 },
            { itemid = xi.item.ELM_LOG,                         droprate =   5 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   5 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   5 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   5 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   5 },
            { itemid =  850,                                    droprate =   5 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   5 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   5 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   5 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   5 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   5 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   5 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   5 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   5 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   5 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   5 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   5 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   5 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   5 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   5 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   5 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   5 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   5 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   5 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   5 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   5 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   5 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   5 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   5 },
            { itemid = xi.item.IMP_HORN,                        droprate =   5 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   5 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   5 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   5 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   5 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   5 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   5 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   5 },
            { itemid = 1225,                                    droprate =   5 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   5 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   5 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   5 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   5 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   5 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   5 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   5 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   5 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   5 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   5 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   5 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   5 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   5 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   5 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   5 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   5 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   5 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   5 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   5 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   5 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   5 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   5 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   5 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   5 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   5 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   5 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   5 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   5 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   5 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   5 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   5 },
            { itemid = 2151,                                    droprate =   5 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   5 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   5 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   5 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   5 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   5 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   5 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   5 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   5 }, -- Water Anima
            { itemid = 1647,                                    droprate =   5 }, -- Light Anima
            { itemid = 1648,                                    droprate =   5 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   5 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   5 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   5 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   5 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   5 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   5 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   5 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   5 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   5 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   5 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   5 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   5 },
            { itemid =  734,                                    droprate =   5 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   5 }, -- Amphiptere Hide
            { itemid = 2164,                                    droprate =   5 }, -- Pephredo Hive Chip
            { itemid = 1279,                                    droprate =   5 }, -- Taffeta Cloth
            { itemid = 1280,                                    droprate =   5 }, -- Sarcenet Cloth
            { itemid = 1281,                                    droprate =   5 }, -- Cheviot Cloth
            { itemid = 1295,                                    droprate =   5 }, -- Twincoon
            { itemid = 1270,                                    droprate =   5 }, -- Arachne Web
            { itemid =  647,                                    droprate =   5 }, -- Molybdenum Ore
            { itemid = 1271,                                    droprate =   5 }, -- Pigeon's Blood Ruby
            { itemid = 1276,                                    droprate =   5 }, -- Tarasque Skin
            { itemid = 1296,                                    droprate =   5 }, -- Yowie Skin
            { itemid = 1277,                                    droprate =   5 }, -- Lindwurm Skin
            { itemid = 1765,                                    droprate =   5 }, -- Habu Skin
            { itemid = 2828,                                    droprate =   5 }, -- Herensugue Skin
            { itemid = 2837,                                    droprate =   5 }, -- Ratatoskr Pelt
            { itemid = 2839,                                    droprate =   5 }, -- Coquecigrue Skin
            { itemid = 2830,                                    droprate =   5 }, -- Bastet Fang
            { itemid = 2833,                                    droprate =   5 }, -- Thunder Coral
            { itemid = 1272,                                    droprate =   5 }, -- Arioch Fang
            { itemid = 1273,                                    droprate =   5 }, -- Namtar Bone
            { itemid = 2849,                                    droprate =   5 }, -- Likho Talon
            { itemid = 2846,                                    droprate =   5 }, -- Hefty Oak Lumber
            { itemid = 2855,                                    droprate =   5 }, -- Mahogany Heartwood
            { itemid = xi.item.CHUNK_OF_FIRE_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_ICE_ORE,                droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WIND_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_EARTH_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHTNING_ORE,          droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WATER_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHT_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_DARK_ORE,               droprate =   3 },
            { itemid = xi.item.CLUMP_OF_IMPERIAL_TEA_LEAVES,    droprate =   4 },
            { itemid = xi.item.DRAGON_FRUIT,                    droprate =   4 },
            { itemid = xi.item.WALNUT,                          droprate =   4 },
            { itemid = xi.item.BOWL_OF_AMBROSIA,                droprate =   4 },
            { itemid = xi.item.BOTTLE_OF_AMRITA,                droprate =   4 },
            { itemid = xi.item.DRAGON_HEART,                    droprate =   3 },
            { itemid = xi.item.HANDFUL_OF_DRAGON_SCALES,        droprate =   3 },
            { itemid = xi.item.SLICE_OF_DRAGON_MEAT,            droprate =   3 },
            { itemid = xi.item.CHUNK_OF_HYDRA_MEAT,             droprate =   3 },
            { itemid = xi.item.SLICE_OF_CERBERUS_MEAT,          droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HIDE,                   droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HORN,                   droprate =   3 },
            { itemid = 2158,                                    droprate =   3 }, -- Hydra Fang
            { itemid = 2172,                                    droprate =   3 }, -- Hydra Scale
            { itemid = 2168,                                    droprate =   3 }, -- Cerberus Claw
            { itemid = 2169,                                    droprate =   3 }, -- Cerberus Hide
            { itemid = 2371,                                    droprate =   3 }, -- Khimaira Horn
            { itemid = 2372,                                    droprate =   3 }, -- Khimaira Mane
            { itemid = 2373,                                    droprate =   3 }, -- Khimaira Tail
            { itemid = 4273,                                    droprate =   3 }, -- Kitron
            { itemid = 1718,                                    droprate =   3 }, -- M-bugard Tusk
            { itemid = 1719,                                    droprate =   3 }, -- Harajnite Shell
            { itemid = xi.item.SQUARE_OF_ECARLATE_CLOTH,        droprate =   3 },
            { itemid = xi.item.ARGYRO_RIVET,                    droprate =   3 },
            { itemid = xi.item.UTOPIAN_GOLD_THREAD,             droprate =   3 },
            { itemid = xi.item.ANCIENT_BRASS_INGOT,             droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BENEDICT_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_BENEDICT_YARN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_DIABOLIC_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_DIABOLIC_YARN,          droprate =   3 },
            { itemid = xi.item.SPOOL_OF_RUBY_SILK_THREAD,       droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CARDINAL_CLOTH,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SUPPLE_SKIN,           droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LIGHT_FILAMENT,         droprate =   3 },
            { itemid = xi.item.CHUNK_OF_SNOWY_CERMET,           droprate =   3 },
            { itemid = xi.item.WHITE_RIVET,                     droprate =   3 },
            { itemid = xi.item.DARK_ORICHALCUM_INGOT,           droprate =   3 },
            { itemid = xi.item.BLACK_RIVET,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SMALT_LEATHER,         droprate =   3 },
            { itemid = xi.item.FETID_LANOLIN_CUBE,              droprate =   3 },
            { itemid = xi.item.SPOOL_OF_COILED_YARN,            droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BROWN_DOESKIN,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_CHAMELEON_YARN,         droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CHARCOAL_COTTON,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SCARLET_ODOSHI,         droprate =   3 },
            { itemid = xi.item.SHEET_OF_KUROGANE,               droprate =   3 },
            { itemid = xi.item.PLAITED_CORD,                    droprate =   3 },
            { itemid = xi.item.POT_OF_EBONY_LACQUER,            droprate =   3 },
            { itemid = xi.item.SHEET_OF_COBALT_MYTHRIL,         droprate =   3 },
            { itemid = xi.item.BLUE_RIVET,                      droprate =   3 },
            { itemid = xi.item.SPOOL_OF_GLITTERING_YARN,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ASTRAL_LEATHER,        droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LUMINIAN_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_FLAMESHUN_CLOTH,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SILKWORM_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CANVAS_TOILE,          droprate =   3 },
            { itemid = xi.item.PANTIN_WIRE,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CORDUROY_CLOTH,        droprate =   3 },
            { itemid = xi.item.PIECE_OF_ANGEL_SKIN,             droprate =   3 },
            { itemid = xi.item.LOCK_OF_SIRENS_HAIR,             droprate =   3 },
            { itemid = xi.item.DIVINE_LOG,                      droprate =   3 },
            { itemid = xi.item.POT_OF_VIRIDIAN_URUSHI,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_KEJUSU_SATIN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ELTORO_LEATHER,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_GALATEIA,              droprate =   3 },
            { itemid = xi.item.DRAGON_BONE,                     droprate =   3 },
            { itemid = 1703,                                    droprate =   3 }, -- Kunwu Ore
        },
        -- Slot 8, Materials --
        {
            { itemid = xi.item.IRON_INGOT,                      droprate =   4 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   4 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   4 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   4 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   4 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   4 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   4 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   4 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   4 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   4 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   4 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   4 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   4 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   4 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   4 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   4 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   4 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   4 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   4 },
            { itemid = xi.item.RAM_HORN,                        droprate =   4 },
            { itemid = xi.item.ELM_LOG,                         droprate =   4 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   4 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   4 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   4 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   4 },
            { itemid =  850,                                    droprate =   4 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   4 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   4 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   4 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   4 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   4 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   4 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   4 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   4 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   4 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   4 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   4 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   4 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   4 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   4 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   4 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   4 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   4 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   4 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   4 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   4 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   4 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   4 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   4 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   4 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   4 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   4 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   4 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   4 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   4 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   4 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   4 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   4 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   4 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   4 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   4 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   4 },
            { itemid = xi.item.IMP_HORN,                        droprate =   4 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   4 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   4 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   4 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   4 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   4 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   4 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   4 },
            { itemid = 1225,                                    droprate =   4 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   4 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   4 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   4 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   4 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   4 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   4 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   4 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   4 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   4 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   4 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   4 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   4 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   4 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   4 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   4 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   4 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   4 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   4 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   4 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   4 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   4 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   4 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   4 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   4 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   4 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   4 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   4 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   4 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   4 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   4 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   4 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   4 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   4 },
            { itemid = 2151,                                    droprate =   4 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   4 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   4 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   4 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   4 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   4 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   4 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   4 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   4 }, -- Water Anima
            { itemid = 1647,                                    droprate =   4 }, -- Light Anima
            { itemid = 1648,                                    droprate =   4 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   3 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   3 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   3 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   3 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   3 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   3 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   3 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   3 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   3 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   3 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   3 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   3 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   3 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   3 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   3 },
            { itemid =  734,                                    droprate =   3 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   3 }, -- Amphiptere Hide
            { itemid = 2164,                                    droprate =   4 }, -- Pephredo Hive Chip
            { itemid = 1279,                                    droprate =   4 }, -- Taffeta Cloth
            { itemid = 1280,                                    droprate =   4 }, -- Sarcenet Cloth
            { itemid = 1281,                                    droprate =   3 }, -- Cheviot Cloth
            { itemid = 1295,                                    droprate =   4 }, -- Twincoon
            { itemid = 1270,                                    droprate =   4 }, -- Arachne Web
            { itemid =  647,                                    droprate =   4 }, -- Molybdenum Ore
            { itemid = 1271,                                    droprate =   4 }, -- Pigeon's Blood Ruby
            { itemid = 1276,                                    droprate =   4 }, -- Tarasque Skin
            { itemid = 1296,                                    droprate =   4 }, -- Yowie Skin
            { itemid = 1277,                                    droprate =   4 }, -- Lindwurm Skin
            { itemid = 1765,                                    droprate =   4 }, -- Habu Skin
            { itemid = 2828,                                    droprate =   4 }, -- Herensugue Skin
            { itemid = 2837,                                    droprate =   4 }, -- Ratatoskr Pelt
            { itemid = 2839,                                    droprate =   4 }, -- Coquecigrue Skin
            { itemid = 2830,                                    droprate =   4 }, -- Bastet Fang
            { itemid = 2833,                                    droprate =   4 }, -- Thunder Coral
            { itemid = 1272,                                    droprate =   4 }, -- Arioch Fang
            { itemid = 1273,                                    droprate =   4 }, -- Namtar Bone
            { itemid = 2849,                                    droprate =   4 }, -- Likho Talon
            { itemid = 2846,                                    droprate =   4 }, -- Hefty Oak Lumber
            { itemid = 2855,                                    droprate =   4 }, -- Mahogany Heartwood
            { itemid = xi.item.CHUNK_OF_FIRE_ORE,               droprate =   2 },
            { itemid = xi.item.CHUNK_OF_ICE_ORE,                droprate =   2 },
            { itemid = xi.item.CHUNK_OF_WIND_ORE,               droprate =   2 },
            { itemid = xi.item.CHUNK_OF_EARTH_ORE,              droprate =   2 },
            { itemid = xi.item.CHUNK_OF_LIGHTNING_ORE,          droprate =   2 },
            { itemid = xi.item.CHUNK_OF_WATER_ORE,              droprate =   2 },
            { itemid = xi.item.CHUNK_OF_LIGHT_ORE,              droprate =   2 },
            { itemid = xi.item.CHUNK_OF_DARK_ORE,               droprate =   2 },
            { itemid = xi.item.CLUMP_OF_IMPERIAL_TEA_LEAVES,    droprate =   2 },
            { itemid = xi.item.DRAGON_FRUIT,                    droprate =   2 },
            { itemid = xi.item.WALNUT,                          droprate =   2 },
            { itemid = xi.item.BOWL_OF_AMBROSIA,                droprate =   2 },
            { itemid = xi.item.BOTTLE_OF_AMRITA,                droprate =   2 },
            { itemid = xi.item.DRAGON_HEART,                    droprate =   2 },
            { itemid = xi.item.HANDFUL_OF_DRAGON_SCALES,        droprate =   2 },
            { itemid = xi.item.SLICE_OF_DRAGON_MEAT,            droprate =   2 },
            { itemid = xi.item.CHUNK_OF_HYDRA_MEAT,             droprate =   2 },
            { itemid = xi.item.SLICE_OF_CERBERUS_MEAT,          droprate =   2 },
            { itemid = xi.item.BEHEMOTH_HIDE,                   droprate =   2 },
            { itemid = xi.item.BEHEMOTH_HORN,                   droprate =   2 },
            { itemid = 2158,                                    droprate =   2 }, -- Hydra Fang
            { itemid = 2172,                                    droprate =   2 }, -- Hydra Scale
            { itemid = 2168,                                    droprate =   2 }, -- Cerberus Claw
            { itemid = 2169,                                    droprate =   2 }, -- Cerberus Hide
            { itemid = 2371,                                    droprate =   2 }, -- Khimaira Horn
            { itemid = 2372,                                    droprate =   2 }, -- Khimaira Mane
            { itemid = 2373,                                    droprate =   2 }, -- Khimaira Tail
            { itemid = 4273,                                    droprate =   2 }, -- Kitron
            { itemid = 1718,                                    droprate =   2 }, -- M-bugard Tusk
            { itemid = 1719,                                    droprate =   2 }, -- Harajnite Shell
            { itemid = xi.item.SQUARE_OF_ECARLATE_CLOTH,        droprate =   2 },
            { itemid = xi.item.ARGYRO_RIVET,                    droprate =   2 },
            { itemid = xi.item.UTOPIAN_GOLD_THREAD,             droprate =   2 },
            { itemid = xi.item.ANCIENT_BRASS_INGOT,             droprate =   2 },
            { itemid = xi.item.SQUARE_OF_BENEDICT_SILK,         droprate =   2 },
            { itemid = xi.item.SPOOL_OF_BENEDICT_YARN,          droprate =   2 },
            { itemid = xi.item.SQUARE_OF_DIABOLIC_SILK,         droprate =   2 },
            { itemid = xi.item.SPOOL_OF_DIABOLIC_YARN,          droprate =   2 },
            { itemid = xi.item.SPOOL_OF_RUBY_SILK_THREAD,       droprate =   2 },
            { itemid = xi.item.SQUARE_OF_CARDINAL_CLOTH,        droprate =   2 },
            { itemid = xi.item.SQUARE_OF_SUPPLE_SKIN,           droprate =   2 },
            { itemid = xi.item.SPOOL_OF_LIGHT_FILAMENT,         droprate =   2 },
            { itemid = xi.item.CHUNK_OF_SNOWY_CERMET,           droprate =   2 },
            { itemid = xi.item.WHITE_RIVET,                     droprate =   2 },
            { itemid = xi.item.DARK_ORICHALCUM_INGOT,           droprate =   2 },
            { itemid = xi.item.BLACK_RIVET,                     droprate =   2 },
            { itemid = xi.item.SQUARE_OF_SMALT_LEATHER,         droprate =   2 },
            { itemid = xi.item.FETID_LANOLIN_CUBE,              droprate =   2 },
            { itemid = xi.item.SPOOL_OF_COILED_YARN,            droprate =   2 },
            { itemid = xi.item.SQUARE_OF_BROWN_DOESKIN,         droprate =   2 },
            { itemid = xi.item.SPOOL_OF_CHAMELEON_YARN,         droprate =   2 },
            { itemid = xi.item.SQUARE_OF_CHARCOAL_COTTON,       droprate =   2 },
            { itemid = xi.item.SPOOL_OF_SCARLET_ODOSHI,         droprate =   2 },
            { itemid = xi.item.SHEET_OF_KUROGANE,               droprate =   2 },
            { itemid = xi.item.PLAITED_CORD,                    droprate =   2 },
            { itemid = xi.item.POT_OF_EBONY_LACQUER,            droprate =   2 },
            { itemid = xi.item.SHEET_OF_COBALT_MYTHRIL,         droprate =   2 },
            { itemid = xi.item.BLUE_RIVET,                      droprate =   2 },
            { itemid = xi.item.SPOOL_OF_GLITTERING_YARN,        droprate =   2 },
            { itemid = xi.item.SQUARE_OF_ASTRAL_LEATHER,        droprate =   2 },
            { itemid = xi.item.SPOOL_OF_LUMINIAN_THREAD,        droprate =   2 },
            { itemid = xi.item.SQUARE_OF_FLAMESHUN_CLOTH,       droprate =   2 },
            { itemid = xi.item.SPOOL_OF_SILKWORM_THREAD,        droprate =   2 },
            { itemid = xi.item.SQUARE_OF_CANVAS_TOILE,          droprate =   2 },
            { itemid = xi.item.PANTIN_WIRE,                     droprate =   2 },
            { itemid = xi.item.SQUARE_OF_CORDUROY_CLOTH,        droprate =   2 },
            { itemid = xi.item.PIECE_OF_ANGEL_SKIN,             droprate =   2 },
            { itemid = xi.item.LOCK_OF_SIRENS_HAIR,             droprate =   2 },
            { itemid = xi.item.DIVINE_LOG,                      droprate =   2 },
            { itemid = xi.item.POT_OF_VIRIDIAN_URUSHI,          droprate =   2 },
            { itemid = xi.item.SQUARE_OF_KEJUSU_SATIN,          droprate =   2 },
            { itemid = xi.item.SQUARE_OF_ELTORO_LEATHER,        droprate =   2 },
            { itemid = xi.item.SQUARE_OF_GALATEIA,              droprate =   2 },
            { itemid = xi.item.DRAGON_BONE,                     droprate =   2 },
            { itemid = 1703,                                    droprate =   2 }, -- Kunwu Ore
            { itemid = 1703,                                    droprate =   2 }, -- Kunwu Ore
            { itemid =    0,                                    droprate = 250 }, -- nothing
        },
        -- Slot 5, Misc/Medicine --
        {
            { itemid = xi.item.VILE_ELIXIR,                     droprate = 150 },
            { itemid = 4149,                                    droprate = 150 }, -- Panacea
            { itemid = xi.item.VILE_ELIXIR_P1,                  droprate = 140 },
            { itemid = xi.item.HI_RERAISER,                     droprate = 140 },
            { itemid = xi.item.REMEDY,                          droprate = 140 },
            { itemid = xi.item.ICARUS_WING,                     droprate = 140 },
            { itemid = xi.item.SUPER_RERAISER,                  droprate = 140 },
        },
        -- Slot 9, Misc/Medicine --
        {
            { itemid = xi.item.VILE_ELIXIR,                     droprate = 150 },
            { itemid = 4149,                                    droprate = 150 }, -- Panacea
            { itemid = xi.item.VILE_ELIXIR_P1,                  droprate = 140 },
            { itemid = xi.item.HI_RERAISER,                     droprate = 140 },
            { itemid = xi.item.REMEDY,                          droprate = 140 },
            { itemid = xi.item.ICARUS_WING,                     droprate = 140 },
            { itemid = xi.item.SUPER_RERAISER,                  droprate = 140 },
        },
    },
    [75] =
    {   -- Slot 1, Currency --
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate =  90 },
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  10 },
            { itemid = xi.item.LINEN_COIN_PURSE,                droprate = 100 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =  90 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =  90 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =  90 },
            { itemid =  6541,                                   droprate =  90 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  90 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  90 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  90 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  90 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter
        },
        -- Slot 6, Currency
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate =  90 },
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  60 },
            { itemid = xi.item.LINEN_COIN_PURSE,                droprate =  90 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =  90 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =  90 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =  90 },
            { itemid =  6541,                                   droprate =  80 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  80 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  80 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  80 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  80 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter
        },
        -- Slot 10, Tatters --
        {
            { itemid =  3283,                                   droprate = 125 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate = 125 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate = 125 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate = 125 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate = 125 }, -- Martial Tatter
            { itemid =  3279,                                   droprate = 125 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate = 125 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate = 125 }, -- Wyrmal Tatter
        },
        -- Slot 2, Pop Items
        {
            { itemid = 1404,                                    droprate =  20 }, -- Genbu Seal
            { itemid = 1405,                                    droprate =  20 }, -- Seiryu Seal
            { itemid = 1406,                                    droprate =  20 }, -- Byakko Seal
            { itemid = 1407,                                    droprate =  20 }, -- Suzaku Seal
            { itemid = xi.item.IVORY_CHIP,                      droprate =  20 },
            { itemid = xi.item.SCARLET_CHIP,                    droprate =  20 },
            { itemid = xi.item.EMERALD_CHIP,                    droprate =  20 },
            { itemid = xi.item.SILVER_CHIP,                     droprate =  20 },
            { itemid = xi.item.CERULEAN_CHIP,                   droprate =  20 },
            { itemid = 1986,                                    droprate =  20 }, -- Orchid Chip
            { itemid = xi.item.SMALT_CHIP,                      droprate =  20 },
            { itemid = xi.item.SMOKY_CHIP,                      droprate =  20 },
            { itemid = 1987,                                    droprate =  20 }, -- Charcoal Chip
            { itemid = 1988,                                    droprate =  20 }, -- Magenta Chip
            { itemid = xi.item.FIRST_VIRTUE,                    droprate =  20 },
            { itemid =  1853,                                   droprate =  20 }, -- Second Virtue
            { itemid = xi.item.THIRD_VIRTUE,                    droprate =  20 },
            { itemid =  1848,                                   droprate =  20 }, -- Fourth Virtue
            { itemid =  1847,                                   droprate =  20 }, -- Fifth Virtue
            { itemid =  1849,                                   droprate =  20 }, -- Sxith Virtue
            { itemid = xi.item.HELLCAGE_BUTTERFLY,              droprate =  20 },
            { itemid = xi.item.JUG_OF_FLORAL_NECTAR,            droprate =  20 },
            { itemid = xi.item.WEDGE_OF_RODENT_CHEESE,          droprate =  20 },
            { itemid = xi.item.CLUMP_OF_SHADELEAVES,            droprate =  20 },
            { itemid = xi.item.BEAKER_OF_PECTIN,                droprate =  20 },
            { itemid = xi.item.FLASK_OF_COG_LUBRICANT,          droprate =  20 },
            { itemid = xi.item.GOLDEN_TEETH,                    droprate =  20 },
            { itemid = xi.item.GREENLING,                       droprate =  20 },
            { itemid = xi.item.BOTTLE_OF_SPOILT_BLOOD,          droprate =  20 },
            { itemid = xi.item.BUNCH_OF_SENORITA_PAMAMAS,       droprate =  20 },
            { itemid = xi.item.JAR_OF_OILY_BLOOD,               droprate =  20 },
            { itemid = xi.item.STRAND_OF_SAMARIRI_CORPSEHAIR,   droprate =  20 },
            { itemid = xi.item.SLAB_OF_RAW_BUFFALO,             droprate =  20 },
            { itemid = xi.item.LUMP_OF_BONE_CHARCOAL,           droprate =  20 },
            { itemid = xi.item.PINCH_OF_GRANULATED_SUGAR,       droprate =  20 },
            { itemid = xi.item.MINT_DROP,                       droprate =  20 },
            { itemid = xi.item.OPALUS_GEM,                      droprate =  20 },
            { itemid = xi.MERROW_NO_11_MOLTING,                 droprate =  20 },
            { itemid = xi.BAR_OF_FERRITE,                       droprate =  20 },
            { itemid = xi.BAGGED_SHEEP_BOTFLY,                  droprate =  20 },
            { itemid = xi.OLZHIRYAN_CACTUS_PADDLE,              droprate =  20 },
            { itemid = xi.VIAL_OF_PURE_BLOOD,                   droprate =  20 },
            { itemid = xi.VINEGAR_PIE,                          droprate =  20 },
            { itemid = xi.JAR_OF_ROCK_JUICE,                    droprate =  20 },
            { itemid = xi.BOUND_EXORCISM_TREATISE,              droprate =  20 },
            { itemid = xi.CLUMP_OF_MYRRH,                       droprate =  20 },
            { itemid = xi.WHOLE_ROSE_SCAMPI,                    droprate =  20 },
            { itemid = xi.JUG_OF_MONKEY_WINE,                   droprate =  20 },
            { itemid = xi.CHUNK_OF_BUFFALO_CORPSE,              droprate =  20 },
            { itemid = xi.CHUNK_OF_SINGED_BUFFALO,              droprate =  20 },
        },
        -- Slot 3, Equipment --
        {
            { itemid = xi.item.DUENDE_COTEHARDIE,               droprate =   4 },
            { itemid = xi.item.NOKIZARU_GI,                     droprate =   4 },
            { itemid = xi.item.RAPPAREE_HARNESS,                droprate =   4 },
            { itemid = xi.item.SHINIMUSHA_HARA_ATE,             droprate =   4 },
            { itemid = xi.item.WYVERN_MAIL,                     droprate =   4 },
            { itemid = xi.item.SHIKAREE_AKETON,                 droprate =   4 },
            { itemid = xi.item.CERISE_DOUBLET,                  droprate =   4 },
            { itemid = xi.item.GLAMOR_JUPON,                    droprate =   4 },
            { itemid = xi.item.GLOOM_BREASTPLATE,               droprate =   4 },
            { itemid = xi.item.NIMBUS_DOUBLET,                  droprate =   4 },
            { itemid = xi.item.AIKIDO_GI,                       droprate =   4 },
            { itemid = xi.item.PARADE_CUIRASS,                  droprate =   4 },
            { itemid = xi.item.GAUDY_HARNESS,                   droprate =   4 },
            { itemid = xi.item.HAMAYUMI,                        droprate =   5 },
            { itemid = xi.item.DIA_WAND,                        droprate =   4 },
            { itemid = xi.item.STONE_GORGET,                    droprate =   5 },
            { itemid =  18359,                                  droprate =   5 }, -- Boreas Cesti
            { itemid =  15468,                                  droprate =   5 }, -- Resentment Cape
            { itemid =  xi.item.GOTHIC_SABATONS,                droprate =   5 },
            { itemid =  xi.item.GOTHIC_GAUNTLETS,               droprate =   5 },
            { itemid =  16187,                                  droprate =   5 }, -- Adoubeurs Pavise
            { itemid =  16899,                                  droprate =   5 }, -- Hototogisu
            { itemid =  16374,                                  droprate =   5 }, -- Layqa Seraweels
            { itemid =  17199,                                  droprate =   5 }, -- Loxley Bow
            { itemid =  16882,                                  droprate =   5 }, -- Calamar
            { itemid =  17504,                                  droprate =   5 }, -- Pagures
            { itemid =  16884,                                  droprate =   5 }, -- Narval
            { itemid =  17503,                                  droprate =   5 }, -- Exocets
            { itemid =  19238,                                  droprate =   5 }, -- Jasper Tathlum
            { itemid =  11404,                                  droprate =   5 }, -- Promptitude Solea
            { itemid =  15897,                                  droprate =   5 }, -- Grace Corset
            { itemid =  13803,                                  droprate =   5 }, -- Shaman's Cloak
            { itemid =  19237,                                  droprate =   5 }, -- Slick Dart
            { itemid =  15942,                                  droprate =   5 }, -- Summoning Belt
            { itemid =  xi.item.MUSHROOM_HELM,                  droprate =   2 },
            { itemid =  xi.item.LUNA_SUBLIGAR,                  droprate =   2 },
            { itemid =  16980,                                  droprate =   5 }, -- Sukesada
            { itemid =  13912,                                  droprate =   5 }, -- Shadow Mask
            { itemid =  16943,                                  droprate =   5 }, -- Ascalon
            { itemid =  14063,                                  droprate =   5 }, -- Protecting Bangles
            { itemid =  14064,                                  droprate =   5 }, -- Sand Gloves
            { itemid =  17651,                                  droprate =   5 }, -- Dainslaif
            { itemid =  17924,                                  droprate =   5 }, -- Tungi
            { itemid =  16734,                                  droprate =   5 }, -- Pendragon Axe
            { itemid =  15995,                                  droprate =   5 }, -- Carline Earring
            { itemid =  16127,                                  droprate =   5 }, -- Carline Ribbon
            { itemid =  16125,                                  droprate =   5 }, -- Breeder Mask
            { itemid =  15001,                                  droprate =   5 }, -- Breeder Mufflers
            { itemid =  15946,                                  droprate =   5 }, -- Tempest Belt
            { itemid =  11405,                                  droprate =   5 }, -- Kyoshu Kyahan
            { itemid =  11533,                                  droprate =   5 }, -- Lyricist's Gonnelle
            { itemid =  16298,                                  droprate =   5 }, -- Knack Pendant
            { itemid =  17454,                                  droprate =   5 }, -- Asklepios
            { itemid =  17455,                                  droprate =   5 }, -- Skirnir's Wand
            { itemid =  16912,                                  droprate =   5 }, -- Kitsutsuki
            { itemid =  17926,                                  droprate =   5 }, -- Acha D'Armas
            { itemid =  17982,                                  droprate =   5 }, -- Kard
            { itemid =  17983,                                  droprate =   5 }, -- Valiant Knife
            { itemid =  18042,                                  droprate =   5 }, -- Ascention
            { itemid =  17563,                                  droprate =   5 }, -- Power Staff
            { itemid =  17969,                                  droprate =   5 }, -- Fendoir
            { itemid =  18608,                                  droprate =   5 }, -- Atesh Pole
            { itemid =  16727,                                  droprate =   5 }, -- Eisentaenzer
            { itemid =  17971,                                  droprate =   5 }, -- Tartaglia
            { itemid =  19235,                                  droprate =   5 }, -- Veuglaire
            { itemid =  16375,                                  droprate =   5 }, -- Surge Subligar
            { itemid =  xi.item.ASTRAL_ASPIS,                   droprate =   5 },
            { itemid =  xi.item.GAE_BOLG,                       droprate =   5 },
            { itemid =  xi.item.LOHAR,                          droprate =   5 },
            { itemid =   19122,                                 droprate =   5 }, -- Courser's Pugio
            { itemid =   16081,                                 droprate =   5 }, -- Curate's Hat
            { itemid =   15882,                                 droprate =   5 }, -- Othinus' Bow
            { itemid =   17244,                                 droprate =   5 }, -- Storm Belt
            { itemid =   14806,                                 droprate =   5 }, -- Intruder Earring
            { itemid =   14466,                                 droprate =   5 }, -- Fomor Tunic
            { itemid =   18007,                                 droprate =   5 }, -- Chiroptera Dagger
            { itemid =   17510,                                 droprate =   5 }, -- Vampiric Claws
            { itemid =   14763,                                 droprate =   5 }, -- Boroka Earring
            { itemid =   13178,                                 droprate =   5 }, -- Auditory Torque
            { itemid =   15943,                                 droprate =   5 }, -- Virtuoso Belt
            { itemid =   14884,                                 droprate =   5 }, -- Mycophile Cuffs
            { itemid =   17794,                                 droprate =   5 }, -- Niokiyotsuna
            { itemid =   15219,                                 droprate =   5 }, -- Sinister Mask
            { itemid =   16368,                                 droprate =   5 }, -- Herder's Subligar
            { itemid =   14724,                                 droprate =   5 }, -- Moldavite Earring
            { itemid =   16279,                                 droprate =   5 }, -- Pile Chain
            { itemid =   15546,                                 droprate =   5 }, -- Fasting Ring
            { itemid =   16299,                                 droprate =   5 }, -- Lleu's Charm
            { itemid =   11496,                                 droprate =   5 }, -- Fenrir's Crown
            { itemid =   14168,                                 droprate =   5 }, -- Dune Boots
            { itemid =   17854,                                 droprate =   5 }, -- Cradle Horn
            { itemid =   19239,                                 droprate =   5 }, -- Astrolable
            { itemid =   16169,                                 droprate =   5 }, -- Caballero Shield
            { itemid =   17653,                                 droprate =   5 }, -- Hrotti
            { itemid =   18027,                                 droprate =   5 }, -- Palladium Dagger
            { itemid =   17564,                                 droprate =   5 }, -- Cocytus Pole
            { itemid =   16426,                                 droprate =   5 }, -- Avengers
            { itemid =   19121,                                 droprate =   5 }, -- Sleight Kukri
            { itemid =   15944,                                 droprate =   7 }, -- Selemnus Belt
            { itemid =   16297,                                 droprate =   7 }, -- Shepherd's Chain
            { itemid =  xi.item.KAMEWARI,                       droprate =   5 },
            { itemid =  xi.item.NADRS,                          droprate =   5 },
            { itemid =  xi.item.ALTDORFS_EARRING,               droprate =   5 },
            { itemid =  xi.item.WILHELMS_EARRING,               droprate =   5 },
            { itemid =  xi.item.HELENUSS_EARRING,               droprate =   5 },
            { itemid =  xi.item.CASSANDRAS_EARRING,             droprate =   5 },
            { itemid =  xi.item.MINSTRELS_DAGGER,               droprate =   5 },
            { itemid =  xi.item.SAND_CHARM,                     droprate =   5 },
            { itemid =   15692,                                 droprate =   5 }, -- Storm Crackows
            { itemid =   14669,                                 droprate =   5 }, -- Jaeger Ring
            { itemid =   15351,                                 droprate =   5 }, -- Bounding Boots
            { itemid =   18018,                                 droprate =   5 }, -- Sirocco Kukri
            { itemid =   13567,                                 droprate =   5 }, -- Bomb Queen Ring
            { itemid =   15547,                                 droprate =   5 }, -- Vilma's Ring
            { itemid =   26164,                                 droprate =   5 }, -- Caliber Ring
            { itemid =   15183,                                 droprate =   7 }, -- Dobson Bandana
            { itemid =   15184,                                 droprate =   7 }, -- Voyager Sallet
            { itemid =   14986,                                 droprate =   7 }, -- Ochimusha Kote
            { itemid =   15737,                                 droprate =   7 }, -- Sarutobi Kyahan
            { itemid =   15551,                                 droprate =   7 }, -- Shikaree Ring
            { itemid =  xi.item.EMPRESS_HAIRPIN,                droprate =   7 },
            { itemid =  xi.item.JOYEUSE,                        droprate =   7 },
            { itemid =  xi.item.DRYAD_STAFF,                    droprate =   7 },
            { itemid =  xi.item.VALIS_BOW,                      droprate =   7 },
            { itemid =  xi.item.RETALIATORS,                    droprate =   7 },
            { itemid =  xi.item.UNGUR_BOOMERANG,                droprate =   7 },
            { itemid =   15515,                                 droprate =   7 }, -- Peacock Amulet
            { itemid =  xi.item.TROTTER_BOOTS,                  droprate =   7 },
            { itemid =   19236,                                 droprate =   7 }, -- Hightail Bullet
            { itemid =   17192,                                 droprate =   7 }, -- Ifrit's Bow
            { itemid =   17711,                                 droprate =   7 }, -- Shiva's Shotel
            { itemid =   18021,                                 droprate =   7 }, -- Titan's Baselarde
            { itemid =   18063,                                 droprate =   7 }, -- Garuda's Sickle
            { itemid =   18109,                                 droprate =   7 }, -- Leviathan's Couse
            { itemid =   18404,                                 droprate =   7 }, -- Ramuh's Mace
            { itemid =   18581,                                 droprate =   7 }, -- Carbuncle's Pole
            { itemid =   14931,                                 droprate =   7 }, -- Carbuncle's Cuffs
            { itemid =   18422,                                 droprate =   7 }, -- Ryumon
            { itemid =   14960,                                 droprate =   7 }, -- Evoker's Gages
            { itemid =   19277,                                 droprate =   7 }, -- Tsugumi
            { itemid =   11408,                                 droprate =   7 }, -- Morana Pigaches
            { itemid =   11409,                                 droprate =   7 }, -- Aoide's Pumps
            { itemid =   16238,                                 droprate =   7 }, -- Taster's Cape
            { itemid =   11497,                                 droprate =   7 }, -- Spurrer Beret
            { itemid =   11406,                                 droprate =   7 }, -- Stimulus Sabots
            { itemid =   18767,                                 droprate =   6 }, -- Birdbanes
            { itemid =   15854,                                 droprate =   7 }, -- Sortie Ring
            { itemid =   15915,                                 droprate =   7 }, -- Sothic Rope
            { itemid =   11342,                                 droprate =   6 }, -- Restorer Cloak
            { itemid =   18770,                                 droprate =   7 }, -- Pygme Sainti
            { itemid =   17737,                                 droprate =   6 }, -- Corsair's Scimitar
            { itemid =   19124,                                 droprate =   7 }, -- Creve-coeur
            { itemid =   19279,                                 droprate =   7 }, -- Musanto
            { itemid =   17766,                                 droprate =   7 }, -- Lyft Scimitar
            { itemid =   17970,                                 droprate =   7 }, -- Lyft Tabar
            { itemid =   18508,                                 droprate =   7 }, -- Lyft Voulge
            { itemid =   18609,                                 droprate =   7 }, -- Lyft Pole
            { itemid =   18771,                                 droprate =   7 }, -- Lyft Sainti
            { itemid =   18872,                                 droprate =   7 }, -- Lyft Ferule
            { itemid =   18958,                                 droprate =   7 }, -- Lyft Scythe
            { itemid =   19125,                                 droprate =   7 }, -- Lyft Jambiya
            { itemid =   19161,                                 droprate =   7 }, -- Lyft Claymore
            { itemid =   19233,                                 droprate =   7 }, -- Lyft Crossbow
            { itemid =   19306,                                 droprate =   7 }, -- Lyft Lance
            { itemid =  xi.item.LAVAS_RING,                     droprate =   7 },
            { itemid =  xi.item.KUSHAS_RING,                    droprate =   7 },
            { itemid =  xi.item.NASATYAS_RING,                  droprate =   7 },
            { itemid =  xi.item.DASRAS_RING,                    droprate =   7 },
            { itemid =  xi.item.HOPE_STAFF,                     droprate =   7 },
            { itemid =  xi.item.JUSTICE_SWORD,                  droprate =   7 },
            { itemid =  xi.item.TEMPERANCE_AXE,                 droprate =   7 },
            { itemid =  xi.item.LOVE_HALBERD,                   droprate =   7 },
            { itemid =  xi.item.FORTITUDE_AXE,                  droprate =   7 },
            { itemid =  xi.item.FAITH_BAGHNAKHS,                droprate =   7 },
            { itemid =  xi.item.PRUDENCE_ROD,                   droprate =   7 },
            { itemid =  xi.item.BYAKKOS_AXE,                    droprate =   8 },
            { itemid =  xi.item.SUZAKUS_SCYTHE,                 droprate =   8 },
            { itemid =  xi.item.SEIRYUS_SWORD,                  droprate =   8 },
        },
        -- Slot 7, Equipment --
        {
            { itemid =  5681,                                   droprate =   7 }, -- Cupid Chocolate
            { itemid = xi.item.AERN_DAGGER,                     droprate =   1 },
            { itemid = xi.item.AERN_SWORD,                      droprate =   1 },
            { itemid = xi.item.AERN_AXE,                        droprate =   1 },
            { itemid = xi.item.AERN_SPEAR,                      droprate =   1 },
            { itemid = xi.item.AERN_STAFF,                      droprate =   1 },
            { itemid = xi.item.CHICKEN_KNIFE_II,                droprate =   1 },
            { itemid = xi.item.GENBUS_KABUTO,                   droprate =   6 },
            { itemid = xi.item.GENBUS_SHIELD,                   droprate =   6 },
            { itemid = xi.item.SEIRYUS_KOTE,                    droprate =   6 },
            { itemid = xi.item.SUZAKUS_SUNE_ATE,                droprate =   6 },
            { itemid = xi.item.BYAKKOS_HAIDATE,                 droprate =   6 },
            { itemid = xi.item.ANIMATOR_P1,                     droprate =   5 },
            { itemid = 17567,                                   droprate =   5 }, -- Kirin's Pole
            { itemid = 12562,                                   droprate =   5 }, -- Kirin's Osode
            { itemid = 16034,                                   droprate =   5 }, -- Sarabande Earring
            { itemid = 13415,                                   droprate =   5 }, -- Pixie Earring
            { itemid = 16300,                                   droprate =   5 }, -- Wit Pendant
            { itemid = 16303,                                   droprate =   5 }, -- Laran's Pendant
            { itemid = 15057,                                   droprate =   5 }, -- Bricta's Cuffs
            { itemid = 14943,                                   droprate =   5 }, -- Barbarossa's Moufles
            { itemid = 16376,                                   droprate =   5 }, -- Bahram Cuisses
            { itemid = 16302,                                   droprate =   5 }, -- Bloodbead Gorget
            { itemid = 11411,                                   droprate =   5 }, -- Shrewd Pumps
            { itemid = 15223,                                   droprate =   5 }, -- Ace's Helm
            { itemid = 18002,                                   droprate =   5 }, -- Perseu's Harp
            { itemid = 14873,                                   droprate =   5 }, -- Bandomusha Kote
            { itemid = 19280,                                   droprate =   5 }, -- Narigitsune
            { itemid = xi.item.WYRM_BEARD,                      droprate =   5 },
            { itemid = xi.item.BEHEMOTH_TONGUE,                 droprate =   5 },
            { itemid = xi.item.ADAMANTOISE_EGG,                 droprate =   5 },
            { itemid = xi.item.SEVENEYES,                       droprate =   5 },
            { itemid = xi.item.ALGOL,                           droprate =   5 },
            { itemid = 13658,                                   droprate =   5 }, -- Shadow Mantle
            { itemid = 14646,                                   droprate =   5 }, -- Shadow Ring
            { itemid = 11589,                                   droprate =   5 }, -- Aesir Torque
            { itemid = 16057,                                   droprate =   5 }, -- Aesir Ear Pendant
            { itemid = 11546,                                   droprate =   5 }, -- Aesir Mantle
            { itemid = 11547,                                   droprate =   5 }, -- Colossus's Mantle
            { itemid = 11590,                                   droprate =   5 }, -- Colossus's Torque
            { itemid = 16058,                                   droprate =   5 }, -- Colossus's Earring
            { itemid = 18019,                                   droprate =   5 }, -- X's Knife
            { itemid = 18057,                                   droprate =   5 }, -- Y's Scythe
            { itemid = 18101,                                   droprate =   5 }, -- Z's Trident
            { itemid = 15899,                                   droprate =   5 }, -- Velocious Belt
            { itemid = 15617,                                   droprate =   5 }, -- Barbarossa's Zerehs
            { itemid = 17586,                                   droprate =   5 }, -- Mercurial Pole
            { itemid = xi.item.JUSTICE_TORQUE,                  droprate =   5 },
            { itemid = xi.item.HOPE_TORQUE,                     droprate =   5 },
            { itemid = xi.item.PRUDENCE_TORQUE,                 droprate =   5 },
            { itemid = xi.item.FORTITUDE_TORQUE,                droprate =   5 },
            { itemid = xi.item.FAITH_TORQUE,                    droprate =   5 },
            { itemid = xi.item.TEMPERANCE_TORQUE,               droprate =   5 },
            { itemid = xi.item.LOVE_TORQUE,                     droprate =   3 },
            { itemid = xi.item.RIDILL,                          droprate =   3 },
            { itemid = xi.item.OCTAVE_CLUB,                     droprate =   3 },
            { itemid = xi.item.HAUTECLAIRE,                     droprate =   3 },
            { itemid = 13566,                                   droprate =   3 }, -- Defending Ring
            { itemid = 27456,                                   droprate =   3 }, -- Crier's Gaiters
            { itemid = 14468,                                   droprate =   3 }, -- Yinyang Robe
            { itemid = 17754,                                   droprate =   5 }, -- Sylphid Epee
            { itemid = 16154,                                   droprate =   5 }, -- Karura Hachigane
            { itemid = 16000,                                   droprate =   5 }, -- Dragoon's Earring
            { itemid = 16240,                                   droprate =   5 }, -- Erato's Cape
            { itemid = 17755,                                   droprate =   5 }, -- Beast Slayer
            { itemid = 16340,                                   droprate =   5 }, -- Armadillo Cuisses
            { itemid = 17961,                                   droprate =   5 }, -- Lion Tamer
            { itemid = 15018,                                   droprate =   5 }, -- Ritterhentzes
            { itemid = 18859,                                   droprate =   5 }, -- Kerykeion
            { itemid = 16274,                                   droprate =   5 }, -- Almah Torque
            { itemid = 15999,                                   droprate =   5 }, -- Guignol Earring
            { itemid = 15916,                                   droprate =   5 }, -- Corsair's Belt
            { itemid = 18950,                                   droprate =   5 }, -- White Joker
            { itemid = 11369,                                   droprate =   5 }, -- Numerist Pumps
            { itemid = 11368,                                   droprate =   5 }, -- Hakke Habaki
            { itemid = 15827,                                   droprate =   5 }, -- Insect Ring
            { itemid = 15828,                                   droprate =   5 }, -- Blood Ring
            { itemid = 19154,                                   droprate =   5 }, -- Ferrara
            { itemid = 11366,                                   droprate =   5 }, -- Avocat Pigaches
            { itemid = 15017,                                   droprate =   5 }, -- Toad Mittens
            { itemid = 16339,                                   droprate =   5 }, -- Paddock Trousers
            { itemid = 16153,                                   droprate =   5 }, -- Reikyo Hairpin
            { itemid = 11367,                                   droprate =   5 }, -- Nobushi Kyahan
            { itemid = 19109,                                   droprate =   5 }, -- Trilling Dagger
            { itemid = 18448,                                   droprate =   5 }, -- Hacchonenbutsu
            { itemid = 19211,                                   droprate =   5 }, -- Reacton Arm
            { itemid = 19028,                                   droprate =   5 }, -- Magic Strap
            { itemid = 18127,                                   droprate =   5 }, -- Achilles' Spear
            { itemid = 16338,                                   droprate =   5 }, -- Ruby Seraweels
            { itemid = 18949,                                   droprate =   5 }, -- Zareehkl Scythe
            { itemid = 19108,                                   droprate =   5 }, -- Zareehkl Jambiya
            { itemid = 16239,                                   droprate =   5 }, -- Solitaire Cape
            { itemid = 16175,                                   droprate =   5 }, -- Muse Tariqah
            { itemid = 16152,                                   droprate =   5 }, -- Hissho Hachimaki
            { itemid = 16174,                                   droprate =   5 }, -- Riot Shield
            { itemid = 18126,                                   droprate =   4 }, -- Tomoe
            { itemid = xi.item.ORACLES_GLOVES,                  droprate =   4 },
            { itemid = xi.item.AURUM_SABATONS,                  droprate =   4 },
            { itemid = 19031,                                   droprate =   4 }, -- Fire Grip
            { itemid = 19032,                                   droprate =   4 }, -- Water Grip
            { itemid = 19033,                                   droprate =   4 }, -- Wind Grip
            { itemid = 19034,                                   droprate =   4 }, -- Ice Grip
            { itemid = 19035,                                   droprate =   4 }, -- Thunder Grip
            { itemid = 19036,                                   droprate =   4 }, -- Earth Grip
            { itemid = 19037,                                   droprate =   4 }, -- Light Grip
            { itemid = 19038,                                   droprate =   4 }, -- Dark Grip
            { itemid = xi.item.ENKIDUS_MITTENS,                 droprate =   4 },
            { itemid = xi.item.AURUM_CUISSES,                   droprate =   4 },
            { itemid = 19153,                                   droprate =   4 }, -- Naglering
            { itemid = 18125,                                   droprate =   4 }, -- Cletine
            { itemid = xi.item.ENKIDUS_SUBLIGAR,                droprate =   4 },
            { itemid = xi.item.ORACLES_PIGACHES,                droprate =   4 },
            { itemid = 17960,                                   droprate =   4 }, -- Labrys
            { itemid = xi.item.ENKIDUS_LEGGINGS,                droprate =   4 },
            { itemid = xi.item.AURUM_GAUNTLETS,                 droprate =   4 },
            { itemid = 16176,                                   droprate =   4 }, -- Simba Buckler
            { itemid = 17753,                                   droprate =   4 }, -- Organics
            { itemid = xi.item.ORACLES_BRACONI,                 droprate =   4 },
            { itemid = 16177,                                   droprate =   4 }, -- Legion Scutum
            { itemid = 18595,                                   droprate =   4 }, -- Mekki Shakki
            { itemid = 18430,                                   droprate =   4 }, -- Oninohocho
            { itemid = 18593,                                   droprate =   2 }, -- Alkalurops
            { itemid = xi.item.ENKIDUS_CAP,                     droprate =   3 },
            { itemid = xi.item.ENKIDUS_HARNESS,                 droprate =   3 },
            { itemid = xi.item.HACHIRYU_SUNE_ATE,               droprate =   3 },
            { itemid = xi.item.ORACLES_CAP,                     droprate =   3 },
            { itemid = 18429,                                   droprate =   3 }, -- Shusui
            { itemid = xi.item.AURUM_ARMET,                     droprate =   3 },
            { itemid = 18497,                                   droprate =   3 }, -- Foolkiller
            { itemid = xi.item.HACHIRYU_HAIDATE,                droprate =   3 },
            { itemid = xi.item.ORACLES_ROBE,                    droprate =   3 },
            { itemid = 18446,                                   droprate =   3 }, -- Pachipachio
            { itemid = 18857,                                   droprate =   3 }, -- Antares
            { itemid = xi.item.AURUM_CUIRASS,                   droprate =   3 },
            { itemid = xi.item.HACHIRYU_KOTE,                   droprate =   3 },
            { itemid = xi.item.HACHIRYU_HARAMAKI,               droprate =   2 },
            { itemid = 10754,                                   droprate =   3 }, -- Moepapa Ring
            { itemid = 10755,                                   droprate =   3 }, -- Moepapa Annulet
            { itemid = 10756,                                   droprate =   3 }, -- Tjukurrpa Ring
            { itemid = 10757,                                   droprate =   3 }, -- Tjukurrpa Annulet
            { itemid = 10759,                                   droprate =   3 }, -- Aife's Annulet
            { itemid = 10817,                                   droprate =   3 }, -- Moepapa Stone
            { itemid = 10818,                                   droprate =   3 }, -- Tjukurrpa Belt
            { itemid = 10932,                                   droprate =   3 }, -- Oneiros torque
            { itemid = 10933,                                   droprate =   3 }, -- Mujin necklace
            { itemid = 10940,                                   droprate =   3 }, -- Moepapa Pendant
            { itemid = 10941,                                   droprate =   3 }, -- Tjukurrpa Medal
            { itemid = 10942,                                   droprate =   3 }, -- Aife's Medal
            { itemid = 10943,                                   droprate =   3 }, -- Moepapa Medal
            { itemid = 10972,                                   droprate =   3 }, -- Oneiros cappa
            { itemid = 10973,                                   droprate =   3 }, -- Oneiros cape
            { itemid = 10974,                                   droprate =   3 }, -- Mujin mantle
            { itemid = 10983,                                   droprate =   3 }, -- Aife's Mantle
            { itemid = 10984,                                   droprate =   3 }, -- Tjukurrpa Mantle
            { itemid = 11030,                                   droprate =   3 }, -- Oneiros earring
            { itemid = 11032,                                   droprate =   3 }, -- Mujin Stud
            { itemid = 11031,                                   droprate =   3 }, -- Oneiros pearl
            { itemid = 11456,                                   droprate =   3 }, -- Ryuga Sune-Ate
            { itemid = 11461,                                   droprate =   3 }, -- Aife's Pumps
            { itemid = 11670,                                   droprate =   3 }, -- Oneiros annulet
            { itemid = 11671,                                   droprate =   3 }, -- Oneiros ring
            { itemid = 11672,                                   droprate =   3 }, -- Mujin band
            { itemid = 11772,                                   droprate =   3 }, -- Oneiros sash
            { itemid = 11773,                                   droprate =   3 }, -- Oneiros belt
            { itemid = 11774,                                   droprate =   3 }, -- Oneiros cest
            { itemid = 11775,                                   droprate =   3 }, -- Oneiros rope
            { itemid = 11776,                                   droprate =   3 }, -- Mujin obi
            { itemid = 11820,                                   droprate =   3 }, -- Khthonios Mask
            { itemid = 11821,                                   droprate =   3 }, -- Khthonios Helm
            { itemid = 11816,                                   droprate =   3 }, -- Oneiros helm
            { itemid = 11817,                                   droprate =   3 }, -- Oneiros barbut
            { itemid = 11818,                                   droprate =   3 }, -- Oneiros headgear
            { itemid = 11819,                                   droprate =   3 }, -- Oneiros coif 
            { itemid = 11923,                                   droprate =   3 }, -- Tjukurrpa Gauntlets
            { itemid = 11918,                                   droprate =   3 }, -- Khthonios Gloves
            { itemid = 11919,                                   droprate =   3 }, -- Avesta Bangles
            { itemid = 17069,                                   droprate =   3 }, -- Moepapa Mace
            { itemid = 17358,                                   droprate =   3 }, -- Oneiros Harp
            { itemid = 18519,                                   droprate =   3 }, -- Oneiros axe
            { itemid = 18541,                                   droprate =   3 }, -- Tjukurrpa Axe 
            { itemid = 18623,                                   droprate =   3 }, -- Chtonic Staff
            { itemid = 18811,                                   droprate =   3 }, -- Oneiros grip
            { itemid = 19141,                                   droprate =   3 }, -- Oneiros knife
            { itemid = 19295,                                   droprate =   3 }, -- Mujin tanto
            { itemid = 19738,                                   droprate =   3 }, -- Aife's Bow
            { itemid = 19762,                                   droprate =   3 }, -- Oneiros Tathlum  
            { itemid = 19763,                                   droprate =   3 }, -- Oneiros Cluster  
            { itemid = 19767,                                   droprate =   3 }, -- Oneiros pebble
            { itemid = 19790,                                   droprate =   3 }, -- Oneiros lance
            { itemid =    0,                                    droprate = 250 }, -- nothing
        },
        -- Slot 4, Materials --
        {
            { itemid = xi.item.IRON_INGOT,                      droprate =   5 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   5 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   5 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   5 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   5 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   5 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   5 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   5 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   5 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   5 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   5 },
            { itemid = xi.item.RAM_HORN,                        droprate =   5 },
            { itemid = xi.item.ELM_LOG,                         droprate =   5 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   5 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   5 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   5 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   5 },
            { itemid =  850,                                    droprate =   5 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   5 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   5 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   5 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   5 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   5 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   5 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   5 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   5 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   5 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   5 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   5 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   5 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   5 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   5 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   5 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   5 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   5 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   5 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   5 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   5 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   5 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   5 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   5 },
            { itemid = xi.item.IMP_HORN,                        droprate =   5 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   5 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   5 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   5 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   5 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   5 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   5 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   5 },
            { itemid = 1225,                                    droprate =   5 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   5 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   5 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   5 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   5 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   5 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   5 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   5 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   5 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   5 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   5 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   5 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   5 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   5 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   5 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   5 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   5 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   5 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   5 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   5 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   5 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   5 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   5 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   5 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   5 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   5 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   5 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   5 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   5 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   5 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   5 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   5 },
            { itemid = 2151,                                    droprate =   5 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   5 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   5 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   5 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   5 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   5 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   5 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   5 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   5 }, -- Water Anima
            { itemid = 1647,                                    droprate =   5 }, -- Light Anima
            { itemid = 1648,                                    droprate =   5 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   5 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   5 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   5 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   5 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   5 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   5 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   5 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   5 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   5 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   5 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   5 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   5 },
            { itemid =  734,                                    droprate =   5 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   5 }, -- Amphiptere Hide
            { itemid = 2164,                                    droprate =   5 }, -- Pephredo Hive Chip
            { itemid = 1279,                                    droprate =   5 }, -- Taffeta Cloth
            { itemid = 1280,                                    droprate =   5 }, -- Sarcenet Cloth
            { itemid = 1281,                                    droprate =   5 }, -- Cheviot Cloth
            { itemid = 1295,                                    droprate =   5 }, -- Twincoon
            { itemid = 1270,                                    droprate =   5 }, -- Arachne Web
            { itemid =  647,                                    droprate =   5 }, -- Molybdenum Ore
            { itemid = 1271,                                    droprate =   5 }, -- Pigeon's Blood Ruby
            { itemid = 1276,                                    droprate =   5 }, -- Tarasque Skin
            { itemid = 1296,                                    droprate =   5 }, -- Yowie Skin
            { itemid = 1277,                                    droprate =   5 }, -- Lindwurm Skin
            { itemid = 1765,                                    droprate =   5 }, -- Habu Skin
            { itemid = 2828,                                    droprate =   5 }, -- Herensugue Skin
            { itemid = 2837,                                    droprate =   5 }, -- Ratatoskr Pelt
            { itemid = 2839,                                    droprate =   5 }, -- Coquecigrue Skin
            { itemid = 2830,                                    droprate =   5 }, -- Bastet Fang
            { itemid = 2833,                                    droprate =   5 }, -- Thunder Coral
            { itemid = 1272,                                    droprate =   5 }, -- Arioch Fang
            { itemid = 1273,                                    droprate =   5 }, -- Namtar Bone
            { itemid = 2849,                                    droprate =   5 }, -- Likho Talon
            { itemid = 2846,                                    droprate =   5 }, -- Hefty Oak Lumber
            { itemid = 2855,                                    droprate =   5 }, -- Mahogany Heartwood
            { itemid = xi.item.CHUNK_OF_FIRE_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_ICE_ORE,                droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WIND_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_EARTH_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHTNING_ORE,          droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WATER_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHT_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_DARK_ORE,               droprate =   3 },
            { itemid = xi.item.CLUMP_OF_IMPERIAL_TEA_LEAVES,    droprate =   4 },
            { itemid = xi.item.DRAGON_FRUIT,                    droprate =   4 },
            { itemid = xi.item.WALNUT,                          droprate =   4 },
            { itemid = xi.item.BOWL_OF_AMBROSIA,                droprate =   4 },
            { itemid = xi.item.BOTTLE_OF_AMRITA,                droprate =   4 },
            { itemid = xi.item.DRAGON_HEART,                    droprate =   3 },
            { itemid = xi.item.HANDFUL_OF_DRAGON_SCALES,        droprate =   3 },
            { itemid = xi.item.SLICE_OF_DRAGON_MEAT,            droprate =   3 },
            { itemid = xi.item.CHUNK_OF_HYDRA_MEAT,             droprate =   3 },
            { itemid = xi.item.SLICE_OF_CERBERUS_MEAT,          droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HIDE,                   droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HORN,                   droprate =   3 },
            { itemid = 2158,                                    droprate =   3 }, -- Hydra Fang
            { itemid = 2172,                                    droprate =   3 }, -- Hydra Scale
            { itemid = 2168,                                    droprate =   3 }, -- Cerberus Claw
            { itemid = 2169,                                    droprate =   3 }, -- Cerberus Hide
            { itemid = 2371,                                    droprate =   3 }, -- Khimaira Horn
            { itemid = 2372,                                    droprate =   3 }, -- Khimaira Mane
            { itemid = 2373,                                    droprate =   3 }, -- Khimaira Tail
            { itemid = 4273,                                    droprate =   3 }, -- Kitron
            { itemid = 1718,                                    droprate =   3 }, -- M-bugard Tusk
            { itemid = 1719,                                    droprate =   3 }, -- Harajnite Shell
            { itemid = xi.item.SQUARE_OF_ECARLATE_CLOTH,        droprate =   3 },
            { itemid = xi.item.ARGYRO_RIVET,                    droprate =   3 },
            { itemid = xi.item.UTOPIAN_GOLD_THREAD,             droprate =   3 },
            { itemid = xi.item.ANCIENT_BRASS_INGOT,             droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BENEDICT_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_BENEDICT_YARN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_DIABOLIC_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_DIABOLIC_YARN,          droprate =   3 },
            { itemid = xi.item.SPOOL_OF_RUBY_SILK_THREAD,       droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CARDINAL_CLOTH,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SUPPLE_SKIN,           droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LIGHT_FILAMENT,         droprate =   3 },
            { itemid = xi.item.CHUNK_OF_SNOWY_CERMET,           droprate =   3 },
            { itemid = xi.item.WHITE_RIVET,                     droprate =   3 },
            { itemid = xi.item.DARK_ORICHALCUM_INGOT,           droprate =   3 },
            { itemid = xi.item.BLACK_RIVET,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SMALT_LEATHER,         droprate =   3 },
            { itemid = xi.item.FETID_LANOLIN_CUBE,              droprate =   3 },
            { itemid = xi.item.SPOOL_OF_COILED_YARN,            droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BROWN_DOESKIN,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_CHAMELEON_YARN,         droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CHARCOAL_COTTON,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SCARLET_ODOSHI,         droprate =   3 },
            { itemid = xi.item.SHEET_OF_KUROGANE,               droprate =   3 },
            { itemid = xi.item.PLAITED_CORD,                    droprate =   3 },
            { itemid = xi.item.POT_OF_EBONY_LACQUER,            droprate =   3 },
            { itemid = xi.item.SHEET_OF_COBALT_MYTHRIL,         droprate =   3 },
            { itemid = xi.item.BLUE_RIVET,                      droprate =   3 },
            { itemid = xi.item.SPOOL_OF_GLITTERING_YARN,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ASTRAL_LEATHER,        droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LUMINIAN_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_FLAMESHUN_CLOTH,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SILKWORM_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CANVAS_TOILE,          droprate =   3 },
            { itemid = xi.item.PANTIN_WIRE,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CORDUROY_CLOTH,        droprate =   3 },
            { itemid = xi.item.PIECE_OF_ANGEL_SKIN,             droprate =   3 },
            { itemid = xi.item.LOCK_OF_SIRENS_HAIR,             droprate =   3 },
            { itemid = xi.item.DIVINE_LOG,                      droprate =   3 },
            { itemid = xi.item.POT_OF_VIRIDIAN_URUSHI,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_KEJUSU_SATIN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ELTORO_LEATHER,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_GALATEIA,              droprate =   3 },
            { itemid = xi.item.DRAGON_BONE,                     droprate =   3 },
            { itemid = 1703,                                    droprate =   3 }, -- Kunwu Ore
        },
        -- Slot 8, Materials --
        {
            { itemid = xi.item.IRON_INGOT,                      droprate =   5 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   5 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   5 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   5 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   5 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   5 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   5 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   5 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   5 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   5 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   5 },
            { itemid = xi.item.RAM_HORN,                        droprate =   5 },
            { itemid = xi.item.ELM_LOG,                         droprate =   5 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   5 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   5 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   5 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   5 },
            { itemid =  850,                                    droprate =   5 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   5 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   5 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   5 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   5 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   5 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   5 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   5 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   5 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   5 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   5 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   5 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   5 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   5 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   5 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   5 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   5 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   5 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   5 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   5 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   5 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   5 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   5 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   5 },
            { itemid = xi.item.IMP_HORN,                        droprate =   5 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   5 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   5 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   5 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   5 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   5 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   5 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   5 },
            { itemid = 1225,                                    droprate =   5 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   5 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   5 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   5 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   5 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   5 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   5 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   5 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   5 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   5 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   5 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   5 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   5 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   5 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   5 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   5 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   5 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   5 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   5 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   5 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   5 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   5 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   5 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   5 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   5 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   5 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   5 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   5 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   5 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   5 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   5 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   5 },
            { itemid = 2151,                                    droprate =   5 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   5 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   5 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   5 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   5 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   5 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   5 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   5 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   5 }, -- Water Anima
            { itemid = 1647,                                    droprate =   5 }, -- Light Anima
            { itemid = 1648,                                    droprate =   5 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   5 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   5 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   5 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   5 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   5 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   5 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   5 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   5 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   5 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   5 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   5 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   5 },
            { itemid =  734,                                    droprate =   5 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   5 }, -- Amphiptere Hide
            { itemid = 2164,                                    droprate =   5 }, -- Pephredo Hive Chip
            { itemid = 1279,                                    droprate =   5 }, -- Taffeta Cloth
            { itemid = 1280,                                    droprate =   5 }, -- Sarcenet Cloth
            { itemid = 1281,                                    droprate =   5 }, -- Cheviot Cloth
            { itemid = 1295,                                    droprate =   5 }, -- Twincoon
            { itemid = 1270,                                    droprate =   5 }, -- Arachne Web
            { itemid =  647,                                    droprate =   5 }, -- Molybdenum Ore
            { itemid = 1271,                                    droprate =   5 }, -- Pigeon's Blood Ruby
            { itemid = 1276,                                    droprate =   5 }, -- Tarasque Skin
            { itemid = 1296,                                    droprate =   5 }, -- Yowie Skin
            { itemid = 1277,                                    droprate =   5 }, -- Lindwurm Skin
            { itemid = 1765,                                    droprate =   5 }, -- Habu Skin
            { itemid = 2828,                                    droprate =   5 }, -- Herensugue Skin
            { itemid = 2837,                                    droprate =   5 }, -- Ratatoskr Pelt
            { itemid = 2839,                                    droprate =   5 }, -- Coquecigrue Skin
            { itemid = 2830,                                    droprate =   5 }, -- Bastet Fang
            { itemid = 2833,                                    droprate =   5 }, -- Thunder Coral
            { itemid = 1272,                                    droprate =   5 }, -- Arioch Fang
            { itemid = 1273,                                    droprate =   5 }, -- Namtar Bone
            { itemid = 2849,                                    droprate =   5 }, -- Likho Talon
            { itemid = 2846,                                    droprate =   5 }, -- Hefty Oak Lumber
            { itemid = 2855,                                    droprate =   5 }, -- Mahogany Heartwood
            { itemid = xi.item.CHUNK_OF_FIRE_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_ICE_ORE,                droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WIND_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_EARTH_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHTNING_ORE,          droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WATER_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHT_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_DARK_ORE,               droprate =   3 },
            { itemid = xi.item.CLUMP_OF_IMPERIAL_TEA_LEAVES,    droprate =   4 },
            { itemid = xi.item.DRAGON_FRUIT,                    droprate =   4 },
            { itemid = xi.item.WALNUT,                          droprate =   4 },
            { itemid = xi.item.BOWL_OF_AMBROSIA,                droprate =   4 },
            { itemid = xi.item.BOTTLE_OF_AMRITA,                droprate =   4 },
            { itemid = xi.item.DRAGON_HEART,                    droprate =   3 },
            { itemid = xi.item.HANDFUL_OF_DRAGON_SCALES,        droprate =   3 },
            { itemid = xi.item.SLICE_OF_DRAGON_MEAT,            droprate =   3 },
            { itemid = xi.item.CHUNK_OF_HYDRA_MEAT,             droprate =   3 },
            { itemid = xi.item.SLICE_OF_CERBERUS_MEAT,          droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HIDE,                   droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HORN,                   droprate =   3 },
            { itemid = 2158,                                    droprate =   3 }, -- Hydra Fang
            { itemid = 2172,                                    droprate =   3 }, -- Hydra Scale
            { itemid = 2168,                                    droprate =   3 }, -- Cerberus Claw
            { itemid = 2169,                                    droprate =   3 }, -- Cerberus Hide
            { itemid = 2371,                                    droprate =   3 }, -- Khimaira Horn
            { itemid = 2372,                                    droprate =   3 }, -- Khimaira Mane
            { itemid = 2373,                                    droprate =   3 }, -- Khimaira Tail
            { itemid = 4273,                                    droprate =   3 }, -- Kitron
            { itemid = 1718,                                    droprate =   3 }, -- M-bugard Tusk
            { itemid = 1719,                                    droprate =   3 }, -- Harajnite Shell
            { itemid = xi.item.SQUARE_OF_ECARLATE_CLOTH,        droprate =   3 },
            { itemid = xi.item.ARGYRO_RIVET,                    droprate =   3 },
            { itemid = xi.item.UTOPIAN_GOLD_THREAD,             droprate =   3 },
            { itemid = xi.item.ANCIENT_BRASS_INGOT,             droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BENEDICT_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_BENEDICT_YARN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_DIABOLIC_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_DIABOLIC_YARN,          droprate =   3 },
            { itemid = xi.item.SPOOL_OF_RUBY_SILK_THREAD,       droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CARDINAL_CLOTH,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SUPPLE_SKIN,           droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LIGHT_FILAMENT,         droprate =   3 },
            { itemid = xi.item.CHUNK_OF_SNOWY_CERMET,           droprate =   3 },
            { itemid = xi.item.WHITE_RIVET,                     droprate =   3 },
            { itemid = xi.item.DARK_ORICHALCUM_INGOT,           droprate =   3 },
            { itemid = xi.item.BLACK_RIVET,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SMALT_LEATHER,         droprate =   3 },
            { itemid = xi.item.FETID_LANOLIN_CUBE,              droprate =   3 },
            { itemid = xi.item.SPOOL_OF_COILED_YARN,            droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BROWN_DOESKIN,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_CHAMELEON_YARN,         droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CHARCOAL_COTTON,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SCARLET_ODOSHI,         droprate =   3 },
            { itemid = xi.item.SHEET_OF_KUROGANE,               droprate =   3 },
            { itemid = xi.item.PLAITED_CORD,                    droprate =   3 },
            { itemid = xi.item.POT_OF_EBONY_LACQUER,            droprate =   3 },
            { itemid = xi.item.SHEET_OF_COBALT_MYTHRIL,         droprate =   3 },
            { itemid = xi.item.BLUE_RIVET,                      droprate =   3 },
            { itemid = xi.item.SPOOL_OF_GLITTERING_YARN,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ASTRAL_LEATHER,        droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LUMINIAN_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_FLAMESHUN_CLOTH,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SILKWORM_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CANVAS_TOILE,          droprate =   3 },
            { itemid = xi.item.PANTIN_WIRE,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CORDUROY_CLOTH,        droprate =   3 },
            { itemid = xi.item.PIECE_OF_ANGEL_SKIN,             droprate =   3 },
            { itemid = xi.item.LOCK_OF_SIRENS_HAIR,             droprate =   3 },
            { itemid = xi.item.DIVINE_LOG,                      droprate =   3 },
            { itemid = xi.item.POT_OF_VIRIDIAN_URUSHI,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_KEJUSU_SATIN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ELTORO_LEATHER,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_GALATEIA,              droprate =   3 },
            { itemid = xi.item.DRAGON_BONE,                     droprate =   3 },
            { itemid = 1703,                                    droprate =   3 }, -- Kunwu Ore
        },
        -- Slot 5, Misc/Medicine --
        {
            { itemid = xi.item.VILE_ELIXIR,                     droprate = 150 },
            { itemid = 4149,                                    droprate = 150 }, -- Panacea
            { itemid = xi.item.VILE_ELIXIR_P1,                  droprate = 140 },
            { itemid = xi.item.HI_RERAISER,                     droprate = 140 },
            { itemid = xi.item.REMEDY,                          droprate = 140 },
            { itemid = xi.item.ICARUS_WING,                     droprate = 140 },
            { itemid = xi.item.SUPER_RERAISER,                  droprate = 140 },
        },
        -- Slot 9, Misc/Medicine --
        {
            { itemid = xi.item.VILE_ELIXIR,                     droprate = 150 },
            { itemid = 4149,                                    droprate = 150 }, -- Panacea
            { itemid = xi.item.VILE_ELIXIR_P1,                  droprate = 140 },
            { itemid = xi.item.HI_RERAISER,                     droprate = 140 },
            { itemid = xi.item.REMEDY,                          droprate = 140 },
            { itemid = xi.item.ICARUS_WING,                     droprate = 140 },
            { itemid = xi.item.SUPER_RERAISER,                  droprate = 140 },
        },
    },
    [90] =
    {   -- Slot 1, Currency --
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate = 100 },
            { itemid = xi.item.LINEN_COIN_PURSE,                droprate = 100 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =  90 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =  90 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =  90 },
            { itemid =  6541,                                   droprate =  90 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  90 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  90 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  90 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  90 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter            
        },
        -- Slot 6, Currency
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate =  90 },
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  60 },
            { itemid = xi.item.LINEN_COIN_PURSE,                droprate = 100 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =  90 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =  90 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =  90 },
            { itemid =  6541,                                   droprate =  80 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  80 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  80 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  80 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  80 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter
        },
        -- Slot 10, Tatters --
        {
            { itemid =  3283,                                   droprate = 125 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate = 125 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate = 125 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate = 125 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate = 125 }, -- Martial Tatter
            { itemid =  3279,                                   droprate = 125 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate = 125 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate = 125 }, -- Wyrmal Tatter
        },
        -- Slot 2, Pop Items
        {
            { itemid = 1404,                                    droprate =  15 }, -- Genbu Seal
            { itemid = 1405,                                    droprate =  15 }, -- Seiryu Seal
            { itemid = 1406,                                    droprate =  15 }, -- Byakko Seal
            { itemid = 1407,                                    droprate =  15 }, -- Suzaku Seal
            { itemid = xi.item.IVORY_CHIP,                      droprate =  20 },
            { itemid = xi.item.SCARLET_CHIP,                    droprate =  20 },
            { itemid = xi.item.EMERALD_CHIP,                    droprate =  20 },
            { itemid = xi.item.SILVER_CHIP,                     droprate =  20 },
            { itemid = xi.item.CERULEAN_CHIP,                   droprate =  20 },
            { itemid = 1986,                                    droprate =  20 }, -- Orchid Chip
            { itemid = xi.item.SMALT_CHIP,                      droprate =  20 },
            { itemid = xi.item.SMOKY_CHIP,                      droprate =  20 },
            { itemid = 1987,                                    droprate =  20 }, -- Charcoal Chip
            { itemid = 1988,                                    droprate =  20 }, -- Magenta Chip
            { itemid = xi.item.FIRST_VIRTUE,                    droprate =  20 },
            { itemid =  1853,                                   droprate =  20 }, -- Second Virtue
            { itemid = xi.item.THIRD_VIRTUE,                    droprate =  20 },
            { itemid =  1848,                                   droprate =  20 }, -- Fourth Virtue
            { itemid =  1847,                                   droprate =  20 }, -- Fifth Virtue
            { itemid =  1849,                                   droprate =  20 }, -- Sxith Virtue
            { itemid = xi.item.HELLCAGE_BUTTERFLY,              droprate =  20 },
            { itemid = xi.item.JUG_OF_FLORAL_NECTAR,            droprate =  20 },
            { itemid = xi.item.WEDGE_OF_RODENT_CHEESE,          droprate =  20 },
            { itemid = xi.item.CLUMP_OF_SHADELEAVES,            droprate =  20 },
            { itemid = xi.item.BEAKER_OF_PECTIN,                droprate =  20 },
            { itemid = xi.item.FLASK_OF_COG_LUBRICANT,          droprate =  20 },
            { itemid = xi.item.GOLDEN_TEETH,                    droprate =  20 },
            { itemid = xi.item.GREENLING,                       droprate =  20 },
            { itemid = xi.item.BOTTLE_OF_SPOILT_BLOOD,          droprate =  20 },
            { itemid = xi.item.BUNCH_OF_SENORITA_PAMAMAS,       droprate =  20 },
            { itemid = xi.item.JAR_OF_OILY_BLOOD,               droprate =  20 },
            { itemid = xi.item.STRAND_OF_SAMARIRI_CORPSEHAIR,   droprate =  20 },
            { itemid = xi.item.SLAB_OF_RAW_BUFFALO,             droprate =  20 },
            { itemid = xi.item.LUMP_OF_BONE_CHARCOAL,           droprate =  20 },
            { itemid = xi.item.PINCH_OF_GRANULATED_SUGAR,       droprate =  20 },
            { itemid = xi.item.MINT_DROP,                       droprate =  20 },
            { itemid = xi.item.OPALUS_GEM,                      droprate =  20 },
            { itemid = xi.MERROW_NO_11_MOLTING,                 droprate =  20 },
            { itemid = xi.BAR_OF_FERRITE,                       droprate =  20 },
            { itemid = xi.BAGGED_SHEEP_BOTFLY,                  droprate =  20 },
            { itemid = xi.OLZHIRYAN_CACTUS_PADDLE,              droprate =  20 },
            { itemid = xi.VIAL_OF_PURE_BLOOD,                   droprate =  20 },
            { itemid = xi.VINEGAR_PIE,                          droprate =  20 },
            { itemid = xi.JAR_OF_ROCK_JUICE,                    droprate =  20 },
            { itemid = xi.BOUND_EXORCISM_TREATISE,              droprate =  20 },
            { itemid = xi.CLUMP_OF_MYRRH,                       droprate =  20 },
            { itemid = xi.WHOLE_ROSE_SCAMPI,                    droprate =  20 },
            { itemid = xi.JUG_OF_MONKEY_WINE,                   droprate =  20 },
            { itemid = xi.CHUNK_OF_BUFFALO_CORPSE,              droprate =  20 },
            { itemid = xi.CHUNK_OF_SINGED_BUFFALO,              droprate =  20 },
            { itemid = xi.PANDEMONIUM_KEY,                      droprate =  20 },
        },
        -- Slot 3, Equipment --
        {
            { itemid = xi.item.DUENDE_COTEHARDIE,               droprate =   4 },
            { itemid = xi.item.NOKIZARU_GI,                     droprate =   4 },
            { itemid = xi.item.RAPPAREE_HARNESS,                droprate =   4 },
            { itemid = xi.item.SHINIMUSHA_HARA_ATE,             droprate =   4 },
            { itemid = xi.item.WYVERN_MAIL,                     droprate =   4 },
            { itemid = xi.item.SHIKAREE_AKETON,                 droprate =   4 },
            { itemid = xi.item.CERISE_DOUBLET,                  droprate =   4 },
            { itemid = xi.item.GLAMOR_JUPON,                    droprate =   4 },
            { itemid = xi.item.GLOOM_BREASTPLATE,               droprate =   4 },
            { itemid = xi.item.NIMBUS_DOUBLET,                  droprate =   4 },
            { itemid = xi.item.AIKIDO_GI,                       droprate =   4 },
            { itemid = xi.item.PARADE_CUIRASS,                  droprate =   4 },
            { itemid = xi.item.GAUDY_HARNESS,                   droprate =   4 },
            { itemid = xi.item.HAMAYUMI,                        droprate =   5 },
            { itemid = xi.item.DIA_WAND,                        droprate =   4 },
            { itemid = xi.item.STONE_GORGET,                    droprate =   5 },
            { itemid =  18359,                                  droprate =   5 }, -- Boreas Cesti
            { itemid =  15468,                                  droprate =   5 }, -- Resentment Cape
            { itemid =  xi.item.GOTHIC_SABATONS,                droprate =   5 },
            { itemid =  xi.item.GOTHIC_GAUNTLETS,               droprate =   5 },
            { itemid =  16187,                                  droprate =   5 }, -- Adoubeurs Pavise
            { itemid =  16899,                                  droprate =   5 }, -- Hototogisu
            { itemid =  16374,                                  droprate =   5 }, -- Layqa Seraweels
            { itemid =  17199,                                  droprate =   5 }, -- Loxley Bow
            { itemid =  16882,                                  droprate =   5 }, -- Calamar
            { itemid =  17504,                                  droprate =   5 }, -- Pagures
            { itemid =  16884,                                  droprate =   5 }, -- Narval
            { itemid =  17503,                                  droprate =   5 }, -- Exocets
            { itemid =  19238,                                  droprate =   5 }, -- Jasper Tathlum
            { itemid =  11404,                                  droprate =   5 }, -- Promptitude Solea
            { itemid =  15897,                                  droprate =   5 }, -- Grace Corset
            { itemid =  13803,                                  droprate =   5 }, -- Shaman's Cloak
            { itemid =  19237,                                  droprate =   5 }, -- Slick Dart
            { itemid =  15942,                                  droprate =   5 }, -- Summoning Belt
            { itemid =  xi.item.MUSHROOM_HELM,                  droprate =   2 },
            { itemid =  xi.item.LUNA_SUBLIGAR,                  droprate =   2 },
            { itemid =  16980,                                  droprate =   5 }, -- Sukesada
            { itemid =  13912,                                  droprate =   5 }, -- Shadow Mask
            { itemid =  16943,                                  droprate =   5 }, -- Ascalon
            { itemid =  14063,                                  droprate =   5 }, -- Protecting Bangles
            { itemid =  14064,                                  droprate =   5 }, -- Sand Gloves
            { itemid =  17651,                                  droprate =   5 }, -- Dainslaif
            { itemid =  17924,                                  droprate =   5 }, -- Tungi
            { itemid =  16734,                                  droprate =   5 }, -- Pendragon Axe
            { itemid =  15995,                                  droprate =   5 }, -- Carline Earring
            { itemid =  16127,                                  droprate =   5 }, -- Carline Ribbon
            { itemid =  16125,                                  droprate =   5 }, -- Breeder Mask
            { itemid =  15001,                                  droprate =   5 }, -- Breeder Mufflers
            { itemid =  15946,                                  droprate =   5 }, -- Tempest Belt
            { itemid =  11405,                                  droprate =   5 }, -- Kyoshu Kyahan
            { itemid =  11533,                                  droprate =   5 }, -- Lyricist's Gonnelle
            { itemid =  16298,                                  droprate =   5 }, -- Knack Pendant
            { itemid =  17454,                                  droprate =   5 }, -- Asklepios
            { itemid =  17455,                                  droprate =   5 }, -- Skirnir's Wand
            { itemid =  16912,                                  droprate =   5 }, -- Kitsutsuki
            { itemid =  17926,                                  droprate =   5 }, -- Acha D'Armas
            { itemid =  17982,                                  droprate =   5 }, -- Kard
            { itemid =  17983,                                  droprate =   5 }, -- Valiant Knife
            { itemid =  18042,                                  droprate =   5 }, -- Ascention
            { itemid =  17563,                                  droprate =   5 }, -- Power Staff
            { itemid =  17969,                                  droprate =   5 }, -- Fendoir
            { itemid =  18608,                                  droprate =   5 }, -- Atesh Pole
            { itemid =  16727,                                  droprate =   5 }, -- Eisentaenzer
            { itemid =  17971,                                  droprate =   5 }, -- Tartaglia
            { itemid =  19235,                                  droprate =   5 }, -- Veuglaire
            { itemid =  16375,                                  droprate =   5 }, -- Surge Subligar
            { itemid =  xi.item.ASTRAL_ASPIS,                   droprate =   5 },
            { itemid =  xi.item.GAE_BOLG,                       droprate =   5 },
            { itemid =  xi.item.LOHAR,                          droprate =   5 },
            { itemid =   19122,                                 droprate =   5 }, -- Courser's Pugio
            { itemid =   16081,                                 droprate =   5 }, -- Curate's Hat
            { itemid =   15882,                                 droprate =   5 }, -- Othinus' Bow
            { itemid =   17244,                                 droprate =   5 }, -- Storm Belt
            { itemid =   14806,                                 droprate =   5 }, -- Intruder Earring
            { itemid =   14466,                                 droprate =   5 }, -- Fomor Tunic
            { itemid =   18007,                                 droprate =   5 }, -- Chiroptera Dagger
            { itemid =   17510,                                 droprate =   5 }, -- Vampiric Claws
            { itemid =   14763,                                 droprate =   5 }, -- Boroka Earring
            { itemid =   13178,                                 droprate =   5 }, -- Auditory Torque
            { itemid =   15943,                                 droprate =   5 }, -- Virtuoso Belt
            { itemid =   14884,                                 droprate =   5 }, -- Mycophile Cuffs
            { itemid =   17794,                                 droprate =   5 }, -- Niokiyotsuna
            { itemid =   15219,                                 droprate =   5 }, -- Sinister Mask
            { itemid =   16368,                                 droprate =   5 }, -- Herder's Subligar
            { itemid =   14724,                                 droprate =   5 }, -- Moldavite Earring
            { itemid =   16279,                                 droprate =   5 }, -- Pile Chain
            { itemid =   15546,                                 droprate =   5 }, -- Fasting Ring
            { itemid =   16299,                                 droprate =   5 }, -- Lleu's Charm
            { itemid =   11496,                                 droprate =   5 }, -- Fenrir's Crown
            { itemid =   14168,                                 droprate =   5 }, -- Dune Boots
            { itemid =   17854,                                 droprate =   5 }, -- Cradle Horn
            { itemid =   19239,                                 droprate =   5 }, -- Astrolable
            { itemid =   16169,                                 droprate =   5 }, -- Caballero Shield
            { itemid =   17653,                                 droprate =   5 }, -- Hrotti
            { itemid =   18027,                                 droprate =   5 }, -- Palladium Dagger
            { itemid =   17564,                                 droprate =   5 }, -- Cocytus Pole
            { itemid =   16426,                                 droprate =   5 }, -- Avengers
            { itemid =   19121,                                 droprate =   5 }, -- Sleight Kukri
            { itemid =   15944,                                 droprate =   7 }, -- Selemnus Belt
            { itemid =   16297,                                 droprate =   7 }, -- Shepherd's Chain
            { itemid =  xi.item.KAMEWARI,                       droprate =   5 },
            { itemid =  xi.item.NADRS,                          droprate =   5 },
            { itemid =  xi.item.ALTDORFS_EARRING,               droprate =   5 },
            { itemid =  xi.item.WILHELMS_EARRING,               droprate =   5 },
            { itemid =  xi.item.HELENUSS_EARRING,               droprate =   5 },
            { itemid =  xi.item.CASSANDRAS_EARRING,             droprate =   5 },
            { itemid =  xi.item.MINSTRELS_DAGGER,               droprate =   5 },
            { itemid =  xi.item.SAND_CHARM,                     droprate =   5 },
            { itemid =   15692,                                 droprate =   5 }, -- Storm Crackows
            { itemid =   14669,                                 droprate =   5 }, -- Jaeger Ring
            { itemid =   15351,                                 droprate =   5 }, -- Bounding Boots
            { itemid =   18018,                                 droprate =   5 }, -- Sirocco Kukri
            { itemid =   13567,                                 droprate =   5 }, -- Bomb Queen Ring
            { itemid =   15547,                                 droprate =   5 }, -- Vilma's Ring
            { itemid =   26164,                                 droprate =   5 }, -- Caliber Ring
            { itemid =   15183,                                 droprate =   7 }, -- Dobson Bandana
            { itemid =   15184,                                 droprate =   7 }, -- Voyager Sallet
            { itemid =   14986,                                 droprate =   7 }, -- Ochimusha Kote
            { itemid =   15737,                                 droprate =   7 }, -- Sarutobi Kyahan
            { itemid =   15551,                                 droprate =   7 }, -- Shikaree Ring
            { itemid =  xi.item.EMPRESS_HAIRPIN,                droprate =   7 },
            { itemid =  xi.item.JOYEUSE,                        droprate =   7 },
            { itemid =  xi.item.DRYAD_STAFF,                    droprate =   7 },
            { itemid =  xi.item.VALIS_BOW,                      droprate =   7 },
            { itemid =  xi.item.RETALIATORS,                    droprate =   7 },
            { itemid =  xi.item.UNGUR_BOOMERANG,                droprate =   7 },
            { itemid =   15515,                                 droprate =   7 }, -- Peacock Amulet
            { itemid =  xi.item.TROTTER_BOOTS,                  droprate =   7 },
            { itemid =   19236,                                 droprate =   7 }, -- Hightail Bullet
            { itemid =   17192,                                 droprate =   7 }, -- Ifrit's Bow
            { itemid =   17711,                                 droprate =   7 }, -- Shiva's Shotel
            { itemid =   18021,                                 droprate =   7 }, -- Titan's Baselarde
            { itemid =   18063,                                 droprate =   7 }, -- Garuda's Sickle
            { itemid =   18109,                                 droprate =   7 }, -- Leviathan's Couse
            { itemid =   18404,                                 droprate =   7 }, -- Ramuh's Mace
            { itemid =   18581,                                 droprate =   7 }, -- Carbuncle's Pole
            { itemid =   14931,                                 droprate =   7 }, -- Carbuncle's Cuffs
            { itemid =   18422,                                 droprate =   7 }, -- Ryumon
            { itemid =   14960,                                 droprate =   7 }, -- Evoker's Gages
            { itemid =   19277,                                 droprate =   7 }, -- Tsugumi
            { itemid =   11408,                                 droprate =   7 }, -- Morana Pigaches
            { itemid =   11409,                                 droprate =   7 }, -- Aoide's Pumps
            { itemid =   16238,                                 droprate =   7 }, -- Taster's Cape
            { itemid =   11497,                                 droprate =   7 }, -- Spurrer Beret
            { itemid =   11406,                                 droprate =   7 }, -- Stimulus Sabots
            { itemid =   18767,                                 droprate =   6 }, -- Birdbanes
            { itemid =   15854,                                 droprate =   7 }, -- Sortie Ring
            { itemid =   15915,                                 droprate =   7 }, -- Sothic Rope
            { itemid =   11342,                                 droprate =   6 }, -- Restorer Cloak
            { itemid =   18770,                                 droprate =   7 }, -- Pygme Sainti
            { itemid =   17737,                                 droprate =   6 }, -- Corsair's Scimitar
            { itemid =   19124,                                 droprate =   7 }, -- Creve-coeur
            { itemid =   19279,                                 droprate =   7 }, -- Musanto
            { itemid =   17766,                                 droprate =   7 }, -- Lyft Scimitar
            { itemid =   17970,                                 droprate =   7 }, -- Lyft Tabar
            { itemid =   18508,                                 droprate =   7 }, -- Lyft Voulge
            { itemid =   18609,                                 droprate =   7 }, -- Lyft Pole
            { itemid =   18771,                                 droprate =   7 }, -- Lyft Sainti
            { itemid =   18872,                                 droprate =   7 }, -- Lyft Ferule
            { itemid =   18958,                                 droprate =   7 }, -- Lyft Scythe
            { itemid =   19125,                                 droprate =   7 }, -- Lyft Jambiya
            { itemid =   19161,                                 droprate =   7 }, -- Lyft Claymore
            { itemid =   19233,                                 droprate =   7 }, -- Lyft Crossbow
            { itemid =   19306,                                 droprate =   7 }, -- Lyft Lance
            { itemid =  xi.item.LAVAS_RING,                     droprate =   7 },
            { itemid =  xi.item.KUSHAS_RING,                    droprate =   7 },
            { itemid =  xi.item.NASATYAS_RING,                  droprate =   7 },
            { itemid =  xi.item.DASRAS_RING,                    droprate =   7 },
            { itemid =  xi.item.HOPE_STAFF,                     droprate =   7 },
            { itemid =  xi.item.JUSTICE_SWORD,                  droprate =   7 },
            { itemid =  xi.item.TEMPERANCE_AXE,                 droprate =   7 },
            { itemid =  xi.item.LOVE_HALBERD,                   droprate =   7 },
            { itemid =  xi.item.FORTITUDE_AXE,                  droprate =   7 },
            { itemid =  xi.item.FAITH_BAGHNAKHS,                droprate =   7 },
            { itemid =  xi.item.PRUDENCE_ROD,                   droprate =   7 },
            { itemid =  xi.item.BYAKKOS_AXE,                    droprate =   8 },
            { itemid =  xi.item.SUZAKUS_SCYTHE,                 droprate =   8 },
            { itemid =  xi.item.SEIRYUS_SWORD,                  droprate =   8 },
        },
        -- Slot 7, Equipment --
        {
            { itemid =  5681,                                   droprate =   4 }, -- Cupid Chocolate
            { itemid = xi.item.GENBUS_KABUTO,                   droprate =   6 },
            { itemid = xi.item.GENBUS_SHIELD,                   droprate =   6 },
            { itemid = xi.item.SEIRYUS_KOTE,                    droprate =   6 },
            { itemid = xi.item.SUZAKUS_SUNE_ATE,                droprate =   6 },
            { itemid = xi.item.BYAKKOS_HAIDATE,                 droprate =   6 },
            { itemid = xi.item.ANIMATOR_P1,                     droprate =   5 },
            { itemid = 17567,                                   droprate =   5 }, -- Kirin's Pole
            { itemid = 12562,                                   droprate =   5 }, -- Kirin's Osode
            { itemid = 16034,                                   droprate =   5 }, -- Sarabande Earring
            { itemid = 13415,                                   droprate =   5 }, -- Pixie Earring
            { itemid = 16300,                                   droprate =   5 }, -- Wit Pendant
            { itemid = 16303,                                   droprate =   5 }, -- Laran's Pendant
            { itemid = 15057,                                   droprate =   5 }, -- Bricta's Cuffs
            { itemid = 14943,                                   droprate =   5 }, -- Barbarossa's Moufles
            { itemid = 16376,                                   droprate =   5 }, -- Bahram Cuisses
            { itemid = 16302,                                   droprate =   5 }, -- Bloodbead Gorget
            { itemid = 11411,                                   droprate =   5 }, -- Shrewd Pumps
            { itemid = 15223,                                   droprate =   5 }, -- Ace's Helm
            { itemid = 18002,                                   droprate =   5 }, -- Perseu's Harp
            { itemid = 14873,                                   droprate =   5 }, -- Bandomusha Kote
            { itemid = 19280,                                   droprate =   5 }, -- Narigitsune
            { itemid = xi.item.WYRM_BEARD,                      droprate =   5 },
            { itemid = xi.item.BEHEMOTH_TONGUE,                 droprate =   5 },
            { itemid = xi.item.ADAMANTOISE_EGG,                 droprate =   5 },
            { itemid = xi.item.SEVENEYES,                       droprate =   5 },
            { itemid = xi.item.ALGOL,                           droprate =   5 },
            { itemid = 13658,                                   droprate =   5 }, -- Shadow Mantle
            { itemid = 14646,                                   droprate =   5 }, -- Shadow Ring
            { itemid = 11589,                                   droprate =   5 }, -- Aesir Torque
            { itemid = 16057,                                   droprate =   5 }, -- Aesir Ear Pendant
            { itemid = 11546,                                   droprate =   5 }, -- Aesir Mantle
            { itemid = 11547,                                   droprate =   5 }, -- Colossus's Mantle
            { itemid = 11590,                                   droprate =   5 }, -- Colossus's Torque
            { itemid = 16058,                                   droprate =   5 }, -- Colossus's Earring
            { itemid = 18019,                                   droprate =   5 }, -- X's Knife
            { itemid = 18057,                                   droprate =   5 }, -- Y's Scythe
            { itemid = 18101,                                   droprate =   5 }, -- Z's Trident
            { itemid = 15899,                                   droprate =   5 }, -- Velocious Belt
            { itemid = 15617,                                   droprate =   5 }, -- Barbarossa's Zerehs
            { itemid = 17586,                                   droprate =   5 }, -- Mercurial Pole
            { itemid = xi.item.JUSTICE_TORQUE,                  droprate =   5 },
            { itemid = xi.item.HOPE_TORQUE,                     droprate =   5 },
            { itemid = xi.item.PRUDENCE_TORQUE,                 droprate =   5 },
            { itemid = xi.item.FORTITUDE_TORQUE,                droprate =   5 },
            { itemid = xi.item.FAITH_TORQUE,                    droprate =   5 },
            { itemid = xi.item.TEMPERANCE_TORQUE,               droprate =   5 },
            { itemid = xi.item.LOVE_TORQUE,                     droprate =   5 },
            { itemid = xi.item.RIDILL,                          droprate =   5 },
            { itemid = xi.item.OCTAVE_CLUB,                     droprate =   5 },
            { itemid = xi.item.HAUTECLAIRE,                     droprate =   5 },
            { itemid = 13566,                                   droprate =   3 }, -- Defending Ring
            { itemid = 27456,                                   droprate =   3 }, -- Crier's Gaiters
            { itemid = 14468,                                   droprate =   3 }, -- Yinyang Robe
            { itemid = 17754,                                   droprate =   5 }, -- Sylphid Epee
            { itemid = 16154,                                   droprate =   5 }, -- Karura Hachigane
            { itemid = 16000,                                   droprate =   5 }, -- Dragoon's Earring
            { itemid = 16240,                                   droprate =   5 }, -- Erato's Cape
            { itemid = 17755,                                   droprate =   5 }, -- Beast Slayer
            { itemid = 16340,                                   droprate =   5 }, -- Armadillo Cuisses
            { itemid = 17961,                                   droprate =   5 }, -- Lion Tamer
            { itemid = 15018,                                   droprate =   5 }, -- Ritterhentzes
            { itemid = 18859,                                   droprate =   5 }, -- Kerykeion
            { itemid = 16274,                                   droprate =   5 }, -- Almah Torque
            { itemid = 15999,                                   droprate =   5 }, -- Guignol Earring
            { itemid = 15916,                                   droprate =   5 }, -- Corsair's Belt
            { itemid = 18950,                                   droprate =   5 }, -- White Joker
            { itemid = 11369,                                   droprate =   5 }, -- Numerist Pumps
            { itemid = 11368,                                   droprate =   5 }, -- Hakke Habaki
            { itemid = 15827,                                   droprate =   5 }, -- Insect Ring
            { itemid = 15828,                                   droprate =   5 }, -- Blood Ring
            { itemid = 19154,                                   droprate =   5 }, -- Ferrara
            { itemid = 11366,                                   droprate =   5 }, -- Avocat Pigaches
            { itemid = 15017,                                   droprate =   5 }, -- Toad Mittens
            { itemid = 16339,                                   droprate =   5 }, -- Paddock Trousers
            { itemid = 16153,                                   droprate =   5 }, -- Reikyo Hairpin
            { itemid = 11367,                                   droprate =   5 }, -- Nobushi Kyahan
            { itemid = 19109,                                   droprate =   5 }, -- Trilling Dagger
            { itemid = 18448,                                   droprate =   5 }, -- Hacchonenbutsu
            { itemid = 19211,                                   droprate =   5 }, -- Reacton Arm
            { itemid = 19028,                                   droprate =   5 }, -- Magic Strap
            { itemid = 18127,                                   droprate =   5 }, -- Achilles' Spear
            { itemid = 16338,                                   droprate =   5 }, -- Ruby Seraweels
            { itemid = 18949,                                   droprate =   5 }, -- Zareehkl Scythe
            { itemid = 19108,                                   droprate =   5 }, -- Zareehkl Jambiya
            { itemid = 16239,                                   droprate =   5 }, -- Solitaire Cape
            { itemid = 16175,                                   droprate =   5 }, -- Muse Tariqah
            { itemid = 16152,                                   droprate =   5 }, -- Hissho Hachimaki
            { itemid = 16174,                                   droprate =   5 }, -- Riot Shield
            { itemid = 18126,                                   droprate =   4 }, -- Tomoe
            { itemid = xi.item.ORACLES_GLOVES,                  droprate =   4 },
            { itemid = xi.item.AURUM_SABATONS,                  droprate =   4 },
            { itemid = 19031,                                   droprate =   4 }, -- Fire Grip
            { itemid = 19032,                                   droprate =   4 }, -- Water Grip
            { itemid = 19033,                                   droprate =   4 }, -- Wind Grip
            { itemid = 19034,                                   droprate =   4 }, -- Ice Grip
            { itemid = 19035,                                   droprate =   4 }, -- Thunder Grip
            { itemid = 19036,                                   droprate =   4 }, -- Earth Grip
            { itemid = 19037,                                   droprate =   4 }, -- Light Grip
            { itemid = 19038,                                   droprate =   4 }, -- Dark Grip
            { itemid = xi.item.ENKIDUS_MITTENS,                 droprate =   4 },
            { itemid = xi.item.AURUM_CUISSES,                   droprate =   4 },
            { itemid = 19153,                                   droprate =   4 }, -- Naglering
            { itemid = 18125,                                   droprate =   4 }, -- Cletine
            { itemid = xi.item.ENKIDUS_SUBLIGAR,                droprate =   4 },
            { itemid = xi.item.ORACLES_PIGACHES,                droprate =   4 },
            { itemid = 17960,                                   droprate =   4 }, -- Labrys
            { itemid = xi.item.ENKIDUS_LEGGINGS,                droprate =   4 },
            { itemid = xi.item.AURUM_GAUNTLETS,                 droprate =   4 },
            { itemid = 16176,                                   droprate =   4 }, -- Simba Buckler
            { itemid = 17753,                                   droprate =   4 }, -- Organics
            { itemid = xi.item.ORACLES_BRACONI,                 droprate =   4 },
            { itemid = 16177,                                   droprate =   4 }, -- Legion Scutum
            { itemid = 18595,                                   droprate =   4 }, -- Mekki Shakki
            { itemid = 18430,                                   droprate =   4 }, -- Oninohocho
            { itemid = 18593,                                   droprate =   2 }, -- Alkalurops
            { itemid = xi.item.ENKIDUS_CAP,                     droprate =   3 },
            { itemid = xi.item.ENKIDUS_HARNESS,                 droprate =   3 },
            { itemid = xi.item.HACHIRYU_SUNE_ATE,               droprate =   3 },
            { itemid = xi.item.ORACLES_CAP,                     droprate =   3 },
            { itemid = 18429,                                   droprate =   3 }, -- Shusui
            { itemid = xi.item.AURUM_ARMET,                     droprate =   3 },
            { itemid = 18497,                                   droprate =   3 }, -- Foolkiller
            { itemid = xi.item.HACHIRYU_HAIDATE,                droprate =   3 },
            { itemid = xi.item.ORACLES_ROBE,                    droprate =   3 },
            { itemid = 18446,                                   droprate =   3 }, -- Pachipachio
            { itemid = 18857,                                   droprate =   3 }, -- Antares
            { itemid = xi.item.AURUM_CUIRASS,                   droprate =   3 },
            { itemid = xi.item.HACHIRYU_KOTE,                   droprate =   3 },
            { itemid = xi.item.HACHIRYU_HARAMAKI,               droprate =   2 },
            { itemid = 10754,                                   droprate =   3 }, -- Moepapa Ring
            { itemid = 10755,                                   droprate =   3 }, -- Moepapa Annulet
            { itemid = 10756,                                   droprate =   3 }, -- Tjukurrpa Ring
            { itemid = 10757,                                   droprate =   3 }, -- Tjukurrpa Annulet
            { itemid = 10759,                                   droprate =   3 }, -- Aife's Annulet
            { itemid = 10817,                                   droprate =   3 }, -- Moepapa Stone
            { itemid = 10818,                                   droprate =   3 }, -- Tjukurrpa Belt
            { itemid = 10932,                                   droprate =   3 }, -- Oneiros torque
            { itemid = 10933,                                   droprate =   3 }, -- Mujin necklace
            { itemid = 10940,                                   droprate =   3 }, -- Moepapa Pendant
            { itemid = 10941,                                   droprate =   3 }, -- Tjukurrpa Medal
            { itemid = 10942,                                   droprate =   3 }, -- Aife's Medal
            { itemid = 10943,                                   droprate =   3 }, -- Moepapa Medal
            { itemid = 10972,                                   droprate =   3 }, -- Oneiros cappa
            { itemid = 10973,                                   droprate =   3 }, -- Oneiros cape
            { itemid = 10974,                                   droprate =   3 }, -- Mujin mantle
            { itemid = 10983,                                   droprate =   3 }, -- Aife's Mantle
            { itemid = 10984,                                   droprate =   3 }, -- Tjukurrpa Mantle
            { itemid = 11030,                                   droprate =   3 }, -- Oneiros earring
            { itemid = 11032,                                   droprate =   3 }, -- Mujin Stud
            { itemid = 11031,                                   droprate =   3 }, -- Oneiros pearl
            { itemid = 11456,                                   droprate =   3 }, -- Ryuga Sune-Ate
            { itemid = 11461,                                   droprate =   3 }, -- Aife's Pumps
            { itemid = 11670,                                   droprate =   3 }, -- Oneiros annulet
            { itemid = 11671,                                   droprate =   3 }, -- Oneiros ring
            { itemid = 11672,                                   droprate =   3 }, -- Mujin band
            { itemid = 11772,                                   droprate =   3 }, -- Oneiros sash
            { itemid = 11773,                                   droprate =   3 }, -- Oneiros belt
            { itemid = 11774,                                   droprate =   3 }, -- Oneiros cest
            { itemid = 11775,                                   droprate =   3 }, -- Oneiros rope
            { itemid = 11776,                                   droprate =   3 }, -- Mujin obi
            { itemid = 11820,                                   droprate =   3 }, -- Khthonios Mask
            { itemid = 11821,                                   droprate =   3 }, -- Khthonios Helm
            { itemid = 11816,                                   droprate =   3 }, -- Oneiros helm
            { itemid = 11817,                                   droprate =   3 }, -- Oneiros barbut
            { itemid = 11818,                                   droprate =   3 }, -- Oneiros headgear
            { itemid = 11819,                                   droprate =   3 }, -- Oneiros coif 
            { itemid = 11923,                                   droprate =   3 }, -- Tjukurrpa Gauntlets
            { itemid = 11918,                                   droprate =   3 }, -- Khthonios Gloves
            { itemid = 11919,                                   droprate =   3 }, -- Avesta Bangles
            { itemid = 17069,                                   droprate =   3 }, -- Moepapa Mace
            { itemid = 17358,                                   droprate =   3 }, -- Oneiros Harp
            { itemid = 18519,                                   droprate =   3 }, -- Oneiros axe
            { itemid = 18541,                                   droprate =   3 }, -- Tjukurrpa Axe 
            { itemid = 18623,                                   droprate =   3 }, -- Chtonic Staff
            { itemid = 18811,                                   droprate =   3 }, -- Oneiros grip
            { itemid = 19141,                                   droprate =   3 }, -- Oneiros knife
            { itemid = 19295,                                   droprate =   3 }, -- Mujin tanto
            { itemid = 19738,                                   droprate =   3 }, -- Aife's Bow
            { itemid = 19762,                                   droprate =   3 }, -- Oneiros Tathlum  
            { itemid = 19763,                                   droprate =   3 }, -- Oneiros Cluster  
            { itemid = 19767,                                   droprate =   3 }, -- Oneiros pebble
            { itemid = 19790,                                   droprate =   3 }, -- Oneiros lance
            { itemid = xi.item.MURREY_GRISAILLE,                droprate =   1 },
            { itemid =    0,                                    droprate = 250 }, -- nothing
        },
        -- Slot 4, Materials --
        {
            { itemid = xi.item.IRON_INGOT,                      droprate =   5 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   5 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   5 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   5 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   5 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   5 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   5 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   5 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   5 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   5 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   5 },
            { itemid = xi.item.RAM_HORN,                        droprate =   5 },
            { itemid = xi.item.ELM_LOG,                         droprate =   5 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   5 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   5 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   5 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   5 },
            { itemid =  850,                                    droprate =   5 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   5 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   5 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   5 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   5 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   5 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   5 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   5 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   5 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   5 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   5 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   5 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   5 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   5 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   5 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   5 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   5 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   5 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   5 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   5 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   5 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   5 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   5 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   5 },
            { itemid = xi.item.IMP_HORN,                        droprate =   5 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   5 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   5 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   5 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   5 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   5 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   5 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   5 },
            { itemid = 1225,                                    droprate =   5 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   5 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   5 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   5 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   5 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   5 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   5 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   5 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   5 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   5 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   5 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   5 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   5 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   5 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   5 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   5 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   5 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   5 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   5 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   5 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   5 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   5 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   5 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   5 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   5 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   5 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   5 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   5 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   5 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   5 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   5 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   5 },
            { itemid = 2151,                                    droprate =   5 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   5 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   5 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   5 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   5 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   5 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   5 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   5 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   5 }, -- Water Anima
            { itemid = 1647,                                    droprate =   5 }, -- Light Anima
            { itemid = 1648,                                    droprate =   5 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   5 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   5 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   5 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   5 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   5 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   5 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   5 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   5 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   5 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   5 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   5 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   5 },
            { itemid =  734,                                    droprate =   5 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   5 }, -- Amphiptere Hide
            { itemid = 2164,                                    droprate =   5 }, -- Pephredo Hive Chip
            { itemid = 1279,                                    droprate =   5 }, -- Taffeta Cloth
            { itemid = 1280,                                    droprate =   5 }, -- Sarcenet Cloth
            { itemid = 1281,                                    droprate =   5 }, -- Cheviot Cloth
            { itemid = 1295,                                    droprate =   5 }, -- Twincoon
            { itemid = 1270,                                    droprate =   5 }, -- Arachne Web
            { itemid =  647,                                    droprate =   5 }, -- Molybdenum Ore
            { itemid = 1271,                                    droprate =   5 }, -- Pigeon's Blood Ruby
            { itemid = 1276,                                    droprate =   5 }, -- Tarasque Skin
            { itemid = 1296,                                    droprate =   5 }, -- Yowie Skin
            { itemid = 1277,                                    droprate =   5 }, -- Lindwurm Skin
            { itemid = 1765,                                    droprate =   5 }, -- Habu Skin
            { itemid = 2828,                                    droprate =   5 }, -- Herensugue Skin
            { itemid = 2837,                                    droprate =   5 }, -- Ratatoskr Pelt
            { itemid = 2839,                                    droprate =   5 }, -- Coquecigrue Skin
            { itemid = 2830,                                    droprate =   5 }, -- Bastet Fang
            { itemid = 2833,                                    droprate =   5 }, -- Thunder Coral
            { itemid = 1272,                                    droprate =   5 }, -- Arioch Fang
            { itemid = 1273,                                    droprate =   5 }, -- Namtar Bone
            { itemid = 2849,                                    droprate =   5 }, -- Likho Talon
            { itemid = 2846,                                    droprate =   5 }, -- Hefty Oak Lumber
            { itemid = 2855,                                    droprate =   5 }, -- Mahogany Heartwood
            { itemid = xi.item.CHUNK_OF_FIRE_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_ICE_ORE,                droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WIND_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_EARTH_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHTNING_ORE,          droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WATER_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHT_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_DARK_ORE,               droprate =   3 },
            { itemid = xi.item.CLUMP_OF_IMPERIAL_TEA_LEAVES,    droprate =   4 },
            { itemid = xi.item.DRAGON_FRUIT,                    droprate =   4 },
            { itemid = xi.item.WALNUT,                          droprate =   4 },
            { itemid = xi.item.BOWL_OF_AMBROSIA,                droprate =   4 },
            { itemid = xi.item.BOTTLE_OF_AMRITA,                droprate =   4 },
            { itemid = xi.item.DRAGON_HEART,                    droprate =   3 },
            { itemid = xi.item.HANDFUL_OF_DRAGON_SCALES,        droprate =   3 },
            { itemid = xi.item.SLICE_OF_DRAGON_MEAT,            droprate =   3 },
            { itemid = xi.item.CHUNK_OF_HYDRA_MEAT,             droprate =   3 },
            { itemid = xi.item.SLICE_OF_CERBERUS_MEAT,          droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HIDE,                   droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HORN,                   droprate =   3 },
            { itemid = 2158,                                    droprate =   3 }, -- Hydra Fang
            { itemid = 2172,                                    droprate =   3 }, -- Hydra Scale
            { itemid = 2168,                                    droprate =   3 }, -- Cerberus Claw
            { itemid = 2169,                                    droprate =   3 }, -- Cerberus Hide
            { itemid = 2371,                                    droprate =   3 }, -- Khimaira Horn
            { itemid = 2372,                                    droprate =   3 }, -- Khimaira Mane
            { itemid = 2373,                                    droprate =   3 }, -- Khimaira Tail
            { itemid = 4273,                                    droprate =   3 }, -- Kitron
            { itemid = 1718,                                    droprate =   3 }, -- M-bugard Tusk
            { itemid = 1719,                                    droprate =   3 }, -- Harajnite Shell
            { itemid = xi.item.SQUARE_OF_ECARLATE_CLOTH,        droprate =   3 },
            { itemid = xi.item.ARGYRO_RIVET,                    droprate =   3 },
            { itemid = xi.item.UTOPIAN_GOLD_THREAD,             droprate =   3 },
            { itemid = xi.item.ANCIENT_BRASS_INGOT,             droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BENEDICT_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_BENEDICT_YARN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_DIABOLIC_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_DIABOLIC_YARN,          droprate =   3 },
            { itemid = xi.item.SPOOL_OF_RUBY_SILK_THREAD,       droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CARDINAL_CLOTH,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SUPPLE_SKIN,           droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LIGHT_FILAMENT,         droprate =   3 },
            { itemid = xi.item.CHUNK_OF_SNOWY_CERMET,           droprate =   3 },
            { itemid = xi.item.WHITE_RIVET,                     droprate =   3 },
            { itemid = xi.item.DARK_ORICHALCUM_INGOT,           droprate =   3 },
            { itemid = xi.item.BLACK_RIVET,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SMALT_LEATHER,         droprate =   3 },
            { itemid = xi.item.FETID_LANOLIN_CUBE,              droprate =   3 },
            { itemid = xi.item.SPOOL_OF_COILED_YARN,            droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BROWN_DOESKIN,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_CHAMELEON_YARN,         droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CHARCOAL_COTTON,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SCARLET_ODOSHI,         droprate =   3 },
            { itemid = xi.item.SHEET_OF_KUROGANE,               droprate =   3 },
            { itemid = xi.item.PLAITED_CORD,                    droprate =   3 },
            { itemid = xi.item.POT_OF_EBONY_LACQUER,            droprate =   3 },
            { itemid = xi.item.SHEET_OF_COBALT_MYTHRIL,         droprate =   3 },
            { itemid = xi.item.BLUE_RIVET,                      droprate =   3 },
            { itemid = xi.item.SPOOL_OF_GLITTERING_YARN,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ASTRAL_LEATHER,        droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LUMINIAN_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_FLAMESHUN_CLOTH,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SILKWORM_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CANVAS_TOILE,          droprate =   3 },
            { itemid = xi.item.PANTIN_WIRE,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CORDUROY_CLOTH,        droprate =   3 },
            { itemid = xi.item.PIECE_OF_ANGEL_SKIN,             droprate =   3 },
            { itemid = xi.item.LOCK_OF_SIRENS_HAIR,             droprate =   3 },
            { itemid = xi.item.DIVINE_LOG,                      droprate =   3 },
            { itemid = xi.item.POT_OF_VIRIDIAN_URUSHI,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_KEJUSU_SATIN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ELTORO_LEATHER,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_GALATEIA,              droprate =   3 },
            { itemid = xi.item.DRAGON_BONE,                     droprate =   3 },
            { itemid = 1703,                                    droprate =   3 }, -- Kunwu Ore
        },
        -- Slot 8, Materials --
        {
            { itemid = xi.item.IRON_INGOT,                      droprate =   5 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   5 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   5 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   5 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   5 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   5 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   5 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   5 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   5 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   5 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   5 },
            { itemid = xi.item.RAM_HORN,                        droprate =   5 },
            { itemid = xi.item.ELM_LOG,                         droprate =   5 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   5 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   5 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   5 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   5 },
            { itemid =  850,                                    droprate =   5 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   5 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   5 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   5 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   5 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   5 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   5 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   5 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   5 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   5 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   5 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   5 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   5 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   5 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   5 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   5 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   5 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   5 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   5 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   5 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   5 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   5 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   5 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   5 },
            { itemid = xi.item.IMP_HORN,                        droprate =   5 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   5 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   5 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   5 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   5 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   5 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   5 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   5 },
            { itemid = 1225,                                    droprate =   5 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   5 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   5 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   5 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   5 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   5 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   5 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   5 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   5 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   5 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   5 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   5 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   5 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   5 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   5 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   5 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   5 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   5 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   5 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   5 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   5 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   5 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   5 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   5 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   5 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   5 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   5 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   5 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   5 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   5 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   5 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   5 },
            { itemid = 2151,                                    droprate =   5 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   5 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   5 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   5 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   5 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   5 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   5 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   5 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   5 }, -- Water Anima
            { itemid = 1647,                                    droprate =   5 }, -- Light Anima
            { itemid = 1648,                                    droprate =   5 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   5 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   5 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   5 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   5 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   5 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   5 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   5 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   5 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   5 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   5 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   5 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   5 },
            { itemid =  734,                                    droprate =   5 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   5 }, -- Amphiptere Hide
            { itemid = 2164,                                    droprate =   5 }, -- Pephredo Hive Chip
            { itemid = 1279,                                    droprate =   5 }, -- Taffeta Cloth
            { itemid = 1280,                                    droprate =   5 }, -- Sarcenet Cloth
            { itemid = 1281,                                    droprate =   5 }, -- Cheviot Cloth
            { itemid = 1295,                                    droprate =   5 }, -- Twincoon
            { itemid = 1270,                                    droprate =   5 }, -- Arachne Web
            { itemid =  647,                                    droprate =   5 }, -- Molybdenum Ore
            { itemid = 1271,                                    droprate =   5 }, -- Pigeon's Blood Ruby
            { itemid = 1276,                                    droprate =   5 }, -- Tarasque Skin
            { itemid = 1296,                                    droprate =   5 }, -- Yowie Skin
            { itemid = 1277,                                    droprate =   5 }, -- Lindwurm Skin
            { itemid = 1765,                                    droprate =   5 }, -- Habu Skin
            { itemid = 2828,                                    droprate =   5 }, -- Herensugue Skin
            { itemid = 2837,                                    droprate =   5 }, -- Ratatoskr Pelt
            { itemid = 2839,                                    droprate =   5 }, -- Coquecigrue Skin
            { itemid = 2830,                                    droprate =   5 }, -- Bastet Fang
            { itemid = 2833,                                    droprate =   5 }, -- Thunder Coral
            { itemid = 1272,                                    droprate =   5 }, -- Arioch Fang
            { itemid = 1273,                                    droprate =   5 }, -- Namtar Bone
            { itemid = 2849,                                    droprate =   5 }, -- Likho Talon
            { itemid = 2846,                                    droprate =   5 }, -- Hefty Oak Lumber
            { itemid = 2855,                                    droprate =   5 }, -- Mahogany Heartwood
            { itemid = xi.item.CHUNK_OF_FIRE_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_ICE_ORE,                droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WIND_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_EARTH_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHTNING_ORE,          droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WATER_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHT_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_DARK_ORE,               droprate =   3 },
            { itemid = xi.item.CLUMP_OF_IMPERIAL_TEA_LEAVES,    droprate =   4 },
            { itemid = xi.item.DRAGON_FRUIT,                    droprate =   4 },
            { itemid = xi.item.WALNUT,                          droprate =   4 },
            { itemid = xi.item.BOWL_OF_AMBROSIA,                droprate =   4 },
            { itemid = xi.item.BOTTLE_OF_AMRITA,                droprate =   4 },
            { itemid = xi.item.DRAGON_HEART,                    droprate =   3 },
            { itemid = xi.item.HANDFUL_OF_DRAGON_SCALES,        droprate =   3 },
            { itemid = xi.item.SLICE_OF_DRAGON_MEAT,            droprate =   3 },
            { itemid = xi.item.CHUNK_OF_HYDRA_MEAT,             droprate =   3 },
            { itemid = xi.item.SLICE_OF_CERBERUS_MEAT,          droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HIDE,                   droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HORN,                   droprate =   3 },
            { itemid = 2158,                                    droprate =   3 }, -- Hydra Fang
            { itemid = 2172,                                    droprate =   3 }, -- Hydra Scale
            { itemid = 2168,                                    droprate =   3 }, -- Cerberus Claw
            { itemid = 2169,                                    droprate =   3 }, -- Cerberus Hide
            { itemid = 2371,                                    droprate =   3 }, -- Khimaira Horn
            { itemid = 2372,                                    droprate =   3 }, -- Khimaira Mane
            { itemid = 2373,                                    droprate =   3 }, -- Khimaira Tail
            { itemid = 4273,                                    droprate =   3 }, -- Kitron
            { itemid = 1718,                                    droprate =   3 }, -- M-bugard Tusk
            { itemid = 1719,                                    droprate =   3 }, -- Harajnite Shell
            { itemid = xi.item.SQUARE_OF_ECARLATE_CLOTH,        droprate =   3 },
            { itemid = xi.item.ARGYRO_RIVET,                    droprate =   3 },
            { itemid = xi.item.UTOPIAN_GOLD_THREAD,             droprate =   3 },
            { itemid = xi.item.ANCIENT_BRASS_INGOT,             droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BENEDICT_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_BENEDICT_YARN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_DIABOLIC_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_DIABOLIC_YARN,          droprate =   3 },
            { itemid = xi.item.SPOOL_OF_RUBY_SILK_THREAD,       droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CARDINAL_CLOTH,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SUPPLE_SKIN,           droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LIGHT_FILAMENT,         droprate =   3 },
            { itemid = xi.item.CHUNK_OF_SNOWY_CERMET,           droprate =   3 },
            { itemid = xi.item.WHITE_RIVET,                     droprate =   3 },
            { itemid = xi.item.DARK_ORICHALCUM_INGOT,           droprate =   3 },
            { itemid = xi.item.BLACK_RIVET,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SMALT_LEATHER,         droprate =   3 },
            { itemid = xi.item.FETID_LANOLIN_CUBE,              droprate =   3 },
            { itemid = xi.item.SPOOL_OF_COILED_YARN,            droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BROWN_DOESKIN,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_CHAMELEON_YARN,         droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CHARCOAL_COTTON,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SCARLET_ODOSHI,         droprate =   3 },
            { itemid = xi.item.SHEET_OF_KUROGANE,               droprate =   3 },
            { itemid = xi.item.PLAITED_CORD,                    droprate =   3 },
            { itemid = xi.item.POT_OF_EBONY_LACQUER,            droprate =   3 },
            { itemid = xi.item.SHEET_OF_COBALT_MYTHRIL,         droprate =   3 },
            { itemid = xi.item.BLUE_RIVET,                      droprate =   3 },
            { itemid = xi.item.SPOOL_OF_GLITTERING_YARN,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ASTRAL_LEATHER,        droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LUMINIAN_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_FLAMESHUN_CLOTH,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SILKWORM_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CANVAS_TOILE,          droprate =   3 },
            { itemid = xi.item.PANTIN_WIRE,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CORDUROY_CLOTH,        droprate =   3 },
            { itemid = xi.item.PIECE_OF_ANGEL_SKIN,             droprate =   3 },
            { itemid = xi.item.LOCK_OF_SIRENS_HAIR,             droprate =   3 },
            { itemid = xi.item.DIVINE_LOG,                      droprate =   3 },
            { itemid = xi.item.POT_OF_VIRIDIAN_URUSHI,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_KEJUSU_SATIN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ELTORO_LEATHER,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_GALATEIA,              droprate =   3 },
            { itemid = xi.item.DRAGON_BONE,                     droprate =   3 },
            { itemid = 1703,                                    droprate =   3 }, -- Kunwu Ore
        },
        -- Slot 5, Misc/Medicine --
        {
            { itemid = xi.item.VILE_ELIXIR,                     droprate = 150 },
            { itemid = 4149,                                    droprate = 150 }, -- Panacea
            { itemid = xi.item.VILE_ELIXIR_P1,                  droprate = 140 },
            { itemid = xi.item.HI_RERAISER,                     droprate = 140 },
            { itemid = xi.item.REMEDY,                          droprate = 140 },
            { itemid = xi.item.ICARUS_WING,                     droprate = 140 },
            { itemid = xi.item.SUPER_RERAISER,                  droprate = 140 },
        },
        -- Slot 9, Misc/Medicine --
        {
            { itemid = xi.item.VILE_ELIXIR,                     droprate = 150 },
            { itemid = 4149,                                    droprate = 150 }, -- Panacea
            { itemid = xi.item.VILE_ELIXIR_P1,                  droprate = 140 },
            { itemid = xi.item.HI_RERAISER,                     droprate = 140 },
            { itemid = xi.item.REMEDY,                          droprate = 140 },
            { itemid = xi.item.ICARUS_WING,                     droprate = 140 },
            { itemid = xi.item.SUPER_RERAISER,                  droprate = 140 },
        },
    },
    [105] =
    {   -- Slot 1, Currency --
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate = 100 },
            { itemid = xi.item.LINEN_COIN_PURSE,                droprate = 100 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =  90 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =  90 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =  90 },
            { itemid =  6541,                                   droprate =  90 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  90 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  90 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  90 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  90 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter            
        },
        -- Slot 6, Currency
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate =  90 },
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  60 },
            { itemid = xi.item.LINEN_COIN_PURSE,                droprate = 100 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =  90 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =  90 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =  90 },
            { itemid =  6541,                                   droprate =  80 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  80 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  80 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  80 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  80 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter
        },
        -- Slot 10, Tatters --
        {
            { itemid =  3283,                                   droprate = 125 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate = 125 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate = 125 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate = 125 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate = 125 }, -- Martial Tatter
            { itemid =  3279,                                   droprate = 125 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate = 125 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate = 125 }, -- Wyrmal Tatter
        },
        -- Slot 2, Pop Items
        {
            { itemid = 1404,                                    droprate =  15 }, -- Genbu Seal
            { itemid = 1405,                                    droprate =  15 }, -- Seiryu Seal
            { itemid = 1406,                                    droprate =  15 }, -- Byakko Seal
            { itemid = 1407,                                    droprate =  15 }, -- Suzaku Seal
            { itemid = xi.item.IVORY_CHIP,                      droprate =  20 },
            { itemid = xi.item.SCARLET_CHIP,                    droprate =  20 },
            { itemid = xi.item.EMERALD_CHIP,                    droprate =  20 },
            { itemid = xi.item.SILVER_CHIP,                     droprate =  20 },
            { itemid = xi.item.CERULEAN_CHIP,                   droprate =  20 },
            { itemid = 1986,                                    droprate =  20 }, -- Orchid Chip
            { itemid = xi.item.SMALT_CHIP,                      droprate =  20 },
            { itemid = xi.item.SMOKY_CHIP,                      droprate =  20 },
            { itemid = 1987,                                    droprate =  20 }, -- Charcoal Chip
            { itemid = 1988,                                    droprate =  20 }, -- Magenta Chip
            { itemid = xi.item.FIRST_VIRTUE,                    droprate =  20 },
            { itemid =  1853,                                   droprate =  20 }, -- Second Virtue
            { itemid = xi.item.THIRD_VIRTUE,                    droprate =  20 },
            { itemid =  1848,                                   droprate =  20 }, -- Fourth Virtue
            { itemid =  1847,                                   droprate =  20 }, -- Fifth Virtue
            { itemid =  1849,                                   droprate =  20 }, -- Sxith Virtue
            { itemid = xi.item.HELLCAGE_BUTTERFLY,              droprate =  20 },
            { itemid = xi.item.JUG_OF_FLORAL_NECTAR,            droprate =  20 },
            { itemid = xi.item.WEDGE_OF_RODENT_CHEESE,          droprate =  20 },
            { itemid = xi.item.CLUMP_OF_SHADELEAVES,            droprate =  20 },
            { itemid = xi.item.BEAKER_OF_PECTIN,                droprate =  20 },
            { itemid = xi.item.FLASK_OF_COG_LUBRICANT,          droprate =  20 },
            { itemid = xi.item.GOLDEN_TEETH,                    droprate =  20 },
            { itemid = xi.item.GREENLING,                       droprate =  20 },
            { itemid = xi.item.BOTTLE_OF_SPOILT_BLOOD,          droprate =  20 },
            { itemid = xi.item.BUNCH_OF_SENORITA_PAMAMAS,       droprate =  20 },
            { itemid = xi.item.JAR_OF_OILY_BLOOD,               droprate =  20 },
            { itemid = xi.item.STRAND_OF_SAMARIRI_CORPSEHAIR,   droprate =  20 },
            { itemid = xi.item.SLAB_OF_RAW_BUFFALO,             droprate =  20 },
            { itemid = xi.item.LUMP_OF_BONE_CHARCOAL,           droprate =  20 },
            { itemid = xi.item.PINCH_OF_GRANULATED_SUGAR,       droprate =  20 },
            { itemid = xi.item.MINT_DROP,                       droprate =  20 },
            { itemid = xi.item.OPALUS_GEM,                      droprate =  20 },
            { itemid = xi.MERROW_NO_11_MOLTING,                 droprate =  20 },
            { itemid = xi.BAR_OF_FERRITE,                       droprate =  20 },
            { itemid = xi.BAGGED_SHEEP_BOTFLY,                  droprate =  20 },
            { itemid = xi.OLZHIRYAN_CACTUS_PADDLE,              droprate =  20 },
            { itemid = xi.VIAL_OF_PURE_BLOOD,                   droprate =  20 },
            { itemid = xi.VINEGAR_PIE,                          droprate =  20 },
            { itemid = xi.JAR_OF_ROCK_JUICE,                    droprate =  20 },
            { itemid = xi.BOUND_EXORCISM_TREATISE,              droprate =  20 },
            { itemid = xi.CLUMP_OF_MYRRH,                       droprate =  20 },
            { itemid = xi.WHOLE_ROSE_SCAMPI,                    droprate =  20 },
            { itemid = xi.JUG_OF_MONKEY_WINE,                   droprate =  20 },
            { itemid = xi.CHUNK_OF_BUFFALO_CORPSE,              droprate =  20 },
            { itemid = xi.CHUNK_OF_SINGED_BUFFALO,              droprate =  20 },
            { itemid = xi.PANDEMONIUM_KEY,                      droprate =  20 },
        },
        -- Slot 3, Equipment --
        {
            { itemid = xi.item.DUENDE_COTEHARDIE,               droprate =   4 },
            { itemid = xi.item.NOKIZARU_GI,                     droprate =   4 },
            { itemid = xi.item.RAPPAREE_HARNESS,                droprate =   4 },
            { itemid = xi.item.SHINIMUSHA_HARA_ATE,             droprate =   4 },
            { itemid = xi.item.WYVERN_MAIL,                     droprate =   4 },
            { itemid = xi.item.SHIKAREE_AKETON,                 droprate =   4 },
            { itemid = xi.item.CERISE_DOUBLET,                  droprate =   4 },
            { itemid = xi.item.GLAMOR_JUPON,                    droprate =   4 },
            { itemid = xi.item.GLOOM_BREASTPLATE,               droprate =   4 },
            { itemid = xi.item.NIMBUS_DOUBLET,                  droprate =   4 },
            { itemid = xi.item.AIKIDO_GI,                       droprate =   4 },
            { itemid = xi.item.PARADE_CUIRASS,                  droprate =   4 },
            { itemid = xi.item.GAUDY_HARNESS,                   droprate =   4 },
            { itemid = xi.item.HAMAYUMI,                        droprate =   5 },
            { itemid = xi.item.DIA_WAND,                        droprate =   4 },
            { itemid = xi.item.STONE_GORGET,                    droprate =   5 },
            { itemid =  18359,                                  droprate =   5 }, -- Boreas Cesti
            { itemid =  15468,                                  droprate =   5 }, -- Resentment Cape
            { itemid =  xi.item.GOTHIC_SABATONS,                droprate =   5 },
            { itemid =  xi.item.GOTHIC_GAUNTLETS,               droprate =   5 },
            { itemid =  16187,                                  droprate =   5 }, -- Adoubeurs Pavise
            { itemid =  16899,                                  droprate =   5 }, -- Hototogisu
            { itemid =  16374,                                  droprate =   5 }, -- Layqa Seraweels
            { itemid =  17199,                                  droprate =   5 }, -- Loxley Bow
            { itemid =  16882,                                  droprate =   5 }, -- Calamar
            { itemid =  17504,                                  droprate =   5 }, -- Pagures
            { itemid =  16884,                                  droprate =   5 }, -- Narval
            { itemid =  17503,                                  droprate =   5 }, -- Exocets
            { itemid =  19238,                                  droprate =   5 }, -- Jasper Tathlum
            { itemid =  11404,                                  droprate =   5 }, -- Promptitude Solea
            { itemid =  15897,                                  droprate =   5 }, -- Grace Corset
            { itemid =  13803,                                  droprate =   5 }, -- Shaman's Cloak
            { itemid =  19237,                                  droprate =   5 }, -- Slick Dart
            { itemid =  15942,                                  droprate =   5 }, -- Summoning Belt
            { itemid =  xi.item.MUSHROOM_HELM,                  droprate =   2 },
            { itemid =  xi.item.LUNA_SUBLIGAR,                  droprate =   2 },
            { itemid =  16980,                                  droprate =   5 }, -- Sukesada
            { itemid =  13912,                                  droprate =   5 }, -- Shadow Mask
            { itemid =  16943,                                  droprate =   5 }, -- Ascalon
            { itemid =  14063,                                  droprate =   5 }, -- Protecting Bangles
            { itemid =  14064,                                  droprate =   5 }, -- Sand Gloves
            { itemid =  17651,                                  droprate =   5 }, -- Dainslaif
            { itemid =  17924,                                  droprate =   5 }, -- Tungi
            { itemid =  16734,                                  droprate =   5 }, -- Pendragon Axe
            { itemid =  15995,                                  droprate =   5 }, -- Carline Earring
            { itemid =  16127,                                  droprate =   5 }, -- Carline Ribbon
            { itemid =  16125,                                  droprate =   5 }, -- Breeder Mask
            { itemid =  15001,                                  droprate =   5 }, -- Breeder Mufflers
            { itemid =  15946,                                  droprate =   5 }, -- Tempest Belt
            { itemid =  11405,                                  droprate =   5 }, -- Kyoshu Kyahan
            { itemid =  11533,                                  droprate =   5 }, -- Lyricist's Gonnelle
            { itemid =  16298,                                  droprate =   5 }, -- Knack Pendant
            { itemid =  17454,                                  droprate =   5 }, -- Asklepios
            { itemid =  17455,                                  droprate =   5 }, -- Skirnir's Wand
            { itemid =  16912,                                  droprate =   5 }, -- Kitsutsuki
            { itemid =  17926,                                  droprate =   5 }, -- Acha D'Armas
            { itemid =  17982,                                  droprate =   5 }, -- Kard
            { itemid =  17983,                                  droprate =   5 }, -- Valiant Knife
            { itemid =  18042,                                  droprate =   5 }, -- Ascention
            { itemid =  17563,                                  droprate =   5 }, -- Power Staff
            { itemid =  17969,                                  droprate =   5 }, -- Fendoir
            { itemid =  18608,                                  droprate =   5 }, -- Atesh Pole
            { itemid =  16727,                                  droprate =   5 }, -- Eisentaenzer
            { itemid =  17971,                                  droprate =   5 }, -- Tartaglia
            { itemid =  19235,                                  droprate =   5 }, -- Veuglaire
            { itemid =  16375,                                  droprate =   5 }, -- Surge Subligar
            { itemid =  xi.item.ASTRAL_ASPIS,                   droprate =   5 },
            { itemid =  xi.item.GAE_BOLG,                       droprate =   5 },
            { itemid =  xi.item.LOHAR,                          droprate =   5 },
            { itemid =   19122,                                 droprate =   5 }, -- Courser's Pugio
            { itemid =   16081,                                 droprate =   5 }, -- Curate's Hat
            { itemid =   15882,                                 droprate =   5 }, -- Othinus' Bow
            { itemid =   17244,                                 droprate =   5 }, -- Storm Belt
            { itemid =   14806,                                 droprate =   5 }, -- Intruder Earring
            { itemid =   14466,                                 droprate =   5 }, -- Fomor Tunic
            { itemid =   18007,                                 droprate =   5 }, -- Chiroptera Dagger
            { itemid =   17510,                                 droprate =   5 }, -- Vampiric Claws
            { itemid =   14763,                                 droprate =   5 }, -- Boroka Earring
            { itemid =   13178,                                 droprate =   5 }, -- Auditory Torque
            { itemid =   15943,                                 droprate =   5 }, -- Virtuoso Belt
            { itemid =   14884,                                 droprate =   5 }, -- Mycophile Cuffs
            { itemid =   17794,                                 droprate =   5 }, -- Niokiyotsuna
            { itemid =   15219,                                 droprate =   5 }, -- Sinister Mask
            { itemid =   16368,                                 droprate =   5 }, -- Herder's Subligar
            { itemid =   14724,                                 droprate =   5 }, -- Moldavite Earring
            { itemid =   16279,                                 droprate =   5 }, -- Pile Chain
            { itemid =   15546,                                 droprate =   5 }, -- Fasting Ring
            { itemid =   16299,                                 droprate =   5 }, -- Lleu's Charm
            { itemid =   11496,                                 droprate =   5 }, -- Fenrir's Crown
            { itemid =   14168,                                 droprate =   5 }, -- Dune Boots
            { itemid =   17854,                                 droprate =   5 }, -- Cradle Horn
            { itemid =   19239,                                 droprate =   5 }, -- Astrolable
            { itemid =   16169,                                 droprate =   5 }, -- Caballero Shield
            { itemid =   17653,                                 droprate =   5 }, -- Hrotti
            { itemid =   18027,                                 droprate =   5 }, -- Palladium Dagger
            { itemid =   17564,                                 droprate =   5 }, -- Cocytus Pole
            { itemid =   16426,                                 droprate =   5 }, -- Avengers
            { itemid =   19121,                                 droprate =   5 }, -- Sleight Kukri
            { itemid =   15944,                                 droprate =   7 }, -- Selemnus Belt
            { itemid =   16297,                                 droprate =   7 }, -- Shepherd's Chain
            { itemid =  xi.item.KAMEWARI,                       droprate =   5 },
            { itemid =  xi.item.NADRS,                          droprate =   5 },
            { itemid =  xi.item.ALTDORFS_EARRING,               droprate =   5 },
            { itemid =  xi.item.WILHELMS_EARRING,               droprate =   5 },
            { itemid =  xi.item.HELENUSS_EARRING,               droprate =   5 },
            { itemid =  xi.item.CASSANDRAS_EARRING,             droprate =   5 },
            { itemid =  xi.item.MINSTRELS_DAGGER,               droprate =   5 },
            { itemid =  xi.item.SAND_CHARM,                     droprate =   5 },
            { itemid =   15692,                                 droprate =   5 }, -- Storm Crackows
            { itemid =   14669,                                 droprate =   5 }, -- Jaeger Ring
            { itemid =   15351,                                 droprate =   5 }, -- Bounding Boots
            { itemid =   18018,                                 droprate =   5 }, -- Sirocco Kukri
            { itemid =   13567,                                 droprate =   5 }, -- Bomb Queen Ring
            { itemid =   15547,                                 droprate =   5 }, -- Vilma's Ring
            { itemid =   26164,                                 droprate =   5 }, -- Caliber Ring
            { itemid =   15183,                                 droprate =   7 }, -- Dobson Bandana
            { itemid =   15184,                                 droprate =   7 }, -- Voyager Sallet
            { itemid =   14986,                                 droprate =   7 }, -- Ochimusha Kote
            { itemid =   15737,                                 droprate =   7 }, -- Sarutobi Kyahan
            { itemid =   15551,                                 droprate =   7 }, -- Shikaree Ring
            { itemid =  xi.item.EMPRESS_HAIRPIN,                droprate =   7 },
            { itemid =  xi.item.JOYEUSE,                        droprate =   7 },
            { itemid =  xi.item.DRYAD_STAFF,                    droprate =   7 },
            { itemid =  xi.item.VALIS_BOW,                      droprate =   7 },
            { itemid =  xi.item.RETALIATORS,                    droprate =   7 },
            { itemid =  xi.item.UNGUR_BOOMERANG,                droprate =   7 },
            { itemid =   15515,                                 droprate =   7 }, -- Peacock Amulet
            { itemid =  xi.item.TROTTER_BOOTS,                  droprate =   7 },
            { itemid =   19236,                                 droprate =   7 }, -- Hightail Bullet
            { itemid =   17192,                                 droprate =   7 }, -- Ifrit's Bow
            { itemid =   17711,                                 droprate =   7 }, -- Shiva's Shotel
            { itemid =   18021,                                 droprate =   7 }, -- Titan's Baselarde
            { itemid =   18063,                                 droprate =   7 }, -- Garuda's Sickle
            { itemid =   18109,                                 droprate =   7 }, -- Leviathan's Couse
            { itemid =   18404,                                 droprate =   7 }, -- Ramuh's Mace
            { itemid =   18581,                                 droprate =   7 }, -- Carbuncle's Pole
            { itemid =   14931,                                 droprate =   7 }, -- Carbuncle's Cuffs
            { itemid =   18422,                                 droprate =   7 }, -- Ryumon
            { itemid =   14960,                                 droprate =   7 }, -- Evoker's Gages
            { itemid =   19277,                                 droprate =   7 }, -- Tsugumi
            { itemid =   11408,                                 droprate =   7 }, -- Morana Pigaches
            { itemid =   11409,                                 droprate =   7 }, -- Aoide's Pumps
            { itemid =   16238,                                 droprate =   7 }, -- Taster's Cape
            { itemid =   11497,                                 droprate =   7 }, -- Spurrer Beret
            { itemid =   11406,                                 droprate =   7 }, -- Stimulus Sabots
            { itemid =   18767,                                 droprate =   6 }, -- Birdbanes
            { itemid =   15854,                                 droprate =   7 }, -- Sortie Ring
            { itemid =   15915,                                 droprate =   7 }, -- Sothic Rope
            { itemid =   11342,                                 droprate =   6 }, -- Restorer Cloak
            { itemid =   18770,                                 droprate =   7 }, -- Pygme Sainti
            { itemid =   17737,                                 droprate =   6 }, -- Corsair's Scimitar
            { itemid =   19124,                                 droprate =   7 }, -- Creve-coeur
            { itemid =   19279,                                 droprate =   7 }, -- Musanto
            { itemid =   17766,                                 droprate =   7 }, -- Lyft Scimitar
            { itemid =   17970,                                 droprate =   7 }, -- Lyft Tabar
            { itemid =   18508,                                 droprate =   7 }, -- Lyft Voulge
            { itemid =   18609,                                 droprate =   7 }, -- Lyft Pole
            { itemid =   18771,                                 droprate =   7 }, -- Lyft Sainti
            { itemid =   18872,                                 droprate =   7 }, -- Lyft Ferule
            { itemid =   18958,                                 droprate =   7 }, -- Lyft Scythe
            { itemid =   19125,                                 droprate =   7 }, -- Lyft Jambiya
            { itemid =   19161,                                 droprate =   7 }, -- Lyft Claymore
            { itemid =   19233,                                 droprate =   7 }, -- Lyft Crossbow
            { itemid =   19306,                                 droprate =   7 }, -- Lyft Lance
            { itemid =  xi.item.LAVAS_RING,                     droprate =   7 },
            { itemid =  xi.item.KUSHAS_RING,                    droprate =   7 },
            { itemid =  xi.item.NASATYAS_RING,                  droprate =   7 },
            { itemid =  xi.item.DASRAS_RING,                    droprate =   7 },
            { itemid =  xi.item.HOPE_STAFF,                     droprate =   7 },
            { itemid =  xi.item.JUSTICE_SWORD,                  droprate =   7 },
            { itemid =  xi.item.TEMPERANCE_AXE,                 droprate =   7 },
            { itemid =  xi.item.LOVE_HALBERD,                   droprate =   7 },
            { itemid =  xi.item.FORTITUDE_AXE,                  droprate =   7 },
            { itemid =  xi.item.FAITH_BAGHNAKHS,                droprate =   7 },
            { itemid =  xi.item.PRUDENCE_ROD,                   droprate =   7 },
            { itemid =  xi.item.BYAKKOS_AXE,                    droprate =   8 },
            { itemid =  xi.item.SUZAKUS_SCYTHE,                 droprate =   8 },
            { itemid =  xi.item.SEIRYUS_SWORD,                  droprate =   8 },
        },
        -- Slot 7, Equipment --
        {
            { itemid =  5681,                                   droprate =   4 }, -- Cupid Chocolate
            { itemid = xi.item.GENBUS_KABUTO,                   droprate =   6 },
            { itemid = xi.item.GENBUS_SHIELD,                   droprate =   6 },
            { itemid = xi.item.SEIRYUS_KOTE,                    droprate =   6 },
            { itemid = xi.item.SUZAKUS_SUNE_ATE,                droprate =   6 },
            { itemid = xi.item.BYAKKOS_HAIDATE,                 droprate =   6 },
            { itemid = xi.item.ANIMATOR_P1,                     droprate =   5 },
            { itemid = 17567,                                   droprate =   5 }, -- Kirin's Pole
            { itemid = 12562,                                   droprate =   5 }, -- Kirin's Osode
            { itemid = 16034,                                   droprate =   5 }, -- Sarabande Earring
            { itemid = 13415,                                   droprate =   5 }, -- Pixie Earring
            { itemid = 16300,                                   droprate =   5 }, -- Wit Pendant
            { itemid = 16303,                                   droprate =   5 }, -- Laran's Pendant
            { itemid = 15057,                                   droprate =   5 }, -- Bricta's Cuffs
            { itemid = 14943,                                   droprate =   5 }, -- Barbarossa's Moufles
            { itemid = 16376,                                   droprate =   5 }, -- Bahram Cuisses
            { itemid = 16302,                                   droprate =   5 }, -- Bloodbead Gorget
            { itemid = 11411,                                   droprate =   5 }, -- Shrewd Pumps
            { itemid = 15223,                                   droprate =   5 }, -- Ace's Helm
            { itemid = 18002,                                   droprate =   5 }, -- Perseu's Harp
            { itemid = 14873,                                   droprate =   5 }, -- Bandomusha Kote
            { itemid = 19280,                                   droprate =   5 }, -- Narigitsune
            { itemid = xi.item.WYRM_BEARD,                      droprate =   5 },
            { itemid = xi.item.BEHEMOTH_TONGUE,                 droprate =   5 },
            { itemid = xi.item.ADAMANTOISE_EGG,                 droprate =   5 },
            { itemid = xi.item.SEVENEYES,                       droprate =   5 },
            { itemid = xi.item.ALGOL,                           droprate =   5 },
            { itemid = 13658,                                   droprate =   5 }, -- Shadow Mantle
            { itemid = 14646,                                   droprate =   5 }, -- Shadow Ring
            { itemid = 11589,                                   droprate =   5 }, -- Aesir Torque
            { itemid = 16057,                                   droprate =   5 }, -- Aesir Ear Pendant
            { itemid = 11546,                                   droprate =   5 }, -- Aesir Mantle
            { itemid = 11547,                                   droprate =   5 }, -- Colossus's Mantle
            { itemid = 11590,                                   droprate =   5 }, -- Colossus's Torque
            { itemid = 16058,                                   droprate =   5 }, -- Colossus's Earring
            { itemid = 18019,                                   droprate =   5 }, -- X's Knife
            { itemid = 18057,                                   droprate =   5 }, -- Y's Scythe
            { itemid = 18101,                                   droprate =   5 }, -- Z's Trident
            { itemid = 15899,                                   droprate =   5 }, -- Velocious Belt
            { itemid = 15617,                                   droprate =   5 }, -- Barbarossa's Zerehs
            { itemid = 17586,                                   droprate =   5 }, -- Mercurial Pole
            { itemid = xi.item.JUSTICE_TORQUE,                  droprate =   5 },
            { itemid = xi.item.HOPE_TORQUE,                     droprate =   5 },
            { itemid = xi.item.PRUDENCE_TORQUE,                 droprate =   5 },
            { itemid = xi.item.FORTITUDE_TORQUE,                droprate =   5 },
            { itemid = xi.item.FAITH_TORQUE,                    droprate =   5 },
            { itemid = xi.item.TEMPERANCE_TORQUE,               droprate =   5 },
            { itemid = xi.item.LOVE_TORQUE,                     droprate =   5 },
            { itemid = xi.item.RIDILL,                          droprate =   5 },
            { itemid = xi.item.OCTAVE_CLUB,                     droprate =   5 },
            { itemid = xi.item.HAUTECLAIRE,                     droprate =   5 },
            { itemid = 13566,                                   droprate =   3 }, -- Defending Ring
            { itemid = 27456,                                   droprate =   3 }, -- Crier's Gaiters
            { itemid = 14468,                                   droprate =   3 }, -- Yinyang Robe
            { itemid = 17754,                                   droprate =   5 }, -- Sylphid Epee
            { itemid = 16154,                                   droprate =   5 }, -- Karura Hachigane
            { itemid = 16000,                                   droprate =   5 }, -- Dragoon's Earring
            { itemid = 16240,                                   droprate =   5 }, -- Erato's Cape
            { itemid = 17755,                                   droprate =   5 }, -- Beast Slayer
            { itemid = 16340,                                   droprate =   5 }, -- Armadillo Cuisses
            { itemid = 17961,                                   droprate =   5 }, -- Lion Tamer
            { itemid = 15018,                                   droprate =   5 }, -- Ritterhentzes
            { itemid = 18859,                                   droprate =   5 }, -- Kerykeion
            { itemid = 16274,                                   droprate =   5 }, -- Almah Torque
            { itemid = 15999,                                   droprate =   5 }, -- Guignol Earring
            { itemid = 15916,                                   droprate =   5 }, -- Corsair's Belt
            { itemid = 18950,                                   droprate =   5 }, -- White Joker
            { itemid = 11369,                                   droprate =   5 }, -- Numerist Pumps
            { itemid = 11368,                                   droprate =   5 }, -- Hakke Habaki
            { itemid = 15827,                                   droprate =   5 }, -- Insect Ring
            { itemid = 15828,                                   droprate =   5 }, -- Blood Ring
            { itemid = 19154,                                   droprate =   5 }, -- Ferrara
            { itemid = 11366,                                   droprate =   5 }, -- Avocat Pigaches
            { itemid = 15017,                                   droprate =   5 }, -- Toad Mittens
            { itemid = 16339,                                   droprate =   5 }, -- Paddock Trousers
            { itemid = 16153,                                   droprate =   5 }, -- Reikyo Hairpin
            { itemid = 11367,                                   droprate =   5 }, -- Nobushi Kyahan
            { itemid = 19109,                                   droprate =   5 }, -- Trilling Dagger
            { itemid = 18448,                                   droprate =   5 }, -- Hacchonenbutsu
            { itemid = 19211,                                   droprate =   5 }, -- Reacton Arm
            { itemid = 19028,                                   droprate =   5 }, -- Magic Strap
            { itemid = 18127,                                   droprate =   5 }, -- Achilles' Spear
            { itemid = 16338,                                   droprate =   5 }, -- Ruby Seraweels
            { itemid = 18949,                                   droprate =   5 }, -- Zareehkl Scythe
            { itemid = 19108,                                   droprate =   5 }, -- Zareehkl Jambiya
            { itemid = 16239,                                   droprate =   5 }, -- Solitaire Cape
            { itemid = 16175,                                   droprate =   5 }, -- Muse Tariqah
            { itemid = 16152,                                   droprate =   5 }, -- Hissho Hachimaki
            { itemid = 16174,                                   droprate =   5 }, -- Riot Shield
            { itemid = 18126,                                   droprate =   4 }, -- Tomoe
            { itemid = xi.item.ORACLES_GLOVES,                  droprate =   4 },
            { itemid = xi.item.AURUM_SABATONS,                  droprate =   4 },
            { itemid = 19031,                                   droprate =   4 }, -- Fire Grip
            { itemid = 19032,                                   droprate =   4 }, -- Water Grip
            { itemid = 19033,                                   droprate =   4 }, -- Wind Grip
            { itemid = 19034,                                   droprate =   4 }, -- Ice Grip
            { itemid = 19035,                                   droprate =   4 }, -- Thunder Grip
            { itemid = 19036,                                   droprate =   4 }, -- Earth Grip
            { itemid = 19037,                                   droprate =   4 }, -- Light Grip
            { itemid = 19038,                                   droprate =   4 }, -- Dark Grip
            { itemid = xi.item.ENKIDUS_MITTENS,                 droprate =   4 },
            { itemid = xi.item.AURUM_CUISSES,                   droprate =   4 },
            { itemid = 19153,                                   droprate =   4 }, -- Naglering
            { itemid = 18125,                                   droprate =   4 }, -- Cletine
            { itemid = xi.item.ENKIDUS_SUBLIGAR,                droprate =   4 },
            { itemid = xi.item.ORACLES_PIGACHES,                droprate =   4 },
            { itemid = 17960,                                   droprate =   4 }, -- Labrys
            { itemid = xi.item.ENKIDUS_LEGGINGS,                droprate =   4 },
            { itemid = xi.item.AURUM_GAUNTLETS,                 droprate =   4 },
            { itemid = 16176,                                   droprate =   4 }, -- Simba Buckler
            { itemid = 17753,                                   droprate =   4 }, -- Organics
            { itemid = xi.item.ORACLES_BRACONI,                 droprate =   4 },
            { itemid = 16177,                                   droprate =   4 }, -- Legion Scutum
            { itemid = 18595,                                   droprate =   4 }, -- Mekki Shakki
            { itemid = 18430,                                   droprate =   4 }, -- Oninohocho
            { itemid = 18593,                                   droprate =   2 }, -- Alkalurops
            { itemid = xi.item.ENKIDUS_CAP,                     droprate =   3 },
            { itemid = xi.item.ENKIDUS_HARNESS,                 droprate =   3 },
            { itemid = xi.item.HACHIRYU_SUNE_ATE,               droprate =   3 },
            { itemid = xi.item.ORACLES_CAP,                     droprate =   3 },
            { itemid = 18429,                                   droprate =   3 }, -- Shusui
            { itemid = xi.item.AURUM_ARMET,                     droprate =   3 },
            { itemid = 18497,                                   droprate =   3 }, -- Foolkiller
            { itemid = xi.item.HACHIRYU_HAIDATE,                droprate =   3 },
            { itemid = xi.item.ORACLES_ROBE,                    droprate =   3 },
            { itemid = 18446,                                   droprate =   3 }, -- Pachipachio
            { itemid = 18857,                                   droprate =   3 }, -- Antares
            { itemid = xi.item.AURUM_CUIRASS,                   droprate =   3 },
            { itemid = xi.item.HACHIRYU_KOTE,                   droprate =   3 },
            { itemid = xi.item.HACHIRYU_HARAMAKI,               droprate =   2 },
            { itemid = 10754,                                   droprate =   3 }, -- Moepapa Ring
            { itemid = 10755,                                   droprate =   3 }, -- Moepapa Annulet
            { itemid = 10756,                                   droprate =   3 }, -- Tjukurrpa Ring
            { itemid = 10757,                                   droprate =   3 }, -- Tjukurrpa Annulet
            { itemid = 10759,                                   droprate =   3 }, -- Aife's Annulet
            { itemid = 10817,                                   droprate =   3 }, -- Moepapa Stone
            { itemid = 10818,                                   droprate =   3 }, -- Tjukurrpa Belt
            { itemid = 10932,                                   droprate =   3 }, -- Oneiros torque
            { itemid = 10933,                                   droprate =   3 }, -- Mujin necklace
            { itemid = 10940,                                   droprate =   3 }, -- Moepapa Pendant
            { itemid = 10941,                                   droprate =   3 }, -- Tjukurrpa Medal
            { itemid = 10942,                                   droprate =   3 }, -- Aife's Medal
            { itemid = 10943,                                   droprate =   3 }, -- Moepapa Medal
            { itemid = 10972,                                   droprate =   3 }, -- Oneiros cappa
            { itemid = 10973,                                   droprate =   3 }, -- Oneiros cape
            { itemid = 10974,                                   droprate =   3 }, -- Mujin mantle
            { itemid = 10983,                                   droprate =   3 }, -- Aife's Mantle
            { itemid = 10984,                                   droprate =   3 }, -- Tjukurrpa Mantle
            { itemid = 11030,                                   droprate =   3 }, -- Oneiros earring
            { itemid = 11032,                                   droprate =   3 }, -- Mujin Stud
            { itemid = 11031,                                   droprate =   3 }, -- Oneiros pearl
            { itemid = 11456,                                   droprate =   3 }, -- Ryuga Sune-Ate
            { itemid = 11461,                                   droprate =   3 }, -- Aife's Pumps
            { itemid = 11670,                                   droprate =   3 }, -- Oneiros annulet
            { itemid = 11671,                                   droprate =   3 }, -- Oneiros ring
            { itemid = 11672,                                   droprate =   3 }, -- Mujin band
            { itemid = 11772,                                   droprate =   3 }, -- Oneiros sash
            { itemid = 11773,                                   droprate =   3 }, -- Oneiros belt
            { itemid = 11774,                                   droprate =   3 }, -- Oneiros cest
            { itemid = 11775,                                   droprate =   3 }, -- Oneiros rope
            { itemid = 11776,                                   droprate =   3 }, -- Mujin obi
            { itemid = 11820,                                   droprate =   3 }, -- Khthonios Mask
            { itemid = 11821,                                   droprate =   3 }, -- Khthonios Helm
            { itemid = 11816,                                   droprate =   3 }, -- Oneiros helm
            { itemid = 11817,                                   droprate =   3 }, -- Oneiros barbut
            { itemid = 11818,                                   droprate =   3 }, -- Oneiros headgear
            { itemid = 11819,                                   droprate =   3 }, -- Oneiros coif 
            { itemid = 11923,                                   droprate =   3 }, -- Tjukurrpa Gauntlets
            { itemid = 11918,                                   droprate =   3 }, -- Khthonios Gloves
            { itemid = 11919,                                   droprate =   3 }, -- Avesta Bangles
            { itemid = 17069,                                   droprate =   3 }, -- Moepapa Mace
            { itemid = 17358,                                   droprate =   3 }, -- Oneiros Harp
            { itemid = 18519,                                   droprate =   3 }, -- Oneiros axe
            { itemid = 18541,                                   droprate =   3 }, -- Tjukurrpa Axe 
            { itemid = 18623,                                   droprate =   3 }, -- Chtonic Staff
            { itemid = 18811,                                   droprate =   3 }, -- Oneiros grip
            { itemid = 19141,                                   droprate =   3 }, -- Oneiros knife
            { itemid = 19295,                                   droprate =   3 }, -- Mujin tanto
            { itemid = 19738,                                   droprate =   3 }, -- Aife's Bow
            { itemid = 19762,                                   droprate =   3 }, -- Oneiros Tathlum  
            { itemid = 19763,                                   droprate =   3 }, -- Oneiros Cluster  
            { itemid = 19767,                                   droprate =   3 }, -- Oneiros pebble
            { itemid = 19790,                                   droprate =   3 }, -- Oneiros lance
            { itemid = xi.item.MURREY_GRISAILLE,                droprate =   1 },
            { itemid =    0,                                    droprate = 250 }, -- nothing
        },
        -- Slot 4, Materials --
        {
            { itemid = xi.item.IRON_INGOT,                      droprate =   5 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   5 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   5 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   5 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   5 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   5 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   5 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   5 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   5 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   5 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   5 },
            { itemid = xi.item.RAM_HORN,                        droprate =   5 },
            { itemid = xi.item.ELM_LOG,                         droprate =   5 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   5 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   5 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   5 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   5 },
            { itemid =  850,                                    droprate =   5 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   5 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   5 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   5 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   5 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   5 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   5 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   5 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   5 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   5 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   5 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   5 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   5 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   5 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   5 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   5 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   5 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   5 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   5 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   5 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   5 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   5 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   5 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   5 },
            { itemid = xi.item.IMP_HORN,                        droprate =   5 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   5 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   5 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   5 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   5 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   5 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   5 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   5 },
            { itemid = 1225,                                    droprate =   5 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   5 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   5 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   5 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   5 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   5 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   5 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   5 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   5 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   5 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   5 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   5 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   5 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   5 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   5 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   5 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   5 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   5 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   5 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   5 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   5 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   5 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   5 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   5 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   5 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   5 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   5 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   5 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   5 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   5 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   5 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   5 },
            { itemid = 2151,                                    droprate =   5 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   5 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   5 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   5 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   5 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   5 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   5 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   5 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   5 }, -- Water Anima
            { itemid = 1647,                                    droprate =   5 }, -- Light Anima
            { itemid = 1648,                                    droprate =   5 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   5 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   5 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   5 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   5 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   5 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   5 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   5 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   5 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   5 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   5 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   5 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   5 },
            { itemid =  734,                                    droprate =   5 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   5 }, -- Amphiptere Hide
            { itemid = 2164,                                    droprate =   5 }, -- Pephredo Hive Chip
            { itemid = 1279,                                    droprate =   5 }, -- Taffeta Cloth
            { itemid = 1280,                                    droprate =   5 }, -- Sarcenet Cloth
            { itemid = 1281,                                    droprate =   5 }, -- Cheviot Cloth
            { itemid = 1295,                                    droprate =   5 }, -- Twincoon
            { itemid = 1270,                                    droprate =   5 }, -- Arachne Web
            { itemid =  647,                                    droprate =   5 }, -- Molybdenum Ore
            { itemid = 1271,                                    droprate =   5 }, -- Pigeon's Blood Ruby
            { itemid = 1276,                                    droprate =   5 }, -- Tarasque Skin
            { itemid = 1296,                                    droprate =   5 }, -- Yowie Skin
            { itemid = 1277,                                    droprate =   5 }, -- Lindwurm Skin
            { itemid = 1765,                                    droprate =   5 }, -- Habu Skin
            { itemid = 2828,                                    droprate =   5 }, -- Herensugue Skin
            { itemid = 2837,                                    droprate =   5 }, -- Ratatoskr Pelt
            { itemid = 2839,                                    droprate =   5 }, -- Coquecigrue Skin
            { itemid = 2830,                                    droprate =   5 }, -- Bastet Fang
            { itemid = 2833,                                    droprate =   5 }, -- Thunder Coral
            { itemid = 1272,                                    droprate =   5 }, -- Arioch Fang
            { itemid = 1273,                                    droprate =   5 }, -- Namtar Bone
            { itemid = 2849,                                    droprate =   5 }, -- Likho Talon
            { itemid = 2846,                                    droprate =   5 }, -- Hefty Oak Lumber
            { itemid = 2855,                                    droprate =   5 }, -- Mahogany Heartwood
            { itemid = xi.item.CHUNK_OF_FIRE_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_ICE_ORE,                droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WIND_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_EARTH_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHTNING_ORE,          droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WATER_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHT_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_DARK_ORE,               droprate =   3 },
            { itemid = xi.item.CLUMP_OF_IMPERIAL_TEA_LEAVES,    droprate =   4 },
            { itemid = xi.item.DRAGON_FRUIT,                    droprate =   4 },
            { itemid = xi.item.WALNUT,                          droprate =   4 },
            { itemid = xi.item.BOWL_OF_AMBROSIA,                droprate =   4 },
            { itemid = xi.item.BOTTLE_OF_AMRITA,                droprate =   4 },
            { itemid = xi.item.DRAGON_HEART,                    droprate =   3 },
            { itemid = xi.item.HANDFUL_OF_DRAGON_SCALES,        droprate =   3 },
            { itemid = xi.item.SLICE_OF_DRAGON_MEAT,            droprate =   3 },
            { itemid = xi.item.CHUNK_OF_HYDRA_MEAT,             droprate =   3 },
            { itemid = xi.item.SLICE_OF_CERBERUS_MEAT,          droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HIDE,                   droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HORN,                   droprate =   3 },
            { itemid = 2158,                                    droprate =   3 }, -- Hydra Fang
            { itemid = 2172,                                    droprate =   3 }, -- Hydra Scale
            { itemid = 2168,                                    droprate =   3 }, -- Cerberus Claw
            { itemid = 2169,                                    droprate =   3 }, -- Cerberus Hide
            { itemid = 2371,                                    droprate =   3 }, -- Khimaira Horn
            { itemid = 2372,                                    droprate =   3 }, -- Khimaira Mane
            { itemid = 2373,                                    droprate =   3 }, -- Khimaira Tail
            { itemid = 4273,                                    droprate =   3 }, -- Kitron
            { itemid = 1718,                                    droprate =   3 }, -- M-bugard Tusk
            { itemid = 1719,                                    droprate =   3 }, -- Harajnite Shell
            { itemid = xi.item.SQUARE_OF_ECARLATE_CLOTH,        droprate =   3 },
            { itemid = xi.item.ARGYRO_RIVET,                    droprate =   3 },
            { itemid = xi.item.UTOPIAN_GOLD_THREAD,             droprate =   3 },
            { itemid = xi.item.ANCIENT_BRASS_INGOT,             droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BENEDICT_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_BENEDICT_YARN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_DIABOLIC_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_DIABOLIC_YARN,          droprate =   3 },
            { itemid = xi.item.SPOOL_OF_RUBY_SILK_THREAD,       droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CARDINAL_CLOTH,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SUPPLE_SKIN,           droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LIGHT_FILAMENT,         droprate =   3 },
            { itemid = xi.item.CHUNK_OF_SNOWY_CERMET,           droprate =   3 },
            { itemid = xi.item.WHITE_RIVET,                     droprate =   3 },
            { itemid = xi.item.DARK_ORICHALCUM_INGOT,           droprate =   3 },
            { itemid = xi.item.BLACK_RIVET,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SMALT_LEATHER,         droprate =   3 },
            { itemid = xi.item.FETID_LANOLIN_CUBE,              droprate =   3 },
            { itemid = xi.item.SPOOL_OF_COILED_YARN,            droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BROWN_DOESKIN,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_CHAMELEON_YARN,         droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CHARCOAL_COTTON,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SCARLET_ODOSHI,         droprate =   3 },
            { itemid = xi.item.SHEET_OF_KUROGANE,               droprate =   3 },
            { itemid = xi.item.PLAITED_CORD,                    droprate =   3 },
            { itemid = xi.item.POT_OF_EBONY_LACQUER,            droprate =   3 },
            { itemid = xi.item.SHEET_OF_COBALT_MYTHRIL,         droprate =   3 },
            { itemid = xi.item.BLUE_RIVET,                      droprate =   3 },
            { itemid = xi.item.SPOOL_OF_GLITTERING_YARN,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ASTRAL_LEATHER,        droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LUMINIAN_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_FLAMESHUN_CLOTH,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SILKWORM_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CANVAS_TOILE,          droprate =   3 },
            { itemid = xi.item.PANTIN_WIRE,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CORDUROY_CLOTH,        droprate =   3 },
            { itemid = xi.item.PIECE_OF_ANGEL_SKIN,             droprate =   3 },
            { itemid = xi.item.LOCK_OF_SIRENS_HAIR,             droprate =   3 },
            { itemid = xi.item.DIVINE_LOG,                      droprate =   3 },
            { itemid = xi.item.POT_OF_VIRIDIAN_URUSHI,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_KEJUSU_SATIN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ELTORO_LEATHER,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_GALATEIA,              droprate =   3 },
            { itemid = xi.item.DRAGON_BONE,                     droprate =   3 },
            { itemid = 1703,                                    droprate =   3 }, -- Kunwu Ore
        },
        -- Slot 8, Materials --
        {
            { itemid = xi.item.IRON_INGOT,                      droprate =   5 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   5 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   5 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   5 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   5 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   5 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   5 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   5 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   5 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   5 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   5 },
            { itemid = xi.item.RAM_HORN,                        droprate =   5 },
            { itemid = xi.item.ELM_LOG,                         droprate =   5 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   5 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   5 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   5 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   5 },
            { itemid =  850,                                    droprate =   5 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   5 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   5 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   5 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   5 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   5 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   5 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   5 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   5 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   5 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   5 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   5 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   5 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   5 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   5 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   5 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   5 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   5 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   5 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   5 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   5 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   5 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   5 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   5 },
            { itemid = xi.item.IMP_HORN,                        droprate =   5 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   5 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   5 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   5 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   5 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   5 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   5 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   5 },
            { itemid = 1225,                                    droprate =   5 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   5 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   5 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   5 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   5 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   5 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   5 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   5 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   5 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   5 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   5 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   5 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   5 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   5 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   5 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   5 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   5 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   5 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   5 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   5 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   5 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   5 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   5 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   5 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   5 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   5 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   5 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   5 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   5 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   5 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   5 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   5 },
            { itemid = 2151,                                    droprate =   5 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   5 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   5 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   5 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   5 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   5 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   5 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   5 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   5 }, -- Water Anima
            { itemid = 1647,                                    droprate =   5 }, -- Light Anima
            { itemid = 1648,                                    droprate =   5 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   5 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   5 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   5 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   5 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   5 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   5 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   5 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   5 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   5 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   5 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   5 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   5 },
            { itemid =  734,                                    droprate =   5 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   5 }, -- Amphiptere Hide
            { itemid = 2164,                                    droprate =   5 }, -- Pephredo Hive Chip
            { itemid = 1279,                                    droprate =   5 }, -- Taffeta Cloth
            { itemid = 1280,                                    droprate =   5 }, -- Sarcenet Cloth
            { itemid = 1281,                                    droprate =   5 }, -- Cheviot Cloth
            { itemid = 1295,                                    droprate =   5 }, -- Twincoon
            { itemid = 1270,                                    droprate =   5 }, -- Arachne Web
            { itemid =  647,                                    droprate =   5 }, -- Molybdenum Ore
            { itemid = 1271,                                    droprate =   5 }, -- Pigeon's Blood Ruby
            { itemid = 1276,                                    droprate =   5 }, -- Tarasque Skin
            { itemid = 1296,                                    droprate =   5 }, -- Yowie Skin
            { itemid = 1277,                                    droprate =   5 }, -- Lindwurm Skin
            { itemid = 1765,                                    droprate =   5 }, -- Habu Skin
            { itemid = 2828,                                    droprate =   5 }, -- Herensugue Skin
            { itemid = 2837,                                    droprate =   5 }, -- Ratatoskr Pelt
            { itemid = 2839,                                    droprate =   5 }, -- Coquecigrue Skin
            { itemid = 2830,                                    droprate =   5 }, -- Bastet Fang
            { itemid = 2833,                                    droprate =   5 }, -- Thunder Coral
            { itemid = 1272,                                    droprate =   5 }, -- Arioch Fang
            { itemid = 1273,                                    droprate =   5 }, -- Namtar Bone
            { itemid = 2849,                                    droprate =   5 }, -- Likho Talon
            { itemid = 2846,                                    droprate =   5 }, -- Hefty Oak Lumber
            { itemid = 2855,                                    droprate =   5 }, -- Mahogany Heartwood
            { itemid = xi.item.CHUNK_OF_FIRE_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_ICE_ORE,                droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WIND_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_EARTH_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHTNING_ORE,          droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WATER_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHT_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_DARK_ORE,               droprate =   3 },
            { itemid = xi.item.CLUMP_OF_IMPERIAL_TEA_LEAVES,    droprate =   4 },
            { itemid = xi.item.DRAGON_FRUIT,                    droprate =   4 },
            { itemid = xi.item.WALNUT,                          droprate =   4 },
            { itemid = xi.item.BOWL_OF_AMBROSIA,                droprate =   4 },
            { itemid = xi.item.BOTTLE_OF_AMRITA,                droprate =   4 },
            { itemid = xi.item.DRAGON_HEART,                    droprate =   3 },
            { itemid = xi.item.HANDFUL_OF_DRAGON_SCALES,        droprate =   3 },
            { itemid = xi.item.SLICE_OF_DRAGON_MEAT,            droprate =   3 },
            { itemid = xi.item.CHUNK_OF_HYDRA_MEAT,             droprate =   3 },
            { itemid = xi.item.SLICE_OF_CERBERUS_MEAT,          droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HIDE,                   droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HORN,                   droprate =   3 },
            { itemid = 2158,                                    droprate =   3 }, -- Hydra Fang
            { itemid = 2172,                                    droprate =   3 }, -- Hydra Scale
            { itemid = 2168,                                    droprate =   3 }, -- Cerberus Claw
            { itemid = 2169,                                    droprate =   3 }, -- Cerberus Hide
            { itemid = 2371,                                    droprate =   3 }, -- Khimaira Horn
            { itemid = 2372,                                    droprate =   3 }, -- Khimaira Mane
            { itemid = 2373,                                    droprate =   3 }, -- Khimaira Tail
            { itemid = 4273,                                    droprate =   3 }, -- Kitron
            { itemid = 1718,                                    droprate =   3 }, -- M-bugard Tusk
            { itemid = 1719,                                    droprate =   3 }, -- Harajnite Shell
            { itemid = xi.item.SQUARE_OF_ECARLATE_CLOTH,        droprate =   3 },
            { itemid = xi.item.ARGYRO_RIVET,                    droprate =   3 },
            { itemid = xi.item.UTOPIAN_GOLD_THREAD,             droprate =   3 },
            { itemid = xi.item.ANCIENT_BRASS_INGOT,             droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BENEDICT_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_BENEDICT_YARN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_DIABOLIC_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_DIABOLIC_YARN,          droprate =   3 },
            { itemid = xi.item.SPOOL_OF_RUBY_SILK_THREAD,       droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CARDINAL_CLOTH,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SUPPLE_SKIN,           droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LIGHT_FILAMENT,         droprate =   3 },
            { itemid = xi.item.CHUNK_OF_SNOWY_CERMET,           droprate =   3 },
            { itemid = xi.item.WHITE_RIVET,                     droprate =   3 },
            { itemid = xi.item.DARK_ORICHALCUM_INGOT,           droprate =   3 },
            { itemid = xi.item.BLACK_RIVET,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SMALT_LEATHER,         droprate =   3 },
            { itemid = xi.item.FETID_LANOLIN_CUBE,              droprate =   3 },
            { itemid = xi.item.SPOOL_OF_COILED_YARN,            droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BROWN_DOESKIN,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_CHAMELEON_YARN,         droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CHARCOAL_COTTON,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SCARLET_ODOSHI,         droprate =   3 },
            { itemid = xi.item.SHEET_OF_KUROGANE,               droprate =   3 },
            { itemid = xi.item.PLAITED_CORD,                    droprate =   3 },
            { itemid = xi.item.POT_OF_EBONY_LACQUER,            droprate =   3 },
            { itemid = xi.item.SHEET_OF_COBALT_MYTHRIL,         droprate =   3 },
            { itemid = xi.item.BLUE_RIVET,                      droprate =   3 },
            { itemid = xi.item.SPOOL_OF_GLITTERING_YARN,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ASTRAL_LEATHER,        droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LUMINIAN_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_FLAMESHUN_CLOTH,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SILKWORM_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CANVAS_TOILE,          droprate =   3 },
            { itemid = xi.item.PANTIN_WIRE,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CORDUROY_CLOTH,        droprate =   3 },
            { itemid = xi.item.PIECE_OF_ANGEL_SKIN,             droprate =   3 },
            { itemid = xi.item.LOCK_OF_SIRENS_HAIR,             droprate =   3 },
            { itemid = xi.item.DIVINE_LOG,                      droprate =   3 },
            { itemid = xi.item.POT_OF_VIRIDIAN_URUSHI,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_KEJUSU_SATIN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ELTORO_LEATHER,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_GALATEIA,              droprate =   3 },
            { itemid = xi.item.DRAGON_BONE,                     droprate =   3 },
            { itemid = 1703,                                    droprate =   3 }, -- Kunwu Ore
        },
        -- Slot 5, Misc/Medicine --
        {
            { itemid = xi.item.VILE_ELIXIR,                     droprate = 150 },
            { itemid = 4149,                                    droprate = 150 }, -- Panacea
            { itemid = xi.item.VILE_ELIXIR_P1,                  droprate = 140 },
            { itemid = xi.item.HI_RERAISER,                     droprate = 140 },
            { itemid = xi.item.REMEDY,                          droprate = 140 },
            { itemid = xi.item.ICARUS_WING,                     droprate = 140 },
            { itemid = xi.item.SUPER_RERAISER,                  droprate = 140 },
        },
        -- Slot 9, Misc/Medicine --
        {
            { itemid = xi.item.VILE_ELIXIR,                     droprate = 150 },
            { itemid = 4149,                                    droprate = 150 }, -- Panacea
            { itemid = xi.item.VILE_ELIXIR_P1,                  droprate = 140 },
            { itemid = xi.item.HI_RERAISER,                     droprate = 140 },
            { itemid = xi.item.REMEDY,                          droprate = 140 },
            { itemid = xi.item.ICARUS_WING,                     droprate = 140 },
            { itemid = xi.item.SUPER_RERAISER,                  droprate = 140 },
        },
    },
    [120] =
    {   -- Slot 1, Currency --
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate = 100 },
            { itemid = xi.item.LINEN_COIN_PURSE,                droprate = 100 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =  90 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =  90 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =  90 },
            { itemid =  6541,                                   droprate =  90 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  90 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  90 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  90 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  90 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter            
        },
        -- Slot 6, Currency
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate =  90 },
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  60 },
            { itemid = xi.item.LINEN_COIN_PURSE,                droprate = 100 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =  90 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =  90 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =  90 },
            { itemid =  6541,                                   droprate =  80 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  80 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  80 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  80 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  80 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter
        },
        -- Slot 10, Tatters --
        {
            { itemid =  3283,                                   droprate = 125 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate = 125 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate = 125 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate = 125 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate = 125 }, -- Martial Tatter
            { itemid =  3279,                                   droprate = 125 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate = 125 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate = 125 }, -- Wyrmal Tatter
        },
        -- Slot 2, Pop Items
        {
            { itemid = 1404,                                    droprate =  15 }, -- Genbu Seal
            { itemid = 1405,                                    droprate =  15 }, -- Seiryu Seal
            { itemid = 1406,                                    droprate =  15 }, -- Byakko Seal
            { itemid = 1407,                                    droprate =  15 }, -- Suzaku Seal
            { itemid = xi.item.IVORY_CHIP,                      droprate =  20 },
            { itemid = xi.item.SCARLET_CHIP,                    droprate =  20 },
            { itemid = xi.item.EMERALD_CHIP,                    droprate =  20 },
            { itemid = xi.item.SILVER_CHIP,                     droprate =  20 },
            { itemid = xi.item.CERULEAN_CHIP,                   droprate =  20 },
            { itemid = 1986,                                    droprate =  20 }, -- Orchid Chip
            { itemid = xi.item.SMALT_CHIP,                      droprate =  20 },
            { itemid = xi.item.SMOKY_CHIP,                      droprate =  20 },
            { itemid = 1987,                                    droprate =  20 }, -- Charcoal Chip
            { itemid = 1988,                                    droprate =  20 }, -- Magenta Chip
            { itemid = xi.item.FIRST_VIRTUE,                    droprate =  20 },
            { itemid =  1853,                                   droprate =  20 }, -- Second Virtue
            { itemid = xi.item.THIRD_VIRTUE,                    droprate =  20 },
            { itemid =  1848,                                   droprate =  20 }, -- Fourth Virtue
            { itemid =  1847,                                   droprate =  20 }, -- Fifth Virtue
            { itemid =  1849,                                   droprate =  20 }, -- Sxith Virtue
            { itemid = xi.item.HELLCAGE_BUTTERFLY,              droprate =  20 },
            { itemid = xi.item.JUG_OF_FLORAL_NECTAR,            droprate =  20 },
            { itemid = xi.item.WEDGE_OF_RODENT_CHEESE,          droprate =  20 },
            { itemid = xi.item.CLUMP_OF_SHADELEAVES,            droprate =  20 },
            { itemid = xi.item.BEAKER_OF_PECTIN,                droprate =  20 },
            { itemid = xi.item.FLASK_OF_COG_LUBRICANT,          droprate =  20 },
            { itemid = xi.item.GOLDEN_TEETH,                    droprate =  20 },
            { itemid = xi.item.GREENLING,                       droprate =  20 },
            { itemid = xi.item.BOTTLE_OF_SPOILT_BLOOD,          droprate =  20 },
            { itemid = xi.item.BUNCH_OF_SENORITA_PAMAMAS,       droprate =  20 },
            { itemid = xi.item.JAR_OF_OILY_BLOOD,               droprate =  20 },
            { itemid = xi.item.STRAND_OF_SAMARIRI_CORPSEHAIR,   droprate =  20 },
            { itemid = xi.item.SLAB_OF_RAW_BUFFALO,             droprate =  20 },
            { itemid = xi.item.LUMP_OF_BONE_CHARCOAL,           droprate =  20 },
            { itemid = xi.item.PINCH_OF_GRANULATED_SUGAR,       droprate =  20 },
            { itemid = xi.item.MINT_DROP,                       droprate =  20 },
            { itemid = xi.item.OPALUS_GEM,                      droprate =  20 },
            { itemid = xi.MERROW_NO_11_MOLTING,                 droprate =  20 },
            { itemid = xi.BAR_OF_FERRITE,                       droprate =  20 },
            { itemid = xi.BAGGED_SHEEP_BOTFLY,                  droprate =  20 },
            { itemid = xi.OLZHIRYAN_CACTUS_PADDLE,              droprate =  20 },
            { itemid = xi.VIAL_OF_PURE_BLOOD,                   droprate =  20 },
            { itemid = xi.VINEGAR_PIE,                          droprate =  20 },
            { itemid = xi.JAR_OF_ROCK_JUICE,                    droprate =  20 },
            { itemid = xi.BOUND_EXORCISM_TREATISE,              droprate =  20 },
            { itemid = xi.CLUMP_OF_MYRRH,                       droprate =  20 },
            { itemid = xi.WHOLE_ROSE_SCAMPI,                    droprate =  20 },
            { itemid = xi.JUG_OF_MONKEY_WINE,                   droprate =  20 },
            { itemid = xi.CHUNK_OF_BUFFALO_CORPSE,              droprate =  20 },
            { itemid = xi.CHUNK_OF_SINGED_BUFFALO,              droprate =  20 },
            { itemid = xi.PANDEMONIUM_KEY,                      droprate =  20 },
        },
        -- Slot 3, Equipment --
        {
            { itemid = xi.item.DUENDE_COTEHARDIE,               droprate =   4 },
            { itemid = xi.item.NOKIZARU_GI,                     droprate =   4 },
            { itemid = xi.item.RAPPAREE_HARNESS,                droprate =   4 },
            { itemid = xi.item.SHINIMUSHA_HARA_ATE,             droprate =   4 },
            { itemid = xi.item.WYVERN_MAIL,                     droprate =   4 },
            { itemid = xi.item.SHIKAREE_AKETON,                 droprate =   4 },
            { itemid = xi.item.CERISE_DOUBLET,                  droprate =   4 },
            { itemid = xi.item.GLAMOR_JUPON,                    droprate =   4 },
            { itemid = xi.item.GLOOM_BREASTPLATE,               droprate =   4 },
            { itemid = xi.item.NIMBUS_DOUBLET,                  droprate =   4 },
            { itemid = xi.item.AIKIDO_GI,                       droprate =   4 },
            { itemid = xi.item.PARADE_CUIRASS,                  droprate =   4 },
            { itemid = xi.item.GAUDY_HARNESS,                   droprate =   4 },
            { itemid = xi.item.HAMAYUMI,                        droprate =   5 },
            { itemid = xi.item.DIA_WAND,                        droprate =   4 },
            { itemid = xi.item.STONE_GORGET,                    droprate =   5 },
            { itemid =  18359,                                  droprate =   5 }, -- Boreas Cesti
            { itemid =  15468,                                  droprate =   5 }, -- Resentment Cape
            { itemid =  xi.item.GOTHIC_SABATONS,                droprate =   5 },
            { itemid =  xi.item.GOTHIC_GAUNTLETS,               droprate =   5 },
            { itemid =  16187,                                  droprate =   5 }, -- Adoubeurs Pavise
            { itemid =  16899,                                  droprate =   5 }, -- Hototogisu
            { itemid =  16374,                                  droprate =   5 }, -- Layqa Seraweels
            { itemid =  17199,                                  droprate =   5 }, -- Loxley Bow
            { itemid =  16882,                                  droprate =   5 }, -- Calamar
            { itemid =  17504,                                  droprate =   5 }, -- Pagures
            { itemid =  16884,                                  droprate =   5 }, -- Narval
            { itemid =  17503,                                  droprate =   5 }, -- Exocets
            { itemid =  19238,                                  droprate =   5 }, -- Jasper Tathlum
            { itemid =  11404,                                  droprate =   5 }, -- Promptitude Solea
            { itemid =  15897,                                  droprate =   5 }, -- Grace Corset
            { itemid =  13803,                                  droprate =   5 }, -- Shaman's Cloak
            { itemid =  19237,                                  droprate =   5 }, -- Slick Dart
            { itemid =  15942,                                  droprate =   5 }, -- Summoning Belt
            { itemid =  xi.item.MUSHROOM_HELM,                  droprate =   2 },
            { itemid =  xi.item.LUNA_SUBLIGAR,                  droprate =   2 },
            { itemid =  16980,                                  droprate =   5 }, -- Sukesada
            { itemid =  13912,                                  droprate =   5 }, -- Shadow Mask
            { itemid =  16943,                                  droprate =   5 }, -- Ascalon
            { itemid =  14063,                                  droprate =   5 }, -- Protecting Bangles
            { itemid =  14064,                                  droprate =   5 }, -- Sand Gloves
            { itemid =  17651,                                  droprate =   5 }, -- Dainslaif
            { itemid =  17924,                                  droprate =   5 }, -- Tungi
            { itemid =  16734,                                  droprate =   5 }, -- Pendragon Axe
            { itemid =  15995,                                  droprate =   5 }, -- Carline Earring
            { itemid =  16127,                                  droprate =   5 }, -- Carline Ribbon
            { itemid =  16125,                                  droprate =   5 }, -- Breeder Mask
            { itemid =  15001,                                  droprate =   5 }, -- Breeder Mufflers
            { itemid =  15946,                                  droprate =   5 }, -- Tempest Belt
            { itemid =  11405,                                  droprate =   5 }, -- Kyoshu Kyahan
            { itemid =  11533,                                  droprate =   5 }, -- Lyricist's Gonnelle
            { itemid =  16298,                                  droprate =   5 }, -- Knack Pendant
            { itemid =  17454,                                  droprate =   5 }, -- Asklepios
            { itemid =  17455,                                  droprate =   5 }, -- Skirnir's Wand
            { itemid =  16912,                                  droprate =   5 }, -- Kitsutsuki
            { itemid =  17926,                                  droprate =   5 }, -- Acha D'Armas
            { itemid =  17982,                                  droprate =   5 }, -- Kard
            { itemid =  17983,                                  droprate =   5 }, -- Valiant Knife
            { itemid =  18042,                                  droprate =   5 }, -- Ascention
            { itemid =  17563,                                  droprate =   5 }, -- Power Staff
            { itemid =  17969,                                  droprate =   5 }, -- Fendoir
            { itemid =  18608,                                  droprate =   5 }, -- Atesh Pole
            { itemid =  16727,                                  droprate =   5 }, -- Eisentaenzer
            { itemid =  17971,                                  droprate =   5 }, -- Tartaglia
            { itemid =  19235,                                  droprate =   5 }, -- Veuglaire
            { itemid =  16375,                                  droprate =   5 }, -- Surge Subligar
            { itemid =  xi.item.ASTRAL_ASPIS,                   droprate =   5 },
            { itemid =  xi.item.GAE_BOLG,                       droprate =   5 },
            { itemid =  xi.item.LOHAR,                          droprate =   5 },
            { itemid =   19122,                                 droprate =   5 }, -- Courser's Pugio
            { itemid =   16081,                                 droprate =   5 }, -- Curate's Hat
            { itemid =   15882,                                 droprate =   5 }, -- Othinus' Bow
            { itemid =   17244,                                 droprate =   5 }, -- Storm Belt
            { itemid =   14806,                                 droprate =   5 }, -- Intruder Earring
            { itemid =   14466,                                 droprate =   5 }, -- Fomor Tunic
            { itemid =   18007,                                 droprate =   5 }, -- Chiroptera Dagger
            { itemid =   17510,                                 droprate =   5 }, -- Vampiric Claws
            { itemid =   14763,                                 droprate =   5 }, -- Boroka Earring
            { itemid =   13178,                                 droprate =   5 }, -- Auditory Torque
            { itemid =   15943,                                 droprate =   5 }, -- Virtuoso Belt
            { itemid =   14884,                                 droprate =   5 }, -- Mycophile Cuffs
            { itemid =   17794,                                 droprate =   5 }, -- Niokiyotsuna
            { itemid =   15219,                                 droprate =   5 }, -- Sinister Mask
            { itemid =   16368,                                 droprate =   5 }, -- Herder's Subligar
            { itemid =   14724,                                 droprate =   5 }, -- Moldavite Earring
            { itemid =   16279,                                 droprate =   5 }, -- Pile Chain
            { itemid =   15546,                                 droprate =   5 }, -- Fasting Ring
            { itemid =   16299,                                 droprate =   5 }, -- Lleu's Charm
            { itemid =   11496,                                 droprate =   5 }, -- Fenrir's Crown
            { itemid =   14168,                                 droprate =   5 }, -- Dune Boots
            { itemid =   17854,                                 droprate =   5 }, -- Cradle Horn
            { itemid =   19239,                                 droprate =   5 }, -- Astrolable
            { itemid =   16169,                                 droprate =   5 }, -- Caballero Shield
            { itemid =   17653,                                 droprate =   5 }, -- Hrotti
            { itemid =   18027,                                 droprate =   5 }, -- Palladium Dagger
            { itemid =   17564,                                 droprate =   5 }, -- Cocytus Pole
            { itemid =   16426,                                 droprate =   5 }, -- Avengers
            { itemid =   19121,                                 droprate =   5 }, -- Sleight Kukri
            { itemid =   15944,                                 droprate =   7 }, -- Selemnus Belt
            { itemid =   16297,                                 droprate =   7 }, -- Shepherd's Chain
            { itemid =  xi.item.KAMEWARI,                       droprate =   5 },
            { itemid =  xi.item.NADRS,                          droprate =   5 },
            { itemid =  xi.item.ALTDORFS_EARRING,               droprate =   5 },
            { itemid =  xi.item.WILHELMS_EARRING,               droprate =   5 },
            { itemid =  xi.item.HELENUSS_EARRING,               droprate =   5 },
            { itemid =  xi.item.CASSANDRAS_EARRING,             droprate =   5 },
            { itemid =  xi.item.MINSTRELS_DAGGER,               droprate =   5 },
            { itemid =  xi.item.SAND_CHARM,                     droprate =   5 },
            { itemid =   15692,                                 droprate =   5 }, -- Storm Crackows
            { itemid =   14669,                                 droprate =   5 }, -- Jaeger Ring
            { itemid =   15351,                                 droprate =   5 }, -- Bounding Boots
            { itemid =   18018,                                 droprate =   5 }, -- Sirocco Kukri
            { itemid =   13567,                                 droprate =   5 }, -- Bomb Queen Ring
            { itemid =   15547,                                 droprate =   5 }, -- Vilma's Ring
            { itemid =   26164,                                 droprate =   5 }, -- Caliber Ring
            { itemid =   15183,                                 droprate =   7 }, -- Dobson Bandana
            { itemid =   15184,                                 droprate =   7 }, -- Voyager Sallet
            { itemid =   14986,                                 droprate =   7 }, -- Ochimusha Kote
            { itemid =   15737,                                 droprate =   7 }, -- Sarutobi Kyahan
            { itemid =   15551,                                 droprate =   7 }, -- Shikaree Ring
            { itemid =  xi.item.EMPRESS_HAIRPIN,                droprate =   7 },
            { itemid =  xi.item.JOYEUSE,                        droprate =   7 },
            { itemid =  xi.item.DRYAD_STAFF,                    droprate =   7 },
            { itemid =  xi.item.VALIS_BOW,                      droprate =   7 },
            { itemid =  xi.item.RETALIATORS,                    droprate =   7 },
            { itemid =  xi.item.UNGUR_BOOMERANG,                droprate =   7 },
            { itemid =   15515,                                 droprate =   7 }, -- Peacock Amulet
            { itemid =  xi.item.TROTTER_BOOTS,                  droprate =   7 },
            { itemid =   19236,                                 droprate =   7 }, -- Hightail Bullet
            { itemid =   17192,                                 droprate =   7 }, -- Ifrit's Bow
            { itemid =   17711,                                 droprate =   7 }, -- Shiva's Shotel
            { itemid =   18021,                                 droprate =   7 }, -- Titan's Baselarde
            { itemid =   18063,                                 droprate =   7 }, -- Garuda's Sickle
            { itemid =   18109,                                 droprate =   7 }, -- Leviathan's Couse
            { itemid =   18404,                                 droprate =   7 }, -- Ramuh's Mace
            { itemid =   18581,                                 droprate =   7 }, -- Carbuncle's Pole
            { itemid =   14931,                                 droprate =   7 }, -- Carbuncle's Cuffs
            { itemid =   18422,                                 droprate =   7 }, -- Ryumon
            { itemid =   14960,                                 droprate =   7 }, -- Evoker's Gages
            { itemid =   19277,                                 droprate =   7 }, -- Tsugumi
            { itemid =   11408,                                 droprate =   7 }, -- Morana Pigaches
            { itemid =   11409,                                 droprate =   7 }, -- Aoide's Pumps
            { itemid =   16238,                                 droprate =   7 }, -- Taster's Cape
            { itemid =   11497,                                 droprate =   7 }, -- Spurrer Beret
            { itemid =   11406,                                 droprate =   7 }, -- Stimulus Sabots
            { itemid =   18767,                                 droprate =   6 }, -- Birdbanes
            { itemid =   15854,                                 droprate =   7 }, -- Sortie Ring
            { itemid =   15915,                                 droprate =   7 }, -- Sothic Rope
            { itemid =   11342,                                 droprate =   6 }, -- Restorer Cloak
            { itemid =   18770,                                 droprate =   7 }, -- Pygme Sainti
            { itemid =   17737,                                 droprate =   6 }, -- Corsair's Scimitar
            { itemid =   19124,                                 droprate =   7 }, -- Creve-coeur
            { itemid =   19279,                                 droprate =   7 }, -- Musanto
            { itemid =   17766,                                 droprate =   7 }, -- Lyft Scimitar
            { itemid =   17970,                                 droprate =   7 }, -- Lyft Tabar
            { itemid =   18508,                                 droprate =   7 }, -- Lyft Voulge
            { itemid =   18609,                                 droprate =   7 }, -- Lyft Pole
            { itemid =   18771,                                 droprate =   7 }, -- Lyft Sainti
            { itemid =   18872,                                 droprate =   7 }, -- Lyft Ferule
            { itemid =   18958,                                 droprate =   7 }, -- Lyft Scythe
            { itemid =   19125,                                 droprate =   7 }, -- Lyft Jambiya
            { itemid =   19161,                                 droprate =   7 }, -- Lyft Claymore
            { itemid =   19233,                                 droprate =   7 }, -- Lyft Crossbow
            { itemid =   19306,                                 droprate =   7 }, -- Lyft Lance
            { itemid =  xi.item.LAVAS_RING,                     droprate =   7 },
            { itemid =  xi.item.KUSHAS_RING,                    droprate =   7 },
            { itemid =  xi.item.NASATYAS_RING,                  droprate =   7 },
            { itemid =  xi.item.DASRAS_RING,                    droprate =   7 },
            { itemid =  xi.item.HOPE_STAFF,                     droprate =   7 },
            { itemid =  xi.item.JUSTICE_SWORD,                  droprate =   7 },
            { itemid =  xi.item.TEMPERANCE_AXE,                 droprate =   7 },
            { itemid =  xi.item.LOVE_HALBERD,                   droprate =   7 },
            { itemid =  xi.item.FORTITUDE_AXE,                  droprate =   7 },
            { itemid =  xi.item.FAITH_BAGHNAKHS,                droprate =   7 },
            { itemid =  xi.item.PRUDENCE_ROD,                   droprate =   7 },
            { itemid =  xi.item.BYAKKOS_AXE,                    droprate =   8 },
            { itemid =  xi.item.SUZAKUS_SCYTHE,                 droprate =   8 },
            { itemid =  xi.item.SEIRYUS_SWORD,                  droprate =   8 },
        },
        -- Slot 7, Equipment --
        {
            { itemid =  5681,                                   droprate =   4 }, -- Cupid Chocolate
            { itemid = xi.item.GENBUS_KABUTO,                   droprate =   6 },
            { itemid = xi.item.GENBUS_SHIELD,                   droprate =   6 },
            { itemid = xi.item.SEIRYUS_KOTE,                    droprate =   6 },
            { itemid = xi.item.SUZAKUS_SUNE_ATE,                droprate =   6 },
            { itemid = xi.item.BYAKKOS_HAIDATE,                 droprate =   6 },
            { itemid = xi.item.ANIMATOR_P1,                     droprate =   5 },
            { itemid = 17567,                                   droprate =   5 }, -- Kirin's Pole
            { itemid = 12562,                                   droprate =   5 }, -- Kirin's Osode
            { itemid = 16034,                                   droprate =   5 }, -- Sarabande Earring
            { itemid = 13415,                                   droprate =   5 }, -- Pixie Earring
            { itemid = 16300,                                   droprate =   5 }, -- Wit Pendant
            { itemid = 16303,                                   droprate =   5 }, -- Laran's Pendant
            { itemid = 15057,                                   droprate =   5 }, -- Bricta's Cuffs
            { itemid = 14943,                                   droprate =   5 }, -- Barbarossa's Moufles
            { itemid = 16376,                                   droprate =   5 }, -- Bahram Cuisses
            { itemid = 16302,                                   droprate =   5 }, -- Bloodbead Gorget
            { itemid = 11411,                                   droprate =   5 }, -- Shrewd Pumps
            { itemid = 15223,                                   droprate =   5 }, -- Ace's Helm
            { itemid = 18002,                                   droprate =   5 }, -- Perseu's Harp
            { itemid = 14873,                                   droprate =   5 }, -- Bandomusha Kote
            { itemid = 19280,                                   droprate =   5 }, -- Narigitsune
            { itemid = xi.item.WYRM_BEARD,                      droprate =   5 },
            { itemid = xi.item.BEHEMOTH_TONGUE,                 droprate =   5 },
            { itemid = xi.item.ADAMANTOISE_EGG,                 droprate =   5 },
            { itemid = xi.item.SEVENEYES,                       droprate =   5 },
            { itemid = xi.item.ALGOL,                           droprate =   5 },
            { itemid = 13658,                                   droprate =   5 }, -- Shadow Mantle
            { itemid = 14646,                                   droprate =   5 }, -- Shadow Ring
            { itemid = 11589,                                   droprate =   5 }, -- Aesir Torque
            { itemid = 16057,                                   droprate =   5 }, -- Aesir Ear Pendant
            { itemid = 11546,                                   droprate =   5 }, -- Aesir Mantle
            { itemid = 11547,                                   droprate =   5 }, -- Colossus's Mantle
            { itemid = 11590,                                   droprate =   5 }, -- Colossus's Torque
            { itemid = 16058,                                   droprate =   5 }, -- Colossus's Earring
            { itemid = 18019,                                   droprate =   5 }, -- X's Knife
            { itemid = 18057,                                   droprate =   5 }, -- Y's Scythe
            { itemid = 18101,                                   droprate =   5 }, -- Z's Trident
            { itemid = 15899,                                   droprate =   5 }, -- Velocious Belt
            { itemid = 15617,                                   droprate =   5 }, -- Barbarossa's Zerehs
            { itemid = 17586,                                   droprate =   5 }, -- Mercurial Pole
            { itemid = xi.item.JUSTICE_TORQUE,                  droprate =   5 },
            { itemid = xi.item.HOPE_TORQUE,                     droprate =   5 },
            { itemid = xi.item.PRUDENCE_TORQUE,                 droprate =   5 },
            { itemid = xi.item.FORTITUDE_TORQUE,                droprate =   5 },
            { itemid = xi.item.FAITH_TORQUE,                    droprate =   5 },
            { itemid = xi.item.TEMPERANCE_TORQUE,               droprate =   5 },
            { itemid = xi.item.LOVE_TORQUE,                     droprate =   5 },
            { itemid = xi.item.RIDILL,                          droprate =   5 },
            { itemid = xi.item.OCTAVE_CLUB,                     droprate =   5 },
            { itemid = xi.item.HAUTECLAIRE,                     droprate =   5 },
            { itemid = 13566,                                   droprate =   3 }, -- Defending Ring
            { itemid = 27456,                                   droprate =   3 }, -- Crier's Gaiters
            { itemid = 14468,                                   droprate =   3 }, -- Yinyang Robe
            { itemid = 17754,                                   droprate =   5 }, -- Sylphid Epee
            { itemid = 16154,                                   droprate =   5 }, -- Karura Hachigane
            { itemid = 16000,                                   droprate =   5 }, -- Dragoon's Earring
            { itemid = 16240,                                   droprate =   5 }, -- Erato's Cape
            { itemid = 17755,                                   droprate =   5 }, -- Beast Slayer
            { itemid = 16340,                                   droprate =   5 }, -- Armadillo Cuisses
            { itemid = 17961,                                   droprate =   5 }, -- Lion Tamer
            { itemid = 15018,                                   droprate =   5 }, -- Ritterhentzes
            { itemid = 18859,                                   droprate =   5 }, -- Kerykeion
            { itemid = 16274,                                   droprate =   5 }, -- Almah Torque
            { itemid = 15999,                                   droprate =   5 }, -- Guignol Earring
            { itemid = 15916,                                   droprate =   5 }, -- Corsair's Belt
            { itemid = 18950,                                   droprate =   5 }, -- White Joker
            { itemid = 11369,                                   droprate =   5 }, -- Numerist Pumps
            { itemid = 11368,                                   droprate =   5 }, -- Hakke Habaki
            { itemid = 15827,                                   droprate =   5 }, -- Insect Ring
            { itemid = 15828,                                   droprate =   5 }, -- Blood Ring
            { itemid = 19154,                                   droprate =   5 }, -- Ferrara
            { itemid = 11366,                                   droprate =   5 }, -- Avocat Pigaches
            { itemid = 15017,                                   droprate =   5 }, -- Toad Mittens
            { itemid = 16339,                                   droprate =   5 }, -- Paddock Trousers
            { itemid = 16153,                                   droprate =   5 }, -- Reikyo Hairpin
            { itemid = 11367,                                   droprate =   5 }, -- Nobushi Kyahan
            { itemid = 19109,                                   droprate =   5 }, -- Trilling Dagger
            { itemid = 18448,                                   droprate =   5 }, -- Hacchonenbutsu
            { itemid = 19211,                                   droprate =   5 }, -- Reacton Arm
            { itemid = 19028,                                   droprate =   5 }, -- Magic Strap
            { itemid = 18127,                                   droprate =   5 }, -- Achilles' Spear
            { itemid = 16338,                                   droprate =   5 }, -- Ruby Seraweels
            { itemid = 18949,                                   droprate =   5 }, -- Zareehkl Scythe
            { itemid = 19108,                                   droprate =   5 }, -- Zareehkl Jambiya
            { itemid = 16239,                                   droprate =   5 }, -- Solitaire Cape
            { itemid = 16175,                                   droprate =   5 }, -- Muse Tariqah
            { itemid = 16152,                                   droprate =   5 }, -- Hissho Hachimaki
            { itemid = 16174,                                   droprate =   5 }, -- Riot Shield
            { itemid = 18126,                                   droprate =   4 }, -- Tomoe
            { itemid = xi.item.ORACLES_GLOVES,                  droprate =   4 },
            { itemid = xi.item.AURUM_SABATONS,                  droprate =   4 },
            { itemid = 19031,                                   droprate =   4 }, -- Fire Grip
            { itemid = 19032,                                   droprate =   4 }, -- Water Grip
            { itemid = 19033,                                   droprate =   4 }, -- Wind Grip
            { itemid = 19034,                                   droprate =   4 }, -- Ice Grip
            { itemid = 19035,                                   droprate =   4 }, -- Thunder Grip
            { itemid = 19036,                                   droprate =   4 }, -- Earth Grip
            { itemid = 19037,                                   droprate =   4 }, -- Light Grip
            { itemid = 19038,                                   droprate =   4 }, -- Dark Grip
            { itemid = xi.item.ENKIDUS_MITTENS,                 droprate =   4 },
            { itemid = xi.item.AURUM_CUISSES,                   droprate =   4 },
            { itemid = 19153,                                   droprate =   4 }, -- Naglering
            { itemid = 18125,                                   droprate =   4 }, -- Cletine
            { itemid = xi.item.ENKIDUS_SUBLIGAR,                droprate =   4 },
            { itemid = xi.item.ORACLES_PIGACHES,                droprate =   4 },
            { itemid = 17960,                                   droprate =   4 }, -- Labrys
            { itemid = xi.item.ENKIDUS_LEGGINGS,                droprate =   4 },
            { itemid = xi.item.AURUM_GAUNTLETS,                 droprate =   4 },
            { itemid = 16176,                                   droprate =   4 }, -- Simba Buckler
            { itemid = 17753,                                   droprate =   4 }, -- Organics
            { itemid = xi.item.ORACLES_BRACONI,                 droprate =   4 },
            { itemid = 16177,                                   droprate =   4 }, -- Legion Scutum
            { itemid = 18595,                                   droprate =   4 }, -- Mekki Shakki
            { itemid = 18430,                                   droprate =   4 }, -- Oninohocho
            { itemid = 18593,                                   droprate =   2 }, -- Alkalurops
            { itemid = xi.item.ENKIDUS_CAP,                     droprate =   3 },
            { itemid = xi.item.ENKIDUS_HARNESS,                 droprate =   3 },
            { itemid = xi.item.HACHIRYU_SUNE_ATE,               droprate =   3 },
            { itemid = xi.item.ORACLES_CAP,                     droprate =   3 },
            { itemid = 18429,                                   droprate =   3 }, -- Shusui
            { itemid = xi.item.AURUM_ARMET,                     droprate =   3 },
            { itemid = 18497,                                   droprate =   3 }, -- Foolkiller
            { itemid = xi.item.HACHIRYU_HAIDATE,                droprate =   3 },
            { itemid = xi.item.ORACLES_ROBE,                    droprate =   3 },
            { itemid = 18446,                                   droprate =   3 }, -- Pachipachio
            { itemid = 18857,                                   droprate =   3 }, -- Antares
            { itemid = xi.item.AURUM_CUIRASS,                   droprate =   3 },
            { itemid = xi.item.HACHIRYU_KOTE,                   droprate =   3 },
            { itemid = xi.item.HACHIRYU_HARAMAKI,               droprate =   2 },
            { itemid = 10754,                                   droprate =   3 }, -- Moepapa Ring
            { itemid = 10755,                                   droprate =   3 }, -- Moepapa Annulet
            { itemid = 10756,                                   droprate =   3 }, -- Tjukurrpa Ring
            { itemid = 10757,                                   droprate =   3 }, -- Tjukurrpa Annulet
            { itemid = 10759,                                   droprate =   3 }, -- Aife's Annulet
            { itemid = 10817,                                   droprate =   3 }, -- Moepapa Stone
            { itemid = 10818,                                   droprate =   3 }, -- Tjukurrpa Belt
            { itemid = 10932,                                   droprate =   3 }, -- Oneiros torque
            { itemid = 10933,                                   droprate =   3 }, -- Mujin necklace
            { itemid = 10940,                                   droprate =   3 }, -- Moepapa Pendant
            { itemid = 10941,                                   droprate =   3 }, -- Tjukurrpa Medal
            { itemid = 10942,                                   droprate =   3 }, -- Aife's Medal
            { itemid = 10943,                                   droprate =   3 }, -- Moepapa Medal
            { itemid = 10972,                                   droprate =   3 }, -- Oneiros cappa
            { itemid = 10973,                                   droprate =   3 }, -- Oneiros cape
            { itemid = 10974,                                   droprate =   3 }, -- Mujin mantle
            { itemid = 10983,                                   droprate =   3 }, -- Aife's Mantle
            { itemid = 10984,                                   droprate =   3 }, -- Tjukurrpa Mantle
            { itemid = 11030,                                   droprate =   3 }, -- Oneiros earring
            { itemid = 11032,                                   droprate =   3 }, -- Mujin Stud
            { itemid = 11031,                                   droprate =   3 }, -- Oneiros pearl
            { itemid = 11456,                                   droprate =   3 }, -- Ryuga Sune-Ate
            { itemid = 11461,                                   droprate =   3 }, -- Aife's Pumps
            { itemid = 11670,                                   droprate =   3 }, -- Oneiros annulet
            { itemid = 11671,                                   droprate =   3 }, -- Oneiros ring
            { itemid = 11672,                                   droprate =   3 }, -- Mujin band
            { itemid = 11772,                                   droprate =   3 }, -- Oneiros sash
            { itemid = 11773,                                   droprate =   3 }, -- Oneiros belt
            { itemid = 11774,                                   droprate =   3 }, -- Oneiros cest
            { itemid = 11775,                                   droprate =   3 }, -- Oneiros rope
            { itemid = 11776,                                   droprate =   3 }, -- Mujin obi
            { itemid = 11820,                                   droprate =   3 }, -- Khthonios Mask
            { itemid = 11821,                                   droprate =   3 }, -- Khthonios Helm
            { itemid = 11816,                                   droprate =   3 }, -- Oneiros helm
            { itemid = 11817,                                   droprate =   3 }, -- Oneiros barbut
            { itemid = 11818,                                   droprate =   3 }, -- Oneiros headgear
            { itemid = 11819,                                   droprate =   3 }, -- Oneiros coif 
            { itemid = 11923,                                   droprate =   3 }, -- Tjukurrpa Gauntlets
            { itemid = 11918,                                   droprate =   3 }, -- Khthonios Gloves
            { itemid = 11919,                                   droprate =   3 }, -- Avesta Bangles
            { itemid = 17069,                                   droprate =   3 }, -- Moepapa Mace
            { itemid = 17358,                                   droprate =   3 }, -- Oneiros Harp
            { itemid = 18519,                                   droprate =   3 }, -- Oneiros axe
            { itemid = 18541,                                   droprate =   3 }, -- Tjukurrpa Axe 
            { itemid = 18623,                                   droprate =   3 }, -- Chtonic Staff
            { itemid = 18811,                                   droprate =   3 }, -- Oneiros grip
            { itemid = 19141,                                   droprate =   3 }, -- Oneiros knife
            { itemid = 19295,                                   droprate =   3 }, -- Mujin tanto
            { itemid = 19738,                                   droprate =   3 }, -- Aife's Bow
            { itemid = 19762,                                   droprate =   3 }, -- Oneiros Tathlum  
            { itemid = 19763,                                   droprate =   3 }, -- Oneiros Cluster  
            { itemid = 19767,                                   droprate =   3 }, -- Oneiros pebble
            { itemid = 19790,                                   droprate =   3 }, -- Oneiros lance
            { itemid = xi.item.MURREY_GRISAILLE,                droprate =   1 },
            { itemid =    0,                                    droprate = 250 }, -- nothing
        },
        -- Slot 4, Materials --
        {
            { itemid = xi.item.IRON_INGOT,                      droprate =   5 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   5 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   5 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   5 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   5 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   5 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   5 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   5 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   5 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   5 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   5 },
            { itemid = xi.item.RAM_HORN,                        droprate =   5 },
            { itemid = xi.item.ELM_LOG,                         droprate =   5 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   5 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   5 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   5 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   5 },
            { itemid =  850,                                    droprate =   5 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   5 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   5 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   5 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   5 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   5 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   5 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   5 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   5 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   5 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   5 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   5 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   5 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   5 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   5 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   5 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   5 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   5 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   5 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   5 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   5 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   5 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   5 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   5 },
            { itemid = xi.item.IMP_HORN,                        droprate =   5 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   5 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   5 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   5 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   5 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   5 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   5 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   5 },
            { itemid = 1225,                                    droprate =   5 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   5 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   5 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   5 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   5 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   5 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   5 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   5 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   5 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   5 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   5 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   5 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   5 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   5 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   5 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   5 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   5 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   5 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   5 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   5 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   5 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   5 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   5 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   5 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   5 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   5 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   5 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   5 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   5 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   5 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   5 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   5 },
            { itemid = 2151,                                    droprate =   5 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   5 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   5 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   5 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   5 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   5 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   5 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   5 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   5 }, -- Water Anima
            { itemid = 1647,                                    droprate =   5 }, -- Light Anima
            { itemid = 1648,                                    droprate =   5 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   5 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   5 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   5 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   5 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   5 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   5 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   5 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   5 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   5 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   5 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   5 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   5 },
            { itemid =  734,                                    droprate =   5 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   5 }, -- Amphiptere Hide
            { itemid = 2164,                                    droprate =   5 }, -- Pephredo Hive Chip
            { itemid = 1279,                                    droprate =   5 }, -- Taffeta Cloth
            { itemid = 1280,                                    droprate =   5 }, -- Sarcenet Cloth
            { itemid = 1281,                                    droprate =   5 }, -- Cheviot Cloth
            { itemid = 1295,                                    droprate =   5 }, -- Twincoon
            { itemid = 1270,                                    droprate =   5 }, -- Arachne Web
            { itemid =  647,                                    droprate =   5 }, -- Molybdenum Ore
            { itemid = 1271,                                    droprate =   5 }, -- Pigeon's Blood Ruby
            { itemid = 1276,                                    droprate =   5 }, -- Tarasque Skin
            { itemid = 1296,                                    droprate =   5 }, -- Yowie Skin
            { itemid = 1277,                                    droprate =   5 }, -- Lindwurm Skin
            { itemid = 1765,                                    droprate =   5 }, -- Habu Skin
            { itemid = 2828,                                    droprate =   5 }, -- Herensugue Skin
            { itemid = 2837,                                    droprate =   5 }, -- Ratatoskr Pelt
            { itemid = 2839,                                    droprate =   5 }, -- Coquecigrue Skin
            { itemid = 2830,                                    droprate =   5 }, -- Bastet Fang
            { itemid = 2833,                                    droprate =   5 }, -- Thunder Coral
            { itemid = 1272,                                    droprate =   5 }, -- Arioch Fang
            { itemid = 1273,                                    droprate =   5 }, -- Namtar Bone
            { itemid = 2849,                                    droprate =   5 }, -- Likho Talon
            { itemid = 2846,                                    droprate =   5 }, -- Hefty Oak Lumber
            { itemid = 2855,                                    droprate =   5 }, -- Mahogany Heartwood
            { itemid = xi.item.CHUNK_OF_FIRE_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_ICE_ORE,                droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WIND_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_EARTH_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHTNING_ORE,          droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WATER_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHT_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_DARK_ORE,               droprate =   3 },
            { itemid = xi.item.CLUMP_OF_IMPERIAL_TEA_LEAVES,    droprate =   4 },
            { itemid = xi.item.DRAGON_FRUIT,                    droprate =   4 },
            { itemid = xi.item.WALNUT,                          droprate =   4 },
            { itemid = xi.item.BOWL_OF_AMBROSIA,                droprate =   4 },
            { itemid = xi.item.BOTTLE_OF_AMRITA,                droprate =   4 },
            { itemid = xi.item.DRAGON_HEART,                    droprate =   3 },
            { itemid = xi.item.HANDFUL_OF_DRAGON_SCALES,        droprate =   3 },
            { itemid = xi.item.SLICE_OF_DRAGON_MEAT,            droprate =   3 },
            { itemid = xi.item.CHUNK_OF_HYDRA_MEAT,             droprate =   3 },
            { itemid = xi.item.SLICE_OF_CERBERUS_MEAT,          droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HIDE,                   droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HORN,                   droprate =   3 },
            { itemid = 2158,                                    droprate =   3 }, -- Hydra Fang
            { itemid = 2172,                                    droprate =   3 }, -- Hydra Scale
            { itemid = 2168,                                    droprate =   3 }, -- Cerberus Claw
            { itemid = 2169,                                    droprate =   3 }, -- Cerberus Hide
            { itemid = 2371,                                    droprate =   3 }, -- Khimaira Horn
            { itemid = 2372,                                    droprate =   3 }, -- Khimaira Mane
            { itemid = 2373,                                    droprate =   3 }, -- Khimaira Tail
            { itemid = 4273,                                    droprate =   3 }, -- Kitron
            { itemid = 1718,                                    droprate =   3 }, -- M-bugard Tusk
            { itemid = 1719,                                    droprate =   3 }, -- Harajnite Shell
            { itemid = xi.item.SQUARE_OF_ECARLATE_CLOTH,        droprate =   3 },
            { itemid = xi.item.ARGYRO_RIVET,                    droprate =   3 },
            { itemid = xi.item.UTOPIAN_GOLD_THREAD,             droprate =   3 },
            { itemid = xi.item.ANCIENT_BRASS_INGOT,             droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BENEDICT_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_BENEDICT_YARN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_DIABOLIC_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_DIABOLIC_YARN,          droprate =   3 },
            { itemid = xi.item.SPOOL_OF_RUBY_SILK_THREAD,       droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CARDINAL_CLOTH,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SUPPLE_SKIN,           droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LIGHT_FILAMENT,         droprate =   3 },
            { itemid = xi.item.CHUNK_OF_SNOWY_CERMET,           droprate =   3 },
            { itemid = xi.item.WHITE_RIVET,                     droprate =   3 },
            { itemid = xi.item.DARK_ORICHALCUM_INGOT,           droprate =   3 },
            { itemid = xi.item.BLACK_RIVET,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SMALT_LEATHER,         droprate =   3 },
            { itemid = xi.item.FETID_LANOLIN_CUBE,              droprate =   3 },
            { itemid = xi.item.SPOOL_OF_COILED_YARN,            droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BROWN_DOESKIN,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_CHAMELEON_YARN,         droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CHARCOAL_COTTON,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SCARLET_ODOSHI,         droprate =   3 },
            { itemid = xi.item.SHEET_OF_KUROGANE,               droprate =   3 },
            { itemid = xi.item.PLAITED_CORD,                    droprate =   3 },
            { itemid = xi.item.POT_OF_EBONY_LACQUER,            droprate =   3 },
            { itemid = xi.item.SHEET_OF_COBALT_MYTHRIL,         droprate =   3 },
            { itemid = xi.item.BLUE_RIVET,                      droprate =   3 },
            { itemid = xi.item.SPOOL_OF_GLITTERING_YARN,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ASTRAL_LEATHER,        droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LUMINIAN_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_FLAMESHUN_CLOTH,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SILKWORM_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CANVAS_TOILE,          droprate =   3 },
            { itemid = xi.item.PANTIN_WIRE,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CORDUROY_CLOTH,        droprate =   3 },
            { itemid = xi.item.PIECE_OF_ANGEL_SKIN,             droprate =   3 },
            { itemid = xi.item.LOCK_OF_SIRENS_HAIR,             droprate =   3 },
            { itemid = xi.item.DIVINE_LOG,                      droprate =   3 },
            { itemid = xi.item.POT_OF_VIRIDIAN_URUSHI,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_KEJUSU_SATIN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ELTORO_LEATHER,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_GALATEIA,              droprate =   3 },
            { itemid = xi.item.DRAGON_BONE,                     droprate =   3 },
            { itemid = 1703,                                    droprate =   3 }, -- Kunwu Ore
        },
        -- Slot 8, Materials --
        {
            { itemid = xi.item.IRON_INGOT,                      droprate =   5 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   5 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   5 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   5 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   5 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   5 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   5 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   5 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   5 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   5 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   5 },
            { itemid = xi.item.RAM_HORN,                        droprate =   5 },
            { itemid = xi.item.ELM_LOG,                         droprate =   5 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   5 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   5 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   5 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   5 },
            { itemid =  850,                                    droprate =   5 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   5 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   5 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   5 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   5 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   5 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   5 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   5 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   5 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   5 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   5 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   5 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   5 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   5 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   5 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   5 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   5 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   5 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   5 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   5 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   5 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   5 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   5 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   5 },
            { itemid = xi.item.IMP_HORN,                        droprate =   5 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   5 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   5 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   5 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   5 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   5 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   5 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   5 },
            { itemid = 1225,                                    droprate =   5 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   5 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   5 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   5 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   5 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   5 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   5 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   5 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   5 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   5 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   5 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   5 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   5 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   5 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   5 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   5 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   5 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   5 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   5 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   5 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   5 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   5 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   5 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   5 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   5 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   5 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   5 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   5 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   5 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   5 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   5 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   5 },
            { itemid = 2151,                                    droprate =   5 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   5 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   5 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   5 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   5 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   5 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   5 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   5 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   5 }, -- Water Anima
            { itemid = 1647,                                    droprate =   5 }, -- Light Anima
            { itemid = 1648,                                    droprate =   5 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   5 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   5 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   5 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   5 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   5 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   5 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   5 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   5 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   5 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   5 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   5 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   5 },
            { itemid =  734,                                    droprate =   5 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   5 }, -- Amphiptere Hide
            { itemid = 2164,                                    droprate =   5 }, -- Pephredo Hive Chip
            { itemid = 1279,                                    droprate =   5 }, -- Taffeta Cloth
            { itemid = 1280,                                    droprate =   5 }, -- Sarcenet Cloth
            { itemid = 1281,                                    droprate =   5 }, -- Cheviot Cloth
            { itemid = 1295,                                    droprate =   5 }, -- Twincoon
            { itemid = 1270,                                    droprate =   5 }, -- Arachne Web
            { itemid =  647,                                    droprate =   5 }, -- Molybdenum Ore
            { itemid = 1271,                                    droprate =   5 }, -- Pigeon's Blood Ruby
            { itemid = 1276,                                    droprate =   5 }, -- Tarasque Skin
            { itemid = 1296,                                    droprate =   5 }, -- Yowie Skin
            { itemid = 1277,                                    droprate =   5 }, -- Lindwurm Skin
            { itemid = 1765,                                    droprate =   5 }, -- Habu Skin
            { itemid = 2828,                                    droprate =   5 }, -- Herensugue Skin
            { itemid = 2837,                                    droprate =   5 }, -- Ratatoskr Pelt
            { itemid = 2839,                                    droprate =   5 }, -- Coquecigrue Skin
            { itemid = 2830,                                    droprate =   5 }, -- Bastet Fang
            { itemid = 2833,                                    droprate =   5 }, -- Thunder Coral
            { itemid = 1272,                                    droprate =   5 }, -- Arioch Fang
            { itemid = 1273,                                    droprate =   5 }, -- Namtar Bone
            { itemid = 2849,                                    droprate =   5 }, -- Likho Talon
            { itemid = 2846,                                    droprate =   5 }, -- Hefty Oak Lumber
            { itemid = 2855,                                    droprate =   5 }, -- Mahogany Heartwood
            { itemid = xi.item.CHUNK_OF_FIRE_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_ICE_ORE,                droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WIND_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_EARTH_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHTNING_ORE,          droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WATER_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHT_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_DARK_ORE,               droprate =   3 },
            { itemid = xi.item.CLUMP_OF_IMPERIAL_TEA_LEAVES,    droprate =   4 },
            { itemid = xi.item.DRAGON_FRUIT,                    droprate =   4 },
            { itemid = xi.item.WALNUT,                          droprate =   4 },
            { itemid = xi.item.BOWL_OF_AMBROSIA,                droprate =   4 },
            { itemid = xi.item.BOTTLE_OF_AMRITA,                droprate =   4 },
            { itemid = xi.item.DRAGON_HEART,                    droprate =   3 },
            { itemid = xi.item.HANDFUL_OF_DRAGON_SCALES,        droprate =   3 },
            { itemid = xi.item.SLICE_OF_DRAGON_MEAT,            droprate =   3 },
            { itemid = xi.item.CHUNK_OF_HYDRA_MEAT,             droprate =   3 },
            { itemid = xi.item.SLICE_OF_CERBERUS_MEAT,          droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HIDE,                   droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HORN,                   droprate =   3 },
            { itemid = 2158,                                    droprate =   3 }, -- Hydra Fang
            { itemid = 2172,                                    droprate =   3 }, -- Hydra Scale
            { itemid = 2168,                                    droprate =   3 }, -- Cerberus Claw
            { itemid = 2169,                                    droprate =   3 }, -- Cerberus Hide
            { itemid = 2371,                                    droprate =   3 }, -- Khimaira Horn
            { itemid = 2372,                                    droprate =   3 }, -- Khimaira Mane
            { itemid = 2373,                                    droprate =   3 }, -- Khimaira Tail
            { itemid = 4273,                                    droprate =   3 }, -- Kitron
            { itemid = 1718,                                    droprate =   3 }, -- M-bugard Tusk
            { itemid = 1719,                                    droprate =   3 }, -- Harajnite Shell
            { itemid = xi.item.SQUARE_OF_ECARLATE_CLOTH,        droprate =   3 },
            { itemid = xi.item.ARGYRO_RIVET,                    droprate =   3 },
            { itemid = xi.item.UTOPIAN_GOLD_THREAD,             droprate =   3 },
            { itemid = xi.item.ANCIENT_BRASS_INGOT,             droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BENEDICT_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_BENEDICT_YARN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_DIABOLIC_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_DIABOLIC_YARN,          droprate =   3 },
            { itemid = xi.item.SPOOL_OF_RUBY_SILK_THREAD,       droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CARDINAL_CLOTH,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SUPPLE_SKIN,           droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LIGHT_FILAMENT,         droprate =   3 },
            { itemid = xi.item.CHUNK_OF_SNOWY_CERMET,           droprate =   3 },
            { itemid = xi.item.WHITE_RIVET,                     droprate =   3 },
            { itemid = xi.item.DARK_ORICHALCUM_INGOT,           droprate =   3 },
            { itemid = xi.item.BLACK_RIVET,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SMALT_LEATHER,         droprate =   3 },
            { itemid = xi.item.FETID_LANOLIN_CUBE,              droprate =   3 },
            { itemid = xi.item.SPOOL_OF_COILED_YARN,            droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BROWN_DOESKIN,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_CHAMELEON_YARN,         droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CHARCOAL_COTTON,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SCARLET_ODOSHI,         droprate =   3 },
            { itemid = xi.item.SHEET_OF_KUROGANE,               droprate =   3 },
            { itemid = xi.item.PLAITED_CORD,                    droprate =   3 },
            { itemid = xi.item.POT_OF_EBONY_LACQUER,            droprate =   3 },
            { itemid = xi.item.SHEET_OF_COBALT_MYTHRIL,         droprate =   3 },
            { itemid = xi.item.BLUE_RIVET,                      droprate =   3 },
            { itemid = xi.item.SPOOL_OF_GLITTERING_YARN,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ASTRAL_LEATHER,        droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LUMINIAN_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_FLAMESHUN_CLOTH,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SILKWORM_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CANVAS_TOILE,          droprate =   3 },
            { itemid = xi.item.PANTIN_WIRE,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CORDUROY_CLOTH,        droprate =   3 },
            { itemid = xi.item.PIECE_OF_ANGEL_SKIN,             droprate =   3 },
            { itemid = xi.item.LOCK_OF_SIRENS_HAIR,             droprate =   3 },
            { itemid = xi.item.DIVINE_LOG,                      droprate =   3 },
            { itemid = xi.item.POT_OF_VIRIDIAN_URUSHI,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_KEJUSU_SATIN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ELTORO_LEATHER,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_GALATEIA,              droprate =   3 },
            { itemid = xi.item.DRAGON_BONE,                     droprate =   3 },
            { itemid = 1703,                                    droprate =   3 }, -- Kunwu Ore
        },
        -- Slot 5, Misc/Medicine --
        {
            { itemid = xi.item.VILE_ELIXIR,                     droprate = 150 },
            { itemid = 4149,                                    droprate = 150 }, -- Panacea
            { itemid = xi.item.VILE_ELIXIR_P1,                  droprate = 140 },
            { itemid = xi.item.HI_RERAISER,                     droprate = 140 },
            { itemid = xi.item.REMEDY,                          droprate = 140 },
            { itemid = xi.item.ICARUS_WING,                     droprate = 140 },
            { itemid = xi.item.SUPER_RERAISER,                  droprate = 140 },
        },
        -- Slot 9, Misc/Medicine --
        {
            { itemid = xi.item.VILE_ELIXIR,                     droprate = 150 },
            { itemid = 4149,                                    droprate = 150 }, -- Panacea
            { itemid = xi.item.VILE_ELIXIR_P1,                  droprate = 140 },
            { itemid = xi.item.HI_RERAISER,                     droprate = 140 },
            { itemid = xi.item.REMEDY,                          droprate = 140 },
            { itemid = xi.item.ICARUS_WING,                     droprate = 140 },
            { itemid = xi.item.SUPER_RERAISER,                  droprate = 140 },
        },
    },
    [135] =
    {   -- Slot 1, Currency --
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate = 100 },
            { itemid = xi.item.LINEN_COIN_PURSE,                droprate = 100 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =  90 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =  90 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =  90 },
            { itemid =  6541,                                   droprate =  90 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  90 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  90 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  90 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  90 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter            
        },
        -- Slot 6, Currency
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate =  90 },
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  60 },
            { itemid = xi.item.LINEN_COIN_PURSE,                droprate = 100 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =  90 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =  90 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =  90 },
            { itemid =  6541,                                   droprate =  80 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  80 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  80 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  80 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  80 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter
        },
        -- Slot 10, Tatters --
        {
            { itemid =  3283,                                   droprate = 125 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate = 125 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate = 125 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate = 125 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate = 125 }, -- Martial Tatter
            { itemid =  3279,                                   droprate = 125 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate = 125 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate = 125 }, -- Wyrmal Tatter
        },
        -- Slot 2, Pop Items
        {
            { itemid = 1404,                                    droprate =  15 }, -- Genbu Seal
            { itemid = 1405,                                    droprate =  15 }, -- Seiryu Seal
            { itemid = 1406,                                    droprate =  15 }, -- Byakko Seal
            { itemid = 1407,                                    droprate =  15 }, -- Suzaku Seal
            { itemid = xi.item.IVORY_CHIP,                      droprate =  20 },
            { itemid = xi.item.SCARLET_CHIP,                    droprate =  20 },
            { itemid = xi.item.EMERALD_CHIP,                    droprate =  20 },
            { itemid = xi.item.SILVER_CHIP,                     droprate =  20 },
            { itemid = xi.item.CERULEAN_CHIP,                   droprate =  20 },
            { itemid = 1986,                                    droprate =  20 }, -- Orchid Chip
            { itemid = xi.item.SMALT_CHIP,                      droprate =  20 },
            { itemid = xi.item.SMOKY_CHIP,                      droprate =  20 },
            { itemid = 1987,                                    droprate =  20 }, -- Charcoal Chip
            { itemid = 1988,                                    droprate =  20 }, -- Magenta Chip
            { itemid = xi.item.FIRST_VIRTUE,                    droprate =  20 },
            { itemid =  1853,                                   droprate =  20 }, -- Second Virtue
            { itemid = xi.item.THIRD_VIRTUE,                    droprate =  20 },
            { itemid =  1848,                                   droprate =  20 }, -- Fourth Virtue
            { itemid =  1847,                                   droprate =  20 }, -- Fifth Virtue
            { itemid =  1849,                                   droprate =  20 }, -- Sxith Virtue
            { itemid = xi.item.HELLCAGE_BUTTERFLY,              droprate =  20 },
            { itemid = xi.item.JUG_OF_FLORAL_NECTAR,            droprate =  20 },
            { itemid = xi.item.WEDGE_OF_RODENT_CHEESE,          droprate =  20 },
            { itemid = xi.item.CLUMP_OF_SHADELEAVES,            droprate =  20 },
            { itemid = xi.item.BEAKER_OF_PECTIN,                droprate =  20 },
            { itemid = xi.item.FLASK_OF_COG_LUBRICANT,          droprate =  20 },
            { itemid = xi.item.GOLDEN_TEETH,                    droprate =  20 },
            { itemid = xi.item.GREENLING,                       droprate =  20 },
            { itemid = xi.item.BOTTLE_OF_SPOILT_BLOOD,          droprate =  20 },
            { itemid = xi.item.BUNCH_OF_SENORITA_PAMAMAS,       droprate =  20 },
            { itemid = xi.item.JAR_OF_OILY_BLOOD,               droprate =  20 },
            { itemid = xi.item.STRAND_OF_SAMARIRI_CORPSEHAIR,   droprate =  20 },
            { itemid = xi.item.SLAB_OF_RAW_BUFFALO,             droprate =  20 },
            { itemid = xi.item.LUMP_OF_BONE_CHARCOAL,           droprate =  20 },
            { itemid = xi.item.PINCH_OF_GRANULATED_SUGAR,       droprate =  20 },
            { itemid = xi.item.MINT_DROP,                       droprate =  20 },
            { itemid = xi.item.OPALUS_GEM,                      droprate =  20 },
            { itemid = xi.MERROW_NO_11_MOLTING,                 droprate =  20 },
            { itemid = xi.BAR_OF_FERRITE,                       droprate =  20 },
            { itemid = xi.BAGGED_SHEEP_BOTFLY,                  droprate =  20 },
            { itemid = xi.OLZHIRYAN_CACTUS_PADDLE,              droprate =  20 },
            { itemid = xi.VIAL_OF_PURE_BLOOD,                   droprate =  20 },
            { itemid = xi.VINEGAR_PIE,                          droprate =  20 },
            { itemid = xi.JAR_OF_ROCK_JUICE,                    droprate =  20 },
            { itemid = xi.BOUND_EXORCISM_TREATISE,              droprate =  20 },
            { itemid = xi.CLUMP_OF_MYRRH,                       droprate =  20 },
            { itemid = xi.WHOLE_ROSE_SCAMPI,                    droprate =  20 },
            { itemid = xi.JUG_OF_MONKEY_WINE,                   droprate =  20 },
            { itemid = xi.CHUNK_OF_BUFFALO_CORPSE,              droprate =  20 },
            { itemid = xi.CHUNK_OF_SINGED_BUFFALO,              droprate =  20 },
            { itemid = xi.PANDEMONIUM_KEY,                      droprate =  20 },
        },
        -- Slot 3, Equipment --
        {
            { itemid = xi.item.DUENDE_COTEHARDIE,               droprate =   4 },
            { itemid = xi.item.NOKIZARU_GI,                     droprate =   4 },
            { itemid = xi.item.RAPPAREE_HARNESS,                droprate =   4 },
            { itemid = xi.item.SHINIMUSHA_HARA_ATE,             droprate =   4 },
            { itemid = xi.item.WYVERN_MAIL,                     droprate =   4 },
            { itemid = xi.item.SHIKAREE_AKETON,                 droprate =   4 },
            { itemid = xi.item.CERISE_DOUBLET,                  droprate =   4 },
            { itemid = xi.item.GLAMOR_JUPON,                    droprate =   4 },
            { itemid = xi.item.GLOOM_BREASTPLATE,               droprate =   4 },
            { itemid = xi.item.NIMBUS_DOUBLET,                  droprate =   4 },
            { itemid = xi.item.AIKIDO_GI,                       droprate =   4 },
            { itemid = xi.item.PARADE_CUIRASS,                  droprate =   4 },
            { itemid = xi.item.GAUDY_HARNESS,                   droprate =   4 },
            { itemid = xi.item.HAMAYUMI,                        droprate =   5 },
            { itemid = xi.item.DIA_WAND,                        droprate =   4 },
            { itemid = xi.item.STONE_GORGET,                    droprate =   5 },
            { itemid =  18359,                                  droprate =   5 }, -- Boreas Cesti
            { itemid =  15468,                                  droprate =   5 }, -- Resentment Cape
            { itemid =  xi.item.GOTHIC_SABATONS,                droprate =   5 },
            { itemid =  xi.item.GOTHIC_GAUNTLETS,               droprate =   5 },
            { itemid =  16187,                                  droprate =   5 }, -- Adoubeurs Pavise
            { itemid =  16899,                                  droprate =   5 }, -- Hototogisu
            { itemid =  16374,                                  droprate =   5 }, -- Layqa Seraweels
            { itemid =  17199,                                  droprate =   5 }, -- Loxley Bow
            { itemid =  16882,                                  droprate =   5 }, -- Calamar
            { itemid =  17504,                                  droprate =   5 }, -- Pagures
            { itemid =  16884,                                  droprate =   5 }, -- Narval
            { itemid =  17503,                                  droprate =   5 }, -- Exocets
            { itemid =  19238,                                  droprate =   5 }, -- Jasper Tathlum
            { itemid =  11404,                                  droprate =   5 }, -- Promptitude Solea
            { itemid =  15897,                                  droprate =   5 }, -- Grace Corset
            { itemid =  13803,                                  droprate =   5 }, -- Shaman's Cloak
            { itemid =  19237,                                  droprate =   5 }, -- Slick Dart
            { itemid =  15942,                                  droprate =   5 }, -- Summoning Belt
            { itemid =  xi.item.MUSHROOM_HELM,                  droprate =   2 },
            { itemid =  xi.item.LUNA_SUBLIGAR,                  droprate =   2 },
            { itemid =  16980,                                  droprate =   5 }, -- Sukesada
            { itemid =  13912,                                  droprate =   5 }, -- Shadow Mask
            { itemid =  16943,                                  droprate =   5 }, -- Ascalon
            { itemid =  14063,                                  droprate =   5 }, -- Protecting Bangles
            { itemid =  14064,                                  droprate =   5 }, -- Sand Gloves
            { itemid =  17651,                                  droprate =   5 }, -- Dainslaif
            { itemid =  17924,                                  droprate =   5 }, -- Tungi
            { itemid =  16734,                                  droprate =   5 }, -- Pendragon Axe
            { itemid =  15995,                                  droprate =   5 }, -- Carline Earring
            { itemid =  16127,                                  droprate =   5 }, -- Carline Ribbon
            { itemid =  16125,                                  droprate =   5 }, -- Breeder Mask
            { itemid =  15001,                                  droprate =   5 }, -- Breeder Mufflers
            { itemid =  15946,                                  droprate =   5 }, -- Tempest Belt
            { itemid =  11405,                                  droprate =   5 }, -- Kyoshu Kyahan
            { itemid =  11533,                                  droprate =   5 }, -- Lyricist's Gonnelle
            { itemid =  16298,                                  droprate =   5 }, -- Knack Pendant
            { itemid =  17454,                                  droprate =   5 }, -- Asklepios
            { itemid =  17455,                                  droprate =   5 }, -- Skirnir's Wand
            { itemid =  16912,                                  droprate =   5 }, -- Kitsutsuki
            { itemid =  17926,                                  droprate =   5 }, -- Acha D'Armas
            { itemid =  17982,                                  droprate =   5 }, -- Kard
            { itemid =  17983,                                  droprate =   5 }, -- Valiant Knife
            { itemid =  18042,                                  droprate =   5 }, -- Ascention
            { itemid =  17563,                                  droprate =   5 }, -- Power Staff
            { itemid =  17969,                                  droprate =   5 }, -- Fendoir
            { itemid =  18608,                                  droprate =   5 }, -- Atesh Pole
            { itemid =  16727,                                  droprate =   5 }, -- Eisentaenzer
            { itemid =  17971,                                  droprate =   5 }, -- Tartaglia
            { itemid =  19235,                                  droprate =   5 }, -- Veuglaire
            { itemid =  16375,                                  droprate =   5 }, -- Surge Subligar
            { itemid =  xi.item.ASTRAL_ASPIS,                   droprate =   5 },
            { itemid =  xi.item.GAE_BOLG,                       droprate =   5 },
            { itemid =  xi.item.LOHAR,                          droprate =   5 },
            { itemid =   19122,                                 droprate =   5 }, -- Courser's Pugio
            { itemid =   16081,                                 droprate =   5 }, -- Curate's Hat
            { itemid =   15882,                                 droprate =   5 }, -- Othinus' Bow
            { itemid =   17244,                                 droprate =   5 }, -- Storm Belt
            { itemid =   14806,                                 droprate =   5 }, -- Intruder Earring
            { itemid =   14466,                                 droprate =   5 }, -- Fomor Tunic
            { itemid =   18007,                                 droprate =   5 }, -- Chiroptera Dagger
            { itemid =   17510,                                 droprate =   5 }, -- Vampiric Claws
            { itemid =   14763,                                 droprate =   5 }, -- Boroka Earring
            { itemid =   13178,                                 droprate =   5 }, -- Auditory Torque
            { itemid =   15943,                                 droprate =   5 }, -- Virtuoso Belt
            { itemid =   14884,                                 droprate =   5 }, -- Mycophile Cuffs
            { itemid =   17794,                                 droprate =   5 }, -- Niokiyotsuna
            { itemid =   15219,                                 droprate =   5 }, -- Sinister Mask
            { itemid =   16368,                                 droprate =   5 }, -- Herder's Subligar
            { itemid =   14724,                                 droprate =   5 }, -- Moldavite Earring
            { itemid =   16279,                                 droprate =   5 }, -- Pile Chain
            { itemid =   15546,                                 droprate =   5 }, -- Fasting Ring
            { itemid =   16299,                                 droprate =   5 }, -- Lleu's Charm
            { itemid =   11496,                                 droprate =   5 }, -- Fenrir's Crown
            { itemid =   14168,                                 droprate =   5 }, -- Dune Boots
            { itemid =   17854,                                 droprate =   5 }, -- Cradle Horn
            { itemid =   19239,                                 droprate =   5 }, -- Astrolable
            { itemid =   16169,                                 droprate =   5 }, -- Caballero Shield
            { itemid =   17653,                                 droprate =   5 }, -- Hrotti
            { itemid =   18027,                                 droprate =   5 }, -- Palladium Dagger
            { itemid =   17564,                                 droprate =   5 }, -- Cocytus Pole
            { itemid =   16426,                                 droprate =   5 }, -- Avengers
            { itemid =   19121,                                 droprate =   5 }, -- Sleight Kukri
            { itemid =   15944,                                 droprate =   7 }, -- Selemnus Belt
            { itemid =   16297,                                 droprate =   7 }, -- Shepherd's Chain
            { itemid =  xi.item.KAMEWARI,                       droprate =   5 },
            { itemid =  xi.item.NADRS,                          droprate =   5 },
            { itemid =  xi.item.ALTDORFS_EARRING,               droprate =   5 },
            { itemid =  xi.item.WILHELMS_EARRING,               droprate =   5 },
            { itemid =  xi.item.HELENUSS_EARRING,               droprate =   5 },
            { itemid =  xi.item.CASSANDRAS_EARRING,             droprate =   5 },
            { itemid =  xi.item.MINSTRELS_DAGGER,               droprate =   5 },
            { itemid =  xi.item.SAND_CHARM,                     droprate =   5 },
            { itemid =   15692,                                 droprate =   5 }, -- Storm Crackows
            { itemid =   14669,                                 droprate =   5 }, -- Jaeger Ring
            { itemid =   15351,                                 droprate =   5 }, -- Bounding Boots
            { itemid =   18018,                                 droprate =   5 }, -- Sirocco Kukri
            { itemid =   13567,                                 droprate =   5 }, -- Bomb Queen Ring
            { itemid =   15547,                                 droprate =   5 }, -- Vilma's Ring
            { itemid =   26164,                                 droprate =   5 }, -- Caliber Ring
            { itemid =   15183,                                 droprate =   7 }, -- Dobson Bandana
            { itemid =   15184,                                 droprate =   7 }, -- Voyager Sallet
            { itemid =   14986,                                 droprate =   7 }, -- Ochimusha Kote
            { itemid =   15737,                                 droprate =   7 }, -- Sarutobi Kyahan
            { itemid =   15551,                                 droprate =   7 }, -- Shikaree Ring
            { itemid =  xi.item.EMPRESS_HAIRPIN,                droprate =   7 },
            { itemid =  xi.item.JOYEUSE,                        droprate =   7 },
            { itemid =  xi.item.DRYAD_STAFF,                    droprate =   7 },
            { itemid =  xi.item.VALIS_BOW,                      droprate =   7 },
            { itemid =  xi.item.RETALIATORS,                    droprate =   7 },
            { itemid =  xi.item.UNGUR_BOOMERANG,                droprate =   7 },
            { itemid =   15515,                                 droprate =   7 }, -- Peacock Amulet
            { itemid =  xi.item.TROTTER_BOOTS,                  droprate =   7 },
            { itemid =   19236,                                 droprate =   7 }, -- Hightail Bullet
            { itemid =   17192,                                 droprate =   7 }, -- Ifrit's Bow
            { itemid =   17711,                                 droprate =   7 }, -- Shiva's Shotel
            { itemid =   18021,                                 droprate =   7 }, -- Titan's Baselarde
            { itemid =   18063,                                 droprate =   7 }, -- Garuda's Sickle
            { itemid =   18109,                                 droprate =   7 }, -- Leviathan's Couse
            { itemid =   18404,                                 droprate =   7 }, -- Ramuh's Mace
            { itemid =   18581,                                 droprate =   7 }, -- Carbuncle's Pole
            { itemid =   14931,                                 droprate =   7 }, -- Carbuncle's Cuffs
            { itemid =   18422,                                 droprate =   7 }, -- Ryumon
            { itemid =   14960,                                 droprate =   7 }, -- Evoker's Gages
            { itemid =   19277,                                 droprate =   7 }, -- Tsugumi
            { itemid =   11408,                                 droprate =   7 }, -- Morana Pigaches
            { itemid =   11409,                                 droprate =   7 }, -- Aoide's Pumps
            { itemid =   16238,                                 droprate =   7 }, -- Taster's Cape
            { itemid =   11497,                                 droprate =   7 }, -- Spurrer Beret
            { itemid =   11406,                                 droprate =   7 }, -- Stimulus Sabots
            { itemid =   18767,                                 droprate =   6 }, -- Birdbanes
            { itemid =   15854,                                 droprate =   7 }, -- Sortie Ring
            { itemid =   15915,                                 droprate =   7 }, -- Sothic Rope
            { itemid =   11342,                                 droprate =   6 }, -- Restorer Cloak
            { itemid =   18770,                                 droprate =   7 }, -- Pygme Sainti
            { itemid =   17737,                                 droprate =   6 }, -- Corsair's Scimitar
            { itemid =   19124,                                 droprate =   7 }, -- Creve-coeur
            { itemid =   19279,                                 droprate =   7 }, -- Musanto
            { itemid =   17766,                                 droprate =   7 }, -- Lyft Scimitar
            { itemid =   17970,                                 droprate =   7 }, -- Lyft Tabar
            { itemid =   18508,                                 droprate =   7 }, -- Lyft Voulge
            { itemid =   18609,                                 droprate =   7 }, -- Lyft Pole
            { itemid =   18771,                                 droprate =   7 }, -- Lyft Sainti
            { itemid =   18872,                                 droprate =   7 }, -- Lyft Ferule
            { itemid =   18958,                                 droprate =   7 }, -- Lyft Scythe
            { itemid =   19125,                                 droprate =   7 }, -- Lyft Jambiya
            { itemid =   19161,                                 droprate =   7 }, -- Lyft Claymore
            { itemid =   19233,                                 droprate =   7 }, -- Lyft Crossbow
            { itemid =   19306,                                 droprate =   7 }, -- Lyft Lance
            { itemid =  xi.item.LAVAS_RING,                     droprate =   7 },
            { itemid =  xi.item.KUSHAS_RING,                    droprate =   7 },
            { itemid =  xi.item.NASATYAS_RING,                  droprate =   7 },
            { itemid =  xi.item.DASRAS_RING,                    droprate =   7 },
            { itemid =  xi.item.HOPE_STAFF,                     droprate =   7 },
            { itemid =  xi.item.JUSTICE_SWORD,                  droprate =   7 },
            { itemid =  xi.item.TEMPERANCE_AXE,                 droprate =   7 },
            { itemid =  xi.item.LOVE_HALBERD,                   droprate =   7 },
            { itemid =  xi.item.FORTITUDE_AXE,                  droprate =   7 },
            { itemid =  xi.item.FAITH_BAGHNAKHS,                droprate =   7 },
            { itemid =  xi.item.PRUDENCE_ROD,                   droprate =   7 },
            { itemid =  xi.item.BYAKKOS_AXE,                    droprate =   8 },
            { itemid =  xi.item.SUZAKUS_SCYTHE,                 droprate =   8 },
            { itemid =  xi.item.SEIRYUS_SWORD,                  droprate =   8 },
        },
        -- Slot 7, Equipment --
        {
            { itemid =  5681,                                   droprate =   4 }, -- Cupid Chocolate
            { itemid = xi.item.GENBUS_KABUTO,                   droprate =   6 },
            { itemid = xi.item.GENBUS_SHIELD,                   droprate =   6 },
            { itemid = xi.item.SEIRYUS_KOTE,                    droprate =   6 },
            { itemid = xi.item.SUZAKUS_SUNE_ATE,                droprate =   6 },
            { itemid = xi.item.BYAKKOS_HAIDATE,                 droprate =   6 },
            { itemid = xi.item.ANIMATOR_P1,                     droprate =   5 },
            { itemid = 17567,                                   droprate =   5 }, -- Kirin's Pole
            { itemid = 12562,                                   droprate =   5 }, -- Kirin's Osode
            { itemid = 16034,                                   droprate =   5 }, -- Sarabande Earring
            { itemid = 13415,                                   droprate =   5 }, -- Pixie Earring
            { itemid = 16300,                                   droprate =   5 }, -- Wit Pendant
            { itemid = 16303,                                   droprate =   5 }, -- Laran's Pendant
            { itemid = 15057,                                   droprate =   5 }, -- Bricta's Cuffs
            { itemid = 14943,                                   droprate =   5 }, -- Barbarossa's Moufles
            { itemid = 16376,                                   droprate =   5 }, -- Bahram Cuisses
            { itemid = 16302,                                   droprate =   5 }, -- Bloodbead Gorget
            { itemid = 11411,                                   droprate =   5 }, -- Shrewd Pumps
            { itemid = 15223,                                   droprate =   5 }, -- Ace's Helm
            { itemid = 18002,                                   droprate =   5 }, -- Perseu's Harp
            { itemid = 14873,                                   droprate =   5 }, -- Bandomusha Kote
            { itemid = 19280,                                   droprate =   5 }, -- Narigitsune
            { itemid = xi.item.WYRM_BEARD,                      droprate =   5 },
            { itemid = xi.item.BEHEMOTH_TONGUE,                 droprate =   5 },
            { itemid = xi.item.ADAMANTOISE_EGG,                 droprate =   5 },
            { itemid = xi.item.SEVENEYES,                       droprate =   5 },
            { itemid = xi.item.ALGOL,                           droprate =   5 },
            { itemid = 13658,                                   droprate =   5 }, -- Shadow Mantle
            { itemid = 14646,                                   droprate =   5 }, -- Shadow Ring
            { itemid = 11589,                                   droprate =   5 }, -- Aesir Torque
            { itemid = 16057,                                   droprate =   5 }, -- Aesir Ear Pendant
            { itemid = 11546,                                   droprate =   5 }, -- Aesir Mantle
            { itemid = 11547,                                   droprate =   5 }, -- Colossus's Mantle
            { itemid = 11590,                                   droprate =   5 }, -- Colossus's Torque
            { itemid = 16058,                                   droprate =   5 }, -- Colossus's Earring
            { itemid = 18019,                                   droprate =   5 }, -- X's Knife
            { itemid = 18057,                                   droprate =   5 }, -- Y's Scythe
            { itemid = 18101,                                   droprate =   5 }, -- Z's Trident
            { itemid = 15899,                                   droprate =   5 }, -- Velocious Belt
            { itemid = 15617,                                   droprate =   5 }, -- Barbarossa's Zerehs
            { itemid = 17586,                                   droprate =   5 }, -- Mercurial Pole
            { itemid = xi.item.JUSTICE_TORQUE,                  droprate =   5 },
            { itemid = xi.item.HOPE_TORQUE,                     droprate =   5 },
            { itemid = xi.item.PRUDENCE_TORQUE,                 droprate =   5 },
            { itemid = xi.item.FORTITUDE_TORQUE,                droprate =   5 },
            { itemid = xi.item.FAITH_TORQUE,                    droprate =   5 },
            { itemid = xi.item.TEMPERANCE_TORQUE,               droprate =   5 },
            { itemid = xi.item.LOVE_TORQUE,                     droprate =   5 },
            { itemid = xi.item.RIDILL,                          droprate =   5 },
            { itemid = xi.item.OCTAVE_CLUB,                     droprate =   5 },
            { itemid = xi.item.HAUTECLAIRE,                     droprate =   5 },
            { itemid = 13566,                                   droprate =   3 }, -- Defending Ring
            { itemid = 27456,                                   droprate =   3 }, -- Crier's Gaiters
            { itemid = 14468,                                   droprate =   3 }, -- Yinyang Robe
            { itemid = 17754,                                   droprate =   5 }, -- Sylphid Epee
            { itemid = 16154,                                   droprate =   5 }, -- Karura Hachigane
            { itemid = 16000,                                   droprate =   5 }, -- Dragoon's Earring
            { itemid = 16240,                                   droprate =   5 }, -- Erato's Cape
            { itemid = 17755,                                   droprate =   5 }, -- Beast Slayer
            { itemid = 16340,                                   droprate =   5 }, -- Armadillo Cuisses
            { itemid = 17961,                                   droprate =   5 }, -- Lion Tamer
            { itemid = 15018,                                   droprate =   5 }, -- Ritterhentzes
            { itemid = 18859,                                   droprate =   5 }, -- Kerykeion
            { itemid = 16274,                                   droprate =   5 }, -- Almah Torque
            { itemid = 15999,                                   droprate =   5 }, -- Guignol Earring
            { itemid = 15916,                                   droprate =   5 }, -- Corsair's Belt
            { itemid = 18950,                                   droprate =   5 }, -- White Joker
            { itemid = 11369,                                   droprate =   5 }, -- Numerist Pumps
            { itemid = 11368,                                   droprate =   5 }, -- Hakke Habaki
            { itemid = 15827,                                   droprate =   5 }, -- Insect Ring
            { itemid = 15828,                                   droprate =   5 }, -- Blood Ring
            { itemid = 19154,                                   droprate =   5 }, -- Ferrara
            { itemid = 11366,                                   droprate =   5 }, -- Avocat Pigaches
            { itemid = 15017,                                   droprate =   5 }, -- Toad Mittens
            { itemid = 16339,                                   droprate =   5 }, -- Paddock Trousers
            { itemid = 16153,                                   droprate =   5 }, -- Reikyo Hairpin
            { itemid = 11367,                                   droprate =   5 }, -- Nobushi Kyahan
            { itemid = 19109,                                   droprate =   5 }, -- Trilling Dagger
            { itemid = 18448,                                   droprate =   5 }, -- Hacchonenbutsu
            { itemid = 19211,                                   droprate =   5 }, -- Reacton Arm
            { itemid = 19028,                                   droprate =   5 }, -- Magic Strap
            { itemid = 18127,                                   droprate =   5 }, -- Achilles' Spear
            { itemid = 16338,                                   droprate =   5 }, -- Ruby Seraweels
            { itemid = 18949,                                   droprate =   5 }, -- Zareehkl Scythe
            { itemid = 19108,                                   droprate =   5 }, -- Zareehkl Jambiya
            { itemid = 16239,                                   droprate =   5 }, -- Solitaire Cape
            { itemid = 16175,                                   droprate =   5 }, -- Muse Tariqah
            { itemid = 16152,                                   droprate =   5 }, -- Hissho Hachimaki
            { itemid = 16174,                                   droprate =   5 }, -- Riot Shield
            { itemid = 18126,                                   droprate =   4 }, -- Tomoe
            { itemid = xi.item.ORACLES_GLOVES,                  droprate =   4 },
            { itemid = xi.item.AURUM_SABATONS,                  droprate =   4 },
            { itemid = 19031,                                   droprate =   4 }, -- Fire Grip
            { itemid = 19032,                                   droprate =   4 }, -- Water Grip
            { itemid = 19033,                                   droprate =   4 }, -- Wind Grip
            { itemid = 19034,                                   droprate =   4 }, -- Ice Grip
            { itemid = 19035,                                   droprate =   4 }, -- Thunder Grip
            { itemid = 19036,                                   droprate =   4 }, -- Earth Grip
            { itemid = 19037,                                   droprate =   4 }, -- Light Grip
            { itemid = 19038,                                   droprate =   4 }, -- Dark Grip
            { itemid = xi.item.ENKIDUS_MITTENS,                 droprate =   4 },
            { itemid = xi.item.AURUM_CUISSES,                   droprate =   4 },
            { itemid = 19153,                                   droprate =   4 }, -- Naglering
            { itemid = 18125,                                   droprate =   4 }, -- Cletine
            { itemid = xi.item.ENKIDUS_SUBLIGAR,                droprate =   4 },
            { itemid = xi.item.ORACLES_PIGACHES,                droprate =   4 },
            { itemid = 17960,                                   droprate =   4 }, -- Labrys
            { itemid = xi.item.ENKIDUS_LEGGINGS,                droprate =   4 },
            { itemid = xi.item.AURUM_GAUNTLETS,                 droprate =   4 },
            { itemid = 16176,                                   droprate =   4 }, -- Simba Buckler
            { itemid = 17753,                                   droprate =   4 }, -- Organics
            { itemid = xi.item.ORACLES_BRACONI,                 droprate =   4 },
            { itemid = 16177,                                   droprate =   4 }, -- Legion Scutum
            { itemid = 18595,                                   droprate =   4 }, -- Mekki Shakki
            { itemid = 18430,                                   droprate =   4 }, -- Oninohocho
            { itemid = 18593,                                   droprate =   2 }, -- Alkalurops
            { itemid = xi.item.ENKIDUS_CAP,                     droprate =   3 },
            { itemid = xi.item.ENKIDUS_HARNESS,                 droprate =   3 },
            { itemid = xi.item.HACHIRYU_SUNE_ATE,               droprate =   3 },
            { itemid = xi.item.ORACLES_CAP,                     droprate =   3 },
            { itemid = 18429,                                   droprate =   3 }, -- Shusui
            { itemid = xi.item.AURUM_ARMET,                     droprate =   3 },
            { itemid = 18497,                                   droprate =   3 }, -- Foolkiller
            { itemid = xi.item.HACHIRYU_HAIDATE,                droprate =   3 },
            { itemid = xi.item.ORACLES_ROBE,                    droprate =   3 },
            { itemid = 18446,                                   droprate =   3 }, -- Pachipachio
            { itemid = 18857,                                   droprate =   3 }, -- Antares
            { itemid = xi.item.AURUM_CUIRASS,                   droprate =   3 },
            { itemid = xi.item.HACHIRYU_KOTE,                   droprate =   3 },
            { itemid = xi.item.HACHIRYU_HARAMAKI,               droprate =   2 },
            { itemid = 10754,                                   droprate =   3 }, -- Moepapa Ring
            { itemid = 10755,                                   droprate =   3 }, -- Moepapa Annulet
            { itemid = 10756,                                   droprate =   3 }, -- Tjukurrpa Ring
            { itemid = 10757,                                   droprate =   3 }, -- Tjukurrpa Annulet
            { itemid = 10759,                                   droprate =   3 }, -- Aife's Annulet
            { itemid = 10817,                                   droprate =   3 }, -- Moepapa Stone
            { itemid = 10818,                                   droprate =   3 }, -- Tjukurrpa Belt
            { itemid = 10932,                                   droprate =   3 }, -- Oneiros torque
            { itemid = 10933,                                   droprate =   3 }, -- Mujin necklace
            { itemid = 10940,                                   droprate =   3 }, -- Moepapa Pendant
            { itemid = 10941,                                   droprate =   3 }, -- Tjukurrpa Medal
            { itemid = 10942,                                   droprate =   3 }, -- Aife's Medal
            { itemid = 10943,                                   droprate =   3 }, -- Moepapa Medal
            { itemid = 10972,                                   droprate =   3 }, -- Oneiros cappa
            { itemid = 10973,                                   droprate =   3 }, -- Oneiros cape
            { itemid = 10974,                                   droprate =   3 }, -- Mujin mantle
            { itemid = 10983,                                   droprate =   3 }, -- Aife's Mantle
            { itemid = 10984,                                   droprate =   3 }, -- Tjukurrpa Mantle
            { itemid = 11030,                                   droprate =   3 }, -- Oneiros earring
            { itemid = 11032,                                   droprate =   3 }, -- Mujin Stud
            { itemid = 11031,                                   droprate =   3 }, -- Oneiros pearl
            { itemid = 11456,                                   droprate =   3 }, -- Ryuga Sune-Ate
            { itemid = 11461,                                   droprate =   3 }, -- Aife's Pumps
            { itemid = 11670,                                   droprate =   3 }, -- Oneiros annulet
            { itemid = 11671,                                   droprate =   3 }, -- Oneiros ring
            { itemid = 11672,                                   droprate =   3 }, -- Mujin band
            { itemid = 11772,                                   droprate =   3 }, -- Oneiros sash
            { itemid = 11773,                                   droprate =   3 }, -- Oneiros belt
            { itemid = 11774,                                   droprate =   3 }, -- Oneiros cest
            { itemid = 11775,                                   droprate =   3 }, -- Oneiros rope
            { itemid = 11776,                                   droprate =   3 }, -- Mujin obi
            { itemid = 11820,                                   droprate =   3 }, -- Khthonios Mask
            { itemid = 11821,                                   droprate =   3 }, -- Khthonios Helm
            { itemid = 11816,                                   droprate =   3 }, -- Oneiros helm
            { itemid = 11817,                                   droprate =   3 }, -- Oneiros barbut
            { itemid = 11818,                                   droprate =   3 }, -- Oneiros headgear
            { itemid = 11819,                                   droprate =   3 }, -- Oneiros coif 
            { itemid = 11923,                                   droprate =   3 }, -- Tjukurrpa Gauntlets
            { itemid = 11918,                                   droprate =   3 }, -- Khthonios Gloves
            { itemid = 11919,                                   droprate =   3 }, -- Avesta Bangles
            { itemid = 17069,                                   droprate =   3 }, -- Moepapa Mace
            { itemid = 17358,                                   droprate =   3 }, -- Oneiros Harp
            { itemid = 18519,                                   droprate =   3 }, -- Oneiros axe
            { itemid = 18541,                                   droprate =   3 }, -- Tjukurrpa Axe 
            { itemid = 18623,                                   droprate =   3 }, -- Chtonic Staff
            { itemid = 18811,                                   droprate =   3 }, -- Oneiros grip
            { itemid = 19141,                                   droprate =   3 }, -- Oneiros knife
            { itemid = 19295,                                   droprate =   3 }, -- Mujin tanto
            { itemid = 19738,                                   droprate =   3 }, -- Aife's Bow
            { itemid = 19762,                                   droprate =   3 }, -- Oneiros Tathlum  
            { itemid = 19763,                                   droprate =   3 }, -- Oneiros Cluster  
            { itemid = 19767,                                   droprate =   3 }, -- Oneiros pebble
            { itemid = 19790,                                   droprate =   3 }, -- Oneiros lance
            { itemid = xi.item.MURREY_GRISAILLE,                droprate =   1 },
            { itemid =    0,                                    droprate = 250 }, -- nothing
        },
        -- Slot 4, Materials --
        {
            { itemid = xi.item.IRON_INGOT,                      droprate =   5 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   5 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   5 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   5 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   5 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   5 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   5 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   5 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   5 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   5 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   5 },
            { itemid = xi.item.RAM_HORN,                        droprate =   5 },
            { itemid = xi.item.ELM_LOG,                         droprate =   5 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   5 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   5 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   5 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   5 },
            { itemid =  850,                                    droprate =   5 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   5 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   5 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   5 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   5 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   5 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   5 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   5 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   5 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   5 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   5 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   5 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   5 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   5 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   5 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   5 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   5 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   5 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   5 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   5 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   5 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   5 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   5 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   5 },
            { itemid = xi.item.IMP_HORN,                        droprate =   5 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   5 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   5 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   5 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   5 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   5 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   5 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   5 },
            { itemid = 1225,                                    droprate =   5 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   5 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   5 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   5 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   5 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   5 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   5 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   5 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   5 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   5 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   5 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   5 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   5 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   5 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   5 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   5 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   5 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   5 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   5 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   5 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   5 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   5 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   5 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   5 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   5 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   5 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   5 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   5 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   5 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   5 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   5 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   5 },
            { itemid = 2151,                                    droprate =   5 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   5 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   5 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   5 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   5 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   5 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   5 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   5 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   5 }, -- Water Anima
            { itemid = 1647,                                    droprate =   5 }, -- Light Anima
            { itemid = 1648,                                    droprate =   5 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   5 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   5 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   5 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   5 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   5 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   5 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   5 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   5 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   5 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   5 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   5 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   5 },
            { itemid =  734,                                    droprate =   5 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   5 }, -- Amphiptere Hide
            { itemid = 2164,                                    droprate =   5 }, -- Pephredo Hive Chip
            { itemid = 1279,                                    droprate =   5 }, -- Taffeta Cloth
            { itemid = 1280,                                    droprate =   5 }, -- Sarcenet Cloth
            { itemid = 1281,                                    droprate =   5 }, -- Cheviot Cloth
            { itemid = 1295,                                    droprate =   5 }, -- Twincoon
            { itemid = 1270,                                    droprate =   5 }, -- Arachne Web
            { itemid =  647,                                    droprate =   5 }, -- Molybdenum Ore
            { itemid = 1271,                                    droprate =   5 }, -- Pigeon's Blood Ruby
            { itemid = 1276,                                    droprate =   5 }, -- Tarasque Skin
            { itemid = 1296,                                    droprate =   5 }, -- Yowie Skin
            { itemid = 1277,                                    droprate =   5 }, -- Lindwurm Skin
            { itemid = 1765,                                    droprate =   5 }, -- Habu Skin
            { itemid = 2828,                                    droprate =   5 }, -- Herensugue Skin
            { itemid = 2837,                                    droprate =   5 }, -- Ratatoskr Pelt
            { itemid = 2839,                                    droprate =   5 }, -- Coquecigrue Skin
            { itemid = 2830,                                    droprate =   5 }, -- Bastet Fang
            { itemid = 2833,                                    droprate =   5 }, -- Thunder Coral
            { itemid = 1272,                                    droprate =   5 }, -- Arioch Fang
            { itemid = 1273,                                    droprate =   5 }, -- Namtar Bone
            { itemid = 2849,                                    droprate =   5 }, -- Likho Talon
            { itemid = 2846,                                    droprate =   5 }, -- Hefty Oak Lumber
            { itemid = 2855,                                    droprate =   5 }, -- Mahogany Heartwood
            { itemid = xi.item.CHUNK_OF_FIRE_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_ICE_ORE,                droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WIND_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_EARTH_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHTNING_ORE,          droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WATER_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHT_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_DARK_ORE,               droprate =   3 },
            { itemid = xi.item.CLUMP_OF_IMPERIAL_TEA_LEAVES,    droprate =   4 },
            { itemid = xi.item.DRAGON_FRUIT,                    droprate =   4 },
            { itemid = xi.item.WALNUT,                          droprate =   4 },
            { itemid = xi.item.BOWL_OF_AMBROSIA,                droprate =   4 },
            { itemid = xi.item.BOTTLE_OF_AMRITA,                droprate =   4 },
            { itemid = xi.item.DRAGON_HEART,                    droprate =   3 },
            { itemid = xi.item.HANDFUL_OF_DRAGON_SCALES,        droprate =   3 },
            { itemid = xi.item.SLICE_OF_DRAGON_MEAT,            droprate =   3 },
            { itemid = xi.item.CHUNK_OF_HYDRA_MEAT,             droprate =   3 },
            { itemid = xi.item.SLICE_OF_CERBERUS_MEAT,          droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HIDE,                   droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HORN,                   droprate =   3 },
            { itemid = 2158,                                    droprate =   3 }, -- Hydra Fang
            { itemid = 2172,                                    droprate =   3 }, -- Hydra Scale
            { itemid = 2168,                                    droprate =   3 }, -- Cerberus Claw
            { itemid = 2169,                                    droprate =   3 }, -- Cerberus Hide
            { itemid = 2371,                                    droprate =   3 }, -- Khimaira Horn
            { itemid = 2372,                                    droprate =   3 }, -- Khimaira Mane
            { itemid = 2373,                                    droprate =   3 }, -- Khimaira Tail
            { itemid = 4273,                                    droprate =   3 }, -- Kitron
            { itemid = 1718,                                    droprate =   3 }, -- M-bugard Tusk
            { itemid = 1719,                                    droprate =   3 }, -- Harajnite Shell
            { itemid = xi.item.SQUARE_OF_ECARLATE_CLOTH,        droprate =   3 },
            { itemid = xi.item.ARGYRO_RIVET,                    droprate =   3 },
            { itemid = xi.item.UTOPIAN_GOLD_THREAD,             droprate =   3 },
            { itemid = xi.item.ANCIENT_BRASS_INGOT,             droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BENEDICT_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_BENEDICT_YARN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_DIABOLIC_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_DIABOLIC_YARN,          droprate =   3 },
            { itemid = xi.item.SPOOL_OF_RUBY_SILK_THREAD,       droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CARDINAL_CLOTH,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SUPPLE_SKIN,           droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LIGHT_FILAMENT,         droprate =   3 },
            { itemid = xi.item.CHUNK_OF_SNOWY_CERMET,           droprate =   3 },
            { itemid = xi.item.WHITE_RIVET,                     droprate =   3 },
            { itemid = xi.item.DARK_ORICHALCUM_INGOT,           droprate =   3 },
            { itemid = xi.item.BLACK_RIVET,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SMALT_LEATHER,         droprate =   3 },
            { itemid = xi.item.FETID_LANOLIN_CUBE,              droprate =   3 },
            { itemid = xi.item.SPOOL_OF_COILED_YARN,            droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BROWN_DOESKIN,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_CHAMELEON_YARN,         droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CHARCOAL_COTTON,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SCARLET_ODOSHI,         droprate =   3 },
            { itemid = xi.item.SHEET_OF_KUROGANE,               droprate =   3 },
            { itemid = xi.item.PLAITED_CORD,                    droprate =   3 },
            { itemid = xi.item.POT_OF_EBONY_LACQUER,            droprate =   3 },
            { itemid = xi.item.SHEET_OF_COBALT_MYTHRIL,         droprate =   3 },
            { itemid = xi.item.BLUE_RIVET,                      droprate =   3 },
            { itemid = xi.item.SPOOL_OF_GLITTERING_YARN,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ASTRAL_LEATHER,        droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LUMINIAN_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_FLAMESHUN_CLOTH,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SILKWORM_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CANVAS_TOILE,          droprate =   3 },
            { itemid = xi.item.PANTIN_WIRE,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CORDUROY_CLOTH,        droprate =   3 },
            { itemid = xi.item.PIECE_OF_ANGEL_SKIN,             droprate =   3 },
            { itemid = xi.item.LOCK_OF_SIRENS_HAIR,             droprate =   3 },
            { itemid = xi.item.DIVINE_LOG,                      droprate =   3 },
            { itemid = xi.item.POT_OF_VIRIDIAN_URUSHI,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_KEJUSU_SATIN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ELTORO_LEATHER,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_GALATEIA,              droprate =   3 },
            { itemid = xi.item.DRAGON_BONE,                     droprate =   3 },
            { itemid = 1703,                                    droprate =   3 }, -- Kunwu Ore
        },
        -- Slot 8, Materials --
        {
            { itemid = xi.item.IRON_INGOT,                      droprate =   5 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   5 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   5 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   5 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   5 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   5 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   5 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   5 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   5 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   5 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   5 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   5 },
            { itemid = xi.item.RAM_HORN,                        droprate =   5 },
            { itemid = xi.item.ELM_LOG,                         droprate =   5 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   5 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   5 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   5 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   5 },
            { itemid =  850,                                    droprate =   5 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   5 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   5 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   5 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   5 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   5 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   5 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   5 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   5 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   5 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   5 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   5 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   5 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   5 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   5 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   5 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   5 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   5 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   5 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   5 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   5 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   5 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   5 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   5 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   5 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   5 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   5 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   5 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   5 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   5 },
            { itemid = xi.item.IMP_HORN,                        droprate =   5 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   5 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   5 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   5 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   5 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   5 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   5 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   5 },
            { itemid = 1225,                                    droprate =   5 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   5 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   5 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   5 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   5 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   5 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   5 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   5 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   5 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   5 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   5 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   5 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   5 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   5 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   5 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   5 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   5 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   5 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   5 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   5 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   5 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   5 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   5 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   5 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   5 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   5 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   5 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   5 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   5 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   5 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   5 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   5 },
            { itemid = 2151,                                    droprate =   5 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   5 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   5 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   5 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   5 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   5 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   5 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   5 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   5 }, -- Water Anima
            { itemid = 1647,                                    droprate =   5 }, -- Light Anima
            { itemid = 1648,                                    droprate =   5 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   5 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   5 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   5 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   5 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   5 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   5 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   5 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   5 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   5 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   5 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   5 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   5 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   5 },
            { itemid =  734,                                    droprate =   5 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   5 }, -- Amphiptere Hide
            { itemid = 2164,                                    droprate =   5 }, -- Pephredo Hive Chip
            { itemid = 1279,                                    droprate =   5 }, -- Taffeta Cloth
            { itemid = 1280,                                    droprate =   5 }, -- Sarcenet Cloth
            { itemid = 1281,                                    droprate =   5 }, -- Cheviot Cloth
            { itemid = 1295,                                    droprate =   5 }, -- Twincoon
            { itemid = 1270,                                    droprate =   5 }, -- Arachne Web
            { itemid =  647,                                    droprate =   5 }, -- Molybdenum Ore
            { itemid = 1271,                                    droprate =   5 }, -- Pigeon's Blood Ruby
            { itemid = 1276,                                    droprate =   5 }, -- Tarasque Skin
            { itemid = 1296,                                    droprate =   5 }, -- Yowie Skin
            { itemid = 1277,                                    droprate =   5 }, -- Lindwurm Skin
            { itemid = 1765,                                    droprate =   5 }, -- Habu Skin
            { itemid = 2828,                                    droprate =   5 }, -- Herensugue Skin
            { itemid = 2837,                                    droprate =   5 }, -- Ratatoskr Pelt
            { itemid = 2839,                                    droprate =   5 }, -- Coquecigrue Skin
            { itemid = 2830,                                    droprate =   5 }, -- Bastet Fang
            { itemid = 2833,                                    droprate =   5 }, -- Thunder Coral
            { itemid = 1272,                                    droprate =   5 }, -- Arioch Fang
            { itemid = 1273,                                    droprate =   5 }, -- Namtar Bone
            { itemid = 2849,                                    droprate =   5 }, -- Likho Talon
            { itemid = 2846,                                    droprate =   5 }, -- Hefty Oak Lumber
            { itemid = 2855,                                    droprate =   5 }, -- Mahogany Heartwood
            { itemid = xi.item.CHUNK_OF_FIRE_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_ICE_ORE,                droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WIND_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_EARTH_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHTNING_ORE,          droprate =   3 },
            { itemid = xi.item.CHUNK_OF_WATER_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_LIGHT_ORE,              droprate =   3 },
            { itemid = xi.item.CHUNK_OF_DARK_ORE,               droprate =   3 },
            { itemid = xi.item.CLUMP_OF_IMPERIAL_TEA_LEAVES,    droprate =   4 },
            { itemid = xi.item.DRAGON_FRUIT,                    droprate =   4 },
            { itemid = xi.item.WALNUT,                          droprate =   4 },
            { itemid = xi.item.BOWL_OF_AMBROSIA,                droprate =   4 },
            { itemid = xi.item.BOTTLE_OF_AMRITA,                droprate =   4 },
            { itemid = xi.item.DRAGON_HEART,                    droprate =   3 },
            { itemid = xi.item.HANDFUL_OF_DRAGON_SCALES,        droprate =   3 },
            { itemid = xi.item.SLICE_OF_DRAGON_MEAT,            droprate =   3 },
            { itemid = xi.item.CHUNK_OF_HYDRA_MEAT,             droprate =   3 },
            { itemid = xi.item.SLICE_OF_CERBERUS_MEAT,          droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HIDE,                   droprate =   3 },
            { itemid = xi.item.BEHEMOTH_HORN,                   droprate =   3 },
            { itemid = 2158,                                    droprate =   3 }, -- Hydra Fang
            { itemid = 2172,                                    droprate =   3 }, -- Hydra Scale
            { itemid = 2168,                                    droprate =   3 }, -- Cerberus Claw
            { itemid = 2169,                                    droprate =   3 }, -- Cerberus Hide
            { itemid = 2371,                                    droprate =   3 }, -- Khimaira Horn
            { itemid = 2372,                                    droprate =   3 }, -- Khimaira Mane
            { itemid = 2373,                                    droprate =   3 }, -- Khimaira Tail
            { itemid = 4273,                                    droprate =   3 }, -- Kitron
            { itemid = 1718,                                    droprate =   3 }, -- M-bugard Tusk
            { itemid = 1719,                                    droprate =   3 }, -- Harajnite Shell
            { itemid = xi.item.SQUARE_OF_ECARLATE_CLOTH,        droprate =   3 },
            { itemid = xi.item.ARGYRO_RIVET,                    droprate =   3 },
            { itemid = xi.item.UTOPIAN_GOLD_THREAD,             droprate =   3 },
            { itemid = xi.item.ANCIENT_BRASS_INGOT,             droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BENEDICT_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_BENEDICT_YARN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_DIABOLIC_SILK,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_DIABOLIC_YARN,          droprate =   3 },
            { itemid = xi.item.SPOOL_OF_RUBY_SILK_THREAD,       droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CARDINAL_CLOTH,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SUPPLE_SKIN,           droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LIGHT_FILAMENT,         droprate =   3 },
            { itemid = xi.item.CHUNK_OF_SNOWY_CERMET,           droprate =   3 },
            { itemid = xi.item.WHITE_RIVET,                     droprate =   3 },
            { itemid = xi.item.DARK_ORICHALCUM_INGOT,           droprate =   3 },
            { itemid = xi.item.BLACK_RIVET,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_SMALT_LEATHER,         droprate =   3 },
            { itemid = xi.item.FETID_LANOLIN_CUBE,              droprate =   3 },
            { itemid = xi.item.SPOOL_OF_COILED_YARN,            droprate =   3 },
            { itemid = xi.item.SQUARE_OF_BROWN_DOESKIN,         droprate =   3 },
            { itemid = xi.item.SPOOL_OF_CHAMELEON_YARN,         droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CHARCOAL_COTTON,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SCARLET_ODOSHI,         droprate =   3 },
            { itemid = xi.item.SHEET_OF_KUROGANE,               droprate =   3 },
            { itemid = xi.item.PLAITED_CORD,                    droprate =   3 },
            { itemid = xi.item.POT_OF_EBONY_LACQUER,            droprate =   3 },
            { itemid = xi.item.SHEET_OF_COBALT_MYTHRIL,         droprate =   3 },
            { itemid = xi.item.BLUE_RIVET,                      droprate =   3 },
            { itemid = xi.item.SPOOL_OF_GLITTERING_YARN,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ASTRAL_LEATHER,        droprate =   3 },
            { itemid = xi.item.SPOOL_OF_LUMINIAN_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_FLAMESHUN_CLOTH,       droprate =   3 },
            { itemid = xi.item.SPOOL_OF_SILKWORM_THREAD,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CANVAS_TOILE,          droprate =   3 },
            { itemid = xi.item.PANTIN_WIRE,                     droprate =   3 },
            { itemid = xi.item.SQUARE_OF_CORDUROY_CLOTH,        droprate =   3 },
            { itemid = xi.item.PIECE_OF_ANGEL_SKIN,             droprate =   3 },
            { itemid = xi.item.LOCK_OF_SIRENS_HAIR,             droprate =   3 },
            { itemid = xi.item.DIVINE_LOG,                      droprate =   3 },
            { itemid = xi.item.POT_OF_VIRIDIAN_URUSHI,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_KEJUSU_SATIN,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_ELTORO_LEATHER,        droprate =   3 },
            { itemid = xi.item.SQUARE_OF_GALATEIA,              droprate =   3 },
            { itemid = xi.item.DRAGON_BONE,                     droprate =   3 },
            { itemid = 1703,                                    droprate =   3 }, -- Kunwu Ore
        },
        -- Slot 5, Misc/Medicine --
        {
            { itemid = xi.item.VILE_ELIXIR,                     droprate = 150 },
            { itemid = 4149,                                    droprate = 150 }, -- Panacea
            { itemid = xi.item.VILE_ELIXIR_P1,                  droprate = 140 },
            { itemid = xi.item.HI_RERAISER,                     droprate = 140 },
            { itemid = xi.item.REMEDY,                          droprate = 140 },
            { itemid = xi.item.ICARUS_WING,                     droprate = 140 },
            { itemid = xi.item.SUPER_RERAISER,                  droprate = 140 },
        },
        -- Slot 9, Misc/Medicine --
        {
            { itemid = xi.item.VILE_ELIXIR,                     droprate = 150 },
            { itemid = 4149,                                    droprate = 150 }, -- Panacea
            { itemid = xi.item.VILE_ELIXIR_P1,                  droprate = 140 },
            { itemid = xi.item.HI_RERAISER,                     droprate = 140 },
            { itemid = xi.item.REMEDY,                          droprate = 140 },
            { itemid = xi.item.ICARUS_WING,                     droprate = 140 },
            { itemid = xi.item.SUPER_RERAISER,                  droprate = 140 },
        },
    },
    [150] =
    {   -- Slot 1, Currency --
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate = 100 },
            { itemid = xi.item.LINEN_COIN_PURSE,                droprate = 100 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =  90 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =  90 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =  90 },
            { itemid =  6541,                                   droprate =  90 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  90 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  90 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  90 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  90 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter            
        },
        -- Slot 6, Currency
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate =  90 },
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  60 },
            { itemid = xi.item.LINEN_COIN_PURSE,                droprate = 100 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =  90 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =  90 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =  90 },
            { itemid =  6541,                                   droprate =  80 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  80 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  80 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  80 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  80 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter
        },
        -- Slot 10, Tatters --
        {
            { itemid =  3283,                                   droprate = 125 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate = 125 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate = 125 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate = 125 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate = 125 }, -- Martial Tatter
            { itemid =  3279,                                   droprate = 125 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate = 125 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate = 125 }, -- Wyrmal Tatter
        },
        -- Slot 2, Pop Items
        {
            { itemid = 1404,                                    droprate =  15 }, -- Genbu Seal
            { itemid = 1405,                                    droprate =  15 }, -- Seiryu Seal
            { itemid = 1406,                                    droprate =  15 }, -- Byakko Seal
            { itemid = 1407,                                    droprate =  15 }, -- Suzaku Seal
            { itemid = xi.item.IVORY_CHIP,                      droprate =  20 },
            { itemid = xi.item.SCARLET_CHIP,                    droprate =  20 },
            { itemid = xi.item.EMERALD_CHIP,                    droprate =  20 },
            { itemid = xi.item.SILVER_CHIP,                     droprate =  20 },
            { itemid = xi.item.CERULEAN_CHIP,                   droprate =  20 },
            { itemid = 1986,                                    droprate =  20 }, -- Orchid Chip
            { itemid = xi.item.SMALT_CHIP,                      droprate =  20 },
            { itemid = xi.item.SMOKY_CHIP,                      droprate =  20 },
            { itemid = 1987,                                    droprate =  20 }, -- Charcoal Chip
            { itemid = 1988,                                    droprate =  20 }, -- Magenta Chip
            { itemid = xi.item.FIRST_VIRTUE,                    droprate =  20 },
            { itemid =  1853,                                   droprate =  20 }, -- Second Virtue
            { itemid = xi.item.THIRD_VIRTUE,                    droprate =  20 },
            { itemid =  1848,                                   droprate =  20 }, -- Fourth Virtue
            { itemid =  1847,                                   droprate =  20 }, -- Fifth Virtue
            { itemid =  1849,                                   droprate =  20 }, -- Sxith Virtue
            { itemid = xi.item.HELLCAGE_BUTTERFLY,              droprate =  20 },
            { itemid = xi.item.JUG_OF_FLORAL_NECTAR,            droprate =  20 },
            { itemid = xi.item.WEDGE_OF_RODENT_CHEESE,          droprate =  20 },
            { itemid = xi.item.CLUMP_OF_SHADELEAVES,            droprate =  20 },
            { itemid = xi.item.BEAKER_OF_PECTIN,                droprate =  20 },
            { itemid = xi.item.FLASK_OF_COG_LUBRICANT,          droprate =  20 },
            { itemid = xi.item.GOLDEN_TEETH,                    droprate =  20 },
            { itemid = xi.item.GREENLING,                       droprate =  20 },
            { itemid = xi.item.BOTTLE_OF_SPOILT_BLOOD,          droprate =  20 },
            { itemid = xi.item.BUNCH_OF_SENORITA_PAMAMAS,       droprate =  20 },
            { itemid = xi.item.JAR_OF_OILY_BLOOD,               droprate =  20 },
            { itemid = xi.item.STRAND_OF_SAMARIRI_CORPSEHAIR,   droprate =  20 },
            { itemid = xi.item.SLAB_OF_RAW_BUFFALO,             droprate =  20 },
            { itemid = xi.item.LUMP_OF_BONE_CHARCOAL,           droprate =  20 },
            { itemid = xi.item.PINCH_OF_GRANULATED_SUGAR,       droprate =  20 },
            { itemid = xi.item.MINT_DROP,                       droprate =  20 },
            { itemid = xi.item.OPALUS_GEM,                      droprate =  20 },
            { itemid = xi.MERROW_NO_11_MOLTING,                 droprate =  20 },
            { itemid = xi.BAR_OF_FERRITE,                       droprate =  20 },
            { itemid = xi.BAGGED_SHEEP_BOTFLY,                  droprate =  20 },
            { itemid = xi.OLZHIRYAN_CACTUS_PADDLE,              droprate =  20 },
            { itemid = xi.VIAL_OF_PURE_BLOOD,                   droprate =  20 },
            { itemid = xi.VINEGAR_PIE,                          droprate =  20 },
            { itemid = xi.JAR_OF_ROCK_JUICE,                    droprate =  20 },
            { itemid = xi.BOUND_EXORCISM_TREATISE,              droprate =  20 },
            { itemid = xi.CLUMP_OF_MYRRH,                       droprate =  20 },
            { itemid = xi.WHOLE_ROSE_SCAMPI,                    droprate =  20 },
            { itemid = xi.JUG_OF_MONKEY_WINE,                   droprate =  20 },
            { itemid = xi.CHUNK_OF_BUFFALO_CORPSE,              droprate =  20 },
            { itemid = xi.CHUNK_OF_SINGED_BUFFALO,              droprate =  20 },
            { itemid = xi.PANDEMONIUM_KEY,                      droprate =  20 },
        },
        -- Slot 3, Equipment --
        {
            { itemid = xi.item.DUENDE_COTEHARDIE,               droprate =   4 },
            { itemid = xi.item.NOKIZARU_GI,                     droprate =   4 },
            { itemid = xi.item.RAPPAREE_HARNESS,                droprate =   4 },
            { itemid = xi.item.SHINIMUSHA_HARA_ATE,             droprate =   4 },
            { itemid = xi.item.WYVERN_MAIL,                     droprate =   4 },
            { itemid = xi.item.SHIKAREE_AKETON,                 droprate =   4 },
            { itemid = xi.item.CERISE_DOUBLET,                  droprate =   4 },
            { itemid = xi.item.GLAMOR_JUPON,                    droprate =   4 },
            { itemid = xi.item.GLOOM_BREASTPLATE,               droprate =   4 },
            { itemid = xi.item.NIMBUS_DOUBLET,                  droprate =   4 },
            { itemid = xi.item.AIKIDO_GI,                       droprate =   4 },
            { itemid = xi.item.PARADE_CUIRASS,                  droprate =   4 },
            { itemid = xi.item.GAUDY_HARNESS,                   droprate =   4 },
            { itemid = xi.item.HAMAYUMI,                        droprate =   5 },
            { itemid = xi.item.DIA_WAND,                        droprate =   4 },
            { itemid = xi.item.STONE_GORGET,                    droprate =   5 },
            { itemid =  18359,                                  droprate =   5 }, -- Boreas Cesti
            { itemid =  15468,                                  droprate =   5 }, -- Resentment Cape
            { itemid =  xi.item.GOTHIC_SABATONS,                droprate =   5 },
            { itemid =  xi.item.GOTHIC_GAUNTLETS,               droprate =   5 },
            { itemid =  16187,                                  droprate =   5 }, -- Adoubeurs Pavise
            { itemid =  16899,                                  droprate =   5 }, -- Hototogisu
            { itemid =  16374,                                  droprate =   5 }, -- Layqa Seraweels
            { itemid =  17199,                                  droprate =   5 }, -- Loxley Bow
            { itemid =  16882,                                  droprate =   5 }, -- Calamar
            { itemid =  17504,                                  droprate =   5 }, -- Pagures
            { itemid =  16884,                                  droprate =   5 }, -- Narval
            { itemid =  17503,                                  droprate =   5 }, -- Exocets
            { itemid =  19238,                                  droprate =   5 }, -- Jasper Tathlum
            { itemid =  11404,                                  droprate =   5 }, -- Promptitude Solea
            { itemid =  15897,                                  droprate =   5 }, -- Grace Corset
            { itemid =  13803,                                  droprate =   5 }, -- Shaman's Cloak
            { itemid =  19237,                                  droprate =   5 }, -- Slick Dart
            { itemid =  15942,                                  droprate =   5 }, -- Summoning Belt
            { itemid =  xi.item.MUSHROOM_HELM,                  droprate =   2 },
            { itemid =  xi.item.LUNA_SUBLIGAR,                  droprate =   2 },
            { itemid =  16980,                                  droprate =   5 }, -- Sukesada
            { itemid =  13912,                                  droprate =   5 }, -- Shadow Mask
            { itemid =  16943,                                  droprate =   5 }, -- Ascalon
            { itemid =  14063,                                  droprate =   5 }, -- Protecting Bangles
            { itemid =  14064,                                  droprate =   5 }, -- Sand Gloves
            { itemid =  17651,                                  droprate =   5 }, -- Dainslaif
            { itemid =  17924,                                  droprate =   5 }, -- Tungi
            { itemid =  16734,                                  droprate =   5 }, -- Pendragon Axe
            { itemid =  15995,                                  droprate =   5 }, -- Carline Earring
            { itemid =  16127,                                  droprate =   5 }, -- Carline Ribbon
            { itemid =  16125,                                  droprate =   5 }, -- Breeder Mask
            { itemid =  15001,                                  droprate =   5 }, -- Breeder Mufflers
            { itemid =  15946,                                  droprate =   5 }, -- Tempest Belt
            { itemid =  11405,                                  droprate =   5 }, -- Kyoshu Kyahan
            { itemid =  11533,                                  droprate =   5 }, -- Lyricist's Gonnelle
            { itemid =  16298,                                  droprate =   5 }, -- Knack Pendant
            { itemid =  17454,                                  droprate =   5 }, -- Asklepios
            { itemid =  17455,                                  droprate =   5 }, -- Skirnir's Wand
            { itemid =  16912,                                  droprate =   5 }, -- Kitsutsuki
            { itemid =  17926,                                  droprate =   5 }, -- Acha D'Armas
            { itemid =  17982,                                  droprate =   5 }, -- Kard
            { itemid =  17983,                                  droprate =   5 }, -- Valiant Knife
            { itemid =  18042,                                  droprate =   5 }, -- Ascention
            { itemid =  17563,                                  droprate =   5 }, -- Power Staff
            { itemid =  17969,                                  droprate =   5 }, -- Fendoir
            { itemid =  18608,                                  droprate =   5 }, -- Atesh Pole
            { itemid =  16727,                                  droprate =   5 }, -- Eisentaenzer
            { itemid =  17971,                                  droprate =   5 }, -- Tartaglia
            { itemid =  19235,                                  droprate =   5 }, -- Veuglaire
            { itemid =  16375,                                  droprate =   5 }, -- Surge Subligar
            { itemid =  xi.item.ASTRAL_ASPIS,                   droprate =   5 },
            { itemid =  xi.item.GAE_BOLG,                       droprate =   5 },
            { itemid =  xi.item.LOHAR,                          droprate =   5 },
            { itemid =   19122,                                 droprate =   5 }, -- Courser's Pugio
            { itemid =   16081,                                 droprate =   5 }, -- Curate's Hat
            { itemid =   15882,                                 droprate =   5 }, -- Othinus' Bow
            { itemid =   17244,                                 droprate =   5 }, -- Storm Belt
            { itemid =   14806,                                 droprate =   5 }, -- Intruder Earring
            { itemid =   14466,                                 droprate =   5 }, -- Fomor Tunic
            { itemid =   18007,                                 droprate =   5 }, -- Chiroptera Dagger
            { itemid =   17510,                                 droprate =   5 }, -- Vampiric Claws
            { itemid =   14763,                                 droprate =   5 }, -- Boroka Earring
            { itemid =   13178,                                 droprate =   5 }, -- Auditory Torque
            { itemid =   15943,                                 droprate =   5 }, -- Virtuoso Belt
            { itemid =   14884,                                 droprate =   5 }, -- Mycophile Cuffs
            { itemid =   17794,                                 droprate =   5 }, -- Niokiyotsuna
            { itemid =   15219,                                 droprate =   5 }, -- Sinister Mask
            { itemid =   16368,                                 droprate =   5 }, -- Herder's Subligar
            { itemid =   14724,                                 droprate =   5 }, -- Moldavite Earring
            { itemid =   16279,                                 droprate =   5 }, -- Pile Chain
            { itemid =   15546,                                 droprate =   5 }, -- Fasting Ring
            { itemid =   16299,                                 droprate =   5 }, -- Lleu's Charm
            { itemid =   11496,                                 droprate =   5 }, -- Fenrir's Crown
            { itemid =   14168,                                 droprate =   5 }, -- Dune Boots
            { itemid =   17854,                                 droprate =   5 }, -- Cradle Horn
            { itemid =   19239,                                 droprate =   5 }, -- Astrolable
            { itemid =   16169,                                 droprate =   5 }, -- Caballero Shield
            { itemid =   17653,                                 droprate =   5 }, -- Hrotti
            { itemid =   18027,                                 droprate =   5 }, -- Palladium Dagger
            { itemid =   17564,                                 droprate =   5 }, -- Cocytus Pole
            { itemid =   16426,                                 droprate =   5 }, -- Avengers
            { itemid =   19121,                                 droprate =   5 }, -- Sleight Kukri
            { itemid =   15944,                                 droprate =   7 }, -- Selemnus Belt
            { itemid =   16297,                                 droprate =   7 }, -- Shepherd's Chain
            { itemid =  xi.item.KAMEWARI,                       droprate =   5 },
            { itemid =  xi.item.NADRS,                          droprate =   5 },
            { itemid =  xi.item.ALTDORFS_EARRING,               droprate =   5 },
            { itemid =  xi.item.WILHELMS_EARRING,               droprate =   5 },
            { itemid =  xi.item.HELENUSS_EARRING,               droprate =   5 },
            { itemid =  xi.item.CASSANDRAS_EARRING,             droprate =   5 },
            { itemid =  xi.item.MINSTRELS_DAGGER,               droprate =   5 },
            { itemid =  xi.item.SAND_CHARM,                     droprate =   5 },
            { itemid =   15692,                                 droprate =   5 }, -- Storm Crackows
            { itemid =   14669,                                 droprate =   5 }, -- Jaeger Ring
            { itemid =   15351,                                 droprate =   5 }, -- Bounding Boots
            { itemid =   18018,                                 droprate =   5 }, -- Sirocco Kukri
            { itemid =   13567,                                 droprate =   5 }, -- Bomb Queen Ring
            { itemid =   15547,                                 droprate =   5 }, -- Vilma's Ring
            { itemid =   26164,                                 droprate =   5 }, -- Caliber Ring
            { itemid =   15183,                                 droprate =   7 }, -- Dobson Bandana
            { itemid =   15184,                                 droprate =   7 }, -- Voyager Sallet
            { itemid =   14986,                                 droprate =   7 }, -- Ochimusha Kote
            { itemid =   15737,                                 droprate =   7 }, -- Sarutobi Kyahan
            { itemid =   15551,                                 droprate =   7 }, -- Shikaree Ring
            { itemid =  xi.item.EMPRESS_HAIRPIN,                droprate =   7 },
            { itemid =  xi.item.JOYEUSE,                        droprate =   7 },
            { itemid =  xi.item.DRYAD_STAFF,                    droprate =   7 },
            { itemid =  xi.item.VALIS_BOW,                      droprate =   7 },
            { itemid =  xi.item.RETALIATORS,                    droprate =   7 },
            { itemid =  xi.item.UNGUR_BOOMERANG,                droprate =   7 },
            { itemid =   15515,                                 droprate =   7 }, -- Peacock Amulet
            { itemid =  xi.item.TROTTER_BOOTS,                  droprate =   7 },
            { itemid =   19236,                                 droprate =   7 }, -- Hightail Bullet
            { itemid =   17192,                                 droprate =   7 }, -- Ifrit's Bow
            { itemid =   17711,                                 droprate =   7 }, -- Shiva's Shotel
            { itemid =   18021,                                 droprate =   7 }, -- Titan's Baselarde
            { itemid =   18063,                                 droprate =   7 }, -- Garuda's Sickle
            { itemid =   18109,                                 droprate =   7 }, -- Leviathan's Couse
            { itemid =   18404,                                 droprate =   7 }, -- Ramuh's Mace
            { itemid =   18581,                                 droprate =   7 }, -- Carbuncle's Pole
            { itemid =   14931,                                 droprate =   7 }, -- Carbuncle's Cuffs
            { itemid =   18422,                                 droprate =   7 }, -- Ryumon
            { itemid =   14960,                                 droprate =   7 }, -- Evoker's Gages
            { itemid =   19277,                                 droprate =   7 }, -- Tsugumi
            { itemid =   11408,                                 droprate =   7 }, -- Morana Pigaches
            { itemid =   11409,                                 droprate =   7 }, -- Aoide's Pumps
            { itemid =   16238,                                 droprate =   7 }, -- Taster's Cape
            { itemid =   11497,                                 droprate =   7 }, -- Spurrer Beret
            { itemid =   11406,                                 droprate =   7 }, -- Stimulus Sabots
            { itemid =   18767,                                 droprate =   6 }, -- Birdbanes
            { itemid =   15854,                                 droprate =   7 }, -- Sortie Ring
            { itemid =   15915,                                 droprate =   7 }, -- Sothic Rope
            { itemid =   11342,                                 droprate =   6 }, -- Restorer Cloak
            { itemid =   18770,                                 droprate =   7 }, -- Pygme Sainti
            { itemid =   17737,                                 droprate =   6 }, -- Corsair's Scimitar
            { itemid =   19124,                                 droprate =   7 }, -- Creve-coeur
            { itemid =   19279,                                 droprate =   7 }, -- Musanto
            { itemid =   17766,                                 droprate =   7 }, -- Lyft Scimitar
            { itemid =   17970,                                 droprate =   7 }, -- Lyft Tabar
            { itemid =   18508,                                 droprate =   7 }, -- Lyft Voulge
            { itemid =   18609,                                 droprate =   7 }, -- Lyft Pole
            { itemid =   18771,                                 droprate =   7 }, -- Lyft Sainti
            { itemid =   18872,                                 droprate =   7 }, -- Lyft Ferule
            { itemid =   18958,                                 droprate =   7 }, -- Lyft Scythe
            { itemid =   19125,                                 droprate =   7 }, -- Lyft Jambiya
            { itemid =   19161,                                 droprate =   7 }, -- Lyft Claymore
            { itemid =   19233,                                 droprate =   7 }, -- Lyft Crossbow
            { itemid =   19306,                                 droprate =   7 }, -- Lyft Lance
            { itemid =  xi.item.LAVAS_RING,                     droprate =   7 },
            { itemid =  xi.item.KUSHAS_RING,                    droprate =   7 },
            { itemid =  xi.item.NASATYAS_RING,                  droprate =   7 },
            { itemid =  xi.item.DASRAS_RING,                    droprate =   7 },
            { itemid =  xi.item.HOPE_STAFF,                     droprate =   7 },
            { itemid =  xi.item.JUSTICE_SWORD,                  droprate =   7 },
            { itemid =  xi.item.TEMPERANCE_AXE,                 droprate =   7 },
            { itemid =  xi.item.LOVE_HALBERD,                   droprate =   7 },
            { itemid =  xi.item.FORTITUDE_AXE,                  droprate =   7 },
            { itemid =  xi.item.FAITH_BAGHNAKHS,                droprate =   7 },
            { itemid =  xi.item.PRUDENCE_ROD,                   droprate =   7 },
            { itemid =  xi.item.BYAKKOS_AXE,                    droprate =   8 },
            { itemid =  xi.item.SUZAKUS_SCYTHE,                 droprate =   8 },
            { itemid =  xi.item.SEIRYUS_SWORD,                  droprate =   8 },
        },
        -- Slot 7, Equipment --
        {
            { itemid =  5681,                                   droprate =   4 }, -- Cupid Chocolate
            { itemid = xi.item.GENBUS_KABUTO,                   droprate =   6 },
            { itemid = xi.item.GENBUS_SHIELD,                   droprate =   6 },
            { itemid = xi.item.SEIRYUS_KOTE,                    droprate =   6 },
            { itemid = xi.item.SUZAKUS_SUNE_ATE,                droprate =   6 },
            { itemid = xi.item.BYAKKOS_HAIDATE,                 droprate =   6 },
            { itemid = xi.item.ANIMATOR_P1,                     droprate =   5 },
            { itemid = 17567,                                   droprate =   5 }, -- Kirin's Pole
            { itemid = 12562,                                   droprate =   5 }, -- Kirin's Osode
            { itemid = 16034,                                   droprate =   5 }, -- Sarabande Earring
            { itemid = 13415,                                   droprate =   5 }, -- Pixie Earring
            { itemid = 16300,                                   droprate =   5 }, -- Wit Pendant
            { itemid = 16303,                                   droprate =   5 }, -- Laran's Pendant
            { itemid = 15057,                                   droprate =   5 }, -- Bricta's Cuffs
            { itemid = 14943,                                   droprate =   5 }, -- Barbarossa's Moufles
            { itemid = 16376,                                   droprate =   5 }, -- Bahram Cuisses
            { itemid = 16302,                                   droprate =   5 }, -- Bloodbead Gorget
            { itemid = 11411,                                   droprate =   5 }, -- Shrewd Pumps
            { itemid = 15223,                                   droprate =   5 }, -- Ace's Helm
            { itemid = 18002,                                   droprate =   5 }, -- Perseu's Harp
            { itemid = 14873,                                   droprate =   5 }, -- Bandomusha Kote
            { itemid = 19280,                                   droprate =   5 }, -- Narigitsune
            { itemid = xi.item.WYRM_BEARD,                      droprate =   5 },
            { itemid = xi.item.BEHEMOTH_TONGUE,                 droprate =   5 },
            { itemid = xi.item.ADAMANTOISE_EGG,                 droprate =   5 },
            { itemid = xi.item.SEVENEYES,                       droprate =   5 },
            { itemid = xi.item.ALGOL,                           droprate =   5 },
            { itemid = 13658,                                   droprate =   5 }, -- Shadow Mantle
            { itemid = 14646,                                   droprate =   5 }, -- Shadow Ring
            { itemid = 11589,                                   droprate =   5 }, -- Aesir Torque
            { itemid = 16057,                                   droprate =   5 }, -- Aesir Ear Pendant
            { itemid = 11546,                                   droprate =   5 }, -- Aesir Mantle
            { itemid = 11547,                                   droprate =   5 }, -- Colossus's Mantle
            { itemid = 11590,                                   droprate =   5 }, -- Colossus's Torque
            { itemid = 16058,                                   droprate =   5 }, -- Colossus's Earring
            { itemid = 18019,                                   droprate =   5 }, -- X's Knife
            { itemid = 18057,                                   droprate =   5 }, -- Y's Scythe
            { itemid = 18101,                                   droprate =   5 }, -- Z's Trident
            { itemid = 15899,                                   droprate =   5 }, -- Velocious Belt
            { itemid = 15617,                                   droprate =   5 }, -- Barbarossa's Zerehs
            { itemid = 17586,                                   droprate =   5 }, -- Mercurial Pole
            { itemid = xi.item.JUSTICE_TORQUE,                  droprate =   5 },
            { itemid = xi.item.HOPE_TORQUE,                     droprate =   5 },
            { itemid = xi.item.PRUDENCE_TORQUE,                 droprate =   5 },
            { itemid = xi.item.FORTITUDE_TORQUE,                droprate =   5 },
            { itemid = xi.item.FAITH_TORQUE,                    droprate =   5 },
            { itemid = xi.item.TEMPERANCE_TORQUE,               droprate =   5 },
            { itemid = xi.item.LOVE_TORQUE,                     droprate =   5 },
            { itemid = xi.item.RIDILL,                          droprate =   5 },
            { itemid = xi.item.OCTAVE_CLUB,                     droprate =   5 },
            { itemid = xi.item.HAUTECLAIRE,                     droprate =   5 },
            { itemid = 13566,                                   droprate =   3 }, -- Defending Ring
            { itemid = 27456,                                   droprate =   3 }, -- Crier's Gaiters
            { itemid = 14468,                                   droprate =   3 }, -- Yinyang Robe
            { itemid = 17754,                                   droprate =   5 }, -- Sylphid Epee
            { itemid = 16154,                                   droprate =   5 }, -- Karura Hachigane
            { itemid = 16000,                                   droprate =   5 }, -- Dragoon's Earring
            { itemid = 16240,                                   droprate =   5 }, -- Erato's Cape
            { itemid = 17755,                                   droprate =   5 }, -- Beast Slayer
            { itemid = 16340,                                   droprate =   5 }, -- Armadillo Cuisses
            { itemid = 17961,                                   droprate =   5 }, -- Lion Tamer
            { itemid = 15018,                                   droprate =   5 }, -- Ritterhentzes
            { itemid = 18859,                                   droprate =   5 }, -- Kerykeion
            { itemid = 16274,                                   droprate =   5 }, -- Almah Torque
            { itemid = 15999,                                   droprate =   5 }, -- Guignol Earring
            { itemid = 15916,                                   droprate =   5 }, -- Corsair's Belt
            { itemid = 18950,                                   droprate =   5 }, -- White Joker
            { itemid = 11369,                                   droprate =   5 }, -- Numerist Pumps
            { itemid = 11368,                                   droprate =   5 }, -- Hakke Habaki
            { itemid = 15827,                                   droprate =   5 }, -- Insect Ring
            { itemid = 15828,                                   droprate =   5 }, -- Blood Ring
            { itemid = 19154,                                   droprate =   5 }, -- Ferrara
            { itemid = 11366,                                   droprate =   5 }, -- Avocat Pigaches
            { itemid = 15017,                                   droprate =   5 }, -- Toad Mittens
            { itemid = 16339,                                   droprate =   5 }, -- Paddock Trousers
            { itemid = 16153,                                   droprate =   5 }, -- Reikyo Hairpin
            { itemid = 11367,                                   droprate =   5 }, -- Nobushi Kyahan
            { itemid = 19109,                                   droprate =   5 }, -- Trilling Dagger
            { itemid = 18448,                                   droprate =   5 }, -- Hacchonenbutsu
            { itemid = 19211,                                   droprate =   5 }, -- Reacton Arm
            { itemid = 19028,                                   droprate =   5 }, -- Magic Strap
            { itemid = 18127,                                   droprate =   5 }, -- Achilles' Spear
            { itemid = 16338,                                   droprate =   5 }, -- Ruby Seraweels
            { itemid = 18949,                                   droprate =   5 }, -- Zareehkl Scythe
            { itemid = 19108,                                   droprate =   5 }, -- Zareehkl Jambiya
            { itemid = 16239,                                   droprate =   5 }, -- Solitaire Cape
            { itemid = 16175,                                   droprate =   5 }, -- Muse Tariqah
            { itemid = 16152,                                   droprate =   5 }, -- Hissho Hachimaki
            { itemid = 16174,                                   droprate =   5 }, -- Riot Shield
            { itemid = 18126,                                   droprate =   4 }, -- Tomoe
            { itemid = xi.item.ORACLES_GLOVES,                  droprate =   4 },
            { itemid = xi.item.AURUM_SABATONS,                  droprate =   4 },
            { itemid = 19031,                                   droprate =   4 }, -- Fire Grip
            { itemid = 19032,                                   droprate =   4 }, -- Water Grip
            { itemid = 19033,                                   droprate =   4 }, -- Wind Grip
            { itemid = 19034,                                   droprate =   4 }, -- Ice Grip
            { itemid = 19035,                                   droprate =   4 }, -- Thunder Grip
            { itemid = 19036,                                   droprate =   4 }, -- Earth Grip
            { itemid = 19037,                                   droprate =   4 }, -- Light Grip
            { itemid = 19038,                                   droprate =   4 }, -- Dark Grip
            { itemid = xi.item.ENKIDUS_MITTENS,                 droprate =   4 },
            { itemid = xi.item.AURUM_CUISSES,                   droprate =   4 },
            { itemid = 19153,                                   droprate =   4 }, -- Naglering
            { itemid = 18125,                                   droprate =   4 }, -- Cletine
            { itemid = xi.item.ENKIDUS_SUBLIGAR,                droprate =   4 },
            { itemid = xi.item.ORACLES_PIGACHES,                droprate =   4 },
            { itemid = 17960,                                   droprate =   4 }, -- Labrys
            { itemid = xi.item.ENKIDUS_LEGGINGS,                droprate =   4 },
            { itemid = xi.item.AURUM_GAUNTLETS,                 droprate =   4 },
            { itemid = 16176,                                   droprate =   4 }, -- Simba Buckler
            { itemid = 17753,                                   droprate =   4 }, -- Organics
            { itemid = xi.item.ORACLES_BRACONI,                 droprate =   4 },
            { itemid = 16177,                                   droprate =   4 }, -- Legion Scutum
            { itemid = 18595,                                   droprate =   4 }, -- Mekki Shakki
            { itemid = 18430,                                   droprate =   4 }, -- Oninohocho
            { itemid = 18593,                                   droprate =   2 }, -- Alkalurops
            { itemid = xi.item.ENKIDUS_CAP,                     droprate =   3 },
            { itemid = xi.item.ENKIDUS_HARNESS,                 droprate =   3 },
            { itemid = xi.item.HACHIRYU_SUNE_ATE,               droprate =   3 },
            { itemid = xi.item.ORACLES_CAP,                     droprate =   3 },
            { itemid = 18429,                                   droprate =   3 }, -- Shusui
            { itemid = xi.item.AURUM_ARMET,                     droprate =   3 },
            { itemid = 18497,                                   droprate =   3 }, -- Foolkiller
            { itemid = xi.item.HACHIRYU_HAIDATE,                droprate =   3 },
            { itemid = xi.item.ORACLES_ROBE,                    droprate =   3 },
            { itemid = 18446,                                   droprate =   3 }, -- Pachipachio
            { itemid = 18857,                                   droprate =   3 }, -- Antares
            { itemid = xi.item.AURUM_CUIRASS,                   droprate =   3 },
            { itemid = xi.item.HACHIRYU_KOTE,                   droprate =   3 },
            { itemid = xi.item.HACHIRYU_HARAMAKI,               droprate =   2 },
            { itemid = 10754,                                   droprate =   3 }, -- Moepapa Ring
            { itemid = 10755,                                   droprate =   3 }, -- Moepapa Annulet
            { itemid = 10756,                                   droprate =   3 }, -- Tjukurrpa Ring
            { itemid = 10757,                                   droprate =   3 }, -- Tjukurrpa Annulet
            { itemid = 10759,                                   droprate =   3 }, -- Aife's Annulet
            { itemid = 10817,                                   droprate =   3 }, -- Moepapa Stone
            { itemid = 10818,                                   droprate =   3 }, -- Tjukurrpa Belt
            { itemid = 10932,                                   droprate =   3 }, -- Oneiros torque
            { itemid = 10933,                                   droprate =   3 }, -- Mujin necklace
            { itemid = 10940,                                   droprate =   3 }, -- Moepapa Pendant
            { itemid = 10941,                                   droprate =   3 }, -- Tjukurrpa Medal
            { itemid = 10942,                                   droprate =   3 }, -- Aife's Medal
            { itemid = 10943,                                   droprate =   3 }, -- Moepapa Medal
            { itemid = 10972,                                   droprate =   3 }, -- Oneiros cappa
            { itemid = 10973,                                   droprate =   3 }, -- Oneiros cape
            { itemid = 10974,                                   droprate =   3 }, -- Mujin mantle
            { itemid = 10983,                                   droprate =   3 }, -- Aife's Mantle
            { itemid = 10984,                                   droprate =   3 }, -- Tjukurrpa Mantle
            { itemid = 11030,                                   droprate =   3 }, -- Oneiros earring
            { itemid = 11032,                                   droprate =   3 }, -- Mujin Stud
            { itemid = 11031,                                   droprate =   3 }, -- Oneiros pearl
            { itemid = 11456,                                   droprate =   3 }, -- Ryuga Sune-Ate
            { itemid = 11461,                                   droprate =   3 }, -- Aife's Pumps
            { itemid = 11670,                                   droprate =   3 }, -- Oneiros annulet
            { itemid = 11671,                                   droprate =   3 }, -- Oneiros ring
            { itemid = 11672,                                   droprate =   3 }, -- Mujin band
            { itemid = 11772,                                   droprate =   3 }, -- Oneiros sash
            { itemid = 11773,                                   droprate =   3 }, -- Oneiros belt
            { itemid = 11774,                                   droprate =   3 }, -- Oneiros cest
            { itemid = 11775,                                   droprate =   3 }, -- Oneiros rope
            { itemid = 11776,                                   droprate =   3 }, -- Mujin obi
            { itemid = 11820,                                   droprate =   3 }, -- Khthonios Mask
            { itemid = 11821,                                   droprate =   3 }, -- Khthonios Helm
            { itemid = 11816,                                   droprate =   3 }, -- Oneiros helm
            { itemid = 11817,                                   droprate =   3 }, -- Oneiros barbut
            { itemid = 11818,                                   droprate =   3 }, -- Oneiros headgear
            { itemid = 11819,                                   droprate =   3 }, -- Oneiros coif 
            { itemid = 11923,                                   droprate =   3 }, -- Tjukurrpa Gauntlets
            { itemid = 11918,                                   droprate =   3 }, -- Khthonios Gloves
            { itemid = 11919,                                   droprate =   3 }, -- Avesta Bangles
            { itemid = 17069,                                   droprate =   3 }, -- Moepapa Mace
            { itemid = 17358,                                   droprate =   3 }, -- Oneiros Harp
            { itemid = 18519,                                   droprate =   3 }, -- Oneiros axe
            { itemid = 18541,                                   droprate =   3 }, -- Tjukurrpa Axe 
            { itemid = 18623,                                   droprate =   3 }, -- Chtonic Staff
            { itemid = 18811,                                   droprate =   3 }, -- Oneiros grip
            { itemid = 19141,                                   droprate =   3 }, -- Oneiros knife
            { itemid = 19295,                                   droprate =   3 }, -- Mujin tanto
            { itemid = 19738,                                   droprate =   3 }, -- Aife's Bow
            { itemid = 19762,                                   droprate =   3 }, -- Oneiros Tathlum  
            { itemid = 19763,                                   droprate =   3 }, -- Oneiros Cluster  
            { itemid = 19767,                                   droprate =   3 }, -- Oneiros pebble
            { itemid = 19790,                                   droprate =   3 }, -- Oneiros lance
            { itemid = xi.item.MURREY_GRISAILLE,                droprate =   1 },
            { itemid =    0,                                    droprate = 250 }, -- nothing
        },
        -- Slot 5, Misc/Medicine --
        {
            { itemid = xi.item.VILE_ELIXIR,                     droprate = 150 },
            { itemid = 4149,                                    droprate = 150 }, -- Panacea
            { itemid = xi.item.VILE_ELIXIR_P1,                  droprate = 140 },
            { itemid = xi.item.HI_RERAISER,                     droprate = 140 },
            { itemid = xi.item.REMEDY,                          droprate = 140 },
            { itemid = xi.item.ICARUS_WING,                     droprate = 140 },
            { itemid = xi.item.SUPER_RERAISER,                  droprate = 140 },
        },
        -- Slot 9, Misc/Medicine --
        {
            { itemid = xi.item.VILE_ELIXIR,                     droprate = 150 },
            { itemid = 4149,                                    droprate = 150 }, -- Panacea
            { itemid = xi.item.VILE_ELIXIR_P1,                  droprate = 140 },
            { itemid = xi.item.HI_RERAISER,                     droprate = 140 },
            { itemid = xi.item.REMEDY,                          droprate = 140 },
            { itemid = xi.item.ICARUS_WING,                     droprate = 140 },
            { itemid = xi.item.SUPER_RERAISER,                  droprate = 140 },
        },
    },
}

--
-- Mars Orb Loot
--

m.marsLoot =
{

    [15] =
    {   -- Slot 1, Currency --
        {
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  50 },
            { itemid = xi.item.ALEXANDRITE,                     droprate = 100 },
            { itemid = xi.item.ONE_BYNE_BILL,                   droprate = 100 },
            { itemid = xi.item.ORDELLE_BRONZEPIECE,             droprate = 100 },
            { itemid = xi.item.TUKUKU_WHITESHELL,               droprate = 100 },
            { itemid = xi.item.BEASTMENS_SEAL,                  droprate =  95 },
            { itemid = xi.item.KINDREDS_SEAL,                   droprate =  95 },
            { itemid = xi.item.IMPERIAL_BRONZE_PIECE,           droprate =  25 },
            { itemid = xi.item.IMPERIAL_SILVER_PIECE,           droprate =  25 },
            { itemid = xi.item.FORGOTTEN_THOUGHT,               droprate =  50 },
            { itemid = xi.item.FORGOTTEN_HOPE,                  droprate =  50 },
            { itemid = xi.item.FORGOTTEN_TOUCH,                 droprate =  50 },
            { itemid = xi.item.FORGOTTEN_JOURNEY,               droprate =  50 },
            { itemid = xi.item.FORGOTTEN_STEP,                  droprate =  50 },
            { itemid =  8798,                                   droprate =  50 }, -- HP Bayld
            { itemid =  3283,                                   droprate =   1 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =   1 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =   1 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =   1 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =   1 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =   1 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =   1 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =   1 }, -- Wyrmal Tatter            
        },
        -- Slot 2, Pop Item --
        {
            { itemid = xi.item.CURTANA,                         droprate =  20 },
            { itemid = xi.item.CHUNK_OF_DIORITE,                droprate =  20 },
            { itemid = xi.item.FLASK_OF_ROMAEVE_SPRING_WATER,   droprate =  20 },
            { itemid = xi.item.RED_CRYPTEX,                     droprate =  20 },
            { itemid = xi.item.DARKSTEEL_ENGRAVING,             droprate =  20 },
            { itemid = xi.item.SEVEN_KNOT_QUIPU,                droprate =  20 },
            { itemid = xi.item.GALKA_FANG_SACK,                 droprate =  20 },
            { itemid = xi.item.JADE_CRYPTEX,                    droprate =  20 },
            { itemid = xi.item.SILVER_ENGRAVING,                droprate =  20 },
            { itemid = xi.item.MITHRA_FANG_SACK,                droprate =  20 },
            { itemid = xi.item.THIRTEEN_KNOT_QUIPU,             droprate =  20 },
            { itemid = xi.item.TIGER_LEATHER_MISSIVE,           droprate =  20 },
            { itemid = xi.item.BEHEMOTH_LEATHER_MISSIVE,        droprate =  20 },
            { itemid = xi.item.RAM_LEATHER_MISSIVE,             droprate =  20 },
            { itemid = xi.item.HOUND_FANG_SACK,                 droprate =  20 },
            { itemid = xi.item.DHALMEL_LEATHER_MISSIVE,         droprate =  20 },
            { itemid = xi.item.BUNNY_FANG_SACK,                 droprate =  20 },
            { itemid = xi.item.SHEEP_LEATHER_MISSIVE,           droprate =  20 },
            { itemid = xi.item.COEURL_LEATHER_MISSIVE,          droprate =  20 },
            { itemid = xi.item.MIRATETES_MEMOIRS,               droprate =  30 },
            { itemid =  1784,                                   droprate =  20 }, -- Phuabo Organ
            { itemid =  1785,                                   droprate =  20 }, -- Xzomit Organ
            { itemid =  1786,                                   droprate =  20 }, -- Aern Organ
            { itemid =  1787,                                   droprate =  20 }, -- Hpemde Organ
            { itemid =  1788,                                   droprate =  20 }, -- Yovra Organ
            { itemid = xi.item.HIGH_QUALITY_PHUABO_ORGAN,       droprate =  20 },
            { itemid = xi.item.HIGH_QUALITY_HPEMDE_ORGAN,       droprate =  20 },
            { itemid = xi.item.HIGH_QUALITY_EUVHI_ORGAN,        droprate =  20 },
            { itemid = xi.item.HIGH_QUALITY_AERN_ORGAN,         droprate =  20 },
            { itemid =  1855,                                   droprate =  20 }, -- H.Q. Xzomit Organ
            { itemid =  1872,                                   droprate =  20 }, -- Ghrah M Chip
            { itemid =  1783,                                   droprate =  20 }, -- Luminian Tissue
            { itemid = xi.item.JAR_OF_PEISTE_PELLETS,           droprate =  20 },
            { itemid = xi.item.JAR_OF_GNAT_PELLETS,             droprate =  20 },
            { itemid =  2565,                                   droprate =  20 }, -- Gnole Pellets
            { itemid = xi.item.PRELATE_KEY,                     droprate =   5 },
            { itemid = xi.item.FLICKERING_LANTERN,              droprate =   5 },
            { itemid = xi.item.TONBERRY_RATTLE,                 droprate =   5 },
            { itemid = xi.item.OFFERING_TO_UGGALEPIH,           droprate =   5 },
            { itemid = xi.item.UGGALEPIH_WHISTLE,               droprate =   5 },
            { itemid = xi.item.BAG_OF_BEE_LARVAE,               droprate =   5 },
            { itemid = xi.item.CARBUNCLES_RUBY,                 droprate =   5 },
            { itemid = xi.item.SAHAGIN_KEY,                     droprate =   5 },
            { itemid =     0,                                   droprate = 250 }, -- Nothing
        },
        -- Slot 3, Equipment --
        {
            { itemid = xi.item.MELEE_CAPE,                      droprate =   5 },
            { itemid = xi.item.ABYSS_CAPE,                      droprate =   5 },
            { itemid = xi.item.ASSASSINS_CAPE,                  droprate =   5 },
            { itemid = xi.item.VALOR_CAPE,                      droprate =   5 },
            { itemid = xi.item.BARDS_CAPE,                      droprate =   5 },
            { itemid = xi.item.SUMMONERS_CAPE,                  droprate =   5 },
            { itemid = xi.item.WARRIORS_STONE,                  droprate =   5 },
            { itemid = xi.item.CLERICS_BELT,                    droprate =   5 },
            { itemid = xi.item.DUELISTS_BELT,                   droprate =   5 },
            { itemid = xi.item.SORCERERS_BELT,                  droprate =   5 },
            { itemid = xi.item.MONSTER_BELT,                    droprate =   5 },
            { itemid = xi.item.SCOUTS_BELT,                     droprate =   5 },
            { itemid = xi.item.KOGA_SARASHI,                    droprate =   5 },
            { itemid = xi.item.WYRM_BELT,                       droprate =   5 },
            { itemid = xi.item.SAOTOME_KOSHI_ATE,               droprate =   5 },
            { itemid = xi.item.COMMODORE_BELT,                  droprate =   5 },
            { itemid = xi.item.ARGUTE_BELT,                     droprate =   5 },
            { itemid = xi.item.MIRAGE_MANTLE,                   droprate =   5 },
            { itemid = xi.item.PANTIN_CAPE,                     droprate =   5 },
            { itemid = xi.item.ETOILE_CAPE,                     droprate =   5 },
            { itemid = xi.item.KOBO_OBI,                        droprate =   5 },  -- GEO Dynamis Accessory
            { itemid = xi.item.TANTALIC_CAPE,                   droprate =   5 },  -- RUN Dynamis Accessory
            { itemid = xi.item.ARIES_SUBLIGAR,                  droprate =   5 },
            { itemid = xi.item.TAURUS_SUBLIGAR,                 droprate =   5 },
            { itemid = xi.item.GEMINI_SUBLIGAR,                 droprate =   5 },
            { itemid = xi.item.CANCER_SUBLIGAR,                 droprate =   5 },
            { itemid = xi.item.LEO_SUBLIGAR,                    droprate =   5 },
            { itemid = xi.item.VIRGO_SUBLIGAR,                  droprate =   5 },
            { itemid = xi.item.LIBRA_SUBLIGAR,                  droprate =   5 },
            { itemid = xi.item.SCORPIUS_SUBLIGAR,               droprate =   5 },
            { itemid = xi.item.SAGITTARIUS_SUBLIGAR,            droprate =   5 },
            { itemid = xi.item.CAPRICORNUS_SUBLIGAR,            droprate =   5 },
            { itemid = xi.item.AQUARIUS_SUBLIGAR,               droprate =   5 },
            { itemid = xi.item.PISCES_SUBLIGAR,                 droprate =   5 },
            { itemid = xi.item.OPHIUCHUS_SUBLIGAR,              droprate =   5 },
            { itemid = xi.item.CARPENTERS_BELT,                 droprate =   5 },
            { itemid = xi.item.BLACKSMITHS_BELT,                droprate =   5 },
            { itemid = xi.item.GOLDSMITHS_BELT,                 droprate =   5 },
            { itemid = xi.item.WEAVERS_BELT,                    droprate =   5 },
            { itemid = xi.item.TANNERS_BELT,                    droprate =   5 },
            { itemid = xi.item.BONEWORKERS_BELT,                droprate =   5 },
            { itemid = xi.item.ALCHEMISTS_BELT,                 droprate =   5 },
            { itemid = xi.item.CULINARIANS_BELT,                droprate =   5 },
            { itemid = xi.item.FISHERMANS_BELT,                 droprate =   5 },
            { itemid = xi.item.HAMAYUMI,                        droprate =   5 },
            { itemid = xi.item.DIA_WAND,                        droprate =   5 },
            { itemid = xi.item.STONE_GORGET,                    droprate =   5 },
            { itemid =  17708,                                  droprate =   5 }, -- Auriga Xiphos
            { itemid =  15220,                                  droprate =   5 }, -- Rain Hat
            { itemid =  15468,                                  droprate =   5 }, -- Resentment Cape
            { itemid =  15505,                                  droprate =   5 }, -- Dhalmel Whistle
            { itemid =  14667,                                  droprate =   5 }, -- Carect Ring
            { itemid =  xi.item.GOTHIC_SABATONS,                droprate =   5 },
            { itemid =  xi.item.GOTHIC_GAUNTLETS,               droprate =   5 },
            { itemid =  11529,                                  droprate =   5 }, -- Frugal Cape
            { itemid =  16187,                                  droprate =   5 }, -- Adoubeurs Pavise
            { itemid =  16899,                                  droprate =   5 }, -- Hototogisu
            { itemid =  16374,                                  droprate =   5 }, -- Layqa Seraweels
            { itemid =  17199,                                  droprate =   5 }, -- Loxley Bow
            { itemid =  16882,                                  droprate =   5 }, -- Calamar
            { itemid =  17504,                                  droprate =   5 }, -- Pagures
            { itemid =  16884,                                  droprate =   5 }, -- Narval
            { itemid =  17503,                                  droprate =   5 }, -- Exocets
            { itemid =  19238,                                  droprate =   5 }, -- Jasper Tathlum
            { itemid =  11404,                                  droprate =   5 }, -- Promptitude Solea
            { itemid =  15897,                                  droprate =   5 }, -- Grace Corset
            { itemid =  13803,                                  droprate =   5 }, -- Shaman's Cloak
            { itemid =  19237,                                  droprate =   5 }, -- Slick Dart
            { itemid =  15942,                                  droprate =   5 }, -- Summoning Belt
            { itemid =  xi.item.MUSHROOM_HELM,                  droprate =   5 },
            { itemid =  xi.item.LUNA_SUBLIGAR,                  droprate =   5 },
            { itemid =  16980,                                  droprate =   5 }, -- Sukesada
            { itemid =  13912,                                  droprate =   5 }, -- Shadow Mask
            { itemid =  16943,                                  droprate =   5 }, -- Ascalon
            { itemid =  14063,                                  droprate =   5 }, -- Protecting Bangles
            { itemid =  14064,                                  droprate =   5 }, -- Sand Gloves
            { itemid =  17651,                                  droprate =   5 }, -- Dainslaif
            { itemid =  17924,                                  droprate =   5 }, -- Tungi
            { itemid =  16734,                                  droprate =   5 }, -- Pendragon Axe
            { itemid =  15995,                                  droprate =   5 }, -- Carline Earring
            { itemid =  16127,                                  droprate =   5 }, -- Carline Ribbon
            { itemid =  16125,                                  droprate =   5 }, -- Breeder Mask
            { itemid =  15001,                                  droprate =   5 }, -- Breeder Mufflers
            { itemid =  15946,                                  droprate =   5 }, -- Tempest Belt
            { itemid =  11405,                                  droprate =   5 }, -- Kyoshu Kyahan
            { itemid =  11533,                                  droprate =   5 }, -- Lyricist's Gonnelle
            { itemid =  16298,                                  droprate =   5 }, -- Knack Pendant
            { itemid =  17454,                                  droprate =   5 }, -- Asklepios
            { itemid =  17455,                                  droprate =   5 }, -- Skirnir's Wand
            { itemid =  16912,                                  droprate =   5 }, -- Kitsutsuki
            { itemid =  17926,                                  droprate =   5 }, -- Acha D'Armas
            { itemid =  17982,                                  droprate =   5 }, -- Kard
            { itemid =  17983,                                  droprate =   5 }, -- Valiant Knife
            { itemid =  18042,                                  droprate =   5 }, -- Ascention
            { itemid =  17563,                                  droprate =   5 }, -- Power Staff
            { itemid =  17969,                                  droprate =   5 }, -- Fendoir
            { itemid =  18608,                                  droprate =   5 }, -- Atesh Pole
            { itemid =  xi.item.ASTRAL_ASPIS,                   droprate =   5 },
            { itemid =  xi.item.GAE_BOLG,                       droprate =   5 },
            { itemid =  xi.item.LOHAR,                          droprate =   5 },
            { itemid =    0,                                    droprate = 500 }, -- Nothing
        },
        -- Slot 4, Misc/Medicine --
        {
            { itemid = xi.item.FIRE_CLUSTER,                    droprate =  30 },
            { itemid = xi.item.ICE_CLUSTER,                     droprate =  30 },
            { itemid = xi.item.WIND_CLUSTER,                    droprate =  30 },
            { itemid = xi.item.EARTH_CLUSTER,                   droprate =  30 },
            { itemid = xi.item.LIGHTNING_CLUSTER,               droprate =  30 },
            { itemid = xi.item.WATER_CLUSTER,                   droprate =  30 },
            { itemid = xi.item.LIGHT_CLUSTER,                   droprate =  30 },
            { itemid = xi.item.DARK_CLUSTER,                    droprate =  30 },
            { itemid = xi.item.MOAT_CARP,                       droprate =  10 },
            { itemid =    0,                                    droprate = 750 }, -- nothing
        },
    },

    [30] =
    {   -- Slot 1, Currency --
        {
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  50 },
            { itemid = xi.item.ALEXANDRITE,                     droprate = 100 },
            { itemid = xi.item.ONE_BYNE_BILL,                   droprate = 100 },
            { itemid = xi.item.ORDELLE_BRONZEPIECE,             droprate = 100 },
            { itemid = xi.item.TUKUKU_WHITESHELL,               droprate = 100 },
            { itemid = xi.item.BEASTMENS_SEAL,                  droprate =  95 },
            { itemid = xi.item.KINDREDS_SEAL,                   droprate = 100 },
            { itemid = xi.item.IMPERIAL_SILVER_PIECE,           droprate =  20 },
            { itemid = xi.item.IMPERIAL_MYTHRIL_PIECE,          droprate =  20 },
            { itemid = xi.item.FORGOTTEN_THOUGHT,               droprate =  45 },
            { itemid = xi.item.FORGOTTEN_HOPE,                  droprate =  45 },
            { itemid = xi.item.FORGOTTEN_TOUCH,                 droprate =  45 },
            { itemid = xi.item.FORGOTTEN_JOURNEY,               droprate =  45 },
            { itemid = xi.item.FORGOTTEN_STEP,                  droprate =  45 },
            { itemid =  8798,                                   droprate =  50 }, -- HP Bayld
            { itemid =  3283,                                   droprate =   5 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =   5 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =   5 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =   5 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =   5 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =   5 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =   5 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =   5 }, -- Wyrmal Tatter   
        },
        -- Slot 10, Tatters --
        {
            { itemid =  3283,                                   droprate =  31 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  31 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  31 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  32 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  31 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  31 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  32 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  31 }, -- Wyrmal Tatter
            { itemid =     0,                                   droprate = 750 }, -- Nothing
        },
        -- Slot 2, Pop Items --
        {
            { itemid = xi.item.CURTANA,                         droprate =  30 },
            { itemid = xi.item.CHUNK_OF_DIORITE,                droprate =  30 },
            { itemid = xi.item.FLASK_OF_ROMAEVE_SPRING_WATER,   droprate =  30 },
            { itemid = xi.item.RED_CRYPTEX,                     droprate =  20 },
            { itemid = xi.item.DARKSTEEL_ENGRAVING,             droprate =  20 },
            { itemid = xi.item.SEVEN_KNOT_QUIPU,                droprate =  20 },
            { itemid = xi.item.GALKA_FANG_SACK,                 droprate =  20 },
            { itemid = xi.item.JADE_CRYPTEX,                    droprate =  20 },
            { itemid = xi.item.SILVER_ENGRAVING,                droprate =  20 },
            { itemid = xi.item.MITHRA_FANG_SACK,                droprate =  20 },
            { itemid = xi.item.THIRTEEN_KNOT_QUIPU,             droprate =  20 },
            { itemid = xi.item.TIGER_LEATHER_MISSIVE,           droprate =  20 },
            { itemid = xi.item.BEHEMOTH_LEATHER_MISSIVE,        droprate =  20 },
            { itemid = xi.item.RAM_LEATHER_MISSIVE,             droprate =  20 },
            { itemid = xi.item.HOUND_FANG_SACK,                 droprate =  20 },
            { itemid = xi.item.DHALMEL_LEATHER_MISSIVE,         droprate =  20 },
            { itemid = xi.item.BUNNY_FANG_SACK,                 droprate =  20 },
            { itemid = xi.item.SHEEP_LEATHER_MISSIVE,           droprate =  20 },
            { itemid = xi.item.COEURL_LEATHER_MISSIVE,          droprate =  20 },
            { itemid = xi.item.MIRATETES_MEMOIRS,               droprate =  20 },
            { itemid = xi.item.HIGH_QUALITY_PHUABO_ORGAN,       droprate =  15 },
            { itemid = xi.item.HIGH_QUALITY_HPEMDE_ORGAN,       droprate =  15 },
            { itemid = xi.item.HIGH_QUALITY_EUVHI_ORGAN,        droprate =  15 },
            { itemid = xi.item.HIGH_QUALITY_AERN_ORGAN,         droprate =  15 },
            { itemid =  1855,                                   droprate =  15 }, -- H.Q. Xzomit Organ
            { itemid =  1784,                                   droprate =  20 }, -- Phuabo Organ
            { itemid =  1785,                                   droprate =  20 }, -- Xzomit Organ
            { itemid =  1786,                                   droprate =  20 }, -- Aern Organ
            { itemid =  1787,                                   droprate =  20 }, -- Hpemde Organ
            { itemid =  1788,                                   droprate =  20 }, -- Yovra Organ
            { itemid =  1872,                                   droprate =  20 }, -- Ghrah M Chip
            { itemid =  1783,                                   droprate =  20 }, -- Luminian Tissue
            { itemid =  1288,                                   droprate =   5 }, -- Wooden Hakutatku Eye
            { itemid =  1289,                                   droprate =   5 }, -- Burning Hakutatku Eye
            { itemid =  1290,                                   droprate =   5 }, -- Earthen Hakutatku Eye
            { itemid =  1291,                                   droprate =   5 }, -- Golden Hakutatku Eye
            { itemid =  1292,                                   droprate =   5 }, -- Damp Hakutatku Eye
            { itemid = xi.item.JAR_OF_PEISTE_PELLETS,           droprate =  20 },
            { itemid = xi.item.JAR_OF_GNAT_PELLETS,             droprate =  20 },
            { itemid =  2565,                                   droprate =  20 }, -- Gnole Pellets
            { itemid = xi.item.PRELATE_KEY,                     droprate =   5 },
            { itemid = xi.item.FLICKERING_LANTERN,              droprate =   5 },
            { itemid = xi.item.TONBERRY_RATTLE,                 droprate =   5 },
            { itemid = xi.item.OFFERING_TO_UGGALEPIH,           droprate =   5 },
            { itemid = xi.item.UGGALEPIH_WHISTLE,               droprate =   5 },
            { itemid = xi.item.BAG_OF_BEE_LARVAE,               droprate =   5 },
            { itemid = xi.item.CARBUNCLES_RUBY,                 droprate =   5 },
            { itemid = xi.item.SAHAGIN_KEY,                     droprate =   5 },
            { itemid = xi.item.DEED_OF_PLACIDITY,               droprate =  20 },
            { itemid = xi.item.DEED_OF_SENSIBILITY,             droprate =  20 },
            { itemid =  1854,                                   droprate =  20 }, -- Deed of Moderation
            { itemid = xi.item.FOMOR_CODEX,                     droprate =  20 },
            { itemid = xi.item.POT_OF_CLUSTERED_TAR,            droprate =  20 },
            { itemid =  1782,                                   droprate =  20 }, -- Florid Stone
            { itemid = xi.item.PREMIUM_BAG,                     droprate =  20 },
            { itemid = xi.item.AIR_TANK,                        droprate =  20 },
            { itemid = xi.item.ARK_PENTASPHERE,                 droprate =   5 },
            { itemid = xi.item.PIRATES_CHART,                   droprate =   5 },
            { itemid = xi.item.BRIGANDS_CHART,                  droprate =   5 },
            { itemid = xi.item.BOTTLE_OF_PSYCHOANIMA,           droprate =   5 },
            { itemid = xi.item.BOTTLE_OF_HYSTEROANIMA,          droprate =   5 },
            { itemid = xi.item.BOTTLE_OF_TERROANIMA,            droprate =   5 },
            { itemid =   724,                                   droprate =  20 }, -- Magnolia Lumber
            { itemid =   677,                                   droprate =  20 }, -- White Steel
        },
        -- Slot 3, Equipment --
        {
            { itemid = xi.item.MELEE_CAPE,                      droprate =   5 },
            { itemid = xi.item.ABYSS_CAPE,                      droprate =   5 },
            { itemid = xi.item.ASSASSINS_CAPE,                  droprate =   5 },
            { itemid = xi.item.VALOR_CAPE,                      droprate =   5 },
            { itemid = xi.item.BARDS_CAPE,                      droprate =   5 },
            { itemid = xi.item.SUMMONERS_CAPE,                  droprate =   5 },
            { itemid = xi.item.WARRIORS_STONE,                  droprate =   5 },
            { itemid = xi.item.CLERICS_BELT,                    droprate =   5 },
            { itemid = xi.item.DUELISTS_BELT,                   droprate =   5 },
            { itemid = xi.item.SORCERERS_BELT,                  droprate =   5 },
            { itemid = xi.item.MONSTER_BELT,                    droprate =   5 },
            { itemid = xi.item.SCOUTS_BELT,                     droprate =   5 },
            { itemid = xi.item.KOGA_SARASHI,                    droprate =   5 },
            { itemid = xi.item.WYRM_BELT,                       droprate =   5 },
            { itemid = xi.item.SAOTOME_KOSHI_ATE,               droprate =   5 },
            { itemid = xi.item.COMMODORE_BELT,                  droprate =   5 },
            { itemid = xi.item.ARGUTE_BELT,                     droprate =   5 },
            { itemid = xi.item.MIRAGE_MANTLE,                   droprate =   5 },
            { itemid = xi.item.PANTIN_CAPE,                     droprate =   5 },
            { itemid = xi.item.ETOILE_CAPE,                     droprate =   5 },
            { itemid = xi.item.KOBO_OBI,                        droprate =   5 },  -- GEO Dynamis Accessory
            { itemid = xi.item.TANTALIC_CAPE,                   droprate =   5 },  -- RUN Dynamis Accessory
            { itemid = xi.item.ARIES_SUBLIGAR,                  droprate =   4 },
            { itemid = xi.item.TAURUS_SUBLIGAR,                 droprate =   4 },
            { itemid = xi.item.GEMINI_SUBLIGAR,                 droprate =   4 },
            { itemid = xi.item.CANCER_SUBLIGAR,                 droprate =   4 },
            { itemid = xi.item.LEO_SUBLIGAR,                    droprate =   4 },
            { itemid = xi.item.VIRGO_SUBLIGAR,                  droprate =   4 },
            { itemid = xi.item.LIBRA_SUBLIGAR,                  droprate =   4 },
            { itemid = xi.item.SCORPIUS_SUBLIGAR,               droprate =   4 },
            { itemid = xi.item.SAGITTARIUS_SUBLIGAR,            droprate =   4 },
            { itemid = xi.item.CAPRICORNUS_SUBLIGAR,            droprate =   4 },
            { itemid = xi.item.AQUARIUS_SUBLIGAR,               droprate =   4 },
            { itemid = xi.item.PISCES_SUBLIGAR,                 droprate =   4 },
            { itemid = xi.item.OPHIUCHUS_SUBLIGAR,              droprate =   4 },
            { itemid = xi.item.CARPENTERS_BELT,                 droprate =   4 },
            { itemid = xi.item.BLACKSMITHS_BELT,                droprate =   4 },
            { itemid = xi.item.GOLDSMITHS_BELT,                 droprate =   4 },
            { itemid = xi.item.WEAVERS_BELT,                    droprate =   4 },
            { itemid = xi.item.TANNERS_BELT,                    droprate =   4 },
            { itemid = xi.item.BONEWORKERS_BELT,                droprate =   4 },
            { itemid = xi.item.ALCHEMISTS_BELT,                 droprate =   4 },
            { itemid = xi.item.CULINARIANS_BELT,                droprate =   4 },
            { itemid = xi.item.FISHERMANS_BELT,                 droprate =   4 },
            { itemid = xi.item.HAMAYUMI,                        droprate =   5 },
            { itemid = xi.item.DIA_WAND,                        droprate =   5 },
            { itemid = xi.item.STONE_GORGET,                    droprate =   5 },
            { itemid = xi.item.PILGRIMS_WAND,                   droprate =   5 },
            { itemid = xi.item.GELONG_STAFF,                    droprate =   5 },
            { itemid = xi.item.WEBCUTTER,                       droprate =   5 },
            { itemid =  18412,                                  droprate =   5 }, -- Gassan
            { itemid =  17708,                                  droprate =   5 }, -- Auriga Xiphos
            { itemid =  18359,                                  droprate =   5 }, -- Boreas Cesti
            { itemid =  15220,                                  droprate =   5 }, -- Rain Hat
            { itemid =  15468,                                  droprate =   5 }, -- Resentment Cape
            { itemid =  15505,                                  droprate =   5 }, -- Dhalmel Whistle
            { itemid =  14667,                                  droprate =   5 }, -- Carect Ring
            { itemid =  xi.item.GOTHIC_SABATONS,                droprate =   5 },
            { itemid =  xi.item.GOTHIC_GAUNTLETS,               droprate =   5 },
            { itemid =  11529,                                  droprate =   5 }, -- Frugal Cape
            { itemid =  16187,                                  droprate =   5 }, -- Adoubeurs Pavise
            { itemid =  16899,                                  droprate =   5 }, -- Hototogisu
            { itemid =  16374,                                  droprate =   5 }, -- Layqa Seraweels
            { itemid =  17199,                                  droprate =   5 }, -- Loxley Bow
            { itemid =  16882,                                  droprate =   5 }, -- Calamar
            { itemid =  17504,                                  droprate =   5 }, -- Pagures
            { itemid =  16884,                                  droprate =   5 }, -- Narval
            { itemid =  17503,                                  droprate =   5 }, -- Exocets
            { itemid =  19238,                                  droprate =   5 }, -- Jasper Tathlum
            { itemid =  11404,                                  droprate =   5 }, -- Promptitude Solea
            { itemid =  15897,                                  droprate =   5 }, -- Grace Corset
            { itemid =  13803,                                  droprate =   5 }, -- Shaman's Cloak
            { itemid =  19237,                                  droprate =   5 }, -- Slick Dart
            { itemid =  15942,                                  droprate =   5 }, -- Summoning Belt
            { itemid =  xi.item.MUSHROOM_HELM,                  droprate =   5 },
            { itemid =  xi.item.LUNA_SUBLIGAR,                  droprate =   5 },
            { itemid =  16980,                                  droprate =   5 }, -- Sukesada
            { itemid =  13912,                                  droprate =   5 }, -- Shadow Mask
            { itemid =  16943,                                  droprate =   5 }, -- Ascalon
            { itemid =  14063,                                  droprate =   5 }, -- Protecting Bangles
            { itemid =  14064,                                  droprate =   5 }, -- Sand Gloves
            { itemid =  17651,                                  droprate =   5 }, -- Dainslaif
            { itemid =  17924,                                  droprate =   5 }, -- Tungi
            { itemid =  16734,                                  droprate =   5 }, -- Pendragon Axe
            { itemid =  15995,                                  droprate =   5 }, -- Carline Earring
            { itemid =  16127,                                  droprate =   5 }, -- Carline Ribbon
            { itemid =  16125,                                  droprate =   5 }, -- Breeder Mask
            { itemid =  15001,                                  droprate =   5 }, -- Breeder Mufflers
            { itemid =  15946,                                  droprate =   5 }, -- Tempest Belt
            { itemid =  11405,                                  droprate =   5 }, -- Kyoshu Kyahan
            { itemid =  11533,                                  droprate =   5 }, -- Lyricist's Gonnelle
            { itemid =  16298,                                  droprate =   5 }, -- Knack Pendant
            { itemid =  17454,                                  droprate =   5 }, -- Asklepios
            { itemid =  17455,                                  droprate =   5 }, -- Skirnir's Wand
            { itemid =  16912,                                  droprate =   5 }, -- Kitsutsuki
            { itemid =  17926,                                  droprate =   5 }, -- Acha D'Armas
            { itemid =  17982,                                  droprate =   5 }, -- Kard
            { itemid =  17983,                                  droprate =   5 }, -- Valiant Knife
            { itemid =  18042,                                  droprate =   5 }, -- Ascention
            { itemid =  17563,                                  droprate =   5 }, -- Power Staff
            { itemid =  17969,                                  droprate =   5 }, -- Fendoir
            { itemid =  18608,                                  droprate =   5 }, -- Atesh Pole
            { itemid =  16727,                                  droprate =   5 }, -- Eisentaenzer
            { itemid =  17971,                                  droprate =   5 }, -- Tartaglia
            { itemid =  19235,                                  droprate =   5 }, -- Veuglaire
            { itemid =  16375,                                  droprate =   5 }, -- Surge Subligar
            { itemid =  xi.item.ASTRAL_ASPIS,                   droprate =   5 },
            { itemid =  xi.item.GAE_BOLG,                       droprate =   5 },
            { itemid =  xi.item.LOHAR,                          droprate =   5 },
            { itemid =   19122,                                 droprate =   5 }, -- Courser's Pugio
            { itemid =   16081,                                 droprate =   5 }, -- Curate's Hat
            { itemid =   15882,                                 droprate =   5 }, -- Othinus' Bow
            { itemid =   17244,                                 droprate =   5 }, -- Storm Belt
            { itemid =   14806,                                 droprate =   5 }, -- Intruder Earring
            { itemid =   14466,                                 droprate =   5 }, -- Fomor Tunic
            { itemid =   18007,                                 droprate =   5 }, -- Chiroptera Dagger
            { itemid =   17510,                                 droprate =   5 }, -- Vampiric Claws
            { itemid =   14763,                                 droprate =   5 }, -- Boroka Earring
            { itemid =   13178,                                 droprate =   5 }, -- Auditory Torque
            { itemid =   15943,                                 droprate =   5 }, -- Virtuoso Belt
            { itemid =   14884,                                 droprate =   5 }, -- Mycophile Cuffs
            { itemid =   17794,                                 droprate =   5 }, -- Niokiyotsuna
            { itemid =   15219,                                 droprate =   5 }, -- Sinister Mask
            { itemid =   16368,                                 droprate =   5 }, -- Herder's Subligar
            { itemid =   14724,                                 droprate =   5 }, -- Moldavite Earring
            { itemid =   16279,                                 droprate =   5 }, -- Pile Chain
            { itemid =   15546,                                 droprate =   5 }, -- Fasting Ring
            { itemid =   16299,                                 droprate =   5 }, -- Lleu's Charm
            { itemid =   11496,                                 droprate =   5 }, -- Fenrir's Crown
            { itemid =   14168,                                 droprate =   5 }, -- Dune Boots
            { itemid =   17854,                                 droprate =   5 }, -- Cradle Horn
            { itemid =   19239,                                 droprate =   5 }, -- Astrolable
            { itemid =   16169,                                 droprate =   5 }, -- Caballero Shield
            { itemid =   17653,                                 droprate =   5 }, -- Hrotti
            { itemid =   18027,                                 droprate =   5 }, -- Palladium Dagger
            { itemid =   17564,                                 droprate =   5 }, -- Cocytus Pole
            { itemid =   16426,                                 droprate =   5 }, -- Avengers
            { itemid =   19121,                                 droprate =   5 }, -- Sleight Kukri
            { itemid =   15944,                                 droprate =   5 }, -- Selemnus Belt
            { itemid =   16297,                                 droprate =   4 }, -- Shepherd's Chain
            { itemid =  xi.item.KAMEWARI,                       droprate =   5 },
            { itemid =  xi.item.NADRS,                          droprate =   5 },
            { itemid =  xi.item.ALTDORFS_EARRING,               droprate =   5 },
            { itemid =  xi.item.WILHELMS_EARRING,               droprate =   5 },
            { itemid =  xi.item.MINSTRELS_DAGGER,               droprate =   5 },
            { itemid =  xi.item.SAND_CHARM,                     droprate =   5 },
            { itemid =   15692,                                 droprate =   3 }, -- Storm Crackows
            { itemid =   14669,                                 droprate =   3 }, -- Jaeger Ring
            { itemid =   15351,                                 droprate =   2 }, -- Bounding Boots
            { itemid =   18018,                                 droprate =   2 }, -- Sirocco Kukri
            { itemid =   13567,                                 droprate =   2 }, -- Bomb Queen Ring
            { itemid =   15547,                                 droprate =   2 }, -- Vilma's Ring
            { itemid =   26164,                                 droprate =   2 }, -- Caliber Ring
            { itemid =   15183,                                 droprate =   5 }, -- Dobson Bandana
            { itemid =   15184,                                 droprate =   2 }, -- Voyager Sallet
            { itemid =   14986,                                 droprate =   2 }, -- Ochimusha Kote
            { itemid =   15737,                                 droprate =   2 }, -- Sarutobi Kyahan
            { itemid =   15551,                                 droprate =   2 }, -- Shikaree Ring
            { itemid =  xi.item.EMPRESS_HAIRPIN,                droprate =   2 },
            { itemid =  xi.item.JOYEUSE,                        droprate =   2 },
            { itemid =  xi.item.DRYAD_STAFF,                    droprate =   2 },
            { itemid =  xi.item.VALIS_BOW,                      droprate =   2 },
            { itemid =  xi.item.RETALIATORS,                    droprate =   2 },
            { itemid =  xi.item.UNGUR_BOOMERANG,                droprate =   2 },
            { itemid =   15515,                                 droprate =   1 }, -- Peacock Amulet
            { itemid =  xi.item.TROTTER_BOOTS,                  droprate =   1 },
            { itemid =    0,                                    droprate = 250 }, -- Nothing
        },
        -- Slot 4, Materials --
        {
            { itemid = xi.item.MOAT_CARP,                       droprate =   5 },
            { itemid = xi.item.IRON_INGOT,                      droprate =   6 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   6 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   6 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   6 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   6 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   6 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   6 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   6 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   6 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   6 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   6 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   6 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   6 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   6 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   6 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   6 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   6 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   6 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   6 },
            { itemid = xi.item.RAM_HORN,                        droprate =   6 },
            { itemid = xi.item.ELM_LOG,                         droprate =   6 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   6 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   6 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   6 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   6 },
            { itemid = xi.item.SACK_OF_SILICA,                  droprate =   6 },
            { itemid =  850,                                    droprate =   6 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   6 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   6 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   6 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   6 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   6 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   6 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   6 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   6 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   4 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   4 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   4 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   4 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   4 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   4 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   4 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   4 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   4 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   4 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   4 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   4 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   4 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   4 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   4 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   4 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   4 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   4 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   4 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   4 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   4 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   4 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   4 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   4 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   4 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   4 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   4 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   4 },
            { itemid = xi.item.IMP_HORN,                        droprate =   4 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   4 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   4 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   4 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   4 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   4 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   4 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   4 },
            { itemid = 1225,                                    droprate =   4 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   4 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   4 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   4 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   4 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   4 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   4 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   4 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   4 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   4 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   4 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   4 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   4 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   4 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   4 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   4 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   4 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   2 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   2 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   2 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   2 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   2 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   2 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   2 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   2 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   2 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   2 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   2 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   2 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   2 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   2 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   2 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   2 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   2 },
            { itemid = 2151,                                    droprate =   2 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   2 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   2 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   2 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   2 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   2 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   2 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   2 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   2 }, -- Water Anima
            { itemid = 1647,                                    droprate =   2 }, -- Light Anima
            { itemid = 1648,                                    droprate =   2 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   1 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   1 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   1 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   1 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   1 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   1 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   1 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   1 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   1 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   1 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   1 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   1 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   1 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   1 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   1 },
            { itemid =  734,                                    droprate =   1 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   1 }, -- Amphiptere Hide
            { itemid =    0,                                    droprate = 500 }, -- nothing
        },
        -- Slot 5, Misc/Medicine --
        {
            { itemid = xi.item.TRAINING_MANUAL,                 droprate =  15 },
            { itemid = xi.item.FIRE_CLUSTER,                    droprate =  10 },
            { itemid = xi.item.ICE_CLUSTER,                     droprate =  10 },
            { itemid = xi.item.WIND_CLUSTER,                    droprate =  10 },
            { itemid = xi.item.EARTH_CLUSTER,                   droprate =  10 },
            { itemid = xi.item.LIGHTNING_CLUSTER,               droprate =  10 },
            { itemid = xi.item.WATER_CLUSTER,                   droprate =  10 },
            { itemid = xi.item.LIGHT_CLUSTER,                   droprate =  10 },
            { itemid = xi.item.DARK_CLUSTER,                    droprate =  10 },
            { itemid = xi.item.ANTIDOTE,                        droprate =  10 },
            { itemid = xi.item.FLASK_OF_ECHO_DROPS,             droprate =  10 },
            { itemid = xi.item.FLASK_OF_HOLY_WATER,             droprate =  10 },
            { itemid = xi.item.RERAISER,                        droprate =  10 },
            { itemid = xi.item.HI_RERAISER,                     droprate =  10 },
            { itemid = xi.item.VILE_ELIXIR,                     droprate =  10 },
            { itemid = xi.item.BOTTLE_OF_PINEAPPLE_JUICE,       droprate =  10 },
            { itemid = xi.item.PINCH_OF_PUNGENT_POWDER_II,      droprate =  10 },
            { itemid = 5724,                                    droprate =  10 }, -- Pungent Powder I
            { itemid = 5350,                                    droprate =  10 }, -- Volant Serum
            { itemid = 4153,                                    droprate =  10 }, -- Antacid
            { itemid = 5356,                                    droprate =  10 }, -- Remedy Ointment
            { itemid = 5254,                                    droprate =  10 }, -- Hyper Potion
            { itemid = 5255,                                    droprate =  10 }, -- Hyper Ether
            { itemid = xi.item.REMEDY,                          droprate =   9 },
            { itemid = xi.item.MOAT_CARP,                       droprate =   5 },
            { itemid = 4149,                                    droprate =   1 }, -- Panacea
            { itemid =    0,                                    droprate = 750 }, -- nothing
        },
    },
    [45] =
    {   -- Slot 1, Currency --
        {
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate = 100 },
            { itemid = xi.item.COTTON_COIN_PURSE,               droprate = 100 },
            { itemid = xi.item.ONE_BYNE_BILL,                   droprate = 100 },
            { itemid = xi.item.ORDELLE_BRONZEPIECE,             droprate = 100 },
            { itemid = xi.item.TUKUKU_WHITESHELL,               droprate = 100 },
            { itemid = xi.item.BEASTMENS_SEAL,                  droprate =  40 },
            { itemid = xi.item.KINDREDS_SEAL,                   droprate =  40 },
            { itemid = xi.item.IMPERIAL_MYTHRIL_PIECE,          droprate =  25 },
            { itemid = xi.item.IMPERIAL_SILVER_PIECE,           droprate =  25 },
            { itemid = xi.item.FORGOTTEN_THOUGHT,               droprate =  55 },
            { itemid = xi.item.FORGOTTEN_HOPE,                  droprate =  55 },
            { itemid = xi.item.FORGOTTEN_TOUCH,                 droprate =  55 },
            { itemid = xi.item.FORGOTTEN_JOURNEY,               droprate =  55 },
            { itemid = xi.item.FORGOTTEN_STEP,                  droprate =  55 },
            { itemid =  8798,                                   droprate =  55 }, -- HP Bayld
            { itemid =  3283,                                   droprate =   5 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =   5 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =   5 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =   5 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =   5 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =   5 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =   5 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =   5 }, -- Wyrmal Tatter   
        },
        -- Slot 6, Currency --
        {
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  20 },
            { itemid = xi.item.COTTON_COIN_PURSE,               droprate =  20 },
            { itemid = xi.item.ONE_BYNE_BILL,                   droprate =  20 },
            { itemid = xi.item.ORDELLE_BRONZEPIECE,             droprate =  20 },
            { itemid = xi.item.TUKUKU_WHITESHELL,               droprate =  20 },
            { itemid = xi.item.BEASTMENS_SEAL,                  droprate =  10 },
            { itemid = xi.item.KINDREDS_SEAL,                   droprate =  10 },
            { itemid = xi.item.IMPERIAL_MYTHRIL_PIECE,          droprate =   5 },
            { itemid = xi.item.IMPERIAL_SILVER_PIECE,           droprate =   5 },
            { itemid = xi.item.FORGOTTEN_THOUGHT,               droprate =  20 },
            { itemid = xi.item.FORGOTTEN_HOPE,                  droprate =  20 },
            { itemid = xi.item.FORGOTTEN_TOUCH,                 droprate =  20 },
            { itemid = xi.item.FORGOTTEN_JOURNEY,               droprate =  20 },
            { itemid = xi.item.FORGOTTEN_STEP,                  droprate =  20 },
            { itemid =  8798,                                   droprate =  10 }, -- HP Bayld
            { itemid =  3283,                                   droprate =   1 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =   1 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =   1 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =   1 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =   1 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =   1 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =   1 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =   1 }, -- Wyrmal Tatter 
            { itemid =    0,                                    droprate = 750 }, -- nothing
        },
        -- Slot 10, Tatters --
        {
            { itemid =  3283,                                   droprate =  62 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  62 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  62 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  62 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  62 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  62 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  62 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  62 }, -- Wyrmal Tatter
            { itemid =     0,                                   droprate = 500 }, -- Nothing
        },
        -- Slot 2, Pop Items --
        {
            { itemid = xi.item.CURTANA,                         droprate =  40 },
            { itemid = xi.item.CHUNK_OF_DIORITE,                droprate =  40 },
            { itemid = xi.item.FLASK_OF_ROMAEVE_SPRING_WATER,   droprate =  40 },
            { itemid = xi.item.RED_CRYPTEX,                     droprate =  20 },
            { itemid = xi.item.DARKSTEEL_ENGRAVING,             droprate =  20 },
            { itemid = xi.item.SEVEN_KNOT_QUIPU,                droprate =  20 },
            { itemid = xi.item.GALKA_FANG_SACK,                 droprate =  20 },
            { itemid = xi.item.JADE_CRYPTEX,                    droprate =  20 },
            { itemid = xi.item.SILVER_ENGRAVING,                droprate =  20 },
            { itemid = xi.item.MITHRA_FANG_SACK,                droprate =  20 },
            { itemid = xi.item.THIRTEEN_KNOT_QUIPU,             droprate =  20 },
            { itemid = xi.item.TIGER_LEATHER_MISSIVE,           droprate =  20 },
            { itemid = xi.item.BEHEMOTH_LEATHER_MISSIVE,        droprate =  20 },
            { itemid = xi.item.RAM_LEATHER_MISSIVE,             droprate =  20 },
            { itemid = xi.item.HOUND_FANG_SACK,                 droprate =  20 },
            { itemid = xi.item.DHALMEL_LEATHER_MISSIVE,         droprate =  20 },
            { itemid = xi.item.BUNNY_FANG_SACK,                 droprate =  20 },
            { itemid = xi.item.SHEEP_LEATHER_MISSIVE,           droprate =  20 },
            { itemid = xi.item.COEURL_LEATHER_MISSIVE,          droprate =  20 },
            { itemid = xi.item.DRAGON_CHRONICLES,               droprate =  20 },
            { itemid = xi.item.HIGH_QUALITY_PHUABO_ORGAN,       droprate =  15 },
            { itemid = xi.item.HIGH_QUALITY_HPEMDE_ORGAN,       droprate =  15 },
            { itemid = xi.item.HIGH_QUALITY_EUVHI_ORGAN,        droprate =  15 },
            { itemid = xi.item.HIGH_QUALITY_AERN_ORGAN,         droprate =  15 },
            { itemid =  1855,                                   droprate =  15 }, -- H.Q. Xzomit Organ
            { itemid =  1784,                                   droprate =  15 }, -- Phuabo Organ
            { itemid =  1785,                                   droprate =  15 }, -- Xzomit Organ
            { itemid =  1786,                                   droprate =  15 }, -- Aern Organ
            { itemid =  1787,                                   droprate =  15 }, -- Hpemde Organ
            { itemid =  1788,                                   droprate =  15 }, -- Yovra Organ
            { itemid =  1872,                                   droprate =  20 }, -- Ghrah M Chip
            { itemid =  1783,                                   droprate =  20 }, -- Luminian Tissue
            { itemid =  1288,                                   droprate =  10 }, -- Wooden Hakutatku Eye
            { itemid =  1289,                                   droprate =  10 }, -- Burning Hakutatku Eye
            { itemid =  1290,                                   droprate =  10 }, -- Earthen Hakutatku Eye
            { itemid =  1291,                                   droprate =  10 }, -- Golden Hakutatku Eye
            { itemid =  1292,                                   droprate =  10 }, -- Damp Hakutatku Eye
            { itemid = xi.item.JAR_OF_PEISTE_PELLETS,           droprate =  20 },
            { itemid = xi.item.JAR_OF_GNAT_PELLETS,             droprate =  20 },
            { itemid =  2565,                                   droprate =  20 }, -- Gnole Pellets
            { itemid = xi.item.FLICKERING_LANTERN,              droprate =   5 },
            { itemid = xi.item.TONBERRY_RATTLE,                 droprate =   5 },
            { itemid = xi.item.OFFERING_TO_UGGALEPIH,           droprate =   5 },
            { itemid = xi.item.UGGALEPIH_WHISTLE,               droprate =   5 },
            { itemid = xi.item.CARBUNCLES_RUBY,                 droprate =   5 },
            { itemid = xi.item.SAHAGIN_KEY,                     droprate =   5 },
            { itemid = xi.item.DEED_OF_PLACIDITY,               droprate =  20 },
            { itemid = xi.item.DEED_OF_SENSIBILITY,             droprate =  20 },
            { itemid =  1854,                                   droprate =  20 }, -- Deed of Moderation
            { itemid = xi.item.FOMOR_CODEX,                     droprate =  20 },
            { itemid = xi.item.POT_OF_CLUSTERED_TAR,            droprate =  20 },
            { itemid =  1782,                                   droprate =  20 }, -- Florid Stone
            { itemid = xi.item.AIR_TANK,                        droprate =  20 },
            { itemid = xi.item.PREMIUM_BAG,                     droprate =  15 },
            { itemid = xi.item.ARK_PENTASPHERE,                 droprate =   5 },
            { itemid = xi.item.PIRATES_CHART,                   droprate =   5 },
            { itemid = xi.item.BRIGANDS_CHART,                  droprate =   5 },
            { itemid =   724,                                   droprate =  20 }, -- Magnolia Lumber
            { itemid =   677,                                   droprate =  20 }, -- White Steel
        },
        -- Slot 3, Equipment --
        {
            { itemid = xi.item.MELEE_CAPE,                      droprate =   5 },
            { itemid = xi.item.ABYSS_CAPE,                      droprate =   5 },
            { itemid = xi.item.ASSASSINS_CAPE,                  droprate =   5 },
            { itemid = xi.item.VALOR_CAPE,                      droprate =   5 },
            { itemid = xi.item.BARDS_CAPE,                      droprate =   5 },
            { itemid = xi.item.SUMMONERS_CAPE,                  droprate =   5 },
            { itemid = xi.item.WARRIORS_STONE,                  droprate =   5 },
            { itemid = xi.item.CLERICS_BELT,                    droprate =   5 },
            { itemid = xi.item.DUELISTS_BELT,                   droprate =   5 },
            { itemid = xi.item.SORCERERS_BELT,                  droprate =   5 },
            { itemid = xi.item.MONSTER_BELT,                    droprate =   5 },
            { itemid = xi.item.SCOUTS_BELT,                     droprate =   5 },
            { itemid = xi.item.KOGA_SARASHI,                    droprate =   5 },
            { itemid = xi.item.WYRM_BELT,                       droprate =   5 },
            { itemid = xi.item.SAOTOME_KOSHI_ATE,               droprate =   5 },
            { itemid = xi.item.COMMODORE_BELT,                  droprate =   5 },
            { itemid = xi.item.ARGUTE_BELT,                     droprate =   5 },
            { itemid = xi.item.MIRAGE_MANTLE,                   droprate =   5 },
            { itemid = xi.item.PANTIN_CAPE,                     droprate =   5 },
            { itemid = xi.item.ETOILE_CAPE,                     droprate =   5 },
            { itemid = xi.item.KOBO_OBI,                        droprate =   5 },  -- GEO Dynamis Accessory
            { itemid = xi.item.TANTALIC_CAPE,                   droprate =   5 },  -- RUN Dynamis Accessory
            { itemid = xi.item.ARIES_SUBLIGAR,                  droprate =   4 },
            { itemid = xi.item.TAURUS_SUBLIGAR,                 droprate =   4 },
            { itemid = xi.item.GEMINI_SUBLIGAR,                 droprate =   4 },
            { itemid = xi.item.CANCER_SUBLIGAR,                 droprate =   4 },
            { itemid = xi.item.LEO_SUBLIGAR,                    droprate =   4 },
            { itemid = xi.item.VIRGO_SUBLIGAR,                  droprate =   4 },
            { itemid = xi.item.LIBRA_SUBLIGAR,                  droprate =   4 },
            { itemid = xi.item.SCORPIUS_SUBLIGAR,               droprate =   4 },
            { itemid = xi.item.SAGITTARIUS_SUBLIGAR,            droprate =   4 },
            { itemid = xi.item.CAPRICORNUS_SUBLIGAR,            droprate =   4 },
            { itemid = xi.item.AQUARIUS_SUBLIGAR,               droprate =   4 },
            { itemid = xi.item.PISCES_SUBLIGAR,                 droprate =   4 },
            { itemid = xi.item.OPHIUCHUS_SUBLIGAR,              droprate =   4 },
            { itemid = xi.item.CARPENTERS_BELT,                 droprate =   4 },
            { itemid = xi.item.BLACKSMITHS_BELT,                droprate =   4 },
            { itemid = xi.item.GOLDSMITHS_BELT,                 droprate =   4 },
            { itemid = xi.item.WEAVERS_BELT,                    droprate =   4 },
            { itemid = xi.item.TANNERS_BELT,                    droprate =   4 },
            { itemid = xi.item.BONEWORKERS_BELT,                droprate =   4 },
            { itemid = xi.item.ALCHEMISTS_BELT,                 droprate =   4 },
            { itemid = xi.item.CULINARIANS_BELT,                droprate =   4 },
            { itemid = xi.item.FISHERMANS_BELT,                 droprate =   4 },
            { itemid = xi.item.HAMAYUMI,                        droprate =   5 },
            { itemid = xi.item.DIA_WAND,                        droprate =   5 },
            { itemid = xi.item.STONE_GORGET,                    droprate =   5 },
            { itemid = xi.item.PILGRIMS_WAND,                   droprate =   5 },
            { itemid = xi.item.GELONG_STAFF,                    droprate =   5 },
            { itemid = xi.item.WEBCUTTER,                       droprate =   5 },
            { itemid =  18412,                                  droprate =   5 }, -- Gassan
            { itemid =  17708,                                  droprate =   5 }, -- Auriga Xiphos
            { itemid =  18359,                                  droprate =   5 }, -- Boreas Cesti
            { itemid =  15220,                                  droprate =   5 }, -- Rain Hat
            { itemid =  15468,                                  droprate =   5 }, -- Resentment Cape
            { itemid =  15505,                                  droprate =   5 }, -- Dhalmel Whistle
            { itemid =  14667,                                  droprate =   5 }, -- Carect Ring
            { itemid =  xi.item.GOTHIC_SABATONS,                droprate =   5 },
            { itemid =  xi.item.GOTHIC_GAUNTLETS,               droprate =   5 },
            { itemid =  11529,                                  droprate =   5 }, -- Frugal Cape
            { itemid =  16187,                                  droprate =   5 }, -- Adoubeurs Pavise
            { itemid =  16899,                                  droprate =   5 }, -- Hototogisu
            { itemid =  16374,                                  droprate =   5 }, -- Layqa Seraweels
            { itemid =  17199,                                  droprate =   5 }, -- Loxley Bow
            { itemid =  16882,                                  droprate =   5 }, -- Calamar
            { itemid =  17504,                                  droprate =   5 }, -- Pagures
            { itemid =  16884,                                  droprate =   5 }, -- Narval
            { itemid =  17503,                                  droprate =   5 }, -- Exocets
            { itemid =  19238,                                  droprate =   5 }, -- Jasper Tathlum
            { itemid =  11404,                                  droprate =   5 }, -- Promptitude Solea
            { itemid =  15897,                                  droprate =   5 }, -- Grace Corset
            { itemid =  13803,                                  droprate =   5 }, -- Shaman's Cloak
            { itemid =  19237,                                  droprate =   5 }, -- Slick Dart
            { itemid =  15942,                                  droprate =   5 }, -- Summoning Belt
            { itemid =  xi.item.MUSHROOM_HELM,                  droprate =   5 },
            { itemid =  xi.item.LUNA_SUBLIGAR,                  droprate =   5 },
            { itemid =  16980,                                  droprate =   5 }, -- Sukesada
            { itemid =  13912,                                  droprate =   5 }, -- Shadow Mask
            { itemid =  16943,                                  droprate =   5 }, -- Ascalon
            { itemid =  14063,                                  droprate =   5 }, -- Protecting Bangles
            { itemid =  14064,                                  droprate =   5 }, -- Sand Gloves
            { itemid =  17651,                                  droprate =   5 }, -- Dainslaif
            { itemid =  17924,                                  droprate =   5 }, -- Tungi
            { itemid =  16734,                                  droprate =   5 }, -- Pendragon Axe
            { itemid =  15995,                                  droprate =   5 }, -- Carline Earring
            { itemid =  16127,                                  droprate =   5 }, -- Carline Ribbon
            { itemid =  16125,                                  droprate =   5 }, -- Breeder Mask
            { itemid =  15001,                                  droprate =   5 }, -- Breeder Mufflers
            { itemid =  15946,                                  droprate =   5 }, -- Tempest Belt
            { itemid =  11405,                                  droprate =   5 }, -- Kyoshu Kyahan
            { itemid =  11533,                                  droprate =   5 }, -- Lyricist's Gonnelle
            { itemid =  16298,                                  droprate =   5 }, -- Knack Pendant
            { itemid =  17454,                                  droprate =   5 }, -- Asklepios
            { itemid =  17455,                                  droprate =   5 }, -- Skirnir's Wand
            { itemid =  16912,                                  droprate =   5 }, -- Kitsutsuki
            { itemid =  17926,                                  droprate =   5 }, -- Acha D'Armas
            { itemid =  17982,                                  droprate =   5 }, -- Kard
            { itemid =  17983,                                  droprate =   5 }, -- Valiant Knife
            { itemid =  18042,                                  droprate =   5 }, -- Ascention
            { itemid =  17563,                                  droprate =   5 }, -- Power Staff
            { itemid =  17969,                                  droprate =   5 }, -- Fendoir
            { itemid =  18608,                                  droprate =   5 }, -- Atesh Pole
            { itemid =  16727,                                  droprate =   5 }, -- Eisentaenzer
            { itemid =  17971,                                  droprate =   5 }, -- Tartaglia
            { itemid =  19235,                                  droprate =   5 }, -- Veuglaire
            { itemid =  16375,                                  droprate =   5 }, -- Surge Subligar
            { itemid =  xi.item.ASTRAL_ASPIS,                   droprate =   5 },
            { itemid =  xi.item.GAE_BOLG,                       droprate =   5 },
            { itemid =  xi.item.LOHAR,                          droprate =   5 },
            { itemid =   19122,                                 droprate =   5 }, -- Courser's Pugio
            { itemid =   16081,                                 droprate =   5 }, -- Curate's Hat
            { itemid =   15882,                                 droprate =   5 }, -- Othinus' Bow
            { itemid =   17244,                                 droprate =   5 }, -- Storm Belt
            { itemid =   14806,                                 droprate =   5 }, -- Intruder Earring
            { itemid =   14466,                                 droprate =   5 }, -- Fomor Tunic
            { itemid =   18007,                                 droprate =   5 }, -- Chiroptera Dagger
            { itemid =   17510,                                 droprate =   5 }, -- Vampiric Claws
            { itemid =   14763,                                 droprate =   5 }, -- Boroka Earring
            { itemid =   13178,                                 droprate =   5 }, -- Auditory Torque
            { itemid =   15943,                                 droprate =   5 }, -- Virtuoso Belt
            { itemid =   14884,                                 droprate =   5 }, -- Mycophile Cuffs
            { itemid =   17794,                                 droprate =   5 }, -- Niokiyotsuna
            { itemid =   15219,                                 droprate =   5 }, -- Sinister Mask
            { itemid =   16368,                                 droprate =   5 }, -- Herder's Subligar
            { itemid =   14724,                                 droprate =   5 }, -- Moldavite Earring
            { itemid =   16279,                                 droprate =   5 }, -- Pile Chain
            { itemid =   15546,                                 droprate =   5 }, -- Fasting Ring
            { itemid =   16299,                                 droprate =   5 }, -- Lleu's Charm
            { itemid =   11496,                                 droprate =   5 }, -- Fenrir's Crown
            { itemid =   14168,                                 droprate =   5 }, -- Dune Boots
            { itemid =   17854,                                 droprate =   5 }, -- Cradle Horn
            { itemid =   19239,                                 droprate =   5 }, -- Astrolable
            { itemid =   16169,                                 droprate =   5 }, -- Caballero Shield
            { itemid =   17653,                                 droprate =   5 }, -- Hrotti
            { itemid =   18027,                                 droprate =   5 }, -- Palladium Dagger
            { itemid =   17564,                                 droprate =   5 }, -- Cocytus Pole
            { itemid =   16426,                                 droprate =   5 }, -- Avengers
            { itemid =   19121,                                 droprate =   5 }, -- Sleight Kukri
            { itemid =   15944,                                 droprate =   5 }, -- Selemnus Belt
            { itemid =   16297,                                 droprate =   4 }, -- Shepherd's Chain
            { itemid =  xi.item.KAMEWARI,                       droprate =   5 },
            { itemid =  xi.item.NADRS,                          droprate =   5 },
            { itemid =  xi.item.ALTDORFS_EARRING,               droprate =   5 },
            { itemid =  xi.item.WILHELMS_EARRING,               droprate =   5 },
            { itemid =  xi.item.MINSTRELS_DAGGER,               droprate =   5 },
            { itemid =  xi.item.SAND_CHARM,                     droprate =   5 },
            { itemid =   15692,                                 droprate =   3 }, -- Storm Crackows
            { itemid =   14669,                                 droprate =   3 }, -- Jaeger Ring
            { itemid =   15351,                                 droprate =   2 }, -- Bounding Boots
            { itemid =   18018,                                 droprate =   2 }, -- Sirocco Kukri
            { itemid =   13567,                                 droprate =   2 }, -- Bomb Queen Ring
            { itemid =   15547,                                 droprate =   2 }, -- Vilma's Ring
            { itemid =   26164,                                 droprate =   2 }, -- Caliber Ring
            { itemid =   15183,                                 droprate =   5 }, -- Dobson Bandana
            { itemid =   15184,                                 droprate =   2 }, -- Voyager Sallet
            { itemid =   14986,                                 droprate =   2 }, -- Ochimusha Kote
            { itemid =   15737,                                 droprate =   2 }, -- Sarutobi Kyahan
            { itemid =   15551,                                 droprate =   2 }, -- Shikaree Ring
            { itemid =  xi.item.EMPRESS_HAIRPIN,                droprate =   2 },
            { itemid =  xi.item.JOYEUSE,                        droprate =   2 },
            { itemid =  xi.item.DRYAD_STAFF,                    droprate =   2 },
            { itemid =  xi.item.VALIS_BOW,                      droprate =   2 },
            { itemid =  xi.item.RETALIATORS,                    droprate =   2 },
            { itemid =  xi.item.UNGUR_BOOMERANG,                droprate =   2 },
            { itemid =   15515,                                 droprate =   1 }, -- Peacock Amulet
            { itemid =  xi.item.TROTTER_BOOTS,                  droprate =   1 },
            { itemid =   19236,                                 droprate =   2 }, -- Hightail Bullet
            { itemid =   17192,                                 droprate =   3 }, -- Ifrit's Bow
            { itemid =   17711,                                 droprate =   5 }, -- Shiva's Shotel
            { itemid =   18021,                                 droprate =   5 }, -- Titan's Baselarde
            { itemid =   18063,                                 droprate =   5 }, -- Garuda's Sickle
            { itemid =   18109,                                 droprate =   5 }, -- Leviathan's Couse
            { itemid =   18404,                                 droprate =   5 }, -- Ramuh's Mace
            { itemid =   18581,                                 droprate =   5 }, -- Carbuncle's Pole
            { itemid =   14931,                                 droprate =   5 }, -- Carbuncle's Cuffs
            { itemid =   18422,                                 droprate =   5 }, -- Ryumon
            { itemid =   14960,                                 droprate =   5 }, -- Evoker's Gages
            { itemid =   19277,                                 droprate =   5 }, -- Tsugumi
            { itemid =   11408,                                 droprate =   5 }, -- Morana Pigaches
            { itemid =   11409,                                 droprate =   5 }, -- Aoide's Pumps
            { itemid =   16238,                                 droprate =   5 }, -- Taster's Cape
            { itemid =   11497,                                 droprate =   5 }, -- Spurrer Beret
            { itemid =   11406,                                 droprate =   5 }, -- Stimulus Sabots
            { itemid =   18767,                                 droprate =   5 }, -- Birdbanes
            { itemid =   15854,                                 droprate =   5 }, -- Sortie Ring
            { itemid =   15915,                                 droprate =   5 }, -- Sothic Rope
            { itemid =   11342,                                 droprate =   5 }, -- Restorer Cloak
            { itemid =   18770,                                 droprate =   5 }, -- Pygme Sainti
            { itemid =   17737,                                 droprate =   5 }, -- Corsair's Scimitar
            { itemid =   19124,                                 droprate =   5 }, -- Creve-coeur
            { itemid =   19279,                                 droprate =   5 }, -- Musanto
            { itemid =   17766,                                 droprate =   5 }, -- Lyft Scimitar
            { itemid =   17970,                                 droprate =   5 }, -- Lyft Tabar
            { itemid =   18508,                                 droprate =   5 }, -- Lyft Voulge
            { itemid =   18609,                                 droprate =   5 }, -- Lyft Pole
            { itemid =   18771,                                 droprate =   5 }, -- Lyft Sainti
            { itemid =   18872,                                 droprate =   5 }, -- Lyft Ferule
            { itemid =   18958,                                 droprate =   5 }, -- Lyft Scythe
            { itemid =   19125,                                 droprate =   5 }, -- Lyft Jambiya
            { itemid =   19161,                                 droprate =   5 }, -- Lyft Claymore
            { itemid =   19233,                                 droprate =   5 }, -- Lyft Crossbow
            { itemid =   19306,                                 droprate =   5 }, -- Lyft Lance
            { itemid =  xi.item.LAVAS_RING,                     droprate =   5 },
            { itemid =  xi.item.KUSHAS_RING,                    droprate =   5 },
            { itemid =  xi.item.NASATYAS_RING,                  droprate =   5 },
            { itemid =  xi.item.DASRAS_RING,                    droprate =   5 },
            { itemid =  xi.item.HOPE_STAFF,                     droprate =   5 },
            { itemid =  xi.item.JUSTICE_SWORD,                  droprate =   5 },
            { itemid =  xi.item.TEMPERANCE_AXE,                 droprate =   5 },
            { itemid =  xi.item.LOVE_HALBERD,                   droprate =   5 },
            { itemid =  xi.item.FORTITUDE_AXE,                  droprate =   5 },
            { itemid =  xi.item.FAITH_BAGHNAKHS,                droprate =   5 },
            { itemid =  xi.item.PRUDENCE_ROD,                   droprate =   5 },
            { itemid =  xi.item.BYAKKOS_AXE,                    droprate =   5 },
            { itemid =  xi.item.SUZAKUS_SCYTHE,                 droprate =   5 },
            { itemid =  xi.item.SEIRYUS_SWORD,                  droprate =   5 },
            { itemid =  xi.item.SANGUINE_SWORD,                 droprate =   5 },
        },
        -- Slot 4, Materials --
        {
            { itemid = xi.item.MOAT_CARP,                       droprate =   5 },
            { itemid = xi.item.IRON_INGOT,                      droprate =   6 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   6 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   6 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   6 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   6 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   6 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   6 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   6 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   6 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   6 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   6 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   6 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   6 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   6 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   6 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   6 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   6 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   6 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   6 },
            { itemid = xi.item.RAM_HORN,                        droprate =   6 },
            { itemid = xi.item.ELM_LOG,                         droprate =   6 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   6 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   6 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   6 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   6 },
            { itemid = xi.item.SACK_OF_SILICA,                  droprate =   6 },
            { itemid =  850,                                    droprate =   6 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   6 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   6 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   6 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   6 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   6 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   6 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   6 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   6 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   6 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   6 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   6 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   6 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   6 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   6 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   6 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   6 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   6 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   6 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   6 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   6 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   6 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   6 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   6 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   6 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   6 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   6 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   6 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   6 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   6 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   6 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   6 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   6 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   6 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   6 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   6 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   6 },
            { itemid = xi.item.IMP_HORN,                        droprate =   6 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   6 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   6 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   6 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   6 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   6 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   6 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   6 },
            { itemid = 1225,                                    droprate =   6 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   6 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   6 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   6 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   6 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   6 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   6 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   6 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   6 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   6 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   6 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   6 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   6 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   6 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   6 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   6 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   6 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   4 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   4 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   4 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   4 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   4 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   4 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   4 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   4 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   4 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   4 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   4 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   4 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   4 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   4 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   4 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   4 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   3 },
            { itemid = 2151,                                    droprate =   3 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   3 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   3 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   4 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   4 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   4 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   4 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   4 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   4 }, -- Water Anima
            { itemid = 1647,                                    droprate =   4 }, -- Light Anima
            { itemid = 1648,                                    droprate =   4 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   2 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   2 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   2 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   2 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   2 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   2 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   2 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   2 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   2 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   2 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   2 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   2 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   2 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   2 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   2 },
            { itemid =  734,                                    droprate =   2 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   2 }, -- Amphiptere Hide
            { itemid = 2164,                                    droprate =   2 }, -- Red Grass Thread
            { itemid = 1279,                                    droprate =   2 }, -- Taffeta Cloth
            { itemid = 1280,                                    droprate =   2 }, -- Sarcenet Cloth
            { itemid = 1281,                                    droprate =   2 }, -- Cheviot Cloth
            { itemid = 1295,                                    droprate =   2 }, -- Twincoon
            { itemid = 1270,                                    droprate =   2 }, -- Arachne Web
            { itemid =  647,                                    droprate =   2 }, -- Molybdenum Ore
            { itemid = 1271,                                    droprate =   2 }, -- Pigeon's Blood Ruby
            { itemid = 1276,                                    droprate =   2 }, -- Tarasque Skin
            { itemid = 1296,                                    droprate =   2 }, -- Yowie Skin
            { itemid = 1277,                                    droprate =   2 }, -- Lindwurm Skin
            { itemid = 1765,                                    droprate =   4 }, -- Habu Skin
            { itemid = 2828,                                    droprate =   2 }, -- Herensugue Skin
            { itemid = 2837,                                    droprate =   2 }, -- Ratatoskr Pelt
            { itemid = 2839,                                    droprate =   2 }, -- Coquecigrue Skin
            { itemid =  909,                                    droprate =   2 }, -- Guivre's Skull
            { itemid = 2830,                                    droprate =   2 }, -- Bastet Fang
            { itemid = 2833,                                    droprate =   2 }, -- Thunder Coral
            { itemid = 1272,                                    droprate =   2 }, -- Arioch Fang
            { itemid = 1273,                                    droprate =   2 }, -- Namtar Bone
            { itemid = 2849,                                    droprate =   2 }, -- Likho Talon
            { itemid = 2846,                                    droprate =   2 }, -- Hefty Oak Lumber
            { itemid = 2855,                                    droprate =   2 }, -- Mahogany Heartwood
            { itemid = xi.item.CHUNK_OF_FIRE_ORE,               droprate =   4 },
            { itemid = xi.item.CHUNK_OF_ICE_ORE,                droprate =   4 },
            { itemid = xi.item.CHUNK_OF_WIND_ORE,               droprate =   4 },
            { itemid = xi.item.CHUNK_OF_EARTH_ORE,              droprate =   4 },
            { itemid = xi.item.CHUNK_OF_LIGHTNING_ORE,          droprate =   4 },
            { itemid = xi.item.CHUNK_OF_WATER_ORE,              droprate =   4 },
            { itemid = xi.item.CHUNK_OF_LIGHT_ORE,              droprate =   4 },
            { itemid = xi.item.CHUNK_OF_DARK_ORE,               droprate =   4 },
            { itemid =    0,                                    droprate = 250 }, -- nothing
        },
        -- Slot 5 Misc/Medicine --
        {
            { itemid = xi.item.TRAINING_MANUAL,                 droprate =  25 },
            { itemid = xi.item.FIRE_CLUSTER,                    droprate =  20 },
            { itemid = xi.item.ICE_CLUSTER,                     droprate =  20 },
            { itemid = xi.item.WIND_CLUSTER,                    droprate =  20 },
            { itemid = xi.item.EARTH_CLUSTER,                   droprate =  20 },
            { itemid = xi.item.LIGHTNING_CLUSTER,               droprate =  20 },
            { itemid = xi.item.WATER_CLUSTER,                   droprate =  20 },
            { itemid = xi.item.LIGHT_CLUSTER,                   droprate =  20 },
            { itemid = xi.item.DARK_CLUSTER,                    droprate =  20 },
            { itemid = xi.item.ANTIDOTE,                        droprate =  20 },
            { itemid = xi.item.FLASK_OF_ECHO_DROPS,             droprate =  20 },
            { itemid = xi.item.FLASK_OF_HOLY_WATER,             droprate =  20 },
            { itemid = xi.item.RERAISER,                        droprate =  20 },
            { itemid = xi.item.HI_RERAISER,                     droprate =  20 },
            { itemid = xi.item.VILE_ELIXIR,                     droprate =  20 },
            { itemid = xi.item.PINCH_OF_PUNGENT_POWDER_II,      droprate =  20 },
            { itemid = 4512,                                    droprate =  20 }, -- Vampire Juice
            { itemid = 5724,                                    droprate =  20 }, -- Pungent Powder I
            { itemid = 5350,                                    droprate =  20 }, -- Volant Serum
            { itemid = 4153,                                    droprate =  20 }, -- Antacid
            { itemid = 5356,                                    droprate =  20 }, -- Remedy Ointment
            { itemid = 5254,                                    droprate =  20 }, -- Hyper Potion
            { itemid = 5255,                                    droprate =  20 }, -- Hyper Ether
            { itemid = xi.item.REMEDY,                          droprate =  15 },
            { itemid = xi.item.MOAT_CARP,                       droprate =  15 },
            { itemid = 4149,                                    droprate =   5 }, -- Panacea
            { itemid =    0,                                    droprate = 500 }, -- nothing
        },
    },
    [60] =
    {   -- Slot 1, Currency --
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate =  80 },
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  80 },
            { itemid = xi.item.COTTON_COIN_PURSE,               droprate =  90 },
            { itemid = xi.item.ONE_BYNE_BILL,                   droprate =  60 },
            { itemid = xi.item.ORDELLE_BRONZEPIECE,             droprate =  60 },
            { itemid = xi.item.TUKUKU_WHITESHELL,               droprate =  60 },
            { itemid = xi.item.BEASTMENS_SEAL,                  droprate =  10 },
            { itemid = xi.item.KINDREDS_SEAL,                   droprate =  10 },
            { itemid = xi.item.IMPERIAL_MYTHRIL_PIECE,          droprate =  10 },
            { itemid = xi.item.IMPERIAL_SILVER_PIECE,           droprate =  10 },
            { itemid =  6541,                                   droprate =  90 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  90 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  90 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  90 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  90 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter
        },
        -- Slot 6, Currency --
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate =  30 },
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  40 },
            { itemid = xi.item.COTTON_COIN_PURSE,               droprate =  50 },
            { itemid = xi.item.ONE_BYNE_BILL,                   droprate =  40 },
            { itemid = xi.item.ORDELLE_BRONZEPIECE,             droprate =  40 },
            { itemid = xi.item.TUKUKU_WHITESHELL,               droprate =  40 },
            { itemid = xi.item.BEASTMENS_SEAL,                  droprate =   5 },
            { itemid = xi.item.KINDREDS_SEAL,                   droprate =   5 },
            { itemid = xi.item.IMPERIAL_MYTHRIL_PIECE,          droprate =   5 },
            { itemid = xi.item.IMPERIAL_SILVER_PIECE,           droprate =   5 },
            { itemid =  6541,                                   droprate =  40 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  40 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  40 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  40 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  40 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =   5 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =   5 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =   5 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =   5 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =   5 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =   5 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =   5 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =   5 }, -- Wyrmal Tatter 
            { itemid =    0,                                    droprate = 500 }, -- nothing
        },
        -- Slot 10, Tatters --
        {
            { itemid =  3283,                                   droprate =  93 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  93 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  93 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  93 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  93 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  93 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  93 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  93 }, -- Wyrmal Tatter
            { itemid =     0,                                   droprate = 250 }, -- Nothing
        },
        -- Slot 2, Pop Items --
        {
            { itemid = xi.item.CURTANA,                         droprate =  40 },
            { itemid = xi.item.CHUNK_OF_DIORITE,                droprate =  40 },
            { itemid = xi.item.FLASK_OF_ROMAEVE_SPRING_WATER,   droprate =  40 },
            { itemid = xi.item.GEM_OF_THE_EAST,                 droprate =  20 },
            { itemid = xi.item.SPRINGSTONE,                     droprate =  20 },
            { itemid = xi.item.GEM_OF_THE_SOUTH,                droprate =  20 },
            { itemid = xi.item.SUMMERSTONE,                     droprate =  20 },
            { itemid = xi.item.GEM_OF_THE_WEST,                 droprate =  20 },
            { itemid = xi.item.AUTUMNSTONE,                     droprate =  20 },
            { itemid = xi.item.GEM_OF_THE_NORTH,                droprate =  20 },
            { itemid = xi.item.WINTERSTONE,                     droprate =  20 },
            { itemid = xi.item.RED_CRYPTEX,                     droprate =  10 },
            { itemid = xi.item.DARKSTEEL_ENGRAVING,             droprate =  10 },
            { itemid = xi.item.SEVEN_KNOT_QUIPU,                droprate =  10 },
            { itemid = xi.item.GALKA_FANG_SACK,                 droprate =  10 },
            { itemid = xi.item.JADE_CRYPTEX,                    droprate =  10 },
            { itemid = xi.item.SILVER_ENGRAVING,                droprate =  10 },
            { itemid = xi.item.MITHRA_FANG_SACK,                droprate =  10 },
            { itemid = xi.item.THIRTEEN_KNOT_QUIPU,             droprate =  10 },
            { itemid = xi.item.TIGER_LEATHER_MISSIVE,           droprate =  10 },
            { itemid = xi.item.BEHEMOTH_LEATHER_MISSIVE,        droprate =  10 },
            { itemid = xi.item.RAM_LEATHER_MISSIVE,             droprate =  10 },
            { itemid = xi.item.HOUND_FANG_SACK,                 droprate =  10 },
            { itemid = xi.item.DHALMEL_LEATHER_MISSIVE,         droprate =  10 },
            { itemid = xi.item.BUNNY_FANG_SACK,                 droprate =  10 },
            { itemid = xi.item.SHEEP_LEATHER_MISSIVE,           droprate =  10 },
            { itemid = xi.item.COEURL_LEATHER_MISSIVE,          droprate =  10 },
            { itemid = xi.item.DRAGON_CHRONICLES,               droprate =  10 },
            { itemid = xi.item.CLOUD_EVOKER,                    droprate =  10 },
            { itemid = xi.item.IVORY_CHIP,                      droprate =   5 },
            { itemid = xi.item.SCARLET_CHIP,                    droprate =   5 },
            { itemid = xi.item.EMERALD_CHIP,                    droprate =   5 },
            { itemid = xi.item.HIGH_QUALITY_PHUABO_ORGAN,       droprate =  10 },
            { itemid = xi.item.HIGH_QUALITY_HPEMDE_ORGAN,       droprate =  10 },
            { itemid = xi.item.HIGH_QUALITY_EUVHI_ORGAN,        droprate =  10 },
            { itemid = xi.item.HIGH_QUALITY_AERN_ORGAN,         droprate =  10 },
            { itemid =  1855,                                   droprate =  10 }, -- H.Q. Xzomit Organ
            { itemid =  1784,                                   droprate =  10 }, -- Phuabo Organ
            { itemid =  1785,                                   droprate =  10 }, -- Xzomit Organ
            { itemid =  1786,                                   droprate =  10 }, -- Aern Organ
            { itemid =  1787,                                   droprate =  10 }, -- Hpemde Organ
            { itemid =  1788,                                   droprate =  10 }, -- Yovra Organ
            { itemid =  1872,                                   droprate =  20 }, -- Ghrah M Chip
            { itemid =  1783,                                   droprate =  10 }, -- Luminian Tissue
            { itemid =  1288,                                   droprate =  20 }, -- Wooden Hakutatku Eye
            { itemid =  1289,                                   droprate =  20 }, -- Burning Hakutatku Eye
            { itemid =  1290,                                   droprate =  20 }, -- Earthen Hakutatku Eye
            { itemid =  1291,                                   droprate =  20 }, -- Golden Hakutatku Eye
            { itemid =  1292,                                   droprate =  20 }, -- Damp Hakutatku Eye
            { itemid = xi.item.JAR_OF_PEISTE_PELLETS,           droprate =   5 },
            { itemid = xi.item.JAR_OF_GNAT_PELLETS,             droprate =   5 },
            { itemid =  2565,                                   droprate =   5 }, -- Gnole Pellets
            { itemid = xi.item.FLICKERING_LANTERN,              droprate =   5 },
            { itemid = xi.item.TONBERRY_RATTLE,                 droprate =   5 },
            { itemid = xi.item.OFFERING_TO_UGGALEPIH,           droprate =   5 },
            { itemid = xi.item.UGGALEPIH_WHISTLE,               droprate =   5 },
            { itemid = xi.item.SAHAGIN_KEY,                     droprate =   5 },
            { itemid = xi.item.DEED_OF_PLACIDITY,               droprate =  30 },
            { itemid = xi.item.DEED_OF_SENSIBILITY,             droprate =  30 },
            { itemid =  1854,                                   droprate =  30 }, -- Deed of Moderation
            { itemid = xi.item.FIRST_VIRTUE,                    droprate =  15 },
            { itemid =  1853,                                   droprate =  15 }, -- Second Virtue
            { itemid = xi.item.THIRD_VIRTUE,                    droprate =  15 },
            { itemid = xi.item.FOMOR_CODEX,                     droprate =  20 },
            { itemid = xi.item.POT_OF_CLUSTERED_TAR,            droprate =  20 },
            { itemid = xi.item.AIR_TANK,                        droprate =  20 },
            { itemid = xi.item.PREMIUM_BAG,                     droprate =  15 },
            { itemid = xi.item.ARK_PENTASPHERE,                 droprate =   5 },
            { itemid = xi.item.PIRATES_CHART,                   droprate =   5 },
            { itemid = xi.item.BRIGANDS_CHART,                  droprate =   5 },
            { itemid =  1782,                                   droprate =  10 }, -- Florid Stone
            { itemid =   724,                                   droprate =  10 }, -- Magnolia Lumber
            { itemid =   677,                                   droprate =  10 }, -- White Steel
        },
        -- Slot 3, Equipment --
        {
            { itemid = xi.item.MELEE_CAPE,                      droprate =   5 },
            { itemid = xi.item.ABYSS_CAPE,                      droprate =   5 },
            { itemid = xi.item.ASSASSINS_CAPE,                  droprate =   5 },
            { itemid = xi.item.VALOR_CAPE,                      droprate =   5 },
            { itemid = xi.item.BARDS_CAPE,                      droprate =   5 },
            { itemid = xi.item.SUMMONERS_CAPE,                  droprate =   5 },
            { itemid = xi.item.WARRIORS_STONE,                  droprate =   5 },
            { itemid = xi.item.CLERICS_BELT,                    droprate =   5 },
            { itemid = xi.item.DUELISTS_BELT,                   droprate =   5 },
            { itemid = xi.item.SORCERERS_BELT,                  droprate =   5 },
            { itemid = xi.item.MONSTER_BELT,                    droprate =   5 },
            { itemid = xi.item.SCOUTS_BELT,                     droprate =   5 },
            { itemid = xi.item.KOGA_SARASHI,                    droprate =   5 },
            { itemid = xi.item.WYRM_BELT,                       droprate =   5 },
            { itemid = xi.item.SAOTOME_KOSHI_ATE,               droprate =   5 },
            { itemid = xi.item.COMMODORE_BELT,                  droprate =   5 },
            { itemid = xi.item.ARGUTE_BELT,                     droprate =   5 },
            { itemid = xi.item.MIRAGE_MANTLE,                   droprate =   5 },
            { itemid = xi.item.PANTIN_CAPE,                     droprate =   5 },
            { itemid = xi.item.ETOILE_CAPE,                     droprate =   5 },
            { itemid = xi.item.KOBO_OBI,                        droprate =   5 },  -- GEO Dynamis Accessory
            { itemid = xi.item.TANTALIC_CAPE,                   droprate =   5 },  -- RUN Dynamis Accessory
            { itemid = xi.item.CARPENTERS_BELT,                 droprate =   3 },
            { itemid = xi.item.BLACKSMITHS_BELT,                droprate =   3 },
            { itemid = xi.item.GOLDSMITHS_BELT,                 droprate =   3 },
            { itemid = xi.item.WEAVERS_BELT,                    droprate =   3 },
            { itemid = xi.item.TANNERS_BELT,                    droprate =   3 },
            { itemid = xi.item.BONEWORKERS_BELT,                droprate =   3 },
            { itemid = xi.item.ALCHEMISTS_BELT,                 droprate =   3 },
            { itemid = xi.item.CULINARIANS_BELT,                droprate =   3 },
            { itemid = xi.item.FISHERMANS_BELT,                 droprate =   3 },
            { itemid = xi.item.HAMAYUMI,                        droprate =   5 },
            { itemid = xi.item.DIA_WAND,                        droprate =   5 },
            { itemid = xi.item.STONE_GORGET,                    droprate =   5 },
            { itemid = xi.item.PILGRIMS_WAND,                   droprate =   5 },
            { itemid = xi.item.GELONG_STAFF,                    droprate =   5 },
            { itemid = xi.item.WEBCUTTER,                       droprate =   5 },
            { itemid =  18412,                                  droprate =   5 }, -- Gassan
            { itemid =  17708,                                  droprate =   5 }, -- Auriga Xiphos
            { itemid =  18359,                                  droprate =   5 }, -- Boreas Cesti
            { itemid =  15220,                                  droprate =   5 }, -- Rain Hat
            { itemid =  15468,                                  droprate =   5 }, -- Resentment Cape
            { itemid =  15505,                                  droprate =   5 }, -- Dhalmel Whistle
            { itemid =  14667,                                  droprate =   5 }, -- Carect Ring
            { itemid =  xi.item.GOTHIC_SABATONS,                droprate =   5 },
            { itemid =  xi.item.GOTHIC_GAUNTLETS,               droprate =   5 },
            { itemid =  11529,                                  droprate =   5 }, -- Frugal Cape
            { itemid =  16187,                                  droprate =   5 }, -- Adoubeurs Pavise
            { itemid =  16899,                                  droprate =   5 }, -- Hototogisu
            { itemid =  16374,                                  droprate =   5 }, -- Layqa Seraweels
            { itemid =  17199,                                  droprate =   5 }, -- Loxley Bow
            { itemid =  16882,                                  droprate =   5 }, -- Calamar
            { itemid =  17504,                                  droprate =   5 }, -- Pagures
            { itemid =  16884,                                  droprate =   5 }, -- Narval
            { itemid =  17503,                                  droprate =   5 }, -- Exocets
            { itemid =  19238,                                  droprate =   5 }, -- Jasper Tathlum
            { itemid =  11404,                                  droprate =   5 }, -- Promptitude Solea
            { itemid =  15897,                                  droprate =   5 }, -- Grace Corset
            { itemid =  13803,                                  droprate =   5 }, -- Shaman's Cloak
            { itemid =  19237,                                  droprate =   5 }, -- Slick Dart
            { itemid =  15942,                                  droprate =   5 }, -- Summoning Belt
            { itemid =  xi.item.MUSHROOM_HELM,                  droprate =   5 },
            { itemid =  xi.item.LUNA_SUBLIGAR,                  droprate =   5 },
            { itemid =  16980,                                  droprate =   5 }, -- Sukesada
            { itemid =  13912,                                  droprate =   5 }, -- Shadow Mask
            { itemid =  16943,                                  droprate =   5 }, -- Ascalon
            { itemid =  14063,                                  droprate =   5 }, -- Protecting Bangles
            { itemid =  14064,                                  droprate =   5 }, -- Sand Gloves
            { itemid =  17651,                                  droprate =   5 }, -- Dainslaif
            { itemid =  17924,                                  droprate =   5 }, -- Tungi
            { itemid =  16734,                                  droprate =   5 }, -- Pendragon Axe
            { itemid =  15995,                                  droprate =   5 }, -- Carline Earring
            { itemid =  16127,                                  droprate =   5 }, -- Carline Ribbon
            { itemid =  16125,                                  droprate =   5 }, -- Breeder Mask
            { itemid =  15001,                                  droprate =   5 }, -- Breeder Mufflers
            { itemid =  15946,                                  droprate =   5 }, -- Tempest Belt
            { itemid =  11405,                                  droprate =   5 }, -- Kyoshu Kyahan
            { itemid =  11533,                                  droprate =   5 }, -- Lyricist's Gonnelle
            { itemid =  16298,                                  droprate =   5 }, -- Knack Pendant
            { itemid =  17454,                                  droprate =   5 }, -- Asklepios
            { itemid =  17455,                                  droprate =   5 }, -- Skirnir's Wand
            { itemid =  16912,                                  droprate =   5 }, -- Kitsutsuki
            { itemid =  17926,                                  droprate =   5 }, -- Acha D'Armas
            { itemid =  17982,                                  droprate =   5 }, -- Kard
            { itemid =  17983,                                  droprate =   5 }, -- Valiant Knife
            { itemid =  18042,                                  droprate =   5 }, -- Ascention
            { itemid =  17563,                                  droprate =   5 }, -- Power Staff
            { itemid =  17969,                                  droprate =   5 }, -- Fendoir
            { itemid =  18608,                                  droprate =   5 }, -- Atesh Pole
            { itemid =  16727,                                  droprate =   5 }, -- Eisentaenzer
            { itemid =  17971,                                  droprate =   5 }, -- Tartaglia
            { itemid =  19235,                                  droprate =   5 }, -- Veuglaire
            { itemid =  16375,                                  droprate =   5 }, -- Surge Subligar
            { itemid =  xi.item.ASTRAL_ASPIS,                   droprate =   5 },
            { itemid =  xi.item.GAE_BOLG,                       droprate =   5 },
            { itemid =  xi.item.LOHAR,                          droprate =   5 },
            { itemid =   19122,                                 droprate =   5 }, -- Courser's Pugio
            { itemid =   16081,                                 droprate =   5 }, -- Curate's Hat
            { itemid =   15882,                                 droprate =   5 }, -- Othinus' Bow
            { itemid =   17244,                                 droprate =   5 }, -- Storm Belt
            { itemid =   14806,                                 droprate =   5 }, -- Intruder Earring
            { itemid =   14466,                                 droprate =   5 }, -- Fomor Tunic
            { itemid =   18007,                                 droprate =   5 }, -- Chiroptera Dagger
            { itemid =   17510,                                 droprate =   5 }, -- Vampiric Claws
            { itemid =   14763,                                 droprate =   5 }, -- Boroka Earring
            { itemid =   13178,                                 droprate =   5 }, -- Auditory Torque
            { itemid =   15943,                                 droprate =   5 }, -- Virtuoso Belt
            { itemid =   14884,                                 droprate =   5 }, -- Mycophile Cuffs
            { itemid =   17794,                                 droprate =   5 }, -- Niokiyotsuna
            { itemid =   15219,                                 droprate =   5 }, -- Sinister Mask
            { itemid =   16368,                                 droprate =   5 }, -- Herder's Subligar
            { itemid =   14724,                                 droprate =   5 }, -- Moldavite Earring
            { itemid =   16279,                                 droprate =   5 }, -- Pile Chain
            { itemid =   15546,                                 droprate =   5 }, -- Fasting Ring
            { itemid =   16299,                                 droprate =   5 }, -- Lleu's Charm
            { itemid =   11496,                                 droprate =   5 }, -- Fenrir's Crown
            { itemid =   14168,                                 droprate =   5 }, -- Dune Boots
            { itemid =   17854,                                 droprate =   5 }, -- Cradle Horn
            { itemid =   19239,                                 droprate =   5 }, -- Astrolable
            { itemid =   16169,                                 droprate =   5 }, -- Caballero Shield
            { itemid =   17653,                                 droprate =   5 }, -- Hrotti
            { itemid =   18027,                                 droprate =   5 }, -- Palladium Dagger
            { itemid =   17564,                                 droprate =   5 }, -- Cocytus Pole
            { itemid =   16426,                                 droprate =   5 }, -- Avengers
            { itemid =   19121,                                 droprate =   5 }, -- Sleight Kukri
            { itemid =   15944,                                 droprate =   5 }, -- Selemnus Belt
            { itemid =   16297,                                 droprate =   5 }, -- Shepherd's Chain
            { itemid =  xi.item.KAMEWARI,                       droprate =   5 },
            { itemid =  xi.item.NADRS,                          droprate =   5 },
            { itemid =  xi.item.ALTDORFS_EARRING,               droprate =   5 },
            { itemid =  xi.item.WILHELMS_EARRING,               droprate =   5 },
            { itemid =  xi.item.HELENUSS_EARRING,               droprate =   5 },
            { itemid =  xi.item.CASSANDRAS_EARRING,             droprate =   5 },
            { itemid =  xi.item.MINSTRELS_DAGGER,               droprate =   5 },
            { itemid =  xi.item.SAND_CHARM,                     droprate =   5 },
            { itemid =   15692,                                 droprate =   5 }, -- Storm Crackows
            { itemid =   14669,                                 droprate =   5 }, -- Jaeger Ring
            { itemid =   15351,                                 droprate =   5 }, -- Bounding Boots
            { itemid =   18018,                                 droprate =   5 }, -- Sirocco Kukri
            { itemid =   13567,                                 droprate =   5 }, -- Bomb Queen Ring
            { itemid =   15547,                                 droprate =   5 }, -- Vilma's Ring
            { itemid =   26164,                                 droprate =   4 }, -- Caliber Ring
            { itemid =   15183,                                 droprate =   5 }, -- Dobson Bandana
            { itemid =   15184,                                 droprate =   5 }, -- Voyager Sallet
            { itemid =   14986,                                 droprate =   5 }, -- Ochimusha Kote
            { itemid =   15737,                                 droprate =   5 }, -- Sarutobi Kyahan
            { itemid =   15551,                                 droprate =   5 }, -- Shikaree Ring
            { itemid =  xi.item.EMPRESS_HAIRPIN,                droprate =   5 },
            { itemid =  xi.item.JOYEUSE,                        droprate =   5 },
            { itemid =  xi.item.DRYAD_STAFF,                    droprate =   5 },
            { itemid =  xi.item.VALIS_BOW,                      droprate =   5 },
            { itemid =  xi.item.RETALIATORS,                    droprate =   5 },
            { itemid =  xi.item.UNGUR_BOOMERANG,                droprate =   5 },
            { itemid =   15515,                                 droprate =   2 }, -- Peacock Amulet
            { itemid =  xi.item.TROTTER_BOOTS,                  droprate =   2 },
            { itemid =   19236,                                 droprate =   2 }, -- Hightail Bullet
            { itemid =   17192,                                 droprate =   3 }, -- Ifrit's Bow
            { itemid =   17711,                                 droprate =   5 }, -- Shiva's Shotel
            { itemid =   18021,                                 droprate =   5 }, -- Titan's Baselarde
            { itemid =   18063,                                 droprate =   5 }, -- Garuda's Sickle
            { itemid =   18109,                                 droprate =   5 }, -- Leviathan's Couse
            { itemid =   18404,                                 droprate =   5 }, -- Ramuh's Mace
            { itemid =   18581,                                 droprate =   5 }, -- Carbuncle's Pole
            { itemid =   14931,                                 droprate =   5 }, -- Carbuncle's Cuffs
            { itemid =   18422,                                 droprate =   5 }, -- Ryumon
            { itemid =   14960,                                 droprate =   5 }, -- Evoker's Gages
            { itemid =   19277,                                 droprate =   5 }, -- Tsugumi
            { itemid =   11408,                                 droprate =   5 }, -- Morana Pigaches
            { itemid =   11409,                                 droprate =   5 }, -- Aoide's Pumps
            { itemid =   16238,                                 droprate =   5 }, -- Taster's Cape
            { itemid =   11497,                                 droprate =   5 }, -- Spurrer Beret
            { itemid =   11406,                                 droprate =   5 }, -- Stimulus Sabots
            { itemid =   18767,                                 droprate =   5 }, -- Birdbanes
            { itemid =   15854,                                 droprate =   5 }, -- Sortie Ring
            { itemid =   15915,                                 droprate =   5 }, -- Sothic Rope
            { itemid =   11342,                                 droprate =   5 }, -- Restorer Cloak
            { itemid =   18770,                                 droprate =   5 }, -- Pygme Sainti
            { itemid =   17737,                                 droprate =   5 }, -- Corsair's Scimitar
            { itemid =   19124,                                 droprate =   5 }, -- Creve-coeur
            { itemid =   19279,                                 droprate =   5 }, -- Musanto
            { itemid =   17766,                                 droprate =   5 }, -- Lyft Scimitar
            { itemid =   17970,                                 droprate =   5 }, -- Lyft Tabar
            { itemid =   18508,                                 droprate =   5 }, -- Lyft Voulge
            { itemid =   18609,                                 droprate =   5 }, -- Lyft Pole
            { itemid =   18771,                                 droprate =   5 }, -- Lyft Sainti
            { itemid =   18872,                                 droprate =   5 }, -- Lyft Ferule
            { itemid =   18958,                                 droprate =   5 }, -- Lyft Scythe
            { itemid =   19125,                                 droprate =   5 }, -- Lyft Jambiya
            { itemid =   19161,                                 droprate =   5 }, -- Lyft Claymore
            { itemid =   19233,                                 droprate =   5 }, -- Lyft Crossbow
            { itemid =   19306,                                 droprate =   5 }, -- Lyft Lance
            { itemid =  xi.item.LAVAS_RING,                     droprate =   5 },
            { itemid =  xi.item.KUSHAS_RING,                    droprate =   5 },
            { itemid =  xi.item.NASATYAS_RING,                  droprate =   5 },
            { itemid =  xi.item.DASRAS_RING,                    droprate =   5 },
            { itemid =  xi.item.HOPE_STAFF,                     droprate =   5 },
            { itemid =  xi.item.JUSTICE_SWORD,                  droprate =   5 },
            { itemid =  xi.item.TEMPERANCE_AXE,                 droprate =   5 },
            { itemid =  xi.item.LOVE_HALBERD,                   droprate =   5 },
            { itemid =  xi.item.FORTITUDE_AXE,                  droprate =   5 },
            { itemid =  xi.item.FAITH_BAGHNAKHS,                droprate =   5 },
            { itemid =  xi.item.PRUDENCE_ROD,                   droprate =   5 },
            { itemid =  xi.item.BYAKKOS_AXE,                    droprate =   5 },
            { itemid =  xi.item.SUZAKUS_SCYTHE,                 droprate =   5 },
            { itemid =  xi.item.SEIRYUS_SWORD,                  droprate =   5 },
            { itemid =  xi.item.SANGUINE_SWORD,                 droprate =   5 },
        },
        -- Slot 7, Equipment --
        {
            { itemid =  5230,                                   droprate =  10 }, -- Love Chocolate
            { itemid = xi.item.AERN_DAGGER,                     droprate =   5 },
            { itemid = xi.item.AERN_SWORD,                      droprate =   5 },
            { itemid = xi.item.AERN_AXE,                        droprate =   5 },
            { itemid = xi.item.AERN_SPEAR,                      droprate =   5 },
            { itemid = xi.item.AERN_STAFF,                      droprate =   5 },
            { itemid = xi.item.CHICKEN_KNIFE_II,                droprate =   5 },
            { itemid = xi.item.GENBUS_KABUTO,                   droprate =   5 },
            { itemid = xi.item.GENBUS_SHIELD,                   droprate =   5 },
            { itemid = xi.item.SEIRYUS_KOTE,                    droprate =   5 },
            { itemid = xi.item.SUZAKUS_SUNE_ATE,                droprate =   5 },
            { itemid = xi.item.BYAKKOS_HAIDATE,                 droprate =   5 },
            { itemid = xi.item.ANIMATOR_P1,                     droprate =   5 },
            { itemid = 17567,                                   droprate =   5 }, -- Kirin's Pole
            { itemid = 12562,                                   droprate =   5 }, -- Kirin's Osode
            { itemid = 19123,                                   droprate =   5 }, -- Cinquedea
            { itemid = 15221,                                   droprate =   5 }, -- Patroclus's Helm
            { itemid = 15182,                                   droprate =   5 }, -- Zoolater Hat
            { itemid = 11343,                                   droprate =   5 }, -- Thrakon Breastplate
            { itemid = 13804,                                   droprate =   5 }, -- Minstrel's Coat
            { itemid = 13805,                                   droprate =   5 }, -- Assault Jerkin
            { itemid = 14467,                                   droprate =   5 }, -- Archer's Jupon
            { itemid = 16126,                                   droprate =   5 }, -- Bowman's Mask
            { itemid = 15744,                                   droprate =   5 }, -- Bowman's Ledelsens
            { itemid = 16034,                                   droprate =   5 }, -- Sarabande Earring
            { itemid = 12361,                                   droprate =   5 }, -- Sipar
            { itemid = 13914,                                   droprate =   5 }, -- Aegishjalmr
            { itemid = 14075,                                   droprate =   5 }, -- Andvaranauts
            { itemid = 13415,                                   droprate =   5 }, -- Pixie Earring
            { itemid = 16300,                                   droprate =   5 }, -- Wit Pendant
            { itemid = 16303,                                   droprate =   5 }, -- Laran's Pendant
            { itemid = 15057,                                   droprate =   5 }, -- Bricta's Cuffs
            { itemid = 14943,                                   droprate =   5 }, -- Barbarossa's Moufles
            { itemid = 16376,                                   droprate =   5 }, -- Bahram Cuisses
            { itemid = 16302,                                   droprate =   3 }, -- Bloodbead Gorget
            { itemid = 11411,                                   droprate =   3 }, -- Shrewd Pumps
            { itemid = 15223,                                   droprate =   3 }, -- Ace's Helm
            { itemid = 18002,                                   droprate =   3 }, -- Perseu's Harp
            { itemid = 14873,                                   droprate =   3 }, -- Bandomusha Kote
            { itemid = 19280,                                   droprate =   3 }, -- Narigitsune
            { itemid = xi.item.WYRM_BEARD,                      droprate =   3 },
            { itemid = xi.item.BEHEMOTH_TONGUE,                 droprate =   3 },
            { itemid = xi.item.ADAMANTOISE_EGG,                 droprate =   3 },
            { itemid = xi.item.SEVENEYES,                       droprate =   3 },
            { itemid = xi.item.ALGOL,                           droprate =   3 },
            { itemid = 13658,                                   droprate =   2 }, -- Shadow Mantle
            { itemid = 14646,                                   droprate =   2 }, -- Shadow Ring
            { itemid = 11589,                                   droprate =   2 }, -- Aesir Torque
            { itemid = 16057,                                   droprate =   2 }, -- Aesir Ear Pendant
            { itemid = 11546,                                   droprate =   2 }, -- Aesir Mantle
            { itemid = 11547,                                   droprate =   2 }, -- Colossus's Mantle
            { itemid = 11590,                                   droprate =   2 }, -- Colossus's Torque
            { itemid = 16058,                                   droprate =   2 }, -- Colossus's Earring
            { itemid = 18019,                                   droprate =   2 }, -- X's Knife
            { itemid = 18057,                                   droprate =   2 }, -- Y's Scythe
            { itemid = 18101,                                   droprate =   2 }, -- Z's Trident
            { itemid = 15899,                                   droprate =   2 }, -- Velocious Belt
            { itemid = 15617,                                   droprate =   2 }, -- Barbarossa's Zerehs
            { itemid = 17586,                                   droprate =   2 }, -- Mercurial Pole
            { itemid = xi.item.JUSTICE_TORQUE,                  droprate =   1 },
            { itemid = xi.item.HOPE_TORQUE,                     droprate =   1 },
            { itemid = xi.item.PRUDENCE_TORQUE,                 droprate =   1 },
            { itemid = xi.item.FORTITUDE_TORQUE,                droprate =   1 },
            { itemid = xi.item.FAITH_TORQUE,                    droprate =   1 },
            { itemid = xi.item.TEMPERANCE_TORQUE,               droprate =   1 },
            { itemid = xi.item.LOVE_TORQUE,                     droprate =   1 },
            { itemid = xi.item.RIDILL,                          droprate =   1 },
            { itemid = xi.item.OCTAVE_CLUB,                     droprate =   1 },
            { itemid = xi.item.HAUTECLAIRE,                     droprate =   1 },
            { itemid = 13566,                                   droprate =   1 }, -- Defending Ring
            { itemid = 27456,                                   droprate =   1 }, -- Crier's Gaiters
            { itemid = 14468,                                   droprate =   2 }, -- Yinyang Robe
            { itemid =    0,                                    droprate = 750 }, -- nothing
        },
        -- Slot 4, Materials --
        {
            { itemid = xi.item.MOAT_CARP,                       droprate =   5 },
            { itemid = xi.item.IRON_INGOT,                      droprate =   7 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   7 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   7 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   7 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   7 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   7 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   7 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   7 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   7 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   7 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   7 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   7 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   7 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   7 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   7 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   7 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   7 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   7 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   7 },
            { itemid = xi.item.RAM_HORN,                        droprate =   7 },
            { itemid = xi.item.ELM_LOG,                         droprate =   7 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   7 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   7 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   7 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   7 },
            { itemid = xi.item.SACK_OF_SILICA,                  droprate =   7 },
            { itemid =  850,                                    droprate =   7 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   7 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   7 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   7 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   7 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   7 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   7 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   7 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   7 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   7 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   7 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   7 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   7 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   7 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   7 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   7 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   7 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   7 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   7 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   7 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   7 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   7 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   7 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   7 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   7 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   7 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   7 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   7 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   7 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   7 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   7 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   7 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   7 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   7 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   7 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   7 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   7 },
            { itemid = xi.item.IMP_HORN,                        droprate =   7 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   7 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   7 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   7 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   7 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   7 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   7 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   7 },
            { itemid = 1225,                                    droprate =   7 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   7 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   7 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   7 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   7 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   7 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   7 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   7 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   7 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   7 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   7 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   7 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   7 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   7 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   7 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   7 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   7 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   5 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   5 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   5 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   5 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   5 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   5 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   5 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   5 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   5 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   5 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   5 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   5 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   5 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   5 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   4 },
            { itemid = 2151,                                    droprate =   4 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   4 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   4 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   5 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   5 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   5 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   5 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   5 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   5 }, -- Water Anima
            { itemid = 1647,                                    droprate =   5 }, -- Light Anima
            { itemid = 1648,                                    droprate =   5 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   4 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   4 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   4 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   4 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   4 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   4 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   4 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   4 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   4 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   4 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   4 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   4 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   4 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   4 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   4 },
            { itemid =  734,                                    droprate =   4 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   4 }, -- Amphiptere Hide
            { itemid = 2164,                                    droprate =   4 }, -- Pephredo Hive Chip
            { itemid = 1279,                                    droprate =   4 }, -- Taffeta Cloth
            { itemid = 1280,                                    droprate =   4 }, -- Sarcenet Cloth
            { itemid = 1281,                                    droprate =   4 }, -- Cheviot Cloth
            { itemid = 1295,                                    droprate =   4 }, -- Twincoon
            { itemid = 1270,                                    droprate =   4 }, -- Arachne Web
            { itemid =  647,                                    droprate =   4 }, -- Molybdenum Ore
            { itemid = 1271,                                    droprate =   4 }, -- Pigeon's Blood Ruby
            { itemid = 1276,                                    droprate =   4 }, -- Tarasque Skin
            { itemid = 1296,                                    droprate =   4 }, -- Yowie Skin
            { itemid = 1277,                                    droprate =   4 }, -- Lindwurm Skin
            { itemid = 1765,                                    droprate =   4 }, -- Habu Skin
            { itemid = 2828,                                    droprate =   4 }, -- Herensugue Skin
            { itemid = 2837,                                    droprate =   4 }, -- Ratatoskr Pelt
            { itemid = 2839,                                    droprate =   4 }, -- Coquecigrue Skin
            { itemid = 2830,                                    droprate =   4 }, -- Bastet Fang
            { itemid = 2833,                                    droprate =   4 }, -- Thunder Coral
            { itemid = 1272,                                    droprate =   4 }, -- Arioch Fang
            { itemid = 1273,                                    droprate =   4 }, -- Namtar Bone
            { itemid = 2849,                                    droprate =   4 }, -- Likho Talon
            { itemid = 2846,                                    droprate =   4 }, -- Hefty Oak Lumber
            { itemid = 2855,                                    droprate =   4 }, -- Mahogany Heartwood
            { itemid = xi.item.CHUNK_OF_FIRE_ORE,               droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ICE_ORE,                droprate =   5 },
            { itemid = xi.item.CHUNK_OF_WIND_ORE,               droprate =   5 },
            { itemid = xi.item.CHUNK_OF_EARTH_ORE,              droprate =   5 },
            { itemid = xi.item.CHUNK_OF_LIGHTNING_ORE,          droprate =   5 },
            { itemid = xi.item.CHUNK_OF_WATER_ORE,              droprate =   5 },
            { itemid = xi.item.CHUNK_OF_LIGHT_ORE,              droprate =   5 },
            { itemid = xi.item.CHUNK_OF_DARK_ORE,               droprate =   5 },
            { itemid = xi.item.CLUMP_OF_IMPERIAL_TEA_LEAVES,    droprate =   5 },
            { itemid = xi.item.DRAGON_FRUIT,                    droprate =   2 },
            { itemid = xi.item.WALNUT,                          droprate =   2 },
            { itemid = xi.item.BOWL_OF_AMBROSIA,                droprate =   2 },
            { itemid = xi.item.BOTTLE_OF_AMRITA,                droprate =   2 },
            { itemid = xi.item.DRAGON_HEART,                    droprate =   2 },
            { itemid = xi.item.HANDFUL_OF_DRAGON_SCALES,        droprate =   2 },
            { itemid = xi.item.SLICE_OF_DRAGON_MEAT,            droprate =   2 },
            { itemid = xi.item.CHUNK_OF_HYDRA_MEAT,             droprate =   2 },
            { itemid = xi.item.SLICE_OF_CERBERUS_MEAT,          droprate =   2 },
            { itemid = xi.item.BEHEMOTH_HIDE,                   droprate =   2 },
            { itemid = xi.item.BEHEMOTH_HORN,                   droprate =   2 },
            { itemid = 2158,                                    droprate =   2 }, -- Hydra Fang
            { itemid = 2172,                                    droprate =   2 }, -- Hydra Scale
            { itemid = 2168,                                    droprate =   2 }, -- Cerberus Claw
            { itemid = 2169,                                    droprate =   2 }, -- Cerberus Hide
            { itemid = 2371,                                    droprate =   2 }, -- Khimaira Horn
            { itemid = 2372,                                    droprate =   2 }, -- Khimaira Mane
            { itemid = 2373,                                    droprate =   2 }, -- Khimaira Tail
            { itemid = 4273,                                    droprate =   2 }, -- Kitron
            { itemid = 1718,                                    droprate =   2 }, -- M-bugard Tusk
            { itemid = 1719,                                    droprate =   2 }, -- Harajnite Shell  
        },
        -- Slot 5, Misc/Medicine --
        {
            { itemid = xi.item.RERAISER,                        droprate =  40 },
            { itemid = xi.item.FIRE_CLUSTER,                    droprate =  30 },
            { itemid = xi.item.ICE_CLUSTER,                     droprate =  30 },
            { itemid = xi.item.WIND_CLUSTER,                    droprate =  30 },
            { itemid = xi.item.EARTH_CLUSTER,                   droprate =  30 },
            { itemid = xi.item.LIGHTNING_CLUSTER,               droprate =  30 },
            { itemid = xi.item.WATER_CLUSTER,                   droprate =  30 },
            { itemid = xi.item.LIGHT_CLUSTER,                   droprate =  30 },
            { itemid = xi.item.DARK_CLUSTER,                    droprate =  30 },
            { itemid = xi.item.ANTIDOTE,                        droprate =  30 },
            { itemid = xi.item.FLASK_OF_ECHO_DROPS,             droprate =  30 },
            { itemid = xi.item.FLASK_OF_HOLY_WATER,             droprate =  30 },
            { itemid = xi.item.HI_RERAISER,                     droprate =  30 },
            { itemid = xi.item.VILE_ELIXIR,                     droprate =  30 },
            { itemid = 4512,                                    droprate =  40 }, -- Vampire Juice
            { itemid = 5356,                                    droprate =  40 }, -- Remedy Ointment
            { itemid = 4153,                                    droprate =  30 }, -- Antacid
            { itemid = 5254,                                    droprate =  30 }, -- Hyper Potion
            { itemid = 5255,                                    droprate =  30 }, -- Hyper Ether
            { itemid = xi.item.REMEDY,                          droprate =  25 },
            { itemid = 4149,                                    droprate =  25 }, -- Panacea
            { itemid = 5350,                                    droprate =  20 }, -- Volant Serum
            { itemid = xi.item.TRAINING_MANUAL,                 droprate =  20 },
            { itemid = xi.item.MOAT_CARP,                       droprate =  20 },
            { itemid = xi.item.PINCH_OF_PUNGENT_POWDER_II,      droprate =  20 },
            { itemid = 5724,                                    droprate =  20 }, -- Pungent Powder I
            { itemid =    0,                                    droprate = 250 }, -- nothing
        },
    },
    [75] =
    {   -- Slot 1, Currency --
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate =  90 },
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  60 },
            { itemid = xi.item.COTTON_COIN_PURSE,               droprate =  10 },
            { itemid = xi.item.LINEN_COIN_PURSE,                droprate =  90 },
            { itemid = xi.item.ONE_BYNE_BILL,                   droprate =  30 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =  40 },
            { itemid = xi.item.ORDELLE_BRONZEPIECE,             droprate =  30 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =  40 },
            { itemid = xi.item.TUKUKU_WHITESHELL,               droprate =  30 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =  40 },
            { itemid = xi.item.IMPERIAL_GOLD_PIECE,             droprate =  10 },
            { itemid =  6541,                                   droprate =  90 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  90 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  90 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  90 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  90 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter
        },
        -- Slot 6, Currency --
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate =  40 },
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  20 },
            { itemid = xi.item.COTTON_COIN_PURSE,               droprate =  10 },
            { itemid = xi.item.LINEN_COIN_PURSE,                droprate =  70 },
            { itemid = xi.item.ONE_BYNE_BILL,                   droprate =  20 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =  20 },
            { itemid = xi.item.ORDELLE_BRONZEPIECE,             droprate =  20 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =  20 },
            { itemid = xi.item.TUKUKU_WHITESHELL,               droprate =  20 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =  20 },
            { itemid = xi.item.IMPERIAL_GOLD_PIECE,             droprate =  10 },
            { itemid =  6541,                                   droprate =  80 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  80 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  80 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  80 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  80 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter
            { itemid =    0,                                    droprate = 250 }, -- nothing
        },
        -- Slot 10, Tatters --
        {
            { itemid =  3283,                                   droprate = 125 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate = 125 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate = 125 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate = 125 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate = 125 }, -- Martial Tatter
            { itemid =  3279,                                   droprate = 125 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate = 125 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate = 125 }, -- Wyrmal Tatter
        },
        -- Slot 2, Pop Items --
        {
            { itemid = xi.item.CURTANA,                         droprate =  40 },
            { itemid = xi.item.CHUNK_OF_DIORITE,                droprate =  40 },
            { itemid = xi.item.FLASK_OF_ROMAEVE_SPRING_WATER,   droprate =  40 },
            { itemid = xi.item.GEM_OF_THE_EAST,                 droprate =  30 },
            { itemid = xi.item.SPRINGSTONE,                     droprate =  30 },
            { itemid = xi.item.GEM_OF_THE_SOUTH,                droprate =  30 },
            { itemid = xi.item.SUMMERSTONE,                     droprate =  30 },
            { itemid = xi.item.GEM_OF_THE_WEST,                 droprate =  30 },
            { itemid = xi.item.AUTUMNSTONE,                     droprate =  30 },
            { itemid = xi.item.GEM_OF_THE_NORTH,                droprate =  30 },
            { itemid = xi.item.WINTERSTONE,                     droprate =  30 },
            { itemid = xi.item.DRAGON_CHRONICLES,               droprate =   5 },
            { itemid = xi.item.IVORY_CHIP,                      droprate =  30 },
            { itemid = xi.item.SCARLET_CHIP,                    droprate =  30 },
            { itemid = xi.item.EMERALD_CHIP,                    droprate =  30 },
            { itemid = xi.item.SILVER_CHIP,                     droprate =  20 },
            { itemid = xi.item.CERULEAN_CHIP,                   droprate =  20 },
            { itemid = 1986,                                    droprate =  20 }, -- Orchid Chip
            { itemid = xi.item.SMALT_CHIP,                      droprate =  20 },
            { itemid = xi.item.SMOKY_CHIP,                      droprate =  20 },
            { itemid = 1987,                                    droprate =  20 }, -- Charcoal Chip
            { itemid = 1988,                                    droprate =  20 }, -- Magenta Chip
            { itemid = xi.item.HIGH_QUALITY_PHUABO_ORGAN,       droprate =  10 },
            { itemid = xi.item.HIGH_QUALITY_HPEMDE_ORGAN,       droprate =  10 },
            { itemid = xi.item.HIGH_QUALITY_EUVHI_ORGAN,        droprate =  10 },
            { itemid = xi.item.HIGH_QUALITY_AERN_ORGAN,         droprate =  10 },
            { itemid =  1855,                                   droprate =  10 }, -- H.Q. Xzomit Organ
            { itemid =  1784,                                   droprate =   5 }, -- Phuabo Organ
            { itemid =  1785,                                   droprate =   5 }, -- Xzomit Organ
            { itemid =  1786,                                   droprate =   5 }, -- Aern Organ
            { itemid =  1787,                                   droprate =   5 }, -- Hpemde Organ
            { itemid =  1788,                                   droprate =   5 }, -- Yovra Organ
            { itemid =  1872,                                   droprate =   5 }, -- Ghrah M Chip
            { itemid =  1783,                                   droprate =   5 }, -- Luminian Tissue
            { itemid =  1288,                                   droprate =  10 }, -- Wooden Hakutatku Eye
            { itemid =  1289,                                   droprate =  10 }, -- Burning Hakutatku Eye
            { itemid =  1290,                                   droprate =  10 }, -- Earthen Hakutatku Eye
            { itemid =  1291,                                   droprate =  10 }, -- Golden Hakutatku Eye
            { itemid =  1292,                                   droprate =  10 }, -- Damp Hakutatku Eye
            { itemid = xi.item.JAR_OF_PEISTE_PELLETS,           droprate =   5 },
            { itemid = xi.item.JAR_OF_GNAT_PELLETS,             droprate =   5 },
            { itemid =  2565,                                   droprate =   5 }, -- Gnole Pellets
            { itemid = xi.item.FLICKERING_LANTERN,              droprate =   5 },
            { itemid = xi.item.OFFERING_TO_UGGALEPIH,           droprate =   5 },
            { itemid = xi.item.SAHAGIN_KEY,                     droprate =   5 },
            { itemid = xi.item.DEED_OF_PLACIDITY,               droprate =  40 },
            { itemid = xi.item.DEED_OF_SENSIBILITY,             droprate =  40 },
            { itemid =  1854,                                   droprate =  40 }, -- Deed of Moderation
            { itemid = xi.item.FIRST_VIRTUE,                    droprate =  20 },
            { itemid =  1853,                                   droprate =  20 }, -- Second Virtue
            { itemid = xi.item.THIRD_VIRTUE,                    droprate =  20 },
            { itemid = xi.item.ANTLION_TRAP,                    droprate =  15 },
            { itemid = xi.item.HAUNTED_MULETA,                  droprate =  15 },
            { itemid = xi.item.SHRIMP_LANTERN,                  droprate =  15 },
            { itemid = xi.item.ARK_PENTASPHERE,                 droprate =   5 },
            { itemid = xi.item.PIRATES_CHART,                   droprate =   5 },
            { itemid = xi.item.BRIGANDS_CHART,                  droprate =   5 },
        },
        -- Slot 3, Equipment --
        {
            { itemid = xi.item.MELEE_CAPE,                      droprate =   3 },
            { itemid = xi.item.ABYSS_CAPE,                      droprate =   3 },
            { itemid = xi.item.ASSASSINS_CAPE,                  droprate =   3 },
            { itemid = xi.item.VALOR_CAPE,                      droprate =   3 },
            { itemid = xi.item.BARDS_CAPE,                      droprate =   3 },
            { itemid = xi.item.SUMMONERS_CAPE,                  droprate =   3 },
            { itemid = xi.item.WARRIORS_STONE,                  droprate =   3 },
            { itemid = xi.item.CLERICS_BELT,                    droprate =   3 },
            { itemid = xi.item.DUELISTS_BELT,                   droprate =   3 },
            { itemid = xi.item.SORCERERS_BELT,                  droprate =   3 },
            { itemid = xi.item.MONSTER_BELT,                    droprate =   3 },
            { itemid = xi.item.SCOUTS_BELT,                     droprate =   3 },
            { itemid = xi.item.KOGA_SARASHI,                    droprate =   3 },
            { itemid = xi.item.WYRM_BELT,                       droprate =   3 },
            { itemid = xi.item.SAOTOME_KOSHI_ATE,               droprate =   3 },
            { itemid = xi.item.COMMODORE_BELT,                  droprate =   3 },
            { itemid = xi.item.ARGUTE_BELT,                     droprate =   3 },
            { itemid = xi.item.MIRAGE_MANTLE,                   droprate =   3 },
            { itemid = xi.item.PANTIN_CAPE,                     droprate =   3 },
            { itemid = xi.item.ETOILE_CAPE,                     droprate =   3 },
            { itemid = xi.item.KOBO_OBI,                        droprate =   3 },  -- GEO Dynamis Accessory
            { itemid = xi.item.TANTALIC_CAPE,                   droprate =   3 },  -- RUN Dynamis Accessory
            { itemid = xi.item.CARPENTERS_BELT,                 droprate =   1 },
            { itemid = xi.item.BLACKSMITHS_BELT,                droprate =   1 },
            { itemid = xi.item.GOLDSMITHS_BELT,                 droprate =   1 },
            { itemid = xi.item.WEAVERS_BELT,                    droprate =   1 },
            { itemid = xi.item.TANNERS_BELT,                    droprate =   1 },
            { itemid = xi.item.BONEWORKERS_BELT,                droprate =   1 },
            { itemid = xi.item.ALCHEMISTS_BELT,                 droprate =   1 },
            { itemid = xi.item.CULINARIANS_BELT,                droprate =   1 },
            { itemid = xi.item.FISHERMANS_BELT,                 droprate =   1 },
            { itemid = xi.item.HAMAYUMI,                        droprate =   5 },
            { itemid = xi.item.DIA_WAND,                        droprate =   5 },
            { itemid = xi.item.STONE_GORGET,                    droprate =   5 },
            { itemid = xi.item.PILGRIMS_WAND,                   droprate =   5 },
            { itemid = xi.item.GELONG_STAFF,                    droprate =   5 },
            { itemid = xi.item.WEBCUTTER,                       droprate =   5 },
            { itemid =  18412,                                  droprate =   5 }, -- Gassan
            { itemid =  17708,                                  droprate =   5 }, -- Auriga Xiphos
            { itemid =  18359,                                  droprate =   5 }, -- Boreas Cesti
            { itemid =  15220,                                  droprate =   5 }, -- Rain Hat
            { itemid =  15468,                                  droprate =   5 }, -- Resentment Cape
            { itemid =  15505,                                  droprate =   5 }, -- Dhalmel Whistle
            { itemid =  14667,                                  droprate =   5 }, -- Carect Ring
            { itemid =  xi.item.GOTHIC_SABATONS,                droprate =   5 },
            { itemid =  xi.item.GOTHIC_GAUNTLETS,               droprate =   5 },
            { itemid =  11529,                                  droprate =   5 }, -- Frugal Cape
            { itemid =  16187,                                  droprate =   5 }, -- Adoubeurs Pavise
            { itemid =  16899,                                  droprate =   5 }, -- Hototogisu
            { itemid =  16374,                                  droprate =   5 }, -- Layqa Seraweels
            { itemid =  17199,                                  droprate =   5 }, -- Loxley Bow
            { itemid =  16882,                                  droprate =   5 }, -- Calamar
            { itemid =  17504,                                  droprate =   5 }, -- Pagures
            { itemid =  16884,                                  droprate =   5 }, -- Narval
            { itemid =  17503,                                  droprate =   5 }, -- Exocets
            { itemid =  19238,                                  droprate =   5 }, -- Jasper Tathlum
            { itemid =  11404,                                  droprate =   5 }, -- Promptitude Solea
            { itemid =  15897,                                  droprate =   5 }, -- Grace Corset
            { itemid =  13803,                                  droprate =   5 }, -- Shaman's Cloak
            { itemid =  19237,                                  droprate =   5 }, -- Slick Dart
            { itemid =  15942,                                  droprate =   5 }, -- Summoning Belt
            { itemid =  xi.item.MUSHROOM_HELM,                  droprate =   5 },
            { itemid =  xi.item.LUNA_SUBLIGAR,                  droprate =   5 },
            { itemid =  16980,                                  droprate =   5 }, -- Sukesada
            { itemid =  13912,                                  droprate =   5 }, -- Shadow Mask
            { itemid =  16943,                                  droprate =   5 }, -- Ascalon
            { itemid =  14063,                                  droprate =   5 }, -- Protecting Bangles
            { itemid =  14064,                                  droprate =   5 }, -- Sand Gloves
            { itemid =  17651,                                  droprate =   5 }, -- Dainslaif
            { itemid =  17924,                                  droprate =   5 }, -- Tungi
            { itemid =  16734,                                  droprate =   5 }, -- Pendragon Axe
            { itemid =  15995,                                  droprate =   5 }, -- Carline Earring
            { itemid =  16127,                                  droprate =   5 }, -- Carline Ribbon
            { itemid =  16125,                                  droprate =   5 }, -- Breeder Mask
            { itemid =  15001,                                  droprate =   5 }, -- Breeder Mufflers
            { itemid =  15946,                                  droprate =   5 }, -- Tempest Belt
            { itemid =  11405,                                  droprate =   5 }, -- Kyoshu Kyahan
            { itemid =  11533,                                  droprate =   5 }, -- Lyricist's Gonnelle
            { itemid =  16298,                                  droprate =   5 }, -- Knack Pendant
            { itemid =  17454,                                  droprate =   5 }, -- Asklepios
            { itemid =  17455,                                  droprate =   5 }, -- Skirnir's Wand
            { itemid =  16912,                                  droprate =   5 }, -- Kitsutsuki
            { itemid =  17926,                                  droprate =   5 }, -- Acha D'Armas
            { itemid =  17982,                                  droprate =   5 }, -- Kard
            { itemid =  17983,                                  droprate =   5 }, -- Valiant Knife
            { itemid =  18042,                                  droprate =   5 }, -- Ascention
            { itemid =  17563,                                  droprate =   5 }, -- Power Staff
            { itemid =  17969,                                  droprate =   5 }, -- Fendoir
            { itemid =  18608,                                  droprate =   5 }, -- Atesh Pole
            { itemid =  16727,                                  droprate =   5 }, -- Eisentaenzer
            { itemid =  17971,                                  droprate =   5 }, -- Tartaglia
            { itemid =  19235,                                  droprate =   5 }, -- Veuglaire
            { itemid =  16375,                                  droprate =   5 }, -- Surge Subligar
            { itemid =  xi.item.ASTRAL_ASPIS,                   droprate =   5 },
            { itemid =  xi.item.GAE_BOLG,                       droprate =   5 },
            { itemid =  xi.item.LOHAR,                          droprate =   5 },
            { itemid =   19122,                                 droprate =   5 }, -- Courser's Pugio
            { itemid =   16081,                                 droprate =   5 }, -- Curate's Hat
            { itemid =   15882,                                 droprate =   5 }, -- Othinus' Bow
            { itemid =   17244,                                 droprate =   5 }, -- Storm Belt
            { itemid =   14806,                                 droprate =   5 }, -- Intruder Earring
            { itemid =   14466,                                 droprate =   5 }, -- Fomor Tunic
            { itemid =   18007,                                 droprate =   5 }, -- Chiroptera Dagger
            { itemid =   17510,                                 droprate =   5 }, -- Vampiric Claws
            { itemid =   14763,                                 droprate =   5 }, -- Boroka Earring
            { itemid =   13178,                                 droprate =   5 }, -- Auditory Torque
            { itemid =   15943,                                 droprate =   5 }, -- Virtuoso Belt
            { itemid =   14884,                                 droprate =   5 }, -- Mycophile Cuffs
            { itemid =   17794,                                 droprate =   5 }, -- Niokiyotsuna
            { itemid =   15219,                                 droprate =   5 }, -- Sinister Mask
            { itemid =   16368,                                 droprate =   5 }, -- Herder's Subligar
            { itemid =   14724,                                 droprate =   5 }, -- Moldavite Earring
            { itemid =   16279,                                 droprate =   5 }, -- Pile Chain
            { itemid =   15546,                                 droprate =   5 }, -- Fasting Ring
            { itemid =   16299,                                 droprate =   5 }, -- Lleu's Charm
            { itemid =   11496,                                 droprate =   5 }, -- Fenrir's Crown
            { itemid =   14168,                                 droprate =   5 }, -- Dune Boots
            { itemid =   17854,                                 droprate =   5 }, -- Cradle Horn
            { itemid =   19239,                                 droprate =   5 }, -- Astrolable
            { itemid =   16169,                                 droprate =   5 }, -- Caballero Shield
            { itemid =   17653,                                 droprate =   5 }, -- Hrotti
            { itemid =   18027,                                 droprate =   5 }, -- Palladium Dagger
            { itemid =   17564,                                 droprate =   5 }, -- Cocytus Pole
            { itemid =   16426,                                 droprate =   5 }, -- Avengers
            { itemid =   19121,                                 droprate =   5 }, -- Sleight Kukri
            { itemid =   15944,                                 droprate =   5 }, -- Selemnus Belt
            { itemid =   16297,                                 droprate =   5 }, -- Shepherd's Chain
            { itemid =  xi.item.KAMEWARI,                       droprate =   5 },
            { itemid =  xi.item.NADRS,                          droprate =   5 },
            { itemid =  xi.item.ALTDORFS_EARRING,               droprate =   5 },
            { itemid =  xi.item.WILHELMS_EARRING,               droprate =   5 },
            { itemid =  xi.item.HELENUSS_EARRING,               droprate =   5 },
            { itemid =  xi.item.CASSANDRAS_EARRING,             droprate =   5 },
            { itemid =  xi.item.MINSTRELS_DAGGER,               droprate =   5 },
            { itemid =  xi.item.SAND_CHARM,                     droprate =   5 },
            { itemid =   15692,                                 droprate =   5 }, -- Storm Crackows
            { itemid =   14669,                                 droprate =   5 }, -- Jaeger Ring
            { itemid =   15351,                                 droprate =   5 }, -- Bounding Boots
            { itemid =   18018,                                 droprate =   5 }, -- Sirocco Kukri
            { itemid =   13567,                                 droprate =   5 }, -- Bomb Queen Ring
            { itemid =   15547,                                 droprate =   5 }, -- Vilma's Ring
            { itemid =   26164,                                 droprate =   5 }, -- Caliber Ring
            { itemid =   15183,                                 droprate =   5 }, -- Dobson Bandana
            { itemid =   15184,                                 droprate =   5 }, -- Voyager Sallet
            { itemid =   14986,                                 droprate =   5 }, -- Ochimusha Kote
            { itemid =   15737,                                 droprate =   5 }, -- Sarutobi Kyahan
            { itemid =   15551,                                 droprate =   5 }, -- Shikaree Ring
            { itemid =  xi.item.EMPRESS_HAIRPIN,                droprate =   5 },
            { itemid =  xi.item.JOYEUSE,                        droprate =   5 },
            { itemid =  xi.item.DRYAD_STAFF,                    droprate =   5 },
            { itemid =  xi.item.VALIS_BOW,                      droprate =   5 },
            { itemid =  xi.item.RETALIATORS,                    droprate =   5 },
            { itemid =  xi.item.UNGUR_BOOMERANG,                droprate =   5 },
            { itemid =   15515,                                 droprate =   2 }, -- Peacock Amulet
            { itemid =  xi.item.TROTTER_BOOTS,                  droprate =   2 },
            { itemid =   19236,                                 droprate =   6 }, -- Hightail Bullet
            { itemid =   17192,                                 droprate =   6 }, -- Ifrit's Bow
            { itemid =   17711,                                 droprate =   6 }, -- Shiva's Shotel
            { itemid =   18021,                                 droprate =   6 }, -- Titan's Baselarde
            { itemid =   18063,                                 droprate =   6 }, -- Garuda's Sickle
            { itemid =   18109,                                 droprate =   6 }, -- Leviathan's Couse
            { itemid =   18404,                                 droprate =   6 }, -- Ramuh's Mace
            { itemid =   18581,                                 droprate =   6 }, -- Carbuncle's Pole
            { itemid =   14931,                                 droprate =   6 }, -- Carbuncle's Cuffs
            { itemid =   18422,                                 droprate =   6 }, -- Ryumon
            { itemid =   14960,                                 droprate =   6 }, -- Evoker's Gages
            { itemid =   19277,                                 droprate =   6 }, -- Tsugumi
            { itemid =   11408,                                 droprate =   6 }, -- Morana Pigaches
            { itemid =   11409,                                 droprate =   6 }, -- Aoide's Pumps
            { itemid =   16238,                                 droprate =   6 }, -- Taster's Cape
            { itemid =   11497,                                 droprate =   6 }, -- Spurrer Beret
            { itemid =   11406,                                 droprate =   6 }, -- Stimulus Sabots
            { itemid =   18767,                                 droprate =   6 }, -- Birdbanes
            { itemid =   15854,                                 droprate =   6 }, -- Sortie Ring
            { itemid =   15915,                                 droprate =   6 }, -- Sothic Rope
            { itemid =   11342,                                 droprate =   6 }, -- Restorer Cloak
            { itemid =   18770,                                 droprate =   6 }, -- Pygme Sainti
            { itemid =   17737,                                 droprate =   6 }, -- Corsair's Scimitar
            { itemid =   19124,                                 droprate =   6 }, -- Creve-coeur
            { itemid =   19279,                                 droprate =   6 }, -- Musanto
            { itemid =   17766,                                 droprate =   6 }, -- Lyft Scimitar
            { itemid =   17970,                                 droprate =   6 }, -- Lyft Tabar
            { itemid =   18508,                                 droprate =   6 }, -- Lyft Voulge
            { itemid =   18609,                                 droprate =   6 }, -- Lyft Pole
            { itemid =   18771,                                 droprate =   6 }, -- Lyft Sainti
            { itemid =   18872,                                 droprate =   6 }, -- Lyft Ferule
            { itemid =   18958,                                 droprate =   6 }, -- Lyft Scythe
            { itemid =   19125,                                 droprate =   6 }, -- Lyft Jambiya
            { itemid =   19161,                                 droprate =   6 }, -- Lyft Claymore
            { itemid =   19233,                                 droprate =   6 }, -- Lyft Crossbow
            { itemid =   19306,                                 droprate =   6 }, -- Lyft Lance
            { itemid =  xi.item.LAVAS_RING,                     droprate =   6 },
            { itemid =  xi.item.KUSHAS_RING,                    droprate =   6 },
            { itemid =  xi.item.NASATYAS_RING,                  droprate =   6 },
            { itemid =  xi.item.DASRAS_RING,                    droprate =   6 },
            { itemid =  xi.item.HOPE_STAFF,                     droprate =   6 },
            { itemid =  xi.item.JUSTICE_SWORD,                  droprate =   6 },
            { itemid =  xi.item.TEMPERANCE_AXE,                 droprate =   6 },
            { itemid =  xi.item.LOVE_HALBERD,                   droprate =   6 },
            { itemid =  xi.item.FORTITUDE_AXE,                  droprate =   6 },
            { itemid =  xi.item.FAITH_BAGHNAKHS,                droprate =   6 },
            { itemid =  xi.item.PRUDENCE_ROD,                   droprate =   6 },
            { itemid =  xi.item.BYAKKOS_AXE,                    droprate =   7 },
            { itemid =  xi.item.SUZAKUS_SCYTHE,                 droprate =   7 },
            { itemid =  xi.item.SEIRYUS_SWORD,                  droprate =   7 },
            { itemid =  xi.item.SANGUINE_SWORD,                 droprate =   8 },
        },
        -- Slot 7, Equipment --
        {
            { itemid =  5230,                                   droprate =  10 }, -- Love Chocolate
            { itemid = xi.item.AERN_DAGGER,                     droprate =   5 },
            { itemid = xi.item.AERN_SWORD,                      droprate =   5 },
            { itemid = xi.item.AERN_AXE,                        droprate =   5 },
            { itemid = xi.item.AERN_SPEAR,                      droprate =   5 },
            { itemid = xi.item.AERN_STAFF,                      droprate =   5 },
            { itemid = xi.item.CHICKEN_KNIFE_II,                droprate =   5 },
            { itemid = xi.item.GENBUS_KABUTO,                   droprate =   5 },
            { itemid = xi.item.GENBUS_SHIELD,                   droprate =   5 },
            { itemid = xi.item.SEIRYUS_KOTE,                    droprate =   5 },
            { itemid = xi.item.SUZAKUS_SUNE_ATE,                droprate =   5 },
            { itemid = xi.item.BYAKKOS_HAIDATE,                 droprate =   5 },
            { itemid = xi.item.ANIMATOR_P1,                     droprate =   5 },
            { itemid = 17567,                                   droprate =   5 }, -- Kirin's Pole
            { itemid = 12562,                                   droprate =   5 }, -- Kirin's Osode
            { itemid = 19123,                                   droprate =   5 }, -- Cinquedea
            { itemid = 15221,                                   droprate =   5 }, -- Patroclus's Helm
            { itemid = 15182,                                   droprate =   5 }, -- Zoolater Hat
            { itemid = 11343,                                   droprate =   5 }, -- Thrakon Breastplate
            { itemid = 13804,                                   droprate =   5 }, -- Minstrel's Coat
            { itemid = 13805,                                   droprate =   5 }, -- Assault Jerkin
            { itemid = 14467,                                   droprate =   5 }, -- Archer's Jupon
            { itemid = 16126,                                   droprate =   5 }, -- Bowman's Mask
            { itemid = 15744,                                   droprate =   5 }, -- Bowman's Ledelsens
            { itemid = 16034,                                   droprate =   5 }, -- Sarabande Earring
            { itemid = 12361,                                   droprate =   5 }, -- Sipar
            { itemid = 13914,                                   droprate =   5 }, -- Aegishjalmr
            { itemid = 14075,                                   droprate =   5 }, -- Andvaranauts
            { itemid = 13415,                                   droprate =   5 }, -- Pixie Earring
            { itemid = 16300,                                   droprate =   5 }, -- Wit Pendant
            { itemid = 16303,                                   droprate =   5 }, -- Laran's Pendant
            { itemid = 15057,                                   droprate =   5 }, -- Bricta's Cuffs
            { itemid = 14943,                                   droprate =   5 }, -- Barbarossa's Moufles
            { itemid = 16376,                                   droprate =   5 }, -- Bahram Cuisses
            { itemid = 16302,                                   droprate =   3 }, -- Bloodbead Gorget
            { itemid = 11411,                                   droprate =   3 }, -- Shrewd Pumps
            { itemid = 15223,                                   droprate =   3 }, -- Ace's Helm
            { itemid = 18002,                                   droprate =   3 }, -- Perseu's Harp
            { itemid = 14873,                                   droprate =   3 }, -- Bandomusha Kote
            { itemid = 19280,                                   droprate =   3 }, -- Narigitsune
            { itemid = xi.item.WYRM_BEARD,                      droprate =   3 },
            { itemid = xi.item.BEHEMOTH_TONGUE,                 droprate =   3 },
            { itemid = xi.item.ADAMANTOISE_EGG,                 droprate =   3 },
            { itemid = xi.item.SEVENEYES,                       droprate =   3 },
            { itemid = xi.item.ALGOL,                           droprate =   3 },
            { itemid = 13658,                                   droprate =   2 }, -- Shadow Mantle
            { itemid = 14646,                                   droprate =   2 }, -- Shadow Ring
            { itemid = 11589,                                   droprate =   2 }, -- Aesir Torque
            { itemid = 16057,                                   droprate =   2 }, -- Aesir Ear Pendant
            { itemid = 11546,                                   droprate =   2 }, -- Aesir Mantle
            { itemid = 11547,                                   droprate =   2 }, -- Colossus's Mantle
            { itemid = 11590,                                   droprate =   2 }, -- Colossus's Torque
            { itemid = 16058,                                   droprate =   2 }, -- Colossus's Earring
            { itemid = 18019,                                   droprate =   2 }, -- X's Knife
            { itemid = 18057,                                   droprate =   2 }, -- Y's Scythe
            { itemid = 18101,                                   droprate =   2 }, -- Z's Trident
            { itemid = 15899,                                   droprate =   2 }, -- Velocious Belt
            { itemid = 15617,                                   droprate =   2 }, -- Barbarossa's Zerehs
            { itemid = 17586,                                   droprate =   2 }, -- Mercurial Pole
            { itemid = xi.item.JUSTICE_TORQUE,                  droprate =   1 },
            { itemid = xi.item.HOPE_TORQUE,                     droprate =   1 },
            { itemid = xi.item.PRUDENCE_TORQUE,                 droprate =   1 },
            { itemid = xi.item.FORTITUDE_TORQUE,                droprate =   1 },
            { itemid = xi.item.FAITH_TORQUE,                    droprate =   1 },
            { itemid = xi.item.TEMPERANCE_TORQUE,               droprate =   1 },
            { itemid = xi.item.LOVE_TORQUE,                     droprate =   1 },
            { itemid = xi.item.RIDILL,                          droprate =   1 },
            { itemid = xi.item.OCTAVE_CLUB,                     droprate =   1 },
            { itemid = xi.item.HAUTECLAIRE,                     droprate =   1 },
            { itemid = 13566,                                   droprate =   1 }, -- Defending Ring
            { itemid = 27456,                                   droprate =   1 }, -- Crier's Gaiters
            { itemid = 14468,                                   droprate =   2 }, -- Yinyang Robe
            { itemid =    0,                                    droprate = 750 }, -- nothing
        },
        -- Slot 4, Materials --
        {
            { itemid = xi.item.MOAT_CARP,                       droprate =   5 },
            { itemid = xi.item.IRON_INGOT,                      droprate =   7 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   7 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   7 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   7 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   7 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   7 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   7 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   7 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   7 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   7 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   7 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   7 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   7 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   7 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   7 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   7 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   7 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   7 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   7 },
            { itemid = xi.item.RAM_HORN,                        droprate =   7 },
            { itemid = xi.item.ELM_LOG,                         droprate =   7 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   7 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   7 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   7 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   7 },
            { itemid = xi.item.SACK_OF_SILICA,                  droprate =   7 },
            { itemid =  850,                                    droprate =   7 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   7 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   7 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   7 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   7 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   7 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   7 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   7 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   7 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   7 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   7 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   7 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   7 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   7 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   7 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   7 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   7 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   7 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   7 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   7 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   7 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   7 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   7 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   7 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   7 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   7 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   7 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   7 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   7 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   7 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   7 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   7 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   7 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   7 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   7 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   7 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   7 },
            { itemid = xi.item.IMP_HORN,                        droprate =   7 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   7 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   7 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   7 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   7 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   7 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   7 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   7 },
            { itemid = 1225,                                    droprate =   7 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   7 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   7 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   7 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   7 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   7 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   7 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   7 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   7 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   7 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   7 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   7 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   7 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   7 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   7 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   7 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   7 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   5 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   5 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   5 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   5 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   5 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   5 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   5 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   5 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   5 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   5 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   5 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   5 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   5 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   5 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   4 },
            { itemid = 2151,                                    droprate =   4 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   4 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   4 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   5 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   5 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   5 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   5 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   5 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   5 }, -- Water Anima
            { itemid = 1647,                                    droprate =   5 }, -- Light Anima
            { itemid = 1648,                                    droprate =   5 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   4 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   4 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   4 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   4 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   4 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   4 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   4 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   4 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   4 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   4 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   4 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   4 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   4 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   4 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   4 },
            { itemid =  734,                                    droprate =   4 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   4 }, -- Amphiptere Hide
            { itemid = 2164,                                    droprate =   4 }, -- Pephredo Hive Chip
            { itemid = 1279,                                    droprate =   4 }, -- Taffeta Cloth
            { itemid = 1280,                                    droprate =   4 }, -- Sarcenet Cloth
            { itemid = 1281,                                    droprate =   4 }, -- Cheviot Cloth
            { itemid = 1295,                                    droprate =   4 }, -- Twincoon
            { itemid = 1270,                                    droprate =   4 }, -- Arachne Web
            { itemid =  647,                                    droprate =   4 }, -- Molybdenum Ore
            { itemid = 1271,                                    droprate =   4 }, -- Pigeon's Blood Ruby
            { itemid = 1276,                                    droprate =   4 }, -- Tarasque Skin
            { itemid = 1296,                                    droprate =   4 }, -- Yowie Skin
            { itemid = 1277,                                    droprate =   4 }, -- Lindwurm Skin
            { itemid = 1765,                                    droprate =   4 }, -- Habu Skin
            { itemid = 2828,                                    droprate =   4 }, -- Herensugue Skin
            { itemid = 2837,                                    droprate =   4 }, -- Ratatoskr Pelt
            { itemid = 2839,                                    droprate =   4 }, -- Coquecigrue Skin
            { itemid = 2830,                                    droprate =   4 }, -- Bastet Fang
            { itemid = 2833,                                    droprate =   4 }, -- Thunder Coral
            { itemid = 1272,                                    droprate =   4 }, -- Arioch Fang
            { itemid = 1273,                                    droprate =   4 }, -- Namtar Bone
            { itemid = 2849,                                    droprate =   4 }, -- Likho Talon
            { itemid = 2846,                                    droprate =   4 }, -- Hefty Oak Lumber
            { itemid = 2855,                                    droprate =   4 }, -- Mahogany Heartwood
            { itemid = xi.item.CHUNK_OF_FIRE_ORE,               droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ICE_ORE,                droprate =   5 },
            { itemid = xi.item.CHUNK_OF_WIND_ORE,               droprate =   5 },
            { itemid = xi.item.CHUNK_OF_EARTH_ORE,              droprate =   5 },
            { itemid = xi.item.CHUNK_OF_LIGHTNING_ORE,          droprate =   5 },
            { itemid = xi.item.CHUNK_OF_WATER_ORE,              droprate =   5 },
            { itemid = xi.item.CHUNK_OF_LIGHT_ORE,              droprate =   5 },
            { itemid = xi.item.CHUNK_OF_DARK_ORE,               droprate =   5 },
            { itemid = xi.item.CLUMP_OF_IMPERIAL_TEA_LEAVES,    droprate =   5 },
            { itemid = xi.item.DRAGON_FRUIT,                    droprate =   2 },
            { itemid = xi.item.WALNUT,                          droprate =   2 },
            { itemid = xi.item.BOWL_OF_AMBROSIA,                droprate =   2 },
            { itemid = xi.item.BOTTLE_OF_AMRITA,                droprate =   2 },
            { itemid = xi.item.DRAGON_HEART,                    droprate =   2 },
            { itemid = xi.item.HANDFUL_OF_DRAGON_SCALES,        droprate =   2 },
            { itemid = xi.item.SLICE_OF_DRAGON_MEAT,            droprate =   2 },
            { itemid = xi.item.CHUNK_OF_HYDRA_MEAT,             droprate =   2 },
            { itemid = xi.item.SLICE_OF_CERBERUS_MEAT,          droprate =   2 },
            { itemid = xi.item.BEHEMOTH_HIDE,                   droprate =   2 },
            { itemid = xi.item.BEHEMOTH_HORN,                   droprate =   2 },
            { itemid = 2158,                                    droprate =   2 }, -- Hydra Fang
            { itemid = 2172,                                    droprate =   2 }, -- Hydra Scale
            { itemid = 2168,                                    droprate =   2 }, -- Cerberus Claw
            { itemid = 2169,                                    droprate =   2 }, -- Cerberus Hide
            { itemid = 2371,                                    droprate =   2 }, -- Khimaira Horn
            { itemid = 2372,                                    droprate =   2 }, -- Khimaira Mane
            { itemid = 2373,                                    droprate =   2 }, -- Khimaira Tail
            { itemid = 4273,                                    droprate =   2 }, -- Kitron
            { itemid = 1718,                                    droprate =   2 }, -- M-bugard Tusk
            { itemid = 1719,                                    droprate =   2 }, -- Harajnite Shell
        },
        -- Slot 8, Materials --
        {
            { itemid = xi.item.IRON_INGOT,                      droprate =   2 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   2 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   2 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   2 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   2 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   2 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   2 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   2 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   2 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   2 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   2 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   2 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   2 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   2 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   2 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   2 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   2 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   2 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   2 },
            { itemid = xi.item.RAM_HORN,                        droprate =   2 },
            { itemid = xi.item.ELM_LOG,                         droprate =   2 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   2 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   2 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   2 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   2 },
            { itemid = xi.item.SACK_OF_SILICA,                  droprate =   2 },
            { itemid =  850,                                    droprate =   3 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   3 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   3 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   3 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   3 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   3 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   3 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   3 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   3 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   3 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   3 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   3 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   3 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   3 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   3 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   3 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   3 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   3 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   3 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   3 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   3 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   3 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   3 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   3 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   3 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   3 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   3 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   3 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   3 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   3 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   3 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   3 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   3 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   3 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   3 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   3 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   3 },
            { itemid = xi.item.IMP_HORN,                        droprate =   3 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   3 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   3 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   3 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   3 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   3 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   3 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   3 },
            { itemid = 1225,                                    droprate =   3 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   3 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   3 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   3 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   3 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   3 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   3 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   3 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   3 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   3 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   3 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   3 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   3 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   3 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   3 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   3 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   3 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   3 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   3 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   3 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   3 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   3 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   3 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   3 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   3 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   3 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   3 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   3 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   3 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   3 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   3 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   3 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   3 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   3 },
            { itemid = 2151,                                    droprate =   3 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   3 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   3 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   3 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   3 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   3 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   3 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   3 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   3 }, -- Water Anima
            { itemid = 1647,                                    droprate =   3 }, -- Light Anima
            { itemid = 1648,                                    droprate =   3 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   3 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   3 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   3 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   3 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   3 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   3 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   3 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   3 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   3 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   3 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   3 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   3 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   3 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   3 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   3 },
            { itemid =  734,                                    droprate =   3 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   3 }, -- Amphiptere Hide
            { itemid = 2164,                                    droprate =   1 }, -- Pephredo Hive Chip
            { itemid = 1279,                                    droprate =   3 }, -- Taffeta Cloth
            { itemid = 1280,                                    droprate =   3 }, -- Sarcenet Cloth
            { itemid = 1281,                                    droprate =   3 }, -- Cheviot Cloth
            { itemid = 1295,                                    droprate =   3 }, -- Twincoon
            { itemid = 1270,                                    droprate =   3 }, -- Arachne Web
            { itemid =  647,                                    droprate =   3 }, -- Molybdenum Ore
            { itemid = 1271,                                    droprate =   2 }, -- Pigeon's Blood Ruby
            { itemid = 1276,                                    droprate =   2 }, -- Tarasque Skin
            { itemid = 1296,                                    droprate =   2 }, -- Yowie Skin
            { itemid = 1277,                                    droprate =   2 }, -- Lindwurm Skin
            { itemid = 1765,                                    droprate =   2 }, -- Habu Skin
            { itemid = 2828,                                    droprate =   2 }, -- Herensugue Skin
            { itemid = 2837,                                    droprate =   2 }, -- Ratatoskr Pelt
            { itemid = 2839,                                    droprate =   2 }, -- Coquecigrue Skin
            { itemid = 2830,                                    droprate =   2 }, -- Bastet Fang
            { itemid = 2833,                                    droprate =   2 }, -- Thunder Coral
            { itemid = 1272,                                    droprate =   2 }, -- Arioch Fang
            { itemid = 1273,                                    droprate =   2 }, -- Namtar Bone
            { itemid = 2849,                                    droprate =   2 }, -- Likho Talon
            { itemid = 2846,                                    droprate =   2 }, -- Hefty Oak Lumber
            { itemid = 2855,                                    droprate =   2 }, -- Mahogany Heartwood
            { itemid = xi.item.CHUNK_OF_FIRE_ORE,               droprate =   4 },
            { itemid = xi.item.CHUNK_OF_ICE_ORE,                droprate =   4 },
            { itemid = xi.item.CHUNK_OF_WIND_ORE,               droprate =   4 },
            { itemid = xi.item.CHUNK_OF_EARTH_ORE,              droprate =   4 },
            { itemid = xi.item.CHUNK_OF_LIGHTNING_ORE,          droprate =   4 },
            { itemid = xi.item.CHUNK_OF_WATER_ORE,              droprate =   4 },
            { itemid = xi.item.CHUNK_OF_LIGHT_ORE,              droprate =   4 },
            { itemid = xi.item.CHUNK_OF_DARK_ORE,               droprate =   4 },
            { itemid = xi.item.CLUMP_OF_IMPERIAL_TEA_LEAVES,    droprate =   4 },
            { itemid = xi.item.DRAGON_FRUIT,                    droprate =   2 },
            { itemid = xi.item.WALNUT,                          droprate =   2 },
            { itemid = xi.item.BOWL_OF_AMBROSIA,                droprate =   2 },
            { itemid = xi.item.BOTTLE_OF_AMRITA,                droprate =   2 },
            { itemid = xi.item.DRAGON_HEART,                    droprate =   2 },
            { itemid = xi.item.HANDFUL_OF_DRAGON_SCALES,        droprate =   2 },
            { itemid = xi.item.SLICE_OF_DRAGON_MEAT,            droprate =   2 },
            { itemid = xi.item.CHUNK_OF_HYDRA_MEAT,             droprate =   2 },
            { itemid = xi.item.SLICE_OF_CERBERUS_MEAT,          droprate =   2 },
            { itemid = xi.item.BEHEMOTH_HIDE,                   droprate =   2 },
            { itemid = xi.item.BEHEMOTH_HORN,                   droprate =   2 },
            { itemid = 2158,                                    droprate =   2 }, -- Hydra Fang
            { itemid = 2172,                                    droprate =   2 }, -- Hydra Scale
            { itemid = 2168,                                    droprate =   2 }, -- Cerberus Claw
            { itemid = 2169,                                    droprate =   2 }, -- Cerberus Hide
            { itemid = 2371,                                    droprate =   2 }, -- Khimaira Horn
            { itemid = 2372,                                    droprate =   2 }, -- Khimaira Mane
            { itemid = 2373,                                    droprate =   2 }, -- Khimaira Tail
            { itemid = 4273,                                    droprate =   2 }, -- Kitron
            { itemid = 1718,                                    droprate =   2 }, -- M-bugard Tusk
            { itemid = 1719,                                    droprate =   2 }, -- Harajnite Shell
            { itemid =    0,                                    droprate = 500 }, -- nothing
        },
        -- Slot 5, Misc/Medicine --
        {
            { itemid = xi.item.RERAISER,                        droprate = 100 },
            { itemid = xi.item.REMEDY,                          droprate =  80 },
            { itemid = xi.item.HI_RERAISER,                     droprate =  70 },
            { itemid = xi.item.FLASK_OF_ECHO_DROPS,             droprate =  50 },
            { itemid = xi.item.FLASK_OF_HOLY_WATER,             droprate =  50 },
            { itemid = xi.item.SUPER_RERAISER,                  droprate =  60 },
            { itemid = xi.item.ICARUS_WING,                     droprate =  60 },
            { itemid = xi.item.VILE_ELIXIR,                     droprate =  60 },
            { itemid = xi.item.VILE_ELIXIR_P1,                  droprate =  50 },
            { itemid = xi.item.FIRE_CLUSTER,                    droprate =  20 },
            { itemid = xi.item.ICE_CLUSTER,                     droprate =  20 },
            { itemid = xi.item.WIND_CLUSTER,                    droprate =  20 },
            { itemid = xi.item.EARTH_CLUSTER,                   droprate =  20 },
            { itemid = xi.item.LIGHTNING_CLUSTER,               droprate =  20 },
            { itemid = xi.item.WATER_CLUSTER,                   droprate =  20 },
            { itemid = xi.item.LIGHT_CLUSTER,                   droprate =  20 },
            { itemid = xi.item.DARK_CLUSTER,                    droprate =  20 },
            { itemid = 5356,                                    droprate =  60 }, -- Remedy Ointment
            { itemid = 4153,                                    droprate =  60 }, -- Antacid
            { itemid = 4512,                                    droprate =  50 }, -- Vampire Juice
            { itemid = 4149,                                    droprate =  30 }, -- Panacea
            { itemid = 5254,                                    droprate =  25 }, -- Hyper Potion
            { itemid = 5255,                                    droprate =  25 }, -- Hyper Ether
            { itemid = xi.item.MOAT_CARP,                       droprate =  10 },
        },
    },
    [90] =
    {   -- Slot 1, Currency --
        {
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate = 105 },
            { itemid = xi.item.LINEN_COIN_PURSE,                droprate = 105 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =  80 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =  80 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =  80 },
            { itemid = xi.item.IMPERIAL_GOLD_PIECE,             droprate =  20 },
            { itemid =  6541,                                   droprate =  90 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate =  90 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate =  90 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate =  90 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate =  90 }, -- Forgotten Pouch Feet
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate =  80 },
        },
        -- Slot 6, Currency --
        {
            { itemid = xi.item.AGED_BOX_BAYLD,                  droprate =  80 },
            { itemid = xi.item.ANCIENT_BEASTCOIN,               droprate =  90 },
            { itemid = xi.item.LINEN_COIN_PURSE,                droprate = 100 },
            { itemid = xi.item.ONE_HUNDRED_BYNE_BILL,           droprate =  40 },
            { itemid = xi.item.MONTIONT_SILVERPIECE,            droprate =  40 },
            { itemid = xi.item.LUNGO_NANGO_JADESHELL,           droprate =  40 },
            { itemid = xi.item.IMPERIAL_GOLD_PIECE,             droprate =  30 },
            { itemid =  6541,                                   droprate = 100 }, -- Forgotten Pouch Head
            { itemid =  6542,                                   droprate = 100 }, -- Forgotten Pouch Body
            { itemid =  6543,                                   droprate = 100 }, -- Forgotten Pouch Hands
            { itemid =  6544,                                   droprate = 100 }, -- Forgotten Pouch Legs
            { itemid =  6545,                                   droprate = 100 }, -- Forgotten Pouch Feet
            { itemid =  3283,                                   droprate =  10 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate =  10 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate =  10 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate =  10 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate =  10 }, -- Martial Tatter
            { itemid =  3279,                                   droprate =  10 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate =  10 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate =  10 }, -- Wyrmal Tatter            
        },
        -- Slot 10, Tatters --
        {
            { itemid =  3283,                                   droprate = 125 }, -- Aquarian Tatter
            { itemid =  3282,                                   droprate = 125 }, -- Dryadic Tatter
            { itemid =  3281,                                   droprate = 125 }, -- Earthen Tatter
            { itemid =  3286,                                   droprate = 125 }, -- Hadean Tatter
            { itemid =  3280,                                   droprate = 125 }, -- Martial Tatter
            { itemid =  3279,                                   droprate = 125 }, -- Neptunal Tatter
            { itemid =  3285,                                   droprate = 125 }, -- Phantasmal Tatter
            { itemid =  3284,                                   droprate = 125 }, -- Wyrmal Tatter
        },
        -- Slot 2, Pop Items --
        {
            { itemid = xi.item.CURTANA,                         droprate =  30 },
            { itemid = xi.item.CHUNK_OF_DIORITE,                droprate =  30 },
            { itemid = xi.item.FLASK_OF_ROMAEVE_SPRING_WATER,   droprate =  30 },
            { itemid = xi.item.GEM_OF_THE_EAST,                 droprate =  40 },
            { itemid = xi.item.SPRINGSTONE,                     droprate =  40 },
            { itemid = xi.item.GEM_OF_THE_SOUTH,                droprate =  40 },
            { itemid = xi.item.SUMMERSTONE,                     droprate =  40 },
            { itemid = xi.item.GEM_OF_THE_WEST,                 droprate =  40 },
            { itemid = xi.item.AUTUMNSTONE,                     droprate =  40 },
            { itemid = xi.item.GEM_OF_THE_NORTH,                droprate =  40 },
            { itemid = xi.item.WINTERSTONE,                     droprate =  40 },
            { itemid = xi.item.IVORY_CHIP,                      droprate =  30 },
            { itemid = xi.item.SCARLET_CHIP,                    droprate =  30 },
            { itemid = xi.item.EMERALD_CHIP,                    droprate =  30 },
            { itemid = xi.item.SILVER_CHIP,                     droprate =  25 },
            { itemid = xi.item.CERULEAN_CHIP,                   droprate =  25 },
            { itemid = 1986,                                    droprate =  25 }, -- Orchid Chip
            { itemid = xi.item.SMALT_CHIP,                      droprate =  25 },
            { itemid = xi.item.SMOKY_CHIP,                      droprate =  25 },
            { itemid = 1987,                                    droprate =  25 }, -- Charcoal Chip
            { itemid = 1988,                                    droprate =  25 }, -- Magenta Chip
            { itemid = 1404,                                    droprate =  20 }, -- Genbu Seal
            { itemid = 1405,                                    droprate =  20 }, -- Seiryu Seal
            { itemid = 1406,                                    droprate =  20 }, -- Byakko Seal
            { itemid = 1407,                                    droprate =  20 }, -- Suzaku Seal
            { itemid = xi.item.DEED_OF_PLACIDITY,               droprate =  30 },
            { itemid = xi.item.DEED_OF_SENSIBILITY,             droprate =  30 },
            { itemid =  1854,                                   droprate =  30 }, -- Deed of Moderation
            { itemid = xi.item.FIRST_VIRTUE,                    droprate =  20 },
            { itemid =  1853,                                   droprate =  20 }, -- Second Virtue
            { itemid = xi.item.THIRD_VIRTUE,                    droprate =  20 },
            { itemid =  1848,                                   droprate =  20 }, -- Fourth Virtue
            { itemid =  1847,                                   droprate =  20 }, -- Fifth Virtue
            { itemid =  1849,                                   droprate =  20 }, -- Sixth Virtue
            { itemid = xi.item.ANTLION_TRAP,                    droprate =   5 },
            { itemid = xi.item.HAUNTED_MULETA,                  droprate =   5 },
            { itemid = xi.item.SHRIMP_LANTERN,                  droprate =   5 },
            { itemid = xi.item.HAKUTAKU_EYE_CLUSTER,            droprate =  20 },
        },
        -- Slot 3, Equipment --
        {
            { itemid = xi.item.MELEE_CAPE,                      droprate =   1 },
            { itemid = xi.item.ABYSS_CAPE,                      droprate =   1 },
            { itemid = xi.item.ASSASSINS_CAPE,                  droprate =   1 },
            { itemid = xi.item.VALOR_CAPE,                      droprate =   1 },
            { itemid = xi.item.BARDS_CAPE,                      droprate =   1 },
            { itemid = xi.item.SUMMONERS_CAPE,                  droprate =   1 },
            { itemid = xi.item.WARRIORS_STONE,                  droprate =   1 },
            { itemid = xi.item.CLERICS_BELT,                    droprate =   1 },
            { itemid = xi.item.DUELISTS_BELT,                   droprate =   1 },
            { itemid = xi.item.SORCERERS_BELT,                  droprate =   1 },
            { itemid = xi.item.MONSTER_BELT,                    droprate =   1 },
            { itemid = xi.item.SCOUTS_BELT,                     droprate =   1 },
            { itemid = xi.item.KOGA_SARASHI,                    droprate =   1 },
            { itemid = xi.item.WYRM_BELT,                       droprate =   1 },
            { itemid = xi.item.SAOTOME_KOSHI_ATE,               droprate =   1 },
            { itemid = xi.item.COMMODORE_BELT,                  droprate =   1 },
            { itemid = xi.item.ARGUTE_BELT,                     droprate =   1 },
            { itemid = xi.item.MIRAGE_MANTLE,                   droprate =   1 },
            { itemid = xi.item.PANTIN_CAPE,                     droprate =   1 },
            { itemid = xi.item.ETOILE_CAPE,                     droprate =   1 },
            { itemid = xi.item.KOBO_OBI,                        droprate =   1 },  -- GEO Dynamis Accessory
            { itemid = xi.item.TANTALIC_CAPE,                   droprate =   1 },  -- RUN Dynamis Accessory
            { itemid = xi.item.HAMAYUMI,                        droprate =   5 },
            { itemid = xi.item.DIA_WAND,                        droprate =   5 },
            { itemid = xi.item.STONE_GORGET,                    droprate =   5 },
            { itemid = xi.item.PILGRIMS_WAND,                   droprate =   5 },
            { itemid = xi.item.GELONG_STAFF,                    droprate =   5 },
            { itemid = xi.item.WEBCUTTER,                       droprate =   5 },
            { itemid =  18412,                                  droprate =   5 }, -- Gassan
            { itemid =  17708,                                  droprate =   5 }, -- Auriga Xiphos
            { itemid =  18359,                                  droprate =   5 }, -- Boreas Cesti
            { itemid =  15220,                                  droprate =   5 }, -- Rain Hat
            { itemid =  15468,                                  droprate =   5 }, -- Resentment Cape
            { itemid =  15505,                                  droprate =   5 }, -- Dhalmel Whistle
            { itemid =  14667,                                  droprate =   5 }, -- Carect Ring
            { itemid =  xi.item.GOTHIC_SABATONS,                droprate =   5 },
            { itemid =  xi.item.GOTHIC_GAUNTLETS,               droprate =   5 },
            { itemid =  11529,                                  droprate =   5 }, -- Frugal Cape
            { itemid =  16187,                                  droprate =   5 }, -- Adoubeurs Pavise
            { itemid =  16899,                                  droprate =   5 }, -- Hototogisu
            { itemid =  16374,                                  droprate =   5 }, -- Layqa Seraweels
            { itemid =  17199,                                  droprate =   5 }, -- Loxley Bow
            { itemid =  16882,                                  droprate =   5 }, -- Calamar
            { itemid =  17504,                                  droprate =   5 }, -- Pagures
            { itemid =  16884,                                  droprate =   5 }, -- Narval
            { itemid =  17503,                                  droprate =   5 }, -- Exocets
            { itemid =  19238,                                  droprate =   5 }, -- Jasper Tathlum
            { itemid =  11404,                                  droprate =   5 }, -- Promptitude Solea
            { itemid =  15897,                                  droprate =   5 }, -- Grace Corset
            { itemid =  13803,                                  droprate =   5 }, -- Shaman's Cloak
            { itemid =  19237,                                  droprate =   5 }, -- Slick Dart
            { itemid =  15942,                                  droprate =   5 }, -- Summoning Belt
            { itemid =  xi.item.MUSHROOM_HELM,                  droprate =   5 },
            { itemid =  xi.item.LUNA_SUBLIGAR,                  droprate =   5 },
            { itemid =  16980,                                  droprate =   5 }, -- Sukesada
            { itemid =  13912,                                  droprate =   5 }, -- Shadow Mask
            { itemid =  16943,                                  droprate =   5 }, -- Ascalon
            { itemid =  14063,                                  droprate =   5 }, -- Protecting Bangles
            { itemid =  14064,                                  droprate =   5 }, -- Sand Gloves
            { itemid =  17651,                                  droprate =   5 }, -- Dainslaif
            { itemid =  17924,                                  droprate =   5 }, -- Tungi
            { itemid =  16734,                                  droprate =   5 }, -- Pendragon Axe
            { itemid =  15995,                                  droprate =   5 }, -- Carline Earring
            { itemid =  16127,                                  droprate =   5 }, -- Carline Ribbon
            { itemid =  16125,                                  droprate =   5 }, -- Breeder Mask
            { itemid =  15001,                                  droprate =   5 }, -- Breeder Mufflers
            { itemid =  15946,                                  droprate =   5 }, -- Tempest Belt
            { itemid =  11405,                                  droprate =   5 }, -- Kyoshu Kyahan
            { itemid =  11533,                                  droprate =   5 }, -- Lyricist's Gonnelle
            { itemid =  16298,                                  droprate =   5 }, -- Knack Pendant
            { itemid =  17454,                                  droprate =   5 }, -- Asklepios
            { itemid =  17455,                                  droprate =   5 }, -- Skirnir's Wand
            { itemid =  16912,                                  droprate =   5 }, -- Kitsutsuki
            { itemid =  17926,                                  droprate =   5 }, -- Acha D'Armas
            { itemid =  17982,                                  droprate =   5 }, -- Kard
            { itemid =  17983,                                  droprate =   5 }, -- Valiant Knife
            { itemid =  18042,                                  droprate =   5 }, -- Ascention
            { itemid =  17563,                                  droprate =   5 }, -- Power Staff
            { itemid =  17969,                                  droprate =   5 }, -- Fendoir
            { itemid =  18608,                                  droprate =   5 }, -- Atesh Pole
            { itemid =  16727,                                  droprate =   5 }, -- Eisentaenzer
            { itemid =  17971,                                  droprate =   5 }, -- Tartaglia
            { itemid =  19235,                                  droprate =   5 }, -- Veuglaire
            { itemid =  16375,                                  droprate =   5 }, -- Surge Subligar
            { itemid =  xi.item.ASTRAL_ASPIS,                   droprate =   5 },
            { itemid =  xi.item.GAE_BOLG,                       droprate =   5 },
            { itemid =  xi.item.LOHAR,                          droprate =   5 },
            { itemid =   19122,                                 droprate =   5 }, -- Courser's Pugio
            { itemid =   16081,                                 droprate =   5 }, -- Curate's Hat
            { itemid =   15882,                                 droprate =   5 }, -- Othinus' Bow
            { itemid =   17244,                                 droprate =   5 }, -- Storm Belt
            { itemid =   14806,                                 droprate =   5 }, -- Intruder Earring
            { itemid =   14466,                                 droprate =   5 }, -- Fomor Tunic
            { itemid =   18007,                                 droprate =   5 }, -- Chiroptera Dagger
            { itemid =   17510,                                 droprate =   5 }, -- Vampiric Claws
            { itemid =   14763,                                 droprate =   5 }, -- Boroka Earring
            { itemid =   13178,                                 droprate =   5 }, -- Auditory Torque
            { itemid =   15943,                                 droprate =   5 }, -- Virtuoso Belt
            { itemid =   14884,                                 droprate =   5 }, -- Mycophile Cuffs
            { itemid =   17794,                                 droprate =   5 }, -- Niokiyotsuna
            { itemid =   15219,                                 droprate =   5 }, -- Sinister Mask
            { itemid =   16368,                                 droprate =   5 }, -- Herder's Subligar
            { itemid =   14724,                                 droprate =   5 }, -- Moldavite Earring
            { itemid =   16279,                                 droprate =   5 }, -- Pile Chain
            { itemid =   15546,                                 droprate =   5 }, -- Fasting Ring
            { itemid =   16299,                                 droprate =   5 }, -- Lleu's Charm
            { itemid =   11496,                                 droprate =   5 }, -- Fenrir's Crown
            { itemid =   14168,                                 droprate =   5 }, -- Dune Boots
            { itemid =   17854,                                 droprate =   5 }, -- Cradle Horn
            { itemid =   19239,                                 droprate =   5 }, -- Astrolable
            { itemid =   16169,                                 droprate =   5 }, -- Caballero Shield
            { itemid =   17653,                                 droprate =   5 }, -- Hrotti
            { itemid =   18027,                                 droprate =   5 }, -- Palladium Dagger
            { itemid =   17564,                                 droprate =   5 }, -- Cocytus Pole
            { itemid =   16426,                                 droprate =   5 }, -- Avengers
            { itemid =   19121,                                 droprate =   5 }, -- Sleight Kukri
            { itemid =   15944,                                 droprate =   5 }, -- Selemnus Belt
            { itemid =   16297,                                 droprate =   5 }, -- Shepherd's Chain
            { itemid =  xi.item.KAMEWARI,                       droprate =   5 },
            { itemid =  xi.item.NADRS,                          droprate =   5 },
            { itemid =  xi.item.ALTDORFS_EARRING,               droprate =   5 },
            { itemid =  xi.item.WILHELMS_EARRING,               droprate =   5 },
            { itemid =  xi.item.HELENUSS_EARRING,               droprate =   5 },
            { itemid =  xi.item.CASSANDRAS_EARRING,             droprate =   5 },
            { itemid =  xi.item.MINSTRELS_DAGGER,               droprate =   5 },
            { itemid =  xi.item.SAND_CHARM,                     droprate =   5 },
            { itemid =   15692,                                 droprate =   5 }, -- Storm Crackows
            { itemid =   14669,                                 droprate =   5 }, -- Jaeger Ring
            { itemid =   15351,                                 droprate =   5 }, -- Bounding Boots
            { itemid =   18018,                                 droprate =   5 }, -- Sirocco Kukri
            { itemid =   13567,                                 droprate =   5 }, -- Bomb Queen Ring
            { itemid =   15547,                                 droprate =   5 }, -- Vilma's Ring
            { itemid =   26164,                                 droprate =   5 }, -- Caliber Ring
            { itemid =   15183,                                 droprate =   5 }, -- Dobson Bandana
            { itemid =   15184,                                 droprate =   5 }, -- Voyager Sallet
            { itemid =   14986,                                 droprate =   5 }, -- Ochimusha Kote
            { itemid =   15737,                                 droprate =   5 }, -- Sarutobi Kyahan
            { itemid =   15551,                                 droprate =   5 }, -- Shikaree Ring
            { itemid =  xi.item.EMPRESS_HAIRPIN,                droprate =   5 },
            { itemid =  xi.item.JOYEUSE,                        droprate =   5 },
            { itemid =  xi.item.DRYAD_STAFF,                    droprate =   5 },
            { itemid =  xi.item.VALIS_BOW,                      droprate =   5 },
            { itemid =  xi.item.RETALIATORS,                    droprate =   5 },
            { itemid =  xi.item.UNGUR_BOOMERANG,                droprate =   5 },
            { itemid =   15515,                                 droprate =   5 }, -- Peacock Amulet
            { itemid =  xi.item.TROTTER_BOOTS,                  droprate =   5 },
            { itemid =   19236,                                 droprate =   7 }, -- Hightail Bullet
            { itemid =   17192,                                 droprate =   7 }, -- Ifrit's Bow
            { itemid =   17711,                                 droprate =   7 }, -- Shiva's Shotel
            { itemid =   18021,                                 droprate =   7 }, -- Titan's Baselarde
            { itemid =   18063,                                 droprate =   7 }, -- Garuda's Sickle
            { itemid =   18109,                                 droprate =   7 }, -- Leviathan's Couse
            { itemid =   18404,                                 droprate =   7 }, -- Ramuh's Mace
            { itemid =   18581,                                 droprate =   7 }, -- Carbuncle's Pole
            { itemid =   14931,                                 droprate =   7 }, -- Carbuncle's Cuffs
            { itemid =   18422,                                 droprate =   7 }, -- Ryumon
            { itemid =   14960,                                 droprate =   7 }, -- Evoker's Gages
            { itemid =   19277,                                 droprate =   7 }, -- Tsugumi
            { itemid =   11408,                                 droprate =   7 }, -- Morana Pigaches
            { itemid =   11409,                                 droprate =   7 }, -- Aoide's Pumps
            { itemid =   16238,                                 droprate =   7 }, -- Taster's Cape
            { itemid =   11497,                                 droprate =   7 }, -- Spurrer Beret
            { itemid =   11406,                                 droprate =   7 }, -- Stimulus Sabots
            { itemid =   18767,                                 droprate =   6 }, -- Birdbanes
            { itemid =   15854,                                 droprate =   7 }, -- Sortie Ring
            { itemid =   15915,                                 droprate =   7 }, -- Sothic Rope
            { itemid =   11342,                                 droprate =   6 }, -- Restorer Cloak
            { itemid =   18770,                                 droprate =   7 }, -- Pygme Sainti
            { itemid =   17737,                                 droprate =   6 }, -- Corsair's Scimitar
            { itemid =   19124,                                 droprate =   7 }, -- Creve-coeur
            { itemid =   19279,                                 droprate =   7 }, -- Musanto
            { itemid =   17766,                                 droprate =   7 }, -- Lyft Scimitar
            { itemid =   17970,                                 droprate =   7 }, -- Lyft Tabar
            { itemid =   18508,                                 droprate =   7 }, -- Lyft Voulge
            { itemid =   18609,                                 droprate =   7 }, -- Lyft Pole
            { itemid =   18771,                                 droprate =   7 }, -- Lyft Sainti
            { itemid =   18872,                                 droprate =   7 }, -- Lyft Ferule
            { itemid =   18958,                                 droprate =   7 }, -- Lyft Scythe
            { itemid =   19125,                                 droprate =   7 }, -- Lyft Jambiya
            { itemid =   19161,                                 droprate =   7 }, -- Lyft Claymore
            { itemid =   19233,                                 droprate =   7 }, -- Lyft Crossbow
            { itemid =   19306,                                 droprate =   7 }, -- Lyft Lance
            { itemid =  xi.item.LAVAS_RING,                     droprate =   7 },
            { itemid =  xi.item.KUSHAS_RING,                    droprate =   7 },
            { itemid =  xi.item.NASATYAS_RING,                  droprate =   7 },
            { itemid =  xi.item.DASRAS_RING,                    droprate =   7 },
            { itemid =  xi.item.HOPE_STAFF,                     droprate =   7 },
            { itemid =  xi.item.JUSTICE_SWORD,                  droprate =   7 },
            { itemid =  xi.item.TEMPERANCE_AXE,                 droprate =   7 },
            { itemid =  xi.item.LOVE_HALBERD,                   droprate =   7 },
            { itemid =  xi.item.FORTITUDE_AXE,                  droprate =   7 },
            { itemid =  xi.item.FAITH_BAGHNAKHS,                droprate =   7 },
            { itemid =  xi.item.PRUDENCE_ROD,                   droprate =   7 },
            { itemid =  xi.item.BYAKKOS_AXE,                    droprate =   8 },
            { itemid =  xi.item.SUZAKUS_SCYTHE,                 droprate =   8 },
            { itemid =  xi.item.SEIRYUS_SWORD,                  droprate =   8 },
            { itemid =  xi.item.SANGUINE_SWORD,                 droprate =   8 },
        },
        -- Slot 7, Equipment --
        {
            { itemid =  5230,                                   droprate =   1 }, -- Love Chocolate
            { itemid = xi.item.AERN_DAGGER,                     droprate =   5 },
            { itemid = xi.item.AERN_SWORD,                      droprate =   5 },
            { itemid = xi.item.AERN_AXE,                        droprate =   5 },
            { itemid = xi.item.AERN_SPEAR,                      droprate =   5 },
            { itemid = xi.item.AERN_STAFF,                      droprate =   5 },
            { itemid = xi.item.CHICKEN_KNIFE_II,                droprate =   5 },
            { itemid = xi.item.GENBUS_KABUTO,                   droprate =   5 },
            { itemid = xi.item.GENBUS_SHIELD,                   droprate =   5 },
            { itemid = xi.item.SEIRYUS_KOTE,                    droprate =   5 },
            { itemid = xi.item.SUZAKUS_SUNE_ATE,                droprate =   5 },
            { itemid = xi.item.BYAKKOS_HAIDATE,                 droprate =   5 },
            { itemid = xi.item.ANIMATOR_P1,                     droprate =   5 },
            { itemid = 17567,                                   droprate =   4 }, -- Kirin's Pole
            { itemid = 12562,                                   droprate =   5 }, -- Kirin's Osode
            { itemid = 19123,                                   droprate =   5 }, -- Cinquedea
            { itemid = 15221,                                   droprate =   5 }, -- Patroclus's Helm
            { itemid = 15182,                                   droprate =   3 }, -- Zoolater Hat
            { itemid = 11343,                                   droprate =   5 }, -- Thrakon Breastplate
            { itemid = 13804,                                   droprate =   5 }, -- Minstrel's Coat
            { itemid = 13805,                                   droprate =   5 }, -- Assault Jerkin
            { itemid = 14467,                                   droprate =   5 }, -- Archer's Jupon
            { itemid = 16126,                                   droprate =   5 }, -- Bowman's Mask
            { itemid = 15744,                                   droprate =   5 }, -- Bowman's Ledelsens
            { itemid = 16034,                                   droprate =   5 }, -- Sarabande Earring
            { itemid = 12361,                                   droprate =   5 }, -- Sipar
            { itemid = 13914,                                   droprate =   5 }, -- Aegishjalmr
            { itemid = 14075,                                   droprate =   5 }, -- Andvaranauts
            { itemid = 13415,                                   droprate =   5 }, -- Pixie Earring
            { itemid = 16300,                                   droprate =   5 }, -- Wit Pendant
            { itemid = 16303,                                   droprate =   5 }, -- Laran's Pendant
            { itemid = 15057,                                   droprate =   5 }, -- Bricta's Cuffs
            { itemid = 14943,                                   droprate =   5 }, -- Barbarossa's Moufles
            { itemid = 16376,                                   droprate =   5 }, -- Bahram Cuisses
            { itemid = 16302,                                   droprate =   3 }, -- Bloodbead Gorget
            { itemid = 11411,                                   droprate =   3 }, -- Shrewd Pumps
            { itemid = 15223,                                   droprate =   3 }, -- Ace's Helm
            { itemid = 18002,                                   droprate =   3 }, -- Perseu's Harp
            { itemid = 14873,                                   droprate =   3 }, -- Bandomusha Kote
            { itemid = 19280,                                   droprate =   3 }, -- Narigitsune
            { itemid = xi.item.WYRM_BEARD,                      droprate =   3 },
            { itemid = xi.item.BEHEMOTH_TONGUE,                 droprate =   3 },
            { itemid = xi.item.ADAMANTOISE_EGG,                 droprate =   3 },
            { itemid = xi.item.SEVENEYES,                       droprate =   3 },
            { itemid = xi.item.ALGOL,                           droprate =   3 },
            { itemid = 13658,                                   droprate =   2 }, -- Shadow Mantle
            { itemid = 14646,                                   droprate =   2 }, -- Shadow Ring
            { itemid = 11589,                                   droprate =   2 }, -- Aesir Torque
            { itemid = 16057,                                   droprate =   2 }, -- Aesir Ear Pendant
            { itemid = 11546,                                   droprate =   2 }, -- Aesir Mantle
            { itemid = 11547,                                   droprate =   2 }, -- Colossus's Mantle
            { itemid = 11590,                                   droprate =   2 }, -- Colossus's Torque
            { itemid = 16058,                                   droprate =   2 }, -- Colossus's Earring
            { itemid = 18019,                                   droprate =   2 }, -- X's Knife
            { itemid = 18057,                                   droprate =   2 }, -- Y's Scythe
            { itemid = 18101,                                   droprate =   2 }, -- Z's Trident
            { itemid = 15899,                                   droprate =   2 }, -- Velocious Belt
            { itemid = 15617,                                   droprate =   2 }, -- Barbarossa's Zerehs
            { itemid = 17586,                                   droprate =   2 }, -- Mercurial Pole
            { itemid = xi.item.JUSTICE_TORQUE,                  droprate =   2 },
            { itemid = xi.item.HOPE_TORQUE,                     droprate =   2 },
            { itemid = xi.item.PRUDENCE_TORQUE,                 droprate =   2 },
            { itemid = xi.item.FORTITUDE_TORQUE,                droprate =   2 },
            { itemid = xi.item.FAITH_TORQUE,                    droprate =   2 },
            { itemid = xi.item.TEMPERANCE_TORQUE,               droprate =   2 },
            { itemid = xi.item.LOVE_TORQUE,                     droprate =   2 },
            { itemid = xi.item.RIDILL,                          droprate =   2 },
            { itemid = xi.item.OCTAVE_CLUB,                     droprate =   2 },
            { itemid = xi.item.HAUTECLAIRE,                     droprate =   2 },
            { itemid = 13566,                                   droprate =   2 }, -- Defending Ring
            { itemid = 27456,                                   droprate =   2 }, -- Crier's Gaiters
            { itemid = 14468,                                   droprate =   2 }, -- Yinyang Robe
            { itemid =    0,                                    droprate = 750 }, -- nothing
        },
        -- Slot 4, Materials --
        {
            { itemid = xi.item.MOAT_CARP,                       droprate =   5 },
            { itemid = xi.item.IRON_INGOT,                      droprate =   7 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   7 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   7 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   7 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   7 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   7 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   7 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   7 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   7 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   7 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   7 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   7 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   7 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   7 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   7 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   7 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   7 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   7 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   7 },
            { itemid = xi.item.RAM_HORN,                        droprate =   7 },
            { itemid = xi.item.ELM_LOG,                         droprate =   7 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   7 },
            { itemid = xi.item.ROSEWOOD_LOG,                    droprate =   7 },
            { itemid = xi.item.EBONY_LOG,                       droprate =   7 },
            { itemid = xi.item.LUMP_OF_BEESWAX,                 droprate =   7 },
            { itemid = xi.item.SACK_OF_SILICA,                  droprate =   7 },
            { itemid =  850,                                    droprate =   7 }, -- Sheep Leather
            { itemid =  820,                                    droprate =   7 }, -- Wool Thread
            { itemid = 1700,                                    droprate =   7 }, -- Blood Thread
            { itemid = 2287,                                    droprate =   7 }, -- Karakul Thread
            { itemid = 2539,                                    droprate =   7 }, -- Dhalmel Hair
            { itemid = 1651,                                    droprate =   7 }, -- Moblin Thread
            { itemid = 2123,                                    droprate =   7 }, -- Catoblepas Hide
            { itemid =  920,                                    droprate =   7 }, -- Catoblepas Hide
            { itemid = 2549,                                    droprate =   7 }, -- Djinn Ash
            { itemid = xi.item.CHUNK_OF_IRON_ORE,               droprate =   7 },
            { itemid = xi.item.CHUNK_OF_ALUMINUM_ORE,           droprate =   7 },
            { itemid = xi.item.CHUNK_OF_SILVER_ORE,             droprate =   7 },
            { itemid = xi.item.CHUNK_OF_MYTHRIL_ORE,            droprate =   7 },
            { itemid = xi.item.SPOOL_OF_GOLD_THREAD,            droprate =   7 },
            { itemid = xi.item.SPOOL_OF_PLATINUM_SILK_THREAD,   droprate =   7 },
            { itemid = xi.item.SPOOL_OF_RAINBOW_THREAD,         droprate =   7 },
            { itemid = xi.item.SQUARE_OF_VELVET_CLOTH,          droprate =   7 },
            { itemid = xi.item.SQUARE_OF_RAXA,                  droprate =   7 },
            { itemid = xi.item.COEURL_HIDE,                     droprate =   7 },
            { itemid = xi.item.MANTICORE_HIDE,                  droprate =   7 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   7 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   7 },
            { itemid = xi.item.EFT_SKIN,                        droprate =   7 },
            { itemid = xi.item.FIENDISH_SKIN,                   droprate =   7 },
            { itemid = xi.item.DEMON_HORN,                      droprate =   7 },
            { itemid = xi.item.SCORPION_CLAW,                   droprate =   7 },
            { itemid = xi.item.SCORPION_SHELL,                  droprate =   7 },
            { itemid = xi.item.GIANT_FEMUR,                     droprate =   7 },
            { itemid = xi.item.BEETLE_SHELL,                    droprate =   7 },
            { itemid = xi.item.BEETLE_JAW,                      droprate =   7 },
            { itemid = xi.item.CHUNK_OF_ADAMAN_ORE,             droprate =   7 },
            { itemid = xi.item.CHUNK_OF_PLATINUM_ORE,           droprate =   7 },
            { itemid = xi.item.SPIDER_WEB,                      droprate =   7 },
            { itemid = xi.item.WAMOURA_COCOON,                  droprate =   7 },
            { itemid = xi.item.WYVERN_SKIN,                     droprate =   7 },
            { itemid = xi.item.BUFFALO_HORN,                    droprate =   7 },
            { itemid = xi.item.ANTLION_JAW,                     droprate =   7 },
            { itemid = xi.item.IMP_HORN,                        droprate =   7 },
            { itemid = xi.item.WIVRE_HORN,                      droprate =   7 },
            { itemid = xi.item.CHESTNUT_LOG,                    droprate =   7 },
            { itemid = xi.item.WILLOW_LOG,                      droprate =   7 },
            { itemid = xi.item.PETRIFIED_LOG,                   droprate =   7 },
            { itemid = xi.item.SPRIG_OF_MISTLETOE,              droprate =   7 },
            { itemid = xi.item.DOLL_SHARD,                      droprate =   7 },
            { itemid = xi.item.JAR_OF_FIRESAND,                 droprate =   7 },
            { itemid = 1225,                                    droprate =   7 }, -- Gold Nugget
            { itemid = 1227,                                    droprate =   7 }, -- Platinum Nugget
            { itemid = 1228,                                    droprate =   7 }, -- Darksteel Nugget
            { itemid = 1229,                                    droprate =   7 }, -- Adaman Nugget
            { itemid = 2011,                                    droprate =   7 }, -- Wolf Fur
            { itemid =  857,                                    droprate =   7 }, -- Dhalmel Hide
            { itemid =  876,                                    droprate =   7 }, -- Manta Skin
            { itemid = 1628,                                    droprate =   7 }, -- Buffalo Hide
            { itemid = 2512,                                    droprate =   7 }, -- Lynx Hide
            { itemid = 2518,                                    droprate =   7 }, -- Smilodon Hide
            { itemid = 1640,                                    droprate =   7 }, -- Bugard Skin
            { itemid = 2755,                                    droprate =   7 }, -- Ruszor Hide
            { itemid = 1622,                                    droprate =   7 }, -- Bugard Tusk
            { itemid = 2427,                                    droprate =   7 }, -- Wivre Maul
            { itemid = 2747,                                    droprate =   7 }, -- Gargouille Horn
            { itemid = 2754,                                    droprate =   7 }, -- Ruszor Fang
            { itemid =  927,                                    droprate =   7 }, -- Coeurl Whisker
            { itemid = xi.item.ADAMAN_INGOT,                    droprate =   5 },
            { itemid = xi.item.PLATINUM_INGOT,                  droprate =   5 },
            { itemid = xi.item.PEISTE_SKIN,                     droprate =   5 },
            { itemid = xi.item.SHEET_OF_VELLUM,                 droprate =   5 },
            { itemid = xi.item.WYVERN_WING,                     droprate =   5 },
            { itemid = xi.item.HANDFUL_OF_WYVERN_SCALES,        droprate =   5 },
            { itemid = xi.item.CORAL_FRAGMENT,                  droprate =   5 },
            { itemid = xi.item.WYVERN_SKULL,                    droprate =   5 },
            { itemid = xi.item.DEMON_SKULL,                     droprate =   5 },
            { itemid = xi.item.MARID_TUSK,                      droprate =   5 },
            { itemid = xi.item.GNOLE_CLAW,                      droprate =   5 },
            { itemid = xi.item.BLOODWOOD_LOG,                   droprate =   5 },
            { itemid = xi.item.TEAK_LOG,                        droprate =   5 },
            { itemid = xi.item.AHRIMAN_WING,                    droprate =   5 },
            { itemid = xi.item.PINCH_OF_POISON_DUST,            droprate =   5 },
            { itemid = xi.item.PINCH_OF_PARALYSIS_DUST,         droprate =   5 },
            { itemid = xi.item.VIAL_OF_DRAGON_BLOOD,            droprate =   4 },
            { itemid = 2151,                                    droprate =   4 }, -- Marid Hide
            { itemid = 2428,                                    droprate =   4 }, -- Wivre Hide
            { itemid =  732,                                    droprate =   4 }, -- Kapor Log
            { itemid = 1641,                                    droprate =   5 }, -- Fire Anima
            { itemid = 1642,                                    droprate =   5 }, -- Ice Anima
            { itemid = 1643,                                    droprate =   5 }, -- Wind Anima
            { itemid = 1644,                                    droprate =   5 }, -- Earth Anima
            { itemid = 1645,                                    droprate =   5 }, -- Lightning Anima
            { itemid = 1646,                                    droprate =   5 }, -- Water Anima
            { itemid = 1647,                                    droprate =   5 }, -- Light Anima
            { itemid = 1648,                                    droprate =   5 }, -- Dark Anima
            { itemid = xi.item.CHUNK_OF_WOOTZ_ORE,              droprate =   4 }, 
            { itemid = xi.item.CHUNK_OF_KHROMA_ORE,             droprate =   4 },
            { itemid = xi.item.CHUNK_OF_ORICHALCUM_ORE,         droprate =   4 },
            { itemid = xi.item.CHUNK_OF_PHRYGIAN_ORE,           droprate =   4 },
            { itemid = xi.item.DAMASCUS_INGOT,                  droprate =   4 },
            { itemid = xi.item.ORICHALCUM_INGOT,                droprate =   4 },
            { itemid = xi.item.SQUARE_OF_DAMASCENE_CLOTH,       droprate =   4 },
            { itemid = xi.item.GRIFFON_HIDE,                    droprate =   4 },
            { itemid = xi.item.ADAMANTOISE_SHELL,               droprate =   4 },
            { itemid = xi.item.GIANT_FROZEN_HEAD,               droprate =   4 },
            { itemid = xi.item.COLOSSAL_SKULL,                  droprate =   4 },
            { itemid = xi.item.BEECH_LOG,                       droprate =   4 },
            { itemid = xi.item.LANCEWOOD_LOG,                   droprate =   4 },
            { itemid = xi.item.JACARANDA_LOG,                   droprate =   4 },
            { itemid = xi.item.PHILOSOPHERS_STONE,              droprate =   4 },
            { itemid =  734,                                    droprate =   4 }, -- Thokcha Ore
            { itemid = 2750,                                    droprate =   4 }, -- Amphiptere Hide
            { itemid = 2164,                                    droprate =   4 }, -- Pephredo Hive Chip
            { itemid = 1279,                                    droprate =   4 }, -- Taffeta Cloth
            { itemid = 1280,                                    droprate =   4 }, -- Sarcenet Cloth
            { itemid = 1281,                                    droprate =   4 }, -- Cheviot Cloth
            { itemid = 1295,                                    droprate =   4 }, -- Twincoon
            { itemid = 1270,                                    droprate =   4 }, -- Arachne Web
            { itemid =  647,                                    droprate =   4 }, -- Molybdenum Ore
            { itemid = 1271,                                    droprate =   4 }, -- Pigeon's Blood Ruby
            { itemid = 1276,                                    droprate =   4 }, -- Tarasque Skin
            { itemid = 1296,                                    droprate =   4 }, -- Yowie Skin
            { itemid = 1277,                                    droprate =   4 }, -- Lindwurm Skin
            { itemid = 1765,                                    droprate =   4 }, -- Habu Skin
            { itemid = 2828,                                    droprate =   4 }, -- Herensugue Skin
            { itemid = 2837,                                    droprate =   4 }, -- Ratatoskr Pelt
            { itemid = 2839,                                    droprate =   4 }, -- Coquecigrue Skin
            { itemid = 2830,                                    droprate =   4 }, -- Bastet Fang
            { itemid = 2833,                                    droprate =   4 }, -- Thunder Coral
            { itemid = 1272,                                    droprate =   4 }, -- Arioch Fang
            { itemid = 1273,                                    droprate =   4 }, -- Namtar Bone
            { itemid = 2849,                                    droprate =   4 }, -- Likho Talon
            { itemid = 2846,                                    droprate =   4 }, -- Hefty Oak Lumber
            { itemid = 2855,                                    droprate =   4 }, -- Mahogany Heartwood
            { itemid = xi.item.CHUNK_OF_FIRE_ORE,               droprate =   5 },
            { itemid = xi.item.CHUNK_OF_ICE_ORE,                droprate =   5 },
            { itemid = xi.item.CHUNK_OF_WIND_ORE,               droprate =   5 },
            { itemid = xi.item.CHUNK_OF_EARTH_ORE,              droprate =   5 },
            { itemid = xi.item.CHUNK_OF_LIGHTNING_ORE,          droprate =   5 },
            { itemid = xi.item.CHUNK_OF_WATER_ORE,              droprate =   5 },
            { itemid = xi.item.CHUNK_OF_LIGHT_ORE,              droprate =   5 },
            { itemid = xi.item.CHUNK_OF_DARK_ORE,               droprate =   5 },
            { itemid = xi.item.CLUMP_OF_IMPERIAL_TEA_LEAVES,    droprate =   5 },
            { itemid = xi.item.DRAGON_FRUIT,                    droprate =   2 },
            { itemid = xi.item.WALNUT,                          droprate =   2 },
            { itemid = xi.item.BOWL_OF_AMBROSIA,                droprate =   2 },
            { itemid = xi.item.BOTTLE_OF_AMRITA,                droprate =   2 },
            { itemid = xi.item.DRAGON_HEART,                    droprate =   2 },
            { itemid = xi.item.HANDFUL_OF_DRAGON_SCALES,        droprate =   2 },
            { itemid = xi.item.SLICE_OF_DRAGON_MEAT,            droprate =   2 },
            { itemid = xi.item.CHUNK_OF_HYDRA_MEAT,             droprate =   2 },
            { itemid = xi.item.SLICE_OF_CERBERUS_MEAT,          droprate =   2 },
            { itemid = xi.item.BEHEMOTH_HIDE,                   droprate =   2 },
            { itemid = xi.item.BEHEMOTH_HORN,                   droprate =   2 },
            { itemid = 2158,                                    droprate =   2 }, -- Hydra Fang
            { itemid = 2172,                                    droprate =   2 }, -- Hydra Scale
            { itemid = 2168,                                    droprate =   2 }, -- Cerberus Claw
            { itemid = 2169,                                    droprate =   2 }, -- Cerberus Hide
            { itemid = 2371,                                    droprate =   2 }, -- Khimaira Horn
            { itemid = 2372,                                    droprate =   2 }, -- Khimaira Mane
            { itemid = 2373,                                    droprate =   2 }, -- Khimaira Tail
            { itemid = 4273,                                    droprate =   2 }, -- Kitron
            { itemid = 1718,                                    droprate =   2 }, -- M-bugard Tusk
            { itemid = 1719,                                    droprate =   2 }, -- Harajnite Shell
        },
        -- Slot 8, Materials --
        {
            { itemid = xi.item.MOAT_CARP,                       droprate =   5 },
            { itemid = xi.item.IRON_INGOT,                      droprate =   7 },
            { itemid = xi.item.STEEL_INGOT,                     droprate =   7 },
            { itemid = xi.item.CHUNK_OF_DARKSTEEL_ORE,          droprate =   7 },
            { itemid = xi.item.DARKSTEEL_INGOT,                 droprate =   7 },
            { itemid = xi.item.BRASS_INGOT,                     droprate =   7 },
            { itemid = xi.item.SILVER_INGOT,                    droprate =   7 },
            { itemid = xi.item.MYTHRIL_INGOT,                   droprate =   7 },
            { itemid = xi.item.CHUNK_OF_GOLD_ORE,               droprate =   7 },
            { itemid = xi.item.GOLD_INGOT,                      droprate =   7 },
            { itemid = xi.item.SPOOL_OF_SILK_THREAD,            droprate =   7 },
            { itemid = xi.item.SPOOL_OF_SILVER_THREAD,          droprate =   7 },
            { itemid = xi.item.WATER_SPIDERS_WEB,               droprate =   7 },
            { itemid = xi.item.SPOOL_OF_RED_GRASS_THREAD,       droprate =   7 },
            { itemid = xi.item.GIANT_BIRD_PLUME,                droprate =   7 },
            { itemid = xi.item.GIANT_BIRD_FEATHER,              droprate =   7 },
            { itemid = xi.item.RAM_SKIN,                        droprate =   7 },
            { itemid = xi.item.TIGER_HIDE,                      droprate =   7 },
            { itemid = xi.item.RAPTOR_SKIN,                     droprate =   7 },
            { itemid = xi.item.CRAB_SHELL,                      droprate =   7 },
            { itemid = xi.item.RAM_HORN,                        droprate =   7 },
            { itemid = xi.item.ELM_LOG,                         droprate =   7 },
            { itemid = xi.item.MAHOGANY_LOG,                    droprate =   7