-----------------------------------
-- Prospecting Skill
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
-----------------------------------
local m = Module:new("skill_prospecting")
local npcName  = "Shinyrox"

local prospect =
{
    {
        skill  = 5,
        recipe = { xi.item.CHUNK_OF_COPPER_ORE, 12 },
        result =
        {
            { cexi.rate.UNCOMMON,    xi.item.BORNITE,    "a chunk of bornite"    }, -- 10%
            { cexi.rate.RARE,        xi.item.AZURITE,    "a chunk of azurite"    }, --  5%
        },
    },

    {
        skill  = 10,
        recipe = { xi.item.CHUNK_OF_TIN_ORE, 12 },
        result =
        {
            { cexi.rate.COMMON,      xi.item.STANNITE,   "a chunk of stannite"   }, -- 15%
            { cexi.rate.RARE,        xi.item.CYLINDRITE, "a chunk of cylindrite" }, --  5%
        },
    },

    {
        skill  = 15,
        recipe = { xi.item.CHUNK_OF_ZINC_ORE, 12 },
        result =
        {
            { cexi.rate.COMMON,      xi.item.SPHALERITE, "a chunk of sphalerite" }, -- 15%
            { cexi.rate.RARE,        xi.item.WURTZITE,   "a chunk of wurtzite"   }, --  5%
        },
    },

    {
        skill  = 20,
        recipe = { xi.item.CHUNK_OF_IRON_ORE, 12 },
        result =
        {
            { cexi.rate.VERY_COMMON, xi.item.HEMATITE,   "a chunk of hematite"   }, -- 24%
            { cexi.rate.RARE,        xi.item.MAGNETITE,  "a chunk of magnetite"  }, --  5%
        },
    },

    {
        skill  = 25,
        recipe = { xi.item.CHUNK_OF_DARKSTEEL_ORE, 12 },
        result =
        {
            { cexi.rate.VERY_COMMON, xi.item.SIDERITE,   "a chunk of siderite"   }, -- 24%
            { cexi.rate.RARE,        xi.item.GOETHITE,   "a chunk of goethite"   }, --  5%
        },
    },

    {
        skill  = 30,
        recipe = { xi.item.CHUNK_OF_SILVER_ORE, 12 },
        result =
        {
            { cexi.rate.COMMON,      xi.item.BROMYRITE,  "a chunk of bromyrite"  }, -- 15%
            { cexi.rate.RARE,        xi.item.ARGENTITE,  "a chunk of argentite"  }, --  5%
        },
    },

    {
        skill  = 35,
        recipe = { xi.item.CHUNK_OF_GOLD_ORE, 12 },
        result =
        {
            { cexi.rate.VERY_COMMON, xi.item.PETZITE,    "a chunk of petzite"    }, -- 15%
            { cexi.rate.RARE,        xi.item.SYLVANITE,  "a chunk of sylvanite"  }, --  5%
        },
    },

    {
        skill  = 40,
        recipe = { xi.item.CHUNK_OF_PLATINUM_ORE, 12 },
        result =
        {
            { cexi.rate.VERY_COMMON, xi.item.SPERRYLITE, "a chunk of sperrylite" }, -- 24%
            { cexi.rate.RARE,        xi.item.MALANITE,   "a chunk of malanite"   }, --  5%
        },
    },
}

local function onTrade(player, npc, trade)
    for _, itemTable in pairs(prospect) do
        if npcUtil.tradeHasExactly(trade, { itemTable.recipe }) then
            local result = cexi.util.pickItem(itemTable.result)

            if npcUtil.giveItem(player, result[2]) then
                cexi.skill.skillUp(player, cexi.skill.prospecting, itemTable.skill)
                player:tradeComplete()
            end
        end
    end
end

local function onTrigger(player, npc)
    local result = cexi.skill.rankUpReward(player, npc, cexi.skill.prospecting, function(playerArg, npcArg)
        npcArg:facePlayer(playerArg, true)
        playerArg:PrintToPlayer(string.format("%s : Well, well, well, how time flies. Pleasure doing business.", npcName), xi.msg.channel.NS_SAY)
        npcArg:independentAnimation(npc, 251, 4)
    end)

    if not result then
        cexi.util.dialog(
            player,
            {
                "What's up? Didn't expect to see a goblin a place like this?",
                " Listen buddy, there is no limit to how far I'll go for shiny rocks.",

                "Tell you what, bring me some ores and I'll show you some real shinies.",
                " After I've taken my cut of course.",
            },
            npcName,
            { npc = npc }
        )
    end
end

cexi.util.liveReload(m, {
    ["Provenance"] =
    {
        {
            objtype   = xi.objType.NPC,
            name      = npcName,
            look      = 700,
            x         = -624.890,
            y         = -19.475,
            z         = -515.296,
            rotation  = 98,
            widescan  = 1,
            onTrigger = onTrigger,
            onTrade   = onTrade,
        },
    },
})

return m
