-----------------------------------
-- Lapidary Skill
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
-----------------------------------
local m = Module:new("skill_lapidary")

local pattern =
{
    {
        "Amateur",
        {
            {
                skill  = 5,
                name   = "Fine Azurite",
                result = xi.item.FINE_AZURITE,
                recipe = xi.item.AZURITE,
            },

            {
                skill  = 8,
                name   = "Fine Cylindrite",
                result = xi.item.FINE_CYLINDRITE,
                recipe = xi.item.CYLINDRITE,
            },
        },
    },
    {
        "Recruit",
        {
            {
                skill  = 12,
                name   = "Fine Wurtzite",
                result = xi.item.FINE_WURTZITE,
                recipe = xi.item.WURTZITE,
            },

            {
                skill  = 17,
                name   = "Fine Magnetite",
                result = xi.item.FINE_MAGNETITE,
                recipe = xi.item.MAGNETITE,
            },
            {
                skill = 19,
                name  = "Unknown",
            },
        },
    },
    {
        "Initiate",
        {
            {
                skill  = 23,
                name   = "Unknown",
            },
            {
                skill  = 29,
                name   = "Unknown",
            },
        },
    },
    {
        "Novice",
        {
            {
                skill  = 31,
                name   = "Unknown",
            },
            {
                skill  = 34,
                name   = "Unknown",
            },
            {
                skill  = 36,
                name   = "Unknown",
            },
        },
    },
    {
        "Apprentice",
        {
            {
                skill  = 40,
                name   = "Unknown",
            },

            {
                skill  = 44,
                name   = "Fine Goethite",
                result = xi.item.FINE_GOETHITE,
                recipe = xi.item.GOETHITE,
            },

            {
                skill  = 48,
                name   = "Fine Argentite",
                result = xi.item.FINE_ARGENTITE,
                recipe = xi.item.ARGENTITE,
            },
        },
    },
    {
        "Journeyman",
        {
            {
                skill  = 52,
                name   = "Fine Sylvanite",
                result = xi.item.FINE_SYLVANITE,
                recipe = xi.item.SYLVANITE,
            },

            {
                skill  = 56,
                name   = "Fine Malanite",
                result = xi.item.FINE_MALANITE,
                recipe = xi.item.MALANITE,
            },

            {
                skill  = 59,
                name   = "Unknown",
            },
        },
    },
    {
        "Craftsman",
        {
            {
                skill  = 61,
                name   = "Fine Hibonite",
                result = xi.item.FINE_HIBONITE,
                recipe = xi.item.HIBONITE,
            },

            {
                skill  = 65,
                name   = "Unknown",
            },

            {
                skill  = 67,
                name   = "Fine Taenite",
                result = xi.item.FINE_TAENITE,
                recipe = xi.item.TAENITE,
            },
        },
    },
    {
        "Artisan",
        {
            {
                skill  = 70,
                name   = "Fine Kamacite",
                result = xi.item.FINE_KAMACITE,
                recipe = xi.item.KAMACITE,
            },

            {
                skill  = 73,
                name   = "Fine Ruby",
                result = xi.item.FINE_RUBY,
                recipe = xi.item.ROUGH_RUBY,
            },

            {
                skill  = 77,
                name   = "Fine Jadeite",
                result = xi.item.FINE_JADEITE,
                recipe = xi.item.ROUGH_JADEITE,
            },

            {
                skill  = 79,
                name   = "Fine Sapphire",
                result = xi.item.FINE_SAPPHIRE,
                recipe = xi.item.ROUGH_SAPPHIRE,
            },
        },
    },
    {
        "Adept",
        {
            {
                skill  = 82,
                name   = "Ruby Pigaches",
                result = xi.item.RUBY_PIGACHES,
                recipe =
                {
                    { xi.item.SQUARE_OF_RAINBOW_CLOTH, 2 },
                    { xi.item.FINE_RUBY,              2 },
                },
            },

            {
                skill  = 83,
                name   = "Sapphire Leggings",
                result = xi.item.SAPPHIRE_LEGGINGS,
                recipe =
                {
                    { xi.item.DARKSTEEL_SHEET, 2 },
                    { xi.item.FINE_SAPPHIRE,  2 },
                },
            },

            {
                skill  = 84,
                name   = "Jadeite Jambeaux",
                result = xi.item.JADEITE_JAMBEAUX,
                recipe =
                {
                    { xi.item.SMILODON_LEATHER, 2 },
                    { xi.item.FINE_JADEITE,    2 },
                },
            },

            {
                skill  = 86,
                name   = "Sapphire Gauntlets",
                result = xi.item.SAPPHIRE_GAUNTLETS,
                recipe =
                {
                    { xi.item.DARKSTEEL_SHEET, 2 },
                    { xi.item.FINE_SAPPHIRE,  2 },
                },
            },

            {
                skill  = 88,
                name   = "Jadeite Gloves",
                result = xi.item.JADEITE_GLOVES,
                recipe =
                {
                    { xi.item.SMILODON_LEATHER, 2 },
                    { xi.item.FINE_JADEITE,    2 },
                },
            },

            {
                skill  = 89,
                name   = "Ruby Cuffs",
                result = xi.item.RUBY_CUFFS,
                recipe =
                {
                    { xi.item.SQUARE_OF_RAINBOW_CLOTH, 2 },
                    { xi.item.FINE_RUBY,              2 },
                },
            },
        },
    },
    {
        "Veteran",
        {
            {
                skill  = 92,
                name   = "Fine Ruby",
                result = xi.item.FINE_RUBY,
                recipe = xi.item.ROUGH_RUBY,
            },

            {
                skill  = 94,
                name   = "Fine Jadeite",
                result = xi.item.FINE_JADEITE,
                recipe = xi.item.ROUGH_JADEITE,
            },

            {
                skill  = 97,
                name   = "Fine Sapphire",
                result = xi.item.FINE_SAPPHIRE,
                recipe = xi.item.ROUGH_SAPPHIRE,
            },
        },
    },
    {
        "Expert",
        {
            {
                skill  = 101,
                name   = "Unknown",
            },

            {
                skill  = 104,
                name   = "Unknown",
            },

            {
                skill  = 108,
                name   = "Unknown",
            },

            {
                skill  = 110,
                name   = "Unknown",
            },
        },
    },
}

local forge =
{
    ["ifrits_ire"] = { xi.item.IFRITS_IRE, xi.mod.ATT, 30, 1800 }, -- 1 hour
}

for itemName, itemInfo in pairs(forge) do
    local itemPath = string.format("xi.items.%s", itemName)
    xi.module.ensureTable(itemPath)

    m:addOverride(itemPath .. ".onItemCheck", function(target)
        local effect = target:getStatusEffect(xi.effect.ENCHANTMENT)

        if effect ~= nil and effect:getSubType() == itemInfo[1] then
            target:delStatusEffect(xi.effect.ENCHANTMENT)
        end

        return 0
    end)

    m:addOverride(itemPath .. ".onItemUse", function(target)
        target:addStatusEffect(xi.effect.ENCHANTMENT, 0, 0, itemInfo[4], itemInfo[1])
    end)

    m:addOverride(itemPath .. ".onEffectGain", function(target, effect)
        target:addMod(itemInfo[2], itemInfo[3])
    end)

    m:addOverride(itemPath .. ".onEffectLose", function(target, effect)
        target:delMod(itemInfo[2], itemInfo[3])
    end)
end

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function synthPrompt(player, npc, item)
    local craftableQty = 1

    if type(item.recipe) == "table" then
        player:fmt("Creating a {} will require:", item.name)

        for _, ingredient in pairs(item.recipe) do
            local storedQty = player:getCharVar(string.format("[EB]%u", ingredient[1]))
            player:fmt("{} x{} (Stored: {})", cexi.itemName[ingredient[1]], ingredient[2], storedQty)
        end
    else
        local storedQty = player:getCharVar(string.format("[EB]%u", item.recipe))
        player:fmt("Creating a %s will require one %s. (Stored: %u)", cexi.itemName[item.result], cexi.itemName[item.recipe], storedQty)
    end

    if craftableQty < 1 then
        return
    end

    -- TODO: Check for quantities
    delaySendMenu(player, {
        title   = "Create how many?",
        options =
        {
            {
                "None",
                function()
                end,
            },
            {
                "x1",
                function()
                    npc:injectActionPacket(npc:getID(), 6, 248, 0, 0, 0, 0, 0)

                    npc:timer(3000, function()
                        if npcUtil.giveItem(player, item.result) then
                            for _, ingredient in pairs(item.recipe) do
                                local itemVar   = string.format("[EB]%u", ingredient[1])
                                local storedQty = player:getCharVar(itemVar)

                                player:setCharVar(itemVar, storedQty - ingredient[2])
                                cexi.skill.skillUp(player, csk.skill.LAPIDARY, item.skill)
                            end
                        end
                    end)
                end,
            }
        },
    })
end

local function synthList(player, npc)
    cexi.util.skillMenu(player, npc, pattern, synthPrompt, "Select pattern:")
end

cexi.util.liveReload(m, {
    ["Provenance"] =
    {
        {
            objtype  = xi.objType.NPC,
            name     = "Lapis",
            look     = cexi.util.look({
                race = xi.race.HUME_F,
                face = 1,
                body = 441, -- Delegate's Garb
                hand = 441, -- Delegate's Cuffs
                legs = 230, -- Dinner Hose
                feet = 230, -- Dinner Hose
            }),
            x        = -626.374,
            y        = -19.479,
            z        = -531.023,
            rotation = 141,
            widescan = 1,

            onTrigger = function(player, npc)
                if not xi.settings.main.ENABLE_AOP then
                    player:fmt("Nothing happens.")
                    return
                end

                npc:facePlayer(player, true)
                synthList(player, npc)

                --[[
                !exec target:injectActionPacket(target:getID(), 6, 248, 0, 0, 0, 0, 0)
                npc:injectActionPacket(npc:getID(), 6, 248, 0, 0, 0, 0, 0)
                player:printToPlayer("Nothing happens.", xi.msg.channel.NS_SAY)
                ]]
            end,
        },
    },
})

return m
