-----------------------------------
-- Garbagio - Exchanges items for tatters and materials
-----------------------------------
-- !pos -4.875 0.000 7.535 246
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("skill_garbagio")

local rate =
{
    VERY_COMMON = { 2400, 2200, 2000, 1500, 1500, },
    COMMON      = { 1500, 1300, 1200, 1000, 1000, },
    UNCOMMON    = { 1000, 1200, 1500, 1650, 1800, },
    RARE        = {  500,  600,  700,  750,  800, },
    VERY_RARE   = {  100,  150,  200,  225,  250, },
    SUPER_RARE  = {   50,   75,  100,  120,  140, },
    ULTRA_RARE  = {   10,   20,   30,   35,   40, },
}

local JSE =
{
    HEAD  = 20,
    BODY  = 40,
    HANDS = 10,
    LEGS  = 30,
    FEET  = 10,
}

local results =
{
    {
        name  = "Neptunal Tatters",
        range = { 1394, 1403 },
        req   = 0,
        loot  =
        {
            { rate.VERY_COMMON, { 3279,  2,  4 } },
            { rate.COMMON,      { 3279,  4,  6 } },
            { rate.UNCOMMON,    { 3279,  6,  8 } },
            { rate.RARE,        { 3279,  8, 10 } },
            { rate.VERY_RARE,   { 3279, 10, 12 } },
        },
    },
    {
        name  = "Martial Tatters",
        range = { 1374, 1383 },
        req   = 0,
        loot  =
        {
            { rate.VERY_COMMON, { 3280,  2,  4 } },
            { rate.COMMON,      { 3280,  4,  6 } },
            { rate.UNCOMMON,    { 3280,  6,  8 } },
            { rate.RARE,        { 3280,  8, 10 } },
            { rate.VERY_RARE,   { 3280, 10, 12 } },
        },
    },
    {
        name  = "Earthen Tatters",
        range = { 1354, 1363 },
        req   = 0,
        loot  =
        {
            { rate.VERY_COMMON, { 3281,  2,  4 } },
            { rate.COMMON,      { 3281,  4,  6 } },
            { rate.UNCOMMON,    { 3281,  6,  8 } },
            { rate.RARE,        { 3281,  8, 10 } },
            { rate.VERY_RARE,   { 3281, 10, 12 } },
        },
    },
    {
        name  = "Dryadic Tatters",
        range = { 1344, 1353 },
        req   = 0,
        loot  =
        {
            { rate.VERY_COMMON, { 3282,  2,  4 } },
            { rate.COMMON,      { 3282,  4,  6 } },
            { rate.UNCOMMON,    { 3282,  6,  8 } },
            { rate.RARE,        { 3282,  8, 10 } },
            { rate.VERY_RARE,   { 3282, 10, 12 } },
        },
    },
    {
        name  = "Aquarian Tatters",
        range = { 1364, 1373 },
        req   = 0,
        loot  =
        {
            { rate.VERY_COMMON, { 3283,  2,  4 } },
            { rate.COMMON,      { 3283,  4,  6 } },
            { rate.UNCOMMON,    { 3283,  6,  8 } },
            { rate.RARE,        { 3283,  8, 10 } },
            { rate.VERY_RARE,   { 3283, 10, 12 } },
        },
    },
    {
        name  = "Wyrmal Tatters",
        range = { 1384, 1393 },
        req   = 0,
        loot  =
        {
            { rate.VERY_COMMON, { 3284,  2,  4 } },
            { rate.COMMON,      { 3284,  4,  6 } },
            { rate.UNCOMMON,    { 3284,  6,  8 } },
            { rate.RARE,        { 3284,  8, 10 } },
            { rate.VERY_RARE,   { 3284, 10, 12 } },
        },
    },
    {
        name  = "Phant. Tatters",
        range = { 2439, 2448 },
        req   = 0,
        loot  =
        {
            { rate.VERY_COMMON, { 3285,  2,  4 } },
            { rate.COMMON,      { 3285,  4,  6 } },
            { rate.UNCOMMON,    { 3285,  6,  8 } },
            { rate.RARE,        { 3285,  8, 10 } },
            { rate.VERY_RARE,   { 3285, 10, 12 } },
        },
    },
    {
        name  = "Hadean Tatters",
        range = { 2449, 2458 },
        req   = 0,
        loot  =
        {
            { rate.VERY_COMMON, { 3286,  2,  4 } },
            { rate.COMMON,      { 3286,  4,  6 } },
            { rate.UNCOMMON,    { 3286,  6,  8 } },
            { rate.RARE,        { 3286,  8, 10 } },
            { rate.VERY_RARE,   { 3286, 10, 12 } },
        },
    },
    {
        name  = "Sha'ir Turban",
        item  = 15153,
        req   = JSE.HEAD,
        loot  =
        {
            { rate.VERY_COMMON, 1619 }, -- Hippogryph Fthr. (24%)
            { rate.VERY_COMMON,  828 }, -- Velvet Cloth     (24%)
            { rate.VERY_COMMON,  828 }, -- Velvet Cloth     (24%)
            { rate.VERY_COMMON,  823 }, -- Gold Thread      (15%)
            { rate.RARE,        1271 }, -- Pigeon's Blood   ( 5%)
        },
    },
    {
        name  = "Sha'ir Manteel",
        item  = 14414,
        req   = JSE.BODY,
        loot  =
        {
            { rate.VERY_COMMON,  828 }, -- Velvet Cloth     (24%)
            { rate.COMMON,       823 }, -- Gold Thread      (15%)
            { rate.COMMON,       752 }, -- Gold Sheet       (15%)
            { rate.UNCOMMON,     855 }, -- Tiger Leather    (10%)
            { rate.UNCOMMON,     828 }, -- Velvet Cloth     (10%)
            { rate.UNCOMMON,     786 }, -- Ruby             (10%)
            { rate.UNCOMMON,     794 }, -- Sapphire         (10%)
            { rate.RARE,        1714 }, -- Cashmere Cloth   ( 5%)
        },
    },
    {
        name  = "Sha'ir Gages",
        item  = 14846,
        req   = JSE.HANDS,
        loot  =
        {
            { rate.VERY_COMMON,  828 }, -- Velvet Cloth     (24%)
            { rate.COMMON,       745 }, -- Gold Ingot       (15%)
            { rate.COMMON,       823 }, -- Gold Thread      (15%)
            { rate.COMMON,      1680 }, -- H.Q. Bugard Skin (15%)
            { rate.UNCOMMON,     790 }, -- Garnet           (10%)
            { rate.UNCOMMON,     855 }, -- Tiger Leather    (10%)
        },
    },
    {
        name  = "Sha'ir Seraweels",
        item  = 14315,
        req   = JSE.LEGS,
        loot  =
        {
            { rate.VERY_COMMON,  828 }, -- Velvet Cloth     (24%)
            { rate.VERY_COMMON,  828 }, -- Velvet Cloth     (24%)
            { rate.COMMON,       823 }, -- Gold Thread      (15%)
            { rate.UNCOMMON,     855 }, -- Tiger Leather    (10%)
            { rate.RARE,        1279 }, -- Taffeta Cloth    ( 5%)
        },
    },
    {
        name  = "Sha'ir Crackows",
        item  = 15303,
        req   = JSE.FEET,
        loot  =
        {
            { rate.VERY_COMMON,  828 }, -- Velvet Cloth     (24%)
            { rate.COMMON,       823 }, -- Gold Thread      (15%)
            { rate.UNCOMMON,    1629 }, -- Buffalo Leather  (10%)
            { rate.UNCOMMON,     855 }, -- Tiger Leather    (10%)
            { rate.RARE,         747 }, -- Ocl. Ingot       ( 5%)
        },
    },
    {
        name  = "Black Sallet",
        item  = 13887,
        req   = JSE.HEAD,
        loot  =
        {
            { rate.VERY_COMMON,  850 }, -- square_of_sheep_leather (24%)
            { rate.VERY_COMMON,  648 }, -- copper_ingot            (24%)
            { rate.COMMON,       664 }, -- darksteel_sheet         (15%)
            { rate.UNCOMMON,     747 }, -- orichalcum_ingot        (10%)
            { rate.RARE,        1705 }, -- kunwu_iron_sheet        ( 5%)
        },
    },
    {
        name  = "Plastron",
        item  = 14382,
        req   = JSE.BODY,
        loot  =
        {
            { rate.VERY_COMMON,  855 }, -- Tiger Leather       (24%)
            { rate.VERY_COMMON,  664 }, -- darksteel_sheet     (24%)
            { rate.COMMON,       654 }, -- Darksteel Ingot     (15%)
            { rate.COMMON,       682 }, -- darksteel_chain     (15%)
            { rate.UNCOMMON,     747 }, -- orichalcum_ingot    (10%)
            { rate.RARE,        1704 }, -- chunk_of_kunwu_iron ( 5%)
            { rate.RARE,        1705 }, -- kunwu_iron_sheet    ( 5%)
        },
    },
    {
        name  = "Black Gadlings",
        item  = 14010,
        req   = JSE.HANDS,
        loot  =
        {
            { rate.VERY_COMMON,   855 }, -- Tiger Leather    (24%)
            { rate.VERY_COMMON,   654 }, -- Darksteel Ingot  (24%)
            { rate.COMMON,        664 }, -- darksteel_sheet  (15%)
            { rate.UNCOMMON,    12702 }, -- tiger_gloves     (10%)
            { rate.UNCOMMON,    12699 }, -- Cuir Gloves      (10%)
            { rate.RARE,         1705 }, -- kunwu_iron_sheet ( 5%)
        },
    },
    {
        name  = "Black Cuisses",
        item  = 15400,
        req   = JSE.LEGS,
        loot  =
        {
            { rate.VERY_COMMON,  654 }, -- Darksteel Ingot  (24%)
            { rate.VERY_COMMON,  855 }, -- Tiger Leather    (24%)
            { rate.COMMON,       855 }, -- Tiger Leather    (15%)
            { rate.UNCOMMON,     664 }, -- darksteel_sheet  (10%)
            { rate.RARE,        1705 }, -- kunwu_iron_sheet ( 5%)
        },
    },
    {
        name  = "Black Sollerets",
        item  = 15339,
        req   = JSE.FEET,
        loot  =
        {
            { rate.VERY_COMMON,   855 }, -- Tiger Leather    (24%)
            { rate.VERY_COMMON,   654 }, -- Darksteel Ingot  (24%)
            { rate.COMMON,        664 }, -- darksteel_sheet  (15%)
            { rate.UNCOMMON,    12955 }, -- Cuir Highboots   (10%)
            { rate.UNCOMMON,    12958 }, -- tiger_ledelsens  (10%)
            { rate.RARE,         1705 }, -- kunwu_iron_sheet ( 5%)
        },
    },
    {
        name  = "Blessed Bliaut",
        item  = 14436,
        req   = JSE.BODY,
        loot  =
        {
            { rate.VERY_COMMON,  822 }, -- spool_of_silver_thread  (24%)
            { rate.VERY_COMMON,  828 }, -- square_of_velvet_cloth  (24%)
            { rate.COMMON,       823 }, -- Gold Thread             (15%)
            { rate.COMMON,       830 }, -- square_of_rainbow_cloth (15%)
            { rate.UNCOMMON,    1769 }, -- square_of_galateia      (10%)
            { rate.RARE,         828 }, -- square_of_velvet_cloth  ( 5%)
            { rate.RARE,         823 }, -- Gold Thread             ( 5%)
        },
    },
    {
        name  = "Blessed Mitts",
        item  = 14875,
        req   = JSE.HANDS,
        loot  =
        {
            { rate.VERY_COMMON,  823 }, -- spool_of_gold_thread    (24%)
            { rate.VERY_COMMON,  828 }, -- Velvet Cloth            (24%)
            { rate.COMMON,       823 }, -- spool_of_gold_thread    (15%)
            { rate.RARE,         834 }, -- ball_of_saruta_cotton   (10%)
            { rate.RARE,        1769 }, -- square_of_galateia      ( 5%)
        },
    },
    {
        name  = "Blessed Trousers",
        item  = 15391,
        req   = JSE.LEGS,
        loot  =
        {
            { rate.VERY_COMMON,  823 }, -- spool_of_gold_thread    (24%)
            { rate.VERY_COMMON,  828 }, -- square_of_velvet_cloth  (24%)
            { rate.UNCOMMON,     830 }, -- square_of_rainbow_cloth (10%)
            { rate.RARE,         823 }, -- spool_of_gold_thread    ( 5%)
            { rate.RARE,        1769 }, -- square_of_galateia      ( 5%)
        },
    },
    {
        name  = "Blessed Pumps",
        item  = 15329,
        req   = JSE.FEET,
        loot  =
        {
            { rate.VERY_COMMON,  855 }, -- Tiger Leather            (24%)
            { rate.VERY_COMMON,  828 }, -- square_of_velvet_cloth   (24%)
            { rate.COMMON,       823 }, -- spool_of_gold_thread     (15%)
            { rate.UNCOMMON,    1163 }, -- lock_of_manticore_hair   (10%)
            { rate.RARE,        1767 }, -- square_of_eltoro_leather ( 5%)
        },
    },
    {
        name  = "Dragon Mask",
        item  = 12436,
        req   = JSE.HEAD,
        loot  =
        {
            { rate.VERY_COMMON, 850 }, -- square_of_sheep_leather   (24%)
            { rate.COMMON,      850 }, -- square_of_sheep_leather   (15%)
            { rate.UNCOMMON,    866 }, -- handful_of_wyvern_scales  (10%)
            { rate.UNCOMMON,    866 }, -- handful_of_wyvern_scales  (10%)
        },
    },
    {
        name  = "Dragon Mail",
        item  = 12564,
        req   = JSE.BODY,
        loot  =
        {
            { rate.VERY_COMMON,   822         }, -- spool_of_silver_thread   (24%)
            { rate.VERY_COMMON,   664         }, -- darksteel_sheet          (24%)
            { rate.COMMON,        682         }, -- darksteel_chain          (15%)
            { rate.COMMON,      { 866, 1, 3 } }, -- handful_of_wyvern_scales (15%)
            { rate.RARE,          867         }, -- handful_of_dragon_scales ( 5%)
            { rate.VERY_RARE,   12568         }, -- leather_vest             ( 1%)
        },
    },
    {
        name  = "Dragon Finger Gauntlets",
        item  = 12692,
        req   = JSE.HANDS,
        loot  =
        {
            { rate.VERY_COMMON,   822         }, -- spool_of_silver_thread   (24%)
            { rate.VERY_COMMON,   866         }, -- handful_of_wyvern_scales (24%)
            { rate.COMMON,        866         }, -- handful_of_wyvern_scales (15%)
            { rate.RARE,        { 822, 1, 2 } }, -- Silver Thread            ( 5%)
            { rate.VERY_RARE,   12696         }, -- leather_gloves           ( 1%)
        },
    },
    {
        name  = "Dragon Cuisses",
        item  = 12820,
        req   = JSE.LEGS,
        loot  =
        {
            { rate.VERY_COMMON,   822         }, -- spool_of_silver_thread   (24%)
            { rate.VERY_COMMON,   866         }, -- handful_of_wyvern_scales (24%)
            { rate.COMMON,        822         }, -- Silver Thread            (15%)
            { rate.RARE,        { 866, 1, 2 } }, -- Wyvern Scales            ( 5%)
            { rate.VERY_RARE,   12824         }, -- leather_trousers         ( 1%)
        },
    },
    {
        name  = "Dragon Greaves",
        item  = 12948,
        req   = JSE.FEET,
        loot  =
        {
            { rate.VERY_COMMON,   822         }, -- spool_of_silver_thread   (24%)
            { rate.VERY_COMMON,   866         }, -- handful_of_wyvern_scales (24%)
            { rate.COMMON,        866         }, -- handful_of_wyvern_scales (15%)
            { rate.RARE,        { 822, 1, 2 } }, -- Silver Thread            ( 5%)
            { rate.VERY_RARE,   12952         }, -- leather_highboots        ( 1%)
        },
    },
    {
        name  = "Dragon Cap",
        item  = 13936,
        req   = JSE.HEAD,
        loot  =
        {
            { rate.VERY_COMMON,   855 }, -- Tiger Leather   (24%)
            { rate.COMMON,        664 }, -- darksteel_sheet (15%)
            { rate.UNCOMMON,    12452 }, -- darksteel_cap   (10%)
            { rate.UNCOMMON,      855 }, -- Tiger Leather   (10%)
            { rate.RARE,         1771 }, -- dragon_bone     ( 5%)
        },
    },
    {
        name  = "Dragon Harness",
        item  = 14389,
        req   = JSE.BODY,
        loot  =
        {
            { rate.VERY_COMMON, 1629 }, -- square_of_buffalo_leather (24%)
            { rate.VERY_COMMON, 1629 }, -- square_of_buffalo_leather (24%)
            { rate.RARE,        1771 }, -- dragon_bone               ( 5%)
            { rate.RARE,        1816 }, -- wyrm_horn                 ( 5%)
        },
    },
    {
        name  = "Dragon Mittens",
        item  = 14823,
        req   = JSE.HANDS,
        loot  =
        {
            { rate.VERY_COMMON, 1629 }, -- square_of_buffalo_leather (24%)
            { rate.VERY_COMMON, 1629 }, -- square_of_buffalo_leather (24%)
            { rate.COMMON,       866 }, -- handful_of_wyvern_scales  (15%)
            { rate.RARE,        1771 }, -- dragon_bone               ( 5%)
        },
    },
    {
        name  = "Dragon Subligar",
        item  = 14305,
        req   = JSE.LEGS,
        loot  =
        {
            { rate.VERY_COMMON, 1629 }, -- square_of_buffalo_leather (24%)
            { rate.VERY_COMMON, 1629 }, -- square_of_buffalo_leather (24%)
            { rate.UNCOMMON,    1280 }, -- square_of_sarcenet_cloth  (10%)
            { rate.RARE,        1771 }, -- dragon_bone               ( 5%)
        },
    },
    {
        name  = "Dragon Leggings",
        item  = 14186,
        req   = JSE.FEET,
        loot  =
        {
            { rate.VERY_COMMON, 1629 }, -- square_of_buffalo_leather (24%)
            { rate.VERY_COMMON, 1629 }, -- square_of_buffalo_leather (24%)
            { rate.COMMON,       866 }, -- handful_of_wyvern_scales  (15%)
            { rate.RARE,        1771 }, -- dragon_bone               ( 5%)
        },
    },
    {
        name  = "Hachiman Jinpachi",
        item  = 15188,
        req   = JSE.HEAD,
        loot  =
        {
            { rate.VERY_COMMON,  666 }, -- steel_sheet            (24%)
            { rate.VERY_COMMON,  829 }, -- square_of_silk_cloth   (24%)
            { rate.COMMON,      1415 }, -- pot_of_urushi          (15%)
            { rate.UNCOMMON,     683 }, -- adaman_chain           (10%)
            { rate.RARE,        1764 }, -- square_of_kejusu_satin ( 5%)
        },
    },
    {
        name  = "Hachiman Domaru",
        item  = 14437,
        req   = JSE.BODY,
        loot  =
        {
            { rate.VERY_COMMON,  855 }, -- square_of_black_tiger_leather (24%)
            { rate.VERY_COMMON,  823 }, -- spool_of_gold_thread          (24%)
            { rate.COMMON,      1773 }, -- handful_of_darksteel_scales   (15%)
            { rate.UNCOMMON,     665 }, -- adaman_sheet                  (10%)
            { rate.UNCOMMON,     682 }, -- darksteel_chain               (10%)
            { rate.RARE,        1763 }, -- pot_of_viridian_urushi        ( 5%)
        },
    },
    {
        name  = "Hachiman Kote",
        item  = 14876,
        req   = JSE.HANDS,
        loot  =
        {
            { rate.VERY_COMMON,  855 }, -- square_of_black_tiger_leather (24%)
            { rate.COMMON,       664 }, -- darksteel_sheet               (15%)
            { rate.COMMON,       745 }, -- gold_ingot                    (15%)
            { rate.UNCOMMON,     682 }, -- darksteel_chain               (10%)
            { rate.RARE,        1763 }, -- pot_of_viridian_urushi        ( 5%)
        },
    },
    {
        name  = "Hachiman Hakama",
        item  = 15392,
        req   = JSE.LEGS,
        loot  =
        {
            { rate.VERY_COMMON,  823 }, -- spool_of_gold_thread          (24%)
            { rate.VERY_COMMON,  828 }, -- square_of_velvet_cloth        (24%)
            { rate.COMMON,       682 }, -- darksteel_chain               (15%)
            { rate.UNCOMMON,    1699 }, -- square_of_scarlet_linen_cloth (10%)
            { rate.RARE,        1764 }, -- square_of_kejusu_satin        ( 5%)
        },
    },
    {
        name  = "Hachiman Sune-Ate",
        item  = 15330,
        req   = JSE.FEET,
        loot  =
        {
            { rate.VERY_COMMON, 828 }, -- square_of_velvet_cloth        (24%)
            { rate.COMMON,      855 }, -- square_of_black_tiger_leather (15%)
            { rate.COMMON,      821 }, -- spool_of_rainbow_thread       (15%)
            { rate.COMMON,      745 }, -- gold_ingot                    (15%)
            { rate.UNCOMMON,    655 }, -- adaman_ingot                  (10%)
            { rate.UNCOMMON,    664 }, -- darksteel_sheet               (10%)
            { rate.VERY_RARE,   914 }, -- vial_of_mercury               ( 1%)
        },
    },
    {
        name  = "Igqira Tiara",
        item  = 15159,
        req   = JSE.HEAD,
        loot  =
        {
            { rate.VERY_COMMON,  887 }, -- coral_fragment           (24%)
            { rate.COMMON,      1163 }, -- lock_of_manticore_hair   (15%)
            { rate.UNCOMMON,     506 }, -- square_of_coeurl_leather (10%)
            { rate.UNCOMMON,     790 }, -- garnet                   (10%)
        },
    },
    {
        name  = "Igqira Weskit",
        item  = 14420,
        req   = JSE.BODY,
        loot  =
        {
            { rate.COMMON,    848 }, -- square_of_dhalmel_leather (15%)
            { rate.COMMON,   1622 }, -- bugard_tusk               (15%)
            { rate.UNCOMMON,  506 }, -- square_of_coeurl_leather  (10%)
            { rate.UNCOMMON,  795 }, -- lapis_lazuli              (10%)
            { rate.UNCOMMON, 1163 }, -- lock_of_manticore_hair    (10%)
            { rate.UNCOMMON, 1626 }, -- bottle_of_avatar_blood    (10%)
            { rate.UNCOMMON, 1680 }, -- high-quality_bugard_skin  (10%)
            { rate.RARE,      903 }, -- dragon_talon              ( 5%)
        },
    },
    {
        name  = "Igqira Manillas",
        item  = 14852,
        req   = JSE.HANDS,
        loot  =
        {
            { rate.VERY_COMMON, 1622 }, -- bugard_tusk            (24%)
            { rate.COMMON,      1618 }, -- uragnite_shell         (15%)
            { rate.UNCOMMON,    1163 }, -- lock_of_manticore_hair (10%)
            { rate.UNCOMMON,     790 }, -- garnet                 (10%)
            { rate.UNCOMMON,    1626 }, -- bottle_of_avatar_blood (10%)
        },
    },
    {
        name  = "Igqira Lappas",
        item  = 14321,
        req   = JSE.LEGS,
        loot  =
        {
            { rate.COMMON,    506 }, -- square_of_coeurl_leather    (15%)
            { rate.COMMON,    927 }, -- coeurl_whisker              (15%)
            { rate.COMMON,   1618 }, -- uragnite_shell              (15%)
            { rate.COMMON,   1680 }, -- high-quality_bugard_skin    (15%)
            { rate.UNCOMMON, 1117 }, -- square_of_manticore_leather (10%)
            { rate.RARE,     1718 }, -- megalobugard_tusk           ( 5%)
        },
    },
    {
        name  = "Igqira Huaraches",
        item  = 15309,
        req   = JSE.FEET,
        loot  =
        {
            { rate.VERY_COMMON, 1622 }, -- bugard_tusk                (24%)
            { rate.COMMON,       506 }, -- square_of_coeurl_leather   (15%)
            { rate.COMMON,       927 }, -- coeurl_whisker             (15%)
            { rate.RARE,        1680 }, -- high-quality_bugard_skin   ( 5%)
            { rate.RARE,        1719 }, -- harajnite_shell            ( 5%)
        },
    },
    {
        name  = "Khimaira Bonnet",
        item  = 16104,
        req   = JSE.HEAD,
        loot  =
        {
            { rate.VERY_COMMON, 1623           }, -- eft_skin                    (24%)
            { rate.COMMON,      1619           }, -- hippogryph_feather          (15%)
            { rate.COMMON,      1629           }, -- square_of_buffalo_leather   (15%)
            { rate.COMMON,      1117           }, -- square_of_manticore_leather (15%)
            { rate.RARE,        { 2372, 1, 2 } }, -- khimaira_mane               ( 5%)
        },
    },
    {
        name  = "Khimaira Jacket",
        item  = 14566,
        req   = JSE.BODY,
        loot  =
        {
            { rate.VERY_COMMON, 1629           }, -- square_of_buffalo_leather   (24%)
            { rate.VERY_COMMON, 1117           }, -- square_of_manticore_leather (24%)
            { rate.COMMON,      1619           }, -- hippogryph_feather          (15%)
            { rate.UNCOMMON,    1623           }, -- eft_skin                    (10%)
            { rate.UNCOMMON,    1615           }, -- buffalo_horn                (10%)
            { rate.RARE,        { 2372, 1, 2 } }, -- khimaira_mane               ( 5%)
        },
    },
    {
        name  = "Khimaira Wristbands",
        item  = 14981,
        req   = JSE.HANDS,
        loot  =
        {
            { rate.VERY_COMMON, 1629           }, -- square_of_buffalo_leather   (24%)
            { rate.VERY_COMMON, 1117           }, -- square_of_manticore_leather (24%)
            { rate.UNCOMMON,    1117           }, -- square_of_manticore_leather (10%)
            { rate.RARE,        { 2372, 1, 2 } }, -- khimaira_mane               ( 5%)
        },
    },
    {
        name  = "Khimaira Kecks",
        item  = 15645,
        req   = JSE.LEGS,
        loot  =
        {
            { rate.VERY_COMMON,  855           }, -- square_of_black_tiger_leather (24%)
            { rate.VERY_COMMON, 1629           }, -- square_of_buffalo_leather     (24%)
            { rate.COMMON,      1117           }, -- square_of_manticore_leather   (15%)
            { rate.RARE,        1629           }, -- square_of_buffalo_leather     ( 5%)
            { rate.RARE,        { 2372, 1, 4 } }, -- khimaira_mane                 ( 5%)
        },
    },
    {
        name  = "Khimaira Gamashes",
        item  = 15731,
        req   = JSE.FEET,
        loot  =
        {
            { rate.VERY_COMMON, 1619           }, -- hippogryph_feather          (24%)
            { rate.VERY_COMMON, 1629           }, -- square_of_buffalo_leather   (24%)
            { rate.COMMON,      1117           }, -- square_of_manticore_leather (15%)
            { rate.RARE,        1629           }, -- square_of_buffalo_leather   ( 5%)
            { rate.RARE,        { 2372, 1, 2 } }, -- khimaira_mane               ( 5%)
        },
    },
    {
        name  = "Lord's Armet",
        item  = 15189,
        req   = JSE.HEAD,
        loot  =
        {
            { rate.VERY_COMMON,   745 }, -- gold_ingot      (24%)
            { rate.COMMON,        654 }, -- Darksteel Ingot (15%)
            { rate.UNCOMMON,      664 }, -- Darksteel Sheet (10%)
            { rate.UNCOMMON,      850 }, -- Sheep Leather   (10%)
            { rate.RARE,        12419 }, -- darksteel_armet ( 5%)
            { rate.VERY_RARE,     914 }, -- vial_of_mercury ( 1%)
        },
    },
    {
        name  = "Lord's Cuirass",
        item  = 13757,
        req   = JSE.BODY,
        loot  =
        {
            { rate.VERY_COMMON,   745 }, -- gold_ingot        (24%)
            { rate.VERY_COMMON,   654 }, -- Darksteel Ingot   (24%)
            { rate.COMMON,        664 }, -- Darksteel Sheet   (15%)
            { rate.UNCOMMON,      752 }, -- Gold Sheet        (10%)
            { rate.UNCOMMON,      746 }, -- Platinum Ingot    (10%)
            { rate.UNCOMMON,      851 }, -- Ram Leather       (10%)
            { rate.RARE,        12547 }, -- Darksteel Cuirass ( 5%)
        },
    },
    {
        name  = "Lord's Gauntlets",
        item  = 14879,
        req   = JSE.HANDS,
        loot  =
        {
            { rate.VERY_COMMON,   745 }, -- gold_ingot          (24%)
            { rate.COMMON,        654 }, -- Darksteel Ingot     (15%)
            { rate.UNCOMMON,      664 }, -- Darksteel Sheet     (10%)
            { rate.UNCOMMON,      745 }, -- gold_ingot          (10%)
            { rate.RARE,        12675 }, -- darksteel_gauntlets ( 5%)
            { rate.VERY_RARE,     914 }, -- vial_of_mercury     ( 1%)
        },
    },
    {
        name  = "Lord's Cuisses",
        item  = 15395,
        req   = JSE.LEGS,
        loot  =
        {
            { rate.VERY_COMMON,   745 }, -- gold_ingot        (24%)
            { rate.COMMON,        654 }, -- Darksteel Ingot   (15%)
            { rate.UNCOMMON,      664 }, -- Darksteel Sheet   (10%)
            { rate.UNCOMMON,      851 }, -- Ram Leather       (10%)
            { rate.RARE,        12803 }, -- darksteel_cuisses ( 5%)
            { rate.VERY_RARE,     914 }, -- vial_of_mercury   ( 1%)
        },
    },
    {
        name  = "Lord's Sabatons",
        item  = 15333,
        req   = JSE.FEET,
        loot  =
        {
            { rate.VERY_COMMON,   745 }, -- gold_ingot         (24%)
            { rate.COMMON,        654 }, -- Darksteel Ingot    (15%)
            { rate.COMMON,        664 }, -- Darksteel Sheet    (15%)
            { rate.COMMON,        851 }, -- Ram Leather        (15%)
            { rate.RARE,        12931 }, -- darksteel_sabatons ( 5%)
            { rate.VERY_RARE,     914 }, -- vial_of_mercury    ( 1%)
        },
    },
    {
        name  = "Unicorn Cap",
        item  = 15209,
        req   = JSE.HEAD,
        loot  =
        {
            { rate.VERY_COMMON, 823 }, -- spool_of_gold_thread          (24%)
            { rate.VERY_COMMON, 855 }, -- square_of_black_tiger_leather (24%)
            { rate.COMMON,      664 }, -- darksteel_sheet               (15%)
            { rate.RARE,        862 }, -- square_of_behemoth_leather    ( 5%)
            { rate.RARE,       1841 }, -- unicorn_horn                  ( 5%)
        },
    },
    {
        name  = "Unicorn Harness",
        item  = 14448,
        req   = JSE.BODY,
        loot  =
        {
            { rate.VERY_COMMON, 823            }, -- spool_of_gold_thread          (24%)
            { rate.VERY_COMMON, 855            }, -- square_of_black_tiger_leather (24%)
            { rate.RARE,        862            }, -- square_of_behemoth_leather    ( 5%)
            { rate.RARE,        { 1841, 1, 2 } }, -- unicorn_horn                  ( 5%)
        },
    },
    {
        name  = "Unicorn Mittens",
        item  = 14055,
        req   = JSE.HANDS,
        loot  =
        {
            { rate.VERY_COMMON,  823 }, -- spool_of_gold_thread       (24%)
            { rate.COMMON,       866 }, -- handful_of_wyvern_scales   (15%)
            { rate.RARE,         823 }, -- spool_of_gold_thread       ( 5%)
            { rate.RARE,         862 }, -- square_of_behemoth_leather ( 5%)
            { rate.RARE,        1841 }, -- unicorn_horn               ( 5%)
        },
    },
    {
        name  = "Unicorn Subligar",
        item  = 15406,
        req   = JSE.LEGS,
        loot  =
        {
            { rate.VERY_COMMON, 1279 }, -- square_of_taffeta_cloth    (24%)
            { rate.UNCOMMON,     860 }, -- Behemoth Hide              (10%)
            { rate.RARE,         862 }, -- square_of_behemoth_leather ( 5%)
            { rate.RARE,        1841 }, -- unicorn_horn               ( 5%)
        },
    },
    {
        name  = "Unicorn Leggings",
        item  = 15345,
        req   = JSE.FEET,
        loot  =
        {
            { rate.VERY_COMMON,  823 }, -- spool_of_gold_thread       (24%)
            { rate.COMMON,       866 }, -- handful_of_wyvern_scales   (15%)
            { rate.UNCOMMON,     860 }, -- Behemoth Hide              (10%)
            { rate.RARE,         862 }, -- square_of_behemoth_leather ( 5%)
            { rate.RARE,        1841 }, -- unicorn_horn               ( 5%)
        },
    },
    {
        name  = "Wise Cap",
        item  = 15190,
        req   = JSE.HEAD,
        loot  =
        {
            { rate.VERY_COMMON,  822 }, -- spool_of_silver_thread       (24%)
            { rate.VERY_COMMON,  828 }, -- square_of_velvet_cloth       (24%)
            { rate.COMMON,       829 }, -- square_of_silk_cloth         (15%)
            { rate.UNCOMMON,    1117 }, -- square_of_manticore_leather  (10%)
            { rate.RARE,        1767 }, -- square_of_eltoro_leather     ( 5%)
        },
    },
    {
        name  = "Chasuble",
        item  = 14440,
        req   = JSE.BODY,
        loot  =
        {
            { rate.VERY_COMMON,  822 }, -- spool_of_silver_thread       (24%)
            { rate.COMMON,      1623 }, -- eft_skin                     (15%)
            { rate.COMMON,       828 }, -- square_of_velvet_cloth       (15%)
            { rate.UNCOMMON,    1117 }, -- square_of_manticore_leather  (10%)
            { rate.UNCOMMON,     746 }, -- platinum_ingot               (10%)
            { rate.RARE,        1767 }, -- square_of_eltoro_leather     ( 5%)
        },
    },
    {
        name  = "Wise Gloves",
        item  = 14880,
        req   = JSE.HANDS,
        loot  =
        {
            { rate.VERY_COMMON,   822         }, -- spool_of_silver_thread   (24%)
            { rate.VERY_COMMON,   828         }, -- square_of_velvet_cloth   (24%)
            { rate.UNCOMMON,    { 834, 1, 2 } }, -- ball_of_saruta_cotton    (10%)
            { rate.RARE,         1767         }, -- square_of_eltoro_leather ( 5%)
            { rate.VERY_RARE,   12696         }, -- leather_gloves           ( 1%)
        },
    },
    {
        name  = "Wise Braconi",
        item  = 15396,
        req   = JSE.LEGS,
        loot  =
        {
            { rate.VERY_COMMON,  822 }, -- spool_of_silver_thread   (24%)
            { rate.VERY_COMMON,  828 }, -- square_of_velvet_cloth   (24%)
            { rate.COMMON,      1623 }, -- eft_skin                 (15%)
            { rate.RARE,         822 }, -- spool_of_silver_thread   ( 5%)
            { rate.RARE,         828 }, -- square_of_velvet_cloth   ( 5%)
            { rate.RARE,        1767 }, -- square_of_eltoro_leather ( 5%)
        },
    },
    {
        name  = "Wise Pigaches",
        item  = 15334,
        req   = JSE.FEET,
        loot  =
        {
            { rate.VERY_COMMON,  823 }, -- spool_of_gold_thread          (24%)
            { rate.VERY_COMMON,  828 }, -- square_of_velvet_cloth        (24%)
            { rate.COMMON,       850 }, -- square_of_sheep_leather       (15%)
            { rate.UNCOMMON,     855 }, -- square_of_black_tiger_leather (10%)
            { rate.RARE,        1767 }, -- square_of_eltoro_leather      ( 5%)
        },
    },
    {
        name  = "Yasha Jinpachi",
        item  = 12490,
        req   = JSE.HEAD,
        loot  =
        {
            { rate.VERY_COMMON, 664           }, -- darksteel_sheet        (24%)
            { rate.VERY_COMMON, 654           }, -- Darksteel Ingot        (24%)
            { rate.COMMON,      682           }, -- darksteel_chain        (15%)
            { rate.RARE,        {1764, 1, 2 } }, -- square_of_kejusu_satin ( 5%)
        },
    },
    {
        name  = "Yasha Samue",
        item  = 12618,
        req   = JSE.BODY,
        loot  =
        {
            { rate.VERY_COMMON, 666            }, -- steel_sheet                   (24%)
            { rate.COMMON,      828            }, -- square_of_velvet_cloth        (15%)
            { rate.COMMON,      {  855, 1, 2 } }, -- square_of_black_tiger_leather (15%)
            { rate.COMMON,      664            }, -- darksteel_sheet               (15%)
            { rate.COMMON,      821            }, -- spool_of_rainbow_thread       (15%)
            { rate.RARE,        { 1764, 1, 2 } }, -- square_of_kejusu_satin        ( 5%)
        },
    },
    {
        name  = "Yasha Tekko",
        item  = 13957,
        req   = JSE.HANDS,
        loot  =
        {
            { rate.VERY_COMMON,  654 }, -- Darksteel Ingot               (24%)
            { rate.COMMON,       664 }, -- darksteel_sheet               (15%)
            { rate.COMMON,       855 }, -- square_of_black_tiger_leather (15%)
            { rate.UNCOMMON,     682 }, -- darksteel_chain               (10%)
            { rate.RARE,         819 }, -- spool_of_linen_thread         ( 5%)
            { rate.RARE,        1764 }, -- square_of_kejusu_satin        ( 5%)
        },
    },
    {
        name  = "Yasha Hakama",
        item  = 12847,
        req   = JSE.LEGS,
        loot  =
        {
            { rate.COMMON,   { 828, 1, 2 } }, -- square_of_velvet_cloth        (15%)
            { rate.COMMON,    664          }, -- darksteel_sheet               (15%)
            { rate.COMMON,    816          }, -- spool_of_silk_thread          (15%)
            { rate.COMMON,    850          }, -- square_of_sheep_leather       (15%)
            { rate.UNCOMMON,  855          }, -- square_of_black_tiger_leather (10%)
            { rate.RARE,     1764          }, -- square_of_kejusu_satin        ( 5%)
        },
    },
    {
        name  = "Yasha Sune-Ate",
        item  = 13002,
        req   = JSE.FEET,
        loot  =
        {
            { rate.COMMON,    816          }, -- spool_of_silk_thread          (15%)
            { rate.COMMON,    654          }, -- Darksteel Ingot               (15%)
            { rate.COMMON,    664          }, -- darksteel_sheet               (15%)
            { rate.UNCOMMON, { 855, 1, 2 } }, -- square_of_black_tiger_leather (10%)
            { rate.RARE,     1764          }, -- square_of_kejusu_satin        ( 5%)
        },
    },
    {
        name  = "Coffer Keys",
        list  = { 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1057, 1058, 1059, 1060, 1063 },
        req   = 0,
        loot  =
        {
            { rate.UNCOMMON,  { 1179, 1, 6 } },  -- Shihei               (10%)
            { rate.UNCOMMON,  { 5328, 1, 6 } },  -- Hi-Potion Drop       (10%)
            { rate.UNCOMMON,  { 5358, 1, 6 } },  -- Hi-Ether Drop        (10%)
            { rate.RARE,      { 4096, 1, 6 } },  -- Fire Crystal         ( 5%)
            { rate.RARE,      { 4097, 1, 6 } },  -- Ice Crystal          ( 5%)
            { rate.RARE,      { 4098, 1, 6 } },  -- Wind Crystal         ( 5%)
            { rate.RARE,      { 4099, 1, 6 } },  -- Earth Crystal        ( 5%)
            { rate.RARE,      { 4100, 1, 6 } },  -- Lightning Crystal    ( 5%)
            { rate.RARE,      { 4101, 1, 6 } },  -- Water Crystal        ( 5%)
            { rate.RARE,      { 4102, 1, 6 } },  -- Light Crystal        ( 5%)
            { rate.RARE,      { 4103, 1, 6 } },  -- Dark Crystal         ( 5%)
            { rate.RARE,       4155 },           -- Remedy               ( 5%)
            { rate.RARE,       1126 },           -- Beastmen's Seal      ( 5%)
            { rate.RARE,       1126 },           -- Kindred's Seal       ( 5%)
            { rate.RARE,       2184 },           -- Imp. Brz. Piece      ( 5%)
            { rate.VERY_RARE,  4104 },           -- Fire Cluster         ( 1%)
            { rate.VERY_RARE,  4105 },           -- Ice Cluster          ( 1%)
            { rate.VERY_RARE,  4106 },           -- Wind Cluster         ( 1%)
            { rate.VERY_RARE,  4107 },           -- Earth Cluster        ( 1%)
            { rate.VERY_RARE,  4108 },           -- Lightning Cluster    ( 1%)
            { rate.VERY_RARE,  4109 },           -- Water Cluster        ( 1%)
            { rate.VERY_RARE,  4110 },           -- Light Cluster        ( 1%)
            { rate.VERY_RARE,  4111 },           -- Dark Cluster         ( 1%)
            { rate.VERY_RARE,  1875 },           -- Ancient Beastcoin    ( 1%)
            { rate.VERY_RARE,  2185 },           -- Imp. Slv. Piece      ( 1%)
        },
    },
    {
        name  = "Limbus Materials",
        list  = { xi.item.IVORY_CHIP, xi.item.SCARLET_CHIP, xi.item.EMERALD_CHIP, xi.item.SILVER_CHIP, xi.item.CERULEAN_CHIP, xi.item.SMALT_CHIP, xi.item.SMOKY_CHIP, xi.item.ORCHID_CHIP, xi.item.CHARCOAL_CHIP, xi.item.MAGENTA_CHIP, 
                  xi.item.SQUARE_OF_ECARLATE_CLOTH, xi.item.ARGYRO_RIVET, xi.item.UTOPIAN_GOLD_THREAD, xi.item.ANCIENT_BRASS_INGOT, xi.item.SQUARE_OF_BENEDICT_SILK, xi.item.SPOOL_OF_BENEDICT_YARN,
                  xi.item.SQUARE_OF_DIABOLIC_SILK, xi.item.SPOOL_OF_DIABOLIC_YARN, xi.item.SPOOL_OF_RUBY_SILK_THREAD, xi.item.SQUARE_OF_CARDINAL_CLOTH, xi.item.SQUARE_OF_SUPPLE_SKIN, xi.item.SPOOL_OF_LIGHT_FILAMENT,
                  xi.item.CHUNK_OF_SNOWY_CERMET, xi.item.WHITE_RIVET, xi.item.DARK_ORICHALCUM_INGOT, xi.item.BLACK_RIVET, xi.item.SQUARE_OF_SMALT_LEATHER, xi.item.FETID_LANOLIN_CUBE,
                  xi.item.SPOOL_OF_COILED_YARN, xi.item.SQUARE_OF_BROWN_DOESKIN, xi.item.SPOOL_OF_CHAMELEON_YARN, xi.item.SQUARE_OF_CHARCOAL_COTTON, xi.item.SPOOL_OF_SCARLET_ODOSHI, xi.item.SHEET_OF_KUROGANE,
                  xi.item.PLAITED_CORD, xi.item.POT_OF_EBONY_LACQUER, xi.item.SHEET_OF_COBALT_MYTHRIL, xi.item.BLUE_RIVET, xi.item.SPOOL_OF_GLITTERING_YARN, xi.item.SQUARE_OF_ASTRAL_LEATHER,
                  xi.item.SPOOL_OF_LUMINIAN_THREAD, xi.item.SQUARE_OF_FLAMESHUN_CLOTH, xi.item.SPOOL_OF_SILKWORM_THREAD, xi.item.SQUARE_OF_CANVAS_TOILE, xi.item.PANTIN_WIRE, xi.item.SQUARE_OF_CORDUROY_CLOTH,
                  xi.item.SQUARE_OF_FILET_LACE, xi.item.GOLD_STUD, xi.item.SQUARE_OF_BRILLIANTINE, xi.item.ELECTRUM_STUD },
        req   = 0,
        loot  =
        {
            { rate.COMMON,  xi.item.PEBBLE }, --                         (15%)
            { rate.COMMON,  xi.item.PEBBLE }, --                         (15%)
            { rate.COMMON,  xi.item.PEBBLE }, --                         (15%)
            { rate.RARE,  xi.item.ANCIENT_BEASTCOIN }, --                ( 5%)
            { rate.RARE,  xi.item.ANCIENT_BEASTCOIN }, --                ( 5%)

            { rate.RARE,       1786 },           -- Aern Organ           ( 5%)
            { rate.RARE,       1818 },           -- Euvhi Organ          ( 5%)
            { rate.RARE,       1872 },           -- Ghrah M Chip         ( 5%)
            { rate.RARE,       1787 },           -- Hpemde Organ         ( 5%)
            { rate.RARE,       1783 },           -- Luminian Tissue      ( 5%)
            { rate.RARE,       1784 },           -- Phuabo Organ         ( 5%)
            { rate.RARE,       1785 },           -- Xzomit Organ         ( 5%)
            { rate.RARE,       1788 },           -- Yovra Organ          ( 5%)
            { rate.VERY_RARE, xi.item.HIGH_QUALITY_AERN_ORGAN },   --    ( 1%)
            { rate.VERY_RARE, xi.item.HIGH_QUALITY_HPEMDE_ORGAN }, --    ( 1%)
            { rate.VERY_RARE, xi.item.HIGH_QUALITY_PHUABO_ORGAN }, --    ( 1%)
            { rate.VERY_RARE,  1899 },           -- H.Q. Euvhi Organ     ( 1%)
            { rate.VERY_RARE,  1855 },           -- H.Q. Xzomit Organ    ( 1%)
        },
    },
    {
        name  = "Arctic Wind",
        item  = 18161,
        req   = 0,
        loot  =
        {
            { rate.VERY_COMMON, { 4101, 2, 4 } }, -- Water Crystal x2-4 (24%)
            { rate.COMMON,      { 4101, 3, 9 } }, -- Water Crystal x3-9 (15%)
            { rate.UNCOMMON,    4109           }, -- Water Cluster      (10%)
            { rate.UNCOMMON,    3275           }, -- Genbu Scrap        (10%)
            { rate.RARE,        1425           }, -- Winterstone        ( 5%)
            { rate.COMMON,      1424           }, -- Gem of the North   ( 5%)
            { rate.VERY_RARE,   1404           }, -- Seal of Genbu      ( 1%)
        },
    },
    {
        name  = "East Wind",
        item  = 18162,
        req   = 0,
        loot  =
        {
            { rate.VERY_COMMON, { 4098, 2, 4 } }, -- Wind Crystal x2-4 (24%)
            { rate.COMMON,      { 4098, 3, 9 } }, -- Wind Crystal x3-9 (15%)
            { rate.UNCOMMON,    4106           }, -- Wind Cluster      (10%)
            { rate.UNCOMMON,    3277           }, -- Seiryu Scrap      (10%)
            { rate.RARE,        1419           }, -- Springstone       ( 5%)
            { rate.RARE,        1418           }, -- Gem of the East   ( 5%)
            { rate.VERY_RARE,   1405           }, -- Seal of Seiryu    ( 1%)
        },
    },
    {
        name  = "Zephyr",
        item  = 18163,
        req   = 0,
        loot  =
        {
            { rate.VERY_COMMON, { 4102, 2, 4 } }, -- Light Crystal x2-4 (24%)
            { rate.COMMON,      { 4102, 3, 9 } }, -- Light Crystal x3-9 (15%)
            { rate.UNCOMMON,    4110           }, -- Light Cluster      (10%)
            { rate.UNCOMMON,    3278           }, -- Byakko Scrap       (10%)
            { rate.RARE,        1423           }, -- Autumnstone        ( 5%)
            { rate.COMMON,      1422           }, -- Gem of the West    ( 5%)
            { rate.VERY_RARE,   1406           }, -- Seal of Byakko     ( 1%)
        },
    },
    {
        name  = "Antarctic Wind",
        item  = 18164,
        req   = 0,
        loot  =
        {
            { rate.VERY_COMMON, { 4096, 2, 4 } }, -- Fire Crystal x2-4  (24%)
            { rate.COMMON,      { 4096, 3, 9 } }, -- Fire Crystal x3-9  (15%)
            { rate.UNCOMMON,    4104           }, -- Fire Cluster       (10%)
            { rate.UNCOMMON,    3276           }, -- Suzaku Scrap       (10%)
            { rate.RARE,        1421           }, -- Summerstone        ( 5%)
            { rate.COMMON,      1420           }, -- Gem of the South   ( 5%)
            { rate.VERY_RARE,   1407           }, -- Seal of Byakko     ( 1%)
        },
    },
}

local relics =
{
    15066, -- relic_shield
    18260, -- relic_knuckles
    18266, -- relic_dagger
    18272, -- relic_sword
    18278, -- relic_blade
    18284, -- relic_axe
    18290, -- relic_bhuj
    18296, -- relic_lance
    18302, -- relic_scythe
    18308, -- ihintanto
    18314, -- ito
    18320, -- relic_maul
    18326, -- relic_staff
    18332, -- relic_gun
    18338, -- relic_horn
    18344, -- relic_bow
}

for _, relic in pairs(relics) do
    table.insert(results, {
        name = "Relic Weapon",
        item = relic,
        req  = 0,
        loot =
        {
            { rate.VERY_COMMON, xi.item.ORDELLE_BRONZEPIECE }, -- Ordelle Bronzepiece   (24%)
            { rate.VERY_RARE,   xi.item.ORDELLE_BRONZEPIECE }, -- Ordelle Bronzepiece   ( 1%)
            { rate.VERY_COMMON, xi.item.ONE_BYNE_BILL },       -- One Byne Bill         (24%)
            { rate.VERY_RARE,   xi.item.ONE_BYNE_BILL },       -- One Byne Bill         ( 1%)
            { rate.VERY_COMMON, xi.item.TUKUKU_WHITESHELL },   -- Tukuku Whiteshell     (24%)
            { rate.VERY_RARE,   xi.item.TUKUKU_WHITESHELL },   -- Tukuku Whiteshell     ( 1%)

            { rate.RARE,        3493 }, -- Forgotten Thought     ( 5%)
            { rate.RARE,        3494 }, -- Forgotten Hope        ( 5%)
            { rate.RARE,        3495 }, -- Forgotten Touch       ( 5%)
            { rate.RARE,        3496 }, -- Forgotten Journey     ( 5%)
            { rate.RARE,        3497 }, -- Forgotten Step        ( 5%)

            { rate.ULTRA_RARE,  1453 }, -- Montiont Silverpiece  (.1%)
            { rate.ULTRA_RARE,  1456 }, -- 100 Byne Bill         (.1%)
            { rate.ULTRA_RARE,  1450 }, -- Lungo-Nango Jadeshell (.1%)
        },
    })
end

local function tradeAfter(player, npc)
    npc:facePlayer(player, true)
    npc:ceAnimate(player, npc, 25, 1)
    npc:ceAnimate(player, npc, 53, 4)

    player:fmt("Garbagio : Om nom nom nom! *Crunch*")

    local current = player:getCharVar(cexi.skill.garbagio.varSkill) / 10
    local roll    = math.random(0, 100)

    if (roll < 50 and current < 60) or roll < 30 then
        cexi.skill.skillUp(player, cexi.skill.garbagio)
    end
end

local function rollItem(loot, multiplier)
    local picked = cexi.util.pickItem(loot, multiplier)
    local item   = picked[2]

    if type(item) == "table" then
        return { item[1], math.random(item[2], item[3]) }
    else
        return { item, 1 }
    end
end

local function rollResult(player, npc, trade, current, info)
    local diff = current - info.req
    local base = 1

    if diff > 70 then
        base = 5
    elseif diff > 50 then
        base = 4
    elseif diff > 30 then
        base = 3
    elseif diff > 10 then
        base = 2
    end

    local items = {}

    table.insert(items, rollItem(info.loot, base))

    if math.floor(current / 10) > math.random(0, 100) then
        table.insert(items, rollItem(info.loot, base))
    end

    if npcUtil.giveItem(player, items) then
        player:tradeComplete()
        player:incrementCharVar(cexi.skill.garbagio.varTally, 1)
        tradeAfter(player, npc)
    end
end

local function onTrade(player, npc, trade)
    local current = player:getCharVar(cexi.skill.garbagio.varSkill) / 10

    for _, result in pairs(results) do
        if
            result.req == nil or
            current >= result.req
        then
            if result.item ~= nil then
                if npcUtil.tradeHasExactly(trade, result.item) then
                    rollResult(player, npc, trade, current, result)
                end
            end

            if result.range ~= nil then
                for itemID = result.range[1], result.range[2] do
                    if npcUtil.tradeHasExactly(trade, itemID) then
                        rollResult(player, npc, trade, current, result)
                    end
                end
            end

            if result.list ~= nil then
                for _, listItemID in pairs(result.list) do
                    if npcUtil.tradeHasExactly(trade, listItemID) then
                        rollResult(player, npc, trade, current, result)
                    end
                end
            end
        end
    end
end

local function onTrigger(player, npc)
    if cexi.skill.rankUpReward(player, npc, cexi.skill.garbagio) then
        npc:facePlayer(player, true)
        player:fmt("Garbagio : You friend! Me happy!")
        npc:ceAnimate(player, npc, 251, 4)
    else
        npc:facePlayer(player, true)
        player:fmt("Garbagio : Me hungry! Me want snacks!")
    end
end

cexi.util.liveReload(m, {
    ["Port_Jeuno"] =
    {
        {
            objtype   = xi.objType.NPC,
            name      = "Garbagio",
            look      = 2927,
            x         = -4.785,
            y         = 0,
            z         = 9.880,
            rotation  = 81,
            widescan  = 1,
            onTrade   = onTrade,
            onTrigger = onTrigger,
        },
    },
})

return m
