-----------------------------------
-- Adds chocobo digging skillup messages
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("chocobo_digging_skillups")

m:addOverride("xi.chocoboDig.start", function(player, precheck)
    local origSkill = player:getCharSkillLevel(xi.skill.DIG)
    local result = super(player, precheck)

    local newSkill = player:getCharSkillLevel(xi.skill.DIG)
    if newSkill - origSkill > 0 then
        local name = player:getName()
        local skillName = "digging skill"
        local pointsMsg = "%s's %s rises 0.%u points."
        local levelMsg  = "%s's %s reaches level %u."
        local rankMsg   = "%s reaches rank %u."
        player:printToPlayer(string.format(pointsMsg, name, skillName, newSkill - origSkill), xi.msg.channel.SYSTEM_3)

        local resultLevel = math.floor(newSkill / 10)

        if resultLevel > math.floor(origSkill / 10) then
            player:printToPlayer(string.format(levelMsg, name, skillName, resultLevel), xi.msg.channel.SYSTEM_3)

            if resultLevel % 10 == 0 then
                player:printToPlayer(string.format(rankMsg, name, math.floor(resultLevel / 10)), xi.msg.channel.SYSTEM_3)
            end
        end
    end

    return result
end)

return m
