-----------------------------------
-- The Unnamed Way - Unlocks GEO (Lv75)
-----------------------------------
-- !setvar [CW]UNNAMED_WAY 0
-- Master Lao !pos 70.800 -2.750 -165.200 238
-- Baelfyr    !pos -258.078 3.222 -143.968 205
-- Byrgen     !pos -640.000 0.500 -233.400 125
-- Gefryst    !pos -563.170 -20.000 47.500 5
-- Ungeweder  !pos -212.075 -3.000 253.000 113
-- Master Lao !pos 70.800 -2.750 -165.200 238
-- Reward: Unlocks GEO
-----------------------------------
-- !setvar [CW]UNNAMED_WAY 7

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-the_unnamed_way")

local info =
{
    name     = "The Unnamed Way",
    author   = "Loxley",
    var      = "[CW]UNNAMED_WAY",
    required = 885, -- Turtle Shell
    reward   =
    {
        item  = { xi.item.MATRE_BELL, xi.item.PLATE_OF_INDI_POISON },
        after = function(player)
            cq.rewardSlots(player, { xi.inv.WARDROBE, 1 })
            npcUtil.giveKeyItem(player, xi.ki.JOB_GESTURE_GEOMANCER)
            npcUtil.giveKeyItem(player, xi.ki.LUOPAN)
            player:unlockJob(xi.job.GEO)
            player:setCharVar("GEO_Unlocked", 1)
            player:printToPlayer("\129\154 You can now become a Geomancer \129\154", xi.msg.channel.SYSTEM_3)
            return true
        end,
    },
}

local MASTER    = "MASTER"

local BAELFYR   = "BAELFYR"
local SCORCHED  = "SCORCHED"

local BYRGEN    = "BYRGEN"
local CRUMBLED  = "CRUMBLED"

local GEFRYST   = "GEFRYST"
local FROZEN    = "FROZEN"

local UNGEWEDER = "UNGEWEDER"
local SCATTERED = "SCATTERED"

local entity =
{
    {
        id     = MASTER,
        name   = "Master Lao",
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.A8,
            head = 308,
            body = 308,
            hand = 308,
            legs = 308,
            feet = 308,
        }),
        area   = "Windurst_Waters",
        pos    = { 70.800, -2.750, -165.200, 145 }, -- !pos 70.800 -2.750 -165.200 238
        dialog =
        {
            NAME      = true,
            DEFAULT   = { "Those who know, do not speak. Those who speak, do not know." },
            START     =
            {
                "The journey of a thousand miles begins with a single step.",
                " In the days of old, sages read the signs upon turtle shells.",
                { emote = xi.emote.THINK },
                "Bring me a turtle shell, and I shall divine your way.",
            },
            REMINDER  =
            {
                "In the days of old, sages read the signs upon turtle shells.",
                { emote = xi.emote.THINK },
                " Bring me a turtle shell, and I shall divine your way.",
            },
            QUEST     =
            {
                { music = 60 }, -- Adoulin/Ceizak music
                "The hard stone is easily shattered, the sturdy branch easily snapped",
                " The earth yields to all elements, and so endures forever.",
                { emote = xi.emote.YES },
                { delay = 500 },
                "The scorched earth of the Cauldron, the dry crumbled earth of Altepa,",
                " the frozen earth of Uleguerand, and the scattered earth of Teriggan.",
                { emote = xi.emote.THINK },
                { delay = 500 },
                "Find these four conditions of earth, feel and listen to the sounds.",
                " Return to me when you know nothing more, and you shall learn the way",
                { music = cexi.music.WINDURST },
            },
            REMINDER2 =
            {
                "The scorched earth of the Cauldron, the dry crumbled earth of Altepa,",
                " the frozen earth of Uleguerand, and the scattered earth of Teriggan.",
                { emote = xi.emote.THINK },
                { delay = 500 },
                "Find these four conditions of earth, feel and listen to the sounds.",
                " Return to me when you know nothing more, and you shall learn the way",
            },
            FINISH    =
            {
                "When I forget what I am, I become what I might be.",
                " So, have you heard the sounds of the earth?",
                { entity = "player", emote = xi.emote.YES },
                { music  = 63 }, -- Adoulin music
                { delay  = 3000 },
                { emote  = xi.emote.THINK },
                "The wind has no plans, yet it moves mountains.",
                { delay = 1000 },
                " Fire has no will, yet it consumes forests.",
                { delay = 1000 },
                " Water has no form, yet it permeates all things.",
                { delay = 1000 },
                " Earth is barren, yet it births all life.",
                { emote = xi.emote.YES },
                { delay = 2000 },
                "Knowledge is accomplished by adding things each day.",
                " But true wisdom is found by removing things each day.",
                { delay = 2000 },
                "Worldly ways cloud perception, like murky water that must settle.",
                " Only by being still can we see clearly, only by being empty can the cup be filled.",
                { emote = xi.emote.POINT },
                { delay = 3000 },
                "To master these elements, you must forget what you know and become what you are.",
                { music = cexi.music.WINDURST },
            },
        },
    },
    {
        id          = BAELFYR,
        name        = "Baelfyr",
        type        = xi.objType.MOB,
        groupId     = 19,
        groupZoneId = 178,
        area        = "Ifrits_Cauldron", -- (G-9)
        pos         = { -258.078, 3.222, -143.968, 139 }, -- !pos -258.078 3.222 -143.968 205
        level       = 72,
        mods        =
        {
            [xi.mod.SLASH_SDT]  = 1000,
            [xi.mod.PIERCE_SDT] = 1000,
            [xi.mod.IMPACT_SDT] = 1000,
            [xi.mod.HTH_SDT]    = 1000,
        },
    },
    {
        id          = SCORCHED,
        name        = "Scorched Earth",
        marker      = cq.MAIN_QUEST,
        area        = "Ifrits_Cauldron", -- (G-9)
        pos         = { -258.078, 3.222, -143.968, 139 }, -- !pos -258.078 3.222 -143.968 205
        dialog      =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        },
    },
    {
        id          = BYRGEN,
        name        = "Byrgen",
        type        = xi.objType.MOB,
        groupId     = 22,
        groupZoneId = 178,
        area        = "Western_Altepa_Desert", -- (E-9)
        pos         = { -640.000, 0.500, -233.400, 64 }, -- !pos -640.000 0.500 -233.400 125
        level       = 72,
        mods        =
        {
            [xi.mod.SLASH_SDT]  = 1000,
            [xi.mod.PIERCE_SDT] = 1000,
            [xi.mod.IMPACT_SDT] = 1000,
            [xi.mod.HTH_SDT]    = 1000,
        },
    },
    {
        id          = CRUMBLED,
        name        = "Crumbled Earth",
        marker      = cq.MAIN_QUEST,
        area        = "Western_Altepa_Desert", -- (E-9)
        pos         = { -640.000, 0.500, -233.400, 64 }, -- !pos -640.000 0.500 -233.400 125
        dialog      =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        },
    },
    {
        id          = GEFRYST,
        name        = "Gefyrst",
        type        = xi.objType.MOB,
        groupId     = 20,
        groupZoneId = 178,
        area        = "Uleguerand_Range", -- (E-8)
        pos         = { -563.170, -20.000, 47.500, 48 }, -- !pos -563.170 -20.000 47.500 5
        level       = 72,
        mods        =
        {
            [xi.mod.SLASH_SDT]  = 1000,
            [xi.mod.PIERCE_SDT] = 1000,
            [xi.mod.IMPACT_SDT] = 1000,
            [xi.mod.HTH_SDT]    = 1000,
        },
    },
    {
        id          = FROZEN,
        name        = "Frozen Earth",
        marker      = cq.MAIN_QUEST,
        area        = "Uleguerand_Range", -- (E-8)
        pos         = { -563.170, -20.000, 47.500, 48 }, -- !pos -563.170 -20.000 47.500 5
        dialog      =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        },
    },
    {
        id          = UNGEWEDER,
        name        = "Ungeweder",
        type        = xi.objType.MOB,
        groupId     = 21,
        groupZoneId = 178,
        area        = "Cape_Teriggan", -- (G-6)
        pos         = { -212.075, -3.000, 253.000, 32 }, -- !pos -212.075 -3.000 253.000 113
        level       = 72,
        mods        =
        {
            [xi.mod.SLASH_SDT]  = 1000,
            [xi.mod.PIERCE_SDT] = 1000,
            [xi.mod.IMPACT_SDT] = 1000,
            [xi.mod.HTH_SDT]    = 1000,
        },
    },
    {
        id          = SCATTERED,
        name        = "Scattered Earth",
        marker      = cq.MAIN_QUEST,
        area        = "Cape_Teriggan", -- (G-6)
        pos         = { -212.075, -3.000, 253.000, 32 }, -- !pos -212.075 -3.000 253.000 113
        dialog      =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        },
    },
}

local step =
{
    {
        check    = cq.checks({ era = true, level = 75 }),
        [MASTER] = cq.talkStep("START", info.name),
    },
    {
        [MASTER] = 
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeStep("QUEST", "REMINDER", info.required)
        },
    },
    {
        [MASTER]   = cq.talkOnly("REMINDER2"),
        [SCORCHED] = cq.menuSpawn(BAELFYR, "Listen to the sound?", { { "No" }, { "Yes" } }, 2),
        [BAELFYR]  = cq.killStep(SCORCHED),
    },
    {
        [SCORCHED] = cq.talkOnly("AFTER"),
        [MASTER]   = cq.talkOnly("REMINDER2"),
        [CRUMBLED] = cq.menuSpawn(BYRGEN, "Listen to the sound?", { { "No" }, { "Yes" } }, 2),
        [BYRGEN]   = cq.killStep(CRUMBLED),
    },
    {
        [CRUMBLED] = cq.talkOnly("AFTER"),
        [MASTER]   = cq.talkOnly("REMINDER2"),
        [FROZEN]   = cq.menuSpawn(GEFRYST, "Listen to the sound?", { { "No" }, { "Yes" } }, 2),
        [GEFRYST]  = cq.killStep(FROZEN),
    },
    {
        [FROZEN]    = cq.talkOnly("AFTER"),
        [MASTER]    = cq.talkOnly("REMINDER2"),
        [SCATTERED] = cq.menuSpawn(UNGEWEDER, "Listen to the sound?", { { "No" }, { "Yes" } }, 2),
        [UNGEWEDER] = cq.killStep(SCATTERED),
    },
    {
        [SCATTERED]  = cq.talkOnly("AFTER"),
        [MASTER]     = cq.giveStep("FINISH", info.reward, info.name, cexi.music.WINDURST),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
