-----------------------------------
-- Say Peas      (Lv5)
-- Get Cracking (Lv10)
-----------------------------------
-- !setvar [CW]SAY_PEAS 0
-- Perara !pos -119.179 -2.000 46.047 238
-- !additem 4444 12
-- Reward: Augmented Robe (HP +3, MP +3), 200 gil
-----------------------------------
-- !setvar [CW]SAY_PEAS 2
-- Perara      !pos -119.179 -2.000 46.047 238
-- Fallen Nest !pos 1.428 -4.831 14.593 115
-- Perara      !pos -119.179 -2.000 46.047 238
-- Reward: Augment Holly Staff (STR +2, MND +2)
-----------------------------------
-- !setvar [CW]SAY_PEAS 5

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-say_peas")

local info =
{
    name    = "Say Peas",
    second  = "Get Cracking",
    author  = "Loxley",
    var     = "[CW]SAY_PEAS",
    reward  =
    {
        gil     = 200,
        item    = 12600,     -- Robe
        augment = { 17, 2 }, -- HP +3 / MP +3
    },

    reward2 =
    {
        item    = 17089,              -- Holly Staff
        augment = { 512, 1, 517, 1 }, -- STR +2, MND +2
    },

    required =
    {
        item = { { 4444, 5 } },
        name = "five rarab tails",
    },
}

local PERARA      = "PERARA"
local FALLEN_NEST = "FALLEN_NEST"
local ANGRY_BIRD  = "ANGRY_BIRD"

local entity =
{
    {
        id     = PERARA,
        name   = "Perara",
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.TARU_F,
            face = cexi.face.B2,
            head = cexi.model.NOTHING,
            body = cexi.model.ROBE,
            hand = cexi.model.DOUBLET,
            legs = cexi.model.DOUBLET,
            feet = cexi.model.DOUBLET,
        }),
        area   = "Windurst_Waters",                 -- (E-9)
        pos    = { -119.179, -2.000, 46.047, 170 }, -- !pos -119.179 -2.000 46.047 238
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "I'm outaru of ingredients!" },
            START    =
            {
                { emote = xi.emote.SHOCKED },
                "I keep burning the pea soup! Now I'm outaru of ingredients!",
                " Could you fetch me five rarab tails?",
            },
            REMINDER = { "Could you fetch me five rarab tails?" },
            AFTER =
            {
                { emote = xi.emote.SIGH },
                "Thank you, hopefully it won't end up burntaru this time!",
            },
            START2 =
            {
                "Hmmm... I need eggs for my next dish but they must be perfectly fresh.",
                "I've heard you may find fallen bird nests around trees south west of Starfall Hillock.",
                " Could you investigataru for me?",
            },
            REMINDER2 =
            {
                "I've heard you may find fallen bird nests around trees south west of Starfall Hillock.",
                " Could you investigataru for me?",
            },

            AFTER2 =
            {
                { emote = xi.emote.SIGH },
                "This is greataru, thanks for your help!",
            },
        },
    },
    {
        id       = FALLEN_NEST,
        name     = "Fallen Nest",
        marker   = cq.SIDE_QUEST,
        area     = "West_Sarutabaruta",
        pos      = { 1.428, -4.831, 14.593, 239 }, --!pos 1.428 -4.831 14.593 115
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            COLLECT =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion   = "retrieves the perfectly fresh eggs." },
            },
        },
    },
    {
        id          = ANGRY_BIRD,
        name        = "Angry Bird",
        type        = xi.objType.MOB,
        groupId     = 11,
        groupZoneId = 115,
        area        = "West_Sarutabaruta",
        pos         = { 1.428, -4.831, 14.593, 239 }, --!pos 1.428 -4.831 14.593 115
        level       = 9,
    },
}

local step =
{
    {
        check    = cq.checks({ CW = true, level = 5 }),
        [PERARA] = cq.talkStep("START", info.name),
    },
    {
        [PERARA] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeStep("AFTER", "REMINDER", info.required.item, info.reward, info.name, cexi.music.WINDURST),
        },
    },
    {
        check    = cq.checks({ CW = true, level = 10 }),
        [PERARA] = cq.talkStep("START2", info.second),
    },
    {
        [PERARA]      = cq.talkOnly("REMINDER2"),
        [FALLEN_NEST] = cq.menuSpawn(ANGRY_BIRD, "Touch the eggs?", { { "No." }, { "Yes." } }, 2, true, { levelCap = 10 }),
        [ANGRY_BIRD]  = cq.killStep(FALLEN_NEST),
    },
    {
        [PERARA]      = cq.talkOnly("REMINDER2"),
        [FALLEN_NEST] = cq.menuStep("Collect the eggs?", { { "No." }, { "Yes.", "COLLECT" } }, 2),
    },
    {
        [FALLEN_NEST] = cq.talkOnly("AFTER"),
        [PERARA]      = cq.giveStep("AFTER2", info.reward2, info.second, cexi.music.WINDURST),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
