-----------------------------------
-- Rustling Feathers (Lv5)
-----------------------------------
-- !setvar [CW]RUSTLING_FEATHERS 0
-- !setvar [CW]YAGUDO_FEATHERS 0
-- Puluki-Culuki !pos -226.082 -8.198 222.513 36
-- !additem 841 12
-- Rewards: 400g
-----------------------------------
-- !setvar [CW]RUSTLING_FEATHERS 1

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-rustling_feathers")

local info =
{
    name    = "Rustling Feathers",
    author  = "Loxley",
    var     = "[CW]RUSTLING_FEATHERS",
    counter = "[CW]YAGUDO_FEATHERS",
    reward  =
    {
        gil = 400,
    },

    required =
    {
        item = { { 841, 12 } },
        name = "twelve yagudo feathers",
    },
}

local PULU         = "PULU"
local PulukiCuluki = "Puluki-Culuki"

local entity =
{
    {
        id     = PULU,
        name   = PulukiCuluki,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.TARU_M,
            face = cexi.face.A5,
            head = cexi.model.TACTICIAN_MAGICIAN,
            body = cexi.model.TACTICIAN_MAGICIAN,
            hand = cexi.model.TACTICIAN_MAGICIANN,
            legs = cexi.model.TACTICIAN_MAGICIAN,
            feet = cexi.model.TACTICIAN_MAGICIAN,
            main = 120,
        }),
        area   = "Port_Windurst",                   -- (B-4)
        pos    = { -226.082, -8.198, 222.513, 36 }, -- !pos -226.082 -8.198 222.513 36
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "We must push back the Yagudo for the safety of all Windurstians!" },
            START    =
            {
                "Our feathered foes are overstepping their bounds.",
                " They've been coming closer and closer to our borders.",
                { emote = xi.emote.THINK },
                { delay = 2000 },
                "We must push back the Yagudo for the safety of all Windurstians.",
                " Disruptaru them and present twelve yagudo feathers as proof.",
            },
            ACCEPTED =
            {
                { emote = xi.emote.SALUTE },
                "This is progress but Many more Yagudo lie at our border.",
                { delay = 1000 },
                "So far you've brought me %u feathers.",
                " Keep up the excellentaru work!",
            },
            DECLINED =
            {
                "Now is notaru the time for foolish pranks!"
            },
            REMINDER =
            {
                { emote = xi.emote.PANIC },
                "We must push back the Yagudo for the safety of all Windurstians.",
                " Disruptaru them and present twelve yagudo feathers as proof.",
            },
        },
    },
}

local step =
{
    {
        check   = cq.checks({ CW = true, level = 5 }),
        [PULU] = cq.talkStep("START", info.name),
    },
    {
        [PULU] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeOnly("ACCEPTED", "DECLINED", info.required.item, info.reward, info.counter, 12, info.name, cexi.music.WINDURST),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
