-----------------------------------
-- Reaping Rewards (Lv5)
-----------------------------------
-- !setvar [CW]REAPING_REWARDS 0
-- Fha Mhakyaa !pos -162.120 -16.658 -93.217 115
-- !additem 5739
-- Reward: Sickle x12
-----------------------------------
-- !setvar [CW]REAPING_REWARDS 2

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-reaping_rewards")

local info =
{
    name   = "Reaping Rewards",
    author = "Loxley",
    var    = "[CW]REAPING_REWARDS",
    reward =
    {
        item  = { { xi.item.SICKLE, 36 } },
        after = function(player)
            cq.rewardSlots(player, { xi.inv.WARDROBE4, 1 })
            cq.fieldTunica(player)

            return true
        end,
    },
    required = 
    {
        item = 5739,
        name = "a mug of honeyed egg",
    },
}

local MITHRA = "MITHRA"
local Fha    = "Fha Mhakyaa"

local entity =
{
    {
        id     = MITHRA,
        name   = "Fha Mhakyaa",
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.MITHRA,
            face = cexi.model.A2,
            head = cexi.model.ROBE,
            body = cexi.model.ROBE,
            hand = cexi.model.STARTER_RSE,
            legs = cexi.model.STARTER_RSE,
            feet = cexi.model.STARTER_RSE,
        }),
        area   = "West_Sarutabaruta",
        pos    = { -162.120, -16.658, -93.217, 23 }, -- !pos -162.120 -16.658 -93.217 115
        dialog =
        {
            NAME     = true,
            DEFAULT  =
            {
                "G~rrreetings strrranger.",
            },
            START  =
            {
                { entity = Fha, emote = xi.emote.HARVESTING },
                { delay  = 2000 },
                "G~rrreetings strrranger.",
                " I'm out here harvesting ingrrredients for a poultice.",
                string.format("It's been a verrr~y long day and I would love %s.", info.required.name),
                { entity = Fha, emote = xi.emote.BLUSH },
                "If you bring me one, I'll share some of my sickles.",
                { delay  = 500 },
            },
            REMINDER =
            {
                string.format("Brrr~ing me %s and I'll sharrre some sickles.",  info.required.name),
                { entity = Fha, emote = xi.emote.HARVESTING },
                { delay  = 2000 },
            },
            ACCEPTED =
            {
                { entity = Fha, emote = xi.emote.PRAISE},
                "Mmmm... grrreat! Here arrr~e your sickles.",
                { delay  = 500 },
            },
            DECLINED =
            {
                { entity = Fha, emote = xi.emote.NO },
                "Sorry but my diet is verrr~y particular.",
                { delay  = 500 },
            },
            AFTER =
            {
                "I'm harrr~d at work out here.",
                { entity = Fha, emote = xi.emote.HARVESTING },
                { delay  = 2000 },
            },
        },
    },
}

local step =
{
    {
        check    = cq.checks({ CW = true, level = 5 }),
        [MITHRA] = cq.talkStep("START", info.name),
    },
    {
        [MITHRA] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeStep("ACCEPTED", "DECLINED", info.required.item, info.reward, info.name, cexi.music.SARUTABARUTA),
        }
    },
    {
        [MITHRA] = cq.talkOnly("AFTER"),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
