-----------------------------------
-- Only the Dose (Lv1)
-----------------------------------
-- !setvar [CW]ONLY_THE_DOSE 0
-- !setvar [CW]GIANT_STINGERS 0
-- Perah Celehsi !pos 62.262 -4.250 35.154 241
-- !additem 925
-- Rewards: 300g
-----------------------------------
-- !setvar [CW]ONLY_THE_DOSE 1

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-only_the_dose")

local info =
{
    name    = "Only the Dose",
    author  = "Loxley",
    var     = "[CW]ONLY_THE_DOSE",
    counter = "[CW]GIANT_STINGERS",
    reward  =
    {
        gil = 300,
    },

    required =
    {
        item = { { 925, 1 } },
        name = "a giant stinger",
    },
}

local PERAH        = "PERAH"
local PerahCelehsi = "Perah Celehsi"

local entity =
{
    {
        id     = PERAH,
        name   = PerahCelehsi,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.MITHRA,
            face = cexi.face.B2,
            head = cexi.model.LEATHER_VEST,
            body = cexi.model.KENPOGI,
            hand = cexi.model.BRONZE_HARNESS,
            legs = cexi.model.LEATHER_VEST,
            feet = cexi.model.BRONZE_HARNESS,
            main = 120,
            offh = 120,
        }),
        area   = "Windurst_Woods",                -- (J-8)
        pos    = { 69.424, -4.250, 35.333, 170 }, -- !pos 69.424 -4.250 35.333 241
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "I'm sho~rrrt on supplies..." },
            START    =
            {
                { emote = xi.emote.THINK },
                "I make verrr~y special medicine but... I'm sho~rrrt on supplies.",
                " Collect giant stingerrrs and I'll pay 300 gil a piece."
            },
            ACCEPTED =
            {
                { emote = xi.emote.YES },
                "Yes, this is what I need. That makes %u giant stingerrrs.",
                "Brrrring more and I'll pay.",
            },
            DECLINED =
            {
                { emote = xi.emote.PANIC },
                "What's this? I need very pa~rrrticular materials for my worrrrk."
            },
        },
    },
}

local step =
{
    {
        check   = cq.checks({ CW = true }),
        [PERAH] = cq.talkStep("START", info.name),
    },
    {
        [PERAH] =
        {
            onTrigger = cq.talkOnly("START"),
            onTrade   = cq.tradeOnly("ACCEPTED", "DECLINED", info.required.item, info.reward, info.counter, 1, info.name, cexi.music.WINDURST),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
