-----------------------------------
-- Neck and Neck (Lv10)
-- Neck and Neck II (Lv12)
-----------------------------------
-- !setvar [CW]NECK_AND_NECK 0
-- !setvar [CW]PAPAKA 0
-- Erbelie       !pos -28.726 -4.152 59.257 241
-- Dhalmel Bones !pos 222.800 -21.077 597.115 115
-- Reward: 1500 gil
-----------------------------------
-- Erbelie       !pos -28.726 -4.152 59.257 241
-- !additem 938 3
-- Reward: 600 gil
-----------------------------------
-- !setvar [CW]NECK_AND_NECK 5

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-neck_and_neck")

local info =
{
    name    = "Neck and Neck",
    author  = "Loxley",
    var     = "[CW]NECK_AND_NECK",
    counter = "[CW]PAPAKA",

    reward1 =
    {
        gil = 1500,
    },

    reward  =
    {
        gil = 600,
    },

    required =
    {
        item = { { 938, 3 } },
        name = "three sprigs of papaka grass",
    },
}

local ERBE         = "ERBE"
local Erbelie      = "Erbelie"
local GHOST        = "GHOST"
local BONES        = "BONES"
local DhalmelBones = "Dhalmel Bones"

local entity =
{
    {
        id     = ERBE,
        name   = Erbelie,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.ELVAAN_F,
            face = cexi.face.B2,
            head = cexi.model.NOTHING,
            body = cexi.model.LIZARD_JERKIN,
            hand = cexi.model.LIZARD_JERKIN,
            legs = cexi.model.LIZARD_JERKIN,
            feet = cexi.model.LIZARD_JERKIN,
        }),
        area   = "Windurst_Woods",                -- (G-8)
        pos    = { -28.726, -4.152, 59.257, 228}, -- !pos -28.726 -4.152 59.257 241
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "Fascinating, aren't they?" },
            START    =
            {
                { emote = xi.emote.THINK },
                "Fascinating, aren't they?",
                " It's said Dhalmels roamed northern Sarutabaruta before the great war",
                { delay = 2000 },
                "I'd sure like to see some evidence though. Could you help me?",
            },
            BEGIN = { "Thank you. Let me know what you find." },
            AFTER =
            {
                { emote = xi.emote.SHOCKED },
                "You found what!? Oh my... Thanks for looking into this.",
                " From now on, I think I'll stick to admiring the ones we have here!",
                { delay = 2000 },
                "Hmmm... Their favorite treat is papaka grass. Maybe you could find some.",
            },
            REMINDER =
            {
                "A dhalmel's favorite treat is papaka grass.",
                " Collect three sprigs and I'll pay.",
            },
            ACCEPTED =
            {
                { emote = xi.emote.BOW },
                "Thanks for bringing these. That makes %u sprigs.",
                " If you find any more, I'll gladly pay for them.",
            },
        },
    },
    {
        id       = BONES,
        name     = DhalmelBones,
        marker   = cq.SIDE_QUEST,
        area     = "West_Sarutabaruta",
        pos      = { 222.800, -21.077, 597.115, 153 }, --!pos 222.800 -21.077 597.115 115
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        },
    },
    {
        id          = GHOST,
        name        = "Ghost Dhalmel",
        type        = xi.objType.MOB,
        look        = 332,
        groupId     = 16,
        groupZoneId = 118,
        area        = "West_Sarutabaruta",
        pos         = { 222.800, -21.077, 597.115, 153 }, --!pos 222.800 -21.077 597.115 115
        level       = 7,
    },
}

local step =
{
    {
        check   = cq.checks({ CW = true, level = 10 }),
        [ERBE] = cq.talkStep("START"),
    },
    {
        [ERBE] = cq.menuStep("Dhalmels in Sarutabaruta?", { { "I don't believe in nonsense." }, { "Let's neck it out.", "BEGIN" },  }, 2, info.name ),
    },
    {
        [BONES] = cq.menuSpawn(GHOST, "Look closer?", { { "No." }, { "Yes." } }, 2),
        [GHOST] = cq.killStep(BONES),
    },
    {
        [BONES] = cq.talkOnly("AFTER"),
        [ERBE]  = cq.giveStep("AFTER", info.reward1, info.name, cexi.music.WINDURST),
    },
    {
        check  = cq.checks({ CW = true, level = 12 }),
        [ERBE] = cq.talkStep("REMINDER", info.name .. " II"),
    },
    {
        [ERBE] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeOnly("ACCEPTED", "REMINDER", info.required.item, info.reward, info.counter, 3, info.name .. " II", cexi.music.WINDURST),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
