-----------------------------------
-- Give Me a Ring (Lv1)
-----------------------------------
-- !setvar [CW]GIVE_ME_A_RING 0
-- Moyeyo       !pos 131.679 -5.000 -98.182 241
-- Dim Sparkle  !pos 34.598 0.000 245.517 239
-- Moyeyo       !pos 131.679 -5.000 -98.182 241
-- Abu Dabudabu !pos 10.471 -2.500 -15.412 241
-- Reward: Windurstian Ring
-----------------------------------
-- !setvar [CW]GIVE_ME_A_RING 4

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-give_me_a_ring")

local info =
{
    name   = "Give Me a Ring",
    author = "Loxley",
    var    = "[CW]GIVE_ME_A_RING",
    reward =
    {
        item = 13496, -- Windurstian Ring
    },
}

local TARU_1    = "TARU_1"
local TARU_2    = "TARU_2"
local Moyeyo    = "Moyeyo"
local Abu       = "Abu Dabudabu"
local LOST_RING = "LOST_RING"

local entity =
{
    {
        id       = TARU_1,
        name     = Moyeyo,
        type     = xi.objType.NPC,
        look     = "0x010006060000AB01080003000800000000000000",
        area     = "Windurst_Woods",
        pos      = { 131.679, -5.000, -98.182, 90 }, -- !pos 131.679 -5.000 -98.182 241
        dialog   =
        {
            NAME     = true,
            DEFAULT  =
            {
                { emote = xi.emote.SIGH },
                "Oh no, this just won't do!",
            },
            START  =
            {
                { emote = xi.emote.FUME },
                "Oh no, this just won't do! I've lost my ring!!~",
                { delay = 2000 },
                { emote = xi.emote.HUH },
                "You're heading to Windurst Walls?",
                " I was travelling to meet someone and I was so distracted...",
                { delay = 1000 },
                { emote = xi.emote.BLUSH },
                " The ring slipped from my hands was swept away up stream.",
                "Maybe it washed up somewhere. Please let me know if you find my ring!",
            },
            REMINDER = { "Did you find my ring?" },
            FOUND =
            {
                { emote = xi.emote.SURPRISED },
                "This is the one... I can't believe you found it!",
                { delay = 3000 },
                "Well you see, actually this isn't for me.",
                " It was a gift for my love to be.",
                { emote = xi.emote.BLUSH },
                " I couldn't possibly... but I...",
                { delay = 2000 },
                { emote = xi.emote.THINK },
                "I would be ever so grateful if you delivered it on my behalf.",
                " Please take the ring to Abu Dabudabu. He's usually around the Manustery.",
            },
            REMINDER_2 = { "Please take the ring to Abu Dabudabu. He's usually around the Manustery." },
            AFTER      = { "Thank you for helping me." },
        },
    },
    {
        id     = LOST_RING,
        name   = "Dim Sparkle",
        marker = cq.SIDE_QUEST,
        area   = "Windurst_Walls",
        pos    = { 34.598, 0.000, 245.517, 0 }, --!pos 34.598 0.000 245.517 239
        dialog =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            FOUND   =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion = "digs in the dirt and finds Moyeyo's ring!" },
            },
        }
    },
    {
        id       = TARU_2,
        name     = Abu,
        type     = xi.objType.NPC,
        look     = "0x01000F050010032008300A400850006000700000",
        area     = "Windurst_Woods",
        pos      = { 10.471, -2.500, -15.412, 170 }, -- !pos 10.471 -2.500 -15.412 241
        dialog   =
        {
            NAME     = true,
            DEFAULT  = { "I don't have anything for you." },
            ACCEPTED =
            {
                { emote = xi.emote.HUH },
                "For me? Surely you're mistaken.",
                { delay = 2000 },
                { emote = xi.emote.THINK },
                "A gift? From Meyoyo? I see. Thank you for bringing this to me...",
                { delay = 3000 },
                "I should wear Meyoyo's new gift.",
                { emote = xi.emote.YES },
                " Guess I won't be needing this old trinket anymore.",
                "Please take it for your trouble.",
            },
            DECLINED = { "Sorry, but this isn't mine." },
            AFTER    = { "Thank you. I can't wait to tell Meyoyo how I really feel!" },
        },
    },
}

local step =
{
    {
        check    = cq.checks({ CW = true }),
        [TARU_1] = cq.talkStep("START", info.name),
    },
    {
        [TARU_1]    = cq.talkOnly("REMINDER"),
        [LOST_RING] = cq.menuStep("Investigate further?", { { "No" }, { "Yes", "FOUND" } }, 2 ),
    },
    {
        [LOST_RING] = cq.talkOnly("AFTER"),
        [TARU_1]    = cq.talkStep("FOUND"),
    },
    {
        [TARU_1] = cq.talkOnly("REMINDER_2"),
        [TARU_2] = cq.giveStep("ACCEPTED", info.reward, info.name, cexi.music.WINDURST),
    },
    {
        [TARU_1] = cq.talkOnly("AFTER"),
        [TARU_2] = cq.talkOnly("AFTER"),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
