-----------------------------------
-- Crystal Prelude (Windurst) (Lv1)
-----------------------------------
-- !setvar [CW]INTRO 2
-- Erudu-Faludu   !pos 143.855 13.000 -15.370 169
-- Dangling Roots !pos 98.867 16.000 -50.251 169
-- Erudu-Faludu   !pos 143.855 13.000 -15.370 169
-----------------------------------
-- !setvar [CW]INTRO 2

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-crystal_prelude_windurst")

local info =
{
    name   = "A Crystal Prelude (Windurst)",
    author = "Loxley",
    var    = "[CW]INTRO",
    start  = { 180.019, 8.500, 22.654, 64, xi.zone.TORAIMARAI_CANAL },
    reward =
    {
        item  = xi.item.ADVENTURER_COUPON,
        after = function(player)
            player:timer(1000, function(playerArg)
                local endPos = { 141.004, -15.049, -405.378, 132, xi.zone.EAST_SARUTABARUTA } -- !pos 141.004 -15.049 -405.378 116

                playerArg:setHomePointAt(unpack(endPos))
                playerArg:setPos(unpack(endPos))
            end)

            return true
        end,
    },
}

local ERUDU       = "ERUDU"
local EruduFaludu = "Erudu-Faludu"
local ROOT        = "ROOT"
local BOOK        = "BOOK"

local entity =
{
    {
        id   = ERUDU,
        name = EruduFaludu,
        type = xi.objType.NPC,
        look = cexi.util.look({
            race = xi.race.TARU_M,
            face = cexi.face.A6,
            head = cexi.model.TUNIC,
            body = cexi.model.TUNIC,
            hand = cexi.model.TUNIC,
            legs = cexi.model.TUNIC,
            feet = cexi.model.TUNIC,
        }),
        area = "Toraimarai_Canal",
        pos  = { 145.567, 13.000, -14.182 }, -- !pos 145.567 13.000 -14.182 169
        dialog =
        {
            NAME    = true,
            DEFAULT = { "Excuse me. I-I'm on very importantaru business!" },
            CREATURE =
            {
                { emote = xi.emote.SHOCKED },
                "You're ready to leave? B-But I can't leave without that book!",
                { delay = 2000 },
                " You'll stay to help me find it, right? It must be around here somewhere...",
            },
            ESCAPE =
            {
                "That was a real page turner! Let's close this one and head out.",
                { delay  = 1000 },
                { entity = EruduFaludu, packet = "cabk" },
                " As a token of my gratitude, please take this adventurer coupon.",
                " You can exchange it back in Windurst.",
                { delay  = 3000 },
                { entity = EruduFaludu, packet = "shbk" },
            },
            SPAWN    = { "I've f-found the book! I mean HELP!!" },
        },
    },
    {
        id       = ROOT,
        name     = "Harvest. Point",
        type     = xi.objType.NPC,
        look     = 2422,
        item     = { xi.item.REVIVAL_TREE_ROOT, "a revival tree root" },
        area     = "Toraimarai_Canal",
        pos      = { 98.867, 16.000, -50.251 }, -- !pos 98.867 16.000 -50.251 169
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE
        },
    },
    {
        id          = BOOK,
        name        = "Dusty Tome",
        type        = xi.objType.MOB,
        look        = 2228,
        groupId     = 67,
        groupZoneId = 289,
        area        = "Toraimarai_Canal",
        pos         = { 139.770, 13.000, -24.397, 0 }, -- !pos 139.770 13.000 -24.397 169
        level       = 1,
        mods        =
        {
            [xi.mod.HPP] = -70,
        },
    },
}

local hint = cexi.crystal_warrior.intro.getHints({
    npc      = EruduFaludu,
    city     = "Windurst",
    tool     = "Sickle",
    gather   = "Harvesting",
    material = "a revival tree root",
    point    = "Harvest. Point",
    ringNpc  = "Moyeyo",
    ringZone = "Windurst Woods",
})

cexi.crystal_warrior.intro.setNextZone(m, "East_Sarutabaruta", hint, info.start)

local step =
{
    {
        -- Placeholder step for Provenance Intro
    },
    {
        -- Placeholder step for Provenance Intro
    },
    {
        checks  = cq.checks({ cw = true }),
        [ERUDU] = cq.dialog({
            beginQuest = info.name,
            reward     = { { xi.item.SICKLE, 12 } },
            name       = EruduFaludu,
            event      =
            {
                { emote = xi.emote.PANIC },
                "What! Who are you? M-Me? What? I Uhh...",
                { delay = 2000 },
                { emote = xi.emote.HUH },
                { delay = 1000 },
                " The Manustery! I-I've been sent here by the Manustery. Yes, of Windurst. On a very importantaru mission!",
                { delay = 2000 },
                "C-Came here in search of... a certain book but now~",
                { emote = xi.emote.THINK },
                { delay = 3000 },
                " I seem to have misplaced my staff! If only I could... Hmmm",
                { emote = xi.emote.THINK },
                { delay = 3000 },
                "There are some tree roots nearby. If only I had one, I could make it into something r-really dangerous!",
                " Where exactly? Hmm...",
                { emote = xi.emote.HUH },
                "First exit the Animastery through this door, then go down the steps... It-t's a bitaru scary down there!",
                " When you're in the b-big scary-wary room, go up the stairs and look for a Harvesting Point!",
                hint[1],
            },
        }),
    },
    {
        [ERUDU]  = cq.dialog({
            step  = false,
            name  = EruduFaludu,
            event = { "There are tree roots down in the hall. Harvest it using one those sickles I gave you!" },
        }),
        [ROOT] =
        {
            onTrigger = cq.dialog({
                step  = false,
                event = { "Harvesting is possible here if you have a sickle." },
            }),
            onTrade = cq.trade({
                required = xi.item.SICKLE,
                reward   = xi.item.REVIVAL_TREE_ROOT,
                accepted =
                {
                    { entity = "player", emote = xi.emote.HARVESTING },
                    hint[2],
                },
                declined = { "Harvesting is possible here if you have a sickle." },
            }),
        },
    },
    {
        [ROOT]  = cq.talkOnly("AFTER"),
        [ERUDU] =
        {
            onTrigger = cq.dialog({
                step  = false,
                name  = EruduFaludu,
                event = { "Quickly, hand me that revival tree root!" },
            }),
            onTrade   = cq.trade({
                name     = EruduFaludu,
                required = xi.item.REVIVAL_TREE_ROOT,
                declined = { "Quickly, hand me that revival tree root!" },
                accepted =
                {
                    "That's it! One moment...",
                    { emote = xi.emote.THINK },
                    hint[3],
                },
            }),
        },
    },
    {
        [ERUDU] = cq.dialog({
            conditionalDialog = "job",
            conditionalReward = "job",

            name   = EruduFaludu,
            reward =
            {
                [xi.job.WAR] = { { xi.item.ONION_SWORD,  1 } },
                [xi.job.MNK] = { { xi.item.WHITE_BELT,   1 } },
                [xi.job.WHM] = { { xi.item.ONION_ROD,    1 }, { xi.item.SCROLL_OF_CURE,  1 } },
                [xi.job.BLM] = { { xi.item.ONION_STAFF,  1 }, { xi.item.SCROLL_OF_STONE, 1 } },
                [xi.job.RDM] = { { xi.item.ONION_DAGGER, 1 }, { xi.item.SCROLL_OF_DIA,   1 } },
                [xi.job.THF] = { { xi.item.ONION_KNIFE,  1 } },
            },
            event =
            {
                [xi.job.WAR] =
                {
                    "No discernable traces of magic, it's no good.",
                    { emote = xi.emote.NO },
                    " H-However! I found this rusty piece of junk stowed away back there.",
                    { delay = 2000 },
                    { emote = xi.emote.TOSS },
                    "Take this and stand guard while I keep searching.",
                    hint[4],
                },

                [xi.job.MNK] =
                {
                    "Well this root is s-simply useless!",
                    " But uhh... I found this rag behind the bookshelf.",
                    { delay = 3000 },
                    { emote = xi.emote.TOSS },
                    "Take it and use those big arms to help me dust off these covers.",
                    hint[4],
                },

                [xi.job.WHM] =
                {
                    "Well this root is s-simply useless!",
                    " However, while I was searching this fell down and hit me on the head!",
                    { delay = 3000 },
                    { emote = xi.emote.TOSS },
                    "Y-You can heal me, right?",
                    hint[4],
                },

                [xi.job.BLM] =
                {
                    "I can work with this. Here it comes...",
                    { delay = 1000 },
                    " ...",
                    { delay = 1000 },
                    " ....",
                    { delay = 1000 },
                    " .....",
                    { delay = 1000 },
                    { emote = xi.emote.TOSS },
                    "BOOM!",
                    hint[4],
                },

                [xi.job.RDM] =
                {
                    "Well this root is s-simply useless!",
                    " F-Fortunately, while you were gone, I found this inside a grimoire.",
                    { emote = xi.emote.TOSS },
                    hint[4],
                },

                [xi.job.THF] =
                {
                    "Well this root is s-simply useless!",
                    " F-Fortuantely, while you were gone, I found this hiding between the pages.",
                    { emote = xi.emote.TOSS },
                    hint[4],
                },
            },
        }),
    },
    {
        [ERUDU] = cq.menuSpawn(BOOK, { "CREATURE", "Agree to help?" }, { { "Not yet." }, { "I'm ready.", "SPAWN" }  }, 2, false ),
        [BOOK]  = cq.killStep(),
    },
    {
        [ERUDU] = cq.giveStep("ESCAPE", info.reward, info.name, cexi.music.NONE),
    },
    {
        [ERUDU] = cq.dialog({
            step  = false,
            name  = EruduFaludu,
            event = { "Now where did I put that book?..." },
        }),
    },
    {
        [ERUDU] = cq.dialog({
            step  = false,
            name  = EruduFaludu,
            event = { "Now where did I put that book?..." },
        }),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
