-----------------------------------
-- A Matter of Trust (Windurst)     (Lv15)
-- A Matter of Trust (Windurst) II  (Lv25)
-- A Matter of Trust (Windurst) III (Lv40)
-----------------------------------
-- !setvar [CW]TRUST_WINDURST 0
-- Sharara !pos 114.5 -11 171 239
-- Anomaly !pos 189.35 48.41 480 117
-- Sharara !pos 114.5 -11 171 239
-----------------------------------
-- !setvar [CW]TRUST_WINDURST 5
-- Sharara       !pos 114.5 -11 171 239
-- Odd Emanation !pos -98.322 -0.867 -103.188 198
-- Sharara       !pos 114.5 -11 171 239
-----------------------------------
-- !setvar [CW]TRUST_WINDURST 11
-- Sharara       !pos 114.5 -11 171 239
-- !additem 546
-- Low Point     !pos 19.911 40.250 -21.485 151
-- Sharara       !pos 114.5 -11 171 239
-----------------------------------
-- !setvar [CW]TRUST_WINDURST 16

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
require('scripts/zones/West_Sarutabaruta/npcs/Twinkle_Tree')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-a_matter_of_trust_windurst")

local info =
{
    name   = "A Matter of Trust (Windurst)",
    author = "Yve",
    var    = "[CW]TRUST_WINDURST",
    reward =
    {
        item    = 12729,    -- Linen Cuffs (Lv12)
        augment = { 9, 9 }, -- MP +10
        after   = function(player)
            cq.rewardSlots(player, { xi.inv.WARDROBE4, 1 })
            cq.rewardTrust(player, 904, "Ajido-Marujido", 1)

            return true
        end,
    },

    reward2 =
    {
        item    = 12993,            -- Sandals (Lv20)
        augment = { 9, 9, 518, 1 }, -- MP +10, CHR +2
        after   = function(player)
            cq.rewardSlots(player, { xi.inv.WARDROBE4, 2 })
            cq.sprinterShoes(player)

            return true
        end,
    },

    required3 = 
    {
        item = 546, -- Starfall Tear
    },

    reward3 =
    {
        item    = 13625,                      -- Tundra Mantle (lv39)
        augment = { 517, 1, 518, 1, 141, 1 }, -- MND +2, CHR +2, Conserve MP +2
        keyitem =
        {
            xi.ki.WINDURST_TRUST_PERMIT,
            xi.ki.GREEN_INSTITUTE_CARD,
        },
        after   = function(player)
            cq.rewardSlots(player, { xi.inv.WARDROBE4, 2 })
            cq.rewardTrust(player, 898, "Kupipi", 2)

            return true
        end,
    },
}

local SHARARA_1   = "SHARARA_1"
local SHARARA_2   = "SHARARA_2"
local ANOMALY     = "ANOMALY"
local WEAPON      = "WEAPON"

local LOST_ITEM   = "LOST_ITEM"
local SPARE       = "SPARE"

local Sharara     = "Sharara"
local Ajido       = "Ajido-Marujido"

local LOW_POINT   = "LOW_POINT"
local SAGE_1      = "SAGE_1"
local SAGE_2      = "SAGE_2"
local KOGA_1      = "KOGA_1"
local KOGA_2      = "KOGA_2"
local Kupipi      = "Kupipi"

local shararaLook = cexi.util.look({
    race = xi.race.TARU_F,
    face = 13,
    head = 0,
    body = cexi.model.TUNIC,
    hand = cexi.model.TUNIC,
    legs = cexi.model.CLOAK,
    feet = cexi.model.TUNIC,
})

local entity =
{
    {
        id       = SHARARA_1,
        name     = Sharara,
        type     = xi.objType.NPC,
        look     = shararaLook,
        area     = "Windurst_Walls",
        pos      = { 118.900, -11.000, 172.000, 96 },-- !pos 114.5 -11 171 239
        dialog   =
        {
            NAME     = true,
            DEFAULT  =
            {
                "One day, I'll really show them!",
            },
            START    =
            {
                { emote = xi.emote.THINK },
                "Hello, I hear you are not one to lets others get in your way.",
                " Might you be interested in helping me defeat my rival?",
            },
            ACCEPT   =
            {
                { emote = xi.emote.PRAISE },
                "Wonderful! He has been investigating the anomalies in Tahrongi Canyon.",
                { delay = 2000 },
                "If we can find some answers before he does...",
                " he'll surely acknowledge my- uh our superiority.",
                { emote = xi.emote.LAUGH },
            },
            REMINDER = { "Please meet me by the Crag of Mea." },
            FINISH   =
            {
                { emote = xi.emote.SIGH },
                "Thank you for your effort.",
                { delay = 2000 },
                "One day, I will show him who is really Number Two!",
            },
            AFTER    = { "I may be in need your assistance again soon." },

            PART2_START =
            {
                { emote = xi.emote.STAGGER },
                "I'm up to my eyeballs in work just now...",
                " I would really appreciate a little assistance.",
                { delay = 2000 },
                "There's something in it for you, of course.",
            },

            PART2_ACCEPT =
            {
                "Excellent! There are odd emanations appearing in The Maze of Shakhrami.",
                { delay = 1000 },
                "I need you to take some readings to identify the source of the disturbance.",
                { emotion = "receives Sharara's reading device." },
            },

            PART2_REMINDER = { "Please find the source of the odd emanations in The Maze of Shakhrami." },

            PART2_FINISH   =
            {
                { emote = xi.emote.SHOCKED },
                "A Cardian!? In Shakhrami? How very interesting.",
                { delay = 1000 },
                { emote = xi.emote.THINK },
                { delay = 2000 },
                "Thank you for these readings. I can finally finish my project!",
                { delay = 2000 },
                "Here, take these, you deserve them and more.",
            },

            PART2_AFTER    = { "Thanks for helping me out." },

            PART3_START    =
            {
                "I'm almost set! I just need a catalystaru to finish this formula.",
                { emote = xi.emote.THINK },
                " A starfall tear should be exactly perfect...",
                { delay = 2000 },
                "Would you retrieve one and aid in the triumph?",
            },

            PART3_REMINDER1 = { "Would you retrieve a starfall tear and aid in this triumph?" },

            PART3_ACCEPTED =
            {
                "Brilliantaru! Now let's take this to Castle Oztroja and try it out!",
                { delay = 1000 },
                "We'll need somewhere dark enough for this work. Let's meet at a lower level.",
            },

            PART3_REMINDER2 = { "Meet me deep down at a low point in Castle Oztroja." },

            PART3_FINISH =
            {
                "Under Kupipi's guidance, I've perfected my recipe.",
                { emote = xi.emote.LAUGH },
                { delay = 2000 },
                " Thank you for your part. You've earned this. ",
                { emote = xi.emote.BOW },
            },
        },
    },
    {
        id     = ANOMALY,
        name   = "Crystal Anomaly",
        marker = cq.MAIN_QUEST,
        area   = "Tahrongi_Canyon",
        pos    = { 186.714, 48.418, 479.838, 0 }, -- !pos 189.35 48.41 480 117
        dialog =
        {
            DEFAULT    = cq.NOTHING,
            AFTER      = cq.NOTHING_ELSE,
            FINISH  =
            {
                { music = cexi.music.SOMETIME_SOMEWHERE },
                { despawn   = { "Crystal Anomaly" } },
                { spawn = { Sharara } },
                { delay = 2000 },
                "Sharara : Looks like I missed the fun part.",
                " That weapon dropped a faded crystal? Very strange.",
                { entity = Sharara, emote = xi.emote.THINK },
                { delay = 2000 },
                { spawn = { Ajido } },
                { delay = 3000 },
                { entity = Ajido, face = Sharara },
                "Ajido-Marujido : Ah ha! Investigating too, are you, Number Two?",
                { entity = Sharara, face = Ajido },
                " You'll have to do better than that to keep up with me.",
                { entity = Sharara, emote = xi.emote.FUME },
                { delay = 3000 },
                { entity = Ajido, face = "player" },
                "Ajido-Marujido : And you, adventurer, you seem keen to help random pretty faces.",
                " do you have nothing better to do?",
                { delay = 3000 },
                { entity = Ajido, packet = "cabk" },
                "Ajido-Marujido : Maybe I'll see you later, when the great Ajido-Marujido saves the day!",
                { delay  = 3000 },
                { entity = Ajido, packet = "shbk" },
                { delay  = 3000 },
                -- TODO: Warp out effect
                { despawn = { Sharara, Ajido } },
                { spawn   = { "Crystal Anomaly" } },
                { music   = 0 },
            },
        },
    },
    {
        id     = "SHARARA_1",
        name   = Sharara,
        type   = xi.objType.NPC,
        hidden = true,
        look   = shararaLook,
        area   = "Tahrongi_Canyon",
        pos    = { 191.399, 48.081, 477.076, 146 }, -- !pos 189.35 48.41 480 117
    },
    {
        id     = "AJIDO",
        name   = Ajido,
        type   = xi.objType.NPC,
        hidden = true,
        look   = 74,
        area   = "Tahrongi_Canyon",
        pos    = { 192.256, 48.011, 483.470, 103 }, -- !pos 189.35 48.41 480 117
    },
    {
        id          = WEAPON,
        name        = "Crystal Weapon",
        type        = xi.objType.MOB,
        look        = 451,
        groupId     = 7,
        groupZoneId = 126,
        level       = 13,
        area        = "Tahrongi_Canyon",
        pos         = { 186.714, 48.418, 479.838, 0 }, -- !pos 189.35 48.41 480 117
    },

    -- For Part 2
    {
        id          = LOST_ITEM,
        name        = "Odd Emanation",
        marker      = cq.MAIN_QUEST,
        area        = "Maze_of_Shakhrami",
        pos         = { -98.322, -0.867, -103.188, 154 }, --!pos -98.322 -0.867 -103.188 198
        dialog      =
        {
            DEFAULT    = cq.NOTHING,
            AFTER      = cq.NOTHING_ELSE,
            FOUND   =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion = "takes some readings with Sharara's device." },
            },
        }
    },
    {
        id          = SPARE,
        name        = "Spare One",
        type        = xi.objType.MOB,
        look        = 431,
        groupId     = 17,
        groupZoneId = 194,
        area        = "Maze_of_Shakhrami",
        pos         = { -98.322, -0.867, -103.188, 154 }, --!pos -98.322 -0.867 -103.188 198
        widescan    = 1,
        level       = 22,
    },

    -- For Part 3
    {
        id     = "SHARARA_2",
        name   = Sharara,
        type   = xi.objType.NPC,
        hidden = true,
        look   = shararaLook,
        area   = "Castle_Oztroja",
        pos    = { 21.371, 40.250, -25.480, 173 }, -- !pos 21.371 40.250 -25.480 151
    },
    {
        id     = "KUPIPI",
        name   = Kupipi,
        type   = xi.objType.NPC,
        hidden = true,
        look   = "0x0100000600101320133013401350006000700000",
        area   = "Castle_Oztroja",
        pos    = { 16.967, 40.176, -27.589, 199 }, --!pos 16.967 40.176 -27.589 151
    },
    {
        id     = "AJIDO_2",
        name   = Ajido,
        type   = xi.objType.NPC,
        hidden = true,
        look   = 74,
        area   = "Castle_Oztroja",
        pos    = { 17.689, 38.750, -47.988, 196 }, -- !pos 17.689 38.750 -47.988 151
    },
    {
        id          = LOW_POINT,
        name        = "Low Point",
        marker      = cq.MAIN_QUEST,
        area        = "Castle_Oztroja",
        pos         = { 19.911, 40.250, -21.485, 64 }, --!pos 19.911 40.250 -21.485 151
        dialog      =
        {
            DEFAULT    = cq.NOTHING,
            AFTER      = cq.NOTHING_ELSE,
            CUTSCENE   =
            {
                { music   = 163 },
                { despawn = { "Low Point" } },
                { spawn   = { Kupipi, Ajido, Sharara, "Staggered_Sage", "Staggered_Koga" } },
                { delay   = 3000 },
                { entity  = Sharara, face = "Staggered_Sage" },
                { entity  = Sharara, emote = xi.emote.TOSS },
                "Sharara : Take that!!",
                { entity  = "Staggered_Sage", animate = 33, mode = 3 },
                { entity  = "Staggered_Sage", packet = "dead" },
                { delay   = 3000 },

                { entity = Sharara, face = "Staggered_Koga" },
                { entity = Sharara, emote = xi.emote.TOSS },
                "Sharara : And that!",
                { entity = "Staggered_Koga", animate = 33, mode = 3 },
                { entity = "Staggered_Koga", packet = "dead" },
                { delay  = 3000 },

                { entity = Kupipi, face = Sharara },

                { entity = Sharara, emote = xi.emote.TOSS },
                "Sharara : And that!",
                { entity = "Staggered_Sage", animate = 33, mode = 3 },
                { delay  = 3000 },

                { entity = Kupipi, emote = xi.emote.FUME },
                "Kupipi : Please tell me you haven't been using rolanberries in that experiment of yours! What a wastaru!",
                { entity = Sharara, face = "Kupipi" },
                { delay  = 3000 },
                { entity = Sharara, emote = xi.emote.TOSS },
                { delay  = 1500 },
                { entity = Kupipi, animate = 33, mode = 3 },
                { entity = Kupipi, emote = xi.emote.SHOCKED },

                { delay   = 3000 },
                "Kupipi : Oh my, well, I guess I can overlook it this one time.",
                "Kupipi : Please find something else to make your potions with!",
                { entity  = Kupipi, emote = xi.emote.NO },
                { delay   = 3000 },
                " As for you, her accomplice.",
                { entity  = Kupipi, face = "player" },
                { delay   = 2000 },
                "Kupipi : I trust you would never misuse your abilities.",
                { entity  = Kupipi, emote = xi.emote.YES },
                " I'm sure you can help her find something more suitable, in the future.",
                { entity  = Sharara, emote = xi.emote.HUH },
                { delay   = 3000 },
                { despawn = { Kupipi, Ajido, Sharara, "Staggered_Sage", "Staggered_Koga" } },
                { spawn   = { "Low Point" } },
                { music   = 0 },
            },
        },
    },

    {
        id          = SAGE_1,
        name        = "Yagudo Sage",
        type        = xi.objType.MOB,
        look        = 596,
        groupId     = 7,
        groupZoneId = 151,
        area        = "Castle_Oztroja",
        pos         = { 16.890, 40.161, -20.739, 33 }, --!pos 16.890 40.161 -20.739 151
        level       = 45,
    },
    {
        id          = KOGA_1,
        name        = "Yagudo Koga",
        type        = xi.objType.MOB,
        look        = 588,
        groupId     = 6,
        groupZoneId = 151,
        area        = "Castle_Oztroja",
        pos         = { 23.407, 40.102, -20.533, 90 }, --!pos 23.407, 40.102, -20.533 151
        level       = 45,
    },
    {
        id          = SAGE_2,
        name        = "Staggered Sage",
        type        = xi.objType.NPC,
        hidden      = true,
        look        = 596,
        area        = "Castle_Oztroja",
        pos         = { 16.890, 40.161, -20.739, 33 }, --!pos 16.890 40.161 -20.739 151
    },
    {

        id          = KOGA_2,
        name        = "Staggered Koga",
        type        = xi.objType.NPC,
        hidden      = true,
        look        = 588,
        area        = "Castle_Oztroja",
        pos         = { 23.407, 40.102, -20.533, 90 }, --!pos 23.407, 40.102, -20.533 151
    },
}

-- Allow Starfall Tear to always be collected
m:addOverride("xi.zones.West_Sarutabaruta.npcs.Twinkle_Tree.onTrade", function(player, npc, trade)
    if
        npcUtil.tradeHasExactly(trade, 868) and -- Pugil Scales
        VanadielHour() <= 3
    then
        if npcUtil.giveItem(player, 546) then -- Starfall Tear
            player:confirmTrade()
        end

    else
        super(player, npc, trade)
    end
end)

local yagudoSages = { SAGE_1, KOGA_1 }

local step =
{
    {
        check       = cq.checks({ CW = true, level = 15 }),
        [SHARARA_1] = cq.talkStep("START"),
    },
    {
        [SHARARA_1] = cq.menuStep("Agree to help?", { { "No" }, { "Yes", "ACCEPT" } }, 2, info.name ),
    },
    {
        [SHARARA_1] = cq.talkOnly("REMINDER"),
        [ANOMALY]   = cq.menuSpawn(WEAPON, "Investigate the anomaly?", { { "Not yet." }, { "I'm ready" } }, 2, true, { levelCap = 15 }),
        [WEAPON]    = cq.killStep(ANOMALY),
    },
    {
        [ANOMALY]   = cq.talkStep("FINISH"),
    },
    {
        [ANOMALY]   = cq.talkOnly("AFTER"),
        [SHARARA_1] = cq.giveStep("FINISH", info.reward, info.name, cexi.music.NONE),
    },
--[[
-- TODO: This needs to be possible
    {
        [SHARARA_1] = cq.talkOnly("AFTER"),
    },
]]
    {
        check       = cq.checks({ CW = true, level = 25 }),
        [SHARARA_1] = cq.talkStep("PART2_START"),
    },
    {
        [SHARARA_1] = cq.menuStep("Agree to help?", { { "No" }, { "Yes", "PART2_ACCEPT" } }, 2 , info.name .. " II"),
    },
    {
        [SHARARA_1]  = cq.talkOnly("PART2_REMINDER"),
        [LOST_ITEM]  = cq.menuSpawn(SPARE, "Investigate the source?", { { "Too boring." }, { "Why, yes." } }, 2 ),
        [SPARE]      = cq.killStep(LOST_ITEM),
    },
    {
        [LOST_ITEM] = cq.talkStep("FOUND"),
    },
    {
        [LOST_ITEM] = cq.talkOnly("AFTER"),
        [SHARARA_1] = cq.giveStep("PART2_FINISH", info.reward2, info.name .. " II", cexi.music.NONE),
    },
    {
        [SHARARA_1] = cq.talkStep("PART2_AFTER"),
    },
    -- 11
    {
        check      = cq.checks({ CW = true, level = 40 }),
        [SHARARA_1] = cq.talkStep("PART3_START", info.name .. " III"),
    },
    {
        [SHARARA_1] =
        {
            onTrigger = cq.talkOnly("PART3_REMINDER1"),
            onTrade   = cq.tradeStep("PART3_ACCEPTED", "PART3_REMINDER1", info.required3.item),
        },
    },
    {
        [SHARARA_1] = cq.talkOnly("PART3_REMINDER2"),
        [LOW_POINT] = cq.menuSpawn(yagudoSages, "How low can you go?", { { "Not yet." }, { "Lower." } }, 2, true, { levelCap = 40 }),
        [SAGE_1]    = cq.killStep(LOW_POINT, yagudoSages, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "TRUST_WINDURST_III" }),
        [KOGA_1]    = cq.killStep(LOW_POINT, yagudoSages, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "TRUST_WINDURST_III" }),
    },
    {
        [LOW_POINT] = cq.talkStep("CUTSCENE"),
    },
    {
        [LOW_POINT] = cq.talkOnly("AFTER"),
        [SHARARA_1] = cq.giveStep("PART3_FINISH", info.reward3, info.name .. " III", cexi.music.NONE),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
