-----------------------------------
-- Feather Forecast (Lv20)
-----------------------------------
-- !setvar [CQ]FEATHER_FORECAST 0
-- Pennana    !pos -43.831 0.000 -137.145 241
-- Shiny Rock !pos -46.078 14.654 -366.756 119
-- Pennana    !pos -43.831 0.000 -137.145 241
-- Reward: Silver Obi
-- Unlocks: Pennana (Guild Helper)
-----------------------------------
-- !setvar [CQ]FEATHER_FORECAST 5

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-feather_forecast")

local helpers =
{
    {
        name     = "12 grass cloth",
        required = { { 824, 12 } },
        rewards  =
        {
            {
                name = "Cape",
                item = 13583,
                augs =
                {
                    {   1, { 4, 9 }, }, -- HP  +5-10
                    {   9, { 2, 7 }, }, -- MP  +3-8
                    { 9, 7,   518, 0 }, -- MP +8, CHR +1
                },
            },
        },
    },
    {
        name     = "12 cotton cloth",
        required = { { 825, 12 } },
        rewards  =
        {
            {
                name = "Slacks",
                item = 12864,
                augs =
                {
                    {   1, { 4, 9 }, }, -- HP  +5-10
                    {   9, { 2, 7 }, }, -- MP  +3-8
                    { 9, 7,   517, 0 }, -- MP +8, MND +1
                },
            },
        },
    },
    {
        name     = "12 linen cloth",
        required = { { 826, 12 } },
        rewards  =
        {
            {
                name = "Scarlet Ribbon",
                item = 13568,
                augs =
                {
                    {   1, { 4, 9 }, }, -- HP  +5-10
                    {   9, { 2, 7 }, }, -- MP  +3-8
                    { 9, 7,   517, 0 }, -- MP +8, MND +1
                },
            },
        },
    },
    {
        name     = "12 wool cloth",
        required = { { 827, 12 } },
        rewards  =
        {
            {
                name = "Wool Hat",
                item = 12474,
                augs =
                {
                    { 512, { 0, 1 }, }, -- STR      +1-2
                    {  25, { 0, 3 }, }, -- Attack   +1-4
                    {  512, 1, 23, 3 }, -- STR +2, Accuracy +3
                },
            },
        },
    },
    {
        name     = "12 velvet cloth",
        required = { { 828, 12 } },
        rewards  =
        {
            {
                name = "Velvet Robe",
                item = 12603,
                augs =
                {
                    {   9, { 9, 14 }, }, -- MP  +10-15
                    { 517, { 0,  1 }, }, -- MND +1-2
                    { 9, 14,  516, 2, }, -- MP +15, INT +3
                },
            },
        },
    },
    {
        name     = "12 silk cloth",
        required = { { 829, 12 } },
        rewards  =
        {
            {
                name = "Silk Cuffs",
                item = 12732,
                augs =
                {
                    {   9, { 9, 14 }, }, -- MP  +10-15
                    { 517, { 1,  3 }, }, -- MND +2-4
                    { 9, 14,  329, 1, }, -- MP +15, Cure Potency +2%
                },
            },
        },
    },
    {
        name     = "12 karakul cloth",
        required = { { 2288, 12 } },
        rewards  =
        {
            {
                name = "Sipahi Zerehs",
                item = 13806,
                augs =
                {
                    { 513, { 0, 2 }, }, -- DEX      +1-3
                    {  25, { 2, 7 }, }, -- Attack   +3-8
                    { 513, 2, 23, 7, }, -- DEX +3, Accuracy +8
                },
            },
        },
    },
    {
        name     = "12 rainbow cloth",
        required = { { 830, 12 } }, -- Rainbow Cloth x12
        rewards  =
        {
            {
                name = "Arhat's Gi",
                item = 13795,
                augs =
                {
                    { 25,         { 2, 7 }, }, -- Attack   +3-8
                    { 23,         { 2, 7 }, }, -- Accuracy +3-8
                    { 32, 4, 23, 7, 145, 2, }, -- Evasion -5, Accuracy +8, Counter +3
                },
            },
        },
    },
}

local info =
{
    name   = "Feather Forecast",
    author = "Loxley",
    var    = "[CQ]FEATHER_FORECAST",
    reward =
    {
        item    = 13205,                  -- Silver Obi (Lv20)
        augment = { 9, 9, 53, 7, 97, 0 }, -- MP +10, Spell interruption rate down 8%, Pet: Attack+1 Rng.Atk.+1
    },
}

local PENNA   = "PENNA"
local Pennana = "Pennana"
local BIRDY   = "BIRDY"
local SHINY   = "SHINY"

local entity =
{
    {
        id     = PENNA,
        name   = Pennana,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.TARU_F,
            face = cexi.face.A7,
            head = cexi.model.VELVET_ROBE,
            body = cexi.model.CHASUBLE,
            hand = cexi.model.GARISH_TUNIC,
            legs = cexi.model.GARISH_TUNIC,
            feet = cexi.model.GARISH_TUNIC,
        }),
        area   = "Windurst_Woods",
        pos    = { -43.831, 0.000, -137.145, 113 }, -- !pos -43.831 0.000 -137.145 241
        dialog =
        {
            NAME     = true,
            DEFAULT  =
            {
                "Don'taru disturb me please. I'm thinking up a brand new design.",
            },
            START    =
            {
                { emote = xi.emote.THINK },
                "Aboutaru time somebody showed up to help!",
                " I've a super duper important customer who needs a new hat.",
                "This hat must have a very special-whecial feather on top!",
                { delay = 1000 },
                { emote = xi.emote.LAUGH },
                "Don'taru worry, I've something to give you in return!",
            },
            ACCEPTED =
            {
                { emote = xi.emote.YES },
                "There's word of a bird with fabulous feathers soon due in Meriphataud Mountains.",
                " I've heard it can be lured out by shiny things.",
                { delay = 1000 },
                "Bring me one if its feathers so I can finish-winish this hat!",
            },
            REMINDER = { "Look for something shiny to lure outaru the bird-wirdy." },
            AFTER    =
            {
                { emote = xi.emote.SHOCKED },
                "So much color! Absolutaruly beautiful!",
                " Here's a sample of my work. It's yours to keep.",
            },

            -- Guild Helpers
            REQUEST  =
            {
                "Say, could you help me out again?",
                { emote = xi.emote.THINK },
                "I'm missing some materials to finish up this week's orders!",
                "If you bring me %s, I'll give you one of these extra pieces.",
            },
            RESULT   = { "Wonderful! Here's something for your effort!" },
            DECLINED = { "If you bring me %s, I'll give you one of these extra pieces." },
        },
    },
    {
        id     = SHINY,
        name   = "Shiny Rock",
        marker = cq.SIDE_QUEST,
        area   = "Meriphataud_Mountains",
        pos    = { -46.078, 14.654, -366.756, 214 }, --!pos -46.078 14.654 -366.756 119
        dialog =
        {
            DEFAULT   = cq.NOTHING,
            AFTER     = cq.NOTHING_ELSE,
            COLLECT   =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion = "collects the garishly bright feathers." },
            },
        },
    },
    {
        id          = BIRDY,
        name        = "Shrill Jubjub",
        type        = xi.objType.MOB,
        look        = 444,
        flags       = 135,
        groupId     = 2,
        groupZoneId = 119,
        area        = "Meriphataud_Mountains",
        pos         = { -46.078, 14.654, -366.756, 214 }, --!pos -46.078 14.654 -366.756 119
        widescan    = 1,
        level       = 23,
    },
}

local step =
{
    {
        check   = cq.checks({ level = 20 }),
        [PENNA] = cq.talkStep("START"),
    },
    {
        [PENNA] = cq.menuStep("Interested?", { { "Fly away." }, { "Sign me up.", "ACCEPTED" } }, 2, info.name),
    },
    {
        [PENNA] = cq.talkOnly("REMINDER"),
        [SHINY] = cq.menuSpawn(BIRDY, "Peck up the shiny?", { { "I'm not a bird." }, { "Immediately." } }, 2),
        [BIRDY] = cq.killStep(SHINY),
    },
    {
        [SHINY] = cq.talkStep("COLLECT"),
    },
    {
        [SHINY] = cq.talkOnly("AFTER"),
        [PENNA] = cq.giveStep("AFTER", info.reward, info.name, cexi.music.WINDURST),
    },

    -- Guild Helpers
    {
        check   = cq.checks({ cooldown = "[CQ]HELPER_CC" }),
        [PENNA] =
        {
            onTrigger = cq.talkWeekly(helpers, "REQUEST"),
            onTrade   = cq.tradeWeekly(helpers, "[CQ]HELPER_CC", "RESULT", "DECLINED"),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
