-----------------------------------
-- Down to Earth
-----------------------------------
-- !setvar [CW]DOWN_TO_EARTH 0
-- Hermin-Harmon !pos -52.629 -10.750 123.497 238
-- !additem 582
-- Reward: Various ores
-----------------------------------
-- !setvar [CW]DOWN_TO_EARTH 1

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-chasing_tails")

local info =
{
    name   = "Down to Earth",
    author = "Loxley",
    var    = "[CW]DOWN_TO_EARTH",
    tally  = "[CW]METEORITES",
    exchange =
    {
        [582] = -- Meteorite
        {
            { cexi.rate.COMMON,      640, "a chunk of copper ore"   }, --  (15%)
            { cexi.rate.COMMON,      642, "a chunk of zinc ore"     }, --  (15%)
            { cexi.rate.UNCOMMON,    643, "a chunk of iron ore"     }, --  (10%)
            { cexi.rate.UNCOMMON,    736, "a chunk of silver ore"   }, --  (10%)
            { cexi.rate.RARE,        737, "a chunk of gold ore"     }, --  ( 5%)
            { cexi.rate.VERY_RARE,   738, "a chunk of platinum ore" }, --  ( 1%)
        },
    },
}

local HERMIN       = "HERMIN"
local HerminHarmon = "Hermin-Harmon"

local entity =
{
    {
        id     = HERMIN,
        name   = HerminHarmon,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.TARU_M,
            face = cexi.face.A4,
            head = cexi.model.TUNIC,
            body = cexi.model.TUNIC,
            hand = cexi.model.TUNIC,
            legs = cexi.model.TUNIC,
            feet = cexi.model.TUNIC,
        }),
        area   = "Windurst_Waters",
        pos    = { -52.629, -10.750, 123.497, 101 }, -- !pos -52.629 -10.750 123.497 238
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "Have you ever seen a falling star?" },
            START    =
            {
                "Have you ever seen a falling star?",
                { emote = xi.emote.THINK },
                { delay = 2000 },
                "Legend has it that when they first fell on Starfall Hillock...",
                " We used the metal to build weapons, and so began all the wars.",
                { emote = xi.emote.SIGH },
                { delay = 3000 },
                "Maybe if you find one of those meteorites, I could salvage some material.",
            },
            REMINDER =
            {
                "Bring me a meteorite and I'll try to salvage some material.",
            },
        },
    },
}

local step =
{
    {
        [HERMIN] = cq.talkStep("START", info.name),
    },
    {
        [HERMIN] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.trade({
                quest    = info.name,
                music    = cexi.music.WINDURST,
                tally    = info.tally,
                name     = HerminHarmon,
                step     = false,
                exchange = info.exchange,
                accepted =
                {
                   "So it's true. These rocks do contain metal...",
                    "Let's see what this one contains.",
                    { emote = xi.emote.THINK },
                    { delay = 3000 },
                },
                declined =
                {
                    "Bring me a meteorite and I'll try to salvage some material.",
                },
            }),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
