-----------------------------------
-- Ring Around the Roses (Lv1)
-----------------------------------
-- !setvar [CW]RING_AROUND_THE_ROSES 0
-- Aeolia      !pos 159.217 -0.950 17.122 230
-- Flower Bed  !pos -13.677 0.000 43.668 231
-- Aeolia      !pos 159.217 -0.950 17.122 230
-- Reward: San d'Orian Ring
-----------------------------------
-- !setvar [CW]RING_AROUND_THE_ROSES 4

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-ring_around_the_roses")

local info =
{
    name   = "Ring Around the Roses",
    author = "Loxley",
    var    = "[CW]RING_AROUND_THE_ROSES",
    reward =
    {
        item  = 13495, -- San d'Orian Ring (Lv1)
    },
}

local ELVAAN    = "ELVAAN"
local Aeolia    = "Aeolia"
local FLOWERBED = "FLOWERBED"

local entity =
{
    {
        id     = ELVAAN,
        name   = Aeolia,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.ELVAAN_F,
            face = 6,
            head = 0,
            body = cexi.model.VELVET_ROBE,
            hand = cexi.model.TUNIC,
            legs = cexi.model.BATTLE_JUPON,
            feet = cexi.model.VELVET_ROBE,
        }),
        area   = "Southern_San_dOria",
        pos    = { 159.217, -0.950, 17.122, 214 }, -- !pos 159.217 -0.950 17.122 230
        dialog =
        {
            NAME     = true,
            DEFAULT  =
            {
                { entity = Aeolia, emote = xi.emote.SHOCKED },
                "Achoo!!",
            },
            START  =
            {
                { entity = Aeolia, emote = xi.emote.SHOCKED },
                "Achoo!!! I mean, you! I mean sorry.",
                " Can you help me? I...",
                { delay = 1000 },

                { entity = Aeolia, emote = xi.emote.SHOCKED },
                "Achoo!!",
                { delay = 1000 },

                "Dropped my ring in the flower beds... *sniff*",
                " At the fountain in Northern San d'Oria but the flowers they-",
                { delay = 1000 },

                { entity = Aeolia, emote = xi.emote.SHOCKED },
                "Achoo!!",
                { delay = 1000 },

                "Thank you. I would be in your debt.",
            },
            REMINDER =
            {
                { delay = 1000 },
                { entity = Aeolia, emote = xi.emote.SHOCKED },
                "Achoo!!",
            },
            FINISH   =
            {
                "Thank you for bringing this to me but...",
                { delay = 1000 },

                { entity = Aeolia, emote = xi.emote.SHOCKED },
                "Achoo!!",

                { delay = 1000 },
                "Maybe you better keep this... *sniff* instead of me.",
            },
            AFTER    = { "Thanks anyway. *sniff*" },
        },
    },
    {
        id     = FLOWERBED,
        name   = "Flower Bed",
        marker = cq.SIDE_QUEST,
        area   = "Northern_San_dOria",
        pos    = { -10.962, 0.000, 44.073, 0 }, --!pos -13.677, 0.000, 43.668 231
        dialog =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            FOUND   =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion   = "rummages through the Flower Bed and finds Aeolia's ring." },
            },
        }
    },
}

local step =
{
    {
        check    = cq.checks({ CW = true }),
        [ELVAAN] = cq.talkStep("START", info.name),
    },
    {
        [ELVAAN]    = cq.talkOnly("REMINDER"),
        [FLOWERBED] = cq.menuStep("Look for the ring?", { { "I don't like flowers." }, { "Yes", "FOUND" } }, 2),
    },
    {
        [ELVAAN]  = cq.giveStep("FINISH", info.reward, info.name, cexi.music.SANDORIA),
    },
    {
        [ELVAAN]  = cq.talkOnly("AFTER"),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
