-----------------------------------
-- Rambling Around    (Lv10)
-- Rambling Around II (Lv12)
-----------------------------------
-- !setvar [CW]RAMBLING_AROUND 0
-- !setvar [CW]LANOLIN 0
-- Glenda    !pos 81.170 3.000 33.216 230
-- Ram Bones !pos -267.380 -0.166 -569.411 100
-- Reward: 1500 gil
-----------------------------------
-- Glenda    !pos 81.170 3.000 33.216 230
-- !additem 531 2
-- Reward: 1800 gil
-----------------------------------
-- !setvar [CW]RAMBLING_AROUND 5

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-rambling_around")

local info =
{
    name    = "Rambling Around",
    author  = "Loxley",
    var     = "[CW]RAMBLING_AROUND",
    counter = "[CW]LANOLIN",

    reward1 =
    {
        gil = 1500,
    },

    reward  =
    {
        gil = 1800,
    },

    required =
    {
        item = { { 531, 2 } },
        name = "two lanolin cubes",
    },
}

local GLEN    = "GLEN"
local Glenda  = "Glenda"
local WILD    = "WILD"
local WOOL    = "WOOL"
local RamWool = "Ram Wool"

local entity =
{
    {
        id     = GLEN,
        name   = Glenda,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.HUME_F,
            face = cexi.face.B2,
            head = cexi.model.NOTHING,
            body = cexi.model.LEATHER_VEST,
            hand = cexi.model.LEATHER_VEST,
            legs = cexi.model.LEATHER_VEST,
            feet = cexi.model.LEATHER_VEST,
        }),
        area   = "Southern_San_dOria",           -- (K-8)
        pos    = { 81.170, 3.000, 33.216, 224 }, -- !pos 81.170 3.000 33.216 230
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "Have you ever seen a ram?" },
            START    =
            {
                { emote = xi.emote.WAVE },
                "Hello, I'm new here. Have you ever seen a ram?",
                " Rosel told me they even used to roam into Ronfaure!",
                { delay = 2000 },
                { emote = xi.emote.THINK },
                "I'd love to know if it's true. Would you be willing to help me find out?",
            },
            BEGIN =
            {
                "I've been told that rams used to be seen in southern Ronfaure.",
                " I hope you're able to find something.",
            },
            AFTER =
            {
                { emote = xi.emote.AMAZED },
                "Incredible. So there really were rams in Ronfaure!",
            },
            NEXT  =
            {
                "Thanks for helping me out by investigating those rams.",
                { emote = xi.emote.BOW },
                { delay = 1000 },
                "Here are at Rosel's we use lanolin to finish some of the pieces.",
                " If you brought two lanolin cubes, I could make it worth your time.",
            },
            REMINDER =
            {
                "Here are at Rosel's we use lanolin to finish some of the pieces.",
                " If you brought two lanolin cubes, I could make it worth your time.",
            },
            ACCEPTED =
            {
                { emote = xi.emote.BOW },
                "Thanks for these lanolin cubes. That makes %u.",
                " We can always use more, please keep bringing them.",
            },
        },
    },
    {
        id       = WOOL,
        name     = RamWool,
        marker   = cq.SIDE_QUEST,
        area     = "West_Ronfaure",
        pos      = { -267.380, -0.166, -569.411, 170 }, --!pos -267.380 -0.166 -569.411 100
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        },
    },
    {
        id          = WILD,
        name        = "Wild Ram",
        type        = xi.objType.MOB,
        look        = 344,
        groupId     = 30,
        groupZoneId = 102,
        area        = "West_Ronfaure",
        pos         = { -267.380, -0.166, -569.411, 170 }, --!pos -267.380 -0.166 -569.411 100
        level       = 4,
    },
}

local step =
{
    {
        check  = cq.checks({ CW = true, level = 10 }),
        [GLEN] = cq.talkStep("START"),
    },
    {
        [GLEN] = cq.menuStep("Rams in Ronfaure?", { { "Quit your rambling." }, { "Let's find out.", "BEGIN" },  }, 2, info.name ),
    },
    {
        [WOOL] = cq.menuSpawn(WILD, "Examine the clump of wool?", { { "No." }, { "Yes." } }, 2),
        [WILD] = cq.killStep(WOOL),
    },
    {
        [WOOL] = cq.talkOnly("AFTER"),
        [GLEN]  = cq.giveStep("AFTER", info.reward1, info.name, cexi.music.SANDORIA),
    },
    {
        check  = cq.checks({ CW = true, level = 12 }),
        [GLEN] = cq.talkStep("NEXT", info.name .. " II"),
    },
    {
        [GLEN] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeOnly("ACCEPTED", "REMINDER", info.required.item, info.reward, info.counter, 2, info.name .. " II", cexi.music.SANDORIA),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
