-----------------------------------
-- On Guard  (Lv5)
-- On Watch (Lv10)
-----------------------------------
-- !setvar [CW]ON_GUARD 0
-- Somnelius !pos -209.900 -65.000 415.054 100
-- !additem 4374 2
-- Reward: Augmented Kenpogi (HP +5, AGI +1)
-----------------------------------
-- !setvar [CW]ON_GUARD 2
-- Somnelius      !pos -209.900 -65.000 415.054 100
-- Orcish Marking !pos -605.806 -66.160 412.859 100
-- Somnelius      !pos -209.900 -65.000 415.054 100
-- Reward: Augment Brass Xiphos (VIT +2, Evasion -2)
-----------------------------------
-- !setvar [CW]ON_GUARD 5

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-on_guard")

local info =
{
    name    = "On Guard",
    second  = "On Watch",
    author  = "Loxley",
    var     = "[CW]ON_GUARD",
    reward  =
    {
        gil     = 200,
        item    = 12584,            -- Kenpogi
        augment = { 1, 4, 515, 0 }, -- HP +5, AGI +1
    },

    reward2 =
    {
        item    = 16531,             -- Brass Xiphos
        augment = { 514, 1, 32, 1 }, -- VIT +2, Evasion -2
    },

    required =
    {
        item = { { 4374, 2 } },
        name = "two sleepshrooms",
    },
}

local SOMNELIUS      = "SOMNELIUS"
local ORCISH_MARKING = "ORCISH_MARKING"
local ORCISH_WATCHER = "ORCISH_WATCHER"

local entity =
{
    {
        id     = SOMNELIUS,
        name   = "Somnelius",
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.A6,
            head = cexi.model.LEATHER_VEST,
            body = cexi.model.SCALE_MAIL,
            hand = cexi.model.SCALE_MAIL,
            legs = cexi.model.SCALE_MAIL,
            feet = cexi.model.SCALE_MAIL,
        }),
        area      = "West_Ronfaure",                     -- (H-5)
        pos       = { -209.900, -65.000, 415.054, 197 }, -- !pos -209.900 -65.000 415.054 100
        animation = 48,
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "Zzz..." },
            START    =
            {
                { entity = "player", emote = xi.emote.POKE },
                { delay  = 3000 },
                "Got any... *Yawn*",
                " Sleepshrooms? Dreadfully boring guard duty...",
                "Bring *yawn* two sleepshrooms. That should... Do... Zzz...",
            },
            REMINDER = { "Bring *yawn* two sleepshrooms. That should... Do... Zzz..." },
            AFTER    = { "Phew, thought... I was going to be here... all night... Well, I mean Zzz...", },
            START2   = { "Supposed to... Che- *yawn* near Ghelsba... Orcish Marking... Zzz..." },
            AFTER2   = { "Huh... Really? Well *yawn* with the threat gone... take this sword, I don't Zzz..." },
        },
    },
    {
        id       = ORCISH_MARKING,
        name     = "Orcish Marking",
        marker   = cq.SIDE_QUEST,
        area     = "West_Ronfaure",                    -- (F-5)
        pos      = { -606.146, -65.280, 411.705, 26 }, --!pos -606.146 -65.280 411.705 100
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            INSPECT =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion   = "examines the marking." },
            },
        },
    },
    {
        id          = ORCISH_WATCHER,
        name        = "Orcish Watcher",
        type        = xi.objType.MOB,
        groupId     = 12,
        groupZoneId = 100,
        area        = "West_Ronfaure",
        pos         = { -606.146, -65.280, 411.705, 35 }, --!pos -606.146 -65.280 411.705 100
        level       = 9,
    },
}

local step =
{
    {
        check       = cq.checks({ CW = true, level = 5 }),
        [SOMNELIUS] = cq.talkStep("START", info.name),
    },
    {
        [SOMNELIUS] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeStep("AFTER", "REMINDER", info.required.item, info.reward, info.name, cexi.music.RONFAURE),
        },
    },
    {
        check       = cq.checks({ CW = true, level = 10 }),
        [SOMNELIUS] = cq.talkStep("START2", info.second),
    },
    {
        [SOMNELIUS]      = cq.talkOnly("START2"),
        [ORCISH_MARKING] = cq.menuSpawn(ORCISH_WATCHER, "Inspect the marking?", { { "No." }, { "Yes." } }, 2, true, { levelCap = 10 }),
        [ORCISH_WATCHER] = cq.killStep(ORCISH_MARKING),
    },
    {
        [SOMNELIUS]      = cq.talkOnly("START2"),
        [ORCISH_MARKING] = cq.menuStep("Examine the marking?", { { "No." }, { "Yes.", "INSPECT" } }, 2),
    },
    {
        [ORCISH_MARKING] = cq.talkOnly("AFTER"),
        [SOMNELIUS]      = cq.giveStep("AFTER2", info.reward2, info.second, cexi.music.RONFAURE),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
