-----------------------------------
-- In Sheep's Clothing (Lv5)
-----------------------------------
-- !setvar [CW]SHEEPS_CLOTHING 0
-- !setvar [CW]SHEEPSKIN 0
-- Chilly Wolf !pos 62.262 -4.250 35.154 241
-- !additem 505 3
-- Rewards: 250g
-----------------------------------
-- !setvar [CW]SHEEPS_CLOTHING 1

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-only_the_dose")

local info =
{
    name    = "In Sheep's Clothing",
    author  = "Loxley",
    var     = "[CW]SHEEPS_CLOTHING",
    counter = "[CW]SHEEPSKIN",
    reward  =
    {
        gil = 250,
    },

    required =
    {
        item = { { 505, 3 } },
        name = "three sheepskin",
    },
}

local CWOLF      = "CWOLF"
local ChillyWolf = "Chilly Wolf"

local entity =
{
    {
        id     = CWOLF,
        name   = ChillyWolf,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.GALKA,
            face = cexi.face.B2,
            head = cexi.model.NOTHING,
            body = cexi.model.ROBE,
            hand = cexi.model.ROBE,
            legs = cexi.model.ROBE,
            feet = cexi.model.ROBE,
            main = 2,
        }),
        area   = "Northern_San_dOria",            -- (C-9)
        pos    = { -247.432, 8.000, 7.263, 222 }, -- !pos -247.432 8.000 7.263 231
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "So brrr~ cold..." },
            START    =
            {
                { emote = xi.emote.STAGGER },
                "Ronfaure is so cold. I miss the blistering heat of Gustaberg.",
                " Get three sheepskin to warm me up and I'll pay for it.",
            },
            ACCEPTED =
            {
                { emote = xi.emote.YES },
                "That's better, but not enough. So far, I have %u sheepskins.",
                " Get more sheepskins and I'll keep paying.",
            },
            DECLINED =
            {
                "Get three sheepskin to warm me up and I'll pay for it."
            },
        },
    },
}

local step =
{
    {
        check   = cq.checks({ CW = true }),
        [CWOLF] = cq.talkStep("START", info.name),
    },
    {
        [CWOLF] =
        {
            onTrigger = cq.talkOnly("START"),
            onTrade   = cq.tradeOnly("ACCEPTED", "DECLINED", info.required.item, info.reward, info.counter, 3, info.name, cexi.music.SANDORIA),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
