-----------------------------------
-- Hungry Customer (Lv1)
-----------------------------------
-- !setvar [CW]HUNGRY_CUSTOMER 0
-- !setvar [CW]HARE_MEAT 0
-- Couquillard !pos 95.225 0.000, 118.159 230
-- !additem 4358 12
-- Rewards: 900g
-----------------------------------
-- !setvar [CW]HUNGRY_CUSTOMER 0

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-rustling_feathers")

local info =
{
    name    = "Hungry Customer",
    author  = "Loxley",
    var     = "[CW]HUNGRY_CUSTOMER",
    counter = "[CW]HARE_MEAT",
    reward  =
    {
        gil = 900,
    },

    required =
    {
        item = { { 4358, 12 } },
        name = "twelve hare meat",
    },
}

local COUQ        = "COUQ"
local Couquillard = "Couquillard"

local BELLY         = "BELLY"
local RumblingBelly = "Rumbling Belly"

local entity =
{
    {
        id     = BELLY,
        name   = RumblingBelly,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.GALKA,
            face = cexi.face.B7,
            head = cexi.model.LEATHER_VEST,
            body = cexi.model.SCALE_MAIL,
            hand = cexi.model.LEATHER_VEST,
            legs = cexi.model.SCALE_MAIL,
            feet = cexi.model.SCALE_MAIL,
        }),
        area   = "Southern_San_dOria",            -- (K-6)
        pos    = { 93.210, 1.000, 120.840, 127 }, -- !pos 93.210 1.000 120.840 230
        dialog =
        {
            NAME    = true,
            DEFAULT =
            {
                { emote = xi.emote.SULK },
                "So hungry...",
            },
        },
    },
    {
        id     = COUQ,
        name   = Couquillard,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.B7,
            head = cexi.model.NOTHING,
            body = cexi.model.ROBE,
            hand = cexi.model.TUNIC,
            legs = cexi.model.RASETSU_SAMUE,
            feet = cexi.model.TUNIC,
        }),
        area   = "Southern_San_dOria",            -- (K-6)
        pos    = { 95.225, 0.000, 118.159, 225 }, -- !pos 95.225 0.000, 118.159 230
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "He's back again..." },
            START    =
            {
                "One particular customer keeps eating all our hare meat!",
                { entity = RumblingBelly, emote = xi.emote.LAUGH },
                " Fetch twelve hare meat and I'll reward you.",
            },
            ACCEPTED =
            {
                "Phew, thank you. Now I can serve my customers again!",
                { entity = RumblingBelly, emote = xi.emote.LAUGH },
                "So far that makes %u hare dishes served, all thanks to you.",
            },
            DECLINED =
            {
                "Please fetch twelve hare meat and I'll reward you.",
            },
        },
    },
}

local step =
{
    {
        check  = cq.checks({ CW = true }),
        [COUQ] = cq.talkStep("START", info.name),
    },
    {
        [COUQ] =
        {
            onTrigger = cq.talkOnly("DECLINED"),
            onTrade   = cq.tradeOnly("ACCEPTED", "DECLINED", info.required.item, info.reward, info.counter, 12, info.name, cexi.music.SANDORIA),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
