-----------------------------------
-- Hatchet Job (Lv5)
-----------------------------------
-- !setvar [CW]HATCHET_JOB 0
-- Aesculian !pos 364.729 -49.955 173.272 101
-- !additem 4371
-- Reward: Hatchet x12
-----------------------------------
-- !setvar [CW]HATCHET_JOB 2

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-hachet-job")

local info =
{
    name   = "Hatchet Job",
    author = "Loxley",
    var    = "[CW]HATCHET_JOB",
    reward =
    {
        item  = { { xi.item.HATCHET, 36 } },
        after = function(player)
            cq.rewardSlots(player, { xi.inv.WARDROBE4, 1 })
            cq.fieldTunica(player)

            return true
        end,
    },
    required = 
    {
        item = 4371,
        name = "a slice of grilled hare",
    },
}

local ELVAAN    = "ELVAAN"
local Aesculian = "Aesculian"

local entity =
{
    {
        id     = ELVAAN,
        name   = Aesculian,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.B4,
            head = cexi.model.LEATHER_VEST,
            body = cexi.model.FIELD_TUNICA,
            hand = cexi.model.LEATHER_VEST,
            legs = cexi.model.FIELD_TUNICA,
            feet = cexi.model.LEATHER_VEST,
        }),
        area   = "East_Ronfaure",
        pos    = { 364.729, -49.955, 173.272, 90 }, -- !pos 364.729 -49.955 173.272 101
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "I don't have anything for you." },
            START    =
            {
                { noturn = true },
                { entity = Aesculian, emote = xi.emote.LOGGING },
                { delay  = 2000 },
                { entity = Aesculian, face  = "player" },
                "Its a fine day for logging.",
                "I've plenty of hatchets but unfortunately nought to eat!",
                { delay  = 2000 },
                string.format("Say, could you bring me %s?", info.required.name),
                { entity = Aesculian, emote = xi.emote.BOW},
                "I'll gladly share some hatchets, so you can join in the fun!",
            },
            REMINDER = { string.format("Please bring me %s and I'll share some hatchets.", info.required.name) },
            ACCEPTED =
            {
                "Wonderful. This is just what I needed!",
                { entity = Aesculian, emote = xi.emote.BOW},
                "Here are your hatchets as promised.",
                "Have fun, friend!",
            },
            DECLINED =
            {
                { entity = Aesculian, emote = xi.emote.NO },
                string.format("Hmmm... Thanks for the offer but this isn't %s.", info.required.name),
            },
            AFTER =
            {
                { noturn = true },
                { entity = Aesculian, emote = xi.emote.LOGGING },
                "A fine day for logging!",
            },
        },
    },
}

local step =
{
    {
        check     = cq.checks({ CW = true, level = 5 }),
        [ELVAAN]  = cq.talkStep("START", info.name),
    },
    {
        [ELVAAN] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeStep("ACCEPTED", "DECLINED", info.required.item, info.reward, info.name, cexi.music.RONFAURE),
        }
    },
    {
        [ELVAAN] = cq.talkOnly("AFTER"),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
