-----------------------------------
-- Crystal Prelude (San d'Oria) (Lv1)
-----------------------------------
-- !setvar [CW]INTRO 2
-- Robineaux    !pos 149.113 0.000 193.248 190
-- Loose Branch !pos 167.555 0.000 199.753 190
-- Robineaux    !pos 149.113 0.000 193.248 190
-----------------------------------
-- !setvar [CW]INTRO 2

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-crystal_prelude_sandoria")


local info =
{
    name   = "A Crystal Prelude (San d'Oria)",
    author = "Loxley",
    var    = "[CW]INTRO",
    start  = { 152.145, 0.000, 195.839, 100, xi.zone.KING_RANPERRES_TOMB },
    reward =
    {
        item  = xi.item.ADVENTURER_COUPON,
        after = function(player)
            player:timer(3000, function(playerArg)
                local endPos = { 658.330, -19.601, -575.852, 170, xi.zone.EAST_RONFAURE } -- !pos 658.330 -19.601 -575.852 101

                playerArg:setHomePointAt(unpack(endPos))
                playerArg:setPos(unpack(endPos))
            end)

            return true
        end,
    },
}

local ROBIN     = "ROBIN"
local Robineaux = "Robineaux"
local TREE      = "TREE"
local RIME      = "RIME"

local entity =
{
    {
        id   = ROBIN,
        name = Robineaux,
        type = xi.objType.NPC,
        look = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.B5,
            head = cexi.model.LEATHER_VEST,
            body = cexi.model.LEATHER_VEST,
            hand = cexi.model.LEATHER_VEST,
            legs = cexi.model.LEATHER_VEST,
            feet = cexi.model.LEATHER_VEST,
        }),
        area = "King_Ranperres_Tomb",
        pos  = { 149.113, 0.000, 193.248, 230 }, -- !pos 149.113 0.000 193.248 190
        dialog =
        {
            NAME    = true,
            DEFAULT = { "I have nothing to say to you." },
            CREATURE =
            {
                "You're ready to leave? I can show you the way but...",
                " The truth is, I came here following the trail of some creature.",
                { emote = xi.emote.SIGH },
                { delay = 2000 },
                "I won't leave until I've found it. I'm so close now...",
            },
            ESCAPE =
            {
                "Quite impressive. As promised, I'll show you the way out.",
                { emote = xi.emote.BOW },
                { delay = 2000 },
                " As a token of my gratitude, please take this adventurer coupon.",
                " You can exchange it back in San d'Oria.",
            },
            SPAWN = { "Look out! Behind you!" },
        },
    },
    {
        id       = TREE,
        name     = "Logging Point",
        type     = xi.objType.NPC,
        look     = 2423,
        item     = { xi.item.ASH_LOG, "an ash log" },
        area     = "King_Ranperres_Tomb",
        pos      = { 167.555, 0.000, 199.753 }, -- !pos 167.555 0.000 199.753 190
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE
        },
    },
    {
        id          = RIME,
        name        = "Ranperre Rime",
        type        = xi.objType.MOB,
        look        = 292,
        groupId     = 9,
        groupZoneId = 3,
        area        = "King_Ranperres_Tomb",
        pos         = { 153.226, 0.000, 208.719, 0 }, -- !pos 153.226 0.000 208.719 190
        level       = 1,
        mods        =
        {
            [xi.mod.SLASH_SDT]  = 1000,
            [xi.mod.PIERCE_SDT] = 1000,
            [xi.mod.IMPACT_SDT] = 1000,
            [xi.mod.HTH_SDT]    = 1000,
            [xi.mod.HPP]        = -70,
        },
    },
}

local hint = cexi.crystal_warrior.intro.getHints({
    npc      = Robineaux,
    city     = "San d'Oria",
    tool     = "Hatchet",
    gather   = "Logging",
    material = "an ash log",
    point    = "Logging Point",
    ringNpc  = "Aeolia",
    ringZone = "Southern San d'Oria",
})

cexi.crystal_warrior.intro.setNextZone(m, "East_Ronfaure", hint, info.start)

local step =
{
    {
        -- Placeholder step for Provenance Intro
    },
    {
        -- Placeholder step for Provenance Intro
    },
    {
        checks  = cq.checks({ cw = true }),
        [ROBIN] = cq.dialog({
            beginQuest = info.name,
            reward     = { { xi.item.HATCHET, 12 } },
            name       = Robineaux,
            event      =
            {
                "Stranded here too? I came here with my bow but it has broken...",
                " It's dangerous here and we're unarmed.",
                { emote = xi.emote.THINK },
                { delay = 3000 },
                "I could create a makeshift weapon but we'll need some supplies.",
                " See the tree over there? Take these hatchets and bring me a log.",
                hint[1],
            },
        }),
    },
    {
        [ROBIN] = cq.dialog({
            step  = false,
            name  = Robineaux,
            event = { "See the tree over there? Use one of those hatchets on the Logging Point and bring me some wood." },
        }),
        [TREE] =
        {
            onTrigger = cq.dialog({
                step  = false,
                event = { "Logging is possible here if you have a hatchet." },
            }),
            onTrade = cq.trade({
                required = xi.item.HATCHET,
                reward   = xi.item.ASH_LOG,
                accepted =
                {
                    { entity = "player", emote = xi.emote.LOGGING },
                    hint[2],
                },
                declined = { "Logging is possible here if you have a hatchet." },
            }),
        },
    },
    {
        [ROBIN] =
        {
            onTrigger = cq.dialog({
                step  = false,
                name  = Robineaux,
                event = { "I see you've gathered an ash log, hand it to me." },
            }),
            onTrade   = cq.trade({
                name     = Robineaux,
                required = xi.item.ASH_LOG,
                declined = { "I see you've gathered an ash log, hand it to me." },
                accepted =
                {
                    "That's it! One moment...",
                    { emote = xi.emote.THINK },
                    hint[3],
                },
            }),
        },
    },
    {
        [ROBIN] = cq.dialog({
            conditionalDialog = "job",
            conditionalReward = "job",

            name   = Robineaux,
            reward =
            {
                [xi.job.WAR] = { { xi.item.ONION_SWORD,  1 } },
                [xi.job.MNK] = { { xi.item.WHITE_BELT,   1 } },
                [xi.job.WHM] = { { xi.item.ONION_ROD,    1 }, { xi.item.SCROLL_OF_CURE,  1 } },
                [xi.job.BLM] = { { xi.item.ONION_STAFF,  1 }, { xi.item.SCROLL_OF_STONE, 1 } },
                [xi.job.RDM] = { { xi.item.ONION_DAGGER, 1 }, { xi.item.SCROLL_OF_DIA,   1 } },
                [xi.job.THF] = { { xi.item.ONION_KNIFE,  1 } },
            },
            event =
            {
                [xi.job.WAR] =
                {
                    "I've reinforced my broken blade. It's a bit rough but it'll do the job.",
                    " But wait before you charge on out, I've some unfinished business.",
                    { emote = xi.emote.TOSS },
                    hint[4],
                },

                [xi.job.MNK] =
                {
                    "Hmmm... This wood is rotten through. I can't use this.",
                    " However, watching you swing that hatchet, I think you can handle yourself in a fist fight.",
                    { delay = 2000 },
                    "Take this belt, I'm sure you'll put it to better use than me.",
                    { emote = xi.emote.TOSS },
                    hint[4],
                },

                [xi.job.WHM] =
                {
                    "This is but a crude wooden replica but it's better than nothing.",
                    " Maybe you can patch these wounds, then we'll escape.",
                    { emote = xi.emote.TOSS },
                    hint[4],
                },

                [xi.job.BLM] =
                {
                    "Perfect. This staff should serve you well.",
                    " I can sense your affinity for magic. One day you will be a powerful mage. But first...",
                    { emote = xi.emote.TOSS },
                    hint[4],
                },

                [xi.job.RDM] =
                {
                    "I've struck a piece of my broken blade to this hilt. Let's get out of here. But first...",
                    { emote = xi.emote.TOSS },
                    hint[4],
                },

                [xi.job.THF] =
                {
                    "I've bound a piece of my broken blade to this hilt. Let's sneak out. But first...",
                    { emote = xi.emote.TOSS },
                    hint[4],
                },
            },
        }),
    },
    {
        [ROBIN] = cq.menuSpawn(RIME, { "CREATURE", "Agree to help?" }, { { "Not yet." }, { "I'm ready.", "SPAWN" } }, 2, false ),
        [RIME]  = cq.killStep(),
    },
    {
        [ROBIN] = cq.giveStep("ESCAPE", info.reward, info.name, cexi.music.NONE),
    },
    {
        [ROBIN] = cq.dialog({
            step  = false,
            name  = Robineaux,
            event = { "You're back again? I appreciate you helping me out earlier but I have nothing further to share with you." },
        }),
    },
    {
        [ROBIN] = cq.dialog({
            step  = false,
            name  = Robineaux,
            event = { "You're back again? I appreciate you helping me out earlier but I have nothing further to share with you." },
        }),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
