-----------------------------------
-- Boxed Up (Lv45)
-----------------------------------
-- !setvar [CW]BOXED_UP 0
-- Rusty Hammer !pos -177.082 0.000 258.423 231
-- !additem 699
-- !additem 700
-- !additem 701
-- !additem 702
-- Crooked Trunk !pos -227.647 -2.510 -283.085 2
-- Rusty Hammer  !pos -177.082 0.000 258.423 231
-- Reward: Access to the Ephemeral Box
-----------------------------------
-- !setvar [CW]BOXED_UP 5

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-boxed_up")

local info =
{
    name    = "Boxed up",
    author  = "Loxley",
    var     = "[CW]BOXED_UP",

    reward  =
    {
        gil = 3000,
        after = function(playerArg)
            cq.rewardSlots(player, { xi.inv.WARDROBE4, 1 })
            playerArg:printToPlayer("You have unlocked the Ephemeral Box!", xi.msg.channel.SYSTEM_3)
            return true
        end,
    },

    required =
    {
        item = { { 699, 1 }, { 700, 1 }, { 701, 1 }, { 702, 1 } },
    },
}

local RUSTY          = "RUSTY"
local SleepingWillow = "Sleeping Willow"
local WILLOW         = "SLEEPING_WILLOW"
local CROOKED        = "CROOKED_TRUNK"

local entity =
{
    {
        id     = RUSTY,
        name   = "Rusty Hammer",
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.GALKA,
            face = cexi.face.B4,
            head = cexi.model.HAUBERK,
            body = cexi.model.CARPENTERS_APRON,
            hand = cexi.model.KENPOGI,
            legs = cexi.model.RASETSU_SAMUE,
            feet = cexi.model.HAUBERK,
        }),
        area   = "Northern_San_dOria",              -- (E-3)
        pos    = { -177.082, 0.000, 258.423, 251 }, -- !pos -177.082 0.000 258.423 231
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "Nuthin' to say." },
            START    =
            {
                { emote = xi.emote.THINK },
                "Hey, have you seen that weird box in the guild?",
                " This is gonna sound real strange but... it talks.",
                { entity = "player", emote = xi.emote.SHOCKED },
                { delay = 1000 },
                "Apparently it needs some repairs to begin assisting adventurers.",
                " If you bring me some wood, I can have a go. A few different kinds are required.",
                "Oak, mahogany, rosewood and ebony. Fetch one log of each and I'll try to mend the box.",
            },

            REMINDER =
            {
                "Oak, mahogany, rosewood and ebony. Fetch one log of each and I'll try to mend the box.",
            },

            ACCEPTED =
            {
                "Ah, I may have left one thing out. There's very rare wood I'll need to finish the job.",
                " In Carpenter's Landing, find the crooked trunk next to a collapsed bridge.",
                "Take a piece and bring it back to me, then I'll finish the box.",
            },

            FIGHT =
            {
                "In Carpenter's Landing, find the crooked trunk next to a collapsed bridge.",
                " Take a piece and bring it back to me. Then I'll finish the box.",
            },

            AFTER =
            {
                "That's the last piece! I'll see to these repairs right away.",
            },
        },
    },
    {
        id       = CROOKED,
        name     = "Crooked Trunk",
        marker   = cq.SIDE_QUEST,
        area     = "Carpenters_Landing",
        pos      = { -227.647, -2.510, -283.085, 64 }, --!pos -227.647 -2.510 -283.085 2
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            AFTER2  = cq.NOTHING_ELSE,
            AFTER   =
            {
                { entity  = "player", emote = xi.emote.LOGGING },
                { delay   = 1000 },
                { emotion = "collects a piece of the mysterious tree." },
            },
            SWING   =
            {
                { entity = "player", emote = xi.emote.LOGGING },
                { delay  = 1000 },
            },
        },
    },
    {
        id          = WILLOW,
        name        = SleepingWillow,
        type        = xi.objType.MOB,
        groupId     = 35,
        groupZoneId = 105,
        area        = "Carpenters_Landing",
        pos         = { -227.647, -2.510, -283.085, 64 }, --!pos -227.647 -2.510 -283.085 2
        level       = 45,
    },
}

local step =
{
    {
        check   = cq.checks({ CW = true, level = 40 }),
        [RUSTY] = cq.talkStep("START", info.name),
    },
    {
        [RUSTY] =
        {
            onTrade   = cq.tradeStep("ACCEPTED", "REMINDER", info.required.item),
            onTrigger = cq.talkOnly("REMINDER"),
        }
    },
    {
        [RUSTY]   = cq.talkOnly("FIGHT"),
        [CROOKED] = cq.menuSpawn(WILLOW, "Swing your hatchet?", { { "No." }, { "Yes.", "SWING" } }, 2, true, { levelCap = 40 }),
        [WILLOW]  = cq.killStep(CROOKED, nil, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "BOXED_UP" }),
    },
    {
        [CROOKED] = cq.talkStep("AFTER"),
    },
    {
        [CROOKED] = cq.talkOnly("AFTER2"),
        [RUSTY]   = cq.giveStep("AFTER", info.reward, info.name, cexi.music.SANDORIA),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
