-----------------------------------
-- All Thine Heart - Holy Breastplate, Icarus Wing
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-all_thine_heart")

local info =
{
    name    = "All Thine Heart",
    author  = "Loxley",
    var     = "[CW]ALL_THINE_HEART",
    reward  =
    {
        item    = 13812,                    -- Holy Breastplate
        augment = { 25, 4, 23, 4, 517, 2 }, -- Attack +5, Accuracy +5, MND +3
    },

    reward2 =
    {
        item    = 4213, -- Icarus Wing
    },
}

local DOOR   = "DOOR"
local HERMIT = "HERMIT"
local BOOK   = "BOOK"

local entity =
{
    {
        id     = DOOR,
        name   = "Door. Chantry", -- We currently can't use : in names for dynamic entities :(
        type   = xi.objType.NPC,
        area   = "Northern_San_dOria",
        pos    = { 133.775, 0.000, 93.530 }, -- !pos 132 0 95.5 231
        dialog =
        {
            DEFAULT  = { "It's locked." },
            START    =
            {
                "Unknown Voice: Another seeker of wisdom?",
                " I cannot promise you will find it here.",
                { delay = 1000 },
                "Unknown Voice: Seek out the cave-dwelling hermit in Batallia Downs.",
                " Receive his teaching and you may earn my trust.",
            },
            FINISH   =
            {
                "Unknown Voice: What have you learned?",
                " A book? For me? I see...",
                { delay = 1000 },
                "Unknown Voice: You have done well.",
                " I will be watching your progress with interest.",
                { delay = 2000 },
                "The voice is gone but you find a small feather on the ground.",
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
            },
     
            REMINDER = { "Unknown Voice: Seek out the cave-dwelling hermit in Batallia Downs." },
        },
    },
    {
        id        = "ORC_MEMORY_1",
        name      = "Orc Memory 1",
        namevis   = 0x80,  -- Ghost
        hidename  = true,
        notarget  = true,
        animation = 1,
        hidden    = true,
        type      = xi.objType.NPC,
        look      = 616,
        area      = "Batallia_Downs",
        pos       = { 357.303, 2.058, 62.349, 90 },
    },
    {
        id        = "ORC_MEMORY_2",
        name      = "Orc Memory 2",
        namevis   = 0x80,  -- Ghost
        hidename  = true,
        notarget  = true,
        animation = 1,
        hidden    = true,
        type      = xi.objType.NPC,
        look      = 629,
        area      = "Batallia_Downs",
        pos       = { 353.159, 2.365, 59.617, 0 },
    },
    {
        id        = "ORC_MEMORY_3",
        name      = "Orc Memory 3",
        namevis   = 0x80, -- Ghost
        hidename  = true,
        notarget  = true,
        animation = 1,
        hidden    = true,
        type      = xi.objType.NPC,
        look      = 616,
        area      = "Batallia_Downs",
        pos       = { 356.643, 2.083, 56.633, 180 },
    },
    {
        id        = "ELVAAN_MEMORY_1",
        name      = "Elvaan Memory 1",
        namevis   = 0x80,  -- Ghost
        hidename  = true,
        notarget  = true,
        animation = 1,
        hidden    = true,
        type      = xi.objType.NPC,
        area      = "Batallia_Downs",
        pos       = { 357.184, 2.310, 60.719, 190 },
        look      = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.A7,
            head = cexi.model.LEATHER_VEST,
            body = cexi.model.SCALE_MAIL,
            hand = cexi.model.SCALE_MAIL,
            legs = cexi.model.SCALE_MAIL,
            feet = cexi.model.SCALE_MAIL,
            main = 251,
            offh = 37,
        }),
    },
    {
        id        = "ELVAAN_MEMORY_2",
        name      = "Elvaan Memory 2",
        namevis   = 0x80,  -- Ghost
        hidename  = true,
        notarget  = true,
        animation = 1,
        hidden    = true,
        type      = xi.objType.NPC,
        area      = "Batallia_Downs",
        pos       = { 354.993, 2.274, 59.796, 122 },
        look      = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.B3,
            head = cexi.model.SCALE_MAIL,
            body = cexi.model.SCALE_MAIL,
            hand = cexi.model.LEATHER_VEST,
            legs = cexi.model.SCALE_MAIL,
            feet = cexi.model.SCALE_MAIL,
            main = 251,
            offh = 37,
        }),
    },
    {
        id        = "ELVAAN_MEMORY_3",
        name      = "Elvaan Memory 3",
        namevis   = 0x80, -- Ghost
        hidename  = true,
        notarget  = true,
        animation = 1,
        hidden    = true,
        type      = xi.objType.NPC,
        area      = "Batallia_Downs",
        pos       = { 357.087, 2.277, 58.229, 72 },
        look      = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.A6,
            head = cexi.model.SCALE_MAIL,
            body = cexi.model.LEATHER_VEST,
            hand = cexi.model.SCALE_MAIL,
            legs = cexi.model.SCALE_MAIL,
            feet = cexi.model.SCALE_MAIL,
            main = 251,
            offh = 37,
        }),
    },

    {
        id        = "ELVAAN_MEMORY_4",
        name      = "Elvaan Memory 4",
        namevis   = 0x80, -- Ghost
        hidename  = true,
        notarget  = true,
        animation = 1,
        hidden    = true,
        type      = xi.objType.NPC,
        area      = "Batallia_Downs",
        pos       = { 356.049, 2.282, 60.293, 203 },
        look      = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.A2,
            head = cexi.model.SCALE_MAIL,
            body = cexi.model.STARTER_RSE,
            hand = cexi.model.LEATHER_VEST,
            legs = cexi.model.LEATHER_VEST,
            feet = cexi.model.LEATHER_VEST,
            main = 265,
        }),
    },
    {
        id        = "ELVAAN_MEMORY_5",
        name      = "Elvaan Memory 5",
        namevis   = 0x80, -- Ghost
        hidename  = true,
        notarget  = true,
        animation = 1,
        hidden    = true,
        type      = xi.objType.NPC,
        area      = "Batallia_Downs",
        pos       = { 354.881, 2.433, 58.860, 144 },
        look      = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.A3,
            head = cexi.model.SCALE_MAIL,
            body = cexi.model.LEATHER_VEST,
            hand = cexi.model.LEATHER_VEST,
            legs = cexi.model.LEATHER_VEST,
            feet = cexi.model.STARTER_RSE,
            main = 265,
        }),
    },
    {
        id        = "ELVAAN_MEMORY_6",
        name      = "Elvaan Memory 6",
        namevis   = 0x80, -- Ghost
        hidename  = true,
        notarget  = true,
        animation = 1,
        hidden    = true,
        type      = xi.objType.NPC,
        area      = "Batallia_Downs",
        pos       = { 357.805, 2.326, 58.461, 70 },
        look      = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.A5,
            head = cexi.model.SCALE_MAIL,
            body = cexi.model.LEATHER_VEST,
            hand = cexi.model.STARTER_RSE,
            legs = cexi.model.STARTER_RSE,
            feet = cexi.model.LEATHER_VEST,
            main = 265,
        }),
    },
    {
        id     = HERMIT,
        name   = "Seraphian",
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.A8,
            head = cexi.model.RASETSU_SAMUE,
            body = cexi.model.VAGABONDS_TUNICA,
            hand = cexi.model.FIELD_TUNICA,
            legs = cexi.model.AUSTERE_ROBE,
            feet = cexi.model.AUSTERE_ROBE,
        }),
        area   = "Batallia_Downs",
        pos    = { 358.033, 2.374, 59.459, 128 }, -- !pos 358.033 2.374 59.459 105
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "Greetings, wandering soul." },
            START    =
            { 
                "Greetings, wandering soul.",
                { emote   = xi.emote.THINK },
                { delay = 2000 },
                "I will share what little I have come to know after these years.",
                "But I must warn you, wisdom cannot be taught, it must be lived.",
                { delay = 2000 },
                "First I must ask that you travel to Davoi and retrieve my book.",
                "There is a small camp beside the ruined monastery where we once lived...",
                { emote   = xi.emote.BOW },
                { delay = 3000 },
            },
            FINISH   =
            {
                "Very well. I will now tell you my story",
                { delay = 3000 },

                { music = 170 },
                { emote   = xi.emote.COMFORT },
                "Many years ago, I fled La Vaule. It was a terrible night.",
                "We lost everything. The orcs surrounded us...",
                {
                    scripted_event =
                    {
                        entities =
                        {
                            "Orc_Memory_1", "Orc_Memory_2", "Orc_Memory_3",
                            "Elvaan_Memory_1", "Elvaan_Memory_2", "Elvaan_Memory_3",
                            "Elvaan_Memory_4", "Elvaan_Memory_5", "Elvaan_Memory_6",
                        },
                        events =
                        {
                            -- First Wave
                            { 1, "ati2" }, { 7, "ati1" }, { 1, "ati1" }, { 7, "dead" },
                            { 2, "ati1" }, { 8, "ati2" }, { 2, "ati2" }, { 8, "dead" },
                            { 3, "ati2" }, { 9, "ati1" }, { 3, "ati1" }, { 9, "dead" },

                            -- Second Wave
                            { 1, "ati2" }, { 4, "ati1" }, { 2, "ati1" }, { 5, "ati1" },
                            { 1, "ati1" }, { 4, "ati1" }, { 3, "ati1" }, { 6, "ati1" },
                            { 1, "ati1" }, { 4, "dead" }, { 2, "ati1" }, { 5, "dead" },
                            { 3, "ati1" }, { 6, "dead" },
                        },
                    },
                },

                { delay = 1000 },

                { despawn = { "Orc_Memory_1", "Orc_Memory_2", "Orc_Memory_3" } },
                "Countless lives were lost and I have learned to exist with many regrets.",
                { delay = 3000 },
                { emote   = xi.emote.SIGH },
                "But I have come to accept...",
                {
                    despawn =
                    {
                        "Elvaan_Memory_1", "Elvaan_Memory_2", "Elvaan_Memory_3",
                        "Elvaan_Memory_4", "Elvaan_Memory_5", "Elvaan_Memory_6",
                    }
                },
                { music = 159 },
                "We cannot help those who are gone.",
                " But we can honour them by living true.",
                { delay = 3000 },
                "We cannot choose what happens to us.",
                " But we can choose how it shapes us.",
                { delay = 3000 },
                "Even in the darkest hours, that choice cannot be taken from us.",
                { delay = 3000 },
                { emote = xi.emote.THINK },
                "Each adversity tests our resolve to choose right in the face of wrong.",
                { delay = 5000 },
                { emote = xi.emote.YES },
                "Our trials are not meaningless horrors but the fire which forges us to become what we must.",
                { delay = 5000 },
                "As the father corrects the son, it is not through distain or neglect that we must suffer but out of love.",
                { emote = xi.emote.THINK },
                { delay = 5000 },
                "Please return this book to my dear friend at the cathedral in San d'Oria.",
                "You may also take this breastplate, I no longer have need of it.",
                { emote = xi.emote.BOW },
                { delay = 3000 },
                { music = 114 },
                { message = "You receive Seraphian's Journal." },
            },

            REMINDER = { "Travel to a small camp beside the ruined monastery in Davoi and retrieve my book." },
            AFTER    = { "Please return this book to my dear friend at the cathedral in San d'Oria." },
        },
    },
    {
        id     = BOOK,
        name   = "Hiding Spot",
        marker = cq.SIDE_QUEST,
        area   = "Davoi",
        pos    = { 23.210, 0.567, -109.259 }, -- !pos 23.210 0.567 -109.259 149
        dialog =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            TAKE    =
            {
                { animation = 48, target = "player", duration = 3000 },
                { emotion = "collects the ragged tome." },
            },
        },
    },
}

local step =
{
    {
        check    = cq.checks({ CW = true, level = 40 }),
        [DOOR]   = cq.talkStep("START", info.name),
    },
    {
        [DOOR]   = cq.talkOnly("REMINDER"),
        [HERMIT] = cq.talkStep("START"),
    },
    {
        [HERMIT] = cq.talkOnly("REMINDER"),
        [BOOK]   = cq.menuStep("Take the book?", { { "No" }, { "Yes", "TAKE" } }, 2),
    },
    {
        [BOOK]   = cq.talkOnly("AFTER"),
        [HERMIT] = cq.giveStep("FINISH", info.reward),
    },
    {
        [HERMIT] = cq.talkOnly("AFTER"),
        [DOOR]   = cq.giveStep("FINISH", info.reward2, info.name, cexi.music.SANDORIA),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
