-----------------------------------
-- A Matter of Trust (San d'Oria)     (Lv15)
-- A Matter of Trust (San d'Oria) II  (Lv25)
-- A Matter of Trust (San d'Oria) III (Lv40)
-----------------------------------
-- Steps
------------------------------------
-- !setvar [CW]TRUST_SANDORIA 0
-- Keenajaques !pos -66.120 -5.496 -42.413 232
-- Anomaly !pos 663 28.5 -126 102
-- Keenajaques !pos -66.120 -5.496 -42.413 232
------------------------------------
-- !setvar [CW]TRUST_SANDORIA 4
-- Keenajaques !pos -66.120 -5.496 -42.413 232
-- Vertumaix   !pos 16.723 -0.321 570.058 193
-- Keenajaques !pos -66.120 -5.496 -42.413 232
------------------------------------
-- !setvar [CW]TRUST_SANDORIA 10
-- Keenajaques !pos -66.120 -5.496 -42.413 232
-- !additem 503
-- R Point     !pos 59.669 -2.201 -189.594 149
-- Keenajaques !pos -66.120 -5.496 -42.413 232
------------------------------------
-- !setvar [CW]TRUST_SANDORIA 15

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-a_matter_of_trust_sandoria")

local info =
{
    name   = "A Matter of Trust (San d'Oria)",
    author = "Yve",
    var    = "[CW]TRUST_SANDORIA",
    reward =
    {
        item    = 12720,      -- Gloves (Lv11)
        augment = { 1, 9 }, -- HP +10
        after   = function(player)
            cq.rewardSlots(player, { xi.inv.WARDROBE4, 1 })
            cq.rewardTrust(player, 902, "Curilla", 1)

            return true
        end,
    },

    reward2 =
    {
        item    = 12977,              -- Cotton Gaiters (Lv23)
        augment = { 517, 1, 513, 0 }, -- MND +2, DEX +1
        after   = function(player)
            cq.rewardSlots(player, { xi.inv.WARDROBE4, 2 })
            cq.sprinterShoes(player)

            return true
        end,
    },

    required3 = 
    {
        item = 503, -- Sunsand
    },

    reward3 =
    {
        item    = 13570,                     -- Ram Mantle (Lv36)
        augment = { 513, 1, 515, 1, 51, 1 }, -- DEX +2, AGI +2, HP recovered while healing +2
        keyitem =
        {
            xi.ki.SAN_DORIA_TRUST_PERMIT,
            xi.ki.RED_INSTITUTE_CARD,
        },
        after   = function(player)
            cq.rewardSlots(player, { xi.inv.WARDROBE4, 2 })
            cq.rewardTrust(player, 899, "Excenmille", 2)

            return true
        end,
    },
}

local KEENA       = "KEENA"
local ANOMALY     = "ANOMALY"
local WEAPON      = "WEAPON"

local VERTU       = "VERTUMAIX"
local GOBLIN      = "GOBLIN"
local BEDROCK     = "BEDROCK"

local Keenajaques = "Keenajaques"
local Curilla     = "Curilla"
local Excenmille  = "Excenmille"

local POINT       = "POINT"
local SMOKE       = "SMOKE"
local MIRRORS     = "MIRRORS"
local VAULEKOI    = "VAULEKOI"

local keenalook   = cexi.util.look({
    race = xi.race.ELVAAN_M,
    face = cexi.face.B1,
    head = cexi.model.TRADERS_SAIO_BLACK,
    body = cexi.model.TRADERS_SAIO_BLACK,
    hand = cexi.model.TUNIC,
    legs = cexi.model.TUNIC,
    feet = cexi.model.TUNIC,
    main = 270,
})

local vertulook   = cexi.util.look({
    race = xi.race.ELVAAN_F,
    face = cexi.face.B6,
    head = cexi.model.WHITE_CLOAK,
    body = cexi.model.WHITE_CLOAK,
    hand = cexi.model.WHITE_CLOAK,
    legs = cexi.model.WHITE_CLOAK,
    feet = cexi.model.WHITE_CLOAK,
})

local cutscene    =
{
    { music   = cexi.music.DESPAIR },
    { despawn = { "Crystal Anomaly" } },
    { spawn   = { Keenajaques } },
    { delay   = 3000 },
    "Keenajaques : It appears you found something before I did.",
    " Even so, I will be completing my task alone.",
    { entity = Keenajaques, emote = xi.emote.BOW },

    { delay  = 3000 },
    { spawn  = { Curilla } },
    "Curilla : Why are you here, Keenajaques? This does not seem to be your sort of venue.",
    " Do you not have some heathen ceremony or other to attend to?",

    { entity = Keenajaques, face = Curilla },
    { delay = 2000 },
    "Keenajaques : I mind my business. Surely, you appreciate that.",
    { entity = Keenajaques, emote = xi.emote.SIGH },

    { delay  = 3000 },
    { entity = Curilla, face = "player" },
    "Curilla : As for you adventurer, well done, defeating that monster.",
    " Mayhap I can use your help in the future.",
    { delay = 3000 },
    { despawn = { Curilla, Keenajaques } },
    { spawn   = { "Crystal Anomaly" } },
    { music   = cexi.music.NONE },
}

local entity =
{
    {
        id       = KEENA,
        name     = Keenajaques,
        type     = xi.objType.NPC,
        look     = keenalook,
        area     = "Port_San_dOria",
        pos      = { -66.120, -5.496, -42.413, 150 }, --- !pos -66.120 -5.496 -42.413 232
        dialog   =
        {
            NAME     = true,
            DEFAULT  = { "I have nothing to share with you." },
            START    =
            {
                "Are you going to be passing the Crag of Holla?",
                { delay = 1000 },
                { emote = xi.emote.THINK },
                "I will not tell you why, but I am also going there.",
                " If we chance to meet, try not to get in my way, understood?",
            },
            REMINDER = { "Remember to not get in my way." },
            FINISH   =
            {
                { emote = xi.emote.YES },
                "Curilla may have a rough attitude toward those who are not a part of her inner circle, but she wanted you to have this."
            },
            AFTER    = { "I sense that our paths will cross again soon." },

            PART2_START =
            {
                "Greetings, have you been making progress in your goals?",
                { delay = 1000 },
                { emote = xi.emote.YES },
                "This is not a request, by any means, but...",
                " if it suits your purpose, I have a deal to offer.",
            },
            PART2_ACCEPT =
            {
                "In Ordelle's Caves, there's a lady who has been studying the geology.",
                { emote = xi.emote.THINK },
                "If you say to her that you are trying to get to the heart of the caves, she will have something for you.",
                { delay = 2000 },
                "If you bring that back, I'll make it worth your while.",
            },
            PART2_REMINDER = { "Travel to Ordelle's Caves and all will become clear." },
            PART2_FINISH   =
            {
                { emote   = xi.emote.SALUTE },
                { emotion = "hands over the bedrock fragment." },
                "Thank you for bringing this.",
                { delay = 2000 },
                "I hope you are well on your way to discovering your true path.",
                " May these help you along that journey.",
            },
            PART2_AFTER    =
            {
                { emote = xi.emote.BOW },
                "Until we next meet.",
            },

            PART3_START =
            {
                { emote = xi.emote.THINK },
                "Would your plans bring you near the Valkurm Dunes in the near future?",
                { delay = 2000 },
                "I'll pay you for a pinch of Valkurm sunsand if you happen to find any.",
            },
            PART3_REMINDER = { "I'll pay you for a pinch of Valkurm sunsand if you happen to find any." },
            PART3_ACCEPTED =
            {
                "Allow me to explain. There's a new rumor on the horizon.",
                { emote = xi.emote.THINK },
                "Certain bats have been reportedly dropping bountiful sums of gil.",
                { delay = 3000 },
                "I've heard they collect anything gold and some have recently been sighted in Davoi.",
                { delay = 3000 },
                "If we sprinkle a pinch of sunsand...",
                " Maybe we can lure out one of these elusive creatures.",
                { emote = xi.emote.YES },
                { delay = 3000 },
                "Let's meet at the rendezvous point in Davoi.",
                "Then, we can catch one of these bats and share the spoils.",
                { emote = xi.emote.BOW },
            },
            PART3_REMINDER2 = { "Let's meet at the rendezvous point in Davoi." },
            PART3_FINISH =
            {
                "Excenmille left this in my hands for you.",
                "Though he seemed reluctant to do so, as if he feels I cannot be trusted.",
                { emote = xi.emote.SIGH },
                { delay = 3000 },
                "Yet, I only seek the truth and what is more trustworthy than that?",
            },
            PART3_AFTER  =
            {
                { emote = xi.emote.BOW },
                "Until we next meet.",
            },
        },
    },
    {
        id     = ANOMALY,
        name   = "Crystal Anomaly",
        marker = cq.MAIN_QUEST,
        area   = "La_Theine_Plateau",
        pos    = { 663.567, 28.191, -124.082, 0 }, --!pos 663 28.5 -126 102
        dialog =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            FINISH  = cutscene,
        },
    },
    {
        id     = "KEENA_1",
        name   = Keenajaques,
        type   = xi.objType.NPC,
        hidden = true,
        look   = keenalook,
        area   = "La_Theine_Plateau",
        pos    = { 659.424, 27.328, -123.800 }, --!pos 663 28.5 -126 102
    },
    {
        id     = "CURILLA",
        name   = Curilla,
        type   = xi.objType.NPC,
        hidden = true,
        look   = 69,
        area   = "La_Theine_Plateau",
        pos    = { 657.894, 26.945, -122.194, 0 }, --!pos 663 28.5 -126 102
    },
    {
        id          = WEAPON,
        name        = "Crystal Weapon",
        type        = xi.objType.MOB,
        look        = 451,
        groupId     = 7,
        groupZoneId = 126,
        level       = 13,
        area        = "La_Theine_Plateau",
        pos         = { 663.567, 28.191, -124.082, 0 }, --!pos 663 28.5 -126 102
    },

    -- For Part 2
    {
        id     = VERTU,
        name   = "Vertumaix",
        type   = xi.objType.NPC,
        look   = vertulook,
        area   = "Ordelles_Caves",
        pos    = { 16.723, -0.321, 570.058, 155 }, --!pos 16.723 -0.321 570.058 193
        dialog =
        {
            NAME    = true,
            DEFAULT =
            {
                { emote = xi.emote.THINK },
                "Sorry, but I am busy."
            },
            START   =
            {
                { emote = xi.emote.SHOCKED },
                "Look out!",
            },
            AFTER   =
            {
                "Phew that was close.",
                { delay = 1000 },
                "You are searching too?",
                { emote = xi.emote.WELCOME },
                " The heart can be seen in this bedrock.",
                { delay = 1000 },
                "May you reach the heart, and light it with your spirit.",
            },
            REMINDER = { "The heart can be seen in this bedrock." },
        }
    },
    {
        id          = BEDROCK,
        name        = "Bedrock",
        marker      = cq.SIDE_QUEST,
        area        = "Ordelles_Caves",
        pos         = { 15.126, -0.433, 571.622, 0 }, --!pos 16.723 -0.321 570.058 193
        dialog      =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            FOUND   =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion   = "takes a loose piece of bedrock." },
            },
        }
    },
    {
        id          = GOBLIN,
        name        = "Snoring Somatix",
        type        = xi.objType.MOB,
        look        = 485,
        groupId     = 15,
        groupZoneId = 193,
        area        = "Ordelles_Caves",
        pos         = { 19.160, 0.489, 565.382, 180 }, -- !pos 16.723 -0.321 570.058 193
        widescan    = 1,
        level       = 22,
    },
    {
        id     = "KEENA_2",
        name   = Keenajaques,
        type   = xi.objType.NPC,
        hidden = true,
        look   = keenalook,
        area   = "Davoi",
        pos    = { 54.450, -3.106, -188.909, 31 }, -- !pos 54.450 -3.106 -188.909 149
    },
    {
        id     = "EXCEN",
        name   = Excenmille,
        type   = xi.objType.NPC,
        hidden = true,
        look   = "0x0100020300103E203E303C403C50D16000700000",
        area   = "Davoi",
        pos    = { 64.119, -3.113, -191.605, 95 }, -- !pos 64.119 -3.113 -191.605 149
    },
    {
        id     = POINT,
        name   = "Rendezvous Point",
        marker = cq.MAIN_QUEST,
        area   = "Davoi",
        pos    = { 59.669, -2.201, -189.594, 65 }, -- !pos 59.669 -2.201 -189.594 149
        dialog =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            SPRINKLE =
            {
                { entity = "player", emote = xi.emote.TOSS },
                { delay  = 2000 },
            },
            CUTSCENE =
            {
                { despawn = { "Rendezvous Point" } },
                { music = 127 },
                { delay = 2000 },
                { spawn = { Keenajaques } },
                { delay = 3000 },
                { entity = Keenajaques, face = "player" },
                "Keenajaques : Now that you've defeated those monsters",
                " I hope that you will be able to begin to see past the deceptions that beset this world.",
                { delay = 3000 },
                { entity = Keenajaques, emote = xi.emote.YES },
                "Keenajaques : That is really all that I ask for.",
                { spawn = { Excenmille } },
                { delay = 2000 },
                { entity = Excenmille, face = Keenajaques },
                { delay = 3000 },
                { entity = Excenmille, emote = xi.emote.POINT },
                "Excenmille : I do not understand the circumstances I see before me, but there is one thing I must tell you, Keenajaques.",
                { entity = Keenajaques, face = Excenmille },
                { delay = 3000 },
                "Excenmille : A \"leader\" will put his own life at risk before those of his \"followers\"",
                " It may seem to you, adventurer, that I speak riddles, but take care to watch your steps.",
                { delay = 3000 },
                { entity = "Keenajaques", emote = xi.emote.HUH },
                "Keenajaques : We each have our own ways and places in this world.",
                { delay = 3000 },
                { entity = Excenmille, emote = xi.emote.NO },
                "Excenmille : So we do.",
                { despawn = { Keenajaques, Excenmille } },
                { delay = 3000 },
                { music = 0 },
                { spawn = { "Rendezvous Point" } },
            },
        }
    },

    {
        id          = "MIRRORS",
        name        = "Mujrah",
        type        = xi.objType.MOB,
        groupId     = 3,
        groupZoneId = 200,
        area        = "Davoi",
        pos         = { 64.119, -3.113, -191.605, 95 }, -- !pos 64.119 -3.113 -191.605 149
        level       = 45,
    },
    {
        id          = "SMOKE",
        name        = "Smukh",
        type        = xi.objType.MOB,
        groupId     = 3,
        groupZoneId = 200,
        area        = "Davoi",
        pos         = { 54.450, -3.106, -188.909, 31 }, -- !pos 54.450 -3.106 -188.909 149
        level       = 45,
    },
}

local step =
{
    {
        check     = cq.checks({ CW = true, level = 15 }),
        [KEENA]   = cq.talkStep("START", info.name),
    },
    {
        [KEENA]   = cq.talkOnly("REMINDER"),
        [ANOMALY] = cq.menuSpawn(WEAPON, "Investigate the anomaly?", { { "Not yet." }, { "I'm ready" } }, 2, true, { levelCap = 15 }),
        [WEAPON]  = cq.killStep(ANOMALY),
    },
    {
        [ANOMALY] = cq.talkStep("FINISH"),
    },
    {
        [ANOMALY] = cq.talkOnly("AFTER"),
        [KEENA]   = cq.giveStep("FINISH", info.reward, info.name, cexi.music.SANDORIA),
    },
    {
        check     = cq.checks({ CW = true, level = 25 }),
        [KEENA]   = cq.talkStep("PART2_START"),
    },
    {
        [KEENA]   = cq.menuStep("Agree to help?", { { "No" }, { "Yes", "PART2_ACCEPT" } }, 2, info.name .. " II"),
    },
    {
        [KEENA]   = cq.talkOnly("PART2_REMINDER"),
        [VERTU]   = cq.spawnMob(GOBLIN, "START", false),
        [GOBLIN]  = cq.killStep(),
    },
    {
        [VERTU]   = cq.talkStep("AFTER"),
    },
    {
        [VERTU]   = cq.talkOnly("REMINDER"),
        [BEDROCK] = cq.talkStep("FOUND"),
    },
    {
        [BEDROCK] = cq.talkOnly("AFTER"),
        [KEENA]   = cq.giveStep("PART2_FINISH", info.reward2, info.name .. " II", cexi.music.SANDORIA),
    },
    -- 10
    {
        check     = cq.checks({ CW = true, level = 40 }),
        [KEENA]   = cq.talkStep("PART3_START", info.name .. " III"),
    },
    {
        [KEENA]   =
        {
            onTrigger = cq.talkOnly("PART3_REMINDER"),
            onTrade   = cq.tradeStep("PART3_ACCEPTED", "PART3_REMINDER", info.required3.item),
        },
    },
    {
        [KEENA] = cq.talkOnly("PART3_REMINDER2"),
        [POINT] = cq.menuSpawn({ SMOKE, MIRRORS }, "Sprinkle the sunsand?", { { "Not yet." }, { "Here goes.", "SPRINKLE" } }, 2, true, { levelCap = 40 }),
        [SMOKE] =
        {
            onMobFight = cq.transform(50, 616, 47, 260, 189),
            onMobDeath = cq.killStep(POINT, { SMOKE, MIRRORS }, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "TRUST_SANDORIA_III" }),
        },
        [MIRRORS] =
        {
            onMobFight = cq.transform(50, 616, 47, 260, 189),
            onMobDeath = cq.killStep(POINT, { SMOKE, MIRRORS }, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "TRUST_SANDORIA_III" }),
        },
    },
    {
        [POINT] = cq.talkStep("CUTSCENE"),
    },
    {
        [POINT] = cq.talkOnly("AFTER"),
        [KEENA] = cq.giveStep("PART3_FINISH", info.reward3, info.name .. " III", cexi.music.SANDORIA),
    },
    {
        [KEENA] = cq.talkOnly("PART3_AFTER"),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
