-----------------------------------
-- Staying Afloat
-----------------------------------
-- !setvar [CW]STAYING_AFLOAT 0
-- Archimedes !pos -154.714 12.000 142.442 231
-- !additem 4504 12
-- Reward: 800 gil
-----------------------------------
-- !setvar [CW]STAYING_AFLOAT 1

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-staying_afloat")

local info =
{
    name   = "Staying Afloat",
    author = "Loxley",
    var    = "[CW]STAYING_AFLOAT",
    reward =
    {
        gil = 800,
    },

    required =
    {
        item = { { 4504, 12 } },
        name = "an acorn",
    },
}

local ARCHI      = "ARCHI"
local Archimedes = "Archimedes"

local entity =
{
    {
        id     = ARCHI,
        name   = Archimedes,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.ELVAAN_M,
            face = cexi.face.B8,
            head = cexi.model.AUSTERE_ROBE,
            body = cexi.model.TRADERS_SAIO,
            hand = cexi.model.TUNIC,
            legs = cexi.model.TUNIC,
            feet = cexi.model.TRADERS_SAIO,
        }),
        area   = "Northern_San_dOria",
        pos    = { -154.714, 12.000, 142.442, 128 }, -- !pos -154.714 12.000 142.442 231
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "I don't have anything for you." },
            START    =
            {
                "Greetings. I'm in need of acorns for a... a very important experiment.",
                { emote = xi.emote.THINK },
                "Gather twelve acorns and I'll make it worth your time.",
            },
            REMINDER = { "Gather twelve acorns and I'll make it worth your while." },
            ACCEPTED =
            {
                "Thank you. So far you've brought me %u acorns.",
                " Excuse me, one moment.",
                { entity = Archimedes, face = 128 },
                { delay = 2000 },
                { emote = xi.emote.TOSS },
                { delay = 3000 },
                "Fascinating...",
                { entity = Archimedes, face = "player" },
                "Here's your reward.",
            },
        },
    },
}

local step =
{
    {
        [ARCHI] = cq.talkStep("START", info.name),
    },
    {
        [ARCHI] =
        {
            onTrigger = cq.talkOnly("REMINDER"),
            onTrade   = cq.tradeOnly("ACCEPTED", "REMINDER", info.required.item, info.reward, "[CW]ACORNS", 12, info.name, cexi.music.SANDORIA),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
