-----------------------------------
-- Saving My Hide - Lizard Belt
-----------------------------------
-- !setvar [CQ]SAVING_MY_HIDE 0
-- Alutanie     !pos -199.759 -8.800 36.732 230
-- Tiger Tracks !pos 65.713 5.693 373.887 104
-----------------------------------
-- !setvar [CQ]SAVING_MY_HIDE 2

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_quest-saving_my_hide")

local helpers =
{
    {
        name     = "12 sheep leather",
        required = { { 850, 12 } },
        rewards  =
        {
            {
                name = "Leather Belt",
                item = 13192,
                augs =
                {
                    {   1, { 4, 9 }, }, -- HP  +5-10
                    {   9, { 2, 7 }, }, -- MP  +3-8
                    { 1, 9,  515, 0, }, -- HP +10, AGI +1
                },
            },
        },
    },
    {
        name     = "12 dhalmel leather",
        required = { { 848, 12 } },
        rewards  =
        {
            {
                name = "Leather Ring",
                item = 13469,
                augs =
                {
                    {   1, { 4, 9 }, }, -- HP  +5-10
                    {   9, { 4, 9 }, }, -- MP  +5-10
                    {  33,        2, }, -- DEF +3
                },
            },
        },
    },
    {
        name     = "12 ram leather",
        required = { { 851, 12 } },
        rewards  =
        {
            {
                name = "Ram Mantle",
                item = 13570,
                augs =
                {
                    {  33, { 1, 4 }, }, -- DEF: +2-5
                    {  39, { 0, 1 }, }, -- Enmity +1-2
                    {   1, 24, 39, 1 }, -- HP +25, Enmity +2
                },
            },
        },
    },
    {
        name     = "12 moblin sheep leather",
        required = { { 1862, 12 } },
        rewards  =
        {
            {
                name = "Jaridah Khud",
                item = 16063,
                augs =
                {
                    {  23, { 1, 4 }, }, -- Accuracy +2-5
                    { 513, { 1, 3 }, }, -- DEX +2-4
                    { 513, 3, 23, 4  }, -- DEX +4, Accuracy +5
                },
            },
        },
    },
    {
        name     = "12 tiger leather",
        required = { { 855, 12 } },
        rewards  =
        {
            {
                name = "Battle Boots",
                item = 12980,
                augs =
                {
                    { 513, { 0, 2 }, }, -- DEX +1-3
                    {  23, { 1, 4 }, }, -- Accuracy +2-5
                    {  23, 4, 49, 1, }, -- Accuracy +5, Haste +2%
                },
            },
        },
    },
    {
        name     = "12 coeurl leather",
        required = { { 506, 12 } },
        rewards  =
        {
            {
                name = "Coeurl Trousers",
                item = 12831,
                augs =
                {
                    {  25, { 2, 7 }, }, -- Attack   +3-8
                    {  23, { 2, 7 }, }, -- Accuracy +3-8
                    {  25, 7, 49, 1, }, -- Attack +8, Haste +2%
                },
            },
        },
    },
    {
        name     = "12 marid leather",
        required = { { 2152, 12 } },
        rewards  =
        {
            {
                name = "Marid Belt",
                item = 15890,
                augs =
                {
                    {  512, { 0, 2 }, }, -- STR      +1-3
                    {  25,  { 2, 7 }, }, -- Attack   +3-8
                    {  512, 2, 23, 9, }, -- STR +3, Accuracy +10
                },
            },
        },
    },
    {
        name     = "12 manticore leather",
        required = { { 1117, 12 } },
        rewards  =
        {
            {
                name = "Ogre Gloves",
                item = 13706,
                augs =
                {
                    {  25,  { 2, 7 }, }, -- Attack   +3-8
                    {  23,  { 2, 7 }, }, -- Accuracy +3-8
                    { 513,         8, }, -- DEX      +9
                },
            },
        },
    },
}

local info =
{
    name   = "Saving My Hide",
    author = "Loxley",
    var    = "[CQ]SAVING_MY_HIDE",
    reward =
    {
        item    = 13193,                   -- Lizard Belt (Lv17)
        augment = { 1, 4, 513, 1, 51, 0 }, -- HP +5, DEX +2, HP recovered while healing +1
    },
}

local ELVAAN   = "ELVAAN"
local Alutanie = "Alutanie"
local TIGER    = "TIGER"
local TRACKS   = "TRACKS"

local entity =
{
    {
        id     = ELVAAN,
        name   = Alutanie,
        type   = xi.objType.NPC,
        look   = cexi.util.look({
            race = xi.race.ELVAAN_F,
            face = cexi.face.B5,
            head = cexi.model.LEATHER_VEST,
            body = cexi.model.TIGER_JERKIN,
            hand = cexi.model.OGRE_JERKIN,
            legs = cexi.model.DUSK_JERKIN,
            feet = cexi.model.OGRE_JERKIN,
        }),
        area   = "Southern_San_dOria",
        pos    = { -199.759, -8.800, 36.732, 223 }, -- !pos -199.759 -8.800 36.732 230
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "Sorry, I'm quite busy at the moment." },
            START  =
            {
                { emote = xi.emote.BLUSH },
                "I'm behind on an order for a very important customer...",
                " And I'm missing one key material! ",
                { delay = 1000 },
                "Would you perhaps be heading to Jugner Forest?",
            },
            ACCEPTED =
            {
                { emote = xi.emote.BOW },
                "Thank you! I need a tiger hide but not just any tiger hide, mind you.",
                "I'll need the hide of an elusive Greater Tiger...",
                { delay = 1000 },
                "Maybe you can catch one as it comes to Lake Mechieume for water.",
            },
            REMINDER = { "Try to hunt down a Greater Tiger around Lake Mechieueme." },
            AFTER    =
            {
                { emote = xi.emote.THINK },
                "Thanks! Hmmm... Yes, this looks just right.",
                "Here's something for your trouble.",
            },

            -- Guild Helpers
            REQUEST  =
            {
                { emote = xi.emote.BOW },
                "Thanks for your help last time. I may need your assistance again...",
                { delay = 2000 },
                "I need %s for the latest guild order and we're all out of stock.",
                "If you get those for me, I'll give you a special piece I made earlier!",
            },
            RESULT   = { "Thank you! I can finally get to work. Here's your reward." },
            DECLINED = { "If you get %s for me, I'll give you a special piece I made earlier!" },
        },
    },
    {
        id     = TRACKS,
        name   = "Tiger Tracks",
        marker = cq.SIDE_QUEST,
        area   = "Jugner_Forest",
        pos    = { 65.713, 5.693, 373.887, 31 }, --!pos 65.713 5.693 373.887 104
        dialog =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            EXAMINE =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion = "collects the hide of the Greater Tiger." },
            },
        },
    },
    {
        id          = TIGER,
        name        = "Greater Tiger",
        type        = xi.objType.MOB,
        look        = 308,
        flags       = 135,
        groupId     = 16,
        groupZoneId = 104,
        area        = "Jugner_Forest",
        pos         = { 65.713, 5.693, 373.887, 31 }, --!pos 65.713 5.693 373.887 104
        widescan    = 1,
        level       = 23,
    },
}

local step =
{
    {
        check    = cq.checks({ level = 20 }),
        [ELVAAN] = cq.talkStep("START"),
    },
    {
        [ELVAAN] = cq.menuStep("Provide assistance?", { { "Hide." }, { "Accept.", "ACCEPTED" } }, 2, info.name),
    },
    {
        [ELVAAN] = cq.talkOnly("REMINDER"),
        [TRACKS] = cq.menuSpawn(TIGER, "Lie in wait?", { { "Not yet." }, { "I'm ready." } }, 2),
        [TIGER]  = cq.killStep(TRACKS),
    },
    {
        [TRACKS] = cq.talkStep("EXAMINE"),
    },
    {
        [TRACKS] = cq.talkOnly("AFTER"),
        [ELVAAN] = cq.giveStep("AFTER", info.reward, info.name, cexi.music.SANDORIA),
    },
    -- Guild Helpers
    {
        check    = cq.checks({ cooldown = "[CQ]HELPER_LC" }),
        [ELVAAN] =
        {
            onTrigger = cq.talkWeekly(helpers, "REQUEST"),
            onTrade   = cq.tradeWeekly(helpers, "[CQ]HELPER_LC", "RESULT", "DECLINED"),
        },
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
