-------------------------------------
-- Chasing the Light (Lv75) - Enlight Scroll
-------------------------------------
-- !setvar [CQ]CHASING_LIGHT 0
-- Megasolus      !pos 139.679 6.500 130.469 231
-- Thief's Tracks !pos -126.744 47.659 -338.394 176
-- Megasolus      !pos 139.679 6.500 130.469 231
-- Thief's Tracks !pos 106.980 -40.105 -432.377 289
-- Megasolus      !pos 139.679 6.500 130.469 231
-- Reward: Scroll of Enlight
-------------------------------------
-- !setvar [CQ]CHASING_LIGHT 6

require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("cw_chasing_light")

local info =
{
    name   = "Chasing the Light",
    author = "Carver",
    var    = "[CQ]CHASING_LIGHT",
    reward =
    {
        item    = 4706,  -- Scroll of Enlight (75)
    },
}

local MEGASOLUS      = "MEGASOLUS"
local THIEF_TRACKS   = "THIEF_TRACKS"
local THIEF_TRACKS_2 = "THIEF_TRACKS_2"
local NM_SPAWN       = "NM_SPAWN"
local GORGER         = "GORGER"

local entity =
{
    {
        id     = MEGASOLUS,
        name   = "Megasolus",
        type   = xi.objType.NPC,
        look   = 130,
        area   = "Northern_San_dOria",
        pos    = { 139.679, 6.500, 130.469, 223 }, -- !pos 139.679 6.500 130.469 231
        dialog =
        {
            NAME     = true,
            DEFAULT  = { "Altana, show us your path through the light..." },
            START    =
            {
                { emote = xi.emote.KNEEL },
                "Warrior of the Light, it's by Altana's will that we meet each other on this day.",
                " The cathedral is in dire need of your aide!",
                { delay = 2000 },
                "We've been victim to a pilfering thief by night...",
                " They have broken into the holy ark and stole the Light's Blessing!",
                { delay = 2000 },
                "The Royal Knights have tracked the thief to Sea Serpent Grotto in the Outlands.",
                { delay = 2000 },
                "The last report we received is that the thief snuck behind one of the doors.",
                " They said the door is inscribed with the imprint of a gold beastcoin.",
                "Please see what you can find out!",
                { emote = xi.emote.BOW },
            },
            STEP2    =
            {
                { emote = xi.emote.SHOCKED },
                "Whaat?! A crystal casing? The Light's Blessing has been removed",
                { delay = 1000 },
                "Wait. This insignia... Many years ago in Tavanazia I once saw these symbols.",
                "I dreamt that I gazed upon about a vortex in Misareaux Coast, that led to another realm.",
                " It was inside this realm that I saw those symbols.",
                { delay = 2000 },
                { emote = xi.emote.THINK },
                "I don't know what it means, but... maybe this clue can lead you to the thief.",
            },
            ACCEPTED  = { "Godspeed, adventurer. Please return here when you have gathered more information." },
            REMINDER  = { "Travel to Sea Serpent Grotto behind the gold beastcoin door and search for clues as to the thief's whereabouts." },
            REMINDER2 = { "I don't know the meaning of my Misareaux dream but... maybe this clue can lead you to the thief." },
            FINISH    =
            {
                { emote = xi.emote.SIGH },
                "The empty are descending on Vana'diel once again, this means we haven't seen the last of them.",
                " For now, the Blessing of Light is back with it's rightful owners.",
                { delay = 3000 },
                { emote = xi.emote.KNEEL },
                "Adventurer, on behalf of the entire King of San d'Oria, I can't begin to thank you enough.",
                " Take this as a token of our appreciate, I hope it shall aide you on your conquests.",
            },
        },
    },
    {
        id       = THIEF_TRACKS,
        name     = "Thief's Tracks",
        marker   = cq.SIDE_QUEST,
        area     = "Sea_Serpent_Grotto",
        pos      = { -126.744, 47.659, -338.394 }, -- !pos -126.744 47.659 -338.394 176
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            EXAMINE =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion = "examines the tracks and finds a crystal casing." },
            },
            AFTER = { "You must return to Megasolus and report your findings immediately!" },
        },
    },
    {
        id       = THIEF_TRACKS_2,
        name     = "Thief's Tracks",
        marker   = cq.SIDE_QUEST,
        area     = "Escha_RuAun",
        pos      = { -12.222, -34.000, -466.230 }, -- !pos -12.222 -34.000 -466.230 289
        dialog   =
        {
            DEFAULT = cq.NOTHING,
            EXAMINE =
            {
                { animation = 48, target = "player", duration = 3000 }, -- Crouch down
                { emotion = "examines the tracks closely and they seem to lead east." },
            },
            REMINDER = { "The tracks seem to lead east of here." },
        },
    },
    {
        id       = NM_SPAWN,
        name     = "Crystal Casing",
        marker   = cq.SIDE_QUEST,
        area     = "Escha_RuAun",
        pos      = { 106.980, -40.105, -432.377, 140 }, --!pos 106.980 -40.105 -432.377 289
        dialog   =
        {
            DEFAULT  = cq.NOTHING,
            REMINDER = { "You must return to Megasolus and report your findings immediately!" },
        },
    },
    {
        id          = GORGER,
        name        = "Eschan Gorger",
        type        = xi.objType.MOB,
        look        = 1131,
        area        = "Escha_RuAun",
        groupId     = 10,
        groupzoneId = 18,
        pos         = { 106.980, -40.105, -432.377, 140 }, --!pos 106.980 -40.105 -432.377 289
        level       = 77,
    },
}

local step =
{
    {
        check       = cq.checks({ level = 75 }),
        [MEGASOLUS] = cq.talkStep("START", info.name),
    },
    {
        [MEGASOLUS]    = cq.talkOnly("REMINDER"),
        [THIEF_TRACKS] = cq.menuStep("Examine the tracks?", { { "No" }, { "Yes", "EXAMINE" } }, 2),
    },
    {
        [THIEF_TRACKS] = cq.talkOnly("AFTER"),
        [MEGASOLUS]    = cq.talkStep("STEP2"),
    },
    {
        [MEGASOLUS]      = cq.talkOnly("REMINDER2"),
        [THIEF_TRACKS_2] = cq.menuStep("Examine the tracks?", { { "No" } , { "Yes", "EXAMINE" } }, 2),
    },
    {
        [THIEF_TRACKS_2] = cq.talkOnly("REMINDER"),
        [NM_SPAWN]       = cq.menuSpawn(GORGER, "You sense the presence of something nearby.", { { "Run Away?" }, { "Examine Further." } }, 2 ),
        [GORGER]         = cq.killStep(NM_SPAWN),
    },
    {
        [NM_SPAWN]  = cq.talkOnly("REMINDER"),
        [MEGASOLUS] = cq.giveStep("FINISH", info.reward, info.name, cexi.music.SANDORIA),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
